/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.compliance;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.ejb.EntityBean;
import weblogic.ejb.container.compliance.BeanClassChecker;
import weblogic.ejb.container.compliance.ComplianceException;
import weblogic.ejb.container.interfaces.BeanInfo;
import weblogic.ejb.container.interfaces.CMPInfo;
import weblogic.ejb.container.interfaces.ClientDrivenBeanInfo;
import weblogic.ejb.container.interfaces.EntityBeanInfo;
import weblogic.ejb20.dd.DescriptorErrorInfo;
import weblogic.utils.ErrorCollectionException;

abstract class EntityBeanClassChecker
extends BeanClassChecker {
    protected Class pkClass;
    protected boolean isBMP;
    protected EntityBeanInfo ebi = null;

    EntityBeanClassChecker(ClientDrivenBeanInfo clientDrivenBeanInfo) throws ClassNotFoundException {
        super(clientDrivenBeanInfo);
        this.beanClass = clientDrivenBeanInfo.getBeanClass();
        this.beanClassMod = this.beanClass.getModifiers();
        this.beanInfo = clientDrivenBeanInfo;
        this.ejbName = this.beanInfo.getEJBName();
        this.ebi = (EntityBeanInfo)clientDrivenBeanInfo;
        this.pkClass = this.ebi.getPrimaryKeyClass();
        this.isBMP = this.ebi.getIsBeanManagedPersistence();
    }

    protected List getPostCreateMethods() {
        Method[] methodArray = this.beanClass.getMethods();
        ArrayList<Method> arrayList = new ArrayList<Method>();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().startsWith("ejbPostCreate")) continue;
            arrayList.add(methodArray[i]);
        }
        return arrayList;
    }

    protected List getFinderMethods() {
        Method[] methodArray = this.beanClass.getMethods();
        ArrayList<Method> arrayList = new ArrayList<Method>();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().startsWith("ejbFind")) continue;
            arrayList.add(methodArray[i]);
        }
        return arrayList;
    }

    public void doCheckCreatesMatchPostCreates(String string) throws ErrorCollectionException {
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        List list = this.getCreateMethods();
        HashSet hashSet = new HashSet(this.getPostCreateMethods());
        for (Method method : list) {
            try {
                String string2 = "ejbPostC" + method.getName().substring(4);
                Method method2 = this.beanClass.getMethod(string2, method.getParameterTypes());
                hashSet.remove(method2);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                errorCollectionException.add((Throwable)new ComplianceException(this.fmt.CREATES_MATCH_POSTCREATE(this.ejbName, this.methodSig(method))));
            }
        }
        for (Method method : hashSet) {
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.EXTRA_POSTCREATE(this.ejbName, this.methodSig(method))));
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    public void checkEjbCreateMethods() throws ErrorCollectionException {
        List list = this.getCreateMethods();
        if (list.size() != 0) {
            this.validateEjbCreates(list);
        }
    }

    public void doCheckBeanClassImplementsEntityBean(String string) throws ComplianceException {
        if (!EntityBean.class.isAssignableFrom(this.beanClass)) {
            throw new ComplianceException(this.fmt.MUST_IMPLEMENT_ENTITYBEAN(this.ejbName));
        }
    }

    protected void validateCreateReturnType(Method method, String string) throws ComplianceException {
        if (!method.getReturnType().isAssignableFrom(this.pkClass)) {
            throw new ComplianceException(this.fmt.EJBCREATE_RETURNS_PK(this.ejbName, this.methodSig(method)));
        }
    }

    public void doCheckPostCreates(String string) throws ErrorCollectionException {
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        Method[] methodArray = this.beanClass.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            if (!method.getName().startsWith("ejbPostCreate")) continue;
            int n = method.getModifiers();
            if (!Modifier.isPublic(n)) {
                errorCollectionException.add((Throwable)new ComplianceException(this.fmt.EJBPOSTCREATE_MUST_BE_PUBLIC(this.ejbName, this.methodSig(method))));
            }
            if (Modifier.isFinal(n)) {
                errorCollectionException.add((Throwable)new ComplianceException(this.fmt.EJBPOSTCREATE_MUST_NOT_BE_FINAL(this.ejbName, this.methodSig(method))));
            }
            if (Modifier.isStatic(n)) {
                errorCollectionException.add((Throwable)new ComplianceException(this.fmt.EJBPOSTCREATE_MUST_NOT_BE_STATIC(this.ejbName, this.methodSig(method))));
            }
            if (Void.TYPE.isAssignableFrom(method.getReturnType())) continue;
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.EJBPOSTCREATE_MUST_RETURN_VOID(this.ejbName, this.methodSig(method))));
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    public void doCheckCMPBeanDoesntDefineFinders(String string, boolean bl) throws ErrorCollectionException {
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        if (this.isBMP) {
            return;
        }
        List list = this.getFinderMethods();
        if (list.size() != 0) {
            for (Method method : list) {
                boolean bl2;
                if (bl && (bl2 = Modifier.isAbstract(method.getModifiers()))) continue;
                errorCollectionException.add((Throwable)new ComplianceException(this.fmt.FINDER_IN_CMP_BEAN(this.ejbName, this.methodSig(method))));
            }
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    public void doCheckCMPBeanHasPersistenceUse() throws ErrorCollectionException {
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        if (this.isBMP) {
            return;
        }
        CMPInfo cMPInfo = this.ebi.getCMPInfo();
        if (cMPInfo.getPersistenceUseIdentifier() == null) {
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.BEAN_MISSING_PERSISTENCE_USE(this.ejbName)));
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    public void doCheckPrimkeyFieldIsCMPField(String string) throws ComplianceException {
        CMPInfo cMPInfo;
        String string2;
        if (!this.isBMP && (string2 = (cMPInfo = this.ebi.getCMPInfo()).getCMPrimaryKeyFieldName()) != null && !cMPInfo.getAllContainerManagedFieldNames().contains(string2)) {
            throw new ComplianceException(this.fmt.PRIMKEY_FIELD_MUST_BE_CMP_FIELD(this.ejbName), new DescriptorErrorInfo("<cmp-field>", (Object)this.ejbName, (Object)string2));
        }
    }

    public void doCheckPrimaryKeyClassFieldsAreCMPFields(String string) throws ComplianceException {
        CMPInfo cMPInfo;
        if (!this.isBMP && (cMPInfo = this.ebi.getCMPInfo()).getCMPrimaryKeyFieldName() == null) {
            Collection collection = cMPInfo.getAllContainerManagedFieldNames();
            Field[] fieldArray = this.pkClass.getFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                Field field = fieldArray[i];
                String string2 = field.getName();
                if (string2.equals("serialVersionUID") || collection.contains(string2)) continue;
                throw new ComplianceException(this.fmt.PK_FIELDS_MUST_BE_CMP_FIELDS(this.ejbName, field.getName()), new DescriptorErrorInfo("<cmp-field>", (Object)this.ejbName, (Object)field.getName()));
            }
        }
    }

    public void checkConcurrencyDatabaseAndCacheBetweenTransactionsMatch() {
        if (this.ebi.getConcurrencyStrategy() == 2 && this.ebi.getCacheBetweenTransactions()) {
            log.logWarning(this.fmt.CACHE_BETWEEN_TRANS_MUST_BE_FALSE_FOR_CONCURRENCY_DB(this.ejbName));
        }
    }

    public void checkInvalidationTarget() throws ComplianceException {
        String string = this.ebi.getInvalidationTargetEJBName();
        if (string == null) {
            return;
        }
        BeanInfo beanInfo = this.ebi.getDeploymentInfo().getBeanInfo(string);
        if (beanInfo == null) {
            throw new ComplianceException(this.fmt.INVALIDATION_TARGET_DOES_NOT_EXIST(this.ejbName, string), new DescriptorErrorInfo("<invalidation-target>", (Object)this.ejbName, (Object)string));
        }
        if (!(beanInfo instanceof EntityBeanInfo)) {
            throw new ComplianceException(this.fmt.INVALIDATION_TARGET_MUST_BE_RO_ENTITY(this.ejbName, string), new DescriptorErrorInfo("<invalidation-target>", (Object)this.ejbName, (Object)string));
        }
        if (((EntityBeanInfo)beanInfo).getConcurrencyStrategy() != 5) {
            throw new ComplianceException(this.fmt.INVALIDATION_TARGET_MUST_BE_RO_ENTITY(this.ejbName, string), new DescriptorErrorInfo("<invalidation-target>", (Object)this.ejbName, (Object)string));
        }
        if (this.ebi.getConcurrencyStrategy() == 5) {
            throw new ComplianceException(this.fmt.INVALIDATION_TARGET_CANNOT_BE_SET_FOR_RO_ENTITY(this.ejbName), new DescriptorErrorInfo("<invalidation-target>", (Object)this.ejbName, (Object)string));
        }
        if (this.ebi.getIsBeanManagedPersistence() || !this.ebi.getCMPInfo().uses20CMP()) {
            throw new ComplianceException(this.fmt.INVALIDATION_TARGET_MUST_BE_SET_ON_CMP20(this.ejbName), new DescriptorErrorInfo("<invalidation-target>", (Object)this.ejbName, (Object)string));
        }
    }
}

