/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.compliance;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.ejb.FinderException;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.compliance.ComplianceException;
import weblogic.ejb.container.compliance.ComplianceUtils;
import weblogic.ejb.container.compliance.EJBComplianceTextFormatter;
import weblogic.ejb.container.compliance.ExceptionTypeMismatchException;
import weblogic.ejb.container.compliance.HomeInterfaceChecker;
import weblogic.ejb.container.dd.xml.DDUtils;
import weblogic.ejb.container.interfaces.CMPInfo;
import weblogic.ejb.container.interfaces.ClientDrivenBeanInfo;
import weblogic.ejb.container.interfaces.EntityBeanInfo;
import weblogic.ejb.container.utils.ClassUtils;
import weblogic.i18n.Localizer;
import weblogic.i18ntools.L10nLookup;
import weblogic.utils.Debug;
import weblogic.utils.ErrorCollectionException;

class EntityHomeInterfaceChecker
extends HomeInterfaceChecker {
    static final String EJB_HOME = "ejbHome";
    private Class pkClass;
    private EntityBeanInfo ebi;
    private boolean isCMP = false;
    private boolean isCMP20 = false;
    private static Localizer l10n = L10nLookup.getLocalizer((Locale)Locale.getDefault(), (String)"weblogic.ejb.container.compliance.EJBComplianceTextLocalizer");

    EntityHomeInterfaceChecker(Class clazz, Class clazz2, Class clazz3, ClientDrivenBeanInfo clientDrivenBeanInfo, Class clazz4) throws ClassNotFoundException {
        super(clazz, clazz2, clazz3, clientDrivenBeanInfo, clazz4);
        this.ebi = (EntityBeanInfo)clientDrivenBeanInfo;
        this.pkClass = this.ebi.getPrimaryKeyClass();
        CMPInfo cMPInfo = this.ebi.getCMPInfo();
        if (cMPInfo != null) {
            this.isCMP = true;
            this.isCMP20 = cMPInfo.uses20CMP();
        }
    }

    public void checkHomeContainsFindByPK() throws ComplianceException {
        Method[] methodArray = this.homeInterface.getMethods();
        Method method = null;
        for (int i = 0; i < methodArray.length; ++i) {
            if (!"findByPrimaryKey".equals(methodArray[i].getName())) continue;
            method = methodArray[i];
            break;
        }
        if (method == null) {
            if (this.checkingRemoteClientView()) {
                throw new ComplianceException(this.fmt.HOME_MUST_HAVE_FIND_PK(this.ejbName));
            }
            throw new ComplianceException(this.fmt.LOCAL_HOME_MUST_HAVE_FIND_PK(this.ejbName));
        }
        Class<?> clazz = method.getReturnType();
        if (!clazz.equals(this.compInterface)) {
            if (this.checkingRemoteClientView()) {
                throw new ComplianceException(this.fmt.FIND_BY_PK_RETURNS_REMOTE_INTF(this.ejbName));
            }
            throw new ComplianceException(this.fmt.FIND_BY_PK_RETURNS_LOCAL_INTF(this.ejbName));
        }
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length != 1 || !classArray[0].equals(Object.class) && !classArray[0].equals(this.pkClass)) {
            if (this.checkingRemoteClientView()) {
                throw new ComplianceException(this.fmt.HOME_FIND_PK_CORRECT_PARAMETERS(this.ejbName, this.methodSig(method)));
            }
            throw new ComplianceException(this.fmt.LOCAL_HOME_FIND_PK_CORRECT_PARAMETERS(this.ejbName, this.methodSig(method)));
        }
    }

    public void checkFindThrowsFinderException() throws ErrorCollectionException {
        Iterator iterator = ClassUtils.getFinderMethods(this.homeInterface);
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        while (iterator.hasNext()) {
            Method method = (Method)iterator.next();
            if (ComplianceUtils.methodThrowsException(method, FinderException.class)) continue;
            if (this.checkingRemoteClientView()) {
                errorCollectionException.add((Throwable)new ComplianceException(this.fmt.FINDER_MUST_THROW_FE(this.ejbName, this.methodSig(method))));
                continue;
            }
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.LOCAL_FINDER_MUST_THROW_FE(this.ejbName, this.methodSig(method))));
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    private boolean goodFinderReturn(Class clazz) {
        if (clazz.equals(this.compInterface)) {
            return true;
        }
        if (!this.isCMP20 && Enumeration.class.isAssignableFrom(clazz)) {
            return true;
        }
        Class<Collection> clazz2 = Collection.class;
        return clazz2.equals((Object)clazz);
    }

    public void checkFinderReturnsRemoteOrCollection() throws ErrorCollectionException {
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        Iterator iterator = ClassUtils.getFinderMethods(this.homeInterface);
        while (iterator.hasNext()) {
            Method method = (Method)iterator.next();
            Class<?> clazz = method.getReturnType();
            if (this.goodFinderReturn(clazz)) continue;
            if (this.checkingRemoteClientView()) {
                errorCollectionException.add((Throwable)new ComplianceException(this.fmt.FINDER_RETURNS_BAD_TYPE(this.ejbName, this.methodSig(method))));
                continue;
            }
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.LOCAL_FINDER_RETURNS_BAD_TYPE(this.ejbName, this.methodSig(method))));
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    private String beanFindName(String string) {
        Debug.assertion((boolean)string.startsWith("find"));
        return "ejbF" + string.substring(1);
    }

    public void checkFindMethodsMatchBeanMethods() throws ErrorCollectionException {
        if (!this.ebi.getIsBeanManagedPersistence()) {
            return;
        }
        Iterator iterator = ClassUtils.getFinderMethods(this.homeInterface);
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        while (iterator.hasNext()) {
            Method method = (Method)iterator.next();
            try {
                Method method2 = this.beanClass.getMethod(this.beanFindName(method.getName()), method.getParameterTypes());
                ComplianceUtils.exceptionTypesMatch(method, method2);
                Class<?> clazz = method2.getReturnType();
                Class<?> clazz2 = method.getReturnType();
                if (clazz.equals(this.pkClass)) {
                    if (clazz2.equals(this.compInterface)) continue;
                    if (this.checkingRemoteClientView()) {
                        errorCollectionException.add((Throwable)new ComplianceException(this.fmt.SCALAR_FINDER_DOESNT_RETURN_REMOTE_INTF(this.ejbName, this.methodSig(method))));
                        continue;
                    }
                    errorCollectionException.add((Throwable)new ComplianceException(this.fmt.SCALAR_FINDER_DOESNT_RETURN_LOCAL_INTF(this.ejbName, this.methodSig(method))));
                    continue;
                }
                if (clazz.equals(Enumeration.class)) {
                    if (clazz2.equals(Enumeration.class)) continue;
                    errorCollectionException.add((Throwable)new ComplianceException(this.fmt.ENUM_FINDER_DOESNT_RETURN_REMOTE_INTF(this.ejbName, this.methodSig(method))));
                    continue;
                }
                if (clazz.equals(Collection.class)) {
                    if (clazz2.equals(Collection.class)) continue;
                    if (this.checkingRemoteClientView()) {
                        errorCollectionException.add((Throwable)new ComplianceException(this.fmt.COLL_FINDER_DOESNT_RETURN_COLL(this.ejbName, this.methodSig(method))));
                        continue;
                    }
                    errorCollectionException.add((Throwable)new ComplianceException(this.fmt.LOCAL_COLL_FINDER_DOESNT_RETURN_COLL(this.ejbName, this.methodSig(method))));
                    continue;
                }
                errorCollectionException.add((Throwable)new ComplianceException(this.fmt.UNEXPECTED_FINDER_RETURN_TYPE(this.ejbName, this.methodSig(method2))));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                errorCollectionException.add((Throwable)new ComplianceException(this.fmt.FIND_METHOD_DOESNT_EXIST_IN_BEAN(this.ejbName, this.methodSig(method))));
            }
            catch (ExceptionTypeMismatchException exceptionTypeMismatchException) {
                if (this.checkingRemoteClientView()) {
                    errorCollectionException.add((Throwable)new ComplianceException(this.fmt.FIND_EXCEPTION_TYPE_DOESNT_MATCH_BEAN(this.ejbName, this.methodSig(method))));
                    continue;
                }
                errorCollectionException.add((Throwable)new ComplianceException(this.fmt.LOCAL_FIND_EXCEPTION_TYPE_DOESNT_MATCH_BEAN(this.ejbName, this.methodSig(method))));
            }
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    public void checkCreateMethodsMatchBeanPostCreateMethods() throws ErrorCollectionException {
        List list = this.getCreateMethods();
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        for (Method method : list) {
            try {
                String string = "ejbPostC" + method.getName().substring(1);
                Method method2 = this.beanClass.getMethod(string, method.getParameterTypes());
                ComplianceUtils.exceptionTypesMatch(method, method2);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                errorCollectionException.add((Throwable)new ComplianceException(this.fmt.POST_CREATE_METHOD_DOESNT_EXIST_IN_BEAN(this.ejbName, this.methodSig(method))));
            }
            catch (ExceptionTypeMismatchException exceptionTypeMismatchException) {
                errorCollectionException.add((Throwable)new ComplianceException(this.fmt.POST_CREATE_EXCEPTION_TYPE_DOESNT_MATCH_BEAN(this.ejbName, this.methodSig(method))));
            }
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    public void checkForExtraMethodsInHomeInterface() throws ErrorCollectionException {
        Method method;
        Vector vector = new Vector();
        Vector<Method> vector2 = new Vector<Method>();
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        Method[] methodArray = this.homeInterface.getMethods();
        this.computeBeanHomeMethods(errorCollectionException, vector);
        for (int i = 0; i < methodArray.length; ++i) {
            method = methodArray[i];
            String string = method.getName();
            try {
                this.ejbHomeInterface.getMethod(string, method.getParameterTypes());
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                boolean bl;
                boolean bl2 = bl = string.startsWith("create") || string.startsWith("find");
                if (bl || string.equals("<clinit>")) continue;
                vector2.addElement(method);
            }
        }
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            method = (Method)enumeration.nextElement();
            if (vector.contains(method)) continue;
            if (this.checkingRemoteClientView()) {
                errorCollectionException.add((Throwable)new ComplianceException(this.fmt.EXTRA_HOME_METHOD_20(this.ejbName, this.methodSig(method), DDUtils.getEjbHomeMethodSignature(method))));
                continue;
            }
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.EXTRA_LOCAL_HOME_METHOD_20(this.ejbName, this.methodSig(method), DDUtils.getEjbHomeMethodSignature(method))));
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    public void computeBeanHomeMethods(ErrorCollectionException errorCollectionException, Vector vector) throws ErrorCollectionException {
        Method[] methodArray = this.beanClass.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            String string = methodArray[i].getName();
            if (!string.startsWith(EJB_HOME)) continue;
            if (string.length() <= EJB_HOME.length()) {
                errorCollectionException.add((Throwable)new ComplianceException(this.fmt.HOME_METHOD_NAME_IN_BEAN_CLASS_INCOMPLETE_20(this.beanClass.getName())));
                continue;
            }
            this.beanClassHomeMethodNameCheck(this.beanClass, string, errorCollectionException);
            boolean bl = false;
            try {
                bl = this.isValidHomeMethod(string, methodArray[i].getParameterTypes(), methodArray[i].getReturnType(), this.homeInterface, this.beanClass);
            }
            catch (Exception exception) {
                bl = true;
                errorCollectionException.add((Throwable)exception);
            }
            if (!bl) continue;
            try {
                String string2 = string.substring(EJB_HOME.length());
                string2 = Character.toLowerCase(string2.charAt(0)) + string2.substring(1);
                Method method = this.homeInterface.getMethod(string2, methodArray[i].getParameterTypes());
                vector.addElement(method);
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                EJBLogger.logStackTrace((Throwable)noSuchMethodException);
            }
        }
    }

    public boolean isValidHomeMethod(String string, Class[] classArray, Class clazz, Class clazz2, Class clazz3) throws Exception {
        boolean bl = false;
        try {
            String string2 = string.substring(EJB_HOME.length());
            string2 = Character.toLowerCase(string2.charAt(0)) + string2.substring(1);
            Method method = clazz2.getMethod(string2, classArray);
            Class<?> clazz4 = method.getReturnType();
            if (!clazz.equals(clazz4)) {
                EJBComplianceTextFormatter eJBComplianceTextFormatter = new EJBComplianceTextFormatter();
                if (this.checkingRemoteClientView()) {
                    throw new Exception(eJBComplianceTextFormatter.EJB_HOME_METHOD_RETURN_TYPE_SHOULD_MATCH(this.ejbName, clazz2.getName(), string2, clazz4.getName(), clazz3.getName(), clazz.getName(), "remote"));
                }
                throw new Exception(eJBComplianceTextFormatter.EJB_HOME_METHOD_RETURN_TYPE_SHOULD_MATCH(this.ejbName, clazz2.getName(), string2, clazz4.getName(), clazz3.getName(), clazz.getName(), "local"));
            }
            bl = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return bl;
    }

    public void beanClassHomeMethodNameCheck(Class clazz, String string, ErrorCollectionException errorCollectionException) {
        String string2 = string.substring(EJB_HOME.length());
        if (Character.isLowerCase(string2.charAt(0))) {
            StringBuffer stringBuffer = new StringBuffer(EJB_HOME);
            stringBuffer.append(Character.toUpperCase(string2.charAt(0)));
            if (string2.length() > 1) {
                stringBuffer.append(string2.substring(1));
            }
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.HOME_METHOD_NAME_IN_BEAN_CLASS_LOWER_CASE_20(clazz.getName(), string, stringBuffer.toString())));
        }
    }

    private static void p(String string) {
        System.out.println(l10n.get("entityhomeInterfaceCheckerMessage") + string);
    }
}

