/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.compliance;

import java.util.Collection;
import java.util.Map;
import weblogic.ejb.container.compliance.BaseComplianceChecker;
import weblogic.ejb.container.compliance.ComplianceException;
import weblogic.ejb.container.interfaces.BeanInfo;
import weblogic.ejb.container.interfaces.ClientDrivenBeanInfo;
import weblogic.ejb.container.interfaces.DeploymentInfo;
import weblogic.j2ee.descriptor.EjbLocalRefBean;
import weblogic.j2ee.descriptor.EjbRefBean;
import weblogic.j2ee.descriptor.EnvEntryBean;
import weblogic.j2ee.descriptor.MessageDestinationRefBean;
import weblogic.utils.ErrorCollectionException;

public final class EnvironmentValuesChecker
extends BaseComplianceChecker {
    private static final boolean debug = false;
    private static final boolean verbose = false;
    private DeploymentInfo di;

    public EnvironmentValuesChecker(DeploymentInfo deploymentInfo) {
        this.di = deploymentInfo;
    }

    public void checkEnvironmentValues() throws ErrorCollectionException {
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        Collection collection = this.di.getBeanInfos();
        for (BeanInfo beanInfo : collection) {
            this.checkEnvEntries(beanInfo, errorCollectionException);
            this.checkMessageDestinationRefs(beanInfo, errorCollectionException);
            this.checkEjbRefs(beanInfo, errorCollectionException);
            this.checkEjbLocalRefs(beanInfo, errorCollectionException);
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    private void checkEjbRefs(BeanInfo beanInfo, ErrorCollectionException errorCollectionException) {
        if (beanInfo.isEJB30()) {
            return;
        }
        Map map = beanInfo.getAllEJBReferenceJNDINames();
        for (EjbRefBean ejbRefBean : beanInfo.getAllEJBReferences()) {
            if (!map.containsKey(ejbRefBean.getEjbRefName())) {
                String string = ejbRefBean.getEjbLink();
                if (string == null) {
                    errorCollectionException.add((Throwable)new ComplianceException(this.fmt.EJB_REF_MUST_HAVE_EJB_LINK_OR_REF_DESC(beanInfo.getEJBName(), ejbRefBean.getEjbRefName())));
                } else {
                    BeanInfo beanInfo2 = this.di.getBeanInfo(string);
                    if (beanInfo2 != null && !(beanInfo2 instanceof ClientDrivenBeanInfo)) {
                        errorCollectionException.add((Throwable)new ComplianceException(this.fmt.ILLEGAL_LOCAL_EJB_LINK_TO_MDB(beanInfo.getEJBName(), ejbRefBean.getEjbRefName())));
                    }
                }
            }
            if (ejbRefBean.getHome() != null || ejbRefBean.getRemote() != null) continue;
            errorCollectionException.add((Throwable)new ComplianceException("The ejb-ref " + ejbRefBean.getEjbRefName() + " does not have a home or remote interface configured."));
        }
    }

    private void checkEjbLocalRefs(BeanInfo beanInfo, ErrorCollectionException errorCollectionException) {
        if (beanInfo.isEJB30()) {
            return;
        }
        Map map = beanInfo.getAllEJBLocalReferenceJNDINames();
        for (EjbLocalRefBean ejbLocalRefBean : beanInfo.getAllEJBLocalReferences()) {
            if (!map.containsKey(ejbLocalRefBean.getEjbRefName())) {
                String string = ejbLocalRefBean.getEjbLink();
                if (string == null) {
                    errorCollectionException.add((Throwable)new ComplianceException(this.fmt.EJB_REF_MUST_HAVE_EJB_LINK_OR_REF_DESC(beanInfo.getEJBName(), ejbLocalRefBean.getEjbRefName())));
                } else {
                    BeanInfo beanInfo2 = this.di.getBeanInfo(string);
                    if (beanInfo2 != null && !(beanInfo2 instanceof ClientDrivenBeanInfo)) {
                        errorCollectionException.add((Throwable)new ComplianceException(this.fmt.ILLEGAL_LOCAL_EJB_LINK_TO_MDB(beanInfo.getEJBName(), ejbLocalRefBean.getEjbRefName())));
                    }
                }
            }
            if (ejbLocalRefBean.getLocalHome() != null || ejbLocalRefBean.getLocal() != null) continue;
            errorCollectionException.add((Throwable)new ComplianceException("The ejb-local-ref " + ejbLocalRefBean.getEjbRefName() + " does not have a local-home or local interface configured."));
        }
    }

    private void checkMessageDestinationRefs(BeanInfo beanInfo, ErrorCollectionException errorCollectionException) {
        if (beanInfo.isEJB30()) {
            return;
        }
        Collection collection = beanInfo.getAllMessageDestinationReferences();
        for (MessageDestinationRefBean messageDestinationRefBean : collection) {
            if (messageDestinationRefBean.getMessageDestinationLink() != null) continue;
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.MESSAGE_DESTINATION_REF_NOT_LINKED(messageDestinationRefBean.getMessageDestinationRefName(), beanInfo.getEJBName())));
        }
    }

    private void checkEnvEntries(BeanInfo beanInfo, ErrorCollectionException errorCollectionException) {
        if (beanInfo.isEJB30()) {
            return;
        }
        Collection collection = beanInfo.getAllEnvironmentEntries();
        for (EnvEntryBean envEntryBean : collection) {
            String string = envEntryBean.getEnvEntryType();
            String string2 = envEntryBean.getEnvEntryValue();
            if ("java.lang.String".equals(string) || string2 != null && string2.trim().length() != 0) continue;
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.ENV_VALUE_CANNOT_BE_NULL(envEntryBean.getEnvEntryName())));
        }
    }
}

