/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.compliance;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import weblogic.ejb.container.compliance.BaseComplianceChecker;
import weblogic.ejb.container.compliance.ComplianceException;
import weblogic.ejb.container.interfaces.DeploymentInfo;
import weblogic.ejb.container.persistence.spi.CmrField;
import weblogic.ejb.container.persistence.spi.EjbRelation;
import weblogic.ejb.container.persistence.spi.EjbRelationshipRole;
import weblogic.ejb.container.persistence.spi.Relationships;
import weblogic.ejb.container.persistence.spi.RoleSource;
import weblogic.ejb20.dd.DescriptorErrorInfo;
import weblogic.utils.Debug;
import weblogic.utils.ErrorCollectionException;

public final class GlobalRelationsChecker
extends BaseComplianceChecker {
    private static final boolean debug = System.getProperty("weblogic.ejb.container.persistence.debug") != null;
    private static final boolean verbose = System.getProperty("weblogic.ejb.container.persistence.verbose") != null;
    private EjbRelation rel;
    private EjbRelationshipRole role1;
    private EjbRelationshipRole role2;
    private RoleSource src1;
    private RoleSource src2;
    private CmrField field1;
    private CmrField field2;
    private Relationships relationships;
    private DeploymentInfo di;

    public GlobalRelationsChecker(DeploymentInfo deploymentInfo) {
        this.di = deploymentInfo;
        this.relationships = deploymentInfo.getRelationships();
    }

    public void checkRelations() throws ErrorCollectionException {
        this.checkNoDupCmrFields();
    }

    private void checkNoDupCmrFields() throws ErrorCollectionException {
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        HashMap hashMap = new HashMap();
        for (EjbRelation this.rel : this.relationships.getAllEjbRelations().values()) {
            if (verbose) {
                Debug.say((String)("constructed RelationChecker for: " + this.rel.getEjbRelationName()));
            }
            Iterator iterator = this.rel.getAllEjbRelationshipRoles().iterator();
            this.role1 = (EjbRelationshipRole)iterator.next();
            this.role2 = (EjbRelationshipRole)iterator.next();
            this.src1 = this.role1.getRoleSource();
            this.src2 = this.role2.getRoleSource();
            this.field1 = this.role1.getCmrField();
            this.field2 = this.role2.getCmrField();
            this.dupCMRCheck(hashMap, this.src1, this.field1, errorCollectionException);
            if (this.isSymmetric(this.src1, this.field1, this.src2, this.field2)) continue;
            this.dupCMRCheck(hashMap, this.src2, this.field2, errorCollectionException);
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    private void dupCMRCheck(Map map, RoleSource roleSource, CmrField cmrField, ErrorCollectionException errorCollectionException) {
        if (cmrField == null) {
            return;
        }
        String string = this.getEncodedName(roleSource);
        String string2 = cmrField.getName();
        if (map.containsKey(string)) {
            Set set = (Set)map.get(string);
            if (set.contains(string2)) {
                errorCollectionException.add((Throwable)new ComplianceException(this.fmt.DUPLICATE_CMR_FIELD(this.rel.getEjbRelationName() + " <relationship-role-source>: " + roleSource.getEjbName() + " <cmr-field>: " + string2), new DescriptorErrorInfo("<relationship-role-source>", (Object)this.rel.getEjbRelationName(), (Object)roleSource.getEjbName())));
            } else {
                set.add(string2);
            }
        } else {
            HashSet<String> hashSet = new HashSet<String>();
            map.put(string, hashSet);
            hashSet.add(string2);
        }
    }

    private String getEncodedName(RoleSource roleSource) {
        return "EJBNAME_" + roleSource.getEjbName();
    }

    private boolean isSymmetric(RoleSource roleSource, CmrField cmrField, RoleSource roleSource2, CmrField cmrField2) {
        boolean bl;
        boolean bl2 = bl = cmrField != null && cmrField2 != null;
        return roleSource.getEjbName().equals(roleSource2.getEjbName()) && bl && cmrField.getName().equals(cmrField2.getName());
    }
}

