/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.compliance;

import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import weblogic.ejb.container.compliance.BaseComplianceChecker;
import weblogic.ejb.container.compliance.ComplianceException;
import weblogic.ejb.container.compliance.ComplianceUtils;
import weblogic.ejb.container.compliance.ExceptionTypeMismatchException;
import weblogic.ejb.container.interfaces.ClientDrivenBeanInfo;
import weblogic.ejb.container.interfaces.Ejb3SessionBeanInfo;
import weblogic.ejb.container.interfaces.EntityBeanInfo;
import weblogic.utils.ErrorCollectionException;

abstract class HomeInterfaceChecker
extends BaseComplianceChecker {
    protected Class homeInterface;
    protected Class compInterface;
    protected Class beanClass;
    private boolean isEntityBean;
    protected String ejbName;
    protected Class ejbHomeInterface;
    private ClientDrivenBeanInfo cbi;

    HomeInterfaceChecker(Class clazz, Class clazz2, Class clazz3, ClientDrivenBeanInfo clientDrivenBeanInfo, Class clazz4) {
        this.homeInterface = clazz;
        this.compInterface = clazz2;
        this.beanClass = clazz3;
        this.isEntityBean = clientDrivenBeanInfo instanceof EntityBeanInfo;
        this.ejbName = clientDrivenBeanInfo.getEJBName();
        this.ejbHomeInterface = clazz4;
        this.cbi = clientDrivenBeanInfo;
    }

    protected String section(String string, String string2) {
        return this.isEntityBean ? string2 : string;
    }

    protected List getCreateMethods() {
        Method[] methodArray = this.homeInterface.getMethods();
        ArrayList<Method> arrayList = new ArrayList<Method>();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().startsWith("create")) continue;
            arrayList.add(methodArray[i]);
        }
        return arrayList;
    }

    protected List getHomeMethods() {
        ArrayList<Method> arrayList = new ArrayList<Method>();
        Method[] methodArray = this.beanClass.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().startsWith("ejbHome")) continue;
            arrayList.add(methodArray[i]);
        }
        return arrayList;
    }

    protected List getHomeInterfaceHomeMethods() {
        ArrayList<Method> arrayList = new ArrayList<Method>();
        Method[] methodArray = this.homeInterface.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            String string = method.getName();
            boolean bl = string.startsWith("create") || string.startsWith("find");
            boolean bl2 = method.getDeclaringClass().equals(EJBHome.class);
            boolean bl3 = "<clinit>".equals(string);
            if (bl || bl2 || bl3) continue;
            arrayList.add(method);
        }
        return arrayList;
    }

    protected boolean checkingRemoteClientView() {
        return this.ejbHomeInterface.equals(EJBHome.class);
    }

    public void checkExtendsEJBHome() throws ComplianceException {
        if (!this.ejbHomeInterface.isAssignableFrom(this.homeInterface)) {
            if (this.checkingRemoteClientView()) {
                throw new ComplianceException(this.fmt.HOME_EXTENDS_EJBHOME(this.ejbName, this.homeInterface.getName()));
            }
            throw new ComplianceException(this.fmt.LOCAL_HOME_EXTENDS_EJBLOCALHOME(this.ejbName, this.homeInterface.getName()));
        }
    }

    public void checkRMIIIOPTypes() throws ErrorCollectionException {
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        if (this.checkingRemoteClientView()) {
            Method[] methodArray = this.homeInterface.getDeclaredMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                Method method = methodArray[i];
                Class<?> clazz = method.getReturnType();
                if (!ComplianceUtils.isLegalRMIIIOPType(clazz)) {
                    errorCollectionException.add((Throwable)new ComplianceException(this.fmt.NOT_RMIIIOP_LEGAL_TYPE_20(this.ejbName)));
                }
                Class<?>[] classArray = method.getParameterTypes();
                for (int j = 0; j < classArray.length; ++j) {
                    clazz = classArray[j];
                    if (ComplianceUtils.isLegalRMIIIOPType(clazz)) continue;
                    errorCollectionException.add((Throwable)new ComplianceException(this.fmt.NOT_RMIIIOP_LEGAL_TYPE_20(this.ejbName)));
                }
            }
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    public void checkMethodsThrowRemoteException() throws ErrorCollectionException {
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        Method[] methodArray = this.homeInterface.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            if (methodArray[i].getName().equals("<clinit>")) continue;
            if (this.checkingRemoteClientView()) {
                if (ComplianceUtils.methodThrowsException(methodArray[i], RemoteException.class)) continue;
                errorCollectionException.add((Throwable)new ComplianceException(this.fmt.HOME_METHOD_NOT_THROW_REMOTE_EXCEPTION(this.ejbName, this.methodSig(methodArray[i]))));
                continue;
            }
            if (!ComplianceUtils.methodThrowsException(methodArray[i], RemoteException.class)) continue;
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.LOCAL_HOME_METHOD_THROW_REMOTE_EXCEPTION(this.ejbName, this.methodSig(methodArray[i]))));
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    public void checkApplicationExceptions() throws ErrorCollectionException {
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        for (Method method : this.getHomeInterfaceHomeMethods()) {
            Class<?>[] classArray = method.getExceptionTypes();
            for (int i = 0; i < classArray.length; ++i) {
                Class<?> clazz = classArray[i];
                boolean bl = false;
                bl = this.checkingRemoteClientView() ? ComplianceUtils.checkApplicationException(clazz, RemoteException.class) : ComplianceUtils.checkApplicationException(clazz, EJBException.class);
                if (bl) continue;
                errorCollectionException.add((Throwable)new ComplianceException(this.fmt.INVALID_APPLICATION_EXCEPTION_ON_HOME(this.ejbName, this.methodSig(method), method.getDeclaringClass().getName(), clazz.getName())));
            }
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    public void checkCreateReturnsCompInterface() throws ErrorCollectionException {
        Iterator iterator = this.getCreateMethods().iterator();
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        while (iterator.hasNext()) {
            Method method = (Method)iterator.next();
            Class<?> clazz = method.getReturnType();
            if (clazz.equals(this.compInterface)) continue;
            if (this.checkingRemoteClientView()) {
                errorCollectionException.add((Throwable)new ComplianceException(this.fmt.CREATE_METHOD_RETURNS_COMPONENT_INTERFACE(this.ejbName, this.methodSig(method))));
                continue;
            }
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.CREATE_METHOD_RETURNS_LOCAL_COMPONENT_INTERFACE(this.ejbName, this.methodSig(method))));
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    public void checkCreateThrowsCreateException() throws ErrorCollectionException {
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        for (Method method : this.getCreateMethods()) {
            if (ComplianceUtils.methodThrowsException(method, CreateException.class)) continue;
            if (this.checkingRemoteClientView()) {
                errorCollectionException.add((Throwable)new ComplianceException(this.fmt.CREATE_METHOD_THROWS_CREATE_EXCEPTION(this.ejbName, this.methodSig(method))));
                continue;
            }
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.LOCAL_CREATE_METHOD_THROWS_CREATE_EXCEPTION(this.ejbName, this.methodSig(method))));
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    public void checkCreateMethodsMatchBeanCreates() throws ErrorCollectionException {
        if (this.cbi.isEJB30()) {
            if (!(this.cbi instanceof Ejb3SessionBeanInfo)) {
                return;
            }
            if (!((Ejb3SessionBeanInfo)this.cbi).isStateful()) {
                return;
            }
        }
        Iterator iterator = this.getCreateMethods().iterator();
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        while (iterator.hasNext()) {
            Method method = (Method)iterator.next();
            String string = method.getName();
            String string2 = this.cbi.isEJB30() ? ((Ejb3SessionBeanInfo)this.cbi).getEjbCreateInitMethodName(method) : "ejbC" + string.substring(1, string.length());
            try {
                Method method2 = this.beanClass.getMethod(string2, method.getParameterTypes());
                ComplianceUtils.exceptionTypesMatch(method, method2);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (this.checkingRemoteClientView()) {
                    errorCollectionException.add((Throwable)new ComplianceException(this.fmt.CREATE_METHOD_DOESNT_EXIST_IN_BEAN(this.ejbName, this.methodSig(string2, method.getParameterTypes()))));
                    continue;
                }
                errorCollectionException.add((Throwable)new ComplianceException(this.fmt.LOCAL_CREATE_METHOD_DOESNT_EXIST_IN_BEAN(this.ejbName, this.methodSig(string2, method.getParameterTypes()))));
            }
            catch (ExceptionTypeMismatchException exceptionTypeMismatchException) {
                if (this.checkingRemoteClientView()) {
                    errorCollectionException.add((Throwable)new ComplianceException(this.fmt.CREATE_EXCEPTION_TYPE_DOESNT_MATCH_BEAN(this.ejbName, this.methodSig(string2, method.getParameterTypes()))));
                    continue;
                }
                errorCollectionException.add((Throwable)new ComplianceException(this.fmt.LOCAL_CREATE_EXCEPTION_TYPE_DOESNT_MATCH_BEAN(this.ejbName, this.methodSig(string2, method.getParameterTypes()))));
            }
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    public void checkLocalExposeThroughRemote() throws ErrorCollectionException {
        if (!this.checkingRemoteClientView()) {
            return;
        }
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        Method[] methodArray = this.homeInterface.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!ComplianceUtils.localExposeThroughRemote(methodArray[i])) continue;
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.LOCAL_INTERFACE_TYPES_EXPOSE_THROUGH_HOME_INTERFACE(this.ejbName, this.methodSig(methodArray[i]))));
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }
}

