/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.compliance;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import weblogic.ejb.container.compliance.BaseComplianceChecker;
import weblogic.ejb.container.compliance.BusinessMethodInterceptorChecker;
import weblogic.ejb.container.compliance.ComplianceException;
import weblogic.ejb.container.compliance.EJBComplianceTextFormatter;
import weblogic.ejb.container.compliance.LifecycleCallbackInterceptorChecker;
import weblogic.ejb.container.interfaces.DeploymentInfo;
import weblogic.ejb.spi.EjbDescriptorBean;
import weblogic.j2ee.descriptor.EjbJarBean;
import weblogic.j2ee.descriptor.InterceptorBean;
import weblogic.j2ee.descriptor.InterceptorsBean;
import weblogic.utils.ErrorCollectionException;

final class InterceptorChecker
extends BaseComplianceChecker {
    private DeploymentInfo deploymentInfo;
    private EjbDescriptorBean ejbDescriptor;
    private EjbJarBean ejbJarBean;
    private InterceptorsBean interceptorsBean;
    private BusinessMethodInterceptorChecker businessMethodInterceptorChecker;
    private LifecycleCallbackInterceptorChecker lifecycleCallbackInterceptorChecker;
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();

    public InterceptorChecker(DeploymentInfo deploymentInfo) {
        this.deploymentInfo = deploymentInfo;
        this.ejbDescriptor = this.deploymentInfo.getEjbDescriptorBean();
        this.ejbJarBean = this.ejbDescriptor.getEjbJarBean();
        this.interceptorsBean = this.ejbJarBean.getInterceptors();
        this.businessMethodInterceptorChecker = new BusinessMethodInterceptorChecker(deploymentInfo);
        this.lifecycleCallbackInterceptorChecker = new LifecycleCallbackInterceptorChecker(deploymentInfo);
    }

    public void checkInterceptorNotDeclareTwice() throws ComplianceException {
        if (this.interceptorsBean != null) {
            InterceptorBean[] interceptorBeanArray = this.interceptorsBean.getInterceptors();
            for (int i = 0; i < interceptorBeanArray.length; ++i) {
                String string = interceptorBeanArray[i].getInterceptorClass();
                for (int j = i + 1; j < interceptorBeanArray.length; ++j) {
                    if (!interceptorBeanArray[j].getInterceptorClass().equals(string)) continue;
                    throw new ComplianceException(EJBComplianceTextFormatter.getInstance().INTERCEPTOR_CLASS_DECLARED_IN_DD(string.toString()));
                }
            }
        }
    }

    public void checkOnlyOneAroundInvokeMethodperClass() throws ComplianceException {
        this.businessMethodInterceptorChecker.checkOnlyOneAroundInvokeMethodperClass();
    }

    public void checkOnlyOneLifecycleCallbackMethodperLEperClass() throws ComplianceException {
        this.lifecycleCallbackInterceptorChecker.checkOnlyOneLifecycleCallbackMethodperLEperClass();
    }

    public void checkAroundInvokeMethods() throws ErrorCollectionException, ComplianceException {
        this.businessMethodInterceptorChecker.checkAroundInvokeMethods();
    }

    public void checkLifecycleCallbackMethods() throws ErrorCollectionException, ComplianceException {
        this.lifecycleCallbackInterceptorChecker.checkLifecycleCallbackMethods();
    }

    public void checkDefaultConstructorInInterceptorClass() throws ComplianceException {
        if (this.interceptorsBean != null) {
            InterceptorBean[] interceptorBeanArray = this.interceptorsBean.getInterceptors();
            for (int i = 0; i < interceptorBeanArray.length; ++i) {
                String string = interceptorBeanArray[i].getInterceptorClass();
                try {
                    Class<?> clazz = this.classLoader.loadClass(string);
                    Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                    int n = constructor.getModifiers();
                    if (!Modifier.isPublic(n)) {
                        throw new ComplianceException(EJBComplianceTextFormatter.getInstance().INTERCEPTOR_CLASS_WITHOUT_NOARG_CONSTRUCTOR(string.toString()));
                    }
                    n = clazz.getModifiers();
                    if (!Modifier.isFinal(n)) continue;
                    throw new ComplianceException(EJBComplianceTextFormatter.getInstance().AROUNDINVOKE_METHOD_CANNOT_BE_FINAL(string.toString()));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new RuntimeException(classNotFoundException);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new ComplianceException(EJBComplianceTextFormatter.getInstance().INTERCEPTOR_CLASS_WITHOUT_NOARG_CONSTRUCTOR(string.toString()));
                }
            }
        }
    }
}

