/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.compliance;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.interceptor.InvocationContext;
import weblogic.ejb.container.compliance.ComplianceException;
import weblogic.ejb.container.compliance.EJBComplianceTextFormatter;
import weblogic.ejb.container.dd.xml.DDUtils;
import weblogic.ejb.container.interfaces.BeanInfo;
import weblogic.ejb.container.interfaces.Ejb3SessionBeanInfo;
import weblogic.j2ee.descriptor.AroundInvokeBean;
import weblogic.j2ee.descriptor.InterceptorBean;
import weblogic.j2ee.descriptor.LifecycleCallbackBean;
import weblogic.j2ee.descriptor.MessageDrivenBeanBean;
import weblogic.j2ee.descriptor.SessionBeanBean;

public class InterceptorHelper {
    public static Set getAllBusinessMethods(Collection collection) {
        Iterator iterator = collection.iterator();
        HashSet hashSet = new HashSet();
        while (iterator.hasNext()) {
            String string;
            int n;
            Method[] methodArray;
            Set set;
            BeanInfo beanInfo = (BeanInfo)iterator.next();
            if (!(beanInfo instanceof Ejb3SessionBeanInfo)) continue;
            HashMap<String, Method> hashMap = new HashMap<String, Method>();
            Ejb3SessionBeanInfo ejb3SessionBeanInfo = (Ejb3SessionBeanInfo)beanInfo;
            Method[] methodArray2 = ejb3SessionBeanInfo.getBeanClass().getMethods();
            String[] stringArray = new String[methodArray2.length];
            for (int i = 0; i < methodArray2.length; ++i) {
                stringArray[i] = DDUtils.getMethodSignature(methodArray2[i]);
                hashMap.put(stringArray[i], methodArray2[i]);
            }
            List<String> list = Arrays.asList(stringArray);
            if (ejb3SessionBeanInfo.hasBusinessRemotes()) {
                set = ejb3SessionBeanInfo.getBusinessRemotes();
                for (Class clazz : set) {
                    methodArray = clazz.getMethods();
                    for (n = 0; n < methodArray.length; ++n) {
                        string = DDUtils.getMethodSignature(methodArray[n]);
                        if (!list.contains(string)) continue;
                        hashSet.add(hashMap.get(string));
                    }
                }
            }
            if (!ejb3SessionBeanInfo.hasBusinessLocals()) continue;
            set = ejb3SessionBeanInfo.getBusinessLocals();
            for (Class clazz : set) {
                methodArray = clazz.getMethods();
                for (n = 0; n < methodArray.length; ++n) {
                    string = DDUtils.getMethodSignature(methodArray[n]);
                    if (!list.contains(string)) continue;
                    hashSet.add(hashMap.get(string));
                }
            }
        }
        return hashSet;
    }

    public static Set getAroundInvokeMethodinBean(ClassLoader classLoader, SessionBeanBean sessionBeanBean) throws ComplianceException {
        HashSet<Method> hashSet = new HashSet<Method>();
        AroundInvokeBean[] aroundInvokeBeanArray = sessionBeanBean.getAroundInvokes();
        if (aroundInvokeBeanArray != null && aroundInvokeBeanArray.length >= 1) {
            for (int i = 0; i < aroundInvokeBeanArray.length; ++i) {
                String string = aroundInvokeBeanArray[i].getClassName();
                if (string == null) {
                    string = sessionBeanBean.getEjbClass();
                }
                String string2 = aroundInvokeBeanArray[i].getMethodName();
                try {
                    Class<?> clazz = classLoader.loadClass(string);
                    Method method = clazz.getDeclaredMethod(string2, InvocationContext.class);
                    hashSet.add(method);
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new RuntimeException(classNotFoundException);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new ComplianceException(EJBComplianceTextFormatter.getInstance().AROUNDINVOKE_METHOD_WITH_INVALIDE_SIGNATURE(string2, string));
                }
            }
        }
        return hashSet;
    }

    public static Set getAroundInvokeMethodinBean(ClassLoader classLoader, MessageDrivenBeanBean messageDrivenBeanBean) throws ComplianceException {
        HashSet<Method> hashSet = new HashSet<Method>();
        AroundInvokeBean[] aroundInvokeBeanArray = messageDrivenBeanBean.getAroundInvokes();
        if (aroundInvokeBeanArray != null && aroundInvokeBeanArray.length >= 1) {
            for (int i = 0; i < aroundInvokeBeanArray.length; ++i) {
                String string = aroundInvokeBeanArray[i].getClassName();
                String string2 = aroundInvokeBeanArray[i].getMethodName();
                try {
                    Class<?> clazz = classLoader.loadClass(string);
                    Method method = clazz.getDeclaredMethod(string2, InvocationContext.class);
                    hashSet.add(method);
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new RuntimeException(classNotFoundException);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new ComplianceException(EJBComplianceTextFormatter.getInstance().AROUNDINVOKE_METHOD_WITH_INVALIDE_SIGNATURE(string2, string));
                }
            }
        }
        return hashSet;
    }

    public static Set getPostConstructCallbackMethodinBean(ClassLoader classLoader, SessionBeanBean sessionBeanBean) throws ComplianceException {
        HashSet<Method> hashSet = new HashSet<Method>();
        LifecycleCallbackBean[] lifecycleCallbackBeanArray = sessionBeanBean.getPostConstructs();
        if (lifecycleCallbackBeanArray != null && lifecycleCallbackBeanArray.length >= 1) {
            for (int i = 0; i < lifecycleCallbackBeanArray.length; ++i) {
                String string = lifecycleCallbackBeanArray[i].getLifecycleCallbackClass();
                String string2 = lifecycleCallbackBeanArray[i].getLifecycleCallbackMethod();
                try {
                    Class<?> clazz = classLoader.loadClass(string);
                    Method method = clazz.getDeclaredMethod(string2, new Class[0]);
                    hashSet.add(method);
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new RuntimeException(classNotFoundException);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new ComplianceException(EJBComplianceTextFormatter.getInstance().POSTCONSTRUCT_METHOD_WITH_INVALIDE_SIGNATURE(string2, string));
                }
            }
        }
        return hashSet;
    }

    public static Set getPostConstructCallbackMethodinBean(ClassLoader classLoader, MessageDrivenBeanBean messageDrivenBeanBean) throws ComplianceException {
        HashSet<Method> hashSet = new HashSet<Method>();
        LifecycleCallbackBean[] lifecycleCallbackBeanArray = messageDrivenBeanBean.getPostConstructs();
        if (lifecycleCallbackBeanArray != null && lifecycleCallbackBeanArray.length >= 1) {
            for (int i = 0; i < lifecycleCallbackBeanArray.length; ++i) {
                String string = lifecycleCallbackBeanArray[i].getLifecycleCallbackClass();
                String string2 = lifecycleCallbackBeanArray[i].getLifecycleCallbackMethod();
                try {
                    Class<?> clazz = classLoader.loadClass(string);
                    Method method = clazz.getDeclaredMethod(string2, new Class[0]);
                    hashSet.add(method);
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new RuntimeException(classNotFoundException);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new ComplianceException(EJBComplianceTextFormatter.getInstance().POSTCONSTRUCT_METHOD_WITH_INVALIDE_SIGNATURE(string2, string));
                }
            }
        }
        return hashSet;
    }

    public static Set getPreDestroyCallbackMethodinBean(ClassLoader classLoader, SessionBeanBean sessionBeanBean) throws ComplianceException {
        HashSet<Method> hashSet = new HashSet<Method>();
        LifecycleCallbackBean[] lifecycleCallbackBeanArray = sessionBeanBean.getPreDestroys();
        if (lifecycleCallbackBeanArray != null && lifecycleCallbackBeanArray.length >= 1) {
            for (int i = 0; i < lifecycleCallbackBeanArray.length; ++i) {
                String string = lifecycleCallbackBeanArray[i].getLifecycleCallbackClass();
                String string2 = lifecycleCallbackBeanArray[i].getLifecycleCallbackMethod();
                try {
                    Class<?> clazz = classLoader.loadClass(string);
                    Method method = clazz.getDeclaredMethod(string2, new Class[0]);
                    hashSet.add(method);
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new RuntimeException(classNotFoundException);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new ComplianceException(EJBComplianceTextFormatter.getInstance().PREDESTROY_METHOD_WITH_INVALIDE_SIGNATURE(string2, string));
                }
            }
        }
        return hashSet;
    }

    public static Set getPreDestroyCallbackMethodinBean(ClassLoader classLoader, MessageDrivenBeanBean messageDrivenBeanBean) throws ComplianceException {
        HashSet<Method> hashSet = new HashSet<Method>();
        LifecycleCallbackBean[] lifecycleCallbackBeanArray = messageDrivenBeanBean.getPreDestroys();
        if (lifecycleCallbackBeanArray != null && lifecycleCallbackBeanArray.length >= 1) {
            for (int i = 0; i < lifecycleCallbackBeanArray.length; ++i) {
                String string = lifecycleCallbackBeanArray[i].getLifecycleCallbackClass();
                String string2 = lifecycleCallbackBeanArray[i].getLifecycleCallbackMethod();
                try {
                    Class<?> clazz = classLoader.loadClass(string);
                    Method method = clazz.getDeclaredMethod(string2, new Class[0]);
                    hashSet.add(method);
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new RuntimeException(classNotFoundException);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new ComplianceException(EJBComplianceTextFormatter.getInstance().PREDESTROY_METHOD_WITH_INVALIDE_SIGNATURE(string2, string));
                }
            }
        }
        return hashSet;
    }

    public static Set getPostActivateCallbackMethodinBean(ClassLoader classLoader, SessionBeanBean sessionBeanBean) throws ComplianceException {
        HashSet<Method> hashSet = new HashSet<Method>();
        LifecycleCallbackBean[] lifecycleCallbackBeanArray = sessionBeanBean.getPostActivates();
        if (lifecycleCallbackBeanArray != null && lifecycleCallbackBeanArray.length >= 1) {
            for (int i = 0; i < lifecycleCallbackBeanArray.length; ++i) {
                String string = lifecycleCallbackBeanArray[i].getLifecycleCallbackClass();
                String string2 = lifecycleCallbackBeanArray[i].getLifecycleCallbackMethod();
                try {
                    Class<?> clazz = classLoader.loadClass(string);
                    Method method = clazz.getDeclaredMethod(string2, new Class[0]);
                    hashSet.add(method);
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new RuntimeException(classNotFoundException);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new ComplianceException(EJBComplianceTextFormatter.getInstance().POSTACTIVE_METHOD_WITH_INVALIDE_SIGNATURE(string2, string));
                }
            }
        }
        return hashSet;
    }

    public static Set getPrePassivateCallbackMethodinBean(ClassLoader classLoader, SessionBeanBean sessionBeanBean) throws ComplianceException {
        HashSet<Method> hashSet = new HashSet<Method>();
        LifecycleCallbackBean[] lifecycleCallbackBeanArray = sessionBeanBean.getPrePassivates();
        if (lifecycleCallbackBeanArray != null && lifecycleCallbackBeanArray.length >= 1) {
            for (int i = 0; i < lifecycleCallbackBeanArray.length; ++i) {
                String string = lifecycleCallbackBeanArray[i].getLifecycleCallbackClass();
                String string2 = lifecycleCallbackBeanArray[i].getLifecycleCallbackMethod();
                try {
                    Class<?> clazz = classLoader.loadClass(string);
                    Method method = clazz.getDeclaredMethod(string2, new Class[0]);
                    hashSet.add(method);
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new RuntimeException(classNotFoundException);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new ComplianceException(EJBComplianceTextFormatter.getInstance().PREPASSIVATE_METHOD_WITH_INVALIDE_SIGNATURE(string2, string));
                }
            }
        }
        return hashSet;
    }

    public static Set getAroundInvokeMethodinInterceptor(ClassLoader classLoader, InterceptorBean interceptorBean) throws ComplianceException {
        HashSet<Method> hashSet = new HashSet<Method>();
        AroundInvokeBean[] aroundInvokeBeanArray = interceptorBean.getAroundInvokes();
        if (aroundInvokeBeanArray != null && aroundInvokeBeanArray.length >= 1) {
            for (int i = 0; i < aroundInvokeBeanArray.length; ++i) {
                String string = aroundInvokeBeanArray[i].getClassName();
                if (string == null) {
                    string = interceptorBean.getInterceptorClass();
                }
                String string2 = aroundInvokeBeanArray[i].getMethodName();
                try {
                    Class<?> clazz = classLoader.loadClass(string);
                    Method method = clazz.getDeclaredMethod(string2, InvocationContext.class);
                    hashSet.add(method);
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new RuntimeException(classNotFoundException);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new ComplianceException(EJBComplianceTextFormatter.getInstance().AROUNDINVOKE_METHOD_WITH_INVALIDE_SIGNATURE(string2, string));
                }
            }
        }
        return hashSet;
    }

    public static Set getLifecycleCallbackMethodinInterceptor(ClassLoader classLoader, InterceptorBean interceptorBean) throws ComplianceException {
        Method method;
        Class<?> clazz;
        String string;
        String string2;
        int n;
        HashSet<Method> hashSet = new HashSet<Method>();
        LifecycleCallbackBean[] lifecycleCallbackBeanArray = interceptorBean.getPostConstructs();
        if (lifecycleCallbackBeanArray != null && lifecycleCallbackBeanArray.length >= 1) {
            for (n = 0; n < lifecycleCallbackBeanArray.length; ++n) {
                string2 = lifecycleCallbackBeanArray[n].getLifecycleCallbackClass();
                string = lifecycleCallbackBeanArray[n].getLifecycleCallbackMethod();
                try {
                    clazz = classLoader.loadClass(string2);
                    method = clazz.getDeclaredMethod(string, InvocationContext.class);
                    hashSet.add(method);
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new RuntimeException(classNotFoundException);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new ComplianceException(EJBComplianceTextFormatter.getInstance().INTERCEPTOR_POSTCONSTRUCT_METHOD_WITH_INVALIDE_SIGNATURE(string, string2));
                }
            }
        }
        if ((lifecycleCallbackBeanArray = interceptorBean.getPreDestroys()) != null && lifecycleCallbackBeanArray.length >= 1) {
            for (n = 0; n < lifecycleCallbackBeanArray.length; ++n) {
                string2 = lifecycleCallbackBeanArray[n].getLifecycleCallbackClass();
                string = lifecycleCallbackBeanArray[n].getLifecycleCallbackMethod();
                try {
                    clazz = classLoader.loadClass(string2);
                    method = clazz.getDeclaredMethod(string, InvocationContext.class);
                    hashSet.add(method);
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new RuntimeException(classNotFoundException);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new ComplianceException(EJBComplianceTextFormatter.getInstance().INTERCEPTOR_PREDESTROY_METHOD_WITH_INVALIDE_SIGNATURE(string, string2));
                }
            }
        }
        if ((lifecycleCallbackBeanArray = interceptorBean.getPostActivates()) != null && lifecycleCallbackBeanArray.length >= 1) {
            for (n = 0; n < lifecycleCallbackBeanArray.length; ++n) {
                string2 = lifecycleCallbackBeanArray[n].getLifecycleCallbackClass();
                string = lifecycleCallbackBeanArray[n].getLifecycleCallbackMethod();
                try {
                    clazz = classLoader.loadClass(string2);
                    method = clazz.getDeclaredMethod(string, InvocationContext.class);
                    hashSet.add(method);
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new RuntimeException(classNotFoundException);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new ComplianceException(EJBComplianceTextFormatter.getInstance().INTERCEPTOR_POSTACTIVE_METHOD_WITH_INVALIDE_SIGNATURE(string, string2));
                }
            }
        }
        if ((lifecycleCallbackBeanArray = interceptorBean.getPrePassivates()) != null && lifecycleCallbackBeanArray.length >= 1) {
            for (n = 0; n < lifecycleCallbackBeanArray.length; ++n) {
                string2 = lifecycleCallbackBeanArray[n].getLifecycleCallbackClass();
                string = lifecycleCallbackBeanArray[n].getLifecycleCallbackMethod();
                try {
                    clazz = classLoader.loadClass(string2);
                    method = clazz.getDeclaredMethod(string, InvocationContext.class);
                    hashSet.add(method);
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new RuntimeException(classNotFoundException);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new ComplianceException(EJBComplianceTextFormatter.getInstance().INTERCEPTOR_PREPASSIVATE_METHOD_WITH_INVALIDE_SIGNATURE(string, string2));
                }
            }
        }
        return hashSet;
    }
}

