/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.compliance;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import weblogic.ejb.container.compliance.BaseComplianceChecker;
import weblogic.ejb.container.compliance.ComplianceException;
import weblogic.ejb.container.compliance.EJBComplianceTextFormatter;
import weblogic.ejb.container.compliance.InterceptorHelper;
import weblogic.ejb.container.interfaces.BeanInfo;
import weblogic.ejb.container.interfaces.DeploymentInfo;
import weblogic.ejb.container.interfaces.SessionBeanInfo;
import weblogic.ejb.spi.EjbDescriptorBean;
import weblogic.j2ee.descriptor.EjbJarBean;
import weblogic.j2ee.descriptor.InterceptorBean;
import weblogic.j2ee.descriptor.InterceptorsBean;
import weblogic.j2ee.descriptor.LifecycleCallbackBean;
import weblogic.j2ee.descriptor.MessageDrivenBeanBean;
import weblogic.j2ee.descriptor.SessionBeanBean;
import weblogic.utils.ErrorCollectionException;

final class LifecycleCallbackInterceptorChecker
extends BaseComplianceChecker {
    private DeploymentInfo deploymentInfo;
    private EjbDescriptorBean ejbDescriptor;
    private EjbJarBean ejbJarBean;
    private InterceptorsBean interceptorsBean;
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();

    public LifecycleCallbackInterceptorChecker(DeploymentInfo deploymentInfo) {
        this.deploymentInfo = deploymentInfo;
        this.ejbDescriptor = this.deploymentInfo.getEjbDescriptorBean();
        this.ejbJarBean = this.ejbDescriptor.getEjbJarBean();
        this.interceptorsBean = this.ejbJarBean.getInterceptors();
    }

    public void checkOnlyOneLifecycleCallbackMethodperLEperClass() throws ComplianceException {
        SessionBeanBean sessionBeanBean;
        BeanInfo beanInfo;
        int n;
        LifecycleCallbackBean[] lifecycleCallbackBeanArray = null;
        SessionBeanBean[] sessionBeanBeanArray = this.ejbJarBean.getEnterpriseBeans().getSessions();
        for (n = 0; n < sessionBeanBeanArray.length; ++n) {
            beanInfo = this.deploymentInfo.getBeanInfo(sessionBeanBeanArray[n].getEjbName());
            if (!beanInfo.isEJB30()) continue;
            sessionBeanBean = sessionBeanBeanArray[n];
            lifecycleCallbackBeanArray = sessionBeanBean.getPostConstructs();
            this.validateNotTwoSameTypeLifecycleCallbackPerClass(lifecycleCallbackBeanArray, "PostConstruct");
            lifecycleCallbackBeanArray = sessionBeanBean.getPreDestroys();
            this.validateNotTwoSameTypeLifecycleCallbackPerClass(lifecycleCallbackBeanArray, "PreDestroy");
            SessionBeanInfo sessionBeanInfo = (SessionBeanInfo)beanInfo;
            if (!sessionBeanInfo.isStateful()) continue;
            lifecycleCallbackBeanArray = sessionBeanBean.getPostActivates();
            this.validateNotTwoSameTypeLifecycleCallbackPerClass(lifecycleCallbackBeanArray, "PostActivate");
            lifecycleCallbackBeanArray = sessionBeanBean.getPrePassivates();
            this.validateNotTwoSameTypeLifecycleCallbackPerClass(lifecycleCallbackBeanArray, "PrePassivate");
        }
        sessionBeanBeanArray = this.ejbJarBean.getEnterpriseBeans().getMessageDrivens();
        for (n = 0; n < sessionBeanBeanArray.length; ++n) {
            beanInfo = this.deploymentInfo.getBeanInfo(sessionBeanBeanArray[n].getEjbName());
            if (!beanInfo.isEJB30()) continue;
            sessionBeanBean = (MessageDrivenBeanBean)sessionBeanBeanArray[n];
            lifecycleCallbackBeanArray = sessionBeanBean.getPostConstructs();
            this.validateNotTwoSameTypeLifecycleCallbackPerClass(lifecycleCallbackBeanArray, "PostConstruct");
            lifecycleCallbackBeanArray = sessionBeanBean.getPreDestroys();
            this.validateNotTwoSameTypeLifecycleCallbackPerClass(lifecycleCallbackBeanArray, "PreDestroy");
        }
        if (this.interceptorsBean != null) {
            InterceptorBean[] interceptorBeanArray = this.interceptorsBean.getInterceptors();
            for (int i = 0; i < interceptorBeanArray.length; ++i) {
                lifecycleCallbackBeanArray = interceptorBeanArray[i].getPostConstructs();
                this.validateNotTwoSameTypeLifecycleCallbackPerClass(lifecycleCallbackBeanArray, "PostConstruct");
                lifecycleCallbackBeanArray = interceptorBeanArray[i].getPreDestroys();
                this.validateNotTwoSameTypeLifecycleCallbackPerClass(lifecycleCallbackBeanArray, "PreDestroy");
                lifecycleCallbackBeanArray = interceptorBeanArray[i].getPostActivates();
                this.validateNotTwoSameTypeLifecycleCallbackPerClass(lifecycleCallbackBeanArray, "PostActivate");
                lifecycleCallbackBeanArray = interceptorBeanArray[i].getPrePassivates();
                this.validateNotTwoSameTypeLifecycleCallbackPerClass(lifecycleCallbackBeanArray, "PrePassivate");
            }
        }
    }

    public void checkLifecycleCallbackMethods() throws ErrorCollectionException, ComplianceException {
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        Set set = this.getAllLifecycleCallbackMethodsFromBean();
        for (Method method : set) {
            try {
                this.validateLifecycleCallbackMethod(method, true);
            }
            catch (ErrorCollectionException errorCollectionException2) {
                errorCollectionException.add((Throwable)errorCollectionException2);
            }
        }
        set = this.getAllLifecycleCallbackMethodsFromInterceptor();
        for (Method method : set) {
            try {
                this.validateLifecycleCallbackMethod(method, false);
            }
            catch (ErrorCollectionException errorCollectionException3) {
                errorCollectionException.add((Throwable)errorCollectionException3);
            }
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    private void validateLifecycleCallbackMethod(Method method, boolean bl) throws ErrorCollectionException {
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        int n = method.getModifiers();
        if (Modifier.isFinal(n)) {
            errorCollectionException.add((Throwable)new ComplianceException(EJBComplianceTextFormatter.getInstance().LIFECYCLE_INTERCEPTOR_METHOD_NOT_BE_FINAL(method.getName(), method.getDeclaringClass().getName())));
        }
        if (Modifier.isStatic(n)) {
            errorCollectionException.add((Throwable)new ComplianceException(EJBComplianceTextFormatter.getInstance().LIFECYCLE_INTERCEPTOR_METHOD_NOT_BE_STATIC(method.getName(), method.getDeclaringClass().getName())));
        }
        Class<?> clazz = method.getReturnType();
        Class<?>[] classArray = method.getExceptionTypes();
        if (!clazz.equals(Void.TYPE)) {
            if (bl) {
                errorCollectionException.add((Throwable)new ComplianceException(EJBComplianceTextFormatter.getInstance().LIFECYCLE_INTERCEPTOR_METHOD_WITH_INVALID_SIGNATURE(method.getName(), method.getDeclaringClass().getName(), "void <METHOD>()")));
            } else {
                errorCollectionException.add((Throwable)new ComplianceException(EJBComplianceTextFormatter.getInstance().LIFECYCLE_INTERCEPTOR_METHOD_WITH_INVALID_SIGNATURE(method.getName(), method.getDeclaringClass().getName(), "void <METHOD>(InvocationContext)")));
            }
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    private void validateNotTwoSameTypeLifecycleCallbackPerClass(LifecycleCallbackBean[] lifecycleCallbackBeanArray, String string) throws ComplianceException {
        if (lifecycleCallbackBeanArray != null && lifecycleCallbackBeanArray.length > 1) {
            for (int i = 0; i < lifecycleCallbackBeanArray.length; ++i) {
                String string2 = lifecycleCallbackBeanArray[i].getLifecycleCallbackClass();
                for (int j = i + 1; j < lifecycleCallbackBeanArray.length; ++j) {
                    if (!string2.equals(lifecycleCallbackBeanArray[j].getLifecycleCallbackClass())) continue;
                    throw new ComplianceException(EJBComplianceTextFormatter.getInstance().TWO_LIFECYCLE_INTERCEPTOR_METHOD_IN_BEAN(string.toString(), string2.toString()));
                }
            }
        }
    }

    private Set getAllLifecycleCallbackMethodsFromBean() throws ComplianceException {
        Set set;
        SessionBeanBean sessionBeanBean;
        BeanInfo beanInfo;
        int n;
        HashSet hashSet = new HashSet();
        SessionBeanBean[] sessionBeanBeanArray = this.ejbJarBean.getEnterpriseBeans().getSessions();
        for (n = 0; n < sessionBeanBeanArray.length; ++n) {
            beanInfo = this.deploymentInfo.getBeanInfo(sessionBeanBeanArray[n].getEjbName());
            if (!beanInfo.isEJB30()) continue;
            sessionBeanBean = sessionBeanBeanArray[n];
            set = InterceptorHelper.getPostConstructCallbackMethodinBean(this.classLoader, sessionBeanBean);
            hashSet.addAll(set);
            set = InterceptorHelper.getPreDestroyCallbackMethodinBean(this.classLoader, sessionBeanBean);
            hashSet.addAll(set);
            SessionBeanInfo sessionBeanInfo = (SessionBeanInfo)beanInfo;
            if (!sessionBeanInfo.isStateful()) continue;
            set = InterceptorHelper.getPostActivateCallbackMethodinBean(this.classLoader, sessionBeanBean);
            hashSet.addAll(set);
            set = InterceptorHelper.getPrePassivateCallbackMethodinBean(this.classLoader, sessionBeanBean);
            hashSet.addAll(set);
        }
        sessionBeanBeanArray = this.ejbJarBean.getEnterpriseBeans().getMessageDrivens();
        for (n = 0; n < sessionBeanBeanArray.length; ++n) {
            beanInfo = this.deploymentInfo.getBeanInfo(sessionBeanBeanArray[n].getEjbName());
            if (!beanInfo.isEJB30()) continue;
            sessionBeanBean = (MessageDrivenBeanBean)sessionBeanBeanArray[n];
            set = InterceptorHelper.getPostConstructCallbackMethodinBean(this.classLoader, (MessageDrivenBeanBean)sessionBeanBean);
            hashSet.addAll(set);
            set = InterceptorHelper.getPreDestroyCallbackMethodinBean(this.classLoader, (MessageDrivenBeanBean)sessionBeanBean);
            hashSet.addAll(set);
        }
        return hashSet;
    }

    private Set getAllLifecycleCallbackMethodsFromInterceptor() throws ComplianceException {
        HashSet hashSet = new HashSet();
        if (this.interceptorsBean != null) {
            InterceptorBean[] interceptorBeanArray = this.interceptorsBean.getInterceptors();
            for (int i = 0; i < interceptorBeanArray.length; ++i) {
                Set set = InterceptorHelper.getLifecycleCallbackMethodinInterceptor(this.classLoader, interceptorBeanArray[i]);
                hashSet.addAll(set);
            }
        }
        return hashSet;
    }
}

