/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.compliance;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import weblogic.ejb.container.compliance.EJBComplianceTextFormatter;
import weblogic.utils.StackTraceUtils;

public final class Log {
    private static final boolean debug = false;
    private boolean verboseLog = false;
    private boolean hasErrors = false;
    private BufferedWriter logWriter;
    private BufferedWriter stderrWriter = new BufferedWriter(new OutputStreamWriter(System.err));
    private EJBComplianceTextFormatter fmt = new EJBComplianceTextFormatter();

    public boolean getVerbose() {
        return this.verboseLog;
    }

    public void setVerbose(boolean bl) {
        this.verboseLog = bl;
    }

    public void logError(String string) {
        this.log(this.fmt.error());
        this.logln(" " + string);
        this.hasErrors = true;
    }

    public void logWarning(String string) {
        this.log(this.fmt.warning());
        this.logln(" " + string);
    }

    public void logInfo(String string) {
        this.logln(string);
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    private void logln(String string) {
        this.log(string);
        this.log("\n");
    }

    private void log(String string) {
        try {
            this.stderrWriter.write(string);
            this.stderrWriter.flush();
        }
        catch (IOException iOException) {
            System.err.println(this.fmt.logWriteError(string, StackTraceUtils.throwable2StackTrace((Throwable)iOException)));
        }
    }
}

