/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.compliance;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.MessageDrivenBean;
import javax.jms.Message;
import weblogic.ejb.container.compliance.BaseComplianceChecker;
import weblogic.ejb.container.compliance.ComplianceException;
import weblogic.ejb.container.compliance.ComplianceUtils;
import weblogic.ejb.container.compliance.TimeoutCheckHelper;
import weblogic.ejb.container.dd.xml.DDUtils;
import weblogic.ejb.container.interfaces.BeanInfo;
import weblogic.ejb.container.interfaces.MessageDrivenBeanInfo;
import weblogic.ejb.container.interfaces.MethodInfo;
import weblogic.ejb.container.utils.ClassUtils;
import weblogic.ejb20.dd.DescriptorErrorInfo;
import weblogic.utils.ErrorCollectionException;

public class MessageDrivenBeanClassChecker
extends BaseComplianceChecker {
    private Class m_beanClass;
    private String m_ejbName;
    private MessageDrivenBeanInfo m_beanInfo;
    private Class messagingTypeClass;

    public MessageDrivenBeanClassChecker(BeanInfo beanInfo) {
        this.m_beanInfo = (MessageDrivenBeanInfo)beanInfo;
        this.m_beanClass = beanInfo.getBeanClass();
        this.m_ejbName = beanInfo.getEJBName();
        this.messagingTypeClass = ((MessageDrivenBeanInfo)beanInfo).getMessagingTypeInterfaceClass();
    }

    public void checkMessageDrivenImplementsMDB() throws ComplianceException {
        if (!this.m_beanInfo.isEJB30() && !MessageDrivenBean.class.isAssignableFrom(this.m_beanClass)) {
            throw new ComplianceException(this.fmt.BEAN_CLASS_IMPLEMENTS_MESSAGE_DRIVEN(this.m_ejbName));
        }
    }

    public void checkMessageDrivenImplementsMessageListener() throws ComplianceException {
        if (this.m_beanInfo.isEJB30()) {
            return;
        }
        if (!this.messagingTypeClass.isAssignableFrom(this.m_beanClass)) {
            throw new ComplianceException(this.fmt.BEAN_CLASS_IMPLEMENTS_MESSAGE_LISTENER(this.m_ejbName, this.m_beanInfo.getMessagingTypeInterfaceName()));
        }
    }

    public void checkMessageDrivenBeanClassIsPublic() throws ComplianceException {
        int n = this.m_beanClass.getModifiers();
        if (!Modifier.isPublic(n)) {
            throw new ComplianceException(this.fmt.PUBLIC_BEAN_CLASS(this.m_ejbName));
        }
    }

    public void checkMessageDrivenBeanClassIsNotFinal() throws ComplianceException {
        int n = this.m_beanClass.getModifiers();
        if (Modifier.isFinal(n)) {
            throw new ComplianceException(this.fmt.FINAL_BEAN_CLASS(this.m_ejbName));
        }
    }

    public void checkMessageDrivenBeanClassIsNotAbstract() throws ComplianceException {
        int n = this.m_beanClass.getModifiers();
        if (Modifier.isAbstract(n)) {
            throw new ComplianceException(this.fmt.ABSTRACT_BEAN_CLASS(this.m_ejbName));
        }
    }

    public void checkBeanClassDoesNotDefineFinalize() throws ComplianceException {
        try {
            Method method = this.m_beanClass.getMethod("finalize", null);
            throw new ComplianceException(this.fmt.NO_FINALIZE_IN_BEAN(this.m_ejbName));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return;
        }
    }

    public void checkBeanClassHasPublicNoArgCtor() throws ComplianceException {
        if (!ComplianceUtils.classHasPublicNoArgCtor(this.m_beanClass)) {
            throw new ComplianceException(this.fmt.PUBLIC_NOARG_BEAN_CTOR(this.m_ejbName));
        }
    }

    private void validateOnMessageMethod(Method method) throws ErrorCollectionException {
        Class<?>[] classArray;
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        int n = method.getModifiers();
        if (!Modifier.isPublic(n)) {
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.PUBLIC_ONMESSAGE(this.m_ejbName)));
        }
        if (Modifier.isFinal(n)) {
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.FINAL_ONMESSAGE(this.m_ejbName)));
        }
        if (Modifier.isStatic(n)) {
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.STATIC_ONMESSAGE(this.m_ejbName)));
        }
        if ((classArray = method.getParameterTypes()) == null || classArray.length != 1) {
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.SINGLE_ONMESSAGE_REQUIRED(this.m_ejbName)));
        } else if (!Message.class.isAssignableFrom(classArray[0])) {
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.ONMESSAGE_TAKES_MESSAGE(this.m_ejbName)));
        }
        if (!Void.TYPE.equals(method.getReturnType())) {
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.ONMESSAGE_RETURNS_VOID(this.m_ejbName)));
        }
        Class<?>[] classArray2 = method.getExceptionTypes();
        for (int i = 0; i < classArray2.length; ++i) {
            if (!ComplianceUtils.isApplicationException(classArray2[i])) continue;
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.ONMESSAGE_THROWS_APP_EXCEPTION(this.m_ejbName)));
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    private void validateMessagingTypeMethod(Method method) throws ErrorCollectionException {
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        String string = method.getName();
        int n = method.getModifiers();
        if (!Modifier.isPublic(n)) {
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.BUS_METHOD_NOT_PUBLIC(this.m_ejbName, string)));
        }
        if (Modifier.isFinal(n)) {
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.BUS_METHOD_MUST_NOT_FINAL(this.m_ejbName, string)));
        }
        if (Modifier.isStatic(n)) {
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.BUS_METHOD_MUST_NOT_STATIC(this.m_ejbName, string)));
        }
        Class<?>[] classArray = method.getExceptionTypes();
        for (int i = 0; i < classArray.length; ++i) {
            if (!ComplianceUtils.isApplicationException(classArray[i])) continue;
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.ONMESSAGE_THROWS_APP_EXCEPTION(this.m_ejbName)));
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    protected List getMessagingTypeMethods() {
        ArrayList<Method> arrayList = new ArrayList<Method>();
        if (this.messagingTypeClass != null) {
            Method[] methodArray = this.messagingTypeClass.getMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                arrayList.add(methodArray[i]);
            }
        }
        return arrayList;
    }

    public void checkMessagingTypeMethods() throws ErrorCollectionException, ComplianceException {
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        if (this.m_beanInfo.getIsWeblogicJMS()) {
            try {
                Method method = this.m_beanClass.getMethod("onMessage", Message.class);
                this.validateOnMessageMethod(method);
            }
            catch (ErrorCollectionException errorCollectionException2) {
                errorCollectionException.add((Throwable)errorCollectionException2);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                errorCollectionException.add((Throwable)new ComplianceException(this.fmt.BEAN_MUST_HAVE_ONMESSAGE(this.m_ejbName)));
            }
        } else {
            for (Method method : this.getMessagingTypeMethods()) {
                Method method2 = null;
                try {
                    method2 = ClassUtils.getDeclaredMethod(this.m_beanClass, method.getName(), method.getParameterTypes());
                    this.validateMessagingTypeMethod(method2);
                }
                catch (ErrorCollectionException errorCollectionException3) {
                    errorCollectionException.add((Throwable)errorCollectionException3);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    errorCollectionException.add((Throwable)new ComplianceException(this.fmt.MT_METHOD_DOESNT_EXIST_IN_BEAN(this.m_ejbName, DDUtils.getMethodSignature(method2))));
                }
            }
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    private void validateCreateMethod(Method method) throws ErrorCollectionException {
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        int n = method.getModifiers();
        if (!Modifier.isPublic(n)) {
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.PUBLIC_EJBCREATE(this.m_ejbName)));
        }
        if (Modifier.isFinal(n)) {
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.FINAL_EJBCREATE(this.m_ejbName)));
        }
        if (Modifier.isStatic(n)) {
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.STATIC_EJBCREATE(this.m_ejbName)));
        }
        if (!Void.TYPE.equals(method.getReturnType())) {
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.EJBCREATE_RETURNS_VOID(this.m_ejbName)));
        }
        if (!ComplianceUtils.methodTakesNoArgs(method)) {
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.MESSAGE_NOARG_EJBCREATE(this.m_ejbName)));
        }
        Class<?>[] classArray = method.getExceptionTypes();
        for (int i = 0; i < classArray.length; ++i) {
            if (!ComplianceUtils.isApplicationException(classArray[i])) continue;
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.MESSAGE_EJBCREATE_THROWS_APP_EXCEPTION(this.m_ejbName)));
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    public void checkEjbCreateMethod() throws ErrorCollectionException, ComplianceException {
        if (this.m_beanInfo.isEJB30()) {
            return;
        }
        try {
            Method method = this.m_beanClass.getMethod("ejbCreate", null);
            this.validateCreateMethod(method);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ComplianceException(this.fmt.MESSAGE_DEFINES_EJBCREATE(this.m_ejbName));
        }
    }

    private void validateRemoveMethod(Method method) throws ErrorCollectionException {
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        int n = method.getModifiers();
        if (!Modifier.isPublic(n)) {
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.PUBLIC_EJBREMOVE(this.m_ejbName)));
        }
        if (Modifier.isFinal(n)) {
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.FINAL_EJBREMOVE(this.m_ejbName)));
        }
        if (Modifier.isStatic(n)) {
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.STATIC_EJBREMOVE(this.m_ejbName)));
        }
        if (!Void.TYPE.equals(method.getReturnType())) {
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.EJBREMOVE_RETURNS_VOID(this.m_ejbName)));
        }
        if (!ComplianceUtils.methodTakesNoArgs(method)) {
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.MESSAGE_NOARG_EJBREMOVE(this.m_ejbName)));
        }
        Class<?>[] classArray = method.getExceptionTypes();
        for (int i = 0; i < classArray.length; ++i) {
            if (!ComplianceUtils.isApplicationException(classArray[i])) continue;
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.MESSAGE_EJBREMOVE_THROWS_APP_EXCEPTION(this.m_ejbName)));
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    public void checkEjbRemoveMethod() throws ErrorCollectionException, ComplianceException {
        if (this.m_beanInfo.isEJB30()) {
            return;
        }
        try {
            Method method = this.m_beanClass.getMethod("ejbRemove", null);
            this.validateRemoveMethod(method);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ComplianceException(this.fmt.MESSAGE_DEFINES_EJBREMOVE(this.m_ejbName));
        }
    }

    public void checkTimeoutMethods() throws ErrorCollectionException, ComplianceException {
        TimeoutCheckHelper.validateTimeoutMethod(this.m_beanInfo);
    }

    public void checkTransactionAttribute() throws ComplianceException {
        short s;
        MethodInfo methodInfo2;
        for (MethodInfo methodInfo2 : this.m_beanInfo.getAllMessagingTypeMethodInfos()) {
            s = methodInfo2.getTransactionAttribute();
            if (1 == s || 0 == s) continue;
            throw new ComplianceException(this.fmt.MESSAGE_BAD_TX_ATTRIBUTE(this.m_ejbName));
        }
        if (this.m_beanInfo.isTimerDriven() && 1 != (s = (methodInfo2 = this.m_beanInfo.getBeanMethodInfo(DDUtils.getMethodSignature(this.m_beanInfo.getTimeoutMethod().getName(), new String[]{"javax.ejb.Timer"}))).getTransactionAttribute()) && 3 != s && 0 != s) {
            throw new ComplianceException(this.fmt.EJB_TIMEOUT_BAD_TX_ATTRIBUTE(this.m_beanInfo.getDisplayName()));
        }
    }

    public void checkMaxBeansInFreePoolGreaterThanZero() throws ComplianceException {
        int n = this.m_beanInfo.getCachingDescriptor().getMaxBeansInFreePool();
        if (n <= 0) {
            throw new ComplianceException(this.fmt.MESSAGE_ILLEGAL_MAX_BEANS_IN_FREE_POOL(this.m_ejbName, n), new DescriptorErrorInfo("<max-beans-in-free-pool>", (Object)this.m_ejbName, null));
        }
    }
}

