/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.compliance;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import weblogic.ejb.container.compliance.BaseComplianceChecker;
import weblogic.ejb.container.compliance.ComplianceException;
import weblogic.ejb.container.interfaces.EntityBeanInfo;
import weblogic.ejb20.dd.DescriptorErrorInfo;
import weblogic.utils.AssertionError;

final class PKClassChecker
extends BaseComplianceChecker {
    private static final boolean debug = false;
    private static final boolean verbose = false;
    private EntityBeanInfo ebi;
    private Class pkClass;
    private String ejbName;
    private boolean isCMP;
    private boolean isCompoundCMPPK;
    private Class[] wrapperClasses = new Class[]{Boolean.class, Byte.class, Character.class, Double.class, Float.class, Integer.class, Long.class, Short.class, String.class};

    PKClassChecker(EntityBeanInfo entityBeanInfo) throws ClassNotFoundException {
        this.ebi = entityBeanInfo;
        this.pkClass = entityBeanInfo.getPrimaryKeyClass();
        this.ejbName = entityBeanInfo.getEJBName();
        boolean bl = this.isCMP = !entityBeanInfo.getIsBeanManagedPersistence();
        if (this.isCMP) {
            this.isCompoundCMPPK = !entityBeanInfo.isUnknownPrimaryKey() && entityBeanInfo.getCMPInfo().getCMPrimaryKeyFieldName() == null;
        }
    }

    private boolean isWrapperClass(Class clazz) {
        for (int i = 0; i < this.wrapperClasses.length; ++i) {
            if (!clazz.equals(this.wrapperClasses[i])) continue;
            return true;
        }
        return false;
    }

    public void checkPrimitivePKHasFieldSet() throws ComplianceException {
        if (this.isCMP && this.isWrapperClass(this.pkClass) && this.ebi.getCMPInfo().getCMPrimaryKeyFieldName() == null) {
            throw new ComplianceException(this.fmt.PRIMARY_KEY_WITHOUT_PRIMKEY_FIELD(this.pkClass.getName(), this.ejbName), new DescriptorErrorInfo("<primkey-field>", (Object)this.ejbName, (Object)this.pkClass.getName()));
        }
    }

    public void checkPKImplementsHashCode() throws ComplianceException {
        if (Object.class.equals((Object)this.pkClass)) {
            return;
        }
        try {
            Method method = this.pkClass.getMethod("hashCode", null);
            if (Object.class.equals(method.getDeclaringClass())) {
                throw new ComplianceException(this.fmt.PK_MUST_IMPLEMENT_HASHCODE(this.ejbName));
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError("hashCode() not found?!");
        }
    }

    public void checkPKImplementsEquals() throws ComplianceException {
        if (Object.class.equals((Object)this.pkClass)) {
            return;
        }
        try {
            Method method = this.pkClass.getMethod("equals", Object.class);
            if (Object.class.equals(method.getDeclaringClass())) {
                throw new ComplianceException(this.fmt.PK_MUST_IMPLEMENT_EQUALS(this.ejbName));
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError("equals(Object) not found?!");
        }
    }

    public void checkPKImplementsSerializable() throws ComplianceException {
        if (Object.class.equals((Object)this.pkClass)) {
            return;
        }
        if (!Serializable.class.isAssignableFrom(this.pkClass)) {
            throw new ComplianceException(this.fmt.CMP_PK_MUST_IMPLEMENT_SERIALIZABLE(this.ejbName));
        }
    }

    public void checkPKClassNotObject() throws ComplianceException {
        if (this.isCMP && !this.ebi.getCMPInfo().uses20CMP() && Object.class.equals((Object)this.pkClass)) {
            throw new ComplianceException(this.fmt.CMP_PK_CANNOT_BE_JAVA_LANG_OBJECT(this.ejbName));
        }
    }

    public void checkCMPPublicPK() throws ComplianceException {
        int n;
        if (this.isCMP && this.isCompoundCMPPK && !Modifier.isPublic(n = this.pkClass.getModifiers())) {
            throw new ComplianceException(this.fmt.CMP_PK_MUST_BE_PUBLIC(this.ejbName, this.pkClass.getName()));
        }
    }

    public void checkCMPPKDefaultNoArgConstructor() throws ComplianceException {
        if (this.isCMP && this.isCompoundCMPPK) {
            Constructor constructor = null;
            try {
                constructor = this.pkClass.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new ComplianceException(this.fmt.CMP_PK_MUST_HAVE_NOARG_CONSTRUCTOR(this.ejbName, this.pkClass.getName()));
            }
            int n = constructor.getModifiers();
            if (!Modifier.isPublic(n)) {
                throw new ComplianceException(this.fmt.CMP_PK_MUST_HAVE_NOARG_CONSTRUCTOR(this.ejbName, this.pkClass.getName()));
            }
        }
    }

    public void checkCMPFieldsModifiers() throws ComplianceException {
        if (this.isCMP && this.isCompoundCMPPK) {
            Collection collection = this.ebi.getCMPInfo().getAllContainerManagedFieldNames();
            Field[] fieldArray = this.pkClass.getFields();
            if (fieldArray == null || fieldArray.length == 0) {
                throw new ComplianceException(this.fmt.PK_FIELD_CLASS_MUST_HAVE_ATLEAST_ONE_CMP_FIELD(this.ejbName, this.pkClass.getName()));
            }
            boolean bl = false;
            for (int i = 0; i < fieldArray.length; ++i) {
                Field field = fieldArray[i];
                if (field.getName().equals("serialVersionUID") || !collection.contains(fieldArray[i].getName())) continue;
                bl = true;
                int n = field.getModifiers();
                if (!Modifier.isPublic(n)) {
                    throw new ComplianceException(this.fmt.PK_FIELDS_MUST_BE_PUBLIC(this.ejbName, this.pkClass.getName(), field.getName()));
                }
                if (!Modifier.isStatic(n) || Modifier.isFinal(n)) continue;
                throw new ComplianceException(this.fmt.PK_FIELDS_MUST_NOT_BE_STATIC(this.ejbName, this.pkClass.getName(), field.getName()));
            }
            if (!bl) {
                if (fieldArray.length > 0) {
                    throw new ComplianceException(this.fmt.FIELDS_IN_PK_CLASS_SHOULD_BE_CMP_FIELDS(this.ejbName, this.pkClass.getName()));
                }
                throw new ComplianceException(this.fmt.PK_FIELD_CLASS_MUST_HAVE_ATLEAST_ONE_CMP_FIELD(this.ejbName, this.pkClass.getName()));
            }
        }
    }
}

