/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.compliance;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import weblogic.ejb.container.compliance.BaseComplianceChecker;
import weblogic.ejb.container.compliance.ComplianceException;
import weblogic.ejb.container.interfaces.BeanInfo;
import weblogic.ejb.container.interfaces.CMPInfo;
import weblogic.ejb.container.interfaces.DeploymentInfo;
import weblogic.ejb.container.interfaces.EntityBeanInfo;
import weblogic.ejb.container.persistence.PersistenceUtils;
import weblogic.ejb.container.persistence.spi.CmrField;
import weblogic.ejb.container.persistence.spi.EjbRelation;
import weblogic.ejb.container.persistence.spi.EjbRelationshipRole;
import weblogic.ejb.container.persistence.spi.Relationships;
import weblogic.ejb.container.persistence.spi.RoleSource;
import weblogic.ejb.container.utils.MethodUtils;
import weblogic.ejb20.dd.DescriptorErrorInfo;
import weblogic.utils.Debug;
import weblogic.utils.ErrorCollectionException;

public final class RelationChecker
extends BaseComplianceChecker {
    private static final boolean debug = System.getProperty("weblogic.ejb.container.persistence.debug") != null;
    private static final boolean verbose = System.getProperty("weblogic.ejb.container.persistence.verbose") != null;
    private EjbRelation rel;
    private EjbRelationshipRole role1;
    private EjbRelationshipRole role2;
    private RoleSource src1;
    private RoleSource src2;
    private CmrField field1;
    private CmrField field2;
    private DeploymentInfo di;
    private Relationships relationships;
    private Map ejbEntityRefs;
    private Map methods1;
    private Map methods2;

    public RelationChecker(EjbRelation ejbRelation, DeploymentInfo deploymentInfo) {
        this.rel = ejbRelation;
        this.di = deploymentInfo;
        Iterator iterator = ejbRelation.getAllEjbRelationshipRoles().iterator();
        this.role1 = (EjbRelationshipRole)iterator.next();
        this.role2 = (EjbRelationshipRole)iterator.next();
        this.src1 = this.role1.getRoleSource();
        this.src2 = this.role2.getRoleSource();
        this.field1 = this.role1.getCmrField();
        this.field2 = this.role2.getCmrField();
        this.relationships = deploymentInfo.getRelationships();
        this.ejbEntityRefs = this.relationships.getAllEjbEntityRefs();
        if (this.ejbEntityRefs == null) {
            this.ejbEntityRefs = new HashMap();
        }
        if (verbose) {
            Debug.say((String)("constructed RelationChecker for: " + ejbRelation.getEjbRelationName()));
        }
    }

    public void checkRelation() throws ErrorCollectionException {
        this.checkLocalBeanInRoleExists();
        this.checkLocalBeanInRoleIsEntityBean();
        this.checkLocalBeanInRoleNotBM();
        this.checkLocalBeanInRoleUses20CMP();
        this.checkAtLeastUniDirectional();
        this.checkCmrFieldNotACmpField();
        this.checkManyHasType();
        this.check1ManyNoDupFieldForSameBean();
        this.checkCmrFieldExists();
        this.checkEjbCascadeDelete();
    }

    private void check1ManyNoDupFieldForSameBean() throws ErrorCollectionException {
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        int n = 0;
        int n2 = 0;
        if (this.role1.getMultiplicity().equalsIgnoreCase("one")) {
            ++n;
        } else if (this.role1.getMultiplicity().equalsIgnoreCase("many")) {
            ++n2;
        }
        if (this.role2.getMultiplicity().equalsIgnoreCase("one")) {
            ++n;
        } else if (this.role2.getMultiplicity().equalsIgnoreCase("many")) {
            ++n2;
        }
        if (n == 1 && n2 == 1 && this.src1.getEjbName().compareTo(this.src2.getEjbName()) == 0 && this.field1 != null && this.field2 != null && this.field1.getName().compareTo(this.field2.getName()) == 0) {
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.N1_RELATION_HAS_DUP_FIELD_FOR_SAME_BEAN(this.rel.getEjbRelationName() + " <cmr-field>: " + this.field1.getName()), new DescriptorErrorInfo("<cmr-field>", (Object)this.rel.getEjbRelationName(), (Object)this.rel.getEjbRelationName())));
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    private void checkLocalBeanInRoleExists() throws ErrorCollectionException {
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        if (this.di.getBeanInfo(this.src1.getEjbName()) == null) {
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.NON_EXISTENT_BEAN_IN_ROLE(this.src1.getEjbName(), this.rel.getEjbRelationName()), new DescriptorErrorInfo("<relationship-role-source>", (Object)this.rel.getEjbRelationName(), (Object)this.src1.getEjbName())));
        }
        if (this.di.getBeanInfo(this.src2.getEjbName()) == null) {
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.NON_EXISTENT_BEAN_IN_ROLE(this.src2.getEjbName(), this.rel.getEjbRelationName()), new DescriptorErrorInfo("<relationship-role-source>", (Object)this.rel.getEjbRelationName(), (Object)this.src2.getEjbName())));
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    private void checkLocalBeanInRoleIsEntityBean() throws ErrorCollectionException {
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        BeanInfo beanInfo = this.di.getBeanInfo(this.src1.getEjbName());
        if (!(beanInfo instanceof EntityBeanInfo)) {
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.NON_ENTITY_BEAN_IN_ROLE(this.rel.getEjbRelationName()), new DescriptorErrorInfo("<relationship-role-source>", (Object)this.rel.getEjbRelationName(), (Object)this.src1.getEjbName())));
        }
        if (!((beanInfo = this.di.getBeanInfo(this.src2.getEjbName())) instanceof EntityBeanInfo)) {
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.NON_ENTITY_BEAN_IN_ROLE(this.rel.getEjbRelationName()), new DescriptorErrorInfo("<relationship-role-source>", (Object)this.rel.getEjbRelationName(), (Object)this.src2.getEjbName())));
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    private void checkLocalBeanInRoleNotBM() throws ErrorCollectionException {
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        EntityBeanInfo entityBeanInfo = (EntityBeanInfo)this.di.getBeanInfo(this.src1.getEjbName());
        if (entityBeanInfo.getIsBeanManagedPersistence()) {
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.BM_BEAN_IN_ROLE(this.rel.getEjbRelationName()), new DescriptorErrorInfo("<relationship-role-source>", (Object)this.rel.getEjbRelationName(), (Object)this.src1.getEjbName())));
        }
        if ((entityBeanInfo = (EntityBeanInfo)this.di.getBeanInfo(this.src2.getEjbName())).getIsBeanManagedPersistence()) {
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.BM_BEAN_IN_ROLE(this.rel.getEjbRelationName()), new DescriptorErrorInfo("<relationship-role-source>", (Object)this.rel.getEjbRelationName(), (Object)this.src2.getEjbName())));
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    private void checkLocalBeanInRoleUses20CMP() throws ErrorCollectionException {
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        EntityBeanInfo entityBeanInfo = (EntityBeanInfo)this.di.getBeanInfo(this.src1.getEjbName());
        CMPInfo cMPInfo = entityBeanInfo.getCMPInfo();
        if (!cMPInfo.uses20CMP()) {
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.CMP11_BEAN_IN_ROLE(this.rel.getEjbRelationName()), new DescriptorErrorInfo("<relationship-role-source>", (Object)this.rel.getEjbRelationName(), (Object)this.src1.getEjbName())));
        }
        if (!(cMPInfo = (entityBeanInfo = (EntityBeanInfo)this.di.getBeanInfo(this.src2.getEjbName())).getCMPInfo()).uses20CMP()) {
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.CMP11_BEAN_IN_ROLE(this.rel.getEjbRelationName()), new DescriptorErrorInfo("<relationship-role-source>", (Object)this.rel.getEjbRelationName(), (Object)this.src2.getEjbName())));
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    private void checkAtLeastUniDirectional() throws ErrorCollectionException {
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        if (this.field1 == null && this.field2 == null) {
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.FIELD_NOT_DEFINED_FOR_ROLE(this.rel.getEjbRelationName()), new DescriptorErrorInfo("<cmr-field>", (Object)this.rel.getEjbRelationName(), (Object)this.rel.getEjbRelationName())));
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    private void checkManyRoleHasType(EjbRelationshipRole ejbRelationshipRole, EjbRelationshipRole ejbRelationshipRole2, ErrorCollectionException errorCollectionException) {
        CmrField cmrField = ejbRelationshipRole.getCmrField();
        if (ejbRelationshipRole2.getMultiplicity().equalsIgnoreCase("many") && cmrField != null && cmrField.getType() == null) {
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.COLLECTION_FIELD_HAS_NO_TYPE(this.rel.getEjbRelationName()), new DescriptorErrorInfo("<cmr-field>", (Object)this.rel.getEjbRelationName(), (Object)this.rel.getEjbRelationName())));
        }
    }

    private void checkOneRoleHasNoType(EjbRelationshipRole ejbRelationshipRole, EjbRelationshipRole ejbRelationshipRole2, ErrorCollectionException errorCollectionException) {
        CmrField cmrField = ejbRelationshipRole.getCmrField();
        if (ejbRelationshipRole2.getMultiplicity().equalsIgnoreCase("one") && cmrField != null && cmrField.getType() != null) {
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.SINGLETON_FIELD_HAS_TYPE(this.rel.getEjbRelationName()), new DescriptorErrorInfo("<cmr-field>", (Object)this.rel.getEjbRelationName(), (Object)this.rel.getEjbRelationName())));
        }
    }

    private void checkManyHasType() throws ErrorCollectionException {
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        this.checkManyRoleHasType(this.role1, this.role2, errorCollectionException);
        this.checkManyRoleHasType(this.role2, this.role1, errorCollectionException);
        this.checkOneRoleHasNoType(this.role1, this.role2, errorCollectionException);
        this.checkOneRoleHasNoType(this.role2, this.role1, errorCollectionException);
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    private void checkThatRoleFieldExistsOnBean(CmrField cmrField, RoleSource roleSource, RoleSource roleSource2, ErrorCollectionException errorCollectionException) {
        if (cmrField != null) {
            int n;
            Object object;
            EntityBeanInfo entityBeanInfo = (EntityBeanInfo)this.di.getBeanInfo(roleSource.getEjbName());
            Class clazz = entityBeanInfo.getBeanClass();
            String string = entityBeanInfo.getEJBName();
            String string2 = cmrField.getName();
            String string3 = MethodUtils.getMethodName(string2);
            boolean bl = false;
            CMPInfo cMPInfo = entityBeanInfo.getCMPInfo();
            assert (cMPInfo != null);
            if (cMPInfo != null) {
                bl = cMPInfo.isBeanClassAbstract();
            }
            Class<Object> clazz2 = null;
            clazz2 = cmrField.getType() == null ? ((object = (EntityBeanInfo)this.di.getBeanInfo(roleSource2.getEjbName())).hasLocalClientView() ? object.getLocalInterfaceClass() : (object.hasRemoteClientView() ? object.getRemoteInterfaceClass() : object.getBeanClass())) : (cmrField.getType().equals("java.util.Collection") ? Collection.class : Set.class);
            object = null;
            object = PersistenceUtils.getMethodIncludeSuper(clazz, string3, new Class[0]);
            if (object == null) {
                errorCollectionException.add((Throwable)new ComplianceException(this.fmt.GET_METHOD_NOT_DEFINED_FOR_ROLE(string, string3, this.rel.getEjbRelationName()), new DescriptorErrorInfo("<cmr-field>", (Object)this.rel.getEjbRelationName(), (Object)string3)));
            }
            if (object != null && !((Method)object).getReturnType().equals(clazz2)) {
                errorCollectionException.add((Throwable)new ComplianceException(this.fmt.GET_METHOD_HAS_WRONG_RETURN_TYPE(string, string3, this.rel.getEjbRelationName())));
            }
            if (object != null && !Modifier.isAbstract(n = ((Method)object).getModifiers()) && bl) {
                errorCollectionException.add((Throwable)new ComplianceException(this.fmt.GET_METHOD_IS_NOT_ABSTRACT(string, string3, this.rel.getEjbRelationName())));
            }
            if (object != null && !Modifier.isPublic(n = ((Method)object).getModifiers())) {
                errorCollectionException.add((Throwable)new ComplianceException(this.fmt.GET_METHOD_IS_NOT_PUBLIC(string, string3, this.rel.getEjbRelationName())));
            }
            if ((object = PersistenceUtils.getMethodIncludeSuper(clazz, string3 = MethodUtils.setMethodName(string2), new Class[]{clazz2})) == null) {
                errorCollectionException.add((Throwable)new ComplianceException(this.fmt.SET_METHOD_NOT_DEFINED_FOR_ROLE(string, string3, this.rel.getEjbRelationName()), new DescriptorErrorInfo("<cmr-field>", (Object)this.rel.getEjbRelationName(), (Object)string3)));
            }
            if (object != null && !((Method)object).getReturnType().equals(Void.TYPE)) {
                errorCollectionException.add((Throwable)new ComplianceException(this.fmt.SET_METHOD_HAS_WRONG_RETURN_TYPE(string, string3, this.rel.getEjbRelationName())));
            }
            if (object != null && !Modifier.isAbstract(n = ((Method)object).getModifiers()) && bl) {
                errorCollectionException.add((Throwable)new ComplianceException(this.fmt.SET_METHOD_IS_NOT_ABSTRACT(string, string3, this.rel.getEjbRelationName())));
            }
            if (object != null && !Modifier.isPublic(n = ((Method)object).getModifiers())) {
                errorCollectionException.add((Throwable)new ComplianceException(this.fmt.SET_METHOD_IS_NOT_PUBLIC(string, string3, this.rel.getEjbRelationName())));
            }
        }
    }

    private void checkCmrFieldExists() throws ErrorCollectionException {
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        this.checkThatRoleFieldExistsOnBean(this.field1, this.src1, this.src2, errorCollectionException);
        this.checkThatRoleFieldExistsOnBean(this.field2, this.src2, this.src1, errorCollectionException);
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    private void checkCmrFieldNotCmp(CmrField cmrField, RoleSource roleSource, ErrorCollectionException errorCollectionException) {
        String string;
        EntityBeanInfo entityBeanInfo;
        CMPInfo cMPInfo;
        Collection collection;
        if (cmrField != null && (collection = (cMPInfo = (entityBeanInfo = (EntityBeanInfo)this.di.getBeanInfo(roleSource.getEjbName())).getCMPInfo()).getAllContainerManagedFieldNames()).contains(string = cmrField.getName())) {
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.CMR_FIELD_SAME_AS_CMP_FIELD(this.rel.getEjbRelationName()), new DescriptorErrorInfo("<cmr-field>", (Object)this.rel.getEjbRelationName(), (Object)this.rel.getEjbRelationName())));
        }
    }

    private void checkCmrFieldNotACmpField() throws ErrorCollectionException {
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        this.checkCmrFieldNotCmp(this.field1, this.src1, errorCollectionException);
        this.checkCmrFieldNotCmp(this.field2, this.src2, errorCollectionException);
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    private void checkEjbCascadeDelete() throws ErrorCollectionException {
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        if (this.role1.getMultiplicity().equalsIgnoreCase("many") && this.role2.getCascadeDelete()) {
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.CASCADE_DELETE_CANNOT_BE_SPECIFIED(this.role2.getName()), new DescriptorErrorInfo("<ejb-relationship-role>", (Object)this.rel.getEjbRelationName(), (Object)this.role2.getName())));
        }
        if (this.role2.getMultiplicity().equalsIgnoreCase("many") && this.role1.getCascadeDelete()) {
            errorCollectionException.add((Throwable)new ComplianceException(this.fmt.CASCADE_DELETE_CANNOT_BE_SPECIFIED(this.role1.getName()), new DescriptorErrorInfo("<ejb-relationship-role>", (Object)this.rel.getEjbRelationName(), (Object)this.role1.getName())));
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }
}

