/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.compliance;

import java.util.Collection;
import weblogic.ejb.container.compliance.BaseComplianceChecker;
import weblogic.ejb.container.compliance.ComplianceException;
import weblogic.ejb.container.interfaces.BeanInfo;
import weblogic.ejb.container.interfaces.DeploymentInfo;
import weblogic.ejb.container.interfaces.SecurityRoleMapping;
import weblogic.ejb.container.interfaces.SecurityRoleReference;
import weblogic.utils.ErrorCollectionException;

public final class SecurityRoleChecker
extends BaseComplianceChecker {
    private static final boolean debug = false;
    private static final boolean verbose = false;
    private DeploymentInfo di;

    public SecurityRoleChecker(DeploymentInfo deploymentInfo) {
        this.di = deploymentInfo;
    }

    public void checkSecurityRoleRefLinks() throws ErrorCollectionException {
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        Collection collection = this.di.getBeanInfos();
        for (BeanInfo beanInfo : collection) {
            Collection collection2 = beanInfo.getAllSecurityRoleReferences();
            for (SecurityRoleReference securityRoleReference : collection2) {
                String string = securityRoleReference.getReferencedRole();
                if (string == null) {
                    log.logWarning(this.fmt.NULL_SECURITY_ROLE_REF_LINK(beanInfo.getEJBName(), securityRoleReference.getRoleName()));
                    continue;
                }
                SecurityRoleMapping securityRoleMapping = this.di.getDeploymentRoles();
                if (securityRoleMapping.hasRole(string)) continue;
                errorCollectionException.add((Throwable)new ComplianceException(this.fmt.INVALID_SECURITY_ROLE_REF_LINK(beanInfo.getEJBName(), securityRoleReference.getRoleName())));
            }
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }
}

