/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.compliance;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.EJBContext;
import javax.ejb.SessionBean;
import weblogic.ejb.container.compliance.BeanClassChecker;
import weblogic.ejb.container.compliance.ComplianceException;
import weblogic.ejb.container.compliance.ComplianceUtils;
import weblogic.ejb.container.compliance.EJBComplianceTextFormatter;
import weblogic.ejb.container.interfaces.ClientDrivenBeanInfo;
import weblogic.ejb.container.interfaces.SessionBeanInfo;
import weblogic.utils.ErrorCollectionException;

class SessionBeanClassChecker
extends BeanClassChecker {
    private boolean isStateful;
    private boolean isStateless;

    SessionBeanClassChecker(ClientDrivenBeanInfo clientDrivenBeanInfo) throws ClassNotFoundException {
        super(clientDrivenBeanInfo);
        SessionBeanInfo sessionBeanInfo = (SessionBeanInfo)clientDrivenBeanInfo;
        this.isStateful = sessionBeanInfo.isStateful();
        this.isStateless = !this.isStateful;
    }

    public void checkEJBContextIsNotTransient() throws ComplianceException {
        for (Class clazz = this.beanClass; clazz != null && !clazz.equals(Object.class); clazz = clazz.getSuperclass()) {
            Field[] fieldArray = clazz.getDeclaredFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                Class<?> clazz2 = fieldArray[i].getType();
                if (!EJBContext.class.isAssignableFrom(clazz2)) continue;
                if (Modifier.isTransient(fieldArray[i].getModifiers())) {
                    throw new ComplianceException(this.fmt.EJBCONTEXT_IS_TRANSIENT(this.ejbName));
                }
                if (ComplianceUtils.isLegalRMIIIOPType(clazz2)) continue;
                throw new ComplianceException(this.fmt.NOT_RMIIIOP_LEGAL_TYPE_20(this.ejbName));
            }
        }
    }

    public void checkClassImplementsSessionBean() throws ComplianceException {
        if (!this.beanInfo.isEJB30() && !SessionBean.class.isAssignableFrom(this.beanClass)) {
            throw new ComplianceException(this.fmt.BEAN_IMPLEMENT_SESSIONBEAN(this.ejbName));
        }
    }

    public void checkStatelessEjbCreate() throws ComplianceException, ErrorCollectionException {
        if (this.beanInfo.isEJB30()) {
            return;
        }
        if (!this.beanInfo.hasDeclaredRemoteHome() && !this.beanInfo.hasDeclaredLocalHome()) {
            return;
        }
        if (this.isStateful) {
            return;
        }
        List list = this.getCreateMethods();
        if (list.size() != 1) {
            throw new ComplianceException(this.fmt.STATELESS_NOARG_EJBCREATE(this.ejbName));
        }
        try {
            Method method = this.beanClass.getMethod("ejbCreate", null);
            ArrayList<Method> arrayList = new ArrayList<Method>();
            arrayList.add(method);
            this.validateEjbCreates(arrayList);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ComplianceException(this.fmt.STATELESS_NOARG_EJBCREATE(this.ejbName));
        }
    }

    public void checkBeanClassIsNotAbstract() throws ComplianceException {
        if (Modifier.isAbstract(this.beanClassMod)) {
            throw new ComplianceException(this.fmt.ABSTRACT_BEAN_CLASS(this.ejbName));
        }
    }

    public void checkStatefulEjbCreate() throws ErrorCollectionException, ComplianceException {
        if (this.beanInfo.isEJB30()) {
            return;
        }
        if (!this.beanInfo.hasDeclaredRemoteHome() && !this.beanInfo.hasDeclaredLocalHome()) {
            return;
        }
        if (this.isStateless) {
            return;
        }
        List list = this.getCreateMethods();
        if (list.size() == 0) {
            throw new ComplianceException(this.fmt.STATEFUL_DEFINE_EJBCREATE(this.ejbName));
        }
        this.validateEjbCreates(list);
    }

    public void checkInterfacesExist() throws ErrorCollectionException, ComplianceException {
        SessionBeanInfo sessionBeanInfo = (SessionBeanInfo)this.beanInfo;
        if (sessionBeanInfo.isEndpointView()) {
            return;
        }
        if (sessionBeanInfo.getLocalInterfaceName() == null && sessionBeanInfo.getRemoteInterfaceName() == null && sessionBeanInfo.getServiceEndpointName() == null) {
            if (sessionBeanInfo.isEJB30()) {
                if ((sessionBeanInfo.getBusinessLocals() == null || sessionBeanInfo.getBusinessLocals().isEmpty()) && (sessionBeanInfo.getBusinessRemotes() == null || sessionBeanInfo.getBusinessRemotes().isEmpty())) {
                    throw new ComplianceException(EJBComplianceTextFormatter.getInstance().BUSINESS_INTERFACE_NOT_FOUND_IN_SESSION_BEAN(this.ejbName));
                }
            } else {
                throw new ComplianceException(EJBComplianceTextFormatter.getInstance().COMPONENT_INTERFACE_NOT_FOUND_IN_SESSION_BEAN(this.ejbName));
            }
        }
    }

    protected void validateCreateReturnType(Method method) throws ComplianceException {
        if (!method.getReturnType().isAssignableFrom(Void.TYPE)) {
            throw new ComplianceException(this.fmt.EJBCREATE_RETURNS_VOID(this.ejbName));
        }
    }
}

