/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.compliance;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import weblogic.ejb.container.compliance.ComplianceException;
import weblogic.ejb.container.compliance.ComplianceUtils;
import weblogic.ejb.container.compliance.HomeInterfaceChecker;
import weblogic.ejb.container.interfaces.ClientDrivenBeanInfo;
import weblogic.ejb.container.interfaces.SessionBeanInfo;

final class SessionHomeInterfaceChecker
extends HomeInterfaceChecker {
    private final boolean isStateful;
    private final boolean isStateless;
    private SessionBeanInfo sbi;

    SessionHomeInterfaceChecker(Class clazz, Class clazz2, Class clazz3, ClientDrivenBeanInfo clientDrivenBeanInfo, Class clazz4) {
        super(clazz, clazz2, clazz3, clientDrivenBeanInfo, clazz4);
        this.sbi = (SessionBeanInfo)clientDrivenBeanInfo;
        this.isStateful = this.sbi.isStateful();
        this.isStateless = !this.isStateful;
    }

    public void checkStatefulCreates() throws ComplianceException {
        if (this.isStateless) {
            return;
        }
        List list = this.getCreateMethods();
        if (list.size() == 0) {
            if (this.checkingRemoteClientView()) {
                throw new ComplianceException(this.fmt.STATEFUL_HOME_CREATE(this.ejbName));
            }
            throw new ComplianceException(this.fmt.STATEFUL_LOCAL_HOME_CREATE(this.ejbName));
        }
    }

    public void checkStatelessNoArgCreate() throws ComplianceException {
        if (this.isStateful) {
            return;
        }
        List list = this.getCreateMethods();
        if (list.size() != 1) {
            if (this.checkingRemoteClientView()) {
                throw new ComplianceException(this.fmt.STATELESS_HOME_NOARG_CREATE(this.ejbName));
            }
            throw new ComplianceException(this.fmt.STATELESS_LOCAL_HOME_NOARG_CREATE(this.ejbName));
        }
        Method method = (Method)list.get(0);
        if (!"create".equals(method.getName())) {
            if (this.checkingRemoteClientView()) {
                throw new ComplianceException(this.fmt.STATELESS_HOME_NOARG_CREATE(this.ejbName));
            }
            throw new ComplianceException(this.fmt.STATELESS_LOCAL_HOME_NOARG_CREATE(this.ejbName));
        }
        if (!ComplianceUtils.methodTakesNoArgs(method)) {
            if (this.checkingRemoteClientView()) {
                throw new ComplianceException(this.fmt.STATELESS_HOME_NOARG_CREATE(this.ejbName));
            }
            throw new ComplianceException(this.fmt.STATELESS_LOCAL_HOME_NOARG_CREATE(this.ejbName));
        }
    }

    public void checkNoHomeMethods() throws ComplianceException {
        List list = this.getHomeMethods();
        list.addAll(this.getHomeInterfaceHomeMethods());
        if (list.size() > 0) {
            Iterator iterator = list.iterator();
            String string = ((Method)iterator.next()).getName();
            throw new ComplianceException(this.fmt.HOME_METHODS_NOT_ALLOWED_ON_SESSION_20(this.ejbName, this.methodSig(string)));
        }
    }

    protected List getHomeInterfaceHomeMethods() {
        List list = super.getHomeInterfaceHomeMethods();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Method method = (Method)iterator.next();
            if (!method.getName().equals("remove")) continue;
            iterator.remove();
        }
        return list;
    }
}

