/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.compliance;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import javax.ejb.TimedObject;
import javax.ejb.Timer;
import weblogic.ejb.container.compliance.ComplianceException;
import weblogic.ejb.container.compliance.ComplianceUtils;
import weblogic.ejb.container.compliance.EJBComplianceTextFormatter;
import weblogic.ejb.container.dd.xml.DDUtils;
import weblogic.ejb.container.interfaces.BeanInfo;
import weblogic.ejb.container.interfaces.SessionBeanInfo;
import weblogic.utils.ErrorCollectionException;

public final class TimeoutCheckHelper {
    public static void validateTimeoutMethodsIdentical(Method method, Method method2) throws ComplianceException {
        if (method != null && method2 != null && !method.equals(method2)) {
            throw new ComplianceException(EJBComplianceTextFormatter.getInstance().TIMEOUT_IN_DD_NOT_COMPATIBLE_WITH_ANNOTATION());
        }
    }

    public static void validateOnlyOneTimeoutMethod(Collection collection) throws ComplianceException {
        if (collection == null) {
            return;
        }
        if (collection.size() > 1) {
            throw new ComplianceException(EJBComplianceTextFormatter.getInstance().BEAN_CAN_HAVE_ONE_TIMEOUT_METHOD());
        }
    }

    public static void validateTimeoutMethodIsejbTimeout(Class clazz, Method method) throws ComplianceException {
        if (method == null) {
            return;
        }
        if (TimedObject.class.isAssignableFrom(clazz) && !method.getName().equals("ejbTimeout")) {
            throw new ComplianceException(EJBComplianceTextFormatter.getInstance().TIMEOUT_CAN_ONLY_SPECIFY_EJBTIMEOUT_METHOD(clazz.getSimpleName()));
        }
    }

    public static void validateTimeoutMethodExistsInBC(Method method, Class clazz, String string) throws ComplianceException {
        if (method == null) {
            EJBComplianceTextFormatter eJBComplianceTextFormatter = new EJBComplianceTextFormatter();
            throw new ComplianceException(eJBComplianceTextFormatter.EJB_TIMEOUT_METHOD_NOT_FOUND(clazz.getSimpleName(), DDUtils.getMethodSignature(string, new String[]{"javax.ejb.Timer"})));
        }
    }

    public static void validateTimeoutMethod(BeanInfo beanInfo) throws ComplianceException, ErrorCollectionException {
        int n;
        SessionBeanInfo sessionBeanInfo;
        Method method = beanInfo.getTimeoutMethod();
        if (method == null) {
            return;
        }
        String string = beanInfo.getEJBName();
        Class clazz = beanInfo.getBeanClass();
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        if (beanInfo.isSessionBean() && (sessionBeanInfo = (SessionBeanInfo)beanInfo).isStateful()) {
            errorCollectionException.add((Throwable)new ComplianceException(EJBComplianceTextFormatter.getInstance().STATEFULE_BEAN_CANNOT_IMPLEMENTS_TIMEOUT()));
        }
        if (Modifier.isFinal(n = method.getModifiers()) || Modifier.isStatic(n)) {
            errorCollectionException.add((Throwable)new ComplianceException(EJBComplianceTextFormatter.getInstance().TIMEOUT_METHOD_CANNOT_BE_FINAL_OR_STATIC(string)));
        }
        TimeoutCheckHelper.validateTimeoutMethodIsejbTimeout(clazz, method);
        if (beanInfo.isEJB30()) {
            Class<?>[] classArray = method.getParameterTypes();
            if (classArray.length != 1 || !Timer.class.equals(classArray[0]) || !method.getReturnType().isAssignableFrom(Void.TYPE)) {
                errorCollectionException.add((Throwable)new ComplianceException(EJBComplianceTextFormatter.getInstance().TIMEOUT_METHOD_WITH_INVALID_SIGNATURE(string)));
            }
            Class<?>[] classArray2 = method.getExceptionTypes();
            for (int i = 0; i < classArray2.length; ++i) {
                if (!ComplianceUtils.isApplicationException(beanInfo, method, classArray2[i])) continue;
                errorCollectionException.add((Throwable)new ComplianceException(EJBComplianceTextFormatter.getInstance().TIMEOUT_METHOD_CANNOT_THROW_APPLICATION_EXCEPTION(string)));
            }
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }
}

