/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.compliance;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.naming.Name;
import weblogic.ejb.container.compliance.BaseComplianceChecker;
import weblogic.ejb.container.compliance.ComplianceException;
import weblogic.ejb.container.compliance.EJBComplianceTextFormatter;
import weblogic.ejb.container.interfaces.BeanInfo;
import weblogic.ejb.container.interfaces.ClientDrivenBeanInfo;
import weblogic.ejb.container.interfaces.DeploymentInfo;
import weblogic.ejb20.dd.DescriptorErrorInfo;
import weblogic.j2ee.descriptor.EjbJarBean;
import weblogic.j2ee.descriptor.EjbLocalRefBean;
import weblogic.j2ee.descriptor.EjbRefBean;
import weblogic.j2ee.descriptor.EnterpriseBeansBean;
import weblogic.j2ee.descriptor.MessageDrivenBeanBean;
import weblogic.j2ee.descriptor.SessionBeanBean;
import weblogic.utils.Debug;
import weblogic.utils.ErrorCollectionException;

public final class WeblogicJarChecker
extends BaseComplianceChecker {
    private static final boolean debug = System.getProperty("weblogic.ejb.container.compliance.debug") != null;
    private static final boolean verbose = System.getProperty("weblogic.ejb.container.compliance.verbose") != null;
    private DeploymentInfo di;

    public WeblogicJarChecker(DeploymentInfo deploymentInfo) {
        this.di = deploymentInfo;
        if (debug) {
            Debug.assertion((deploymentInfo != null ? 1 : 0) != 0);
        }
    }

    public void checkWeblogicJar() throws ErrorCollectionException {
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        for (BeanInfo beanInfo : this.di.getBeanInfos()) {
            this.doCheckNoDuplicateJNDINames(beanInfo, errorCollectionException);
            this.doCheckForCorrectJndiNames(beanInfo, errorCollectionException);
            this.doCheckEJBReferenceDescriptions(beanInfo, errorCollectionException);
            if (errorCollectionException.isEmpty()) continue;
            throw errorCollectionException;
        }
    }

    public void doCheckNoDuplicateJNDINames(BeanInfo beanInfo, ErrorCollectionException errorCollectionException) throws ErrorCollectionException {
        if (beanInfo instanceof ClientDrivenBeanInfo) {
            String string;
            ClientDrivenBeanInfo clientDrivenBeanInfo = (ClientDrivenBeanInfo)beanInfo;
            HashSet<Name> hashSet = new HashSet<Name>();
            Name name = clientDrivenBeanInfo.getJNDIName();
            Name name2 = clientDrivenBeanInfo.getLocalJNDIName();
            if (name != null) {
                if (hashSet.contains(name)) {
                    errorCollectionException.add((Throwable)new ComplianceException(this.fmt.DUPLICATE_JNDI_NAME(clientDrivenBeanInfo.getEJBName(), clientDrivenBeanInfo.getJNDINameAsString()), new DescriptorErrorInfo("<jndi-name>", (Object)clientDrivenBeanInfo.getEJBName(), (Object)clientDrivenBeanInfo.getJNDINameAsString())));
                } else if (!clientDrivenBeanInfo.hasRemoteClientView()) {
                    log.logWarning(this.fmt.JNDI_NAME_MUST_HAVE_REMOTE_INTERFACE(clientDrivenBeanInfo.getDisplayName()));
                } else {
                    string = clientDrivenBeanInfo.getJNDINameAsString();
                    if (string.indexOf("java:comp/env") != -1) {
                        errorCollectionException.add((Throwable)new ComplianceException(this.fmt.INCORRECT_JNDI_NAME(clientDrivenBeanInfo.getEJBName(), string)));
                    }
                    hashSet.add(name);
                }
            }
            if (name2 != null) {
                if (hashSet.contains(name2)) {
                    errorCollectionException.add((Throwable)new ComplianceException(this.fmt.DUPLICATE_JNDI_NAME(clientDrivenBeanInfo.getEJBName(), clientDrivenBeanInfo.getLocalJNDINameAsString()), new DescriptorErrorInfo("<local-jndi-name>", (Object)clientDrivenBeanInfo.getEJBName(), (Object)clientDrivenBeanInfo.getJNDINameAsString())));
                } else if (!clientDrivenBeanInfo.hasLocalClientView()) {
                    log.logWarning(this.fmt.LOCAL_JNDI_NAME_MUST_HAVE_LOCAL_INTERFACE(clientDrivenBeanInfo.getDisplayName()));
                } else {
                    string = clientDrivenBeanInfo.getLocalJNDINameAsString();
                    if (string.indexOf("java:comp/env") != -1) {
                        errorCollectionException.add((Throwable)new ComplianceException(this.fmt.INCORRECT_JNDI_NAME(clientDrivenBeanInfo.getEJBName(), string)));
                    }
                    hashSet.add(name2);
                }
            }
        }
    }

    public void doCheckForCorrectJndiNames(BeanInfo beanInfo, ErrorCollectionException errorCollectionException) throws ErrorCollectionException {
        if (beanInfo instanceof ClientDrivenBeanInfo) {
            ClientDrivenBeanInfo clientDrivenBeanInfo = (ClientDrivenBeanInfo)beanInfo;
            Name name = clientDrivenBeanInfo.getJNDIName();
            Name name2 = clientDrivenBeanInfo.getLocalJNDIName();
            String string = clientDrivenBeanInfo.getEJBName();
            if (clientDrivenBeanInfo.hasRemoteClientView() && !clientDrivenBeanInfo.isEJB30() && name == null) {
                log.logWarning(this.fmt.NO_JNDI_NAME_DEFINED_FOR_REMOTE_VIEW(string));
            }
        }
    }

    public void doCheckEJBReferenceDescriptions(BeanInfo beanInfo, ErrorCollectionException errorCollectionException) throws ErrorCollectionException {
        HashSet<String> hashSet;
        Object object4;
        Map map = beanInfo.getAllEJBReferenceJNDINames();
        if (map.size() > 0) {
            object4 = new HashSet();
            hashSet = beanInfo.getAllEJBReferences();
            for (EjbRefBean object32 : hashSet) {
                object4.add(object32.getEjbRefName());
            }
            Set set = map.keySet();
            for (Object object2 : set) {
                if (object4.contains(object2)) continue;
                errorCollectionException.add((Throwable)new ComplianceException(this.fmt.noEJBRefForReferenceDescription(beanInfo.getEJBName(), (String)object2)));
            }
        }
        if ((object4 = beanInfo.getAllEJBLocalReferenceJNDINames()).size() > 0) {
            Object object;
            Object object2;
            hashSet = new HashSet<String>();
            Collection collection = beanInfo.getAllEJBLocalReferences();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                object = (EjbLocalRefBean)iterator.next();
                hashSet.add(object.getEjbRefName());
            }
            object = object4.keySet();
            object2 = object.iterator();
            while (object2.hasNext()) {
                String string = (String)object2.next();
                if (hashSet.contains(string)) continue;
                errorCollectionException.add((Throwable)new ComplianceException(this.fmt.noEJBLocalRefForReferenceDescription(beanInfo.getEJBName(), string)));
            }
        }
    }

    public static void validateEnterpriseBeansMinimalConfiguration(EjbJarBean ejbJarBean, String string) throws ComplianceException {
        if (ejbJarBean == null) {
            return;
        }
        EnterpriseBeansBean enterpriseBeansBean = ejbJarBean.getEnterpriseBeans();
        if (enterpriseBeansBean == null || enterpriseBeansBean.getEntities().length + enterpriseBeansBean.getMessageDrivens().length + enterpriseBeansBean.getSessions().length < 1) {
            throw new ComplianceException(EJBComplianceTextFormatter.getInstance().NO_EJBS_FOUND_IN_DD(string.toString()));
        }
        SessionBeanBean[] sessionBeanBeanArray = enterpriseBeansBean.getSessions();
        for (int i = 0; i < sessionBeanBeanArray.length; ++i) {
            if (sessionBeanBeanArray[i].getEjbClass() == null) {
                throw new ComplianceException(EJBComplianceTextFormatter.getInstance().NO_SESSION_BEAN_CLASS_FOUND_FOR_EJB(sessionBeanBeanArray[i].getEjbName()));
            }
            if ("stateless".equalsIgnoreCase(sessionBeanBeanArray[i].getSessionType()) || "stateful".equalsIgnoreCase(sessionBeanBeanArray[i].getSessionType())) continue;
            throw new ComplianceException(EJBComplianceTextFormatter.getInstance().SESSION_BEAN_NO_SESSION_TYPE(sessionBeanBeanArray[i].getEjbName()));
        }
        MessageDrivenBeanBean[] messageDrivenBeanBeanArray = enterpriseBeansBean.getMessageDrivens();
        for (int i = 0; i < messageDrivenBeanBeanArray.length; ++i) {
            if (messageDrivenBeanBeanArray[i].getEjbClass() != null) continue;
            throw new ComplianceException(EJBComplianceTextFormatter.getInstance().NO_MDB_CLASS_FOUND_FOR_EJB(messageDrivenBeanBeanArray[i].getEjbName()));
        }
    }
}

