/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.dd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.MissingResourceException;
import weblogic.ejb.container.utils.validation.Validatable;
import weblogic.ejb.container.utils.validation.ValidatableWithNotify;
import weblogic.ejb.container.utils.validation.ValidationEvent;
import weblogic.ejb.container.utils.validation.ValidationListener;
import weblogic.utils.AssertionError;
import weblogic.utils.localization.Localizer;

public abstract class BaseDescriptor
implements ValidatableWithNotify {
    private static boolean debug = System.getProperty("weblogic.ejb.deployment.debug") != null;
    private static boolean verbose = System.getProperty("weblogic.ejb.deployment.verbose") != null;
    private String descriptorBundle;
    protected List listeners = new ArrayList();
    protected Map errors = new HashMap();
    protected boolean isValid = true;
    protected Localizer localizer;

    public BaseDescriptor() {
    }

    public BaseDescriptor(String string) {
        this();
    }

    public void addValidationListener(ValidationListener validationListener) {
        this.listeners.add(validationListener);
    }

    public void removeValidationListener(ValidationListener validationListener) {
        ListIterator listIterator = this.listeners.listIterator();
        while (listIterator.hasNext()) {
            if (!validationListener.equals((ValidationListener)listIterator.next())) continue;
            this.listeners.remove(validationListener);
            break;
        }
    }

    public boolean isValid() {
        return this.isValid && this.isValidSubObjects();
    }

    public Collection getErrors() {
        return this.errors.values();
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public void validate() {
        this.removeAllErrors();
        this.validateSelf();
        Iterator iterator = this.getSubObjectsIterator();
        while (iterator.hasNext()) {
            ((Validatable)iterator.next()).validate();
        }
    }

    public Collection getInvalidObjects() {
        ArrayList<BaseDescriptor> arrayList = new ArrayList<BaseDescriptor>();
        if (!this.isValid) {
            arrayList.add(this);
        }
        Iterator iterator = this.getSubObjectsIterator();
        while (iterator.hasNext()) {
            Collection collection = ((BaseDescriptor)iterator.next()).getInvalidObjects();
            arrayList.addAll(collection);
        }
        return arrayList;
    }

    protected void addError(String string) {
        this.isValid = false;
        String string2 = null;
        try {
            string2 = this.localizer.getFormattedMsg(string);
        }
        catch (MissingResourceException missingResourceException) {
            throw new AssertionError((Throwable)missingResourceException);
        }
        this.addVE(string, string2);
    }

    protected void addError(String string, String string2) {
        this.isValid = false;
        String string3 = null;
        try {
            string3 = this.localizer.getFormattedMsg(string, string2);
        }
        catch (MissingResourceException missingResourceException) {
            throw new AssertionError((Throwable)missingResourceException);
        }
        this.addVE(string, string3);
    }

    protected void addError(String string, String string2, String string3) {
        this.isValid = false;
        String string4 = null;
        try {
            string4 = this.localizer.getFormattedMsg(string, string2, string3);
        }
        catch (MissingResourceException missingResourceException) {
            throw new AssertionError((Throwable)missingResourceException);
        }
        this.addVE(string, string4);
    }

    protected void addError(String string, String string2, String string3, String string4) {
        this.isValid = false;
        String string5 = null;
        try {
            string5 = this.localizer.getFormattedMsg(string, string2, string3, string4);
        }
        catch (MissingResourceException missingResourceException) {
            throw new AssertionError((Throwable)missingResourceException);
        }
        this.addVE(string, string5);
    }

    private void addVE(String string, String string2) {
        ValidationEvent validationEvent = new ValidationEvent(this, false, string, string2);
        if (verbose) {
            System.err.println(System.identityHashCode(this) + ": Added error " + validationEvent);
        }
        this.errors.put(string, validationEvent);
        if (debug) {
            System.err.println(System.identityHashCode(this) + ": errors.values().size() = " + this.errors.values().size());
        }
        this.notifyListeners(validationEvent);
    }

    public void removeAllErrors() {
        if (debug) {
            System.err.println(System.identityHashCode(this) + ": Remove all errors");
        }
        this.isValid = true;
        this.errors = new HashMap();
    }

    protected void removeError(String string, String string2) {
        ValidationEvent validationEvent = (ValidationEvent)this.errors.remove(string);
        ValidationEvent validationEvent2 = new ValidationEvent((ValidatableWithNotify)validationEvent.getSource(), true, string, string2);
        this.notifyListeners(validationEvent2);
    }

    protected boolean isValidSubObjects() {
        boolean bl = true;
        Iterator iterator = this.getSubObjectsIterator();
        while (iterator.hasNext()) {
            bl &= ((Validatable)iterator.next()).isValid();
        }
        return bl;
    }

    protected void notifyListeners(ValidationEvent validationEvent) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((ValidationListener)iterator.next()).validationPerformed(validationEvent);
        }
    }

    public abstract void validateSelf();

    public abstract Iterator getSubObjectsIterator();
}

