/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.dd;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import weblogic.ejb.container.dd.BaseDescriptor;
import weblogic.utils.AssertionError;
import weblogic.utils.Debug;

public final class EnvironmentEntry
extends BaseDescriptor {
    private static boolean debug = System.getProperty("weblogic.ejb.deployment.debug") != null;
    public static Set VALID_ENV_ENTRY_TYPES = new HashSet<Object>(Arrays.asList((Object[])new String[]{"java.lang.String", "java.lang.Boolean", "java.lang.Integer", "java.lang.Double", "java.lang.Float", "java.lang.Short", "java.lang.Long", "java.lang.Byte", "java.lang.Character"}));
    private String name;
    private String type;
    private String value;
    private String description;

    public EnvironmentEntry() {
        super(null);
    }

    public void setName(String string) {
        if (debug) {
            System.err.println("setName(" + string + ")");
        }
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String string) {
        if (debug) {
            System.err.println("setDescription(" + string + ")");
        }
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setType(String string) {
        if (debug) {
            System.err.println("setType(" + string + ")");
        }
        this.type = string;
    }

    public String getType() {
        return this.type;
    }

    public String getValueString() {
        return this.value;
    }

    public Object getValue() {
        return this.getValue(this.getClass().getClassLoader());
    }

    public Object getValue(ClassLoader classLoader) {
        if (debug) {
            Debug.assertion((classLoader != null ? 1 : 0) != 0);
            Debug.assertion((boolean)VALID_ENV_ENTRY_TYPES.contains(this.type));
        }
        try {
            Class<?> clazz = classLoader.loadClass(this.type);
            if ("java.lang.Character".equals(this.type)) {
                if (this.value.length() > 0) {
                    return new Character(this.value.charAt(0));
                }
                throw new Exception(" env-entry for type java.lang.Character had length = 0 ");
            }
            Constructor<?> constructor = clazz.getConstructor(String.class);
            return constructor.newInstance(this.value);
        }
        catch (Exception exception) {
            throw new AssertionError((Throwable)exception);
        }
    }

    public void setValue(String string) {
        this.value = string;
    }

    public void validateSelf() {
    }

    public Iterator getSubObjectsIterator() {
        return Collections.EMPTY_SET.iterator();
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof EnvironmentEntry && this.name.equals(((EnvironmentEntry)object).name);
    }
}

