/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.dd.xml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import weblogic.descriptor.DescriptorBean;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.spi.EjbDescriptorBean;

public class AnnotationDebugger {
    public static final DebugLogger compilationLogger = DebugLogger.getDebugLogger((String)"DebugEjbAnnotationProcessor");

    public static void log(Class clazz, Annotation annotation) {
        String string = "Processing " + annotation + " on " + clazz;
        AnnotationDebugger.info(string);
    }

    public static void log(Class clazz, Method method, Annotation annotation) {
        String string = "Processing " + annotation + " on '" + method.getName() + "' method of " + clazz;
        AnnotationDebugger.info(string);
    }

    public static void log(Class clazz, Method method, String string) {
        String string2 = "Processing " + string + " on '" + method + "' method of " + clazz;
        AnnotationDebugger.info(string2);
    }

    public static void log(Class clazz, Field field, Annotation annotation) {
        String string = "Processing " + annotation + " on '" + field.getName() + "' field of " + clazz;
        AnnotationDebugger.info(string);
    }

    public static void log(Class clazz, String string) {
        String string2 = "Processing " + string + " on " + clazz;
        AnnotationDebugger.info(string2);
    }

    public static void logEjbJar(EjbDescriptorBean ejbDescriptorBean) {
        if (AnnotationDebugger.isDebugEnabled()) {
            DescriptorBean descriptorBean = (DescriptorBean)ejbDescriptorBean.getEjbJarBean();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                descriptorBean.getDescriptor().toXML((OutputStream)byteArrayOutputStream);
                AnnotationDebugger.info(((Object)byteArrayOutputStream).toString());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void logWlsEjbJar(EjbDescriptorBean ejbDescriptorBean) {
        if (AnnotationDebugger.isDebugEnabled()) {
            DescriptorBean descriptorBean = (DescriptorBean)ejbDescriptorBean.getWeblogicEjbJarBean();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                descriptorBean.getDescriptor().toXML((OutputStream)byteArrayOutputStream);
                AnnotationDebugger.info(((Object)byteArrayOutputStream).toString());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void info(String string) {
        if (AnnotationDebugger.isDebugEnabled()) {
            compilationLogger.debug(string + "\n");
        }
    }

    public static boolean isDebugEnabled() {
        return compilationLogger.isDebugEnabled();
    }
}

