/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.dd.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashSet;
import java.util.Set;
import org.xml.sax.InputSource;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.spi.EjbDescriptorBean;
import weblogic.j2ee.descriptor.EjbJarBean;
import weblogic.j2ee.descriptor.EnterpriseBeansBean;
import weblogic.j2ee.descriptor.MessageDrivenBeanBean;
import weblogic.j2ee.descriptor.SessionBeanBean;
import weblogic.j2ee.descriptor.wl.WeblogicEjbJarBean;
import weblogic.logging.Loggable;
import weblogic.xml.process.XMLParsingException;
import weblogic.xml.process.XMLProcessingException;

public abstract class DDLoader {
    private static final boolean debug = System.getProperty("weblogic.ejb.container.dd.xml") != null;
    private static boolean verbose = System.getProperty("weblogic.ejb.container.dd.xml") != null;
    protected EjbDescriptorBean ejbDescriptor = null;
    protected Set ejbNamesWithValidatedCTs = new HashSet();
    protected boolean validate = true;
    protected String encoding = null;
    protected Set relationNames = new HashSet();
    protected HashSet ejbNames = new HashSet();

    public void setEJBDescriptor(EjbDescriptorBean ejbDescriptorBean) {
        this.ejbDescriptor = ejbDescriptorBean;
    }

    public EjbDescriptorBean getEJBDescriptor() {
        return this.ejbDescriptor;
    }

    public void setValidate(boolean bl) {
        this.validate = bl;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public abstract void process(String var1) throws IOException, XMLParsingException, XMLProcessingException;

    public abstract void process(InputStream var1) throws IOException, XMLParsingException, XMLProcessingException;

    public abstract void process(Reader var1) throws IOException, XMLParsingException, XMLProcessingException;

    public abstract void process(File var1) throws IOException, XMLParsingException, XMLProcessingException;

    public abstract void process(InputSource var1) throws IOException, XMLParsingException, XMLProcessingException;

    protected void validatePositiveInteger(String string) throws Exception {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            Loggable loggable = EJBLogger.logparamIntegerLoggable();
            throw new Exception(loggable.getMessage());
        }
        if (n < 0) {
            Loggable loggable = EJBLogger.logparamPositiveIntegerLoggable();
            throw new Exception(loggable.getMessage());
        }
    }

    protected void validatePositiveIntegerOrNoLimitString(String string) throws Exception {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (string.equalsIgnoreCase("NO Limit")) {
                return;
            }
            throw new Exception("Parameter must be an integer");
        }
        if (n < 0) {
            throw new Exception("Parameter must be a positive integer");
        }
    }

    protected void validateConcurrencyStrategy(String string) throws Exception {
        if (string.equalsIgnoreCase("readonly") || string.equalsIgnoreCase("readonlyexclusive") || string.equalsIgnoreCase("exclusive") || string.equalsIgnoreCase("database") || string.equalsIgnoreCase("optimistic")) {
            return;
        }
        Loggable loggable = EJBLogger.logillegalConcurrencyStrategyLoggable((String)string);
        throw new Exception(loggable.getMessage());
    }

    protected void validateIntegerGreaterThanZero(String string) throws Exception {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            Loggable loggable = EJBLogger.logparamIntegerLoggable();
            throw new Exception(loggable.getMessage());
        }
        if (n <= 0) {
            Loggable loggable = EJBLogger.logparamPositiveIntegerLoggable();
            throw new Exception(loggable.getMessage());
        }
    }

    protected void validateContainerTransaction(EjbJarBean ejbJarBean, String string) {
        Loggable loggable;
        if (this.ejbNamesWithValidatedCTs.contains(string)) {
            return;
        }
        EnterpriseBeansBean enterpriseBeansBean = ejbJarBean.getEnterpriseBeans();
        SessionBeanBean[] sessionBeanBeanArray = enterpriseBeansBean.getSessions();
        for (int i = 0; i < sessionBeanBeanArray.length; ++i) {
            if (!sessionBeanBeanArray[i].getEjbName().equals(string) || !sessionBeanBeanArray[i].getTransactionType().equals("Bean")) continue;
            loggable = EJBLogger.logContainerTransactionSetForBeanManagedEJBLoggable((String)string);
            loggable.log();
        }
        if (enterpriseBeansBean instanceof EnterpriseBeansBean) {
            EnterpriseBeansBean enterpriseBeansBean2 = enterpriseBeansBean;
            loggable = enterpriseBeansBean2.getMessageDrivens();
            for (int i = 0; i < ((MessageDrivenBeanBean[])loggable).length; ++i) {
                if (!loggable[i].getEjbName().equals(string) || !loggable[i].getTransactionType().equals("Bean")) continue;
                Loggable loggable2 = EJBLogger.logContainerTransactionSetForBeanManagedEJBLoggable((String)string);
                loggable2.log();
            }
        }
        this.ejbNamesWithValidatedCTs.add(string);
    }

    protected boolean addEJBName(String string) {
        if (this.ejbNames == null) {
            this.ejbNames = new HashSet();
        }
        return this.ejbNames.add(string);
    }

    protected void setEntityAlwaysUsesTransactionDefault() {
        WeblogicEjbJarBean weblogicEjbJarBean = this.ejbDescriptor.getWeblogicEjbJarBean();
        weblogicEjbJarBean.getWeblogicCompatibility().setEntityAlwaysUsesTransaction(true);
    }

    class PersistenceType {
        public String id;
        public String version;

        PersistenceType() {
        }
    }
}

