/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.dd.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Locale;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.deployer.IncomprehensibleMethodSignatureException;
import weblogic.logging.Loggable;
import weblogic.management.descriptors.Encoding;
import weblogic.utils.AssertionError;
import weblogic.utils.StringUtils;
import weblogic.utils.io.XMLDeclaration;

public final class DDUtils {
    private static final boolean debug = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getMethodName(String string) throws IncomprehensibleMethodSignatureException {
        int n = string.indexOf(40);
        int n2 = string.indexOf(41);
        if (n == -1) {
            if (n2 == -1) {
                return string;
            }
            Loggable loggable = EJBLogger.loginvalidMethodSignatureLoggable((String)string);
            throw new IncomprehensibleMethodSignatureException(loggable.getMessage());
        }
        if (n2 != -1) return string.substring(0, n);
        Loggable loggable = EJBLogger.loginvalidMethodSignatureLoggable((String)string);
        throw new IncomprehensibleMethodSignatureException(loggable.getMessage());
    }

    public static String[] getMethodParams(String string) throws IncomprehensibleMethodSignatureException {
        String[] stringArray;
        int n = string.indexOf(40);
        int n2 = string.indexOf(41);
        if (n == -1 && n2 == -1) {
            stringArray = null;
        } else {
            if (n == -1 || n2 == -1) {
                Loggable loggable = EJBLogger.loginvalidMethodSignatureLoggable((String)string);
                throw new IncomprehensibleMethodSignatureException(loggable.getMessage());
            }
            stringArray = StringUtils.splitCompletely((String)string.substring(n + 1, n2), (String)",", (boolean)false);
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringArray[i].trim();
            }
        }
        return stringArray;
    }

    public static String getMethodSignature(String string, String[] stringArray) {
        if (stringArray != null && !"*".equals(string)) {
            String[] stringArray2 = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray2[i] = DDUtils.makeMethodParam(stringArray[i]);
            }
            return string + "(" + StringUtils.join((String[])stringArray2, (String)",") + ")";
        }
        return string;
    }

    public static String getMethodSignature(Method method) {
        String string = method.getName();
        Class<?>[] classArray = method.getParameterTypes();
        String[] stringArray = new String[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            stringArray[i] = classArray[i].getCanonicalName();
        }
        return DDUtils.getMethodSignature(string, stringArray);
    }

    public static String getMethodSignature(String string, Class[] classArray) {
        String[] stringArray = new String[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            stringArray[i] = classArray[i].getCanonicalName();
        }
        return DDUtils.getMethodSignature(string, stringArray);
    }

    public static String getEjbHomeMethodSignature(Method method) {
        String string = method.getName();
        String string2 = "ejbHome" + string.substring(0, 1).toUpperCase(Locale.ENGLISH);
        if (string.length() > 1) {
            string2 = string2 + string.substring(1);
        }
        return DDUtils.getMethodSignature(string2, method.getParameterTypes());
    }

    static String makeMethodParam(String string) {
        if (!string.endsWith("[]")) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length() - 2;
        while (true) {
            stringBuffer.append('[');
            if (n < 2 || string.charAt(n - 2) != '[' || string.charAt(n - 1) != ']') break;
            n -= 2;
        }
        return stringBuffer.append(DDUtils.arrayClassName(string.substring(0, n).trim())).toString();
    }

    private static String arrayClassName(String string) {
        if (string.equals("byte")) {
            return "B";
        }
        if (string.equals("char")) {
            return "C";
        }
        if (string.equals("int")) {
            return "I";
        }
        if (string.equals("long")) {
            return "J";
        }
        if (string.equals("float")) {
            return "F";
        }
        if (string.equals("double")) {
            return "D";
        }
        if (string.equals("short")) {
            return "S";
        }
        if (string.equals("boolean")) {
            return "Z";
        }
        return "L" + string + ";";
    }

    public static int isoStringToInt(String string) throws IllegalArgumentException {
        if (string.equalsIgnoreCase("TransactionSerializable")) {
            return 8;
        }
        if (string.equalsIgnoreCase("TransactionRepeatableRead")) {
            return 4;
        }
        if (string.equalsIgnoreCase("TransactionReadCommitted")) {
            return 2;
        }
        if (string.equalsIgnoreCase("TransactionReadCommittedForUpdate")) {
            return 2;
        }
        if (string.equalsIgnoreCase("TransactionReadCommittedForUpdateNoWait")) {
            return 2;
        }
        if (string.equalsIgnoreCase("TransactionReadUncommitted")) {
            return 1;
        }
        if (string.equalsIgnoreCase("TransactionNone")) {
            return 0;
        }
        if (string.equalsIgnoreCase("TRANSACTION_SERIALIZABLE")) {
            return 8;
        }
        if (string.equalsIgnoreCase("TRANSACTION_REPEATABLE_READ")) {
            return 4;
        }
        if (string.equalsIgnoreCase("TRANSACTION_READ_COMMITTED")) {
            return 2;
        }
        if (string.equalsIgnoreCase("TRANSACTION_READ_COMMITTED_FOR_UPDATE")) {
            return 2;
        }
        if (string.equalsIgnoreCase("TRANSACTION_READ_COMMITTED_FOR_UPDATE_NO_WAIT")) {
            return 2;
        }
        if (string.equalsIgnoreCase("TRANSACTION_READ_UNCOMMITTED")) {
            return 1;
        }
        if (string.equalsIgnoreCase("TRANSACTION_NONE")) {
            return 0;
        }
        throw new IllegalArgumentException("Bad isolation level: " + string);
    }

    public static int concurrencyStringToInt(String string) {
        int n = -1;
        if ("Exclusive".equalsIgnoreCase(string)) {
            n = 1;
        } else if ("database".equalsIgnoreCase(string)) {
            n = 2;
        } else if ("ReadOnlyExclusive".equalsIgnoreCase(string)) {
            n = 4;
        } else if ("ReadOnly".equalsIgnoreCase(string)) {
            n = 5;
        } else if ("Optimistic".equalsIgnoreCase(string)) {
            n = 6;
        } else {
            throw new AssertionError("Bad concurrency setting: " + string);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getXMLEncoding(InputStream inputStream, String string) throws IOException {
        String string2 = null;
        inputStream.mark(0x100000);
        try {
            XMLDeclaration xMLDeclaration = new XMLDeclaration();
            xMLDeclaration.parse(inputStream);
            string2 = xMLDeclaration.getEncoding();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            inputStream.reset();
            throw throwable;
        }
        inputStream.reset();
        DDUtils.validateEncoding(string2, string);
        return string2;
    }

    private static void validateEncoding(String string, String string2) throws IOException {
        if (string != null && Encoding.getIANA2JavaMapping(string) == null && Encoding.getJava2IANAMapping(string) == null && !Charset.isSupported(string)) {
            throw new UnsupportedEncodingException(string2 + " uses invalid encoding");
        }
    }
}

