/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.dd.xml;

import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.ApplicationException;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.Init;
import javax.ejb.Local;
import javax.ejb.LocalHome;
import javax.ejb.MessageDriven;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.ejb.RemoteHome;
import javax.ejb.Remove;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.interceptor.AroundInvoke;
import javax.interceptor.ExcludeClassInterceptors;
import javax.interceptor.ExcludeDefaultInterceptors;
import javax.interceptor.Interceptors;
import javax.jms.MessageListener;
import javax.jws.WebService;
import javax.xml.ws.WebServiceProvider;
import org.apache.openjpa.lib.meta.ClassAnnotationMetaDataFilter;
import org.apache.openjpa.lib.meta.MetaDataFilter;
import weblogic.application.utils.VirtualJarFileMetaDataIterator;
import weblogic.descriptor.DescriptorBean;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.compliance.ComplianceException;
import weblogic.ejb.container.compliance.EJBComplianceChecker;
import weblogic.ejb.container.compliance.Ejb30AnnotationChecker;
import weblogic.ejb.container.compliance.TimeoutCheckHelper;
import weblogic.ejb.container.utils.ClassUtils;
import weblogic.ejb.container.utils.MethodUtils;
import weblogic.ejb.spi.EjbDescriptorBean;
import weblogic.j2ee.dd.xml.J2eeAnnotationProcessor;
import weblogic.j2ee.descriptor.ActivationConfigBean;
import weblogic.j2ee.descriptor.ActivationConfigPropertyBean;
import weblogic.j2ee.descriptor.ApplicationExceptionBean;
import weblogic.j2ee.descriptor.AroundInvokeBean;
import weblogic.j2ee.descriptor.AssemblyDescriptorBean;
import weblogic.j2ee.descriptor.ContainerTransactionBean;
import weblogic.j2ee.descriptor.EjbCallbackBean;
import weblogic.j2ee.descriptor.EjbJarBean;
import weblogic.j2ee.descriptor.EnterpriseBeanBean;
import weblogic.j2ee.descriptor.EnterpriseBeansBean;
import weblogic.j2ee.descriptor.ExcludeListBean;
import weblogic.j2ee.descriptor.InterceptorBean;
import weblogic.j2ee.descriptor.InterceptorBindingBean;
import weblogic.j2ee.descriptor.InterceptorsBean;
import weblogic.j2ee.descriptor.J2eeClientEnvironmentBean;
import weblogic.j2ee.descriptor.LifecycleCallbackBean;
import weblogic.j2ee.descriptor.MessageDrivenBeanBean;
import weblogic.j2ee.descriptor.MethodParamsBean;
import weblogic.j2ee.descriptor.MethodPermissionBean;
import weblogic.j2ee.descriptor.NamedMethodBean;
import weblogic.j2ee.descriptor.RemoveMethodBean;
import weblogic.j2ee.descriptor.RunAsBean;
import weblogic.j2ee.descriptor.SecurityIdentityBean;
import weblogic.j2ee.descriptor.SecurityRoleBean;
import weblogic.j2ee.descriptor.SecurityRoleRefBean;
import weblogic.j2ee.descriptor.SessionBeanBean;
import weblogic.j2ee.descriptor.wl.BusinessInterfaceJndiNameMapBean;
import weblogic.j2ee.descriptor.wl.IdempotentMethodsBean;
import weblogic.j2ee.descriptor.wl.MessageDrivenDescriptorBean;
import weblogic.j2ee.descriptor.wl.MethodBean;
import weblogic.j2ee.descriptor.wl.RetryMethodsOnRollbackBean;
import weblogic.j2ee.descriptor.wl.StatefulSessionDescriptorBean;
import weblogic.j2ee.descriptor.wl.StatelessSessionDescriptorBean;
import weblogic.j2ee.descriptor.wl.TransactionDescriptorBean;
import weblogic.j2ee.descriptor.wl.TransactionIsolationBean;
import weblogic.j2ee.descriptor.wl.WeblogicEjbJarBean;
import weblogic.j2ee.descriptor.wl.WeblogicEnterpriseBeanBean;
import weblogic.javaee.AllowRemoveDuringTransaction;
import weblogic.javaee.CallByReference;
import weblogic.javaee.DisableWarnings;
import weblogic.javaee.Idempotent;
import weblogic.javaee.JMSClientID;
import weblogic.javaee.JNDIName;
import weblogic.javaee.MessageDestinationConfiguration;
import weblogic.javaee.TransactionIsolation;
import weblogic.javaee.TransactionTimeoutSeconds;
import weblogic.javaee.WarningCode;
import weblogic.logging.Loggable;
import weblogic.utils.ErrorCollectionException;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.ClasspathClassFinder2;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.jars.VirtualJarFactory;
import weblogic.utils.jars.VirtualJarFile;
import weblogic.wsee.deploy.DeployUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbAnnotationProcessor
extends J2eeAnnotationProcessor {
    private static final boolean debug = false;
    private static final boolean verbose = false;
    private static final Class[] identityAnnotations = new Class[]{Stateful.class, Stateless.class, MessageDriven.class, ApplicationException.class};
    GenericClassLoader cl = null;
    private Boolean disableWarningsIsInXML = null;

    public EjbAnnotationProcessor(GenericClassLoader genericClassLoader) {
        this.cl = genericClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAnnotations(EjbDescriptorBean ejbDescriptorBean, VirtualJarFile virtualJarFile) throws ClassNotFoundException, NoSuchMethodException, ErrorCollectionException {
        TreeSet<Class> treeSet = new TreeSet<Class>(new Comparator<Class>(){

            @Override
            public int compare(Class clazz, Class clazz2) {
                return clazz.getCanonicalName().compareTo(clazz2.getCanonicalName());
            }
        });
        File[] fileArray = virtualJarFile.getRootFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            Object object;
            if (!fileArray[i].exists()) continue;
            VirtualJarFile virtualJarFile2 = null;
            String string = null;
            try {
                virtualJarFile2 = VirtualJarFactory.createVirtualJar((File)fileArray[i]);
                VirtualJarFileMetaDataIterator virtualJarFileMetaDataIterator = new VirtualJarFileMetaDataIterator(virtualJarFile2, (MetaDataFilter)new ClassAnnotationMetaDataFilter(identityAnnotations));
                while (virtualJarFileMetaDataIterator.hasNext()) {
                    string = (String)virtualJarFileMetaDataIterator.next();
                    string = string.replace('/', '.');
                    string = string.substring(0, string.length() - 6);
                    object = this.cl.loadClass(string);
                    ((Class)object).getAnnotations();
                    treeSet.add((Class)object);
                }
                continue;
            }
            catch (LinkageError linkageError) {
                object = EJBLogger.logUnableLinkClassLoggable(string, (String)fileArray[i].toString(), (String)linkageError.toString());
                this.addFatalProcessingError(object.getMessage());
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                object = EJBLogger.logUnableLoadClassLoggable(string, (String)fileArray[i].toString(), (String)classNotFoundException.toString());
                this.addFatalProcessingError(object.getMessage());
                continue;
            }
            catch (IOException iOException) {
                object = EJBLogger.logUnableCreateJarLoggable((String)fileArray[i].toString(), (String)iOException.toString());
                this.addFatalProcessingError(object.getMessage());
                continue;
            }
            catch (ArrayStoreException arrayStoreException) {
                object = EJBLogger.logUnableLoadClassLoggable(string, (String)fileArray[i].toString(), (String)arrayStoreException.toString());
                this.addFatalProcessingError(object.getMessage());
                continue;
            }
            finally {
                if (virtualJarFile2 != null) {
                    try {
                        virtualJarFile2.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        this.processAnnotations(treeSet, ejbDescriptorBean);
        if (EJBComplianceChecker.isNeedCheck) {
            return;
        }
        this.validate((ClassLoader)this.cl, (DescriptorBean)ejbDescriptorBean.getEjbJarBean(), false);
        this.throwProcessingErrors();
    }

    /*
     * WARNING - void declaration
     */
    private void processAnnotations(Set<Class> set, EjbDescriptorBean ejbDescriptorBean) throws ClassNotFoundException, NoSuchMethodException, ErrorCollectionException {
        void var11_23;
        void var11_21;
        EnterpriseBeansBean enterpriseBeansBean;
        HashSet<String> hashSet = new HashSet<String>();
        HashMap<String, SessionBeanBean> hashMap = new HashMap<String, SessionBeanBean>();
        HashMap<String, String[]> hashMap2 = new HashMap<String, String[]>();
        EjbJarBean ejbJarBean = ejbDescriptorBean.getEjbJarBean();
        if (ejbJarBean == null) {
            ejbJarBean = ejbDescriptorBean.createEjbJarBean();
        }
        if ((enterpriseBeansBean = ejbJarBean.getEnterpriseBeans()) == null) {
            enterpriseBeansBean = ejbJarBean.createEnterpriseBeans();
        }
        for (SessionBeanBean sessionBeanBean : enterpriseBeansBean.getSessions()) {
            hashSet.add(sessionBeanBean.getEjbClass());
            hashMap.put(sessionBeanBean.getEjbName(), sessionBeanBean);
        }
        for (SessionBeanBean sessionBeanBean : enterpriseBeansBean.getMessageDrivens()) {
            hashSet.add(sessionBeanBean.getEjbClass());
            hashMap.put(sessionBeanBean.getEjbName(), sessionBeanBean);
        }
        HashSet hashSet2 = new HashSet();
        for (Class clazz : set) {
            String[] stringArray;
            if (clazz.isAnnotationPresent(Stateless.class)) {
                Stateless stateless = clazz.getAnnotation(Stateless.class);
                String string = this.getEjbName(stateless.name(), clazz);
                try {
                    stringArray = new String[]{"Stateless", clazz.getName()};
                    Ejb30AnnotationChecker.validateNameAnnotation(string, hashMap2, stringArray);
                }
                catch (ComplianceException complianceException) {
                    this.addProcessingError(complianceException.getMessage());
                    break;
                }
                if (this.ensureBeanClassSet((EnterpriseBeanBean)hashMap.get(string), clazz) || hashSet.contains(clazz.getName())) continue;
                this.addStatelessSessionBean(string, clazz, enterpriseBeansBean);
                continue;
            }
            if (clazz.isAnnotationPresent(Stateful.class)) {
                Stateful stateful = clazz.getAnnotation(Stateful.class);
                String string = this.getEjbName(stateful.name(), clazz);
                try {
                    stringArray = new String[]{"Stateful", clazz.getName()};
                    Ejb30AnnotationChecker.validateNameAnnotation(string, hashMap2, stringArray);
                }
                catch (ComplianceException complianceException) {
                    this.addProcessingError(complianceException.getMessage());
                    break;
                }
                if (this.ensureBeanClassSet((EnterpriseBeanBean)hashMap.get(string), clazz) || hashSet.contains(clazz.getName())) continue;
                this.addStatefulSessionBean(string, clazz, enterpriseBeansBean);
                continue;
            }
            if (clazz.isAnnotationPresent(MessageDriven.class)) {
                MessageDriven messageDriven = clazz.getAnnotation(MessageDriven.class);
                String string = this.getEjbName(messageDriven.name(), clazz);
                try {
                    stringArray = new String[]{"MessageDriven", clazz.getName()};
                    Ejb30AnnotationChecker.validateNameAnnotation(string, hashMap2, stringArray);
                }
                catch (ComplianceException complianceException) {
                    this.addProcessingError(complianceException.getMessage());
                    break;
                }
                if (this.ensureBeanClassSet((EnterpriseBeanBean)hashMap.get(string), clazz) || hashSet.contains(clazz.getName())) continue;
                this.addMessageDrivenBean(string, clazz, enterpriseBeansBean);
                continue;
            }
            if (!clazz.isAnnotationPresent(ApplicationException.class)) continue;
            hashSet2.add(clazz);
        }
        this.processApplicationExceptions(hashSet2, ejbJarBean);
        SessionBeanBean[] sessionBeanBeanArray = enterpriseBeansBean.getSessions();
        int n = sessionBeanBeanArray.length;
        boolean bl = false;
        while (var11_21 < n) {
            SessionBeanBean sessionBeanBean = sessionBeanBeanArray[var11_21];
            this.processSessionAnnotations(sessionBeanBean, ejbDescriptorBean);
            ++var11_21;
        }
        sessionBeanBeanArray = enterpriseBeansBean.getMessageDrivens();
        n = sessionBeanBeanArray.length;
        boolean bl2 = false;
        while (var11_23 < n) {
            SessionBeanBean sessionBeanBean = sessionBeanBeanArray[var11_23];
            this.processMessageDrivenAnnotations((MessageDrivenBeanBean)sessionBeanBean, ejbDescriptorBean);
            ++var11_23;
        }
        this.processInterceptorClasses(ejbDescriptorBean);
    }

    private boolean ensureBeanClassSet(EnterpriseBeanBean enterpriseBeanBean, Class clazz) {
        if (enterpriseBeanBean != null) {
            if (!this.isSet("EjbClass", enterpriseBeanBean)) {
                enterpriseBeanBean.setEjbClass(clazz.getName());
            }
            return true;
        }
        return false;
    }

    private String getEjbName(String string, Class clazz) {
        if (string == null || string.length() == 0) {
            string = clazz.getSimpleName();
        }
        return string;
    }

    private void addStatelessSessionBean(String string, Class clazz, EnterpriseBeansBean enterpriseBeansBean) {
        SessionBeanBean sessionBeanBean = enterpriseBeansBean.createSession();
        sessionBeanBean.setEjbName(string);
        sessionBeanBean.setEjbClass(clazz.getName());
        sessionBeanBean.setSessionType("Stateless");
    }

    private void addStatefulSessionBean(String string, Class clazz, EnterpriseBeansBean enterpriseBeansBean) {
        SessionBeanBean sessionBeanBean = enterpriseBeansBean.createSession();
        sessionBeanBean.setEjbName(string);
        sessionBeanBean.setEjbClass(clazz.getName());
        sessionBeanBean.setSessionType("Stateful");
    }

    private void addMessageDrivenBean(String string, Class clazz, EnterpriseBeansBean enterpriseBeansBean) {
        MessageDrivenBeanBean messageDrivenBeanBean = enterpriseBeansBean.createMessageDriven();
        messageDrivenBeanBean.setEjbName(string);
        messageDrivenBeanBean.setEjbClass(clazz.getName());
    }

    /*
     * WARNING - void declaration
     */
    private void processSessionAnnotations(SessionBeanBean sessionBeanBean, EjbDescriptorBean ejbDescriptorBean) throws ClassNotFoundException, NoSuchMethodException, ErrorCollectionException {
        GenericDeclaration genericDeclaration;
        Object object;
        Object object2;
        int n;
        int n2;
        Object object4;
        javax.ejb.Remote remote;
        Object object6;
        Loggable loggable;
        Class clazz = this.loadBeanClass(sessionBeanBean.getEjbClass(), sessionBeanBean.getEjbName(), (ClassLoader)this.cl);
        if (clazz.isAnnotationPresent(Stateful.class) || clazz.isAnnotationPresent(Stateless.class)) {
            loggable = clazz.getSuperclass();
            while (!loggable.equals(Object.class)) {
                if (loggable.isAnnotationPresent(Stateful.class) || loggable.isAnnotationPresent(Stateless.class)) {
                    object6 = EJBLogger.logSessionBeanWithSessionBeanParentLoggable((String)loggable.getName(), (String)sessionBeanBean.getEjbClass());
                    this.addProcessingError(object6.getMessage());
                    break;
                }
                loggable = loggable.getSuperclass();
            }
        }
        if (!this.isSet("SessionType", sessionBeanBean)) {
            if (clazz.isAnnotationPresent(Stateful.class)) {
                sessionBeanBean.setSessionType("Stateful");
            } else if (clazz.isAnnotationPresent(Stateless.class)) {
                sessionBeanBean.setSessionType("Stateless");
            } else {
                loggable = EJBLogger.logSessionBeanWithoutSetSessionTypeLoggable((String)sessionBeanBean.getEjbName());
                this.addFatalProcessingError(loggable.getMessage());
            }
        }
        boolean bl = sessionBeanBean.getSessionType().equals("Stateless");
        if (!this.isSet("Home", sessionBeanBean) && (object6 = clazz.getAnnotation(RemoteHome.class)) != null) {
            sessionBeanBean.setHome(object6.value().getName());
        }
        if (!this.isSet("LocalHome", sessionBeanBean) && (object6 = clazz.getAnnotation(LocalHome.class)) != null) {
            sessionBeanBean.setLocalHome(object6.value().getName());
        }
        object6 = new HashSet();
        HashSet hashSet = new HashSet();
        Local local = clazz.getAnnotation(Local.class);
        if (local != null) {
            remote = local.value();
            int n3 = ((Class[])remote).length;
            for (int i = 0; i < n3; ++i) {
                javax.ejb.Remote remote2 = remote[i];
                object6.add(remote2);
            }
        }
        if ((remote = clazz.getAnnotation(javax.ejb.Remote.class)) != null) {
            for (Class object52 : remote.value()) {
                hashSet.add(object52);
            }
        }
        Set<Class> set = this.getImplementedInterfaces(clazz);
        for (Class clazz2 : set) {
            if (clazz2.isAnnotationPresent(javax.ejb.Remote.class)) {
                hashSet.add(clazz2);
                continue;
            }
            if (!clazz2.isAnnotationPresent(Local.class)) continue;
            object6.add(clazz2);
        }
        if (hashSet.isEmpty() && object6.isEmpty() && set.size() == 1) {
            object4 = set.iterator().next();
            boolean bl2 = false;
            String[] stringArray = sessionBeanBean.getBusinessRemotes();
            n2 = stringArray.length;
            for (n = 0; n < n2; ++n) {
                String string = stringArray[n];
                if (!((Class)object4).getName().equals(string)) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                if (clazz.isAnnotationPresent(javax.ejb.Remote.class) || this.isExtendRemote((Class)object4)) {
                    hashSet.add(object4);
                } else {
                    object6.add(object4);
                }
            }
        }
        if (sessionBeanBean.getHome() != null) {
            object4 = sessionBeanBean.getRemote();
            if (object4 == null) {
                for (Class clazz7 : hashSet) {
                    if (!EJBObject.class.isAssignableFrom(clazz7)) continue;
                    sessionBeanBean.setRemote(clazz7.getName());
                    hashSet.remove(clazz7);
                    break;
                }
                if (sessionBeanBean.getRemote() == null) {
                    Class clazz3 = this.cl.loadClass(sessionBeanBean.getHome());
                    Method[] complianceException = clazz3.getMethods();
                    n2 = complianceException.length;
                    for (n = 0; n < n2; ++n) {
                        Method method = complianceException[n];
                        if (!method.getName().startsWith("create") || !EJBObject.class.isAssignableFrom(method.getReturnType())) continue;
                        sessionBeanBean.setRemote(method.getReturnType().getName());
                        break;
                    }
                }
            } else {
                Class clazz4 = this.cl.loadClass((String)object4);
                hashSet.remove(clazz4);
            }
        }
        if (sessionBeanBean.getLocalHome() != null) {
            object4 = sessionBeanBean.getLocal();
            if (object4 == null) {
                Object object7 = object6.iterator();
                while (object7.hasNext()) {
                    Class clazz2 = (Class)object7.next();
                    if (!EJBLocalObject.class.isAssignableFrom(clazz2)) continue;
                    sessionBeanBean.setLocal(clazz2.getName());
                    object6.remove(clazz2);
                    break;
                }
                if (sessionBeanBean.getLocal() == null) {
                    object7 = this.cl.loadClass(sessionBeanBean.getLocalHome());
                    Method[] methodArray = ((Class)object7).getMethods();
                    n2 = methodArray.length;
                    for (n = 0; n < n2; ++n) {
                        Method method = methodArray[n];
                        if (!method.getName().startsWith("create") || !EJBLocalObject.class.isAssignableFrom(method.getReturnType())) continue;
                        sessionBeanBean.setLocal(method.getReturnType().getName());
                        break;
                    }
                }
            } else {
                Class clazz5 = this.cl.loadClass(object4);
                object6.remove(clazz5);
            }
        }
        if (sessionBeanBean.getBusinessLocals().length == 0) {
            object4 = new HashSet();
            for (String string : sessionBeanBean.getBusinessRemotes()) {
                object4.add(string);
            }
            Iterator iterator = object6.iterator();
            while (iterator.hasNext()) {
                Class clazz3 = (Class)iterator.next();
                if (object4.contains(clazz3.getName())) continue;
                sessionBeanBean.addBusinessLocal(clazz3.getName());
            }
        }
        if (sessionBeanBean.getBusinessRemotes().length == 0) {
            object4 = new HashSet();
            for (String string : sessionBeanBean.getBusinessLocals()) {
                object4.add(string);
            }
            for (Class clazz4 : hashSet) {
                if (object4.contains(clazz4.getName())) continue;
                sessionBeanBean.addBusinessRemote(clazz4.getName());
            }
        }
        if (sessionBeanBean.getHome() == null && sessionBeanBean.getLocalHome() == null && sessionBeanBean.getServiceEndpoint() == null && sessionBeanBean.getBusinessLocals().length == 0 && sessionBeanBean.getBusinessRemotes().length == 0 && set.size() > 0) {
            this.addFatalProcessingError("The session bean " + sessionBeanBean.getEjbName() + " does not have a client view specified.  Since the bean class " + clazz + " implements multiple interfaces, you must indicate which of these interfaces are local or remote business interfaces by means of the Local or Remote annotation or in the deployment descriptor.");
        }
        if (!this.isSet("TransactionType", sessionBeanBean)) {
            sessionBeanBean.setTransactionType(this.getTransactionType(clazz));
        }
        if (bl) {
            object4 = clazz.getAnnotation(Stateless.class);
            if (object4 != null && !this.isSet("MappedName", sessionBeanBean) && object4.mappedName().length() > 0) {
                sessionBeanBean.setMappedName(object4.mappedName());
            }
        } else {
            object4 = clazz.getAnnotation(Stateful.class);
            if (object4 != null && !this.isSet("MappedName", sessionBeanBean) && object4.mappedName().length() > 0) {
                sessionBeanBean.setMappedName(object4.mappedName());
            }
        }
        if (bl) {
            object4 = null;
            Method method = null;
            try {
                method = this.findAnnotatedTimeoutMethod(clazz);
                object4 = this.getTimeoutMethodByDD(clazz, (EnterpriseBeanBean)sessionBeanBean);
                TimeoutCheckHelper.validateTimeoutMethodsIdentical((Method)object4, method);
            }
            catch (ComplianceException complianceException) {
                throw new ErrorCollectionException((Throwable)complianceException);
            }
            if (object4 == null && method != null) {
                this.populateMethodBean(sessionBeanBean.createTimeoutMethod(), method);
            }
        }
        if (!(bl || sessionBeanBean.getInitMethods().length != 0 || (object4 = this.findAnnotatedMethods(clazz, Init.class, false)).isEmpty() || sessionBeanBean.getHome() == null && sessionBeanBean.getLocalHome() == null)) {
            Iterator iterator = object4.iterator();
            while (iterator.hasNext()) {
                Method method = (Method)iterator.next();
                Init init = method.getAnnotation(Init.class);
                String string = init.value();
                String string2 = init.value();
                object2 = null;
                object = null;
                if (string == null || string.length() == 0) {
                    List list;
                    Class clazz5;
                    if (sessionBeanBean.getHome() != null) {
                        clazz5 = this.cl.loadClass(sessionBeanBean.getHome());
                        list = ClassUtils.getMethodNamesForNameAndParams("create", method.getParameterTypes(), clazz5.getMethods());
                        if (list.size() == 0) {
                            genericDeclaration = EJBLogger.logNoMatchCreateMethodForInitMethodLoggable((String)method.toString(), (String)sessionBeanBean.getEjbName());
                            this.addProcessingError(genericDeclaration.getMessage());
                        } else if (list.size() > 1) {
                            this.addProcessingError("The value element of @Init annotation must be specified when the home interface:" + clazz5 + " of a stateful session bean:" + clazz + " that has more than one create<METHOD> method.");
                        } else {
                            string = (String)list.get(0);
                        }
                    }
                    if (sessionBeanBean.getLocalHome() != null) {
                        clazz5 = this.cl.loadClass(sessionBeanBean.getLocalHome());
                        list = ClassUtils.getMethodNamesForNameAndParams("create", method.getParameterTypes(), clazz5.getMethods());
                        if (list.size() == 0) {
                            genericDeclaration = EJBLogger.logNoMatchCreateMethodForInitMethodLoggable((String)method.toString(), (String)sessionBeanBean.getEjbName());
                            this.addProcessingError(genericDeclaration.getMessage());
                        } else if (list.size() > 1) {
                            this.addProcessingError("The value element of @Init annotation must be specified when the home interface:" + clazz5 + " of a stateful session bean:" + clazz + " that has more than one create<METHOD> method.");
                        } else {
                            String string3 = (String)list.get(0);
                        }
                    }
                }
                boolean bl2 = false;
                boolean bl3 = false;
                try {
                    if (sessionBeanBean.getHome() != null) {
                        genericDeclaration = this.cl.loadClass(sessionBeanBean.getHome());
                        object2 = ((Class)genericDeclaration).getMethod(string, method.getParameterTypes());
                        bl2 = true;
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                try {
                    if (sessionBeanBean.getLocalHome() != null) {
                        void var15_63;
                        genericDeclaration = this.cl.loadClass(sessionBeanBean.getLocalHome());
                        object = ((Class)genericDeclaration).getMethod((String)var15_63, method.getParameterTypes());
                        bl3 = true;
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                if (!bl2 && !bl3) {
                    genericDeclaration = EJBLogger.logNoMatchCreateMethodForInitMethodLoggable((String)method.toString(), (String)sessionBeanBean.getEjbName());
                    this.addProcessingError(genericDeclaration.getMessage());
                }
                if (bl2) {
                    genericDeclaration = sessionBeanBean.createInitMethod();
                    this.populateMethodBean(genericDeclaration.createBeanMethod(), method);
                    this.populateMethodBean(genericDeclaration.createCreateMethod(), (Method)object2);
                }
                if (!bl3) continue;
                genericDeclaration = sessionBeanBean.createInitMethod();
                this.populateMethodBean(genericDeclaration.createBeanMethod(), method);
                this.populateMethodBean(genericDeclaration.createCreateMethod(), (Method)object);
            }
        }
        if (!bl) {
            RemoveMethodBean[] removeMethodBeanArray;
            object4 = this.findAnnotatedMethods(clazz, Remove.class, false);
            for (RemoveMethodBean removeMethodBean : removeMethodBeanArray = sessionBeanBean.getRemoveMethods()) {
                object2 = removeMethodBean.getBeanMethod();
                object = object2.getMethodName();
                MethodParamsBean methodParamsBean = object2.getMethodParams();
                String[] stringArray = methodParamsBean == null ? new String[]{} : methodParamsBean.getMethodParams();
                genericDeclaration = ClassUtils.getMethodForNameAndParams((String)object, stringArray, (List)object4);
                if (!this.isSet("RetainIfException", removeMethodBean) && genericDeclaration != null) {
                    Remove remove = ((Method)genericDeclaration).getAnnotation(Remove.class);
                    removeMethodBean.setRetainIfException(remove.retainIfException());
                }
                if (genericDeclaration == null) continue;
                object4.remove(genericDeclaration);
            }
            Iterator iterator = object4.iterator();
            while (iterator.hasNext()) {
                Method method = (Method)iterator.next();
                Remove remove = method.getAnnotation(Remove.class);
                RemoveMethodBean removeMethodBean = sessionBeanBean.createRemoveMethod();
                this.populateMethodBean(removeMethodBean.createBeanMethod(), method);
                removeMethodBean.setRetainIfException(remove.retainIfException());
            }
        }
        this.processEjbCallbackAnnotations(clazz, (EjbCallbackBean)sessionBeanBean);
        this.processJ2eeAnnotations(clazz, (J2eeClientEnvironmentBean)sessionBeanBean);
        this.processDeclareRoles(clazz, (DescriptorBean)sessionBeanBean);
        this.processRunAs(clazz, (DescriptorBean)sessionBeanBean);
        this.processAssemblyDescriptor((EnterpriseBeanBean)sessionBeanBean, clazz, this.getInterfaceNames(sessionBeanBean), ejbDescriptorBean);
    }

    private Set<String> getInterfaceNames(SessionBeanBean sessionBeanBean) {
        HashSet<String> hashSet = new HashSet<String>();
        if (sessionBeanBean.getRemote() != null) {
            hashSet.add(sessionBeanBean.getRemote());
        }
        if (sessionBeanBean.getLocal() != null) {
            hashSet.add(sessionBeanBean.getLocal());
        }
        for (String string : sessionBeanBean.getBusinessLocals()) {
            hashSet.add(string);
        }
        for (String string : sessionBeanBean.getBusinessRemotes()) {
            hashSet.add(string);
        }
        return hashSet;
    }

    private Set<String> getInterfaceNames(MessageDrivenBeanBean messageDrivenBeanBean) {
        HashSet<String> hashSet = new HashSet<String>();
        String string = messageDrivenBeanBean.getMessagingType();
        if (string == null) {
            string = "javax.jms.MessageListener";
        }
        hashSet.add(string);
        return hashSet;
    }

    private void perhapsDeclareSecurityRoles(Collection<String> collection, EjbJarBean ejbJarBean) {
        HashSet<String> hashSet = new HashSet<String>();
        AssemblyDescriptorBean assemblyDescriptorBean = ejbJarBean.getAssemblyDescriptor();
        if (assemblyDescriptorBean == null) {
            assemblyDescriptorBean = ejbJarBean.createAssemblyDescriptor();
        }
        for (SecurityRoleBean securityRoleBean : assemblyDescriptorBean.getSecurityRoles()) {
            hashSet.add(securityRoleBean.getRoleName());
        }
        for (String string : collection) {
            if (hashSet.contains(string)) continue;
            assemblyDescriptorBean.createSecurityRole().setRoleName(string);
            hashSet.add(string);
        }
    }

    private void processEjbCallbackAnnotations(Class clazz, EjbCallbackBean ejbCallbackBean) {
        List<Method> list;
        if (ejbCallbackBean.getAroundInvokes().length == 0) {
            list = this.findAnnotatedMethods(clazz, AroundInvoke.class, true);
            for (Method method : list) {
                this.populateAroundInvokeBean(ejbCallbackBean.createAroundInvoke(), method);
            }
        }
        if (ejbCallbackBean.getPostActivates().length == 0) {
            list = this.findAnnotatedMethods(clazz, PostActivate.class, true);
            for (Method method : list) {
                this.populateLifecyleCallbackBean(ejbCallbackBean.createPostActivate(), method);
            }
        }
        if (ejbCallbackBean.getPrePassivates().length == 0) {
            list = this.findAnnotatedMethods(clazz, PrePassivate.class, true);
            for (Method method : list) {
                this.populateLifecyleCallbackBean(ejbCallbackBean.createPrePassivate(), method);
            }
        }
    }

    private void processAssemblyDescriptor(EnterpriseBeanBean enterpriseBeanBean, Class clazz, Set<String> set, EjbDescriptorBean ejbDescriptorBean) throws ErrorCollectionException {
        String string = enterpriseBeanBean.getEjbName();
        EjbJarBean ejbJarBean = ejbDescriptorBean.getEjbJarBean();
        AssemblyDescriptorBean assemblyDescriptorBean = ejbJarBean.getAssemblyDescriptor();
        if (assemblyDescriptorBean == null) {
            assemblyDescriptorBean = ejbJarBean.createAssemblyDescriptor();
        }
        Set<Class> set2 = this.getBusinessInterfaces(set);
        Set<Method> set3 = this.getBusinessMethods(clazz, set2, enterpriseBeanBean);
        this.processMethodPermissions(string, set3, assemblyDescriptorBean, ejbDescriptorBean);
        this.processTransactionAttributes(string, set3, assemblyDescriptorBean);
        this.processInterceptorBindings(string, clazz, set3, assemblyDescriptorBean);
        this.processApplicationExceptions(set3, assemblyDescriptorBean);
    }

    private void processApplicationExceptions(Set<Class> set, EjbJarBean ejbJarBean) {
        AssemblyDescriptorBean assemblyDescriptorBean = ejbJarBean.getAssemblyDescriptor();
        if (assemblyDescriptorBean == null) {
            assemblyDescriptorBean = ejbJarBean.createAssemblyDescriptor();
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (ApplicationExceptionBean applicationExceptionBean : assemblyDescriptorBean.getApplicationExceptions()) {
            hashSet.add(applicationExceptionBean.getExceptionClass());
        }
        for (Class clazz : set) {
            ApplicationExceptionBean applicationExceptionBean;
            if (hashSet.contains(clazz.getName())) continue;
            ApplicationExceptionBean applicationExceptionBean2 = assemblyDescriptorBean.createApplicationException();
            applicationExceptionBean2.setExceptionClass(clazz.getName());
            applicationExceptionBean = clazz.getAnnotation(ApplicationException.class);
            applicationExceptionBean2.setRollback(applicationExceptionBean.rollback());
        }
    }

    private void processApplicationExceptions(Set<Method> set, AssemblyDescriptorBean assemblyDescriptorBean) {
        HashSet hashSet = new HashSet();
        for (Method object : set) {
            Class<?>[] clazz = object.getExceptionTypes();
            int n = clazz.length;
            for (int applicationExceptionBean = 0; applicationExceptionBean < n; ++applicationExceptionBean) {
                Class<?> clazz2 = clazz[applicationExceptionBean];
                if (!clazz2.isAnnotationPresent(ApplicationException.class)) continue;
                hashSet.add(clazz2);
            }
        }
        HashSet hashSet2 = new HashSet();
        for (ApplicationExceptionBean applicationExceptionBean : assemblyDescriptorBean.getApplicationExceptions()) {
            hashSet2.add(applicationExceptionBean.getExceptionClass());
        }
        for (Class clazz : hashSet) {
            if (hashSet2.contains(clazz.getName())) continue;
            ApplicationExceptionBean applicationExceptionBean = assemblyDescriptorBean.createApplicationException();
            applicationExceptionBean.setExceptionClass(clazz.getName());
            ApplicationException applicationException = clazz.getAnnotation(ApplicationException.class);
            applicationExceptionBean.setRollback(applicationException.rollback());
        }
    }

    private void processInterceptorBindings(String string, Class clazz, Set<Method> set, AssemblyDescriptorBean assemblyDescriptorBean) {
        for (Method method : set) {
            boolean bl = false;
            boolean bl2 = false;
            int n = 0;
            if (method.isAnnotationPresent(Interceptors.class)) {
                bl = true;
            }
            if (method.isAnnotationPresent(ExcludeDefaultInterceptors.class)) {
                bl2 = true;
            }
            if (method.isAnnotationPresent(ExcludeClassInterceptors.class)) {
                n = 1;
            }
            if (!bl && !bl2 && n == 0) continue;
            InterceptorBindingBean interceptorBindingBean = this.getMethodInterceptorBinding(string, method, assemblyDescriptorBean, set);
            if (interceptorBindingBean == null) {
                interceptorBindingBean = assemblyDescriptorBean.createInterceptorBinding();
                interceptorBindingBean.setEjbName(string);
                this.populateMethodBean(interceptorBindingBean.createMethod(), method);
            }
            if (bl) {
                InterceptorBindingBean interceptorBindingBean2 = method.getAnnotation(Interceptors.class);
                this.perhapsAddInterceptors(interceptorBindingBean, (Interceptors)interceptorBindingBean2);
            }
            if (bl2 && !this.isSet("ExcludeDefaultInterceptors", interceptorBindingBean)) {
                interceptorBindingBean.setExcludeDefaultInterceptors(true);
            }
            if (n == 0 || this.isSet("ExcludeClassInterceptors", interceptorBindingBean)) continue;
            interceptorBindingBean.setExcludeClassInterceptors(true);
        }
        boolean bl = false;
        boolean bl3 = false;
        if (clazz.isAnnotationPresent(Interceptors.class)) {
            bl = true;
        }
        if (clazz.isAnnotationPresent(ExcludeDefaultInterceptors.class)) {
            bl3 = true;
        }
        if (bl || bl3) {
            InterceptorBindingBean interceptorBindingBean = null;
            for (InterceptorBindingBean interceptorBindingBean2 : assemblyDescriptorBean.getInterceptorBindings()) {
                if (!interceptorBindingBean2.getEjbName().equals(string) || interceptorBindingBean2.getMethod() != null) continue;
                interceptorBindingBean = interceptorBindingBean2;
            }
            if (interceptorBindingBean == null) {
                interceptorBindingBean = assemblyDescriptorBean.createInterceptorBinding();
                interceptorBindingBean.setEjbName(string);
            }
            if (bl) {
                Interceptors interceptors = clazz.getAnnotation(Interceptors.class);
                this.perhapsAddInterceptors(interceptorBindingBean, interceptors);
            }
            if (bl3 && !this.isSet("ExcludeDefaultInterceptors", interceptorBindingBean)) {
                interceptorBindingBean.setExcludeDefaultInterceptors(true);
            }
        }
    }

    private void perhapsAddInterceptors(InterceptorBindingBean interceptorBindingBean, Interceptors interceptors) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : interceptorBindingBean.getInterceptorClasses()) {
            hashSet.add(string);
        }
        String[] stringArray = interceptorBindingBean.getInterceptorClasses();
        interceptorBindingBean.setInterceptorClasses(null);
        for (Class object : interceptors.value()) {
            if (hashSet.contains(object.getName())) continue;
            interceptorBindingBean.addInterceptorClass(object.getName());
        }
        for (String string : stringArray) {
            interceptorBindingBean.addInterceptorClass(string);
        }
    }

    private InterceptorBindingBean getMethodInterceptorBinding(String string, Method method, AssemblyDescriptorBean assemblyDescriptorBean, Set<Method> set) {
        for (InterceptorBindingBean interceptorBindingBean : assemblyDescriptorBean.getInterceptorBindings()) {
            Class<?>[] classArray;
            NamedMethodBean namedMethodBean;
            if (!interceptorBindingBean.getEjbName().equals(string) || (namedMethodBean = interceptorBindingBean.getMethod()) == null || !method.getName().equals(namedMethodBean.getMethodName())) continue;
            MethodParamsBean methodParamsBean = namedMethodBean.getMethodParams();
            if (methodParamsBean == null) {
                Method method2;
                int n = 0;
                classArray = set.iterator();
                while (classArray.hasNext() && (!(method2 = (Method)classArray.next()).getName().equals(method.getName()) || ++n <= 1)) {
                }
                if (n != true) continue;
                return interceptorBindingBean;
            }
            String[] stringArray = methodParamsBean.getMethodParams();
            if (stringArray.length != (classArray = method.getParameterTypes()).length) continue;
            int n = 0;
            for (String string2 : stringArray) {
                if (!classArray[n].getName().equals(string2)) break;
                ++n;
            }
            if (n != stringArray.length) continue;
            return interceptorBindingBean;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void processInterceptorClasses(EjbDescriptorBean ejbDescriptorBean) throws ErrorCollectionException {
        InterceptorsBean interceptorsBean;
        EjbJarBean ejbJarBean = ejbDescriptorBean.getEjbJarBean();
        HashSet<void> hashSet = new HashSet<void>();
        AssemblyDescriptorBean assemblyDescriptorBean = ejbJarBean.getAssemblyDescriptor();
        if (assemblyDescriptorBean != null) {
            interceptorsBean = assemblyDescriptorBean.getInterceptorBindings();
            int n = ((InterceptorsBean)interceptorsBean).length;
            for (int i = 0; i < n; ++i) {
                void stringArray;
                InterceptorsBean interceptorsBean2 = interceptorsBean[i];
                Object var9_15 = null;
                if (interceptorsBean2.getInterceptorOrder() != null) {
                    String[] stringArray2 = interceptorsBean2.getInterceptorOrder().getInterceptorClasses();
                } else {
                    String[] stringArray3 = interceptorsBean2.getInterceptorClasses();
                }
                for (void var13_23 : stringArray) {
                    hashSet.add(var13_23);
                }
            }
        }
        if ((interceptorsBean = ejbJarBean.getInterceptors()) != null) {
            for (InterceptorBean interceptorBean : interceptorsBean.getInterceptors()) {
                this.processInterceptorClass(interceptorBean);
                hashSet.remove(interceptorBean.getInterceptorClass());
            }
        }
        if (!hashSet.isEmpty()) {
            if (interceptorsBean == null) {
                interceptorsBean = ejbJarBean.createInterceptors();
            }
            for (String string : hashSet) {
                InterceptorBean interceptorBean = interceptorsBean.createInterceptor();
                interceptorBean.setInterceptorClass(string);
                this.processInterceptorClass(interceptorBean);
            }
        }
    }

    private void processInterceptorClass(InterceptorBean interceptorBean) throws ErrorCollectionException {
        try {
            Class clazz = this.cl.loadClass(interceptorBean.getInterceptorClass());
            this.processJ2eeAnnotations(clazz, (J2eeClientEnvironmentBean)interceptorBean);
            this.processEjbCallbackAnnotations(clazz, (EjbCallbackBean)interceptorBean);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Loggable loggable = EJBLogger.logCannotLoadInterceptorClassLoggable((String)interceptorBean.getInterceptorClass().toString(), (String)classNotFoundException.toString());
            this.addFatalProcessingError(loggable.getMessage());
        }
    }

    private void processTransactionAttributes(String string, Set<Method> set, AssemblyDescriptorBean assemblyDescriptorBean) {
        HashSet<Method> hashSet = new HashSet<Method>();
        hashSet.addAll(set);
        set = hashSet;
        for (ContainerTransactionBean object : assemblyDescriptorBean.getContainerTransactions()) {
            for (weblogic.j2ee.descriptor.MethodBean methodBean : object.getMethods()) {
                if (!methodBean.getEjbName().equals(string)) continue;
                this.removeMethodsFromSet(methodBean, set);
            }
        }
        for (Method method : set) {
            Class<?> clazz;
            TransactionAttribute transactionAttribute = null;
            if (method.isAnnotationPresent(TransactionAttribute.class)) {
                transactionAttribute = method.getAnnotation(TransactionAttribute.class);
            }
            if (transactionAttribute == null && (clazz = method.getDeclaringClass()).isAnnotationPresent(TransactionAttribute.class)) {
                transactionAttribute = clazz.getAnnotation(TransactionAttribute.class);
            }
            if (transactionAttribute == null) continue;
            ContainerTransactionBean containerTransactionBean = assemblyDescriptorBean.createContainerTransaction();
            containerTransactionBean.setTransAttribute(this.getTransactionAttributeAsString(transactionAttribute.value()));
            this.fillMethodBean(containerTransactionBean.createMethod(), string, method);
        }
    }

    private void processMethodPermissions(String string, Set<Method> set, AssemblyDescriptorBean assemblyDescriptorBean, EjbDescriptorBean ejbDescriptorBean) {
        set = new HashSet<Method>(set);
        for (MethodPermissionBean methodPermissionBean : assemblyDescriptorBean.getMethodPermissions()) {
            for (weblogic.j2ee.descriptor.MethodBean methodBean2 : methodPermissionBean.getMethods()) {
                if (!methodBean2.getEjbName().equals(string)) continue;
                this.removeMethodsFromSet(methodBean2, set);
            }
        }
        ExcludeListBean excludeListBean = assemblyDescriptorBean.getExcludeList();
        if (excludeListBean != null) {
            for (weblogic.j2ee.descriptor.MethodBean methodBean : excludeListBean.getMethods()) {
                if (!methodBean.getEjbName().equals(string)) continue;
                this.removeMethodsFromSet(methodBean, set);
            }
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (Method method : set) {
            MethodPermissionBean methodPermissionBean;
            Object object;
            weblogic.j2ee.descriptor.MethodBean methodBean;
            methodBean = null;
            if (method.isAnnotationPresent(DenyAll.class)) {
                if (method.isAnnotationPresent(PermitAll.class) || method.isAnnotationPresent(RolesAllowed.class)) {
                    object = EJBLogger.logMutipleMehtodPermissionMethodForMethodLoggable((String)string, (String)method.toString());
                    this.addProcessingError(object.getMessage());
                }
                if (excludeListBean == null) {
                    excludeListBean = assemblyDescriptorBean.createExcludeList();
                }
                methodBean = excludeListBean.createMethod();
            } else if (method.isAnnotationPresent(PermitAll.class)) {
                if (method.isAnnotationPresent(RolesAllowed.class)) {
                    object = EJBLogger.logMutipleMehtodPermissionMethodForMethodLoggable((String)string, (String)method.toString());
                    this.addProcessingError(object.getMessage());
                }
                object = assemblyDescriptorBean.createMethodPermission();
                object.createUnchecked();
                methodBean = object.createMethod();
            } else if (method.isAnnotationPresent(RolesAllowed.class)) {
                object = method.getAnnotation(RolesAllowed.class);
                methodPermissionBean = assemblyDescriptorBean.createMethodPermission();
                methodPermissionBean.setRoleNames(object.value());
                methodBean = methodPermissionBean.createMethod();
                hashSet.addAll(Arrays.asList(object.value()));
            }
            if (methodBean == null) {
                object = method.getDeclaringClass();
                if (((Class)object).isAnnotationPresent(PermitAll.class)) {
                    if (((Class)object).isAnnotationPresent(RolesAllowed.class)) {
                        methodPermissionBean = EJBLogger.logMutipleMehtodPermissionMethodForClassLoggable((String)((Class)object).toString());
                        this.addProcessingError(methodPermissionBean.getMessage());
                    }
                    methodPermissionBean = assemblyDescriptorBean.createMethodPermission();
                    methodPermissionBean.createUnchecked();
                    methodBean = methodPermissionBean.createMethod();
                } else if (((Class)object).isAnnotationPresent(RolesAllowed.class)) {
                    weblogic.j2ee.descriptor.MethodBean methodBean2;
                    methodPermissionBean = ((Class)object).getAnnotation(RolesAllowed.class);
                    methodBean2 = assemblyDescriptorBean.createMethodPermission();
                    methodBean2.setRoleNames(methodPermissionBean.value());
                    methodBean = methodBean2.createMethod();
                    hashSet.addAll(Arrays.asList(methodPermissionBean.value()));
                }
            }
            if (methodBean == null) continue;
            this.fillMethodBean(methodBean, string, method);
        }
        if (!hashSet.isEmpty()) {
            this.perhapsDeclareSecurityRoles(hashSet, ejbDescriptorBean.getEjbJarBean());
        }
    }

    private void removeMethodsFromSet(weblogic.j2ee.descriptor.MethodBean methodBean, Set<Method> set) {
        MethodParamsBean methodParamsBean = methodBean.getMethodParams();
        HashSet<Method> hashSet = new HashSet<Method>();
        if (methodParamsBean == null) {
            if ("*".equals(methodBean.getMethodName())) {
                set.clear();
            } else {
                for (Method method : set) {
                    if (!method.getName().equals(methodBean.getMethodName())) continue;
                    hashSet.add(method);
                }
            }
        } else {
            String[] stringArray = methodParamsBean.getMethodParams();
            for (Method method : set) {
                Class<?>[] classArray;
                if (!method.getName().equals(methodBean.getMethodName()) || stringArray.length != (classArray = method.getParameterTypes()).length) continue;
                int n = 0;
                for (Class<?> clazz : classArray) {
                    if (!clazz.getName().equals(stringArray[n])) break;
                    ++n;
                }
                if (n != stringArray.length) continue;
                hashSet.add(method);
            }
        }
        set.removeAll(hashSet);
    }

    private Set<Class> getBusinessInterfaces(Collection<String> collection) throws ErrorCollectionException {
        HashSet<Class> hashSet = new HashSet<Class>();
        for (String string : collection) {
            Class clazz = null;
            try {
                clazz = this.cl.loadClass(string);
                hashSet.add(clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Loggable loggable = EJBLogger.logUnableLoadInterfaceClassLoggable((String)string, (String)classNotFoundException.toString());
                this.addFatalProcessingError(loggable.getMessage());
            }
        }
        return hashSet;
    }

    private Set<Method> getBusinessMethods(Class clazz, Set<Class> set, EnterpriseBeanBean enterpriseBeanBean) throws ErrorCollectionException {
        HashSet<Method> hashSet = new HashSet<Method>();
        for (Class clazz2 : set) {
            for (Method method : clazz2.getMethods()) {
                if (method.getDeclaringClass() == EJBObject.class || method.getDeclaringClass() == EJBLocalObject.class) continue;
                try {
                    hashSet.add(clazz.getMethod(method.getName(), method.getParameterTypes()));
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    Loggable loggable;
                    boolean bl = false;
                    if (!EJBObject.class.isAssignableFrom(clazz2) && !EJBLocalObject.class.isAssignableFrom(clazz2)) {
                        loggable = clazz.getMethods();
                        for (int i = 0; i < ((Loggable)loggable).length && !bl; ++i) {
                            bl = MethodUtils.potentialBridgeCandidate(method, (Method)loggable[i]);
                        }
                    }
                    loggable = null;
                    loggable = bl ? EJBLogger.logMayBeMissingBridgeMethodLoggable((String)method.toString(), (String)clazz2.getName()) : EJBLogger.logBeanClassNotImplementInterfaceMethodLoggable((String)clazz.getName(), (String)method.toString());
                    this.addFatalProcessingError(loggable.getMessage());
                }
            }
        }
        if (this.isWebService(enterpriseBeanBean, clazz)) {
            hashSet.addAll(this.getWebServiceMethods(enterpriseBeanBean, clazz));
        }
        return hashSet;
    }

    private boolean isWebService(EnterpriseBeanBean enterpriseBeanBean, Class clazz) {
        return enterpriseBeanBean instanceof SessionBeanBean && (clazz.isAnnotationPresent(WebService.class) || clazz.isAnnotationPresent(WebServiceProvider.class));
    }

    private Collection<Method> getWebServiceMethods(EnterpriseBeanBean enterpriseBeanBean, Class clazz) throws ErrorCollectionException {
        Class clazz2 = null;
        SessionBeanBean sessionBeanBean = (SessionBeanBean)enterpriseBeanBean;
        if (sessionBeanBean.getServiceEndpoint() != null) {
            try {
                clazz2 = this.cl.loadClass(sessionBeanBean.getServiceEndpoint());
            }
            catch (ClassNotFoundException classNotFoundException) {
                Loggable loggable = EJBLogger.logCannotFoundServiceEndPointClassLoggable((String)sessionBeanBean.getServiceEndpoint());
                this.addFatalProcessingError(loggable.getMessage());
            }
        }
        return DeployUtil.getWebServiceMethods(clazz, clazz2);
    }

    private void populateLifecyleCallbackBean(LifecycleCallbackBean lifecycleCallbackBean, Method method) {
        lifecycleCallbackBean.setBeanSource(1);
        lifecycleCallbackBean.setLifecycleCallbackClass(method.getDeclaringClass().getName());
        lifecycleCallbackBean.setLifecycleCallbackMethod(method.getName());
    }

    private void populateAroundInvokeBean(AroundInvokeBean aroundInvokeBean, Method method) {
        aroundInvokeBean.setClassName(method.getDeclaringClass().getName());
        aroundInvokeBean.setMethodName(method.getName());
    }

    private Method findAnnotatedTimeoutMethod(Class clazz) throws ComplianceException {
        List<Method> list = this.findAnnotatedMethods(clazz, Timeout.class, true);
        TimeoutCheckHelper.validateOnlyOneTimeoutMethod(list);
        Iterator iterator = list.iterator();
        if (iterator.hasNext()) {
            Method method = (Method)iterator.next();
            TimeoutCheckHelper.validateTimeoutMethodIsejbTimeout(clazz, method);
            return method;
        }
        return null;
    }

    private Method getTimeoutMethodByDD(Class clazz, EnterpriseBeanBean enterpriseBeanBean) throws ComplianceException {
        NamedMethodBean namedMethodBean = null;
        Class clazz2 = clazz;
        if (enterpriseBeanBean instanceof SessionBeanBean) {
            namedMethodBean = ((SessionBeanBean)enterpriseBeanBean).getTimeoutMethod();
        } else if (enterpriseBeanBean instanceof MessageDrivenBeanBean) {
            namedMethodBean = ((MessageDrivenBeanBean)enterpriseBeanBean).getTimeoutMethod();
        } else {
            return null;
        }
        if (namedMethodBean == null) {
            return null;
        }
        String string = namedMethodBean.getMethodName();
        if (string == null) {
            return null;
        }
        Method method = null;
        while (clazz2 != Object.class) {
            try {
                method = clazz2.getDeclaredMethod(string, Timer.class);
                break;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                clazz2 = clazz2.getSuperclass();
            }
        }
        TimeoutCheckHelper.validateTimeoutMethodExistsInBC(method, clazz, string);
        return method;
    }

    private List<Method> findAnnotatedMethods(Class clazz, Class clazz2, boolean bl) {
        ArrayList<Method> arrayList = new ArrayList<Method>();
        List<Method> list = bl ? this.getMethods(clazz) : Arrays.asList(clazz.getMethods());
        for (Method method : list) {
            if (!method.isAnnotationPresent(clazz2)) continue;
            arrayList.add(method);
        }
        return arrayList;
    }

    private List<Method> getAllMethods(Class clazz) {
        ArrayList<Method> arrayList = new ArrayList<Method>();
        Class clazz2 = clazz;
        while (!clazz2.equals(Object.class)) {
            Method[] methodArray;
            for (Method method : methodArray = clazz2.getDeclaredMethods()) {
                arrayList.add(method);
            }
            clazz2 = clazz2.getSuperclass();
        }
        return arrayList;
    }

    private void processMessageDrivenAnnotations(MessageDrivenBeanBean messageDrivenBeanBean, EjbDescriptorBean ejbDescriptorBean) throws ClassNotFoundException, ErrorCollectionException {
        Method method;
        Object object;
        Object object2;
        Class clazz = this.loadBeanClass(messageDrivenBeanBean.getEjbClass(), messageDrivenBeanBean.getEjbName(), (ClassLoader)this.cl);
        if (clazz.isAnnotationPresent(MessageDriven.class)) {
            object2 = clazz.getSuperclass();
            while (!object2.equals(Object.class)) {
                if (object2.isAnnotationPresent(MessageDriven.class)) {
                    object = EJBLogger.logMDBWithMDBParentLoggable((String)object2.getName(), (String)messageDrivenBeanBean.getEjbClass().toString());
                    this.addProcessingError(object.getMessage());
                    break;
                }
                object2 = object2.getSuperclass();
            }
        }
        if ((object2 = clazz.getAnnotation(MessageDriven.class)) != null) {
            if (!this.isSet("MessagingType", messageDrivenBeanBean) && object2.messageListenerInterface() != Object.class) {
                messageDrivenBeanBean.setMessagingType(object2.messageListenerInterface().getName());
            }
            this.processActivationConfigProperties(messageDrivenBeanBean, object2.activationConfig());
            if (!this.isSet("MappedName", messageDrivenBeanBean) && object2.mappedName().length() > 0) {
                messageDrivenBeanBean.setMappedName(object2.mappedName());
            }
        }
        if (messageDrivenBeanBean.getMessagingType() == null) {
            object = this.getImplementedInterfaces(clazz);
            if (object.size() == 1) {
                messageDrivenBeanBean.setMessagingType(((Class)object.iterator().next()).getName());
            } else {
                if (MessageListener.class.isAssignableFrom(clazz)) {
                    messageDrivenBeanBean.setMessagingType("javax.jms.MessageListener");
                }
                if (messageDrivenBeanBean.getMessagingType() == null) {
                    method = EJBLogger.logNoMessageListenerSpecifiedForMDBLoggable((String)messageDrivenBeanBean.getEjbName());
                    this.addFatalProcessingError(method.getMessage());
                }
            }
        }
        if (!this.isSet("TransactionType", messageDrivenBeanBean)) {
            messageDrivenBeanBean.setTransactionType(this.getTransactionType(clazz));
        }
        this.processJ2eeAnnotations(clazz, (J2eeClientEnvironmentBean)messageDrivenBeanBean);
        object = null;
        method = null;
        try {
            method = this.findAnnotatedTimeoutMethod(clazz);
            object = this.getTimeoutMethodByDD(clazz, (EnterpriseBeanBean)messageDrivenBeanBean);
            TimeoutCheckHelper.validateTimeoutMethodsIdentical((Method)object, method);
        }
        catch (ComplianceException complianceException) {
            throw new ErrorCollectionException((Throwable)complianceException);
        }
        if (object == null && method != null) {
            this.populateMethodBean(messageDrivenBeanBean.createTimeoutMethod(), method);
        }
        if (messageDrivenBeanBean.getAroundInvokes().length == 0) {
            List<Method> list = this.findAnnotatedMethods(clazz, AroundInvoke.class, true);
            for (Method method2 : list) {
                this.populateAroundInvokeBean(messageDrivenBeanBean.createAroundInvoke(), method2);
            }
        }
        this.processRunAs(clazz, (DescriptorBean)messageDrivenBeanBean);
        this.processAssemblyDescriptor((EnterpriseBeanBean)messageDrivenBeanBean, clazz, this.getInterfaceNames(messageDrivenBeanBean), ejbDescriptorBean);
    }

    private void processActivationConfigProperties(MessageDrivenBeanBean messageDrivenBeanBean, ActivationConfigProperty[] activationConfigPropertyArray) {
        if (activationConfigPropertyArray.length > 0) {
            ActivationConfigBean activationConfigBean = messageDrivenBeanBean.getActivationConfig();
            if (activationConfigBean == null) {
                activationConfigBean = messageDrivenBeanBean.createActivationConfig();
            }
            for (int i = 0; i < activationConfigPropertyArray.length; ++i) {
                ActivationConfigPropertyBean[] activationConfigPropertyBeanArray = activationConfigBean.getActivationConfigProperties();
                boolean bl = true;
                String string = activationConfigPropertyArray[i].propertyName();
                for (int j = 0; j < activationConfigPropertyBeanArray.length; ++j) {
                    if (!activationConfigPropertyBeanArray[j].getActivationConfigPropertyName().equalsIgnoreCase(string)) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                ActivationConfigPropertyBean activationConfigPropertyBean = activationConfigBean.createActivationConfigProperty();
                activationConfigPropertyBean.setActivationConfigPropertyName(activationConfigPropertyArray[i].propertyName());
                activationConfigPropertyBean.setActivationConfigPropertyValue(activationConfigPropertyArray[i].propertyValue());
            }
        }
    }

    private String getTransactionType(Class clazz) {
        TransactionManagement transactionManagement = clazz.getAnnotation(TransactionManagement.class);
        if (transactionManagement == null || transactionManagement.value() == TransactionManagementType.CONTAINER) {
            return "Container";
        }
        return "Bean";
    }

    private void populateMethodBean(NamedMethodBean namedMethodBean, Method method) {
        namedMethodBean.setMethodName(method.getName());
        MethodParamsBean methodParamsBean = namedMethodBean.createMethodParams();
        for (Class<?> clazz : method.getParameterTypes()) {
            methodParamsBean.addMethodParam(clazz.getCanonicalName());
        }
    }

    private void fillMethodBean(MethodBean methodBean, String string, Method method) {
        methodBean.setEjbName(string);
        methodBean.setMethodName(method.getName());
        weblogic.j2ee.descriptor.wl.MethodParamsBean methodParamsBean = methodBean.createMethodParams();
        for (Class<?> clazz : method.getParameterTypes()) {
            methodParamsBean.addMethodParam(clazz.getCanonicalName());
        }
    }

    private void fillMethodBean(weblogic.j2ee.descriptor.MethodBean methodBean, String string, Method method) {
        methodBean.setEjbName(string);
        methodBean.setMethodName(method.getName());
        MethodParamsBean methodParamsBean = methodBean.createMethodParams();
        Class<?>[] classArray = method.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            methodParamsBean.addMethodParam(classArray[i].getCanonicalName());
        }
    }

    private String getTransactionAttributeAsString(TransactionAttributeType transactionAttributeType) {
        switch (transactionAttributeType) {
            case MANDATORY: {
                return "Mandatory";
            }
            case REQUIRED: {
                return "Required";
            }
            case REQUIRES_NEW: {
                return "RequiresNew";
            }
            case SUPPORTS: {
                return "Supports";
            }
            case NOT_SUPPORTED: {
                return "NotSupported";
            }
            case NEVER: {
                return "Never";
            }
        }
        throw new AssertionError();
    }

    private Set<Class> getImplementedInterfaces(Class clazz) {
        HashSet<Class> hashSet = new HashSet<Class>();
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            if (classArray[i] == Serializable.class || classArray[i] == Externalizable.class || classArray[i].getName().startsWith("javax.") || classArray[i].getMethods().length == 0) continue;
            hashSet.add(classArray[i]);
        }
        return hashSet;
    }

    private boolean isExtendRemote(Class clazz) {
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            if (!clazz2.getName().equals(Remote.class.getName())) continue;
            return true;
        }
        return false;
    }

    public void processWLSAnnotations(EjbDescriptorBean ejbDescriptorBean, ClassLoader classLoader) throws ClassNotFoundException, ErrorCollectionException {
        Class<?> clazz;
        EjbJarBean ejbJarBean = ejbDescriptorBean.getEjbJarBean();
        if (ejbJarBean == null) {
            return;
        }
        EnterpriseBeansBean enterpriseBeansBean = ejbJarBean.getEnterpriseBeans();
        WeblogicEjbJarBean weblogicEjbJarBean = ejbDescriptorBean.getWeblogicEjbJarBean();
        for (SessionBeanBean sessionBeanBean : enterpriseBeansBean.getSessions()) {
            clazz = Class.forName(sessionBeanBean.getEjbClass(), false, classLoader);
            this.processWLSAnnotations(clazz, weblogicEjbJarBean, (EnterpriseBeanBean)sessionBeanBean, "Stateless".equals(sessionBeanBean.getSessionType()) ? EnterpriseBeanType.STATELESS : EnterpriseBeanType.STATEFUL);
        }
        for (SessionBeanBean sessionBeanBean : enterpriseBeansBean.getMessageDrivens()) {
            clazz = Class.forName(sessionBeanBean.getEjbClass(), false, classLoader);
            this.processWLSAnnotations(clazz, weblogicEjbJarBean, (EnterpriseBeanBean)sessionBeanBean, EnterpriseBeanType.MESSAGE_DRIVEN);
        }
    }

    private void processWLSAnnotations(Class clazz, WeblogicEjbJarBean weblogicEjbJarBean, EnterpriseBeanBean enterpriseBeanBean, EnterpriseBeanType enterpriseBeanType) throws ErrorCollectionException {
        String string = enterpriseBeanBean.getEjbName();
        this.processCallByReference(clazz, string, weblogicEjbJarBean, enterpriseBeanType);
        this.processJNDIName(clazz, enterpriseBeanBean, weblogicEjbJarBean, enterpriseBeanType);
        this.processTransactionTimeoutSeconds(clazz, string, weblogicEjbJarBean, enterpriseBeanType);
        this.processAllowRemoveDuringTransaction(clazz, string, weblogicEjbJarBean, enterpriseBeanType);
        this.processMessageDestinationConfiguration(clazz, string, weblogicEjbJarBean, enterpriseBeanType);
        this.processJMSClientID(clazz, string, weblogicEjbJarBean, enterpriseBeanType);
        this.processDisableWarnings(clazz, weblogicEjbJarBean, enterpriseBeanType);
        Set<Class> set = enterpriseBeanType == EnterpriseBeanType.MESSAGE_DRIVEN ? this.getBusinessInterfaces(this.getInterfaceNames((MessageDrivenBeanBean)enterpriseBeanBean)) : this.getBusinessInterfaces(this.getInterfaceNames((SessionBeanBean)enterpriseBeanBean));
        Set<Method> set2 = this.getBusinessMethods(clazz, set, enterpriseBeanBean);
        for (Method method : set2) {
            this.processIdempotent(method, string, weblogicEjbJarBean, enterpriseBeanType);
            this.processTransactionIsolation(method, string, weblogicEjbJarBean, enterpriseBeanType);
        }
        if (EJBComplianceChecker.isNeedCheck) {
            return;
        }
        this.throwProcessingErrors();
    }

    private void processCallByReference(Class clazz, String string, WeblogicEjbJarBean weblogicEjbJarBean, EnterpriseBeanType enterpriseBeanType) {
        CallByReference callByReference = this.assertContext(clazz, CallByReference.class, enterpriseBeanType);
        if (callByReference != null && !this.isSet("EnableCallByReference", this.getWLBean(string, weblogicEjbJarBean))) {
            this.getWLBean(string, weblogicEjbJarBean).setEnableCallByReference(true);
        }
    }

    private void processJNDIName(Class clazz, EnterpriseBeanBean enterpriseBeanBean, WeblogicEjbJarBean weblogicEjbJarBean, EnterpriseBeanType enterpriseBeanType) throws ErrorCollectionException {
        Loggable loggable;
        Object object;
        String string = enterpriseBeanBean.getEjbName();
        if (!(enterpriseBeanBean instanceof SessionBeanBean)) {
            this.assertContext(clazz, JNDIName.class, enterpriseBeanType);
            return;
        }
        Set<Class> set = this.getBusinessInterfaces(Arrays.asList(((SessionBeanBean)enterpriseBeanBean).getBusinessRemotes()));
        Set<Class> set2 = this.getBusinessInterfaces(Arrays.asList(((SessionBeanBean)enterpriseBeanBean).getBusinessLocals()));
        for (Class object2 : set2) {
            if (!object2.isAnnotationPresent(JNDIName.class)) continue;
            object = EJBLogger.logJNDINameAnnotationOnLocalInterfaceLoggable((String)object2.getName(), (String)enterpriseBeanBean.getEjbName());
            this.addProcessingError(object.getMessage());
        }
        if (set.size() == 1) {
            Object object2;
            loggable = set.iterator().next();
            JNDIName jNDIName = this.assertContext(clazz, JNDIName.class, enterpriseBeanType);
            object = this.assertContext((Class)loggable, JNDIName.class, enterpriseBeanType);
            if (jNDIName != null && object != null) {
                object2 = EJBLogger.logDuplicateJNDINameAnnotationLoggable((String)clazz.getName(), (String)loggable.getName());
                this.addProcessingError(object2.getMessage());
            }
            if (jNDIName == null && object == null) {
                return;
            }
            object2 = jNDIName == null ? object : jNDIName;
            this.addJNDIName((JNDIName)object2, enterpriseBeanType, string, weblogicEjbJarBean, (Class)loggable);
        } else if (set.size() > 1) {
            if (clazz.isAnnotationPresent(JNDIName.class)) {
                loggable = EJBLogger.logNoJNDINameOnMultiInterfaceImplLoggable((String)clazz.getName(), (String)set.toString());
                this.addProcessingError(loggable.getMessage());
            }
            for (Class clazz2 : set) {
                object = clazz2.getAnnotation(JNDIName.class);
                this.addJNDIName((JNDIName)object, enterpriseBeanType, string, weblogicEjbJarBean, clazz2);
            }
        }
    }

    private BusinessInterfaceJndiNameMapBean getBusinessInterfaceBean(EnterpriseBeanType enterpriseBeanType, String string, WeblogicEjbJarBean weblogicEjbJarBean, Class clazz) {
        BusinessInterfaceJndiNameMapBean businessInterfaceJndiNameMapBean;
        if (enterpriseBeanType == EnterpriseBeanType.STATELESS) {
            StatelessSessionDescriptorBean statelessSessionDescriptorBean = this.getWLBean(string, weblogicEjbJarBean).getStatelessSessionDescriptor();
            if (statelessSessionDescriptorBean == null) {
                statelessSessionDescriptorBean = this.getWLBean(string, weblogicEjbJarBean).createStatelessSessionDescriptor();
            }
            if ((businessInterfaceJndiNameMapBean = statelessSessionDescriptorBean.lookupBusinessInterfaceJndiNameMap(clazz.getName())) == null) {
                businessInterfaceJndiNameMapBean = statelessSessionDescriptorBean.createBusinessInterfaceJndiNameMap();
                businessInterfaceJndiNameMapBean.setBusinessRemote(clazz.getName());
            }
        } else {
            StatefulSessionDescriptorBean statefulSessionDescriptorBean = this.getWLBean(string, weblogicEjbJarBean).getStatefulSessionDescriptor();
            if (statefulSessionDescriptorBean == null) {
                statefulSessionDescriptorBean = this.getWLBean(string, weblogicEjbJarBean).createStatefulSessionDescriptor();
            }
            if ((businessInterfaceJndiNameMapBean = this.getWLBean(string, weblogicEjbJarBean).getStatefulSessionDescriptor().lookupBusinessInterfaceJndiNameMap(clazz.getName())) == null) {
                businessInterfaceJndiNameMapBean = this.getWLBean(string, weblogicEjbJarBean).getStatefulSessionDescriptor().createBusinessInterfaceJndiNameMap();
                businessInterfaceJndiNameMapBean.setBusinessRemote(clazz.getName());
            }
        }
        return businessInterfaceJndiNameMapBean;
    }

    private void addJNDIName(JNDIName jNDIName, EnterpriseBeanType enterpriseBeanType, String string, WeblogicEjbJarBean weblogicEjbJarBean, Class clazz) {
        BusinessInterfaceJndiNameMapBean businessInterfaceJndiNameMapBean;
        if (jNDIName != null && !"".equals(jNDIName.value().trim()) && !this.isSet("JNDIName", businessInterfaceJndiNameMapBean = this.getBusinessInterfaceBean(enterpriseBeanType, string, weblogicEjbJarBean, clazz))) {
            businessInterfaceJndiNameMapBean.setJNDIName(jNDIName.value());
        }
    }

    private void processTransactionTimeoutSeconds(Class clazz, String string, WeblogicEjbJarBean weblogicEjbJarBean, EnterpriseBeanType enterpriseBeanType) {
        TransactionTimeoutSeconds transactionTimeoutSeconds = this.assertContext(clazz, TransactionTimeoutSeconds.class, enterpriseBeanType);
        if (transactionTimeoutSeconds == null) {
            return;
        }
        TransactionDescriptorBean transactionDescriptorBean = this.getWLBean(string, weblogicEjbJarBean).getTransactionDescriptor();
        if (transactionDescriptorBean == null) {
            transactionDescriptorBean = this.getWLBean(string, weblogicEjbJarBean).createTransactionDescriptor();
        }
        if (!this.isSet("TransTimeoutSeconds", transactionDescriptorBean)) {
            transactionDescriptorBean.setTransTimeoutSeconds(transactionTimeoutSeconds.value());
            transactionTimeoutSeconds.value();
        }
    }

    private void processAllowRemoveDuringTransaction(Class clazz, String string, WeblogicEjbJarBean weblogicEjbJarBean, EnterpriseBeanType enterpriseBeanType) {
        AllowRemoveDuringTransaction allowRemoveDuringTransaction = this.assertContext(clazz, AllowRemoveDuringTransaction.class, enterpriseBeanType);
        if (allowRemoveDuringTransaction == null) {
            return;
        }
        StatefulSessionDescriptorBean statefulSessionDescriptorBean = this.getWLBean(string, weblogicEjbJarBean).getStatefulSessionDescriptor();
        if (statefulSessionDescriptorBean == null) {
            statefulSessionDescriptorBean = this.getWLBean(string, weblogicEjbJarBean).createStatefulSessionDescriptor();
        }
        if (!this.isSet("AllowRemoveDuringTransaction", statefulSessionDescriptorBean)) {
            statefulSessionDescriptorBean.setAllowRemoveDuringTransaction(true);
        }
    }

    private void processMessageDestinationConfiguration(Class clazz, String string, WeblogicEjbJarBean weblogicEjbJarBean, EnterpriseBeanType enterpriseBeanType) {
        MessageDestinationConfiguration messageDestinationConfiguration = this.assertContext(clazz, MessageDestinationConfiguration.class, enterpriseBeanType);
        if (messageDestinationConfiguration == null) {
            return;
        }
        MessageDrivenDescriptorBean messageDrivenDescriptorBean = this.getWLBean(string, weblogicEjbJarBean).getMessageDrivenDescriptor();
        if (messageDrivenDescriptorBean == null) {
            messageDrivenDescriptorBean = this.getWLBean(string, weblogicEjbJarBean).createMessageDrivenDescriptor();
        }
        if (!this.isSet("ConnectionFactoryJNDIName", messageDrivenDescriptorBean) && !"".equals(messageDestinationConfiguration.connectionFactoryJNDIName())) {
            messageDrivenDescriptorBean.setConnectionFactoryJNDIName(messageDestinationConfiguration.connectionFactoryJNDIName());
        }
        if (!this.isSet("InitialContextFactory", messageDrivenDescriptorBean)) {
            messageDrivenDescriptorBean.setInitialContextFactory(messageDestinationConfiguration.initialContextFactory().getName());
        }
        if (!this.isSet("ProviderUrl", messageDrivenDescriptorBean) && !"".equals(messageDestinationConfiguration.providerURL())) {
            messageDrivenDescriptorBean.setProviderUrl(messageDestinationConfiguration.providerURL());
        }
    }

    private void processJMSClientID(Class clazz, String string, WeblogicEjbJarBean weblogicEjbJarBean, EnterpriseBeanType enterpriseBeanType) {
        JMSClientID jMSClientID = this.assertContext(clazz, JMSClientID.class, enterpriseBeanType);
        if (jMSClientID == null) {
            return;
        }
        MessageDrivenDescriptorBean messageDrivenDescriptorBean = this.getWLBean(string, weblogicEjbJarBean).getMessageDrivenDescriptor();
        if (messageDrivenDescriptorBean == null) {
            messageDrivenDescriptorBean = this.getWLBean(string, weblogicEjbJarBean).createMessageDrivenDescriptor();
        }
        if (!this.isSet("JmsClientId", messageDrivenDescriptorBean)) {
            messageDrivenDescriptorBean.setJmsClientId(jMSClientID.value());
        }
        if (!this.isSet("GenerateUniqueJmsClientId", messageDrivenDescriptorBean)) {
            messageDrivenDescriptorBean.setGenerateUniqueJmsClientId(jMSClientID.generateUniqueID());
        }
    }

    private void processDisableWarnings(Class clazz, WeblogicEjbJarBean weblogicEjbJarBean, EnterpriseBeanType enterpriseBeanType) {
        DisableWarnings disableWarnings = this.assertContext(clazz, DisableWarnings.class, enterpriseBeanType);
        if (disableWarnings != null) {
            if (this.disableWarningsIsInXML == null) {
                this.disableWarningsIsInXML = this.isSet("DisableWarnings", weblogicEjbJarBean);
            }
            if (!this.disableWarningsIsInXML.booleanValue()) {
                for (WarningCode warningCode : disableWarnings.value()) {
                    weblogicEjbJarBean.addDisableWarning(warningCode.getWeblogicCode());
                }
            }
        }
    }

    private void processIdempotent(Method method, String string, WeblogicEjbJarBean weblogicEjbJarBean, EnterpriseBeanType enterpriseBeanType) {
        RetryMethodsOnRollbackBean retryMethodsOnRollbackBean;
        MethodBean methodBean;
        Idempotent idempotent = this.assertContext(method, Idempotent.class, enterpriseBeanType);
        if (idempotent == null) {
            return;
        }
        IdempotentMethodsBean idempotentMethodsBean = weblogicEjbJarBean.getIdempotentMethods();
        if (idempotentMethodsBean == null) {
            idempotentMethodsBean = weblogicEjbJarBean.createIdempotentMethods();
        }
        if ((methodBean = this.findMethod(method, string, idempotentMethodsBean.getMethods())) == null) {
            methodBean = idempotentMethodsBean.createMethod();
            this.fillMethodBean(methodBean, string, method);
        }
        RetryMethodsOnRollbackBean retryMethodsOnRollbackBean2 = weblogicEjbJarBean.getRetryMethodsOnRollbacks();
        methodBean = null;
        if (retryMethodsOnRollbackBean2 == null || ((RetryMethodsOnRollbackBean[])retryMethodsOnRollbackBean2).length == 0) {
            retryMethodsOnRollbackBean2 = new RetryMethodsOnRollbackBean[1];
        } else {
            RetryMethodsOnRollbackBean retryMethodsOnRollbackBean3;
            retryMethodsOnRollbackBean = retryMethodsOnRollbackBean2;
            int n = ((RetryMethodsOnRollbackBean[])retryMethodsOnRollbackBean).length;
            for (int i = 0; i < n && (methodBean = this.findMethod(method, string, (retryMethodsOnRollbackBean3 = retryMethodsOnRollbackBean[i]).getMethods())) == null; ++i) {
            }
        }
        if (methodBean == null) {
            retryMethodsOnRollbackBean = weblogicEjbJarBean.createRetryMethodsOnRollback();
            retryMethodsOnRollbackBean.setRetryCount(idempotent.retryOnRollbackCount());
            methodBean = retryMethodsOnRollbackBean.createMethod();
            this.fillMethodBean(methodBean, string, method);
        }
    }

    private void processTransactionIsolation(Method method, String string, WeblogicEjbJarBean weblogicEjbJarBean, EnterpriseBeanType enterpriseBeanType) {
        TransactionIsolationBean transactionIsolationBean;
        TransactionIsolation transactionIsolation = this.assertContext(method, TransactionIsolation.class, enterpriseBeanType);
        if (transactionIsolation == null) {
            return;
        }
        TransactionIsolationBean transactionIsolationBean2 = weblogicEjbJarBean.getTransactionIsolations();
        MethodBean methodBean = null;
        if (transactionIsolationBean2 == null || ((TransactionIsolationBean[])transactionIsolationBean2).length == 0) {
            transactionIsolationBean2 = new TransactionIsolationBean[1];
        } else {
            TransactionIsolationBean transactionIsolationBean3;
            transactionIsolationBean = transactionIsolationBean2;
            int n = ((TransactionIsolationBean[])transactionIsolationBean).length;
            for (int i = 0; i < n && (methodBean = this.findMethod(method, string, (transactionIsolationBean3 = transactionIsolationBean[i]).getMethods())) == null; ++i) {
            }
        }
        if (methodBean == null) {
            transactionIsolationBean = weblogicEjbJarBean.createTransactionIsolation();
            transactionIsolationBean.setIsolationLevel(transactionIsolation.value().getWeblogicIsolationString());
            methodBean = transactionIsolationBean.createMethod();
            this.fillMethodBean(methodBean, string, method);
        }
    }

    private boolean isSet(String string, WeblogicEjbJarBean weblogicEjbJarBean, String string2) {
        if (weblogicEjbJarBean == null) {
            return false;
        }
        WeblogicEnterpriseBeanBean weblogicEnterpriseBeanBean = weblogicEjbJarBean.lookupWeblogicEnterpriseBean(string);
        if (weblogicEnterpriseBeanBean == null) {
            return false;
        }
        return this.isSet(string2, weblogicEnterpriseBeanBean);
    }

    private <T extends Annotation> T assertContext(Class clazz, Class<T> clazz2, EnterpriseBeanType enterpriseBeanType) {
        T t = clazz.getAnnotation(clazz2);
        if (t != null && !enterpriseBeanType.validAnnotationTypes.contains(clazz2)) {
            Loggable loggable = EJBLogger.logAnnotationOnInvalidClassLoggable((String)clazz2.getName(), (String)clazz.getName());
            throw new IllegalStateException(loggable.getMessage());
        }
        return t;
    }

    private <T extends Annotation> T assertContext(Method method, Class<T> clazz, EnterpriseBeanType enterpriseBeanType) {
        T t = method.getAnnotation(clazz);
        if (t != null && !enterpriseBeanType.validAnnotationTypes.contains(clazz)) {
            Loggable loggable = EJBLogger.logAnnotationOnInvalidMethodLoggable((String)clazz.getName(), (String)method.getDeclaringClass().getName(), (String)method.getName());
            throw new IllegalStateException(loggable.getMessage());
        }
        return t;
    }

    private WeblogicEnterpriseBeanBean getWLBean(String string, WeblogicEjbJarBean weblogicEjbJarBean) {
        WeblogicEnterpriseBeanBean weblogicEnterpriseBeanBean = weblogicEjbJarBean.lookupWeblogicEnterpriseBean(string);
        if (weblogicEnterpriseBeanBean == null) {
            weblogicEnterpriseBeanBean = weblogicEjbJarBean.createWeblogicEnterpriseBean();
            weblogicEnterpriseBeanBean.setEjbName(string);
        }
        return weblogicEnterpriseBeanBean;
    }

    private MethodBean findMethod(Method method, String string, MethodBean[] methodBeanArray) {
        MethodBean methodBean = null;
        block0: for (MethodBean methodBean2 : methodBeanArray) {
            if (!string.equals(methodBean2.getEjbName()) || !method.getName().equals(methodBean2.getMethodName())) continue;
            if (methodBean2.getMethodParams() == null) {
                methodBean = methodBean2;
                continue;
            }
            String[] stringArray = methodBean2.getMethodParams().getMethodParams();
            if (stringArray == null) {
                methodBean = methodBean2;
                continue;
            }
            Class<?>[] classArray = method.getParameterTypes();
            if (stringArray.length != classArray.length) continue;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(classArray[i].getCanonicalName())) continue block0;
            }
            return methodBean2;
        }
        return null;
    }

    private Class loadBeanClass(String string, String string2, ClassLoader classLoader) throws ErrorCollectionException, ClassNotFoundException {
        if (string == null || string.trim().length() == 0) {
            this.addProcessingError("In the ejb-jar.xml, the EJB " + string2 + " does not specify an ejb-class value and no annotated EJB class was found in the ejb-jar file with a matching ejb-name.  The ejb-class value must be specified.");
            this.throwProcessingErrors();
        }
        return classLoader.loadClass(string);
    }

    public static void main(String[] stringArray) throws Exception {
        EjbDescriptorBean ejbDescriptorBean = new EjbDescriptorBean(true);
        VirtualJarFile virtualJarFile = VirtualJarFactory.createVirtualJar((File)new File(stringArray[0]));
        ClasspathClassFinder2 classpathClassFinder2 = new ClasspathClassFinder2(stringArray[0]);
        GenericClassLoader genericClassLoader = new GenericClassLoader((ClassFinder)classpathClassFinder2);
        EjbAnnotationProcessor ejbAnnotationProcessor = new EjbAnnotationProcessor(genericClassLoader);
        ejbAnnotationProcessor.processAnnotations(ejbDescriptorBean, virtualJarFile);
        System.out.println("\n\n");
        DescriptorBean descriptorBean = (DescriptorBean)ejbDescriptorBean.getEjbJarBean();
        descriptorBean.getDescriptor().toXML((OutputStream)System.out);
    }

    @Override
    protected void addBeanInterfaceNotSetError(J2eeClientEnvironmentBean j2eeClientEnvironmentBean) {
        if (j2eeClientEnvironmentBean instanceof EnterpriseBeanBean) {
            String string = ((EnterpriseBeanBean)j2eeClientEnvironmentBean).getEjbClass();
            Loggable loggable = EJBLogger.logNoSetBeanInterfaceForBeanLoggable((String)string);
            this.addProcessingError(loggable.getMessage());
        } else if (j2eeClientEnvironmentBean instanceof InterceptorBean) {
            String string = ((InterceptorBean)j2eeClientEnvironmentBean).getInterceptorClass();
            Loggable loggable = EJBLogger.logNoSetBeanInterfaceForInterceptorLoggable((String)string);
            this.addProcessingError(loggable.getMessage());
        }
    }

    @Override
    protected void perhapsDeclareRunAs(DescriptorBean descriptorBean, String string) {
        EnterpriseBeanBean enterpriseBeanBean = (EnterpriseBeanBean)descriptorBean;
        SecurityIdentityBean securityIdentityBean = enterpriseBeanBean.getSecurityIdentity();
        if (securityIdentityBean == null) {
            securityIdentityBean = enterpriseBeanBean.createSecurityIdentity();
            RunAsBean runAsBean = securityIdentityBean.createRunAs();
            runAsBean.setRoleName(string);
        }
    }

    @Override
    protected void perhapsDeclareRoles(DescriptorBean descriptorBean, String[] stringArray) {
        SessionBeanBean sessionBeanBean = (SessionBeanBean)descriptorBean;
        HashSet<String> hashSet = new HashSet<String>();
        for (SecurityRoleRefBean securityRoleRefBean : sessionBeanBean.getSecurityRoleRefs()) {
            hashSet.add(securityRoleRefBean.getRoleName());
        }
        EjbJarBean ejbJarBean = (EjbJarBean)descriptorBean.getDescriptor().getRootBean();
        this.perhapsDeclareSecurityRoles(Arrays.asList(stringArray), ejbJarBean);
        for (String string : stringArray) {
            if (hashSet.contains(string)) continue;
            SecurityRoleRefBean securityRoleRefBean = sessionBeanBean.createSecurityRoleRef();
            securityRoleRefBean.setRoleName(string);
            hashSet.add(string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum EnterpriseBeanType {
        STATELESS(TransactionTimeoutSeconds.class, DisableWarnings.class, CallByReference.class, JNDIName.class, Idempotent.class, TransactionIsolation.class),
        STATEFUL(TransactionTimeoutSeconds.class, DisableWarnings.class, CallByReference.class, JNDIName.class, AllowRemoveDuringTransaction.class, Idempotent.class, TransactionIsolation.class),
        MESSAGE_DRIVEN(TransactionTimeoutSeconds.class, DisableWarnings.class, MessageDestinationConfiguration.class, JMSClientID.class, TransactionIsolation.class);

        private final Collection validAnnotationTypes = new HashSet();

        private EnterpriseBeanType(Class ... classArray) {
            this.validAnnotationTypes.addAll(Arrays.asList(classArray));
        }
    }
}

