/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.dd.xml;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.xml.sax.InputSource;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.compliance.ComplianceException;
import weblogic.ejb.container.compliance.WeblogicJarChecker;
import weblogic.ejb.container.dd.DDConstants;
import weblogic.ejb.container.dd.xml.AnnotationDebugger;
import weblogic.ejb.container.dd.xml.DDLoader;
import weblogic.ejb.container.dd.xml.DDUtils;
import weblogic.ejb.container.dd.xml.EjbAnnotationProcessor;
import weblogic.ejb.container.dd.xml.EjbJarDescriptorFactory;
import weblogic.ejb.container.deployer.EJBDescriptorMBeanUtils;
import weblogic.ejb.spi.EjbDescriptorBean;
import weblogic.ejb.spi.EjbDescriptorReader;
import weblogic.ejb.spi.EjbJarDescriptor;
import weblogic.j2ee.descriptor.ActivationConfigBean;
import weblogic.j2ee.descriptor.AroundInvokeBean;
import weblogic.j2ee.descriptor.AssemblyDescriptorBean;
import weblogic.j2ee.descriptor.EjbJarBean;
import weblogic.j2ee.descriptor.EnterpriseBeansBean;
import weblogic.j2ee.descriptor.EntityBeanBean;
import weblogic.j2ee.descriptor.InterceptorBean;
import weblogic.j2ee.descriptor.InterceptorsBean;
import weblogic.j2ee.descriptor.LifecycleCallbackBean;
import weblogic.j2ee.descriptor.MessageDrivenBeanBean;
import weblogic.j2ee.descriptor.SecurityRoleRefBean;
import weblogic.j2ee.descriptor.SessionBeanBean;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.j2ee.descriptor.wl.EntityDescriptorBean;
import weblogic.j2ee.descriptor.wl.MessageDrivenDescriptorBean;
import weblogic.j2ee.descriptor.wl.ModuleDescriptorBean;
import weblogic.j2ee.descriptor.wl.ModuleOverrideBean;
import weblogic.j2ee.descriptor.wl.WeblogicEjbJarBean;
import weblogic.j2ee.descriptor.wl.WeblogicEnterpriseBeanBean;
import weblogic.logging.Loggable;
import weblogic.utils.ErrorCollectionException;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.DelegateFinder;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.jars.VirtualJarFactory;
import weblogic.utils.jars.VirtualJarFile;
import weblogic.xml.process.ProcessorFactory;
import weblogic.xml.process.ProcessorFactoryException;
import weblogic.xml.process.XMLParsingException;
import weblogic.xml.process.XMLProcessingException;

public final class EjbDescriptorReaderImpl
implements EjbDescriptorReader {
    private static final boolean debug = false;
    private static final XMLInputFactory xiFactory;
    private static final int BUF_SIZE = 16384;
    private static final int MAX_DTD_ELEMENTS = 10;
    public static final String WEBLOGIC_EJB_JAR_NAME = "META-INF/weblogic-ejb-jar.xml";
    public static final String EJB_JAR_NAME = "META-INF/ejb-jar.xml";

    public EjbDescriptorBean createDescriptorFromJarFile(JarFile jarFile) throws IOException, XMLParsingException, XMLProcessingException, XMLStreamException {
        return this.createDescriptorFromJarFile(jarFile, null);
    }

    public EjbDescriptorBean createDescriptorFromJarFile(JarFile jarFile, File file) throws IOException, XMLParsingException, XMLProcessingException, XMLStreamException {
        return this.createDescriptorFromJarFile(VirtualJarFactory.createVirtualJar((JarFile)jarFile), file);
    }

    public EjbDescriptorBean createDescriptorFromJarFile(VirtualJarFile virtualJarFile) throws IOException, XMLParsingException, XMLProcessingException, XMLStreamException {
        return this.createDescriptorFromJarFile(virtualJarFile, null);
    }

    public EjbDescriptorBean createDescriptorFromJarFile(VirtualJarFile virtualJarFile, File file) throws IOException, XMLParsingException, XMLProcessingException, XMLStreamException {
        return this.createDescriptorFromJarFile(virtualJarFile, file, null, null);
    }

    public EjbDescriptorBean createDescriptorFromJarFile(VirtualJarFile virtualJarFile, File file, String string, String string2) throws IOException, XMLParsingException, XMLProcessingException, XMLStreamException {
        return this.createDescriptorFromJarFile(virtualJarFile, file, null, null, string, string2);
    }

    public EjbDescriptorBean createReadOnlyDescriptorFromJarFile(VirtualJarFile virtualJarFile, GenericClassLoader genericClassLoader) throws IOException, XMLParsingException, XMLProcessingException, XMLStreamException {
        return this.createReadOnlyDescriptorFromJarFile(virtualJarFile, null, null, null, null, null, genericClassLoader, null);
    }

    public EjbDescriptorBean createDescriptorFromJarFile(VirtualJarFile virtualJarFile, File file, File file2, DeploymentPlanBean deploymentPlanBean, String string, String string2) throws IOException, XMLParsingException, XMLProcessingException, XMLStreamException {
        EjbDescriptorBean ejbDescriptorBean = EjbDescriptorReaderImpl.createEjbDescriptorBean(virtualJarFile, string, string2, deploymentPlanBean, file2, false);
        EjbDescriptorReaderImpl.processEjbJarXML(ejbDescriptorBean, virtualJarFile, file, file2, deploymentPlanBean, string, string2, null);
        EjbDescriptorReaderImpl.processWeblogicEjbJarXML(ejbDescriptorBean, virtualJarFile, file2, deploymentPlanBean, string, string2);
        return ejbDescriptorBean;
    }

    public EjbDescriptorBean createReadOnlyDescriptorFromJarFile(VirtualJarFile virtualJarFile, File file, File file2, DeploymentPlanBean deploymentPlanBean, String string, String string2, GenericClassLoader genericClassLoader, VirtualJarFile[] virtualJarFileArray) throws IOException, XMLParsingException, XMLProcessingException, XMLStreamException {
        GenericClassLoader genericClassLoader2 = null;
        EjbDescriptorBean ejbDescriptorBean = EjbDescriptorReaderImpl.createEjbDescriptorBean(virtualJarFile, string, string2, deploymentPlanBean, file2, true);
        EjbDescriptorReaderImpl.processEjbJarXML(ejbDescriptorBean, virtualJarFile, file, file2, deploymentPlanBean, string, string2, virtualJarFileArray);
        AnnotationDebugger.info("The ejb-jar.xml in " + ejbDescriptorBean.getJarFileName() + " before the processing of EJB annotation:");
        AnnotationDebugger.logEjbJar(ejbDescriptorBean);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            genericClassLoader2 = EjbDescriptorReaderImpl.createAnnotationProcessorClassLoader(genericClassLoader);
            Thread.currentThread().setContextClassLoader((ClassLoader)genericClassLoader2);
            EjbDescriptorReaderImpl.processStandardAnnotations(ejbDescriptorBean, virtualJarFile, genericClassLoader2);
            AnnotationDebugger.info("The ejb-jar.xml in " + ejbDescriptorBean.getJarFileName() + " after the processing of EJB annotation:");
            AnnotationDebugger.logEjbJar(ejbDescriptorBean);
            AnnotationDebugger.info("The weblogic-ejb-jar.xml in " + ejbDescriptorBean.getJarFileName() + " before the processing of Weblogic's EJB annotation:");
            EjbDescriptorReaderImpl.processWeblogicEjbJarXML(ejbDescriptorBean, virtualJarFile, file2, deploymentPlanBean, string, string2);
            AnnotationDebugger.logWlsEjbJar(ejbDescriptorBean);
            EjbDescriptorReaderImpl.processWLSAnnotations(ejbDescriptorBean, genericClassLoader2);
            AnnotationDebugger.info("The weblogic-ejb-jar.xml in " + ejbDescriptorBean.getJarFileName() + " after the processing of Weblogic's EJB annotation:");
            AnnotationDebugger.logWlsEjbJar(ejbDescriptorBean);
            WeblogicJarChecker.validateEnterpriseBeansMinimalConfiguration(ejbDescriptorBean.getEjbJarBean(), string2);
            EjbDescriptorReaderImpl.completeEjbJar(ejbDescriptorBean);
            EjbDescriptorReaderImpl.completeWeblogicEjbJar(ejbDescriptorBean);
            EjbDescriptorBean ejbDescriptorBean2 = ejbDescriptorBean;
            return ejbDescriptorBean2;
        }
        catch (ComplianceException complianceException) {
            throw new IOException(complianceException.getMessage());
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
            if (genericClassLoader2 != null) {
                genericClassLoader2.close();
            }
        }
    }

    private static EjbDescriptorBean createEjbDescriptorBean(VirtualJarFile virtualJarFile, String string, String string2, DeploymentPlanBean deploymentPlanBean, File file, boolean bl) {
        EjbDescriptorBean ejbDescriptorBean = new EjbDescriptorBean(bl);
        ejbDescriptorBean.setAppName(string);
        ejbDescriptorBean.setUri(string2);
        ejbDescriptorBean.setDeploymentPlan(deploymentPlanBean);
        ejbDescriptorBean.setConfigDirectory(file);
        ejbDescriptorBean.setJarFileName(virtualJarFile.getName());
        return ejbDescriptorBean;
    }

    private static void processEjbJarXML(EjbDescriptorBean ejbDescriptorBean, VirtualJarFile virtualJarFile, File file, File file2, DeploymentPlanBean deploymentPlanBean, String string, String string2, VirtualJarFile[] virtualJarFileArray) throws IOException, XMLStreamException {
        if (file != null || virtualJarFile.getEntry(EJB_JAR_NAME) != null || virtualJarFileArray != null) {
            EjbDescriptorReaderImpl.processEjbJarXMLWithSchema(virtualJarFile, file, file2, deploymentPlanBean, ejbDescriptorBean, string, string2, virtualJarFileArray);
        }
    }

    private static void completeEjbJar(EjbDescriptorBean ejbDescriptorBean) {
        InterceptorsBean interceptorsBean;
        EjbJarBean ejbJarBean = ejbDescriptorBean.getEjbJarBean();
        if (!ejbDescriptorBean.isEjb30()) {
            return;
        }
        InterceptorsBean interceptorsBean2 = interceptorsBean = ejbJarBean.getEnterpriseBeans().getSessions();
        int n = ((SessionBeanBean[])interceptorsBean2).length;
        for (int i = 0; i < n; ++i) {
            SessionBeanBean sessionBeanBean = interceptorsBean2[i];
            String string = sessionBeanBean.getEjbClass();
            EjbDescriptorReaderImpl.addAroundInvokeDefaults(sessionBeanBean.getAroundInvokes(), string);
            EjbDescriptorReaderImpl.addLifecycleCallbackDefaults(sessionBeanBean.getPostActivates(), string);
            EjbDescriptorReaderImpl.addLifecycleCallbackDefaults(sessionBeanBean.getPrePassivates(), string);
            EjbDescriptorReaderImpl.addLifecycleCallbackDefaults(sessionBeanBean.getPostConstructs(), string);
            EjbDescriptorReaderImpl.addLifecycleCallbackDefaults(sessionBeanBean.getPreDestroys(), string);
        }
        for (String string : interceptorsBean2 = ejbJarBean.getEnterpriseBeans().getMessageDrivens()) {
            String string2 = string.getEjbClass();
            EjbDescriptorReaderImpl.addAroundInvokeDefaults(string.getAroundInvokes(), string2);
            EjbDescriptorReaderImpl.addLifecycleCallbackDefaults(string.getPostConstructs(), string2);
            EjbDescriptorReaderImpl.addLifecycleCallbackDefaults(string.getPreDestroys(), string2);
        }
        InterceptorsBean interceptorsBean3 = ejbJarBean.getInterceptors();
        if (interceptorsBean3 != null) {
            for (InterceptorBean interceptorBean : interceptorsBean3.getInterceptors()) {
                String string = interceptorBean.getInterceptorClass();
                EjbDescriptorReaderImpl.addAroundInvokeDefaults(interceptorBean.getAroundInvokes(), string);
                EjbDescriptorReaderImpl.addLifecycleCallbackDefaults(interceptorBean.getPostActivates(), string);
                EjbDescriptorReaderImpl.addLifecycleCallbackDefaults(interceptorBean.getPrePassivates(), string);
                EjbDescriptorReaderImpl.addLifecycleCallbackDefaults(interceptorBean.getPostConstructs(), string);
                EjbDescriptorReaderImpl.addLifecycleCallbackDefaults(interceptorBean.getPreDestroys(), string);
            }
        }
        HashSet<String> hashSet = new HashSet<String>();
        AssemblyDescriptorBean assemblyDescriptorBean = ejbJarBean.getAssemblyDescriptor();
        if (assemblyDescriptorBean == null) {
            return;
        }
        for (InterceptorsBean interceptorsBean4 : assemblyDescriptorBean.getSecurityRoles()) {
            hashSet.add(interceptorsBean4.getRoleName());
        }
        for (InterceptorsBean interceptorsBean4 : interceptorsBean) {
            for (SecurityRoleRefBean securityRoleRefBean : interceptorsBean4.getSecurityRoleRefs()) {
                if (securityRoleRefBean.getRoleLink() != null || !hashSet.contains(securityRoleRefBean.getRoleName())) continue;
                securityRoleRefBean.setRoleLink(securityRoleRefBean.getRoleName());
            }
        }
    }

    private static void addLifecycleCallbackDefaults(LifecycleCallbackBean[] lifecycleCallbackBeanArray, String string) {
        for (LifecycleCallbackBean lifecycleCallbackBean : lifecycleCallbackBeanArray) {
            if (lifecycleCallbackBean.getLifecycleCallbackClass() != null) continue;
            lifecycleCallbackBean.setLifecycleCallbackClass(string);
        }
    }

    private static void addAroundInvokeDefaults(AroundInvokeBean[] aroundInvokeBeanArray, String string) {
        for (AroundInvokeBean aroundInvokeBean : aroundInvokeBeanArray) {
            if (aroundInvokeBean.getClassName() != null) continue;
            aroundInvokeBean.setClassName(string);
        }
    }

    private static void processStandardAnnotations(EjbDescriptorBean ejbDescriptorBean, VirtualJarFile virtualJarFile, GenericClassLoader genericClassLoader) throws IOException {
        EjbJarBean ejbJarBean = ejbDescriptorBean.getEjbJarBean();
        if (ejbJarBean == null || ejbDescriptorBean.isEjb30() && !ejbJarBean.isMetadataComplete()) {
            try {
                ejbDescriptorBean.setEjb30(true);
                EjbAnnotationProcessor ejbAnnotationProcessor = new EjbAnnotationProcessor(genericClassLoader);
                ejbAnnotationProcessor.processAnnotations(ejbDescriptorBean, virtualJarFile);
            }
            catch (Exception exception) {
                if (exception instanceof ErrorCollectionException) {
                    IOException iOException = new IOException("Error processing annotations: ");
                    iOException.initCause(exception);
                    throw iOException;
                }
                throw new IOException(": " + exception);
            }
        }
    }

    private static void processWLSAnnotations(EjbDescriptorBean ejbDescriptorBean, GenericClassLoader genericClassLoader) throws IOException {
        WeblogicEjbJarBean weblogicEjbJarBean = ejbDescriptorBean.getWeblogicEjbJarBean();
        if (weblogicEjbJarBean == null || ejbDescriptorBean.isEjb30() && !ejbDescriptorBean.getEjbJarBean().isMetadataComplete()) {
            try {
                EjbAnnotationProcessor ejbAnnotationProcessor = new EjbAnnotationProcessor(genericClassLoader);
                ejbAnnotationProcessor.processWLSAnnotations(ejbDescriptorBean, (ClassLoader)genericClassLoader);
            }
            catch (Exception exception) {
                IOException iOException = new IOException("Error processing annotations: " + exception);
                iOException.initCause(exception);
                throw iOException;
            }
        }
    }

    private static GenericClassLoader createAnnotationProcessorClassLoader(GenericClassLoader genericClassLoader) {
        NonClosingClassFinder nonClosingClassFinder = new NonClosingClassFinder(genericClassLoader.getClassFinder());
        return new GenericClassLoader((ClassFinder)nonClosingClassFinder, genericClassLoader.getParent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processWeblogicEjbJarXML(EjbDescriptorBean ejbDescriptorBean, VirtualJarFile virtualJarFile, File file, DeploymentPlanBean deploymentPlanBean, String string, String string2) throws IOException, XMLParsingException, XMLProcessingException, XMLStreamException {
        EjbJarDescriptorFactory ejbJarDescriptorFactory = deploymentPlanBean != null ? EjbJarDescriptorFactory.newInstance(virtualJarFile, file, deploymentPlanBean, string, string2) : EjbJarDescriptorFactory.newInstance(virtualJarFile, string, string2);
        if (virtualJarFile.getEntry(WEBLOGIC_EJB_JAR_NAME) != null) {
            BufferedInputStream bufferedInputStream = null;
            try {
                bufferedInputStream = EjbDescriptorReaderImpl.getStream(virtualJarFile, WEBLOGIC_EJB_JAR_NAME);
                EjbDescriptorReaderImpl.parseWLDD(ejbJarDescriptorFactory, deploymentPlanBean, string2, bufferedInputStream, EjbDescriptorReaderImpl.getSysId(virtualJarFile, WEBLOGIC_EJB_JAR_NAME), ejbDescriptorBean.isReadOnly(), ejbDescriptorBean);
            }
            finally {
                if (bufferedInputStream != null) {
                    ((InputStream)bufferedInputStream).close();
                }
            }
        } else {
            EjbDescriptorReaderImpl.processWLEjbJarXMLWithSchema(ejbJarDescriptorFactory, ejbDescriptorBean, ejbDescriptorBean.isReadOnly());
            if (ejbDescriptorBean.getWeblogicEjbJarBean() == null) {
                ejbDescriptorBean.createWeblogicEjbJarBean();
                ejbDescriptorBean.markWeblogicEjbJarSynthetic();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isDTDBased(InputStream inputStream) throws IOException, XMLStreamException {
        NoCloseInputStream noCloseInputStream = new NoCloseInputStream(inputStream);
        ((InputStream)noCloseInputStream).mark(16384);
        XMLStreamReader xMLStreamReader = xiFactory.createXMLStreamReader(noCloseInputStream);
        try {
            int n;
            for (n = 0; n < 10 && xMLStreamReader.hasNext(); ++n) {
                if (xMLStreamReader.isStartElement()) {
                    boolean bl = false;
                    return bl;
                }
                if (xMLStreamReader.next() != 11) continue;
                boolean bl = true;
                return bl;
            }
            n = 0;
            return n != 0;
        }
        finally {
            xMLStreamReader.close();
            ((InputStream)noCloseInputStream).reset();
        }
    }

    public WeblogicEjbJarBean parseWebLogicEjbJarXML(EjbJarDescriptor ejbJarDescriptor, DeploymentPlanBean deploymentPlanBean, File file, String string, InputStream inputStream, EjbJarBean ejbJarBean, String string2, boolean bl) throws IOException, XMLStreamException {
        EjbDescriptorBean ejbDescriptorBean = new EjbDescriptorBean(bl);
        ejbDescriptorBean.setEjbJarBean(ejbJarBean);
        ejbDescriptorBean.setDeploymentPlan(deploymentPlanBean);
        ejbDescriptorBean.setConfigDirectory(file);
        if (inputStream == null) {
            if (bl) {
                ejbDescriptorBean.createWeblogicEjbJarBean();
                EjbDescriptorReaderImpl.completeWeblogicEjbJar(ejbDescriptorBean);
            }
            return ejbDescriptorBean.getWeblogicEjbJarBean();
        }
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream, 16384);
        }
        try {
            EjbDescriptorReaderImpl.parseWLDD(EjbJarDescriptorFactory.newInstance(ejbJarDescriptor), deploymentPlanBean, string, inputStream, string2, bl, ejbDescriptorBean);
        }
        catch (XMLParsingException xMLParsingException) {
            throw new XMLStreamException(xMLParsingException.getMessage(), (Throwable)((Object)xMLParsingException));
        }
        catch (XMLProcessingException xMLProcessingException) {
            throw new XMLStreamException(xMLProcessingException.getMessage(), (Throwable)((Object)xMLProcessingException));
        }
        return ejbDescriptorBean.getWeblogicEjbJarBean();
    }

    private static void parseWLDD(EjbJarDescriptorFactory ejbJarDescriptorFactory, DeploymentPlanBean deploymentPlanBean, String string, InputStream inputStream, String string2, boolean bl, EjbDescriptorBean ejbDescriptorBean) throws IOException, XMLParsingException, XMLProcessingException, XMLStreamException {
        if (EjbDescriptorReaderImpl.isDTDBased(inputStream)) {
            ModuleDescriptorBean moduleDescriptorBean;
            ModuleOverrideBean moduleOverrideBean;
            if (deploymentPlanBean != null && (moduleOverrideBean = deploymentPlanBean.findModuleOverride(string)) != null && (moduleDescriptorBean = deploymentPlanBean.findModuleDescriptor(string, WEBLOGIC_EJB_JAR_NAME)) != null && moduleDescriptorBean.getVariableAssignments() != null && moduleDescriptorBean.getVariableAssignments().length > 0) {
                Loggable loggable = EJBLogger.logNoPlanOverridesWithDTDDescriptorsLoggable((String)string);
                throw new XMLProcessingException(loggable.getMessage());
            }
            EjbDescriptorReaderImpl.processWLEjbJarXML(inputStream, string2, ejbDescriptorBean);
        } else {
            EjbDescriptorReaderImpl.processWLEjbJarXMLWithSchema(ejbJarDescriptorFactory, ejbDescriptorBean, bl);
        }
    }

    private static void completeWeblogicEjbJar(EjbDescriptorBean ejbDescriptorBean) {
        EntityDescriptorBean entityDescriptorBean;
        WeblogicEnterpriseBeanBean weblogicEnterpriseBeanBean;
        EjbJarBean ejbJarBean = ejbDescriptorBean.getEjbJarBean();
        EnterpriseBeansBean enterpriseBeansBean = ejbJarBean.getEnterpriseBeans();
        WeblogicEjbJarBean weblogicEjbJarBean = ejbDescriptorBean.getWeblogicEjbJarBean();
        WeblogicEnterpriseBeanBean[] weblogicEnterpriseBeanBeanArray = weblogicEjbJarBean.getWeblogicEnterpriseBeans();
        HashMap<String, WeblogicEnterpriseBeanBean> hashMap = new HashMap<String, WeblogicEnterpriseBeanBean>();
        for (int i = 0; i < weblogicEnterpriseBeanBeanArray.length; ++i) {
            hashMap.put(weblogicEnterpriseBeanBeanArray[i].getEjbName(), weblogicEnterpriseBeanBeanArray[i]);
        }
        SessionBeanBean[] sessionBeanBeanArray = enterpriseBeansBean.getSessions();
        for (int i = 0; i < sessionBeanBeanArray.length; ++i) {
            WeblogicEnterpriseBeanBean weblogicEnterpriseBeanBean2 = (WeblogicEnterpriseBeanBean)hashMap.get(sessionBeanBeanArray[i].getEjbName());
            if (weblogicEnterpriseBeanBean2 == null) {
                weblogicEnterpriseBeanBean2 = weblogicEjbJarBean.createWeblogicEnterpriseBean();
                weblogicEnterpriseBeanBean2.setEjbName(sessionBeanBeanArray[i].getEjbName());
            }
            if (weblogicEnterpriseBeanBean2.getTransactionDescriptor() == null) {
                weblogicEnterpriseBeanBean2.createTransactionDescriptor();
            }
            if ("stateless".equalsIgnoreCase(sessionBeanBeanArray[i].getSessionType())) {
                weblogicEnterpriseBeanBean = weblogicEnterpriseBeanBean2.getStatelessSessionDescriptor();
                if (null == weblogicEnterpriseBeanBean) {
                    weblogicEnterpriseBeanBean = weblogicEnterpriseBeanBean2.createStatelessSessionDescriptor();
                }
                if (null == weblogicEnterpriseBeanBean.getPool()) {
                    weblogicEnterpriseBeanBean.createPool();
                }
                if (null != weblogicEnterpriseBeanBean.getStatelessClustering()) continue;
                weblogicEnterpriseBeanBean.createStatelessClustering();
                continue;
            }
            weblogicEnterpriseBeanBean = weblogicEnterpriseBeanBean2.getStatefulSessionDescriptor();
            if (null == weblogicEnterpriseBeanBean) {
                weblogicEnterpriseBeanBean = weblogicEnterpriseBeanBean2.createStatefulSessionDescriptor();
            }
            if (null == weblogicEnterpriseBeanBean.getStatefulSessionCache()) {
                weblogicEnterpriseBeanBean.createStatefulSessionCache();
            }
            if (null != weblogicEnterpriseBeanBean.getStatefulSessionClustering()) continue;
            weblogicEnterpriseBeanBean.createStatefulSessionClustering();
        }
        EntityBeanBean[] entityBeanBeanArray = enterpriseBeansBean.getEntities();
        for (int i = 0; i < entityBeanBeanArray.length; ++i) {
            weblogicEnterpriseBeanBean = (WeblogicEnterpriseBeanBean)hashMap.get(entityBeanBeanArray[i].getEjbName());
            if (weblogicEnterpriseBeanBean == null) {
                weblogicEnterpriseBeanBean = weblogicEjbJarBean.createWeblogicEnterpriseBean();
                weblogicEnterpriseBeanBean.setEjbName(entityBeanBeanArray[i].getEjbName());
            }
            if (weblogicEnterpriseBeanBean.getTransactionDescriptor() == null) {
                weblogicEnterpriseBeanBean.createTransactionDescriptor();
            }
            if (null == (entityDescriptorBean = weblogicEnterpriseBeanBean.getEntityDescriptor())) {
                entityDescriptorBean = weblogicEnterpriseBeanBean.createEntityDescriptor();
            }
            if (null == entityDescriptorBean.getEntityCache() && null == entityDescriptorBean.getEntityCacheRef()) {
                entityDescriptorBean.createEntityCache();
            }
            if (null == entityDescriptorBean.getPersistence()) {
                entityDescriptorBean.createPersistence();
            }
            if (null == entityDescriptorBean.getEntityClustering()) {
                entityDescriptorBean.createEntityClustering();
            }
            if (null != entityDescriptorBean.getPool()) continue;
            entityDescriptorBean.createPool();
        }
        MessageDrivenBeanBean[] messageDrivenBeanBeanArray = enterpriseBeansBean.getMessageDrivens();
        for (int i = 0; i < messageDrivenBeanBeanArray.length; ++i) {
            MessageDrivenDescriptorBean messageDrivenDescriptorBean;
            ActivationConfigBean activationConfigBean;
            entityDescriptorBean = (WeblogicEnterpriseBeanBean)hashMap.get(messageDrivenBeanBeanArray[i].getEjbName());
            if (entityDescriptorBean == null) {
                entityDescriptorBean = weblogicEjbJarBean.createWeblogicEnterpriseBean();
                entityDescriptorBean.setEjbName(messageDrivenBeanBeanArray[i].getEjbName());
            }
            if (entityDescriptorBean.getTransactionDescriptor() == null) {
                entityDescriptorBean.createTransactionDescriptor();
            }
            if ((activationConfigBean = messageDrivenBeanBeanArray[i].getActivationConfig()) == null) {
                activationConfigBean = messageDrivenBeanBeanArray[i].createActivationConfig();
            }
            if (null != (messageDrivenDescriptorBean = entityDescriptorBean.getMessageDrivenDescriptor())) continue;
            messageDrivenDescriptorBean = entityDescriptorBean.createMessageDrivenDescriptor();
        }
    }

    private static void processEjbJarXMLWithSchema(VirtualJarFile virtualJarFile, File file, File file2, DeploymentPlanBean deploymentPlanBean, EjbDescriptorBean ejbDescriptorBean, String string, String string2, VirtualJarFile[] virtualJarFileArray) throws IOException, XMLStreamException {
        EjbJarDescriptor ejbJarDescriptor = null;
        ejbJarDescriptor = file != null ? (deploymentPlanBean != null ? new EjbJarDescriptor(file, file2, deploymentPlanBean, string, string2) : new EjbJarDescriptor(file, string, string2)) : new EjbJarDescriptor(virtualJarFile, file2, deploymentPlanBean, string, string2);
        if (virtualJarFileArray != null && virtualJarFileArray.length > 0) {
            ejbJarDescriptor.mergeEJBJar(virtualJarFileArray);
        }
        if (ejbDescriptorBean.isReadOnly()) {
            ejbDescriptorBean.setEjbJarBean(ejbJarDescriptor.getEjbJarBean());
        } else {
            ejbDescriptorBean.setEjbJarBean(ejbJarDescriptor.getEditableEjbJarBean());
        }
    }

    private static void processWLEjbJarXMLWithSchema(EjbJarDescriptorFactory ejbJarDescriptorFactory, EjbDescriptorBean ejbDescriptorBean, boolean bl) throws IOException, XMLStreamException {
        EjbJarDescriptor ejbJarDescriptor = ejbJarDescriptorFactory.getEjbJarDescriptor();
        if (bl) {
            ejbDescriptorBean.setWeblogicEjbJarBean(ejbJarDescriptor.parseWeblogicEjbJarBean());
        } else {
            ejbDescriptorBean.setWeblogicEjbJarBean(ejbJarDescriptor.parseEditableWeblogicEjbJarBean());
        }
    }

    private static BufferedInputStream getStream(VirtualJarFile virtualJarFile, String string) throws IOException {
        ZipEntry zipEntry = virtualJarFile.getEntry(string);
        if (zipEntry == null) {
            Loggable loggable = EJBLogger.logmissingDescriptorLoggable((String)string, (String)virtualJarFile.getName());
            throw new FileNotFoundException(loggable.getMessage());
        }
        return new BufferedInputStream(virtualJarFile.getInputStream(zipEntry));
    }

    private static BufferedInputStream getStream(File file) throws IOException {
        return new BufferedInputStream(new FileInputStream(file));
    }

    private static void processWLEjbJarXML(InputStream inputStream, String string, EjbDescriptorBean ejbDescriptorBean) throws XMLProcessingException, XMLParsingException, IOException {
        EjbDescriptorReaderImpl.processXML(inputStream, string, ejbDescriptorBean, DDConstants.validWeblogicEjbJarPublicIds, WEBLOGIC_EJB_JAR_NAME, new ProcessorFactory());
    }

    private static void processXML(InputStream inputStream, String string, EjbDescriptorBean ejbDescriptorBean, String[] stringArray, String string2, ProcessorFactory processorFactory) throws XMLProcessingException, XMLParsingException, IOException {
        String string3 = DDUtils.getXMLEncoding(inputStream, WEBLOGIC_EJB_JAR_NAME);
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream);
        }
        inputStream.mark(0x100000);
        DDLoader dDLoader = null;
        try {
            dDLoader = (DDLoader)((Object)processorFactory.getProcessor(inputStream, stringArray));
        }
        catch (ProcessorFactoryException processorFactoryException) {
            throw new XMLProcessingException((Throwable)((Object)processorFactoryException), string2);
        }
        inputStream.reset();
        dDLoader.setEJBDescriptor(ejbDescriptorBean);
        dDLoader.setEncoding(string3);
        dDLoader.setValidate(processorFactory.isValidating());
        try {
            InputSource inputSource = new InputSource(inputStream);
            inputSource.setSystemId(string);
            dDLoader.process(inputSource);
        }
        catch (XMLParsingException xMLParsingException) {
            xMLParsingException.setFileName(string2);
            throw xMLParsingException;
        }
        catch (XMLProcessingException xMLProcessingException) {
            xMLProcessingException.setFileName(string2);
            throw xMLProcessingException;
        }
    }

    public void loadWeblogicRDBMSJarMBeans(EjbDescriptorBean ejbDescriptorBean, VirtualJarFile virtualJarFile, ProcessorFactory processorFactory, boolean bl) throws Exception {
        EJBDescriptorMBeanUtils.loadWeblogicRDBMSJarMBeans(ejbDescriptorBean, virtualJarFile, processorFactory, bl);
    }

    private static String getSysId(VirtualJarFile virtualJarFile, String string) throws IOException {
        String string2 = virtualJarFile.getName().replace('\\', '/');
        string2 = EjbDescriptorReaderImpl.completePath(string2);
        return "zip://" + string2 + "!/" + string;
    }

    private static String completePath(String string) {
        if (string.startsWith("./")) {
            return EjbDescriptorReaderImpl.getPWD() + string.substring(1);
        }
        if (string.startsWith("../")) {
            return EjbDescriptorReaderImpl.getPWD() + "/" + string;
        }
        return string;
    }

    private static String getPWD() {
        return System.getProperty("user.dir").replace('\\', '/');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(EjbDescriptorReaderImpl.class.getClassLoader());
            xiFactory = XMLInputFactory.newInstance();
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    private static class NonClosingClassFinder
    extends DelegateFinder {
        public NonClosingClassFinder(ClassFinder classFinder) {
            super(classFinder);
        }

        public void close() {
        }
    }

    private static class NoCloseInputStream
    extends InputStream {
        private final InputStream is;

        NoCloseInputStream(InputStream inputStream) {
            this.is = inputStream;
        }

        public int read() throws IOException {
            return this.is.read();
        }

        public synchronized void mark(int n) {
            this.is.mark(n);
        }

        public boolean markSupported() {
            return this.is.markSupported();
        }

        public synchronized void reset() throws IOException {
            this.is.reset();
        }

        public void close() {
        }
    }
}

