/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.deployer;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.TimedObject;
import javax.ejb.Timer;
import javax.naming.CompositeName;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.security.jacc.PolicyConfiguration;
import weblogic.application.ApplicationContextInternal;
import weblogic.deployment.BaseEnvironmentBuilder;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.container.EJBDebugService;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.compliance.ComplianceException;
import weblogic.ejb.container.compliance.EJBComplianceTextFormatter;
import weblogic.ejb.container.compliance.TimeoutCheckHelper;
import weblogic.ejb.container.dd.xml.DDUtils;
import weblogic.ejb.container.deployer.CompositeMBeanDescriptor;
import weblogic.ejb.container.deployer.Ejb3SessionBeanInfoImpl;
import weblogic.ejb.container.deployer.EntityBeanInfoImpl;
import weblogic.ejb.container.deployer.MessageDrivenBeanInfoImpl;
import weblogic.ejb.container.deployer.SessionBeanInfoImpl;
import weblogic.ejb.container.deployer.mbimpl.MethodInfoImpl;
import weblogic.ejb.container.interfaces.BaseEJBHomeIntf;
import weblogic.ejb.container.interfaces.BeanInfo;
import weblogic.ejb.container.interfaces.BeanManager;
import weblogic.ejb.container.interfaces.CachingDescriptor;
import weblogic.ejb.container.interfaces.DeploymentInfo;
import weblogic.ejb.container.interfaces.EjbComponentCreator;
import weblogic.ejb.container.interfaces.IIOPSecurityDescriptor;
import weblogic.ejb.container.interfaces.MethodInfo;
import weblogic.ejb.container.interfaces.SecurityRoleReference;
import weblogic.ejb.container.internal.EJBComponentRuntimeMBeanImpl;
import weblogic.ejb.container.internal.MethodDescriptor;
import weblogic.ejb.container.internal.RuntimeHelper;
import weblogic.ejb.container.internal.SecurityHelper;
import weblogic.ejb.spi.WLDeploymentException;
import weblogic.ejb20.interfaces.PrincipalNotFoundException;
import weblogic.j2ee.descriptor.EnterpriseBeanBean;
import weblogic.j2ee.descriptor.EntityBeanBean;
import weblogic.j2ee.descriptor.MessageDrivenBeanBean;
import weblogic.j2ee.descriptor.NamedMethodBean;
import weblogic.j2ee.descriptor.PersistenceContextRefBean;
import weblogic.j2ee.descriptor.PersistenceUnitRefBean;
import weblogic.j2ee.descriptor.SessionBeanBean;
import weblogic.kernel.Kernel;
import weblogic.logging.Loggable;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.jacc.RoleMapper;
import weblogic.security.service.PrivilegedActions;
import weblogic.store.PersistentStoreManager;
import weblogic.utils.AssertionError;
import weblogic.utils.Debug;
import weblogic.utils.StackTraceUtils;
import weblogic.utils.classloaders.Annotation;
import weblogic.utils.classloaders.GenericClassLoader;

abstract class BeanInfoImpl
implements BeanInfo {
    protected static final DebugLogger debugLogger = EJBDebugService.deploymentLogger;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private final CachingDescriptor cachingDescriptor;
    private final IIOPSecurityDescriptor iiopSecurityDescriptor;
    protected final DeploymentInfo deploymentInfo;
    private int txTimeoutMS = 0;
    protected GenericClassLoader cl;
    protected GenericClassLoader moduleCL;
    protected final Name jndiName;
    protected final String jndiNameAsString;
    protected final String ejbName;
    protected final String dispatchPolicy;
    protected final boolean stickToFirstServer;
    protected final int remoteClientTimeout;
    protected final String displayName;
    protected final Collection envEntries;
    protected final Collection ejbRefs;
    protected final Collection ejbLocalRefs;
    protected final Collection resRefs;
    protected final Collection resEnvRefs;
    protected final Collection wlResRefs;
    protected final Collection wlResEnvRefs;
    protected final Collection messageDestRefs;
    protected final Map secRoleRefs;
    protected final String beanClassName;
    protected final String isIdenticalKey;
    protected final boolean isResourceRef;
    protected final boolean isEJB30;
    protected EjbComponentCreator ejbComponentCreator;
    private final Map beanMethodInfos = new HashMap();
    protected CompositeMBeanDescriptor m_desc = null;
    protected Map ejbRefJNDINames;
    protected Map ejbLocalRefJNDINames;
    protected Class beanClass;
    protected String jaccPolicyContextId = null;
    protected PolicyConfiguration jaccPolicyConfig = null;
    protected String jaccCodeSource = null;
    protected RoleMapper jaccRoleMapper = null;
    private boolean runAsPrincipalCalculated = false;
    private String runAsPrincipalName;
    private String createAsPrincipalName;
    private String removeAsPrincipalName;
    private String passivateAsPrincipalName;
    private List methodDescriptors = new ArrayList();
    private MethodDescriptor ejbTimeoutMethodDescriptor;
    private Method ejbTimeoutMethod;
    private boolean isClusteredTimers;
    protected RuntimeHelper runtimeHelper;
    private BeanManager beanManager;
    protected String componentURI;
    protected String componentName;

    BeanInfoImpl(DeploymentInfo deploymentInfo, CompositeMBeanDescriptor compositeMBeanDescriptor, GenericClassLoader genericClassLoader) throws ClassNotFoundException, WLDeploymentException {
        String[] stringArray;
        assert (compositeMBeanDescriptor != null);
        assert (genericClassLoader != null);
        this.deploymentInfo = deploymentInfo;
        this.m_desc = compositeMBeanDescriptor;
        this.componentURI = deploymentInfo.getModuleURI();
        this.componentName = deploymentInfo.getEJBComponentName();
        this.moduleCL = genericClassLoader;
        this.cl = new GenericClassLoader(genericClassLoader.getClassFinder(), (ClassLoader)genericClassLoader);
        if (genericClassLoader.getAnnotation() != null) {
            this.cl.setAnnotation(new Annotation(genericClassLoader.getAnnotation().getApplicationName(), genericClassLoader.getAnnotation().getModuleName()));
        }
        this.beanClassName = this.m_desc.getEJBClassName();
        this.dispatchPolicy = this.m_desc.getDispatchPolicy();
        this.stickToFirstServer = this.m_desc.getStickToFirstServer();
        this.remoteClientTimeout = this.m_desc.getRemoteClientTimeout();
        this.ejbName = this.m_desc.getEJBName();
        assert (this.ejbName != null);
        if (BeanInfoImpl.isServer()) {
            this.txTimeoutMS = this.m_desc.getTransactionTimeoutSeconds() * 1000;
            this.displayName = this.ejbName + "(Application: " + deploymentInfo.getApplicationName() + ", EJBComponent: " + deploymentInfo.getEJBComponentName() + ")";
        } else {
            this.displayName = this.ejbName + "(Jar: " + deploymentInfo.getJarFileName() + ")";
        }
        this.jaccPolicyContextId = deploymentInfo.getJACCPolicyContextId();
        this.jaccPolicyConfig = deploymentInfo.getJACCPolicyConfig();
        this.jaccCodeSource = deploymentInfo.getJACCCodeSource();
        this.jaccRoleMapper = deploymentInfo.getJACCRoleMapper();
        this.envEntries = this.m_desc.getAllEnvironmentEntries();
        this.ejbRefs = this.m_desc.getAllEJBReferences();
        this.ejbRefJNDINames = this.m_desc.getAllEJBReferenceJNDINames();
        this.ejbLocalRefs = this.m_desc.getAllEJBLocalReferences();
        this.ejbLocalRefJNDINames = this.m_desc.getAllEJBLocalReferenceJNDINames();
        this.resRefs = this.m_desc.getAllResourceReferences();
        this.isResourceRef = !this.resRefs.isEmpty();
        this.resEnvRefs = this.m_desc.getAllResourceEnvReferences();
        this.wlResRefs = this.m_desc.getAllWlResourceReferences();
        this.wlResEnvRefs = this.m_desc.getAllWlResourceEnvReferences();
        this.messageDestRefs = this.m_desc.getAllMessageDestinationReferences();
        this.secRoleRefs = new HashMap(this.m_desc.getSecurityRoleReferencesMap());
        this.cachingDescriptor = this.m_desc.getCachingDescriptor();
        this.iiopSecurityDescriptor = this.m_desc.getIIOPSecurityDescriptor();
        this.beanClass = this.loadClass(this.beanClassName);
        this.checkClassLoaders(this.m_desc, this.beanClass);
        this.isIdenticalKey = deploymentInfo.getApplicationName() + deploymentInfo.getModuleURI() + this.ejbName;
        this.createAsPrincipalName = this.m_desc.getCreateAsPrincipalName();
        this.removeAsPrincipalName = this.m_desc.getRemoveAsPrincipalName();
        this.passivateAsPrincipalName = this.m_desc.getPassivateAsPrincipalName();
        this.isClusteredTimers = this.m_desc.isClusteredTimers();
        this.initializeTimeoutMethod();
        this.initializeMethodInfos();
        this.isEJB30 = this.m_desc.isEJB30();
        String string = this.m_desc.getJNDIName();
        if (compositeMBeanDescriptor.getBean() instanceof MessageDrivenBeanBean) {
            if (null == string) {
                string = this.m_desc.getEJBName();
            }
        } else if (this.isEJB30 && null == string && compositeMBeanDescriptor.getBean() instanceof SessionBeanBean && (stringArray = compositeMBeanDescriptor.getBusinessRemotes()) != null && stringArray.length > 0) {
            string = this.isIdenticalKey.replace('.', '_') + "_Home";
        }
        this.jndiNameAsString = BaseEnvironmentBuilder.transformJNDIName(string, this.deploymentInfo.getApplicationName());
        this.jndiName = this.jndiNameAsString != null ? this.getName(this.jndiNameAsString) : null;
    }

    public String getRunAsPrincipalName() {
        if (!this.runAsPrincipalCalculated) {
            throw new AssertionError("unexpected codepath");
        }
        return this.runAsPrincipalName;
    }

    public AuthenticatedSubject getRunAsSubject() throws Exception {
        String string = this.getRunAsPrincipalName();
        AuthenticatedSubject authenticatedSubject = null;
        if (string == null) {
            string = "guest";
            authenticatedSubject = SecurityHelper.getAnonymousUser();
            authenticatedSubject.setQOS((byte)101);
        } else {
            SecurityHelper securityHelper = new SecurityHelper(this.getDeploymentInfo().getSecurityRealmName(), this.getJACCPolicyConfig(), this.getJACCPolicyContextId(), this.getJACCCodeSource(), this.getJACCRoleMapper());
            authenticatedSubject = securityHelper.getSubjectForPrincipal(string);
            if (debugLogger.isDebugEnabled()) {
                BeanInfoImpl.debug("runAsPrincipalName is: '" + string + "', runAsSubject from SecurityHelper is: '" + authenticatedSubject + "'");
            }
        }
        return authenticatedSubject;
    }

    public String getCreateAsPrincipalName() {
        return this.createAsPrincipalName;
    }

    public String getRemoveAsPrincipalName() {
        return this.removeAsPrincipalName;
    }

    public String getPassivateAsPrincipalName() {
        return this.passivateAsPrincipalName;
    }

    public String getJACCPolicyContextId() {
        return this.jaccPolicyContextId;
    }

    public PolicyConfiguration getJACCPolicyConfig() {
        return this.jaccPolicyConfig;
    }

    public String getJACCCodeSource() {
        return this.jaccCodeSource;
    }

    public RoleMapper getJACCRoleMapper() {
        return this.jaccRoleMapper;
    }

    public DeploymentInfo getDeploymentInfo() {
        return this.deploymentInfo;
    }

    public boolean getClientsOnSameServer() {
        return this.m_desc.getClientsOnSameServer();
    }

    public Map getAllResourceReferenceJNDINames(String string) {
        return this.m_desc.getAllResourceReferenceJNDINames(string);
    }

    public Map getAllResourceEnvReferenceJNDINames(String string) {
        return this.m_desc.getAllResourceEnvReferenceJNDINames(string);
    }

    public Map getAllEJBReferenceJNDINames() {
        return this.ejbRefJNDINames;
    }

    public Map getAllEJBLocalReferenceJNDINames() {
        return this.ejbLocalRefJNDINames;
    }

    protected static boolean isServer() {
        return Kernel.isServer();
    }

    protected void checkClassLoaders(CompositeMBeanDescriptor compositeMBeanDescriptor, Class clazz) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (clazz.getClassLoader() == classLoader) {
            if (BeanInfoImpl.isServer()) {
                if (!this.isWarningDisabled("BEA-010001") && !clazz.getName().startsWith("weblogic")) {
                    EJBLogger.logRedeployClasspathFailure((String)compositeMBeanDescriptor.getEJBName(), (String)clazz.getName());
                }
            } else if (!this.isWarningDisabled("BEA-010054")) {
                EJBLogger.logEJBClassFoundInClasspath((String)compositeMBeanDescriptor.getEJBName(), (String)clazz.getName());
            }
        }
    }

    public int getTransactionTimeoutMS() {
        return this.txTimeoutMS;
    }

    public Class getBeanClass() {
        return this.beanClass;
    }

    public Name getJNDIName() {
        return this.jndiName;
    }

    public String getJNDINameAsString() {
        return this.jndiNameAsString;
    }

    public String getIsIdenticalKey() {
        return this.isIdenticalKey;
    }

    public String getEJBName() {
        return this.ejbName;
    }

    public String getComponentURI() {
        return this.componentURI;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getBeanClassName() {
        return this.beanClassName;
    }

    public Collection getAllEnvironmentEntries() {
        return this.envEntries;
    }

    public Collection getAllEJBReferences() {
        return this.ejbRefs;
    }

    public Collection getAllEJBLocalReferences() {
        return this.ejbLocalRefs;
    }

    public Collection getAllServiceReferences() {
        return this.m_desc.getServiceReferences();
    }

    public Collection getAllServiceReferenceDescriptions() {
        return this.m_desc.getServiceReferenceDescriptions();
    }

    public Collection getAllResourceReferences() {
        return this.resRefs;
    }

    public boolean getIsResourceRef() {
        return this.isResourceRef;
    }

    public Collection getAllResourceEnvReferences() {
        return this.resEnvRefs;
    }

    public Collection getAllWlResourceReferences() {
        return this.wlResRefs;
    }

    public Collection getAllWlResourceEnvReferences() {
        return this.wlResEnvRefs;
    }

    public Collection getAllMessageDestinationReferences() {
        return this.messageDestRefs;
    }

    public Collection getAllSecurityRoleReferences() {
        return this.secRoleRefs.values();
    }

    public SecurityRoleReference getSecurityRoleReference(String string) {
        return (SecurityRoleReference)this.secRoleRefs.get(string);
    }

    public PersistenceContextRefBean[] getPersistenceContextRefs() {
        return this.m_desc.getPersistenceContextRefs();
    }

    public PersistenceUnitRefBean[] getPersistenceUnitRefs() {
        return this.m_desc.getPersistenceUnitRefs();
    }

    public ClassLoader getClassLoader() {
        return this.cl;
    }

    public ClassLoader getModuleClassLoader() {
        return this.moduleCL;
    }

    protected Name getName(String string) {
        if (string == null) {
            return null;
        }
        try {
            return new CompositeName(string);
        }
        catch (InvalidNameException invalidNameException) {
            throw new AssertionError("Deployment Error: " + invalidNameException);
        }
    }

    protected Class loadClass(String string) throws ClassNotFoundException {
        assert (string != null);
        return this.cl.loadClass(string);
    }

    public abstract Iterator getAllMethodInfosIterator();

    public Collection getAllBeanMethodInfos() {
        return this.beanMethodInfos.values();
    }

    public MethodInfo getBeanMethodInfo(String string) {
        return (MethodInfo)this.beanMethodInfos.get(string);
    }

    public boolean isEJB30() {
        return this.isEJB30;
    }

    public void setEjbComponentCreator(EjbComponentCreator ejbComponentCreator) {
        this.ejbComponentCreator = ejbComponentCreator;
    }

    public EjbComponentCreator getEjbComponentCreator() {
        return this.ejbComponentCreator;
    }

    public boolean isTimerDriven() {
        return this.ejbTimeoutMethod != null;
    }

    public boolean isClusteredTimers() {
        return this.isClusteredTimers;
    }

    public String getTimerStoreName() {
        return this.m_desc.getTimerStoreName();
    }

    private void prepareTimerService() throws WLDeploymentException {
        if (!this.isTimerDriven()) {
            return;
        }
        if (this.isClusteredTimers()) {
            this.validateClusteredTimerConfig();
        } else {
            this.validateLocalTimerConfig();
        }
    }

    private void validateClusteredTimerConfig() throws WLDeploymentException {
        ServerMBean serverMBean = ManagementService.getRuntimeAccess(kernelId).getServer();
        ClusterMBean clusterMBean = serverMBean.getCluster();
        if (clusterMBean == null) {
            Loggable loggable = EJBLogger.logClusteredTimersRequireClusterLoggable((String)this.getDisplayName(), (String)serverMBean.getName());
            throw new WLDeploymentException(loggable.getMessage());
        }
        if (clusterMBean.getDataSourceForJobScheduler() == null) {
            Loggable loggable = EJBLogger.logJobSchedulerNotConfiguredForClusteredTimersLoggable((String)this.getDisplayName());
            throw new WLDeploymentException(loggable.getMessage());
        }
    }

    private void validateLocalTimerConfig() throws WLDeploymentException {
        PersistentStoreManager persistentStoreManager;
        String string = this.getTimerStoreName();
        if (string != null && (persistentStoreManager = PersistentStoreManager.getManager()).getStoreByLogicalName(string) == null) {
            ServerMBean serverMBean = ManagementService.getRuntimeAccess(kernelId).getServer();
            String string2 = serverMBean.getName();
            Loggable loggable = EJBLogger.logUnableToFindPersistentStoreLoggable((String)this.getDisplayName(), (String)string, (String)string2);
            throw new WLDeploymentException(loggable.getMessage());
        }
    }

    private void initializeTimeoutMethod() throws WLDeploymentException {
        String string = null;
        NamedMethodBean namedMethodBean = this.m_desc.getTimeoutMethod();
        if (namedMethodBean != null) {
            string = namedMethodBean.getMethodName();
        }
        if (string != null) {
            for (Class clazz = this.beanClass; clazz != Object.class; clazz = clazz.getSuperclass()) {
                try {
                    this.ejbTimeoutMethod = clazz.getDeclaredMethod(string, Timer.class);
                    this.ejbTimeoutMethod.setAccessible(true);
                    break;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    continue;
                }
            }
            if (this.ejbTimeoutMethod == null) {
                EJBComplianceTextFormatter eJBComplianceTextFormatter = new EJBComplianceTextFormatter();
                throw new WLDeploymentException(eJBComplianceTextFormatter.EJB_TIMEOUT_METHOD_NOT_FOUND(this.getDisplayName(), BeanInfoImpl.getMethodSignature(string, new String[]{"javax.ejb.Timer"})));
            }
        }
        try {
            TimeoutCheckHelper.validateTimeoutMethodIsejbTimeout(this.beanClass, this.ejbTimeoutMethod);
        }
        catch (ComplianceException complianceException) {
            throw new WLDeploymentException(complianceException.getMessage(), complianceException);
        }
        if (TimedObject.class.isAssignableFrom(this.beanClass)) {
            try {
                this.ejbTimeoutMethod = this.beanClass.getMethod("ejbTimeout", Timer.class);
                this.ejbTimeoutMethod.setAccessible(true);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }

    public Method getTimeoutMethod() {
        return this.ejbTimeoutMethod;
    }

    private void initializeMethodInfos() {
        if (this.isTimerDriven()) {
            MethodInfoImpl methodInfoImpl = new MethodInfoImpl(this.ejbTimeoutMethod, null, this.jaccPolicyContextId);
            this.beanMethodInfos.put(methodInfoImpl.getSignature(), methodInfoImpl);
        }
    }

    public CachingDescriptor getCachingDescriptor() {
        return this.cachingDescriptor;
    }

    public IIOPSecurityDescriptor getIIOPSecurityDescriptor() {
        return this.iiopSecurityDescriptor;
    }

    public boolean isWarningDisabled(String string) {
        return this.deploymentInfo.isWarningDisabled(string);
    }

    static BeanInfoImpl createBeanInfoImpl(DeploymentInfo deploymentInfo, CompositeMBeanDescriptor compositeMBeanDescriptor, GenericClassLoader genericClassLoader) throws ClassNotFoundException, WLDeploymentException {
        Debug.assertion((genericClassLoader != null ? 1 : 0) != 0);
        EnterpriseBeanBean enterpriseBeanBean = compositeMBeanDescriptor.getBean();
        BeanInfoImpl beanInfoImpl = null;
        if (enterpriseBeanBean instanceof SessionBeanBean) {
            beanInfoImpl = compositeMBeanDescriptor.isEJB30() ? new Ejb3SessionBeanInfoImpl(deploymentInfo, compositeMBeanDescriptor, genericClassLoader) : new SessionBeanInfoImpl(deploymentInfo, compositeMBeanDescriptor, genericClassLoader);
        } else if (enterpriseBeanBean instanceof MessageDrivenBeanBean) {
            beanInfoImpl = new MessageDrivenBeanInfoImpl(deploymentInfo, compositeMBeanDescriptor, genericClassLoader);
        } else if (enterpriseBeanBean instanceof EntityBeanBean) {
            beanInfoImpl = new EntityBeanInfoImpl(deploymentInfo, compositeMBeanDescriptor, genericClassLoader);
        } else {
            throw new AssertionError("Uknown type of bean:" + enterpriseBeanBean);
        }
        beanInfoImpl.init();
        return beanInfoImpl;
    }

    public BeanManager getBeanManager() {
        return this.beanManager;
    }

    public abstract BeanManager getBeanManagerInstance(EJBComponentRuntimeMBeanImpl var1);

    public void setupBeanManager(EJBComponentRuntimeMBeanImpl eJBComponentRuntimeMBeanImpl) {
        this.beanManager = this.getBeanManagerInstance(eJBComponentRuntimeMBeanImpl);
    }

    public void onUndeploy() {
    }

    public String getDispatchPolicy() {
        return this.dispatchPolicy;
    }

    public boolean getStickToFirstServer() {
        return this.stickToFirstServer;
    }

    public int getRemoteClientTimeout() {
        return this.remoteClientTimeout;
    }

    public void updateImplClassLoader() throws WLDeploymentException {
        this.cl = new GenericClassLoader(this.cl.getClassFinder(), this.cl.getParent());
        try {
            this.beanClass = this.loadClass(this.beanClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new WLDeploymentException("Couldn't load updated impl class: " + classNotFoundException);
        }
    }

    public void updateTransactionTimeoutSeconds(int n) {
        this.txTimeoutMS = n * 1000;
        if (debugLogger.isDebugEnabled()) {
            BeanInfoImpl.debug("updated TransactionTimeoutSeconds to " + n + " for EJB " + this.getDisplayName());
        }
    }

    public abstract void updateMaxBeansInFreePool(int var1);

    protected StringBuffer assignDefaultTXAttributesIfNecessary(String string, Collection collection, short s) {
        StringBuffer stringBuffer = new StringBuffer();
        for (MethodInfo methodInfo : collection) {
            if (methodInfo.getTransactionAttribute() != -1) continue;
            if (stringBuffer.length() == 0) {
                stringBuffer.append(string);
                stringBuffer.append('[');
            } else {
                stringBuffer.append(", ");
            }
            stringBuffer.append(methodInfo.getSignature());
            methodInfo.setTransactionAttribute(s);
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.append("]  ");
        }
        return stringBuffer;
    }

    protected abstract short getTxAttribute(MethodInfo var1, Class var2);

    protected MethodDescriptor setMethodDescriptor(BaseEJBHomeIntf baseEJBHomeIntf, Method method, Class clazz, MethodInfo methodInfo, boolean bl, String string, String string2) throws WLDeploymentException {
        MethodDescriptor methodDescriptor = this.createMethodDescriptor(method, clazz, methodInfo, bl);
        this.setMDField(baseEJBHomeIntf, clazz, methodDescriptor, string, string2);
        return methodDescriptor;
    }

    public MethodDescriptor createMethodDescriptor(Method method, Class clazz, MethodInfo methodInfo, boolean bl) throws WLDeploymentException {
        MethodDescriptor methodDescriptor;
        short s = this.getTxAttribute(methodInfo, clazz);
        try {
            methodDescriptor = new MethodDescriptor(this, this.deploymentInfo.getApplicationName(), this.deploymentInfo.getEJBComponentName(), this.ejbName, method, methodInfo, s, this.getTransactionTimeoutMS(), this.m_desc.getEntityAlwaysUsesTransaction(), bl);
            this.methodDescriptors.add(methodDescriptor);
            if (!BeanInfoImpl.isServer()) {
                throw new AssertionError("unexpected codepath");
            }
            methodInfo.setRuntimeHelper(this.runtimeHelper);
            this.runtimeHelper.setRunAsSubject(methodDescriptor, this.getRunAsPrincipalName());
            if (methodDescriptor != null && this.runtimeHelper.processUncheckedExcludedMethod(methodDescriptor) && debugLogger.isDebugEnabled()) {
                BeanInfoImpl.debug("method: '" + methodInfo.getMethodName() + "' is unchecked or excluded " + "runtime unchecked/excluded list has been updated.");
            }
        }
        catch (PrincipalNotFoundException principalNotFoundException) {
            throw new WLDeploymentException(principalNotFoundException.toString());
        }
        return methodDescriptor;
    }

    private void setMDField(BaseEJBHomeIntf baseEJBHomeIntf, Class clazz, MethodDescriptor methodDescriptor, String string, String string2) throws WLDeploymentException {
        try {
            if (string2.equals("Home") || string2.equals("LocalHome")) {
                this.setHomeMDField(baseEJBHomeIntf, methodDescriptor, string);
            } else if (string2.equals("Remote") || string2.equals("Local") || string2.equals("ServiceEndpoint") || string2.equals("MessagingType")) {
                this.setObjectMDField(clazz, methodDescriptor, string);
            } else {
                Debug.assertion((boolean)false, (String)("encountered unknown interface type: '" + string2 + "'"));
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            Loggable loggable = EJBLogger.logMismatchBetweenBeanAndGeneratedCodeLoggable((String)this.getDisplayName(), (String)StackTraceUtils.throwable2StackTrace((Throwable)illegalAccessException));
            WLDeploymentException wLDeploymentException = new WLDeploymentException(loggable.getMessage(), illegalAccessException);
            throw wLDeploymentException;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Loggable loggable = EJBLogger.logMismatchBetweenBeanAndGeneratedCodeLoggable((String)this.getDisplayName(), (String)StackTraceUtils.throwable2StackTrace((Throwable)noSuchFieldException));
            WLDeploymentException wLDeploymentException = new WLDeploymentException(loggable.getMessage(), noSuchFieldException);
            throw wLDeploymentException;
        }
    }

    private void setHomeMDField(BaseEJBHomeIntf baseEJBHomeIntf, MethodDescriptor methodDescriptor, String string) throws IllegalAccessException, NoSuchFieldException {
        Field field = baseEJBHomeIntf.getClass().getField("md_" + string);
        field.set(baseEJBHomeIntf, methodDescriptor);
    }

    private void setObjectMDField(Class clazz, MethodDescriptor methodDescriptor, String string) throws IllegalAccessException, NoSuchFieldException {
        Field field = clazz.getField("md_" + string);
        field.set(clazz, methodDescriptor);
    }

    public void setRuntimeHelper(RuntimeHelper runtimeHelper) {
        this.runtimeHelper = runtimeHelper;
    }

    protected List getMethodDescriptors() {
        return this.methodDescriptors;
    }

    protected static String getMethodSignature(Method method) {
        return DDUtils.getMethodSignature(method);
    }

    protected static String getMethodSignature(String string, String[] stringArray) {
        return DDUtils.getMethodSignature(string, stringArray);
    }

    protected void dumpMethodDescriptorFields(Field[] fieldArray, Object object) {
        for (int i = 0; i < fieldArray.length; ++i) {
            Field field = fieldArray[i];
            if (!field.getName().startsWith("md")) continue;
            try {
                MethodDescriptor methodDescriptor = (MethodDescriptor)field.get(object);
                BeanInfoImpl.debug("MethodDescriptor: " + methodDescriptor);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                BeanInfoImpl.debug("", illegalAccessException);
                continue;
            }
            catch (ClassCastException classCastException) {
                BeanInfoImpl.debug("", classCastException);
            }
        }
    }

    public String getNetworkAccessPoint() {
        return this.m_desc.getNetworkAccessPoint();
    }

    public MethodDescriptor getEjbTimeoutMethodDescriptor() {
        return this.ejbTimeoutMethodDescriptor;
    }

    protected void prepare(ApplicationContextInternal applicationContextInternal) throws WLDeploymentException {
        this.prepareTimerService();
        this.calculateRunAsPrincipal();
        this.runtimeHelper.checkRunAsPrivileges(this);
        if (this.isTimerDriven()) {
            MethodInfo methodInfo = this.getBeanMethodInfo(DDUtils.getMethodSignature(this.ejbTimeoutMethod));
            methodInfo.setUnchecked(true);
            this.ejbTimeoutMethodDescriptor = this.createMethodDescriptor(this.ejbTimeoutMethod, TimedObject.class, methodInfo, true);
            this.methodDescriptors.add(this.ejbTimeoutMethodDescriptor);
        }
    }

    public void unprepare() {
    }

    private void calculateRunAsPrincipal() throws WLDeploymentException {
        String string = this.m_desc.getRunAsRoleName();
        if (string != null) {
            this.runAsPrincipalName = this.m_desc.getRunAsIdentityPrincipal();
            if (this.runAsPrincipalName == null) {
                this.runAsPrincipalName = this.deploymentInfo.getRunAsRoleAssignment(string);
            }
            if (this.runAsPrincipalName == null) {
                this.runAsPrincipalName = this.runtimeHelper.getRunAsPrincipalFromRoleMapping(this.ejbName, string, this.deploymentInfo.getDeploymentRoles());
            }
            if (!this.runtimeHelper.isUserPrincipal(this.runAsPrincipalName)) {
                EJBComplianceTextFormatter eJBComplianceTextFormatter = new EJBComplianceTextFormatter();
                throw new WLDeploymentException(eJBComplianceTextFormatter.INVALID_RUN_AS_PRINCIPAL_FOR_EJB(this.getDisplayName(), this.runAsPrincipalName));
            }
        }
        this.runAsPrincipalCalculated = true;
    }

    private static void debug(String string) {
        debugLogger.debug("[BeanInfoImpl] " + string);
    }

    private static void debug(String string, Throwable throwable) {
        debugLogger.debug("[BeanInfoImpl] " + string, throwable);
    }

    public String getHomeInterfaceName() {
        return null;
    }

    public String getLocalHomeInterfaceName() {
        return null;
    }

    public String getLocalInterfaceName() {
        return null;
    }

    public String getRemoteInterfaceName() {
        return null;
    }

    public boolean hasLocalClientView() {
        return false;
    }

    public boolean hasRemoteClientView() {
        return false;
    }

    public boolean isClientDriven() {
        return false;
    }

    public boolean isEntityBean() {
        return false;
    }

    public boolean isSessionBean() {
        return false;
    }

    public Set getBusinessLocals() {
        return Collections.emptySet();
    }

    public Set getBusinessRemotes() {
        return Collections.emptySet();
    }

    public String getComponentName() {
        return this.componentName;
    }
}

