/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.deployer;

import java.io.File;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import weblogic.ejb.container.cmp.rdbms.Deployer;
import weblogic.ejb.container.cmp.rdbms.RDBMSBean;
import weblogic.ejb.container.cmp.rdbms.RDBMSPersistenceManager;
import weblogic.ejb.container.cmp.rdbms.finders.Finder;
import weblogic.ejb.container.cmp.rdbms.finders.RDBMSFinder;
import weblogic.ejb.container.deployer.CompositeMBeanDescriptor;
import weblogic.ejb.container.deployer.EntityBeanInfoImpl;
import weblogic.ejb.container.interfaces.CMPInfo;
import weblogic.ejb.container.persistence.CMPBeanDescriptorImpl;
import weblogic.ejb.container.persistence.PersistenceType;
import weblogic.ejb.container.persistence.spi.CMPBeanDescriptor;
import weblogic.ejb.container.persistence.spi.CMPDeployer;
import weblogic.ejb.container.persistence.spi.EjbEntityRef;
import weblogic.ejb.container.persistence.spi.PersistenceManager;
import weblogic.ejb.container.persistence.spi.Relationships;
import weblogic.ejb.spi.WLDeploymentException;
import weblogic.j2ee.descriptor.CmpFieldBean;
import weblogic.j2ee.descriptor.EntityBeanBean;
import weblogic.utils.Debug;
import weblogic.utils.Getopt2;
import weblogic.utils.jars.VirtualJarFile;

public final class CMPInfoImpl
implements CMPInfo {
    private EntityBeanInfoImpl ebi;
    private String cmpVersion = "1.x";
    private Collection containerManagedFieldNames;
    private String cmPrimaryKeyFieldName;
    private String abstractSchemaName;
    private boolean isBeanClassAbstract;
    Collection queries;
    private Collection annotatedPersistenceTypes;
    private String persistenceUseIdentifier;
    private String persistenceUseVersion;
    private String persistenceUseStorage;
    private boolean findersLoadBean;
    private Relationships relationships = null;
    private Map beanMap;
    private Map allBeanMap;
    private Map dependentMap;
    private String generatedBeanClassName;
    private PersistenceType persistenceType;
    private CMPDeployer deployer = null;
    private Set ejbEntityRefs;
    private Collection finderList;
    private Map<RDBMSFinder.FinderKey, Finder> finderMap;
    private int maxQueriesInCache = 0;

    public CMPInfoImpl(EntityBeanInfoImpl entityBeanInfoImpl, CompositeMBeanDescriptor compositeMBeanDescriptor) {
        this.ebi = entityBeanInfoImpl;
        this.ejbEntityRefs = new HashSet();
        EntityBeanBean entityBeanBean = (EntityBeanBean)compositeMBeanDescriptor.getBean();
        this.containerManagedFieldNames = new LinkedList();
        this.queries = Arrays.asList((Object[])entityBeanBean.getQueries());
        this.cmpVersion = entityBeanBean.getCmpVersion();
        this.abstractSchemaName = entityBeanBean.getAbstractSchemaName();
        CmpFieldBean[] cmpFieldBeanArray = entityBeanBean.getCmpFields();
        for (int i = 0; i < cmpFieldBeanArray.length; ++i) {
            this.containerManagedFieldNames.add(cmpFieldBeanArray[i].getFieldName());
        }
        this.cmPrimaryKeyFieldName = entityBeanBean.getPrimkeyField();
        this.persistenceUseIdentifier = compositeMBeanDescriptor.getPersistenceUseIdentifier();
        this.persistenceUseVersion = compositeMBeanDescriptor.getPersistenceUseVersion();
        this.persistenceUseStorage = compositeMBeanDescriptor.getPersistenceUseStorage();
        this.findersLoadBean = compositeMBeanDescriptor.getFindersLoadBean();
        this.isBeanClassAbstract = !entityBeanInfoImpl.isEJB30();
        this.maxQueriesInCache = compositeMBeanDescriptor.getMaxQueriesInCache();
    }

    public void setup(File file, Getopt2 getopt2, VirtualJarFile virtualJarFile) throws WLDeploymentException {
        this.deployer = this.getPersistenceType().setupDeployer(this.ebi, file, getopt2, virtualJarFile);
        this.deployer.initializePersistenceManager(this.ebi.getPersistenceManager());
        if (this.uses20CMP() && this.getPersistenceUseIdentifier().equals("WebLogic_CMP_RDBMS")) {
            assert (this.deployer instanceof Deployer);
            Deployer deployer = (Deployer)this.deployer;
            RDBMSBean rDBMSBean = deployer.getTypeSpecificData();
            this.finderList = rDBMSBean.getFinderList();
        }
    }

    public boolean isBeanClassAbstract() {
        return this.isBeanClassAbstract;
    }

    public int getInstanceLockOrder() {
        if (this.uses20CMP() && this.getPersistenceUseIdentifier().equals("WebLogic_CMP_RDBMS")) {
            assert (this.deployer instanceof Deployer);
            Deployer deployer = (Deployer)this.deployer;
            RDBMSBean rDBMSBean = deployer.getTypeSpecificData();
            if (rDBMSBean.getInstanceLockOrder().equals("AccessOrder")) {
                return 100;
            }
            if (rDBMSBean.getInstanceLockOrder().equals("ValueOrder")) {
                return 101;
            }
            throw new AssertionError((Object)("invalid value for instanceLockOrder: " + rDBMSBean.getInstanceLockOrder()));
        }
        return 100;
    }

    public Collection getAllContainerManagedFieldNames() {
        return this.containerManagedFieldNames;
    }

    public Collection getAllQueries() {
        return this.queries;
    }

    public boolean hasContainerManagedFields() {
        return !this.containerManagedFieldNames.isEmpty();
    }

    public String getCMPrimaryKeyFieldName() {
        return this.cmPrimaryKeyFieldName;
    }

    public String getCMPVersion() {
        return this.cmpVersion;
    }

    public boolean uses20CMP() {
        return this.getCMPVersion().startsWith("2");
    }

    public String getAbstractSchemaName() {
        return this.abstractSchemaName;
    }

    public boolean findersLoadBean() {
        return this.findersLoadBean;
    }

    public String getPersistenceUseIdentifier() {
        return this.persistenceUseIdentifier;
    }

    public String getPersistenceUseVersion() {
        return this.persistenceUseVersion;
    }

    public String getPersistenceUseStorage() {
        return this.persistenceUseStorage;
    }

    public void setRelationships(Relationships relationships) {
        this.relationships = relationships;
    }

    public Relationships getRelationships() {
        return this.relationships;
    }

    public void setBeanMap(Map map) {
        this.beanMap = map;
    }

    public Map getBeanMap() {
        return this.beanMap;
    }

    public CMPBeanDescriptor getCMPBeanDescriptor(String string) {
        return (CMPBeanDescriptor)this.allBeanMap.get(string);
    }

    public void setAllBeanMap(Map map) {
        this.allBeanMap = map;
    }

    public Map getAllBeanMap() {
        return this.allBeanMap;
    }

    public void setDependentMap(Map map) {
        if (map == null) {
            Debug.say((String)"map is null");
        }
        this.dependentMap = map;
    }

    public Map getDependentMap() {
        return this.dependentMap;
    }

    public void setGeneratedBeanClassName(String string) {
        this.generatedBeanClassName = string;
    }

    public String getGeneratedBeanClassName() {
        return this.generatedBeanClassName;
    }

    public PersistenceType getPersistenceType() {
        assert (this.persistenceType != null);
        return this.persistenceType;
    }

    public void setPersistenceType(PersistenceType persistenceType) {
        this.persistenceType = persistenceType;
    }

    public Class getGeneratedBeanClass() throws ClassNotFoundException {
        assert (this.ebi != null);
        return this.ebi.getGeneratedBeanClass();
    }

    public CMPDeployer getDeployer() {
        return this.deployer;
    }

    public Collection getAllEJBEntityReferences() {
        return this.ejbEntityRefs;
    }

    public void addEjbEntityRef(EjbEntityRef ejbEntityRef) {
        this.ejbEntityRefs.add(ejbEntityRef);
    }

    public void setupParentBeanManagers() {
        PersistenceManager persistenceManager;
        if (this.uses20CMP() && (persistenceManager = this.ebi.getPersistenceManager()) instanceof RDBMSPersistenceManager) {
            ((RDBMSPersistenceManager)persistenceManager).setupParentBeanManagers();
        }
    }

    public void setCycleExists() {
        PersistenceManager persistenceManager;
        if (this.uses20CMP() && (persistenceManager = this.ebi.getPersistenceManager()) instanceof RDBMSPersistenceManager) {
            ((RDBMSPersistenceManager)persistenceManager).setCycleExists();
        }
    }

    public void setupMNBeanManagers() {
        PersistenceManager persistenceManager;
        if (this.uses20CMP() && (persistenceManager = this.ebi.getPersistenceManager()) instanceof RDBMSPersistenceManager) {
            ((RDBMSPersistenceManager)persistenceManager).setupM2NBeanManagers();
        }
    }

    public boolean isQueryCachingEnabled(Method method) {
        if (!this.uses20CMP()) {
            return false;
        }
        if (this.finderMap != null && this.finderMap.containsKey(new RDBMSFinder.FinderKey(method))) {
            return true;
        }
        if (this.finderMap == null) {
            boolean bl = false;
            this.finderMap = new HashMap<RDBMSFinder.FinderKey, Finder>();
            for (Finder finder : this.finderList) {
                if (!finder.isQueryCachingEnabled()) continue;
                RDBMSFinder.FinderKey finderKey = new RDBMSFinder.FinderKey(finder);
                this.finderMap.put(finderKey, finder);
                if (!finderKey.equals(new RDBMSFinder.FinderKey(method))) continue;
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public String getQueryCachingEnabledFinderIndex(Method method) {
        assert (this.finderMap != null);
        Finder finder = this.finderMap.get(new RDBMSFinder.FinderKey(method));
        String string = finder.getFinderIndex();
        assert (string != null);
        return string;
    }

    public int getMaxQueriesInCache() {
        return this.maxQueriesInCache;
    }

    public boolean isEnableEagerRefresh(Method method) {
        Finder finder = this.finderMap.get(new RDBMSFinder.FinderKey(method));
        assert (finder != null);
        return finder.isEagerRefreshEnabled();
    }

    public void beanImplClassChangeNotification() {
        CMPBeanDescriptorImpl cMPBeanDescriptorImpl = (CMPBeanDescriptorImpl)this.allBeanMap.get(this.ebi.getEJBName());
        cMPBeanDescriptorImpl.beanImplClassChangeNotification();
    }
}

