/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.deployer;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.rmi.Remote;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.conf.OpenJPAConfigurationImpl;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import weblogic.application.ApplicationContextInternal;
import weblogic.deployment.BaseEnvironmentBuilder;
import weblogic.deployment.PersistenceUnitInfoImpl;
import weblogic.deployment.PersistenceUnitRegistry;
import weblogic.descriptor.BeanUpdateRejectedException;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.compliance.EJBComplianceTextFormatter;
import weblogic.ejb.container.dd.ClusteringDescriptor;
import weblogic.ejb.container.dd.DDConstants;
import weblogic.ejb.container.dd.DDDefaults;
import weblogic.ejb.container.deployer.BeanInfoImpl;
import weblogic.ejb.container.deployer.CompositeMBeanDescriptor;
import weblogic.ejb.container.deployer.Ejb2JndiBinder;
import weblogic.ejb.container.deployer.EjbJndiBinder;
import weblogic.ejb.container.deployer.EntityBeanInfoImpl;
import weblogic.ejb.container.deployer.NamingConvention;
import weblogic.ejb.container.deployer.mbimpl.MethodInfoImpl;
import weblogic.ejb.container.interfaces.BaseEJBHomeIntf;
import weblogic.ejb.container.interfaces.BaseEJBLocalHomeIntf;
import weblogic.ejb.container.interfaces.BaseEJBLocalObjectIntf;
import weblogic.ejb.container.interfaces.BaseEJBRemoteHomeIntf;
import weblogic.ejb.container.interfaces.BeanManager;
import weblogic.ejb.container.interfaces.CachingManager;
import weblogic.ejb.container.interfaces.ClientDrivenBeanInfo;
import weblogic.ejb.container.interfaces.DeploymentInfo;
import weblogic.ejb.container.interfaces.EntityBeanInfo;
import weblogic.ejb.container.interfaces.MethodInfo;
import weblogic.ejb.container.interfaces.QueryCache;
import weblogic.ejb.container.interfaces.SecurityRoleReference;
import weblogic.ejb.container.internal.MethodDescriptor;
import weblogic.ejb.container.internal.WSObjectFactoryImpl;
import weblogic.ejb.container.manager.TTLManager;
import weblogic.ejb.container.monitoring.EJBRuntimeMBeanImpl;
import weblogic.ejb.spi.EJBCache;
import weblogic.ejb.spi.WLDeploymentException;
import weblogic.ejb.spi.WSObjectFactory;
import weblogic.j2ee.descriptor.SessionBeanBean;
import weblogic.logging.Loggable;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.ExecuteQueueRuntimeMBean;
import weblogic.rmi.extensions.server.ServerHelper;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.AssertionError;
import weblogic.utils.Debug;
import weblogic.utils.StackTraceUtils;
import weblogic.utils.annotation.BeaSynthetic;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.collections.CombinedIterator;
import weblogic.utils.reflect.MethodText;
import weblogic.wsee.deploy.DeployUtil;

abstract class ClientDrivenBeanInfoImpl
extends BeanInfoImpl
implements ClientDrivenBeanInfo {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private Name localJndiName;
    private String localJndiNameAsString;
    private String homeInterfaceName;
    private String remoteInterfaceName;
    private String homeClassName;
    private String ejbObjectClassName;
    private Class homeInterfaceClass;
    private Class remoteInterfaceClass;
    private Class homeClass;
    private Class ejbObjectClass;
    private String localHomeInterfaceName;
    private String localInterfaceName;
    private String localHomeClassName;
    private String ejbLocalObjectClassName;
    private Class localHomeInterfaceClass;
    private Class localInterfaceClass;
    private Class localHomeClass;
    private Class localClass;
    private String serviceEndpointName;
    private Class serviceEndpointClass;
    private String webserviceObjectClassName;
    private Class webserviceObjectClass;
    protected WSObjectFactory webserviceObjectFactory;
    protected final Map remoteMethods = new HashMap();
    protected final Map homeMethods = new HashMap();
    protected final Map localHomeMethods = new HashMap();
    protected final Map localMethods = new HashMap();
    protected Map webserviceMethods = null;
    private BaseEJBRemoteHomeIntf remoteHome;
    private BaseEJBLocalHomeIntf localHome;
    private ClusteringDescriptor clusteringDescriptor;
    private boolean callByReference;
    protected PersistenceUnitRegistry persistenceUnitRegistry;
    protected EjbJndiBinder jndiBinder;
    private Class[] immutableClasses = new Class[]{Boolean.class, Byte.class, Character.class, Double.class, Float.class, Integer.class, Long.class, Short.class, String.class, BigDecimal.class};

    ClientDrivenBeanInfoImpl(DeploymentInfo deploymentInfo, CompositeMBeanDescriptor compositeMBeanDescriptor, GenericClassLoader genericClassLoader) throws ClassNotFoundException, WLDeploymentException {
        super(deploymentInfo, compositeMBeanDescriptor, genericClassLoader);
        if (ClientDrivenBeanInfoImpl.isServer()) {
            this.checkSecurityRoleRefs();
        }
        this.homeInterfaceName = compositeMBeanDescriptor.getHomeInterfaceName();
        this.remoteInterfaceName = compositeMBeanDescriptor.getRemoteInterfaceName();
        this.localHomeInterfaceName = compositeMBeanDescriptor.getLocalHomeInterfaceName();
        this.localInterfaceName = compositeMBeanDescriptor.getLocalInterfaceName();
        if (compositeMBeanDescriptor.isStatelessSession()) {
            this.serviceEndpointName = compositeMBeanDescriptor.getServiceEndpointName();
        }
        this.checkClientViews();
    }

    public void init() throws ClassNotFoundException, WLDeploymentException {
        NamingConvention namingConvention = new NamingConvention(this.beanClassName, this.ejbName);
        boolean bl = false;
        if (this.isSessionBean()) {
            bl = "stateful".equalsIgnoreCase(((SessionBeanBean)this.m_desc.getBean()).getSessionType());
        }
        this.localJndiNameAsString = BaseEnvironmentBuilder.transformJNDIName(this.m_desc.getLocalJNDIName(), this.deploymentInfo.getApplicationName());
        this.localJndiName = this.getName(this.localJndiNameAsString);
        if (this.hasRemoteClientView()) {
            if (this.hasDeclaredRemoteHome()) {
                this.homeClassName = namingConvention.getHomeClassName();
                this.homeInterfaceClass = this.loadClass(this.homeInterfaceName);
                this.checkClassLoaders(this.m_desc, this.homeInterfaceClass);
                this.remoteInterfaceClass = this.loadClass(this.remoteInterfaceName);
                this.checkClassLoaders(this.m_desc, this.remoteInterfaceClass);
            } else {
                this.homeClassName = namingConvention.getHomeImplClassName(bl);
            }
            this.ejbObjectClassName = namingConvention.getEJBObjectClassName();
            this.clusteringDescriptor = this.m_desc.getClusteringDescriptor();
        }
        if (this.hasLocalClientView()) {
            if (this.hasDeclaredLocalHome()) {
                this.localHomeClassName = namingConvention.getLocalHomeClassName();
                this.localHomeInterfaceClass = this.loadClass(this.localHomeInterfaceName);
                this.checkClassLoaders(this.m_desc, this.localHomeInterfaceClass);
                this.localInterfaceClass = this.loadClass(this.localInterfaceName);
                this.checkClassLoaders(this.m_desc, this.localInterfaceClass);
            } else {
                this.localHomeClassName = namingConvention.getLocalHomeImplClassName(bl);
            }
            this.ejbLocalObjectClassName = namingConvention.getEJBLocalObjectClassName();
        }
        if (this.hasWebserviceClientView()) {
            this.webserviceObjectClassName = namingConvention.getWsObjectClassName();
            if (this.serviceEndpointName != null) {
                this.serviceEndpointClass = this.loadClass(this.serviceEndpointName);
            }
            this.webserviceObjectClass = null;
        }
        this.callByReference = this.m_desc.useCallByReference();
        if (!this.callByReference) {
            this.callByReference = this.checkIfItsSafeToUseCallByReference();
        }
        if (!this.callByReference) {
            this.warnIfParameterNotSerializable();
        }
        this.initializeMethodInfos();
    }

    public abstract String getGeneratedBeanClassName();

    public abstract Class getGeneratedBeanClass();

    public abstract String getGeneratedBeanInterfaceName();

    public abstract Class getGeneratedBeanInterface();

    public Name getLocalJNDIName() {
        return this.localJndiName;
    }

    public String getLocalJNDINameAsString() {
        return this.localJndiNameAsString;
    }

    public Class getHomeClass() {
        try {
            if (this.homeClass == null) {
                this.homeClass = this.loadClass(this.homeClassName);
            }
            return this.homeClass;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError((Throwable)classNotFoundException);
        }
    }

    public Class getLocalHomeClass() {
        try {
            if (this.localHomeClass == null) {
                this.localHomeClass = this.loadClass(this.localHomeClassName);
            }
            return this.localHomeClass;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError((Throwable)classNotFoundException);
        }
    }

    public String getHomeInterfaceName() {
        return this.homeInterfaceName;
    }

    public String getLocalHomeInterfaceName() {
        return this.localHomeInterfaceName;
    }

    public boolean hasDeclaredRemoteHome() {
        return this.homeInterfaceName != null;
    }

    public boolean hasDeclaredLocalHome() {
        return this.localHomeInterfaceName != null;
    }

    public Class getHomeInterfaceClass() {
        return this.homeInterfaceClass;
    }

    public Class getLocalHomeInterfaceClass() {
        return this.localHomeInterfaceClass;
    }

    public Class getRemoteClass() {
        try {
            if (this.ejbObjectClass == null) {
                this.ejbObjectClass = this.loadClass(this.ejbObjectClassName);
            }
            return this.ejbObjectClass;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError((Throwable)classNotFoundException);
        }
    }

    public Class getLocalClass() {
        try {
            if (this.localClass == null) {
                this.localClass = this.loadClass(this.ejbLocalObjectClassName);
            }
            return this.localClass;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError((Throwable)classNotFoundException);
        }
    }

    public Class getWebserviceObjectClass() {
        try {
            if (this.webserviceObjectClass == null) {
                this.webserviceObjectClass = this.loadClass(this.webserviceObjectClassName);
            }
            return this.webserviceObjectClass;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError((Throwable)classNotFoundException);
        }
    }

    public String getRemoteInterfaceName() {
        return this.remoteInterfaceName;
    }

    public String getLocalInterfaceName() {
        return this.localInterfaceName;
    }

    public String getServiceEndpointName() {
        return this.serviceEndpointName;
    }

    public Class getRemoteInterfaceClass() {
        return this.remoteInterfaceClass;
    }

    public Class getLocalInterfaceClass() {
        return this.localInterfaceClass;
    }

    public Class getServiceEndpointClass() {
        return this.serviceEndpointClass;
    }

    public boolean hasRemoteClientView() {
        return this.remoteInterfaceName != null;
    }

    public boolean hasLocalClientView() {
        return this.localInterfaceName != null;
    }

    public boolean hasWebserviceClientView() {
        return this.serviceEndpointName != null;
    }

    public BaseEJBRemoteHomeIntf getRemoteHome() {
        return this.remoteHome;
    }

    public BaseEJBLocalHomeIntf getLocalHome() {
        return this.localHome;
    }

    public ClusteringDescriptor getClusteringDescriptor() {
        return this.clusteringDescriptor;
    }

    private void initializeMethodInfos() throws WLDeploymentException {
        try {
            List<Object> list;
            List<Object> list2;
            if (this.hasDeclaredRemoteHome()) {
                list2 = Arrays.asList((Object[])this.remoteInterfaceClass.getMethods());
                this.createMethodInfoImpls(list2, "Remote", this.remoteMethods);
                list = Arrays.asList((Object[])this.homeInterfaceClass.getMethods());
                this.createMethodInfoImpls(list, "Home", this.homeMethods);
            }
            if (this.hasDeclaredLocalHome()) {
                list2 = new ArrayList<Object>();
                list2.addAll(Arrays.asList((Object[])this.localInterfaceClass.getMethods()));
                list2.addAll(Arrays.asList((Object[])BaseEJBLocalObjectIntf.class.getMethods()));
                this.createMethodInfoImpls(list2, "Local", this.localMethods);
                list = Arrays.asList((Object[])this.localHomeInterfaceClass.getMethods());
                this.createMethodInfoImpls(list, "LocalHome", this.localHomeMethods);
            }
            if (this.hasWebserviceClientView()) {
                list2 = this.isEJB30() ? DeployUtil.getWebServiceMethods(this.beanClass, this.serviceEndpointClass) : Arrays.asList((Object[])this.serviceEndpointClass.getMethods());
                this.createMethodInfoImpls(list2, "ServiceEndpoint", this.getWebserviceMethods());
            }
        }
        catch (Throwable throwable) {
            Loggable loggable = EJBLogger.logunableToInitializeInterfaceMethodInfoLoggable((String)this.ejbName, (String)StackTraceUtils.throwable2StackTrace((Throwable)throwable));
            throw new WLDeploymentException(loggable.getMessage(), throwable);
        }
    }

    protected void createMethodInfoImpls(Collection collection, String string, Map map) {
        Iterator iterator = collection.iterator();
        boolean bl = debugLogger.isDebugEnabled();
        while (iterator.hasNext()) {
            Method method = (Method)iterator.next();
            MethodInfoImpl methodInfoImpl = MethodInfoImpl.createMethodInfoImpl(method, string, this.jaccPolicyContextId);
            if (bl) {
                ClientDrivenBeanInfoImpl.debug(string + ".....result.put(" + methodInfoImpl.getSignature() + ")");
            }
            map.put(methodInfoImpl.getSignature(), methodInfoImpl);
        }
    }

    public MethodInfo getRemoteMethodInfo(String string) {
        return (MethodInfo)this.remoteMethods.get(string);
    }

    public MethodInfo getRemoteMethodInfo(String string, String[] stringArray) {
        return (MethodInfo)this.remoteMethods.get(ClientDrivenBeanInfoImpl.getMethodSignature(string, stringArray));
    }

    public MethodInfo getRemoteMethodInfo(Method method) {
        return (MethodInfo)this.remoteMethods.get(ClientDrivenBeanInfoImpl.getMethodSignature(method));
    }

    public Collection getAllRemoteMethodInfos() {
        return this.remoteMethods.values();
    }

    public MethodInfo getHomeMethodInfo(String string) {
        return (MethodInfo)this.homeMethods.get(string);
    }

    public MethodInfo getHomeMethodInfo(String string, String[] stringArray) {
        return (MethodInfo)this.homeMethods.get(ClientDrivenBeanInfoImpl.getMethodSignature(string, stringArray));
    }

    public MethodInfo getHomeMethodInfo(Method method) {
        return (MethodInfo)this.homeMethods.get(ClientDrivenBeanInfoImpl.getMethodSignature(method));
    }

    public Collection getAllHomeMethodInfos() {
        return this.homeMethods.values();
    }

    public MethodInfo getLocalMethodInfo(String string) {
        return (MethodInfo)this.localMethods.get(string);
    }

    public MethodInfo getLocalMethodInfo(String string, String[] stringArray) {
        return (MethodInfo)this.localMethods.get(ClientDrivenBeanInfoImpl.getMethodSignature(string, stringArray));
    }

    public MethodInfo getLocalMethodInfo(Method method) {
        return (MethodInfo)this.localMethods.get(ClientDrivenBeanInfoImpl.getMethodSignature(method));
    }

    public Collection getAllLocalMethodInfos() {
        return this.localMethods.values();
    }

    public MethodInfo getLocalHomeMethodInfo(String string) {
        return (MethodInfo)this.localHomeMethods.get(string);
    }

    public MethodInfo getLocalHomeMethodInfo(String string, String[] stringArray) {
        return (MethodInfo)this.localHomeMethods.get(ClientDrivenBeanInfoImpl.getMethodSignature(string, stringArray));
    }

    public MethodInfo getLocalHomeMethodInfo(Method method) {
        return (MethodInfo)this.localHomeMethods.get(ClientDrivenBeanInfoImpl.getMethodSignature(method));
    }

    public Collection getAllLocalHomeMethodInfos() {
        return this.localHomeMethods.values();
    }

    private Map getWebserviceMethods() {
        if (this.webserviceMethods == null) {
            this.webserviceMethods = new HashMap();
        }
        return this.webserviceMethods;
    }

    public MethodInfo getWebserviceMethodInfo(String string) {
        return (MethodInfo)this.getWebserviceMethods().get(string);
    }

    public MethodInfo getWebserviceMethodInfo(String string, String[] stringArray) {
        return (MethodInfo)this.getWebserviceMethods().get(ClientDrivenBeanInfoImpl.getMethodSignature(string, stringArray));
    }

    public MethodInfo getWebserviceMethodInfo(Method method) {
        return (MethodInfo)this.getWebserviceMethods().get(ClientDrivenBeanInfoImpl.getMethodSignature(method));
    }

    public Collection getAllWebserviceMethodInfos() {
        return this.getWebserviceMethods().values();
    }

    public Iterator getAllMethodInfosIterator() {
        ArrayList arrayList = new ArrayList();
        if (this.hasRemoteClientView()) {
            arrayList.add(this.homeMethods.values().iterator());
            arrayList.add(this.remoteMethods.values().iterator());
        }
        if (this.hasLocalClientView()) {
            arrayList.add(this.localHomeMethods.values().iterator());
            arrayList.add(this.localMethods.values().iterator());
        }
        if (this.hasWebserviceClientView()) {
            arrayList.add(this.getWebserviceMethods().values().iterator());
            arrayList.add(this.localHomeMethods.values().iterator());
        }
        arrayList.add(this.getAllBeanMethodInfos().iterator());
        return new CombinedIterator(arrayList);
    }

    protected void setMethodDescriptors(BaseEJBHomeIntf baseEJBHomeIntf, Class clazz, String string) throws WLDeploymentException {
        Method[] methodArray = clazz.getMethods();
        this.setMethodDescriptors(baseEJBHomeIntf, clazz, methodArray, string);
    }

    protected void setMethodDescriptors(BaseEJBHomeIntf baseEJBHomeIntf, Class clazz, Method[] methodArray, String string) throws WLDeploymentException {
        String string2 = EntityBeanInfoImpl.getCreateQuerySignature();
        for (int i = 0; i < methodArray.length; ++i) {
            Object object;
            Method method = methodArray[i];
            if (BeaSynthetic.Helper.isBeaSyntheticMethod((Method)method)) continue;
            boolean bl = false;
            MethodInfo methodInfo = null;
            if (string.equals("Remote")) {
                methodInfo = this.getRemoteMethodInfo(method);
            } else if (string.equals("Home")) {
                methodInfo = this.getHomeMethodInfo(method);
            } else if (string.equals("Local")) {
                methodInfo = this.getLocalMethodInfo(method);
                bl = true;
            } else if (string.equals("LocalHome")) {
                methodInfo = this.getLocalHomeMethodInfo(method);
                bl = true;
            } else if (string.equals("ServiceEndpoint")) {
                methodInfo = this.getWebserviceMethodInfo(method);
                bl = true;
            }
            if (methodInfo == null) continue;
            if (this instanceof EntityBeanInfoImpl && string2.equals(methodInfo.getSignature())) {
                object = (EntityBeanInfo)((Object)this);
                if (!object.isDynamicQueriesEnabled()) continue;
                methodInfo.setTransactionAttribute((short)1);
                methodInfo.setTxIsolationLevel(-1);
                methodInfo.setSelectForUpdate(0);
                this.setMethodDescriptor(baseEJBHomeIntf, method, clazz, methodInfo, bl, "createQuery", string);
                continue;
            }
            object = new MethodText();
            object.setMethod(method);
            object.setOptions(128);
            String string3 = object.toString();
            if (string.equals("Home") || string.equals("LocalHome")) {
                if (!(string3.equals("getEJBMetaData") && string.equals("Home") || string3.equals("getHomeHandle") && string.equals("Home") || string3.equals("getLocalHomeHandle") && string.equals("LocalHome"))) {
                    string3 = this.homeToBeanName(string3);
                }
            } else if (string.equals("Remote") || string.equals("Local") || string.equals("ServiceEndpoint")) {
                string3 = "eo_" + string3;
            } else {
                Debug.stackdump((String)("encountered unknown interface type: '" + string + "'"));
            }
            this.setMethodDescriptor(baseEJBHomeIntf, method, clazz, methodInfo, bl, string3, string);
        }
    }

    protected MethodDescriptor setMethodDescriptor(BaseEJBHomeIntf baseEJBHomeIntf, Method method, Class clazz, MethodInfo methodInfo, boolean bl, String string, String string2) throws WLDeploymentException {
        MethodDescriptor methodDescriptor;
        try {
            methodDescriptor = super.setMethodDescriptor(baseEJBHomeIntf, method, clazz, methodInfo, bl, string, string2);
        }
        catch (Exception exception) {
            throw new WLDeploymentException(exception.toString());
        }
        Method method2 = this.perhapsGetBeanMethod(method, string2);
        methodDescriptor.setMethod(method2);
        return methodDescriptor;
    }

    private String homeToBeanName(String string) {
        if (string.startsWith("create") || string.startsWith("find") || string.startsWith("remove")) {
            StringBuffer stringBuffer = new StringBuffer("ejb" + string);
            stringBuffer.setCharAt(3, Character.toUpperCase(stringBuffer.charAt(3)));
            return stringBuffer.toString();
        }
        return "ejbHome" + string;
    }

    private Method perhapsGetBeanMethod(Method method, String string) {
        String string2;
        Class<?> clazz = method.getDeclaringClass();
        if ((string.equals("Home") || string.equals("LocalHome")) && this instanceof EntityBeanInfoImpl && (string2 = method.getName()).startsWith("find")) {
            Class clazz2 = this.getGeneratedBeanInterface();
            String string3 = "ejb" + string2.substring(0, 1).toUpperCase(Locale.ENGLISH) + string2.substring(1);
            try {
                Method method2 = clazz2.getMethod(string3, method.getParameterTypes());
                return method2;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (string2.equals("findByPrimaryKey")) {
                    Method[] methodArray = clazz2.getMethods();
                    for (int i = 0; i < methodArray.length; ++i) {
                        if (!methodArray[i].getName().equals("ejbFindByPrimaryKey")) continue;
                        return methodArray[i];
                    }
                }
                Class clazz3 = null;
                clazz3 = string.equals("Home") ? this.getHomeInterfaceClass() : this.getLocalHomeInterfaceClass();
                try {
                    Method method3 = clazz3.getMethod(method.getName(), method.getParameterTypes());
                    return method3;
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    throw new AssertionError("ejbFindXXX method for '" + ClientDrivenBeanInfoImpl.getMethodSignature(method) + "' not found on class '" + clazz2.getName() + "'.");
                }
            }
        }
        return method;
    }

    private void dumpMethodDescriptors() {
        Field[] fieldArray;
        if (this.hasRemoteClientView()) {
            ClientDrivenBeanInfoImpl.debug("** Dumping Remote MethodDescriptor for: " + this.getDisplayName());
            if (this.hasDeclaredRemoteHome()) {
                fieldArray = this.getHomeClass().getFields();
                this.dumpMethodDescriptorFields(fieldArray, this.remoteHome);
                fieldArray = this.getRemoteClass().getFields();
                this.dumpMethodDescriptorFields(fieldArray, null);
            }
        }
        if (this.hasLocalClientView()) {
            ClientDrivenBeanInfoImpl.debug("** Dumping Local MethodDescriptor for: " + this.getLocalJNDIName());
            if (this.hasDeclaredLocalHome()) {
                fieldArray = this.getLocalHomeClass().getFields();
                this.dumpMethodDescriptorFields(fieldArray, this.localHome);
                fieldArray = this.getLocalClass().getFields();
                this.dumpMethodDescriptorFields(fieldArray, null);
            }
        }
        if (this.hasWebserviceClientView()) {
            fieldArray = this.getWebserviceObjectClass().getFields();
            ClientDrivenBeanInfoImpl.debug("** Dumping Webservice MethodDescriptor for: " + this.getServiceEndpointName());
            this.dumpMethodDescriptorFields(fieldArray, null);
        }
    }

    private void dumpMethodInfos() {
        Iterator iterator;
        if (this.hasRemoteClientView()) {
            ClientDrivenBeanInfoImpl.debug("Dumping Remote MethodInfos for: " + this.getDisplayName());
            ClientDrivenBeanInfoImpl.debug("Remote Methods:");
            iterator = this.getAllRemoteMethodInfos().iterator();
            while (iterator.hasNext()) {
                ClientDrivenBeanInfoImpl.debug(iterator.next().toString());
            }
            if (this.hasDeclaredRemoteHome()) {
                ClientDrivenBeanInfoImpl.debug("Home Methods:");
                iterator = this.getAllHomeMethodInfos().iterator();
                while (iterator.hasNext()) {
                    ClientDrivenBeanInfoImpl.debug(iterator.next().toString());
                }
            }
        }
        if (this.hasLocalClientView()) {
            ClientDrivenBeanInfoImpl.debug("Dumping Local MethodInfos for: " + this.getLocalJNDIName());
            ClientDrivenBeanInfoImpl.debug("Local Methods:");
            iterator = this.getAllLocalMethodInfos().iterator();
            while (iterator.hasNext()) {
                ClientDrivenBeanInfoImpl.debug(iterator.next().toString());
            }
            if (this.hasDeclaredLocalHome()) {
                ClientDrivenBeanInfoImpl.debug("Local Home Methods:");
                iterator = this.getAllLocalHomeMethodInfos().iterator();
                while (iterator.hasNext()) {
                    ClientDrivenBeanInfoImpl.debug(iterator.next().toString());
                }
            }
        }
        if (this.hasWebserviceClientView()) {
            ClientDrivenBeanInfoImpl.debug("Dumping Webservice MethodInfos for: " + this.getEJBName());
            ClientDrivenBeanInfoImpl.debug("Webservice Methods:");
            iterator = this.getAllWebserviceMethodInfos().iterator();
            while (iterator.hasNext()) {
                ClientDrivenBeanInfoImpl.debug(iterator.next().toString());
            }
        }
    }

    public void prepare(ApplicationContextInternal applicationContextInternal, DeploymentInfo deploymentInfo) throws WLDeploymentException {
        super.prepare(applicationContextInternal);
        BeanManager beanManager = this.getBeanManager();
        this.registerRoleRefs();
        try {
            Remote remote;
            InitialContext initialContext;
            try {
                initialContext = new InitialContext();
            }
            catch (NamingException namingException) {
                AssertionError assertionError = new AssertionError("Error creating InitialContext!");
                assertionError.initCause((Throwable)namingException);
                throw assertionError;
            }
            if (this.hasRemoteClientView()) {
                this.remoteHome = (BaseEJBRemoteHomeIntf)this.getHomeClass().newInstance();
                this.remoteHome.setBeanInfo(this);
                this.remoteHome.setDeploymentInfo(deploymentInfo);
                this.remoteHome.setup(this, this.localHome, beanManager);
                if (this.hasDeclaredRemoteHome()) {
                    this.setMethodDescriptors(this.remoteHome, this.getHomeClass(), "Home");
                    this.setMethodDescriptors(null, this.getRemoteClass(), "Remote");
                }
                if (this.getJNDIName() != null && this.hasDeclaredRemoteHome()) {
                    try {
                        remote = (Remote)initialContext.lookup(this.getJNDIName());
                        if (!ServerHelper.isClusterable((Remote)remote) || ServerHelper.isLocal((Remote)remote)) {
                            Loggable loggable = EJBLogger.logJNDINameAlreadyInUseLoggable((String)this.getDisplayName(), (String)this.getJNDINameAsString());
                            throw new WLDeploymentException(loggable.getMessage());
                        }
                    }
                    catch (NamingException namingException) {
                        // empty catch block
                    }
                }
            }
            if (this.hasLocalClientView()) {
                this.localHome = (BaseEJBLocalHomeIntf)this.getLocalHomeClass().newInstance();
                this.localHome.setBeanInfo(this);
                this.localHome.setDeploymentInfo(deploymentInfo);
                this.localHome.setup(this, this.remoteHome, beanManager);
                if (this.hasDeclaredLocalHome()) {
                    this.setMethodDescriptors(this.localHome, this.getLocalHomeClass(), "LocalHome");
                    this.setMethodDescriptors(null, this.getLocalClass(), "Local");
                }
                if (this.getLocalJNDIName() != null && this.hasDeclaredLocalHome()) {
                    try {
                        initialContext.lookup(this.getLocalJNDIName());
                        remote = EJBLogger.logJNDINameAlreadyInUseLoggable((String)this.getDisplayName(), (String)this.getLocalJNDINameAsString());
                        throw new WLDeploymentException(remote.getMessage());
                    }
                    catch (NamingException namingException) {
                        // empty catch block
                    }
                }
            }
            if (this.hasWebserviceClientView()) {
                this.webserviceObjectFactory = new WSObjectFactoryImpl(beanManager, this);
                try {
                    this.setMethodDescriptors(null, this.getWebserviceObjectClass(), "ServiceEndpoint");
                }
                catch (Throwable throwable) {
                    Debug.say((String)(" development time message:  no webservice available for EJB '" + this.getEJBName() + "' " + throwable.getMessage()));
                }
            }
            if (debugLogger.isDebugEnabled()) {
                this.dumpMethodInfos();
                this.dumpMethodDescriptors();
            }
        }
        catch (InstantiationException instantiationException) {
            throw new AssertionError((Throwable)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Throwable)illegalAccessException);
        }
    }

    public EjbJndiBinder getJndiBinder() {
        if (this.jndiBinder == null) {
            this.jndiBinder = new Ejb2JndiBinder(this);
        }
        return this.jndiBinder;
    }

    public void activate(Context context, Map map, Map map2, DeploymentInfo deploymentInfo, Context context2) throws WLDeploymentException {
        Object object;
        Object object2;
        BeanManager beanManager = this.getBeanManager();
        if (beanManager instanceof CachingManager) {
            object2 = this.getCache(map);
            if (beanManager instanceof TTLManager) {
                object = this.getQueryCache(map2);
                ((TTLManager)beanManager).setup(this.remoteHome, this.localHome, this, context2, (EJBCache)object2, (QueryCache)object);
            } else {
                ((CachingManager)((Object)beanManager)).setup(this.remoteHome, this.localHome, this, context2, (EJBCache)object2);
            }
        } else {
            beanManager.setup(this.remoteHome, this.localHome, this, context2);
        }
        object2 = beanManager.getEJBRuntimeMBean();
        if (object2 != null) {
            object = (EJBRuntimeMBeanImpl)object2;
            String string = this.getDispatchPolicy();
            if (string == null || string.trim().length() == 0) {
                string = "default";
            }
            ExecuteQueueRuntimeMBean[] executeQueueRuntimeMBeanArray = ManagementService.getRuntimeAccess(kernelId).getServerRuntime().getExecuteQueueRuntimes();
            ExecuteQueueRuntimeMBean executeQueueRuntimeMBean = null;
            for (int i = 0; i < executeQueueRuntimeMBeanArray.length; ++i) {
                if (!executeQueueRuntimeMBeanArray[i].getName().equals(string)) continue;
                executeQueueRuntimeMBean = executeQueueRuntimeMBeanArray[i];
                break;
            }
            if (executeQueueRuntimeMBean != null) {
                ((EJBRuntimeMBeanImpl)object).addResource(executeQueueRuntimeMBean);
            } else if (debugLogger.isDebugEnabled()) {
                ClientDrivenBeanInfoImpl.debug("Error looking up ExecuteQueueRuntimeMBean!!!!!!");
            }
        }
        if (this.hasRemoteClientView()) {
            this.remoteHome.activate();
        }
        this.getJndiBinder().bindToJNDI();
    }

    public void bindEJBRefs(Context context) throws NamingException {
        if (this.hasDeclaredLocalHome()) {
            context.bind(this.getLocalHomeInterfaceName(), (Object)this.getLocalHome());
            context.bind("local-home", (Object)this.getLocalHome());
        }
        if (this.hasDeclaredRemoteHome()) {
            Object object = this.getRemoteHome().getReferenceToBind();
            context.bind(this.getHomeInterfaceName(), object);
            context.bind("home", object);
        }
    }

    public void unbindEJBRefs(Context context) throws NamingException {
        if (this.hasDeclaredLocalHome()) {
            context.unbind(this.getLocalHomeInterfaceName());
            context.unbind("local-home");
        }
        if (this.hasDeclaredRemoteHome()) {
            context.unbind(this.getHomeInterfaceName());
            context.unbind("home");
        }
    }

    public void onUndeploy() {
        this.getJndiBinder().unbindFromJNDI();
        super.onUndeploy();
    }

    protected abstract EJBCache getCache(Map var1) throws WLDeploymentException;

    protected QueryCache getQueryCache(Map map) throws WLDeploymentException {
        throw new AssertionError("Only EntityBeanInfoImpl implements this method");
    }

    public void prepareLockTimeout(int n) throws BeanUpdateRejectedException {
        if (n < -1) {
            throw new BeanUpdateRejectedException("Value for newLockTimout is < -1, it should be >= -1.");
        }
    }

    public void prepareDataCacheTimeout(int n) throws BeanUpdateRejectedException {
        if (n < -1) {
            throw new BeanUpdateRejectedException("Value for dataCacheTimout is < -1, it should be >= -1.");
        }
    }

    public void prepareFetchBatchSize(int n) throws BeanUpdateRejectedException {
        if (n < -1) {
            throw new BeanUpdateRejectedException("Value for fetchBatchSize is < -1, it should be >= -1.");
        }
    }

    public void updateImplClassLoader() throws WLDeploymentException {
        super.updateImplClassLoader();
    }

    public void updateTransactionTimeoutSeconds(int n) {
        super.updateTransactionTimeoutSeconds(n);
        int n2 = n * 1000;
        for (MethodDescriptor methodDescriptor : this.getMethodDescriptors()) {
            methodDescriptor.updateTxTimeoutMS(n2);
        }
    }

    public void updateMaxBeansInCache(int n) {
        BeanManager beanManager = this.getBeanManager();
        if (beanManager instanceof CachingManager) {
            ((CachingManager)((Object)beanManager)).updateMaxBeansInCache(n);
        }
        if (debugLogger.isDebugEnabled()) {
            ClientDrivenBeanInfoImpl.debug("updated MaxBeansInCache to " + n + " for EJB " + this.getDisplayName());
        }
    }

    public void updateLockTimeout(int n, String string) {
        PersistenceUnitInfoImpl persistenceUnitInfoImpl = this.persistenceUnitRegistry.getPersistenceUnit(string);
        EntityManagerFactory entityManagerFactory = persistenceUnitInfoImpl.getEntityManagerFactory();
        OpenJPAConfigurationImpl openJPAConfigurationImpl = this.getConfiguration(entityManagerFactory);
        openJPAConfigurationImpl.lockTimeout.set(n);
    }

    private OpenJPAConfigurationImpl getConfiguration(EntityManagerFactory entityManagerFactory) {
        return (OpenJPAConfigurationImpl)((OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.cast((EntityManagerFactory)entityManagerFactory)).getConfiguration();
    }

    public void updateDataCacheTimeout(int n, String string) {
        PersistenceUnitInfoImpl persistenceUnitInfoImpl = this.persistenceUnitRegistry.getPersistenceUnit(string);
        EntityManagerFactory entityManagerFactory = persistenceUnitInfoImpl.getEntityManagerFactory();
        OpenJPAConfigurationImpl openJPAConfigurationImpl = this.getConfiguration(entityManagerFactory);
        int n2 = openJPAConfigurationImpl.dataCacheTimeout.get();
        openJPAConfigurationImpl.dataCacheTimeout.set(n);
        MetaDataRepository metaDataRepository = openJPAConfigurationImpl.getMetaDataRepositoryInstance();
        if (metaDataRepository == null) {
            return;
        }
        ClassMetaData[] classMetaDataArray = metaDataRepository.getMetaDatas();
        if (classMetaDataArray == null) {
            return;
        }
        ArrayList<ClassMetaData> arrayList = new ArrayList<ClassMetaData>();
        for (ClassMetaData classMetaData : classMetaDataArray) {
            if (classMetaData.getDataCacheTimeout() != n2) continue;
            arrayList.add(classMetaData);
        }
        for (ClassMetaData classMetaData : arrayList) {
            classMetaData.setDataCacheTimeout(n);
        }
    }

    public void updateFetchBatchSize(int n, String string) {
        PersistenceUnitInfoImpl persistenceUnitInfoImpl = this.persistenceUnitRegistry.getPersistenceUnit(string);
        EntityManagerFactory entityManagerFactory = persistenceUnitInfoImpl.getEntityManagerFactory();
        this.getConfiguration((EntityManagerFactory)entityManagerFactory).fetchBatchSize.set(n);
    }

    public void assignDefaultTXAttributesIfNecessary() {
        StringBuffer stringBuffer = new StringBuffer();
        short s = DDDefaults.getTransactionAttribute(this);
        StringBuffer stringBuffer2 = new StringBuffer();
        short s2 = DDDefaults.getBeanMethodTransactionAttribute(this);
        if (this.hasDeclaredRemoteHome()) {
            stringBuffer.append(this.assignDefaultTXAttributesIfNecessary("home", this.getAllHomeMethodInfos(), s));
        }
        stringBuffer.append(this.assignDefaultTXAttributesIfNecessary("remote", this.getAllRemoteMethodInfos(), s));
        if (this.hasDeclaredLocalHome()) {
            stringBuffer.append(this.assignDefaultTXAttributesIfNecessary("local-home", this.getAllLocalHomeMethodInfos(), s));
        }
        stringBuffer.append(this.assignDefaultTXAttributesIfNecessary("local", this.getAllLocalMethodInfos(), s));
        stringBuffer.append(this.assignDefaultTXAttributesIfNecessary("webservice", this.getAllWebserviceMethodInfos(), s));
        stringBuffer2.append(this.assignDefaultTXAttributesIfNecessary("beanClass", this.getAllBeanMethodInfos(), s2));
        if (stringBuffer.length() > 0 && !this.isEJB30()) {
            EJBLogger.logEJBUsesDefaultTXAttribute((String)this.getDisplayName(), (String)DDConstants.TX_ATTRIBUTE_STRINGS[s], (String)stringBuffer.toString());
        }
        if (stringBuffer2.length() > 0 && !this.isEJB30()) {
            EJBLogger.logEJBUsesDefaultTXAttribute((String)this.getDisplayName(), (String)DDConstants.TX_ATTRIBUTE_STRINGS[s2], (String)stringBuffer2.toString());
        }
    }

    private void registerRoleRefs() throws WLDeploymentException {
        this.runtimeHelper.registerRoleRefs(this.ejbName, this.secRoleRefs);
    }

    private void checkClientViews() throws WLDeploymentException {
        if (this.homeInterfaceName != null && this.remoteInterfaceName == null || this.homeInterfaceName == null && this.remoteInterfaceName != null) {
            EJBComplianceTextFormatter eJBComplianceTextFormatter = new EJBComplianceTextFormatter();
            throw new WLDeploymentException(eJBComplianceTextFormatter.INCONSISTENT_REMOTE_VIEW(this.getEJBName()));
        }
        if (this.localHomeInterfaceName != null && this.localInterfaceName == null || this.localHomeInterfaceName == null && this.localInterfaceName != null) {
            EJBComplianceTextFormatter eJBComplianceTextFormatter = new EJBComplianceTextFormatter();
            throw new WLDeploymentException(eJBComplianceTextFormatter.INCONSISTENT_LOCAL_VIEW(this.getEJBName()));
        }
    }

    private void checkSecurityRoleRefs() throws WLDeploymentException {
        Set set = this.secRoleRefs.keySet();
        for (String string : set) {
            SecurityRoleReference securityRoleReference = (SecurityRoleReference)this.secRoleRefs.get(string);
            if (securityRoleReference.getReferencedRole() != null) continue;
            EJBComplianceTextFormatter eJBComplianceTextFormatter = new EJBComplianceTextFormatter();
            throw new WLDeploymentException(eJBComplianceTextFormatter.NULL_SECURITY_ROLE_REF_LINK(this.getEJBName(), string));
        }
    }

    protected boolean checkIfItsSafeToUseCallByReference() {
        Debug.assertion((!this.callByReference ? 1 : 0) != 0);
        if (!this.hasRemoteClientView()) {
            return false;
        }
        if (this.hasDeclaredRemoteHome()) {
            int n;
            Method[] methodArray = this.remoteInterfaceClass.getMethods();
            for (n = 0; n < methodArray.length; ++n) {
                if (!this.businessMethod(methodArray[n]) || this.checkIfMethodCanUseCallByReference(methodArray[n])) continue;
                return false;
            }
            methodArray = this.homeInterfaceClass.getMethods();
            for (n = 0; n < methodArray.length; ++n) {
                if (!this.homeMethod(methodArray[n]) || this.checkIfMethodCanUseCallByReference(methodArray[n])) continue;
                return false;
            }
        }
        return true;
    }

    private boolean businessMethod(Method method) {
        try {
            EJBObject.class.getMethod(method.getName(), method.getParameterTypes());
            return false;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return true;
        }
    }

    private boolean homeMethod(Method method) {
        try {
            EJBHome.class.getMethod(method.getName(), method.getParameterTypes());
            return false;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            String string = method.getName();
            return !string.startsWith("find") && !string.startsWith("create") && !string.startsWith("remove");
        }
    }

    private boolean isMutable(Class clazz) {
        if (clazz.isPrimitive()) {
            return false;
        }
        for (int i = 0; i < this.immutableClasses.length; ++i) {
            if (!clazz.equals(this.immutableClasses[i])) continue;
            return false;
        }
        return true;
    }

    protected boolean checkIfMethodCanUseCallByReference(Method method) {
        if (this.isMutable(method.getReturnType())) {
            return false;
        }
        Class<?>[] classArray = method.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            if (!this.isMutable(classArray[i])) continue;
            return false;
        }
        return true;
    }

    protected void warnIfParameterNotSerializable() {
        if (!this.hasRemoteClientView()) {
            return;
        }
        if (this.remoteInterfaceClass == null) {
            return;
        }
        Method[] methodArray = this.remoteInterfaceClass.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!this.businessMethod(methodArray[i])) continue;
            this.warnIfParamNotSerializableForMethod(methodArray[i]);
        }
    }

    protected void warnIfParamNotSerializableForMethod(Method method) {
        Type[] typeArray = method.getGenericParameterTypes();
        for (int i = 0; i < typeArray.length; ++i) {
            Class clazz;
            if (!(typeArray[i] instanceof Class) || (clazz = (Class)typeArray[i]).isPrimitive() || Serializable.class.isAssignableFrom(clazz) || this.getDeploymentInfo().isWarningDisabled("BEA-012034")) continue;
            EJBLogger.logWarningParameterIsNotSerializable((String)method.toString(), (String)this.m_desc.getEJBName(), (String)clazz.getName());
        }
    }

    public boolean useCallByReference() {
        return this.callByReference;
    }

    private static void debug(String string) {
        debugLogger.debug("[ClientDrivenBeanInfoImpl] " + string);
    }

    public boolean isClientDriven() {
        return true;
    }

    public void updateCacheIdleTimeoutSeconds(int n) {
        BeanManager beanManager = this.getBeanManager();
        if (beanManager instanceof CachingManager) {
            CachingManager cachingManager = (CachingManager)((Object)beanManager);
            cachingManager.updateIdleTimeoutSecondsCache(n);
        }
        if (debugLogger.isDebugEnabled()) {
            ClientDrivenBeanInfoImpl.debug("updated Cache IdleTimeoutSeconds to " + n + " for EJB " + this.getDisplayName());
        }
    }

    public void unprepare() {
        BaseEJBRemoteHomeIntf baseEJBRemoteHomeIntf = this.getRemoteHome();
        if (baseEJBRemoteHomeIntf != null) {
            baseEJBRemoteHomeIntf.unprepare();
        }
    }

    public PersistenceUnitRegistry getPersistenceUnitRegistry() {
        return this.persistenceUnitRegistry;
    }

    public void setPersistenceUnitRegistry(PersistenceUnitRegistry persistenceUnitRegistry) {
        this.persistenceUnitRegistry = persistenceUnitRegistry;
    }
}

