/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.deployer;

import java.security.AccessController;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import weblogic.descriptor.DescriptorBean;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.compliance.EJBComplianceTextFormatter;
import weblogic.ejb.container.dd.ClusteringDescriptor;
import weblogic.ejb.container.deployer.CachingDescriptorImpl;
import weblogic.ejb.container.deployer.IIOPSecurityDescriptorImpl;
import weblogic.ejb.container.deployer.mbimpl.SecurityRoleRefImpl;
import weblogic.ejb.container.interfaces.CachingDescriptor;
import weblogic.ejb.container.interfaces.IIOPSecurityDescriptor;
import weblogic.ejb.spi.EjbDescriptorBean;
import weblogic.ejb.spi.WLDeploymentException;
import weblogic.j2ee.descriptor.EjbJarBean;
import weblogic.j2ee.descriptor.EjbLocalRefBean;
import weblogic.j2ee.descriptor.EjbRefBean;
import weblogic.j2ee.descriptor.EnterpriseBeanBean;
import weblogic.j2ee.descriptor.EnterpriseBeansBean;
import weblogic.j2ee.descriptor.EntityBeanBean;
import weblogic.j2ee.descriptor.EnvEntryBean;
import weblogic.j2ee.descriptor.MessageDestinationRefBean;
import weblogic.j2ee.descriptor.MessageDrivenBeanBean;
import weblogic.j2ee.descriptor.NamedMethodBean;
import weblogic.j2ee.descriptor.PersistenceContextRefBean;
import weblogic.j2ee.descriptor.PersistenceUnitRefBean;
import weblogic.j2ee.descriptor.ResourceEnvRefBean;
import weblogic.j2ee.descriptor.ResourceRefBean;
import weblogic.j2ee.descriptor.RunAsBean;
import weblogic.j2ee.descriptor.SecurityIdentityBean;
import weblogic.j2ee.descriptor.SecurityRoleRefBean;
import weblogic.j2ee.descriptor.ServiceRefBean;
import weblogic.j2ee.descriptor.SessionBeanBean;
import weblogic.j2ee.descriptor.wl.BusinessInterfaceJndiNameMapBean;
import weblogic.j2ee.descriptor.wl.EjbReferenceDescriptionBean;
import weblogic.j2ee.descriptor.wl.EntityCacheBean;
import weblogic.j2ee.descriptor.wl.EntityCacheRefBean;
import weblogic.j2ee.descriptor.wl.EntityDescriptorBean;
import weblogic.j2ee.descriptor.wl.InvalidationTargetBean;
import weblogic.j2ee.descriptor.wl.MessageDrivenDescriptorBean;
import weblogic.j2ee.descriptor.wl.PersistenceBean;
import weblogic.j2ee.descriptor.wl.PersistenceUseBean;
import weblogic.j2ee.descriptor.wl.ResourceDescriptionBean;
import weblogic.j2ee.descriptor.wl.ResourceEnvDescriptionBean;
import weblogic.j2ee.descriptor.wl.ServiceReferenceDescriptionBean;
import weblogic.j2ee.descriptor.wl.TimerDescriptorBean;
import weblogic.j2ee.descriptor.wl.TransactionDescriptorBean;
import weblogic.j2ee.descriptor.wl.WeblogicEjbJarBean;
import weblogic.j2ee.descriptor.wl.WeblogicEnterpriseBeanBean;
import weblogic.j2ee.descriptor.wl60.BaseWeblogicRdbmsBeanBean;
import weblogic.j2ee.descriptor.wl60.WeblogicRdbmsBeanBean;
import weblogic.j2ee.descriptor.wl60.WeblogicRdbmsJarBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JTAMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.AssertionError;
import weblogic.utils.Debug;

public class CompositeMBeanDescriptor {
    private static boolean verbose = false;
    private static boolean debug = true;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private EnterpriseBeanBean m_bean;
    private EjbDescriptorBean m_ejbDesc;
    private BaseWeblogicRdbmsBeanBean m_rdbmsBean;
    private WeblogicEnterpriseBeanBean m_wlBean;
    private Map m_envEntries = null;
    private Map m_ejbReferences = null;
    private Map m_ejbLocalReferences = null;
    private Map m_allServiceReferences = null;
    private Map m_allServiceReferenceDescriptions = null;
    private Map m_allResourceReferences = null;
    private Map m_allResourceEnvReferences = null;
    private Map m_allWlResourceReferences = null;
    private Map m_allWlResourceEnvReferences = null;
    private Map m_securityRoleReferences = null;
    private Map m_businessInterfaceJndiNames = null;
    private boolean m_idleTimeoutSecondsCacheInitialized = false;
    private int m_idleTimeoutSecondsCache = 0;
    private boolean m_idleTimeoutSecondsPoolInitialized = false;
    private int m_idleTimeoutSecondsPool = 0;
    private boolean m_sessionTimeoutSecondsInitialized = false;
    private int m_sessionTimeoutSeconds = 0;
    private boolean m_readTimeoutSecondsInitialized = false;
    private int m_readTimeoutSeconds = 0;
    private CachingDescriptor m_cachingDescriptor = null;
    private static final int EJB_STATELESS_SESSION = 1;
    private static final int EJB_STATEFUL_SESSION = 2;
    private static final int EJB_ENTITY = 3;
    private static final int EJB_MESSAGE_DRIVEN = 4;
    private int m_type = -1;

    public CompositeMBeanDescriptor(EnterpriseBeanBean enterpriseBeanBean, WeblogicEnterpriseBeanBean weblogicEnterpriseBeanBean, EjbDescriptorBean ejbDescriptorBean) throws WLDeploymentException {
        this.m_bean = enterpriseBeanBean;
        this.m_ejbDesc = ejbDescriptorBean;
        this.m_wlBean = weblogicEnterpriseBeanBean;
        this.init();
    }

    public CompositeMBeanDescriptor(String string, EjbDescriptorBean ejbDescriptorBean) throws WLDeploymentException {
        this.m_bean = CompositeMBeanDescriptor.findEJB(string, ejbDescriptorBean);
        this.m_ejbDesc = ejbDescriptorBean;
        this.init();
    }

    public CompositeMBeanDescriptor(EnterpriseBeanBean enterpriseBeanBean, EjbDescriptorBean ejbDescriptorBean) throws WLDeploymentException {
        this.m_bean = enterpriseBeanBean;
        this.m_ejbDesc = ejbDescriptorBean;
        this.init();
    }

    public boolean isEJB30() {
        return this.m_ejbDesc.isEjb30();
    }

    public void delete() {
        int n;
        WeblogicEjbJarBean weblogicEjbJarBean;
        EnterpriseBeanBean enterpriseBeanBean = this.getBean();
        WeblogicEnterpriseBeanBean weblogicEnterpriseBeanBean = this.getWlBean();
        EjbJarBean ejbJarBean = this.getEJBDescriptor().getEjbJarBean();
        EnterpriseBeansBean enterpriseBeansBean = ejbJarBean.getEnterpriseBeans();
        if (this.isEntity()) {
            weblogicEjbJarBean = enterpriseBeansBean.getEntities();
            for (n = 0; n < ((EntityBeanBean[])weblogicEjbJarBean).length; ++n) {
                if (!weblogicEjbJarBean[n].getEjbName().equals(enterpriseBeanBean.getEjbName())) continue;
                ejbJarBean.getEnterpriseBeans().destroyEntity((EntityBeanBean)weblogicEjbJarBean[n]);
            }
        } else if (this.isSession()) {
            weblogicEjbJarBean = enterpriseBeansBean.getSessions();
            for (n = 0; n < ((WeblogicEjbJarBean)weblogicEjbJarBean).length; ++n) {
                if (!weblogicEjbJarBean[n].getEjbName().equals(enterpriseBeanBean.getEjbName())) continue;
                ejbJarBean.getEnterpriseBeans().destroySession((SessionBeanBean)weblogicEjbJarBean[n]);
            }
        } else if (this.isMessageDriven()) {
            weblogicEjbJarBean = enterpriseBeansBean.getMessageDrivens();
            for (n = 0; n < ((WeblogicEjbJarBean)weblogicEjbJarBean).length; ++n) {
                if (!weblogicEjbJarBean[n].getEjbName().equals(enterpriseBeanBean.getEjbName())) continue;
                enterpriseBeansBean.destroyMessageDriven((MessageDrivenBeanBean)weblogicEjbJarBean[n]);
            }
        }
        weblogicEjbJarBean = this.getEJBDescriptor().getWeblogicEjbJarBean();
        WeblogicEnterpriseBeanBean[] weblogicEnterpriseBeanBeanArray = weblogicEjbJarBean.getWeblogicEnterpriseBeans();
        for (int i = 0; i < weblogicEnterpriseBeanBeanArray.length; ++i) {
            if (!weblogicEnterpriseBeanBean.getEjbName().equals(weblogicEnterpriseBeanBeanArray[i].getEjbName())) continue;
            weblogicEjbJarBean.destroyWeblogicEnterpriseBean(weblogicEnterpriseBeanBeanArray[i]);
        }
    }

    private void init() throws WLDeploymentException {
        this.initialize60(this.m_bean, this.m_ejbDesc);
        Debug.assertion((this.m_bean.getEjbName() != null ? 1 : 0) != 0);
        Debug.assertion((this.m_wlBean.getEjbName() != null ? 1 : 0) != 0);
        CompositeMBeanDescriptor.completeBeans(this.m_ejbDesc);
        Debug.assertion((null != this.m_wlBean ? 1 : 0) != 0);
        this.initializeType();
        this.initializeEJBReferences();
        this.initializeEJBLocalReferences();
        this.initializeServiceReferences();
        this.initializeServiceReferenceDescriptions();
    }

    public String getTableName() {
        return ((WeblogicRdbmsBeanBean)this.m_rdbmsBean).getTableName();
    }

    private void initializeType() throws WLDeploymentException {
        SessionBeanBean sessionBeanBean;
        if (this.m_bean instanceof EntityBeanBean) {
            this.m_type = 3;
        } else if (this.m_bean instanceof MessageDrivenBeanBean) {
            this.m_type = 4;
        } else {
            this.m_type = 1;
            sessionBeanBean = (SessionBeanBean)this.m_bean;
            if ("stateful".equalsIgnoreCase(sessionBeanBean.getSessionType())) {
                this.m_type = 2;
            }
        }
        if (!this.isEntity() && this.m_wlBean.getEntityDescriptor() != null) {
            sessionBeanBean = EJBLogger.logmismatchBetweenEJBNamesLoggable((String)this.m_wlBean.getEjbName());
            throw new WLDeploymentException(sessionBeanBean.getMessage());
        }
        if (!this.isStatelessSession() && this.m_wlBean.getStatelessSessionDescriptor() != null) {
            sessionBeanBean = EJBLogger.logmismatchBetweenslsbEJBNamesLoggable((String)this.m_wlBean.getEjbName());
            throw new WLDeploymentException(sessionBeanBean.getMessage());
        }
        if (!this.isStatefulSession() && this.m_wlBean.getStatefulSessionDescriptor() != null) {
            sessionBeanBean = EJBLogger.logmismatchBetweensfsbEJBNamesLoggable((String)this.m_wlBean.getEjbName());
            throw new WLDeploymentException(sessionBeanBean.getMessage());
        }
        if (!this.isMessageDriven() && this.m_wlBean.getMessageDrivenDescriptor() != null) {
            sessionBeanBean = EJBLogger.logmismatchBetweenmdbEJBNamesLoggable((String)this.m_wlBean.getEjbName());
            throw new WLDeploymentException(sessionBeanBean.getMessage());
        }
    }

    public WeblogicEnterpriseBeanBean getWl60Bean() {
        return this.m_wlBean;
    }

    private void initialize60(EnterpriseBeanBean enterpriseBeanBean, EjbDescriptorBean ejbDescriptorBean) throws WLDeploymentException {
        String string = enterpriseBeanBean.getEjbName();
        WeblogicEnterpriseBeanBean[] weblogicEnterpriseBeanBeanArray = ejbDescriptorBean.getWeblogicEjbJarBean().getWeblogicEnterpriseBeans();
        for (int i = 0; i < weblogicEnterpriseBeanBeanArray.length; ++i) {
            if (!weblogicEnterpriseBeanBeanArray[i].getEjbName().equals(string)) continue;
            this.m_wlBean = weblogicEnterpriseBeanBeanArray[i];
            break;
        }
        EJBComplianceTextFormatter eJBComplianceTextFormatter = new EJBComplianceTextFormatter();
        if (this.m_wlBean == null) {
            throw new WLDeploymentException(eJBComplianceTextFormatter.CANNOT_FIND_WL_DESCRIPTOR_FOR_EJB(string));
        }
        if (enterpriseBeanBean instanceof EntityBeanBean) {
            weblogic.j2ee.descriptor.wl.WeblogicRdbmsJarBean weblogicRdbmsJarBean;
            EntityBeanBean entityBeanBean = (EntityBeanBean)enterpriseBeanBean;
            WeblogicRdbmsJarBean[] weblogicRdbmsJarBeanArray = ejbDescriptorBean.getWeblogicRdbms11JarBeans();
            block1: for (int i = 0; i < weblogicRdbmsJarBeanArray.length; ++i) {
                WeblogicRdbmsJarBean weblogicRdbmsJarBean2 = weblogicRdbmsJarBeanArray[i];
                weblogicRdbmsJarBean = weblogicRdbmsJarBean2.getWeblogicRdbmsBeans();
                for (int j = 0; j < ((WeblogicRdbmsBeanBean[])weblogicRdbmsJarBean).length; ++j) {
                    if (!string.equals(weblogicRdbmsJarBean[j].getEjbName())) continue;
                    this.m_rdbmsBean = weblogicRdbmsJarBean[j];
                    continue block1;
                }
            }
            if (null == this.m_rdbmsBean) {
                weblogic.j2ee.descriptor.wl.WeblogicRdbmsJarBean[] weblogicRdbmsJarBeanArray2 = ejbDescriptorBean.getWeblogicRdbmsJarBeans();
                block3: for (int i = 0; i < weblogicRdbmsJarBeanArray2.length; ++i) {
                    weblogicRdbmsJarBean = weblogicRdbmsJarBeanArray2[i];
                    weblogic.j2ee.descriptor.wl.WeblogicRdbmsBeanBean[] weblogicRdbmsBeanBeanArray = weblogicRdbmsJarBean.getWeblogicRdbmsBeans();
                    for (int j = 0; j < weblogicRdbmsBeanBeanArray.length; ++j) {
                        if (!string.equals(weblogicRdbmsBeanBeanArray[j].getEjbName())) continue;
                        this.m_rdbmsBean = weblogicRdbmsBeanBeanArray[j];
                        continue block3;
                    }
                }
            }
        }
    }

    public EjbDescriptorBean getEJBDescriptor() {
        return this.m_ejbDesc;
    }

    public EnterpriseBeanBean getBean() {
        return this.m_bean;
    }

    public BaseWeblogicRdbmsBeanBean getRDBMSBean() {
        return this.m_rdbmsBean;
    }

    public void setRDBMSBean(BaseWeblogicRdbmsBeanBean baseWeblogicRdbmsBeanBean) {
        this.m_rdbmsBean = baseWeblogicRdbmsBeanBean;
    }

    public WeblogicEnterpriseBeanBean getWlBean() {
        return this.m_wlBean;
    }

    public String getCMPVersion() {
        if (!this.isEntity()) {
            return null;
        }
        return ((EntityBeanBean)this.m_bean).getCmpVersion();
    }

    public String getHomeInterfaceName() {
        if (this.isSession()) {
            return ((SessionBeanBean)this.m_bean).getHome();
        }
        if (this.isEntity()) {
            return ((EntityBeanBean)this.m_bean).getHome();
        }
        throw new AssertionError("Trying to get the home interface of a MessageDriven Bean");
    }

    public void setHomeInterfaceName(String string) {
        if (this.isSession()) {
            ((SessionBeanBean)this.m_bean).setHome(string);
        } else if (this.isEntity()) {
            ((EntityBeanBean)this.m_bean).setHome(string);
        } else {
            throw new AssertionError("Trying to get the home interface of a MessageDriven Bean");
        }
    }

    public String getRemoteInterfaceName() {
        if (this.isSession()) {
            return ((SessionBeanBean)this.m_bean).getRemote();
        }
        if (this.isEntity()) {
            return ((EntityBeanBean)this.m_bean).getRemote();
        }
        throw new AssertionError("Trying to get the remote interface of a MessageDriven Bean");
    }

    public void setRemoteInterfaceName(String string) {
        if (this.isSession()) {
            ((SessionBeanBean)this.m_bean).setRemote(string);
        } else if (this.isEntity()) {
            ((EntityBeanBean)this.m_bean).setRemote(string);
        } else {
            throw new AssertionError("Trying to get the remote interface of a MessageDriven Bean");
        }
    }

    public String getLocalHomeInterfaceName() {
        if (this.isSession()) {
            return ((SessionBeanBean)this.m_bean).getLocalHome();
        }
        if (this.isEntity()) {
            return ((EntityBeanBean)this.m_bean).getLocalHome();
        }
        if (this.isMessageDriven()) {
            throw new AssertionError("Trying to get the local home interface of a MessageDriven Bean");
        }
        return null;
    }

    public String getLocalInterfaceName() {
        if (this.isSession()) {
            return ((SessionBeanBean)this.m_bean).getLocal();
        }
        if (this.isEntity()) {
            return ((EntityBeanBean)this.m_bean).getLocal();
        }
        if (this.isMessageDriven()) {
            throw new AssertionError("Trying to get the local interface of a MessageDriven Bean");
        }
        return null;
    }

    public String[] getBusinessRemotes() {
        return ((SessionBeanBean)this.m_bean).getBusinessRemotes();
    }

    public String[] getBusinessLocals() {
        return ((SessionBeanBean)this.m_bean).getBusinessLocals();
    }

    public String getMessagingTypeName() {
        if (this.isMessageDriven()) {
            return ((MessageDrivenBeanBean)this.m_bean).getMessagingType();
        }
        return null;
    }

    public String getServiceEndpointName() {
        if (this.isSession()) {
            return ((SessionBeanBean)this.m_bean).getServiceEndpoint();
        }
        return null;
    }

    public String getEJBClassName() {
        return this.m_bean.getEjbClass();
    }

    private boolean isJNDINameDefined() {
        if (this.isEJB30() && this.isSession() && ((SessionBeanBean)this.m_bean).getMappedName() != null) {
            return true;
        }
        return this.m_wlBean.getJNDIName() != null;
    }

    public String getJNDIName() {
        if (this.isEJB30() && this.isSession()) {
            SessionBeanBean sessionBeanBean = (SessionBeanBean)this.m_bean;
            if (sessionBeanBean.getMappedName() != null && sessionBeanBean.getHome() != null && this.m_wlBean.getJNDIName() == null) {
                return sessionBeanBean.getMappedName() + "#" + sessionBeanBean.getHome();
            }
            return this.m_wlBean.getJNDIName();
        }
        return this.m_wlBean.getJNDIName();
    }

    public String getBusinessJNDIName(Class clazz) {
        if (this.m_businessInterfaceJndiNames == null) {
            int n;
            BusinessInterfaceJndiNameMapBean[] businessInterfaceJndiNameMapBeanArray;
            this.m_businessInterfaceJndiNames = new HashMap();
            if (this.isStatefulSession()) {
                businessInterfaceJndiNameMapBeanArray = this.m_wlBean.getStatefulSessionDescriptor().getBusinessInterfaceJndiNameMaps();
            } else if (this.isStatelessSession()) {
                businessInterfaceJndiNameMapBeanArray = this.m_wlBean.getStatelessSessionDescriptor().getBusinessInterfaceJndiNameMaps();
            } else {
                return null;
            }
            SessionBeanBean sessionBeanBean = (SessionBeanBean)this.m_bean;
            if (sessionBeanBean.getBusinessRemotes() != null && sessionBeanBean.getMappedName() != null) {
                for (n = 0; n < sessionBeanBean.getBusinessRemotes().length; ++n) {
                    String string = sessionBeanBean.getBusinessRemotes()[n];
                    this.m_businessInterfaceJndiNames.put(string, sessionBeanBean.getMappedName() + "#" + string);
                }
            }
            for (n = 0; n < businessInterfaceJndiNameMapBeanArray.length; ++n) {
                this.m_businessInterfaceJndiNames.put(businessInterfaceJndiNameMapBeanArray[n].getBusinessRemote(), businessInterfaceJndiNameMapBeanArray[n].getJNDIName());
            }
        }
        return (String)this.m_businessInterfaceJndiNames.get(clazz.getName());
    }

    public String getDispatchPolicy() {
        return this.m_wlBean.getDispatchPolicy();
    }

    public boolean getStickToFirstServer() {
        return this.m_wlBean.isStickToFirstServer();
    }

    public int getRemoteClientTimeout() {
        return this.m_wlBean.getRemoteClientTimeout();
    }

    public String getLocalJNDIName() {
        if (this.isEJB30() && this.isSession()) {
            SessionBeanBean sessionBeanBean = (SessionBeanBean)this.m_bean;
            if (sessionBeanBean.getMappedName() != null && sessionBeanBean.getLocalHome() != null && this.m_wlBean.getLocalJNDIName() == null) {
                return sessionBeanBean.getMappedName() + "#" + sessionBeanBean.getLocalHome();
            }
            return this.m_wlBean.getLocalJNDIName();
        }
        return this.m_wlBean.getLocalJNDIName();
    }

    public String getDestinationJNDIName() {
        if (!this.isMessageDriven()) {
            return null;
        }
        MessageDrivenBeanBean messageDrivenBeanBean = (MessageDrivenBeanBean)this.m_bean;
        MessageDrivenDescriptorBean messageDrivenDescriptorBean = this.m_wlBean.getMessageDrivenDescriptor();
        if (messageDrivenDescriptorBean != null) {
            if (this.isEJB30() && messageDrivenBeanBean.getMappedName() != null && messageDrivenDescriptorBean.getDestinationJNDIName() == null) {
                return messageDrivenBeanBean.getMappedName();
            }
            return messageDrivenDescriptorBean.getDestinationJNDIName();
        }
        if (this.isEJB30() && messageDrivenBeanBean.getMappedName() != null) {
            return messageDrivenBeanBean.getMappedName();
        }
        return null;
    }

    public String getEJBName() {
        return this.m_bean.getEjbName();
    }

    public Collection getAllEnvironmentEntries() {
        if (null == this.m_envEntries) {
            this.m_envEntries = new HashMap();
            EnvEntryBean[] envEntryBeanArray = this.m_bean.getEnvEntries();
            if (null != envEntryBeanArray) {
                for (int i = 0; i < envEntryBeanArray.length; ++i) {
                    this.m_envEntries.put(envEntryBeanArray[i].getEnvEntryName(), envEntryBeanArray[i]);
                }
            }
        }
        return this.m_envEntries.values();
    }

    public Collection getAllEJBReferences() {
        return this.m_ejbReferences.values();
    }

    public Collection getAllEJBLocalReferences() {
        return this.m_ejbLocalReferences.values();
    }

    public Collection getServiceReferences() {
        return this.m_allServiceReferences.values();
    }

    public Collection getServiceReferenceDescriptions() {
        return this.m_allServiceReferenceDescriptions.values();
    }

    public Collection getAllResourceReferences() {
        if (null == this.m_allResourceReferences) {
            this.m_allResourceReferences = new HashMap();
            ResourceRefBean[] resourceRefBeanArray = this.m_bean.getResourceRefs();
            if (null != resourceRefBeanArray) {
                for (int i = 0; i < resourceRefBeanArray.length; ++i) {
                    this.m_allResourceReferences.put(resourceRefBeanArray[i].getResRefName(), resourceRefBeanArray[i]);
                }
            }
        }
        return this.m_allResourceReferences.values();
    }

    public Collection getAllResourceEnvReferences() {
        if (null == this.m_allResourceEnvReferences) {
            this.m_allResourceEnvReferences = new HashMap();
            ResourceEnvRefBean[] resourceEnvRefBeanArray = this.m_bean.getResourceEnvRefs();
            if (null != resourceEnvRefBeanArray) {
                for (int i = 0; i < resourceEnvRefBeanArray.length; ++i) {
                    this.m_allResourceEnvReferences.put(resourceEnvRefBeanArray[i].getResourceEnvRefName(), resourceEnvRefBeanArray[i]);
                }
            }
        }
        return this.m_allResourceEnvReferences.values();
    }

    public Collection getAllWlResourceReferences() {
        if (null == this.m_allWlResourceReferences) {
            this.m_allWlResourceReferences = new HashMap();
            ResourceDescriptionBean[] resourceDescriptionBeanArray = this.m_wlBean.getResourceDescriptions();
            if (null != resourceDescriptionBeanArray) {
                for (int i = 0; i < resourceDescriptionBeanArray.length; ++i) {
                    this.m_allWlResourceReferences.put(resourceDescriptionBeanArray[i].getResRefName(), resourceDescriptionBeanArray[i]);
                }
            }
        }
        return this.m_allWlResourceReferences.values();
    }

    public Collection getAllWlResourceEnvReferences() {
        if (null == this.m_allWlResourceEnvReferences) {
            this.m_allWlResourceEnvReferences = new HashMap();
            ResourceEnvDescriptionBean[] resourceEnvDescriptionBeanArray = this.m_wlBean.getResourceEnvDescriptions();
            if (null != resourceEnvDescriptionBeanArray) {
                for (int i = 0; i < resourceEnvDescriptionBeanArray.length; ++i) {
                    this.m_allWlResourceEnvReferences.put(resourceEnvDescriptionBeanArray[i].getResourceEnvRefName(), resourceEnvDescriptionBeanArray[i]);
                }
            }
        }
        return this.m_allWlResourceEnvReferences.values();
    }

    public Collection getAllMessageDestinationReferences() {
        MessageDestinationRefBean[] messageDestinationRefBeanArray = this.m_bean.getMessageDestinationRefs();
        return Arrays.asList((Object[])messageDestinationRefBeanArray);
    }

    public Map getSecurityRoleReferencesMap() {
        if (null == this.m_securityRoleReferences) {
            SecurityRoleRefBean[] securityRoleRefBeanArray;
            this.m_securityRoleReferences = new HashMap();
            if ((this.isSession() || this.isEntity()) && null != (securityRoleRefBeanArray = this.isSession() ? ((SessionBeanBean)this.m_bean).getSecurityRoleRefs() : ((EntityBeanBean)this.m_bean).getSecurityRoleRefs())) {
                for (int i = 0; i < securityRoleRefBeanArray.length; ++i) {
                    this.m_securityRoleReferences.put(securityRoleRefBeanArray[i].getRoleName(), new SecurityRoleRefImpl(this.m_ejbDesc, securityRoleRefBeanArray[i]));
                }
            }
        }
        return this.m_securityRoleReferences;
    }

    public PersistenceContextRefBean[] getPersistenceContextRefs() {
        return this.m_bean.getPersistenceContextRefs();
    }

    public PersistenceUnitRefBean[] getPersistenceUnitRefs() {
        return this.m_bean.getPersistenceUnitRefs();
    }

    public int getTransactionTimeoutSeconds() {
        TransactionDescriptorBean transactionDescriptorBean = this.getWl60Bean().getTransactionDescriptor();
        int n = transactionDescriptorBean.getTransTimeoutSeconds();
        if (n == 0) {
            DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
            JTAMBean jTAMBean = domainMBean.getJTA();
            return jTAMBean.getTimeoutSeconds();
        }
        return n;
    }

    public boolean useCallByReference() {
        return this.m_wlBean.isEnableCallByReference();
    }

    public String getNetworkAccessPoint() {
        return this.m_wlBean.getNetworkAccessPoint();
    }

    public boolean getClientsOnSameServer() {
        return this.m_wlBean.isClientsOnSameServer();
    }

    public int getIdleTimeoutSecondsCache() {
        if (!this.m_idleTimeoutSecondsCacheInitialized) {
            this.m_idleTimeoutSecondsCache = -1;
            this.m_idleTimeoutSecondsCacheInitialized = true;
            if (this.isStatefulSession()) {
                this.m_idleTimeoutSecondsCache = this.m_wlBean.getStatefulSessionDescriptor().getStatefulSessionCache().getIdleTimeoutSeconds();
                this.m_idleTimeoutSecondsCacheInitialized = true;
            } else if (this.isEntity()) {
                if (this.hasEntityCacheReference()) {
                    this.m_idleTimeoutSecondsCache = this.m_wlBean.getEntityDescriptor().getEntityCacheRef().getIdleTimeoutSeconds();
                } else if (this.m_wlBean.getEntityDescriptor().getEntityCache() != null) {
                    this.m_idleTimeoutSecondsCache = this.m_wlBean.getEntityDescriptor().getEntityCache().getIdleTimeoutSeconds();
                }
            }
        }
        return this.m_idleTimeoutSecondsCache;
    }

    public void setIdleTimeoutSecondsCache(int n) {
        if (this.isStatefulSession()) {
            this.m_wlBean.getStatefulSessionDescriptor().getStatefulSessionCache().setIdleTimeoutSeconds(n);
        } else if (this.isEntity()) {
            if (this.hasEntityCacheReference()) {
                this.m_wlBean.getEntityDescriptor().getEntityCacheRef().setIdleTimeoutSeconds(n);
            } else {
                this.m_wlBean.getEntityDescriptor().getEntityCache().setIdleTimeoutSeconds(n);
            }
        }
    }

    public int getIdleTimeoutSecondsPool() {
        if (!this.m_idleTimeoutSecondsPoolInitialized) {
            this.m_idleTimeoutSecondsPool = -1;
            this.m_idleTimeoutSecondsPoolInitialized = true;
            if (this.isStatelessSession()) {
                this.m_idleTimeoutSecondsPool = this.m_wlBean.getStatelessSessionDescriptor().getPool().getIdleTimeoutSeconds();
                this.m_idleTimeoutSecondsPoolInitialized = true;
            } else if (this.isMessageDriven()) {
                this.m_idleTimeoutSecondsPool = this.m_wlBean.getMessageDrivenDescriptor().getPool().getIdleTimeoutSeconds();
                this.m_idleTimeoutSecondsPoolInitialized = true;
            } else if (this.isEntity()) {
                this.m_idleTimeoutSecondsPool = this.m_wlBean.getEntityDescriptor().getPool().getIdleTimeoutSeconds();
                this.m_idleTimeoutSecondsPoolInitialized = true;
            }
        }
        return this.m_idleTimeoutSecondsPool;
    }

    public void setIdleTimeoutSecondsPool(int n) {
        if (this.isStatelessSession()) {
            this.m_wlBean.getStatelessSessionDescriptor().getPool().setIdleTimeoutSeconds(n);
        } else if (this.isEntity()) {
            this.m_wlBean.getEntityDescriptor().getPool().setIdleTimeoutSeconds(n);
        }
    }

    public int getSessionTimeoutSeconds() {
        if (!this.m_sessionTimeoutSecondsInitialized && this.isStatefulSession()) {
            this.m_sessionTimeoutSeconds = this.m_wlBean.getStatefulSessionDescriptor().getStatefulSessionCache().getSessionTimeoutSeconds();
            this.m_sessionTimeoutSecondsInitialized = true;
        }
        return this.m_sessionTimeoutSeconds;
    }

    public void setSessionTimeoutSeconds(int n) {
        if (this.isStatefulSession()) {
            this.m_wlBean.getStatefulSessionDescriptor().getStatefulSessionCache().setSessionTimeoutSeconds(n);
        }
    }

    public int getReadTimeoutSeconds() {
        if (!this.m_readTimeoutSecondsInitialized) {
            this.m_readTimeoutSeconds = -1;
            this.m_readTimeoutSecondsInitialized = true;
            if (this.isEntity()) {
                EntityDescriptorBean entityDescriptorBean = this.m_wlBean.getEntityDescriptor();
                boolean bl = false;
                if (this.hasEntityCacheReference()) {
                    this.m_readTimeoutSeconds = entityDescriptorBean.getEntityCacheRef().getReadTimeoutSeconds();
                    bl = ((DescriptorBean)entityDescriptorBean.getEntityCacheRef()).isSet("ReadTimeoutSeconds");
                } else {
                    this.m_readTimeoutSeconds = entityDescriptorBean.getEntityCache().getReadTimeoutSeconds();
                    bl = ((DescriptorBean)entityDescriptorBean.getEntityCache()).isSet("ReadTimeoutSeconds");
                }
                if (this.getCacheBetweenTransactions() && !bl) {
                    this.m_readTimeoutSeconds = 0;
                }
            }
        }
        return this.m_readTimeoutSeconds;
    }

    public String getCacheType() {
        String string = "";
        if (this.isStatefulSession()) {
            string = this.m_wlBean.getStatefulSessionDescriptor().getStatefulSessionCache().getCacheType();
        }
        return string;
    }

    public int getMaxBeansInFreePool() {
        if (this.isStatelessSession()) {
            return this.m_wlBean.getStatelessSessionDescriptor().getPool().getMaxBeansInFreePool();
        }
        if (this.isEntity()) {
            return this.m_wlBean.getEntityDescriptor().getPool().getMaxBeansInFreePool();
        }
        if (this.isMessageDriven()) {
            return this.m_wlBean.getMessageDrivenDescriptor().getPool().getMaxBeansInFreePool();
        }
        return 0;
    }

    public void setMaxBeansInFreePool(int n) {
        if (this.isStatelessSession()) {
            Debug.assertion((null != this.m_wlBean.getStatelessSessionDescriptor() ? 1 : 0) != 0);
            Debug.assertion((null != this.m_wlBean.getStatelessSessionDescriptor().getPool() ? 1 : 0) != 0);
            this.m_wlBean.getStatelessSessionDescriptor().getPool().setMaxBeansInFreePool(n);
        } else if (this.isEntity()) {
            Debug.assertion((null != this.m_wlBean.getEntityDescriptor() ? 1 : 0) != 0);
            Debug.assertion((null != this.m_wlBean.getEntityDescriptor().getPool() ? 1 : 0) != 0);
            this.m_wlBean.getEntityDescriptor().getPool().setMaxBeansInFreePool(n);
        } else if (this.isMessageDriven()) {
            this.m_wlBean.getMessageDrivenDescriptor().getPool().setMaxBeansInFreePool(n);
        }
    }

    public int getInitialBeansInFreePool() {
        if (this.isStatelessSession()) {
            return this.m_wlBean.getStatelessSessionDescriptor().getPool().getInitialBeansInFreePool();
        }
        if (this.isEntity()) {
            return this.m_wlBean.getEntityDescriptor().getPool().getInitialBeansInFreePool();
        }
        if (this.isMessageDriven()) {
            return this.m_wlBean.getMessageDrivenDescriptor().getPool().getInitialBeansInFreePool();
        }
        return 0;
    }

    public int getMaxBeansInCache() {
        if (this.isEntity() && !this.hasEntityCacheReference()) {
            return this.m_wlBean.getEntityDescriptor().getEntityCache().getMaxBeansInCache();
        }
        if (this.isStatefulSession()) {
            return this.m_wlBean.getStatefulSessionDescriptor().getStatefulSessionCache().getMaxBeansInCache();
        }
        return -1;
    }

    public void setMaxBeansInCache(int n) {
        if (this.isEntity()) {
            this.m_wlBean.getEntityDescriptor().getEntityCache().setMaxBeansInCache(n);
        } else if (this.isStatefulSession()) {
            Debug.assertion((null != this.m_wlBean.getStatefulSessionDescriptor() ? 1 : 0) != 0);
            Debug.assertion((null != this.m_wlBean.getStatefulSessionDescriptor().getStatefulSessionCache() ? 1 : 0) != 0);
            this.m_wlBean.getStatefulSessionDescriptor().getStatefulSessionCache().setMaxBeansInCache(n);
        }
    }

    public int getMaxQueriesInCache() {
        if (this.isEntity() && !this.hasEntityCacheReference()) {
            int n = this.m_wlBean.getEntityDescriptor().getEntityCache().getMaxQueriesInCache();
            return n;
        }
        return -1;
    }

    public String getConcurrencyStrategy() {
        String string = null;
        if (this.isEntity()) {
            string = this.hasEntityCacheReference() ? this.m_wlBean.getEntityDescriptor().getEntityCacheRef().getConcurrencyStrategy() : this.m_wlBean.getEntityDescriptor().getEntityCache().getConcurrencyStrategy();
        }
        return string;
    }

    public CachingDescriptor getCachingDescriptor() {
        CachingDescriptorImpl cachingDescriptorImpl = new CachingDescriptorImpl();
        cachingDescriptorImpl.setMaxBeansInCache(this.getMaxBeansInCache());
        cachingDescriptorImpl.setMaxQueriesInCache(this.getMaxQueriesInCache());
        cachingDescriptorImpl.setMaxBeansInFreePool(this.getMaxBeansInFreePool());
        cachingDescriptorImpl.setInitialBeansInFreePool(this.getInitialBeansInFreePool());
        cachingDescriptorImpl.setIdleTimeoutSecondsCache(this.getIdleTimeoutSecondsCache());
        cachingDescriptorImpl.setIdleTimeoutSecondsPool(this.getIdleTimeoutSecondsPool());
        cachingDescriptorImpl.setCacheType(this.getCacheType());
        cachingDescriptorImpl.setReadTimeoutSeconds(this.getReadTimeoutSeconds());
        cachingDescriptorImpl.setConcurrencyStrategy(this.getConcurrencyStrategy());
        return cachingDescriptorImpl;
    }

    public IIOPSecurityDescriptor getIIOPSecurityDescriptor() {
        IIOPSecurityDescriptorImpl iIOPSecurityDescriptorImpl = new IIOPSecurityDescriptorImpl();
        if (this.m_wlBean.getIiopSecurityDescriptor() == null) {
            return iIOPSecurityDescriptorImpl;
        }
        if (this.m_wlBean.getIiopSecurityDescriptor().getTransportRequirements() != null) {
            iIOPSecurityDescriptorImpl.setTransport_integrity(this.m_wlBean.getIiopSecurityDescriptor().getTransportRequirements().getIntegrity());
            iIOPSecurityDescriptorImpl.setTransport_confidentiality(this.m_wlBean.getIiopSecurityDescriptor().getTransportRequirements().getConfidentiality());
            iIOPSecurityDescriptorImpl.setTransport_client_cert_authentication(this.m_wlBean.getIiopSecurityDescriptor().getTransportRequirements().getClientCertAuthentication());
        }
        iIOPSecurityDescriptorImpl.setClient_authentication(this.m_wlBean.getIiopSecurityDescriptor().getClientAuthentication());
        iIOPSecurityDescriptorImpl.setIdentity_assertion(this.m_wlBean.getIiopSecurityDescriptor().getIdentityAssertion());
        return iIOPSecurityDescriptorImpl;
    }

    public boolean hasEntityCacheReference() {
        if (verbose) {
            Debug.say((String)("called hasEntityCacheReference ejb- " + this.m_wlBean.getEjbName() + " value- " + (this.m_wlBean.getEntityDescriptor().getEntityCacheRef() != null)));
        }
        return this.m_wlBean.getEntityDescriptor().getEntityCacheRef() != null;
    }

    public String getEntityCacheName() {
        EntityCacheRefBean entityCacheRefBean = this.m_wlBean.getEntityDescriptor().getEntityCacheRef();
        if (debug) {
            Debug.assertion((entityCacheRefBean != null ? 1 : 0) != 0);
        }
        return entityCacheRefBean.getEntityCacheName();
    }

    public int getEstimatedBeanSize() {
        EntityCacheRefBean entityCacheRefBean = this.m_wlBean.getEntityDescriptor().getEntityCacheRef();
        if (debug) {
            Debug.assertion((entityCacheRefBean != null ? 1 : 0) != 0);
        }
        return entityCacheRefBean.getEstimatedBeanSize();
    }

    private String getHomeLoadAlgorithm() {
        String string = "";
        if (this.isEntity()) {
            Debug.assertion((null != this.m_wlBean.getEntityDescriptor() ? 1 : 0) != 0);
            Debug.assertion((null != this.m_wlBean.getEntityDescriptor().getEntityClustering() ? 1 : 0) != 0);
            string = this.m_wlBean.getEntityDescriptor().getEntityClustering().getHomeLoadAlgorithm();
        } else if (this.isStatefulSession()) {
            Debug.assertion((null != this.m_wlBean ? 1 : 0) != 0);
            Debug.assertion((null != this.m_wlBean.getStatefulSessionDescriptor() ? 1 : 0) != 0);
            Debug.assertion((null != this.m_wlBean.getStatefulSessionDescriptor().getStatefulSessionClustering() ? 1 : 0) != 0);
            string = this.m_wlBean.getStatefulSessionDescriptor().getStatefulSessionClustering().getHomeLoadAlgorithm();
        } else if (this.isStatelessSession()) {
            Debug.assertion((null != this.m_wlBean ? 1 : 0) != 0);
            Debug.assertion((null != this.m_wlBean.getStatelessSessionDescriptor() ? 1 : 0) != 0);
            Debug.assertion((null != this.m_wlBean.getStatelessSessionDescriptor().getStatelessClustering() ? 1 : 0) != 0);
            string = this.m_wlBean.getStatelessSessionDescriptor().getStatelessClustering().getHomeLoadAlgorithm();
        } else {
            throw new AssertionError("HomeLoadAlgorithm should only be for Entity or Stateful Session");
        }
        return string;
    }

    public void setHomeLoadAlgorithm(String string) {
        String string2 = "";
        if (this.isEntity()) {
            this.m_wlBean.getEntityDescriptor().getEntityClustering().setHomeLoadAlgorithm(string);
        } else if (this.isStatefulSession()) {
            this.m_wlBean.getStatefulSessionDescriptor().getStatefulSessionClustering().setHomeLoadAlgorithm(string);
        } else if (this.isStatelessSession()) {
            this.m_wlBean.getStatelessSessionDescriptor().getStatelessClustering().setHomeLoadAlgorithm(string);
        } else {
            throw new AssertionError("HomeLoadAlgorithm should only be for Entity or Stateful Session");
        }
    }

    public boolean getHomeIsClusterable() {
        if (this.isEntity()) {
            return this.m_wlBean.getEntityDescriptor().getEntityClustering().isHomeIsClusterable();
        }
        if (this.isStatefulSession()) {
            return this.m_wlBean.getStatefulSessionDescriptor().getStatefulSessionClustering().isHomeIsClusterable();
        }
        if (this.isStatelessSession()) {
            return this.m_wlBean.getStatelessSessionDescriptor().getStatelessClustering().isHomeIsClusterable();
        }
        throw new AssertionError("HomeIsClusterable should only be for Entity or Stateful Session");
    }

    public boolean getUseServersideStubs() {
        if (this.isEntity()) {
            return this.m_wlBean.getEntityDescriptor().getEntityClustering().isUseServersideStubs();
        }
        if (this.isStatefulSession()) {
            return this.m_wlBean.getStatefulSessionDescriptor().getStatefulSessionClustering().isUseServersideStubs();
        }
        if (this.isStatelessSession()) {
            return this.m_wlBean.getStatelessSessionDescriptor().getStatelessClustering().isUseServersideStubs();
        }
        return false;
    }

    public void setHomeIsClusterable(boolean bl) {
        if (this.isEntity()) {
            this.m_wlBean.getEntityDescriptor().getEntityClustering().setHomeIsClusterable(bl);
        } else if (this.isStatefulSession()) {
            this.m_wlBean.getStatefulSessionDescriptor().getStatefulSessionClustering().setHomeIsClusterable(bl);
        } else if (this.isStatelessSession()) {
            this.m_wlBean.getStatelessSessionDescriptor().getStatelessClustering().setHomeIsClusterable(bl);
        }
    }

    private String getHomeCallRouterClassName() {
        String string = "";
        if (this.isEntity()) {
            string = this.m_wlBean.getEntityDescriptor().getEntityClustering().getHomeCallRouterClassName();
        } else if (this.isStatefulSession()) {
            string = this.m_wlBean.getStatefulSessionDescriptor().getStatefulSessionClustering().getHomeCallRouterClassName();
        } else if (this.isStatelessSession()) {
            string = this.m_wlBean.getStatelessSessionDescriptor().getStatelessClustering().getHomeCallRouterClassName();
        } else {
            throw new AssertionError("HomeCallRouterClassName should only be for Entity or Stateful Session");
        }
        return string;
    }

    public void setHomeCallRouterClassName(String string) {
        if (this.isEntity()) {
            this.m_wlBean.getEntityDescriptor().getEntityClustering().setHomeCallRouterClassName(string);
        } else if (this.isStatefulSession()) {
            this.m_wlBean.getStatefulSessionDescriptor().getStatefulSessionClustering().setHomeCallRouterClassName(string);
        } else if (this.isStatelessSession()) {
            this.m_wlBean.getStatelessSessionDescriptor().getStatelessClustering().setHomeCallRouterClassName(string);
        } else {
            throw new AssertionError("HomeCallRouterClassName should only be for Entity or Stateful Session");
        }
    }

    private boolean getStatelessBeanIsClusterable() {
        if (this.isStatelessSession()) {
            return this.m_wlBean.getStatelessSessionDescriptor().getStatelessClustering().isStatelessBeanIsClusterable();
        }
        throw new AssertionError("StatelessBeanIsClusterable should only be for Statless");
    }

    public void setStatelessBeanIsClusterable(boolean bl) {
        if (!this.isStatelessSession()) {
            throw new AssertionError("StatelessBeanIsClusterable should only be for Statless");
        }
        this.m_wlBean.getStatelessSessionDescriptor().getStatelessClustering().setStatelessBeanIsClusterable(bl);
    }

    private String getStatelessBeanLoadAlgorithm() {
        String string = "";
        if (!this.isStatelessSession()) {
            throw new AssertionError("StatelessBeanLoadAlgorithm should only be for Statless");
        }
        string = this.m_wlBean.getStatelessSessionDescriptor().getStatelessClustering().getStatelessBeanLoadAlgorithm();
        return string;
    }

    public void setStatelessBeanLoadAlgorithm(String string) {
        if (!this.isStatelessSession()) {
            throw new AssertionError("StatelessBeanLoadAlgorithm should only be for Statless");
        }
        this.m_wlBean.getStatelessSessionDescriptor().getStatelessClustering().setStatelessBeanLoadAlgorithm(string);
    }

    private String getStatelessBeanCallRouterClassName() {
        String string = "";
        if (!this.isStatelessSession()) {
            throw new AssertionError("StatelessBeanCallRouterClassName should only be for Statless");
        }
        string = this.m_wlBean.getStatelessSessionDescriptor().getStatelessClustering().getStatelessBeanCallRouterClassName();
        return string;
    }

    public void setStatelessBeanCallRouterClassName(String string) {
        if (!this.isStatelessSession()) {
            throw new AssertionError("StatelessBeanCallRouterClassName should only be for Stateless");
        }
        this.m_wlBean.getStatelessSessionDescriptor().getStatelessClustering().setStatelessBeanCallRouterClassName(string);
    }

    public ClusteringDescriptor getClusteringDescriptor() {
        ClusteringDescriptor clusteringDescriptor = new ClusteringDescriptor();
        if (this.isJNDINameDefined()) {
            if (this.isEntity() || this.isStatefulSession() || this.isStatelessSession()) {
                clusteringDescriptor.setHomeLoadAlgorithm(this.getHomeLoadAlgorithm());
                clusteringDescriptor.setHomeIsClusterable(this.getHomeIsClusterable());
                clusteringDescriptor.setHomeCallRouterClassName(this.getHomeCallRouterClassName());
                clusteringDescriptor.setUseServersideStubs(this.getUseServersideStubs());
            }
            if (this.isStatelessSession()) {
                clusteringDescriptor.setStatelessBeanIsClusterable(this.getStatelessBeanIsClusterable());
                clusteringDescriptor.setStatelessBeanLoadAlgorithm(this.getStatelessBeanLoadAlgorithm());
                clusteringDescriptor.setStatelessBeanCallRouterClassName(this.getStatelessBeanCallRouterClassName());
            }
        } else {
            clusteringDescriptor.setHomeIsClusterable(false);
            clusteringDescriptor.setStatelessBeanIsClusterable(false);
        }
        return clusteringDescriptor;
    }

    public boolean isEntity() {
        return 3 == this.m_type;
    }

    public boolean isStatefulSession() {
        return 2 == this.m_type;
    }

    public boolean isStatelessSession() {
        return 1 == this.m_type;
    }

    public boolean isSession() {
        return 1 == this.m_type || 2 == this.m_type;
    }

    public boolean isMessageDriven() {
        return 4 == this.m_type;
    }

    public String getResourceJNDIName(String string) {
        ResourceDescriptionBean[] resourceDescriptionBeanArray = this.m_wlBean.getResourceDescriptions();
        if (resourceDescriptionBeanArray == null) {
            return null;
        }
        for (int i = 0; i < resourceDescriptionBeanArray.length; ++i) {
            if (!string.equals(resourceDescriptionBeanArray[i].getResRefName())) continue;
            return resourceDescriptionBeanArray[i].getJNDIName();
        }
        return null;
    }

    public static Map getAllEJBReferenceJNDINames(WeblogicEnterpriseBeanBean weblogicEnterpriseBeanBean, EnterpriseBeanBean enterpriseBeanBean) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashSet<String> hashSet = new HashSet<String>();
        EjbRefBean[] ejbRefBeanArray = enterpriseBeanBean.getEjbRefs();
        for (int i = 0; i < ejbRefBeanArray.length; ++i) {
            hashSet.add(ejbRefBeanArray[i].getEjbRefName());
        }
        EjbReferenceDescriptionBean[] ejbReferenceDescriptionBeanArray = weblogicEnterpriseBeanBean.getEjbReferenceDescriptions();
        if (null != ejbReferenceDescriptionBeanArray) {
            for (int i = 0; i < ejbReferenceDescriptionBeanArray.length; ++i) {
                if (!hashSet.contains(ejbReferenceDescriptionBeanArray[i].getEjbRefName())) continue;
                hashMap.put(ejbReferenceDescriptionBeanArray[i].getEjbRefName(), ejbReferenceDescriptionBeanArray[i].getJNDIName());
            }
        }
        return hashMap;
    }

    public Map getAllEJBReferenceJNDINames() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        EjbReferenceDescriptionBean[] ejbReferenceDescriptionBeanArray = this.m_wlBean.getEjbReferenceDescriptions();
        if (null != ejbReferenceDescriptionBeanArray) {
            for (int i = 0; i < ejbReferenceDescriptionBeanArray.length; ++i) {
                if (!this.m_ejbReferences.containsKey(ejbReferenceDescriptionBeanArray[i].getEjbRefName()) || ((EjbRefBean)this.m_ejbReferences.get(ejbReferenceDescriptionBeanArray[i].getEjbRefName())).getHome() == null) continue;
                hashMap.put(ejbReferenceDescriptionBeanArray[i].getEjbRefName(), ejbReferenceDescriptionBeanArray[i].getJNDIName());
            }
        }
        return hashMap;
    }

    public Map getAllEJBLocalReferenceJNDINames() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        EjbReferenceDescriptionBean[] ejbReferenceDescriptionBeanArray = this.m_wlBean.getEjbReferenceDescriptions();
        if (null != ejbReferenceDescriptionBeanArray) {
            for (int i = 0; i < ejbReferenceDescriptionBeanArray.length; ++i) {
                if (!this.m_ejbLocalReferences.containsKey(ejbReferenceDescriptionBeanArray[i].getEjbRefName()) || ((EjbLocalRefBean)this.m_ejbLocalReferences.get(ejbReferenceDescriptionBeanArray[i].getEjbRefName())).getLocalHome() == null) continue;
                hashMap.put(ejbReferenceDescriptionBeanArray[i].getEjbRefName(), ejbReferenceDescriptionBeanArray[i].getJNDIName());
            }
        }
        return hashMap;
    }

    public String resolveResourceLink(String string, String string2) {
        return "weblogic." + string + "." + string2;
    }

    public Map getAllResourceReferenceJNDINames(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ResourceDescriptionBean[] resourceDescriptionBeanArray = this.m_wlBean.getResourceDescriptions();
        if (null != resourceDescriptionBeanArray) {
            for (int i = 0; i < resourceDescriptionBeanArray.length; ++i) {
                String string2;
                String string3 = resourceDescriptionBeanArray[i].getJNDIName();
                if (string != null && (string3 == null || string3.length() <= 0) && (string2 = resourceDescriptionBeanArray[i].getResourceLink()) != null && string2.length() > 0) {
                    string3 = this.resolveResourceLink(string, string2);
                }
                hashMap.put(resourceDescriptionBeanArray[i].getResRefName(), string3);
            }
        }
        return hashMap;
    }

    public Map getAllResourceEnvReferenceJNDINames(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ResourceEnvDescriptionBean[] resourceEnvDescriptionBeanArray = this.m_wlBean.getResourceEnvDescriptions();
        if (null != resourceEnvDescriptionBeanArray) {
            for (int i = 0; i < resourceEnvDescriptionBeanArray.length; ++i) {
                String string2;
                String string3 = resourceEnvDescriptionBeanArray[i].getJNDIName();
                if (string != null && (string3 == null || string3.length() <= 0) && (string2 = resourceEnvDescriptionBeanArray[i].getResourceLink()) != null && string2.length() > 0) {
                    string3 = this.resolveResourceLink(string, string2);
                }
                hashMap.put(resourceEnvDescriptionBeanArray[i].getResourceEnvRefName(), string3);
            }
        }
        return hashMap;
    }

    private RunAsBean getRunAsMBean() {
        RunAsBean runAsBean = null;
        SecurityIdentityBean securityIdentityBean = null;
        if (this.isEntity()) {
            securityIdentityBean = ((EntityBeanBean)this.m_bean).getSecurityIdentity();
        } else if (this.isSession()) {
            securityIdentityBean = ((SessionBeanBean)this.m_bean).getSecurityIdentity();
        } else if (this.isMessageDriven()) {
            securityIdentityBean = ((MessageDrivenBeanBean)this.m_bean).getSecurityIdentity();
        }
        if (securityIdentityBean != null) {
            runAsBean = securityIdentityBean.getRunAs();
        }
        return runAsBean;
    }

    public String getRunAsRoleName() {
        String string = null;
        RunAsBean runAsBean = this.getRunAsMBean();
        if (runAsBean != null) {
            string = runAsBean.getRoleName();
        }
        return string;
    }

    public String getRunAsIdentityPrincipal() {
        return this.m_wlBean.getRunAsPrincipalName();
    }

    public String getCreateAsPrincipalName() {
        return this.m_wlBean.getCreateAsPrincipalName();
    }

    public String getRemoveAsPrincipalName() {
        return this.m_wlBean.getRemoveAsPrincipalName();
    }

    public String getPassivateAsPrincipalName() {
        return this.m_wlBean.getPassivateAsPrincipalName();
    }

    public NamedMethodBean getTimeoutMethod() {
        if (this.isSession()) {
            return ((SessionBeanBean)this.m_bean).getTimeoutMethod();
        }
        if (this.isMessageDriven()) {
            return ((MessageDrivenBeanBean)this.m_bean).getTimeoutMethod();
        }
        return null;
    }

    public String getTimerStoreName() {
        TimerDescriptorBean timerDescriptorBean = null;
        if (this.isEntity()) {
            timerDescriptorBean = this.m_wlBean.getEntityDescriptor().getTimerDescriptor();
        } else if (this.isMessageDriven()) {
            timerDescriptorBean = this.m_wlBean.getMessageDrivenDescriptor().getTimerDescriptor();
        } else if (this.isStatelessSession()) {
            timerDescriptorBean = this.m_wlBean.getStatelessSessionDescriptor().getTimerDescriptor();
        }
        if (timerDescriptorBean == null) {
            return null;
        }
        return timerDescriptorBean.getPersistentStoreLogicalName();
    }

    private static void p(String string) {
        Debug.say((String)("@@@ " + string));
    }

    private static WeblogicEnterpriseBeanBean findWl60Bean(String string, WeblogicEnterpriseBeanBean[] weblogicEnterpriseBeanBeanArray) {
        for (int i = 0; i < weblogicEnterpriseBeanBeanArray.length; ++i) {
            if (!string.equals(weblogicEnterpriseBeanBeanArray[i].getEjbName())) continue;
            return weblogicEnterpriseBeanBeanArray[i];
        }
        return null;
    }

    public static EnterpriseBeanBean[] getEnterpriseBeans(EjbJarBean ejbJarBean) {
        return CompositeMBeanDescriptor.getEnterpriseBeans(ejbJarBean.getEnterpriseBeans());
    }

    public static EnterpriseBeanBean[] getEnterpriseBeans(EnterpriseBeansBean enterpriseBeansBean) {
        int n;
        SessionBeanBean[] sessionBeanBeanArray = enterpriseBeansBean.getSessions();
        EntityBeanBean[] entityBeanBeanArray = enterpriseBeansBean.getEntities();
        MessageDrivenBeanBean[] messageDrivenBeanBeanArray = enterpriseBeansBean.getMessageDrivens();
        EnterpriseBeanBean[] enterpriseBeanBeanArray = new EnterpriseBeanBean[sessionBeanBeanArray.length + entityBeanBeanArray.length + messageDrivenBeanBeanArray.length];
        int n2 = 0;
        for (n2 = 0; n2 < sessionBeanBeanArray.length; ++n2) {
            enterpriseBeanBeanArray[n2] = sessionBeanBeanArray[n2];
        }
        for (n = 0; n < entityBeanBeanArray.length; ++n) {
            enterpriseBeanBeanArray[n2++] = entityBeanBeanArray[n];
        }
        for (n = 0; n < messageDrivenBeanBeanArray.length; ++n) {
            enterpriseBeanBeanArray[n2++] = messageDrivenBeanBeanArray[n];
        }
        return enterpriseBeanBeanArray;
    }

    public static void completeBeans(EjbDescriptorBean ejbDescriptorBean) throws WLDeploymentException {
        EnterpriseBeanBean[] enterpriseBeanBeanArray;
        if (null == ejbDescriptorBean.getEjbJarBean()) {
            enterpriseBeanBeanArray = ejbDescriptorBean.createEjbJarBean();
            enterpriseBeanBeanArray.createEnterpriseBeans();
        }
        if (null == ejbDescriptorBean.getWeblogicEjbJarBean()) {
            ejbDescriptorBean.createWeblogicEjbJarBean();
        }
        enterpriseBeanBeanArray = CompositeMBeanDescriptor.getEnterpriseBeans(ejbDescriptorBean.getEjbJarBean());
        for (int i = 0; i < enterpriseBeanBeanArray.length; ++i) {
            EJBComplianceTextFormatter eJBComplianceTextFormatter;
            Debug.assertion((null != ejbDescriptorBean.getWeblogicEjbJarBean() ? 1 : 0) != 0);
            EnterpriseBeanBean enterpriseBeanBean = enterpriseBeanBeanArray[i];
            WeblogicEnterpriseBeanBean weblogicEnterpriseBeanBean = CompositeMBeanDescriptor.findWl60Bean(enterpriseBeanBean.getEjbName(), ejbDescriptorBean.getWeblogicEjbJarBean().getWeblogicEnterpriseBeans());
            if (weblogicEnterpriseBeanBean == null) {
                eJBComplianceTextFormatter = new EJBComplianceTextFormatter();
                throw new WLDeploymentException(eJBComplianceTextFormatter.CANNOT_FIND_WL_DESCRIPTOR_FOR_EJB(enterpriseBeanBean.getEjbName()));
            }
            if (enterpriseBeanBean instanceof EntityBeanBean) {
                eJBComplianceTextFormatter = weblogicEnterpriseBeanBean.getEntityDescriptor();
                if (null == eJBComplianceTextFormatter) {
                    eJBComplianceTextFormatter = weblogicEnterpriseBeanBean.createEntityDescriptor();
                }
                if (null == eJBComplianceTextFormatter.getEntityCache() && null == eJBComplianceTextFormatter.getEntityCacheRef()) {
                    eJBComplianceTextFormatter.createEntityCache();
                }
                if (null == eJBComplianceTextFormatter.getPersistence()) {
                    eJBComplianceTextFormatter.createPersistence();
                }
                if (null == eJBComplianceTextFormatter.getEntityClustering()) {
                    eJBComplianceTextFormatter.createEntityClustering();
                }
                if (null == eJBComplianceTextFormatter.getPool()) {
                    eJBComplianceTextFormatter.createPool();
                }
            } else if (enterpriseBeanBean instanceof SessionBeanBean && "stateless".equalsIgnoreCase(((SessionBeanBean)enterpriseBeanBean).getSessionType())) {
                eJBComplianceTextFormatter = weblogicEnterpriseBeanBean.getStatelessSessionDescriptor();
                if (null == eJBComplianceTextFormatter) {
                    eJBComplianceTextFormatter = weblogicEnterpriseBeanBean.createStatelessSessionDescriptor();
                }
                if (null == eJBComplianceTextFormatter.getPool()) {
                    eJBComplianceTextFormatter.createPool();
                }
                if (null == eJBComplianceTextFormatter.getStatelessClustering()) {
                    eJBComplianceTextFormatter.createStatelessClustering();
                }
            } else if (enterpriseBeanBean instanceof SessionBeanBean && "stateful".equalsIgnoreCase(((SessionBeanBean)enterpriseBeanBean).getSessionType())) {
                eJBComplianceTextFormatter = weblogicEnterpriseBeanBean.getStatefulSessionDescriptor();
                if (null == eJBComplianceTextFormatter) {
                    eJBComplianceTextFormatter = weblogicEnterpriseBeanBean.createStatefulSessionDescriptor();
                }
                if (null == eJBComplianceTextFormatter.getStatefulSessionCache()) {
                    eJBComplianceTextFormatter.createStatefulSessionCache();
                }
                if (null == eJBComplianceTextFormatter.getStatefulSessionClustering()) {
                    eJBComplianceTextFormatter.createStatefulSessionClustering();
                }
                Debug.assertion((null != eJBComplianceTextFormatter.getStatefulSessionClustering() ? 1 : 0) != 0);
            } else {
                eJBComplianceTextFormatter = weblogicEnterpriseBeanBean.getMessageDrivenDescriptor();
                if (null == eJBComplianceTextFormatter) {
                    eJBComplianceTextFormatter = weblogicEnterpriseBeanBean.createMessageDrivenDescriptor();
                }
            }
            if (weblogicEnterpriseBeanBean.getTransactionDescriptor() != null) continue;
            weblogicEnterpriseBeanBean.createTransactionDescriptor();
        }
    }

    public boolean getEntityAlwaysUsesTransaction() {
        if (null == this.m_ejbDesc.getWeblogicEjbJarBean()) {
            return false;
        }
        return this.m_ejbDesc.getWeblogicEjbJarBean().getWeblogicCompatibility().isEntityAlwaysUsesTransaction();
    }

    public void setEJBName(String string) {
        this.m_bean.setEjbName(string);
        this.m_wlBean.setEjbName(string);
        if (null != this.m_rdbmsBean) {
            this.m_rdbmsBean.setEjbName(string);
        }
    }

    public void setJNDIName(String string) {
        this.m_wlBean.setJNDIName(string);
    }

    public boolean isBeanManagedPersistence() {
        EntityBeanBean entityBeanBean = (EntityBeanBean)this.m_bean;
        return "bean".equalsIgnoreCase(entityBeanBean.getPersistenceType());
    }

    public boolean getCacheBetweenTransactions() {
        if (this.hasEntityCacheReference()) {
            EntityCacheRefBean entityCacheRefBean = this.m_wlBean.getEntityDescriptor().getEntityCacheRef();
            if (debug) {
                Debug.assertion((entityCacheRefBean != null ? 1 : 0) != 0);
            }
            return entityCacheRefBean.isCacheBetweenTransactions();
        }
        EntityCacheBean entityCacheBean = this.m_wlBean.getEntityDescriptor().getEntityCache();
        if (debug) {
            Debug.assertion((entityCacheBean != null ? 1 : 0) != 0);
        }
        PersistenceBean persistenceBean = this.m_wlBean.getEntityDescriptor().getPersistence();
        if (debug) {
            Debug.assertion((persistenceBean != null ? 1 : 0) != 0);
        }
        return entityCacheBean.isCacheBetweenTransactions();
    }

    public boolean getDisableReadyIntances() {
        if (!this.hasEntityCacheReference()) {
            EntityCacheBean entityCacheBean = this.m_wlBean.getEntityDescriptor().getEntityCache();
            if (debug) {
                Debug.assertion((entityCacheBean != null ? 1 : 0) != 0);
            }
            PersistenceBean persistenceBean = this.m_wlBean.getEntityDescriptor().getPersistence();
            if (debug) {
                Debug.assertion((persistenceBean != null ? 1 : 0) != 0);
            }
            return entityCacheBean.isDisableReadyInstances();
        }
        return false;
    }

    public String getIsModifiedMethodName() {
        return this.m_wlBean.getEntityDescriptor().getPersistence().getIsModifiedMethodName();
    }

    public boolean getDelayUpdatesUntilEndOfTx() {
        return this.m_wlBean.getEntityDescriptor().getPersistence().isDelayUpdatesUntilEndOfTx();
    }

    public String getPersistenceUseIdentifier() {
        PersistenceUseBean persistenceUseBean;
        PersistenceBean persistenceBean = this.m_wlBean.getEntityDescriptor().getPersistence();
        if (persistenceBean != null && (persistenceUseBean = persistenceBean.getPersistenceUse()) != null) {
            return persistenceUseBean.getTypeIdentifier();
        }
        return null;
    }

    public String getPersistenceUseVersion() {
        PersistenceUseBean persistenceUseBean;
        PersistenceBean persistenceBean = this.m_wlBean.getEntityDescriptor().getPersistence();
        if (persistenceBean != null && (persistenceUseBean = persistenceBean.getPersistenceUse()) != null) {
            return persistenceUseBean.getTypeVersion();
        }
        return null;
    }

    public String getPersistenceUseStorage() {
        PersistenceUseBean persistenceUseBean;
        PersistenceBean persistenceBean = this.m_wlBean.getEntityDescriptor().getPersistence();
        if (persistenceBean != null && (persistenceUseBean = persistenceBean.getPersistenceUse()) != null) {
            return persistenceUseBean.getTypeStorage();
        }
        return null;
    }

    public boolean getFindersLoadBean() {
        return this.m_wlBean.getEntityDescriptor().getPersistence().isFindersLoadBean();
    }

    public EnvEntryBean createEnvironmentEntry() {
        return this.m_bean.createEnvEntry();
    }

    public String getInvalidationTargetEJBName() {
        InvalidationTargetBean invalidationTargetBean = this.m_wlBean.getEntityDescriptor().getInvalidationTarget();
        if (invalidationTargetBean == null) {
            return null;
        }
        return invalidationTargetBean.getEjbName();
    }

    public boolean isDynamicQueriesEnabled() {
        if (this.m_wlBean.getEntityDescriptor() != null) {
            return this.m_wlBean.getEntityDescriptor().isEnableDynamicQueries();
        }
        return false;
    }

    public boolean isClusteredTimers() {
        String string = this.m_ejbDesc.getWeblogicEjbJarBean().getTimerImplementation();
        return "Clustered".equals(string);
    }

    private static void ppp(String string) {
        System.out.println("[CompositeMBeanDescriptor] " + string);
    }

    public static EnterpriseBeanBean findEJB(String string, EjbDescriptorBean ejbDescriptorBean) {
        return CompositeMBeanDescriptor.findEJB(string, ejbDescriptorBean.getEjbJarBean());
    }

    public static EnterpriseBeanBean findEJB(String string, EjbJarBean ejbJarBean) {
        EnterpriseBeanBean[] enterpriseBeanBeanArray = CompositeMBeanDescriptor.getEnterpriseBeans(ejbJarBean);
        for (int i = 0; i < enterpriseBeanBeanArray.length; ++i) {
            if (!enterpriseBeanBeanArray[i].getEjbName().equals(string)) continue;
            return enterpriseBeanBeanArray[i];
        }
        return null;
    }

    private void initializeEJBReferences() throws WLDeploymentException {
        this.m_ejbReferences = new HashMap();
        EjbRefBean[] ejbRefBeanArray = this.m_bean.getEjbRefs();
        for (int i = 0; i < ejbRefBeanArray.length; ++i) {
            if (this.m_ejbReferences.containsKey(ejbRefBeanArray[i].getEjbRefName())) {
                EJBComplianceTextFormatter eJBComplianceTextFormatter = new EJBComplianceTextFormatter();
                throw new WLDeploymentException(eJBComplianceTextFormatter.noDuplicateEjbRefNamesAllowed(this.getEJBName(), ejbRefBeanArray[i].getEjbRefName()));
            }
            this.m_ejbReferences.put(ejbRefBeanArray[i].getEjbRefName(), ejbRefBeanArray[i]);
        }
    }

    private void initializeEJBLocalReferences() throws WLDeploymentException {
        this.m_ejbLocalReferences = new HashMap();
        EjbLocalRefBean[] ejbLocalRefBeanArray = this.m_bean.getEjbLocalRefs();
        for (int i = 0; i < ejbLocalRefBeanArray.length; ++i) {
            if (this.m_ejbLocalReferences.containsKey(ejbLocalRefBeanArray[i].getEjbRefName())) {
                EJBComplianceTextFormatter eJBComplianceTextFormatter = new EJBComplianceTextFormatter();
                throw new WLDeploymentException(eJBComplianceTextFormatter.noDuplicateEjbRefNamesAllowed(this.getEJBName(), ejbLocalRefBeanArray[i].getEjbRefName()));
            }
            this.m_ejbLocalReferences.put(ejbLocalRefBeanArray[i].getEjbRefName(), ejbLocalRefBeanArray[i]);
        }
    }

    private void initializeServiceReferences() throws WLDeploymentException {
        this.m_allServiceReferences = new HashMap();
        ServiceRefBean[] serviceRefBeanArray = this.m_bean.getServiceRefs();
        for (int i = 0; i < serviceRefBeanArray.length; ++i) {
            if (this.m_allServiceReferences.containsKey(serviceRefBeanArray[i].getServiceRefName())) {
                EJBComplianceTextFormatter eJBComplianceTextFormatter = new EJBComplianceTextFormatter();
                throw new WLDeploymentException(eJBComplianceTextFormatter.noDuplicateServiceRefNamesAllowed(this.getEJBName(), serviceRefBeanArray[i].getServiceRefName()));
            }
            this.m_allServiceReferences.put(serviceRefBeanArray[i].getServiceRefName(), serviceRefBeanArray[i]);
        }
    }

    private void initializeServiceReferenceDescriptions() throws WLDeploymentException {
        this.m_allServiceReferenceDescriptions = new HashMap();
        ServiceReferenceDescriptionBean[] serviceReferenceDescriptionBeanArray = this.m_wlBean.getServiceReferenceDescriptions();
        for (int i = 0; i < serviceReferenceDescriptionBeanArray.length; ++i) {
            if (this.m_allServiceReferenceDescriptions.containsKey(serviceReferenceDescriptionBeanArray[i].getServiceRefName())) {
                EJBComplianceTextFormatter eJBComplianceTextFormatter = new EJBComplianceTextFormatter();
                throw new WLDeploymentException(eJBComplianceTextFormatter.noDuplicateServiceReferenceDescriptionNamesAllowed(this.getEJBName(), serviceReferenceDescriptionBeanArray[i].getServiceRefName()));
            }
            if (!this.m_allServiceReferences.containsKey(serviceReferenceDescriptionBeanArray[i].getServiceRefName())) {
                EJBComplianceTextFormatter eJBComplianceTextFormatter = new EJBComplianceTextFormatter();
                throw new WLDeploymentException(eJBComplianceTextFormatter.noServiceRefForReferenceDescription(this.getEJBName(), serviceReferenceDescriptionBeanArray[i].getServiceRefName()));
            }
            this.m_allServiceReferenceDescriptions.put(serviceReferenceDescriptionBeanArray[i].getServiceRefName(), serviceReferenceDescriptionBeanArray[i]);
        }
    }
}

