/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.deployer;

import java.security.AccessController;
import javax.naming.NamingException;
import weblogic.application.ApplicationAccess;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.ModuleException;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.container.EJBDebugService;
import weblogic.ejb.container.deployer.EJBModule;
import weblogic.ejb.spi.EjbDescriptorBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;

public final class DynamicEJBModule
extends EJBModule
implements weblogic.ejb.spi.DynamicEJBModule {
    private static final DebugLogger debugLogger = EJBDebugService.deploymentLogger;
    private EjbDescriptorBean ejbDescriptor;
    private String ejbName;
    private static final int STATE_NEW = 1;
    private static final int STATE_INITIALIZED = 2;
    private static final int STATE_PREPARED = 4;
    private static final int STATE_ADMIN = 8;
    private static final int STATE_ACTIVE = 16;
    private int state = 1;
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public DynamicEJBModule(String string) {
        super(string + "_dynamic_internal");
    }

    public DynamicEJBModule(String string, ApplicationContextInternal applicationContextInternal) {
        super(string + "_dynamic_internal");
        this.appCtx = applicationContextInternal;
    }

    private static void debug(String string) {
        debugLogger.debug("[DynamicEJBModule] " + string);
    }

    private void pushRunAsSubject(AuthenticatedSubject authenticatedSubject) {
        if (debugLogger.isDebugEnabled()) {
            DynamicEJBModule.debug("pushRunAsSubject to push: '" + authenticatedSubject.toString() + "', currentSubject is: '" + this.getCurrentSubject() + "' ");
        }
        SecurityServiceManager.pushSubject((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)authenticatedSubject);
    }

    private void popRunAsSubject() {
        if (debugLogger.isDebugEnabled()) {
            DynamicEJBModule.debug("\n popRunAsSubject,  subject before pop is: '" + this.getCurrentSubject() + "'");
        }
        SecurityServiceManager.popSubject((AuthenticatedSubject)KERNEL_ID);
        if (debugLogger.isDebugEnabled()) {
            DynamicEJBModule.debug("\n popRunAsSubject,  subject after  pop is: '" + this.getCurrentSubject() + "'");
        }
    }

    private AuthenticatedSubject getCurrentSubject() {
        return SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)KERNEL_ID);
    }

    public void setEjbDescriptorBean(EjbDescriptorBean ejbDescriptorBean) {
        this.ejbDescriptor = ejbDescriptorBean;
    }

    protected EjbDescriptorBean loadEJBDescriptor() {
        return this.ejbDescriptor;
    }

    protected void setupPersistenceUnitRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deployDynamicEJB() {
        try {
            this.pushRunAsSubject(KERNEL_ID);
            this.init();
            this.state = 2;
            this.prepare();
            this.state = 4;
            this.activate();
        }
        catch (ModuleException moduleException) {
            DynamicEJBModule.debug("dynamic deployment of " + this.ejbName + " failed with exception: " + (Object)((Object)moduleException));
            if (debugLogger.isDebugEnabled()) {
                moduleException.getNestedException().printStackTrace();
            }
            this.undeployDynamicEJB();
            boolean bl = false;
            return bl;
        }
        finally {
            this.popRunAsSubject();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startDynamicEJB() {
        try {
            this.pushRunAsSubject(KERNEL_ID);
            this.start();
            this.state = 8;
            this.adminToProduction();
            this.state = 16;
        }
        catch (ModuleException moduleException) {
            DynamicEJBModule.debug("dynamic deployment of " + this.ejbName + " failed with exception: " + (Object)((Object)moduleException));
            if (debugLogger.isDebugEnabled()) {
                moduleException.getNestedException().printStackTrace();
            }
            this.undeployDynamicEJB();
            boolean bl = false;
            return bl;
        }
        finally {
            this.popRunAsSubject();
        }
        return true;
    }

    public void undeployDynamicEJB() {
        block8: {
            block7: {
                this.pushRunAsSubject(KERNEL_ID);
                if (this.state >= 16) {
                    this.forceProductionToAdmin();
                }
                if (this.state >= 8) {
                    try {
                        this.deactivate();
                    }
                    catch (ModuleException moduleException) {
                        if (!debugLogger.isDebugEnabled()) break block7;
                        DynamicEJBModule.debug("Ignoring " + (Object)((Object)moduleException));
                    }
                }
            }
            if (this.state >= 4) {
                try {
                    this.unprepare();
                }
                catch (ModuleException moduleException) {
                    if (!debugLogger.isDebugEnabled()) break block8;
                    DynamicEJBModule.debug("Ignoring " + (Object)((Object)moduleException));
                }
            }
        }
        this.state = 1;
        this.popRunAsSubject();
    }

    public void init() {
        if (this.appCtx == null) {
            this.appCtx = ApplicationAccess.getApplicationAccess().getCurrentApplicationContext();
        }
        try {
            this.appCtx.getEnvContext().createSubcontext("ejb");
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        this.classLoader = this.appCtx.getAppClassLoader();
    }
}

