/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.deployer;

import java.security.AccessController;
import weblogic.application.ApplicationFactoryManager;
import weblogic.ejb.container.EJBDebugService;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.deployer.EJBDeploymentFactory;
import weblogic.ejb.container.deployer.EJBModuleFactory;
import weblogic.ejb.container.monitoring.MessageDrivenControlEJBRuntimeMBeanImpl;
import weblogic.ejb.spi.EJBLibraryFactory;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ServerDebugMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.DomainAccess;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.DomainRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.ActivatedService;
import weblogic.server.ServiceFailureException;

public final class EJB20Service
extends ActivatedService {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static EJB20Service singleton;
    private ServerMBean serverMBean;
    private Class ejbDebugServiceClass = null;
    private boolean shutdown;

    private void initialize() {
        singleton = this;
        this.serverMBean = ManagementService.getRuntimeAccess(kernelId).getServer();
        this.ejbDebugServiceClass = EJBDebugService.class;
        ApplicationFactoryManager applicationFactoryManager = ApplicationFactoryManager.getApplicationFactoryManager();
        EJBDeploymentFactory eJBDeploymentFactory = new EJBDeploymentFactory();
        applicationFactoryManager.addLibraryFactory(new EJBLibraryFactory());
        applicationFactoryManager.addLastDeploymentFactory(eJBDeploymentFactory);
        applicationFactoryManager.addModuleFactory(new EJBModuleFactory());
        if (ManagementService.getRuntimeAccess(kernelId).isAdminServer()) {
            try {
                DomainAccess domainAccess = ManagementService.getDomainAccess(kernelId);
                DomainRuntimeMBean domainRuntimeMBean = domainAccess.getDomainRuntime();
                MessageDrivenControlEJBRuntimeMBeanImpl messageDrivenControlEJBRuntimeMBeanImpl = new MessageDrivenControlEJBRuntimeMBeanImpl();
                domainRuntimeMBean.setMessageDrivenControlEJBRuntime(messageDrivenControlEJBRuntimeMBeanImpl);
            }
            catch (ManagementException managementException) {
                EJBLogger.logFailedToCreateRuntimeMBeanLoggable((Exception)((Object)managementException));
            }
        }
    }

    public synchronized void haltService() throws ServiceFailureException {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
    }

    public synchronized void stopService() throws ServiceFailureException {
        this.haltService();
    }

    public synchronized boolean startService() throws ServiceFailureException {
        this.initialize();
        this.shutdown = false;
        return true;
    }

    static EJB20Service getEJB20Service() {
        return singleton;
    }

    ServerMBean getServer() {
        return this.serverMBean;
    }

    ServerDebugMBean getServerDebug() {
        return this.serverMBean.getServerDebug();
    }
}

