/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.deployer;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.ModuleException;
import weblogic.deployment.BaseEnvironmentBuilder;
import weblogic.deployment.EnvironmentException;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.container.EJBDebugService;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.ReadConfig;
import weblogic.ejb.container.cmp.rdbms.RDBMSPersistenceManager;
import weblogic.ejb.container.deployer.EJBModule;
import weblogic.ejb.container.deployer.EjbInfoImpl;
import weblogic.ejb.container.deployer.EnvironmentBuilder;
import weblogic.ejb.container.deployer.MBeanDeploymentInfoImpl;
import weblogic.ejb.container.deployer.MDBServiceActivator;
import weblogic.ejb.container.ejbc.VersionHelperImpl;
import weblogic.ejb.container.injection.EjbComponentCreatorImpl;
import weblogic.ejb.container.interfaces.BeanInfo;
import weblogic.ejb.container.interfaces.BeanManager;
import weblogic.ejb.container.interfaces.ClientDrivenBeanInfo;
import weblogic.ejb.container.interfaces.DeploymentInfo;
import weblogic.ejb.container.interfaces.Ejb3SessionBeanInfo;
import weblogic.ejb.container.interfaces.EjbComponentCreator;
import weblogic.ejb.container.interfaces.EntityBeanInfo;
import weblogic.ejb.container.interfaces.InvalidationBeanManager;
import weblogic.ejb.container.interfaces.MessageDrivenBeanInfo;
import weblogic.ejb.container.interfaces.MessageDrivenManagerIntf;
import weblogic.ejb.container.interfaces.SecurityRoleMapping;
import weblogic.ejb.container.interfaces.SessionBeanInfo;
import weblogic.ejb.container.internal.DataBeanMapper;
import weblogic.ejb.container.internal.EJBComponentRuntimeMBeanImpl;
import weblogic.ejb.container.internal.EJBRuntimeUtils;
import weblogic.ejb.container.internal.RuntimeHelper;
import weblogic.ejb.container.manager.BaseEntityManager;
import weblogic.ejb.container.manager.StatelessManager;
import weblogic.ejb.container.persistence.spi.PersistenceManager;
import weblogic.ejb.container.timer.EJBTimerManagerFactory;
import weblogic.ejb.spi.EJBC;
import weblogic.ejb.spi.EJBCFactory;
import weblogic.ejb.spi.EJBDeployListener;
import weblogic.ejb.spi.EJBDeploymentException;
import weblogic.ejb.spi.EjbDescriptorBean;
import weblogic.ejb.spi.InvalidationMessage;
import weblogic.ejb.spi.VersionHelper;
import weblogic.ejb.spi.WLDeploymentException;
import weblogic.j2ee.J2EEUtils;
import weblogic.j2ee.descriptor.EjbLocalRefBean;
import weblogic.j2ee.descriptor.EjbRefBean;
import weblogic.j2ee.descriptor.EnvEntryBean;
import weblogic.j2ee.descriptor.InterceptorBean;
import weblogic.j2ee.descriptor.MessageDestinationRefBean;
import weblogic.j2ee.descriptor.PersistenceContextRefBean;
import weblogic.j2ee.descriptor.PersistenceUnitRefBean;
import weblogic.j2ee.descriptor.ResourceEnvRefBean;
import weblogic.j2ee.descriptor.ResourceRefBean;
import weblogic.j2ee.descriptor.ServiceRefBean;
import weblogic.j2ee.descriptor.wl.MessageDestinationDescriptorBean;
import weblogic.j2ee.descriptor.wl.SecurityPermissionBean;
import weblogic.j2ee.descriptor.wl.WeblogicEjbJarBean;
import weblogic.j2ee.injection.PitchforkContext;
import weblogic.jndi.Environment;
import weblogic.logging.Loggable;
import weblogic.management.DeploymentException;
import weblogic.management.DomainDir;
import weblogic.management.ManagementException;
import weblogic.management.configuration.EJBComponentMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.EJBComponentRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.t3.srvr.T3Srvr;
import weblogic.utils.AssertionError;
import weblogic.utils.BadOptionException;
import weblogic.utils.ErrorCollectionException;
import weblogic.utils.FileUtils;
import weblogic.utils.Getopt2;
import weblogic.utils.StringUtils;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.DirectoryClassFinder;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.compiler.CompilerInvoker;
import weblogic.utils.jars.VirtualJarFile;

public final class EJBDeployer {
    private static final DebugLogger debugLogger = EJBDebugService.deploymentLogger;
    private DeployedManagers deployedManagers;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private VersionHelper vHelper;
    private DeploymentInfo dinfo;
    private ApplicationContextInternal appCtx;
    private Map eBuilderMap = new HashMap();
    private String name;
    private EJBModule ejbModule;
    private EJBComponentRuntimeMBeanImpl compRTMBean;
    private Map cacheMap = null;
    private Map queryCacheMap = null;
    private RuntimeHelper helper = null;
    private String jarFilePath = null;
    private String outputDirPath = null;
    private String securitySpec = null;
    private String objectSchemaName = null;
    private Map dataBeansMap = null;
    private static String separator = System.getProperty("path.separator");
    private List deployListeners = new ArrayList();
    private boolean firstActivate = true;
    private final List<MessageDrivenManagerIntf> subscriptionDeleteList = new LinkedList<MessageDrivenManagerIntf>();
    private PitchforkContext pitchforkContext;
    ClassLoader moduleCL = null;

    public EJBDeployer(ApplicationContextInternal applicationContextInternal, EJBModule eJBModule, EJBComponentRuntimeMBeanImpl eJBComponentRuntimeMBeanImpl) throws EJBDeploymentException, ModuleException {
        this.ejbModule = eJBModule;
        this.compRTMBean = eJBComponentRuntimeMBeanImpl;
        this.name = eJBComponentRuntimeMBeanImpl.getName();
        this.appCtx = applicationContextInternal;
        this.deployedManagers = new DeployedManagers();
        this.createDeployListeners();
        for (EJBDeployListener eJBDeployListener : this.deployListeners) {
            eJBDeployListener.init(applicationContextInternal, eJBModule.getEJBComponent());
        }
    }

    private void createDeployListeners() throws EJBDeploymentException {
        Object object = null;
        if (this.appCtx != null) {
            object = this.appCtx.getAppClassLoader();
        }
        if (object == null) {
            object = Thread.currentThread().getContextClassLoader();
        }
        Class<?> clazz = null;
        try {
            clazz = ((ClassLoader)object).loadClass("weblogic.wsee.deploy.WsEJBDeployListener");
            this.deployListeners.add(clazz.newInstance());
        }
        catch (InstantiationException instantiationException) {
            throw new EJBDeploymentException(this.ejbModule.getURI(), this.ejbModule.getURI(), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new EJBDeploymentException(this.ejbModule.getURI(), this.ejbModule.getURI(), illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new EJBDeploymentException(this.ejbModule.getURI(), this.ejbModule.getURI(), classNotFoundException);
        }
    }

    public EJBComponentRuntimeMBean getRuntimeMBean() {
        return this.compRTMBean;
    }

    private Context setupEnvironmentContext(Context context, BeanInfo beanInfo, String string, String string2) throws NamingException, EnvironmentException {
        Object object2;
        context.bind("ejb-info", (Object)new EjbInfoImpl(beanInfo));
        LinkedList<EnvEntryBean> linkedList = new LinkedList<EnvEntryBean>();
        LinkedList<ResourceEnvRefBean> linkedList2 = new LinkedList<ResourceEnvRefBean>();
        LinkedList<PersistenceContextRefBean> linkedList3 = new LinkedList<PersistenceContextRefBean>();
        LinkedList<PersistenceUnitRefBean> linkedList4 = new LinkedList<PersistenceUnitRefBean>();
        String string3 = beanInfo.getEJBName();
        List list = this.dinfo.getInterceptorBeans(string3);
        for (Object object2 : list) {
            linkedList.addAll(Arrays.asList(object2.getEnvEntries()));
            linkedList2.addAll(Arrays.asList(object2.getResourceEnvRefs()));
            linkedList3.addAll(Arrays.asList(object2.getPersistenceContextRefs()));
            linkedList4.addAll(Arrays.asList(object2.getPersistenceUnitRefs()));
        }
        object2 = new EnvironmentBuilder(context, string, string2, beanInfo.getEJBName(), beanInfo);
        linkedList.addAll(beanInfo.getAllEnvironmentEntries());
        ((BaseEnvironmentBuilder)object2).addEnvironmentEntries(linkedList);
        linkedList2.addAll(beanInfo.getAllResourceEnvReferences());
        ((EnvironmentBuilder)object2).addResourceEnvReferences(linkedList2, beanInfo.getAllResourceEnvReferenceJNDINames(this.appCtx == null ? null : this.appCtx.getApplicationId()));
        linkedList3.addAll(Arrays.asList(beanInfo.getPersistenceContextRefs()));
        ((BaseEnvironmentBuilder)object2).addPersistenceContextRefs(linkedList3.toArray(new PersistenceContextRefBean[0]), beanInfo.getModuleClassLoader(), this.ejbModule);
        linkedList4.addAll(Arrays.asList(beanInfo.getPersistenceUnitRefs()));
        ((BaseEnvironmentBuilder)object2).addPersistenceUnitRefs(linkedList4.toArray(new PersistenceUnitRefBean[0]), beanInfo.getModuleClassLoader(), this.ejbModule);
        ((EnvironmentBuilder)object2).addTimerServiceBinding();
        this.eBuilderMap.put(beanInfo.getEJBName(), object2);
        return ((BaseEnvironmentBuilder)object2).getContext();
    }

    private void unsetupEnvironmentContext() {
        if (this.dinfo != null) {
            for (BeanInfo beanInfo : this.dinfo.getBeanInfos()) {
                EnvironmentBuilder environmentBuilder = (EnvironmentBuilder)this.eBuilderMap.get(beanInfo.getEJBName());
                if (environmentBuilder == null) continue;
                LinkedList<EnvEntryBean> linkedList = new LinkedList<EnvEntryBean>();
                LinkedList<ResourceEnvRefBean> linkedList2 = new LinkedList<ResourceEnvRefBean>();
                LinkedList<PersistenceContextRefBean> linkedList3 = new LinkedList<PersistenceContextRefBean>();
                LinkedList<PersistenceUnitRefBean> linkedList4 = new LinkedList<PersistenceUnitRefBean>();
                String string = beanInfo.getEJBName();
                List list = this.dinfo.getInterceptorBeans(string);
                for (InterceptorBean interceptorBean : list) {
                    linkedList.addAll(Arrays.asList(interceptorBean.getEnvEntries()));
                    linkedList2.addAll(Arrays.asList(interceptorBean.getResourceEnvRefs()));
                    linkedList3.addAll(Arrays.asList(interceptorBean.getPersistenceContextRefs()));
                    linkedList4.addAll(Arrays.asList(interceptorBean.getPersistenceUnitRefs()));
                }
                try {
                    environmentBuilder.getContext().unbind("ejb-info");
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
                linkedList.addAll(beanInfo.getAllEnvironmentEntries());
                environmentBuilder.removeEnvironmentEntries(linkedList);
                linkedList2.addAll(beanInfo.getAllResourceEnvReferences());
                environmentBuilder.removeResourceEnvReferences(linkedList2);
                linkedList3.addAll(Arrays.asList(beanInfo.getPersistenceContextRefs()));
                environmentBuilder.removePersistenceContextRefs(linkedList3.toArray(new PersistenceContextRefBean[0]));
                linkedList4.addAll(Arrays.asList(beanInfo.getPersistenceUnitRefs()));
                environmentBuilder.removePersistenceUnitRefs(linkedList4.toArray(new PersistenceUnitRefBean[0]));
                environmentBuilder.removeTimerServiceBinding();
                environmentBuilder.removeStandardEntries();
                this.eBuilderMap.remove(beanInfo.getEJBName());
            }
        }
    }

    private Getopt2 makeGetopt2() {
        Getopt2 getopt2 = new Getopt2();
        getopt2.addFlag("nodeploy", "Do not unpack jar files into the target dir.");
        getopt2.setUsageArgs("<source jar file> <target directory or jar file>");
        getopt2.addFlag("idl", "Generate idl for remote interfaces");
        getopt2.addFlag("idlOverwrite", "Always overwrite existing IDL files");
        getopt2.addFlag("idlVerbose", "Display verbose information for IDL generation");
        getopt2.addFlag("idlNoValueTypes", "Do not generate valuetypes and methods/attributes that contain them.");
        getopt2.markPrivate("idlNoValueTypes");
        getopt2.addOption("idlDirectory", "dir", "Specify the directory where IDL files will be created (default : current directory)");
        getopt2.addFlag("iiop", "Generate CORBA stubs");
        getopt2.addOption("iiopDirectory", "dir", "Specify the directory where IIOP stub files will be written (default : current directory)");
        getopt2.addFlag("forceGeneration", "Force generation of wrapper classes.  Without this flag the classes may not be regenerated if it is determined to be unnecessary.");
        getopt2.addFlag("convertDDs", "Convert old deployment descriptors to new ones");
        getopt2.addFlag("disableHotCodeGen", "Generate ejb stub and skel as part of ejbc. Avoid HotCodeGen to have better performance.");
        new CompilerInvoker(getopt2);
        getopt2.markPrivate("nowrite");
        getopt2.markPrivate("commentary");
        getopt2.markPrivate("nodeploy");
        getopt2.markPrivate("compilerclass");
        getopt2.markPrivate("O");
        getopt2.markPrivate("d");
        getopt2.markPrivate("J");
        return getopt2;
    }

    private String makeClasspath(GenericClassLoader genericClassLoader, EJBComponentMBean eJBComponentMBean) {
        String string = ReadConfig.getJavaCompilerPreClassPath(eJBComponentMBean);
        String string2 = ReadConfig.getJavaCompilerPostClassPath(eJBComponentMBean);
        if (string == null && string2 == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (null != string) {
            stringBuffer.append(string);
            stringBuffer.append(separator);
        }
        stringBuffer.append(genericClassLoader.getClassPath());
        if (null != string2) {
            stringBuffer.append(separator);
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private void runEJBC(GenericClassLoader genericClassLoader, Getopt2 getopt2, EJBComponentMBean eJBComponentMBean, VirtualJarFile virtualJarFile, Collection collection) throws ErrorCollectionException {
        EJBC eJBC = EJBCFactory.createEJBC(getopt2);
        eJBC.compileEJB(genericClassLoader, eJBComponentMBean, virtualJarFile, this.vHelper, collection);
    }

    private void unregisterMBeans() {
        if (this.compRTMBean != null) {
            try {
                this.compRTMBean.unregisterDependents();
            }
            catch (ManagementException managementException) {
                if (debugLogger.isDebugEnabled()) {
                    EJBDeployer.debug("Couldn't unregister MBeans");
                }
                EJBLogger.logStackTraceAndMessage((String)"Couldn't unregister MBeans", (Throwable)managementException);
            }
        }
    }

    private File getEJBCompilerCache() {
        File file = EJBDeployer.getEjbCompilerCacheDir();
        String string = this.ejbModule.getApplicationName();
        String string2 = this.ejbModule.getURI();
        return new File(file, StringUtils.mangle((String)(string + "_" + string2)));
    }

    public static File getEjbCompilerCacheDir() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = ManagementService.getRuntimeAccess(kernelId).getServerName();
        String string2 = System.getProperty("weblogic.j2ee.application.tmpDir");
        string2 = string2 != null ? string2 + File.separator + "servers" + File.separator + string : DomainDir.getCacheDirForServer((String)string);
        stringBuffer.append(string2);
        stringBuffer.append(File.separator);
        stringBuffer.append("EJBCompilerCache");
        return new File(stringBuffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getFileHash(File file) {
        Properties properties;
        File file2 = new File(file, "_WL_GENERATED");
        if (!file2.exists()) {
            return null;
        }
        FileInputStream fileInputStream = null;
        try {
            Properties properties2 = new Properties();
            fileInputStream = new FileInputStream(file2);
            properties2.load(fileInputStream);
            properties = properties2;
            Object var7_8 = null;
        }
        catch (IOException iOException) {
            Properties properties3;
            try {
                EJBLogger.logExceptionLoadingTimestamp((Exception)iOException);
                properties3 = null;
                Object var7_9 = null;
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                EJBDeployer.closeStream(fileInputStream);
                throw throwable;
            }
            EJBDeployer.closeStream(fileInputStream);
            return properties3;
        }
        EJBDeployer.closeStream(fileInputStream);
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getFileHash(VirtualJarFile virtualJarFile) {
        Properties properties;
        ZipEntry zipEntry = virtualJarFile.getEntry("_WL_GENERATED");
        if (zipEntry == null) {
            return null;
        }
        InputStream inputStream = null;
        try {
            Properties properties2 = new Properties();
            inputStream = virtualJarFile.getInputStream(zipEntry);
            properties2.load(inputStream);
            properties = properties2;
            Object var7_8 = null;
        }
        catch (IOException iOException) {
            Properties properties3;
            try {
                EJBLogger.logExceptionLoadingTimestamp((Exception)iOException);
                properties3 = null;
                Object var7_9 = null;
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                EJBDeployer.closeStream(inputStream);
                throw throwable;
            }
            EJBDeployer.closeStream(inputStream);
            return properties3;
        }
        EJBDeployer.closeStream(inputStream);
        return properties;
    }

    private void dumpProps(Properties properties) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            EJBDeployer.debug("Prop: " + string + "value is: " + properties.getProperty(string));
        }
    }

    private void compileIfNecessary(VirtualJarFile virtualJarFile, GenericClassLoader genericClassLoader) throws EJBDeploymentException, ModuleException {
        try {
            this.vHelper = new VersionHelperImpl(this.dinfo, virtualJarFile, null);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new EJBDeploymentException(this.ejbModule.getURI(), this.ejbModule.getURI(), classNotFoundException);
        }
        Properties properties = this.getFileHash(virtualJarFile);
        if (properties != null) {
            this.vHelper.removeCompilerOptions(properties);
        }
        boolean bl = ReadConfig.getForceGeneration(this.ejbModule.getEJBComponent());
        Collection collection = null;
        if (bl) {
            if (debugLogger.isDebugEnabled()) {
                EJBDeployer.debug("force-generation has been enabled.");
            }
            collection = this.dinfo.getBeanInfos();
        } else {
            collection = this.vHelper.needsRecompile(properties);
        }
        if (!collection.isEmpty()) {
            Properties properties2;
            File file = this.getEJBCompilerCache();
            if (file.exists()) {
                if (!file.isDirectory()) {
                    Loggable loggable = EJBLogger.logUnableToCreateTempDirLoggable((String)file.getAbsolutePath());
                    WLDeploymentException wLDeploymentException = new WLDeploymentException(loggable.getMessage());
                    throw new EJBDeploymentException(this.ejbModule.getURI(), this.ejbModule.getURI(), wLDeploymentException);
                }
                if (!bl && (properties2 = this.getFileHash(file)) != null) {
                    this.vHelper.removeCompilerOptions(properties2);
                    collection = this.vHelper.needsRecompile(properties2);
                }
            } else if (!file.mkdirs()) {
                Loggable loggable = EJBLogger.logUnableToCreateTempDirLoggable((String)file.getAbsolutePath());
                WLDeploymentException wLDeploymentException = new WLDeploymentException(loggable.getMessage());
                throw new EJBDeploymentException(this.ejbModule.getURI(), this.ejbModule.getURI(), wLDeploymentException);
            }
            properties2 = null;
            try {
                properties2 = new DirectoryClassFinder(file);
            }
            catch (IOException iOException) {
                throw new EJBDeploymentException(this.ejbModule.getURI(), this.ejbModule.getURI(), iOException);
            }
            genericClassLoader.addClassFinderFirst((ClassFinder)properties2);
            if (!collection.isEmpty()) {
                this.compileJar(file, collection, genericClassLoader, virtualJarFile);
            }
            try {
                properties2.indexFiles();
            }
            catch (IOException iOException) {
                throw new EJBDeploymentException(this.ejbModule.getURI(), this.ejbModule.getURI(), iOException);
            }
        }
    }

    private boolean perhapsUseDisableHotCodeGen(VirtualJarFile virtualJarFile) {
        boolean bl = false;
        Iterator iterator = virtualJarFile.entries();
        while (iterator.hasNext()) {
            ZipEntry zipEntry = (ZipEntry)iterator.next();
            if (zipEntry.getName().indexOf("_WLSkel") == -1) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private void compileJar(File file, Collection collection, GenericClassLoader genericClassLoader, VirtualJarFile virtualJarFile) throws EJBDeploymentException, ModuleException {
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                return file.getName().endsWith(".java");
            }
        };
        FileUtils.remove((File)file, (FileFilter)fileFilter);
        Getopt2 getopt2 = this.makeGetopt2();
        EJBComponentMBean eJBComponentMBean = this.ejbModule.getEJBComponent();
        String string = ReadConfig.getExtraEjbcOptions(eJBComponentMBean);
        this.outputDirPath = file.getAbsolutePath();
        if (string != null && string.trim().length() > 0) {
            try {
                getopt2.grok(StringUtils.splitCompletely((String)string, (String)" "));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new EJBDeploymentException(this.ejbModule.getURI(), this.ejbModule.getURI(), illegalArgumentException);
            }
        }
        try {
            getopt2.setOption("compiler", ReadConfig.getJavaCompiler(eJBComponentMBean));
            String string2 = file.getPath();
            getopt2.setOption("d", string2);
            String string3 = this.makeClasspath(genericClassLoader, eJBComponentMBean);
            if (string3 != null) {
                getopt2.setOption("classpath", string3);
            }
            getopt2.setFlag("nowarn", true);
            getopt2.setFlag("noexit", true);
            if (eJBComponentMBean != null) {
                getopt2.setFlag("keepgenerated", eJBComponentMBean.getKeepGenerated());
                getopt2.setFlag("forceGeneration", ReadConfig.getForceGeneration(eJBComponentMBean));
            }
            if (this.perhapsUseDisableHotCodeGen(virtualJarFile)) {
                if (debugLogger.isDebugEnabled()) {
                    EJBDeployer.debug("Setting disableHotCodeGen to true, as the existing jar contained pre-generated skeletons");
                }
                getopt2.setFlag("disableHotCodeGen", true);
            }
        }
        catch (BadOptionException badOptionException) {
            throw new AssertionError((Throwable)badOptionException);
        }
        try {
            if (getopt2.hasOption("keepgenerated")) {
                EJBLogger.logEJBBeingRecompiledOnServerKeepgenerated((String)this.ejbModule.getURI(), (String)file.getAbsolutePath());
            } else {
                EJBLogger.logEJBBeingRecompiledOnServer((String)this.ejbModule.getURI());
            }
            this.runEJBC(genericClassLoader, getopt2, eJBComponentMBean, virtualJarFile, collection);
        }
        catch (ErrorCollectionException errorCollectionException) {
            throw new EJBDeploymentException(this.ejbModule.getURI(), this.ejbModule.getURI(), errorCollectionException);
        }
    }

    private static void closeStream(InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void registerSupplementalPolicyObject(EjbDescriptorBean ejbDescriptorBean) {
        WeblogicEjbJarBean weblogicEjbJarBean = ejbDescriptorBean.getWeblogicEjbJarBean();
        SecurityPermissionBean securityPermissionBean = weblogicEjbJarBean.getSecurityPermission();
        if (securityPermissionBean != null) {
            this.securitySpec = securityPermissionBean.getSecurityPermissionSpec();
        }
        String string = null;
        String[] stringArray = this.getDeploymentPaths();
        if (this.jarFilePath != null) {
            StringBuilder stringBuilder = new StringBuilder("permission java.io.FilePermission \"");
            stringBuilder.append(stringArray[0]);
            stringBuilder.append("/-\", \"read\"");
            string = this.insertPermission(stringBuilder.toString(), this.securitySpec);
        } else {
            string = this.securitySpec;
        }
        if (debugLogger.isDebugEnabled()) {
            EJBDeployer.debug("  setting J2EE Sandbox Security: component Name: '" + this.jarFilePath + "',  securitySpec: '" + string + "'");
        }
        RuntimeHelper.registerSupplementalPolicyObject(stringArray, string);
    }

    private void removeSupplementalPolicyObject() {
        if (debugLogger.isDebugEnabled()) {
            EJBDeployer.debug("  removing J2EE Sandbox Security: component Name: '" + this.jarFilePath + "'");
        }
        RuntimeHelper.removeSupplementalPolicyObject(this.getDeploymentPaths());
    }

    private String insertPermission(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string2 == null || string2.trim().length() == 0) {
            stringBuilder.append("grant {\n");
            stringBuilder.append(string);
            stringBuilder.append(";\n};");
        } else {
            StringBuilder stringBuilder2 = new StringBuilder(string2);
            int n = stringBuilder2.indexOf("}");
            if (n > 0) {
                stringBuilder2.insert(n, string + ";\n");
            }
            stringBuilder = stringBuilder2;
        }
        return stringBuilder.toString();
    }

    private void deployAllPolicies() throws Exception {
        this.helper.deployAllPolicies();
    }

    private void deployRoles() throws Exception {
        SecurityRoleMapping securityRoleMapping = this.dinfo.getDeploymentRoles();
        Collection collection = securityRoleMapping.getSecurityRoleNames();
        if (collection.size() <= 0) {
            return;
        }
        this.helper.deployRoles(this.dinfo, securityRoleMapping);
    }

    private void unDeployRoles() {
        if (this.helper == null) {
            return;
        }
        SecurityRoleMapping securityRoleMapping = this.dinfo.getDeploymentRoles();
        Collection collection = securityRoleMapping.getSecurityRoleNames();
        if (collection.size() <= 0) {
            return;
        }
        this.helper.unDeployRoles(this.dinfo, securityRoleMapping);
    }

    private String getEJBName(BeanInfo beanInfo, EjbDescriptorBean ejbDescriptorBean) {
        if (beanInfo == null) {
            return ejbDescriptorBean.getJarFileName();
        }
        return beanInfo.getEJBName();
    }

    public Collection getBeanInfos() {
        return this.dinfo.getBeanInfos();
    }

    private void setupMessageDestinations(EjbDescriptorBean ejbDescriptorBean, Context context) throws EJBDeploymentException {
        Context context2 = null;
        try {
            context2 = (Context)context.lookup("messageDestination");
        }
        catch (NameNotFoundException nameNotFoundException) {
            try {
                context2 = context.createSubcontext("messageDestination");
            }
            catch (NamingException namingException) {
                throw new AssertionError((Throwable)namingException);
            }
        }
        catch (NamingException namingException) {
            throw new AssertionError((Throwable)namingException);
        }
        Collection collection = this.dinfo.getMessageDestinationDescriptors();
        String string = J2EEUtils.normalizeJarName(this.ejbModule.getURI());
        try {
            for (MessageDestinationDescriptorBean messageDestinationDescriptorBean : collection) {
                String string2 = J2EEUtils.normalizeJNDIName(messageDestinationDescriptorBean.getMessageDestinationName());
                context2.bind(string + "#" + string2, (Object)messageDestinationDescriptorBean);
            }
        }
        catch (NamingException namingException) {
            throw new EJBDeploymentException(ejbDescriptorBean.getJarFileName(), this.ejbModule.getURI(), namingException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setupBeanInfos(EjbDescriptorBean ejbDescriptorBean, Context context, EjbComponentCreator ejbComponentCreator) throws EJBDeploymentException {
        BeanInfo beanInfo = null;
        try {
            Iterator iterator = this.dinfo.getBeanInfos().iterator();
            ArrayList<BeanManager> arrayList = new ArrayList<BeanManager>();
            HashMap<String, BeanManager> hashMap = new HashMap<String, BeanManager>();
            HashMap<BeanInfo, Object> hashMap2 = new HashMap<BeanInfo, Object>();
            while (iterator.hasNext()) {
                Object var12_17;
                Object object2;
                beanInfo = (BeanInfo)iterator.next();
                beanInfo.setEjbComponentCreator(ejbComponentCreator);
                beanInfo.setRuntimeHelper(this.helper);
                if (!(beanInfo instanceof MessageDrivenBeanInfo)) {
                    beanInfo.setupBeanManager(this.compRTMBean);
                } else {
                    ((MessageDrivenBeanInfo)beanInfo).setEJBComponentRuntime(this.compRTMBean);
                    this.deployedManagers.hasMDBs = true;
                }
                if (beanInfo instanceof EntityBeanInfo) {
                    object2 = (EntityBeanInfo)beanInfo;
                    BeanManager beanManager = object2.getBeanManager();
                    if (!object2.getIsBeanManagedPersistence() && object2.getCMPInfo().uses20CMP()) {
                        arrayList.add(beanManager);
                        hashMap.put(object2.getEJBName(), beanManager);
                    }
                }
                object2 = this.setupEnvironmentFor(beanInfo, context);
                hashMap2.put(beanInfo, object2);
                try {
                    EJBRuntimeUtils.pushEnvironment((Context)object2);
                    beanInfo.prepare(this.appCtx, this.dinfo);
                    var12_17 = null;
                }
                catch (Throwable throwable) {
                    var12_17 = null;
                    EJBRuntimeUtils.popEnvironment();
                    throw throwable;
                }
                EJBRuntimeUtils.popEnvironment();
                if (!(beanInfo instanceof ClientDrivenBeanInfo)) continue;
                ClientDrivenBeanInfo clientDrivenBeanInfo = (ClientDrivenBeanInfo)beanInfo;
                clientDrivenBeanInfo.bindEJBRefs((Context)object2);
            }
            this.deployAllPolicies();
            this.deployRoles();
            for (BeanManager beanManager : arrayList) {
                if (!(beanManager instanceof BaseEntityManager)) continue;
                ((BaseEntityManager)beanManager).setBMMap(hashMap);
            }
        }
        catch (WLDeploymentException wLDeploymentException) {
            throw new EJBDeploymentException(this.getEJBName(beanInfo, ejbDescriptorBean), this.ejbModule.getURI(), wLDeploymentException);
        }
        catch (Throwable throwable) {
            throw new EJBDeploymentException(this.getEJBName(beanInfo, ejbDescriptorBean), this.ejbModule.getURI(), throwable);
        }
    }

    final Context setupEnvironmentFor(BeanInfo beanInfo, Context context) throws WLDeploymentException {
        String string;
        Context context2;
        if (debugLogger.isDebugEnabled()) {
            EJBDeployer.debug("==================SETTING ENV. FOR EJB====================");
            EJBDeployer.debug("EJB: " + beanInfo.getDisplayName());
        }
        String string2 = J2EEUtils.normalizeJarName(this.ejbModule.getURI());
        Context context3 = null;
        try {
            context2 = (Context)context.lookup("ejb");
            string = beanInfo.getEJBName();
            context3 = context2.createSubcontext(string2 + "#" + string);
            context3.bind("app", (Object)context);
        }
        catch (NamingException namingException) {
            throw new AssertionError((Throwable)namingException);
        }
        try {
            context2 = this.setupEnvironmentContext(context3, beanInfo, this.appCtx.getApplicationId(), this.ejbModule.getName());
            return context2;
        }
        catch (NamingException namingException) {
            string = EJBLogger.logFailureWhileCreatingCompEnvLoggable((Exception)namingException);
            throw new WLDeploymentException(string.getMessage(), namingException);
        }
        catch (EnvironmentException environmentException) {
            string = EJBLogger.logFailureWhileCreatingCompEnvLoggable((Exception)((Object)environmentException));
            throw new WLDeploymentException(string.getMessage(), (Throwable)((Object)environmentException));
        }
    }

    final String needsRecompile(List list, ClassLoader classLoader) throws ClassNotFoundException {
        for (String string : list) {
            if (!this.vHelper.needsRecompile(string, classLoader)) continue;
            return string;
        }
        return null;
    }

    final void updateImplClassLoader(String string) throws WLDeploymentException {
        BeanInfo beanInfo = this.dinfo.getBeanInfo(string);
        beanInfo.updateImplClassLoader();
    }

    final void prepare(VirtualJarFile virtualJarFile, ClassLoader classLoader, EjbDescriptorBean ejbDescriptorBean, Context context, Map map, Map map2) throws EJBDeploymentException, ModuleException {
        assert (classLoader != null);
        if (virtualJarFile != null) {
            this.jarFilePath = virtualJarFile.getName();
        }
        GenericClassLoader genericClassLoader = (GenericClassLoader)classLoader;
        this.cacheMap = map;
        this.queryCacheMap = map2;
        EJBLogger.logDeploying((String)this.ejbModule.getURI());
        try {
            this.dinfo = new MBeanDeploymentInfoImpl(ejbDescriptorBean, genericClassLoader, this.ejbModule.getName(), this.ejbModule.getURI(), virtualJarFile, this.appCtx);
        }
        catch (Exception exception) {
            throw new EJBDeploymentException(ejbDescriptorBean.getJarFileName(), this.ejbModule.getURI(), exception);
        }
        boolean bl = false;
        for (Object object : this.dinfo.getBeanInfos()) {
            if (object instanceof EntityBeanInfo) {
                Object object2 = (EntityBeanInfo)object;
                if (object2.getIsBeanManagedPersistence()) continue;
                try {
                    object2.getCMPInfo().setup(new File(this.dinfo.getJarFileName()), null, this.dinfo.getVirtualJarFile());
                    continue;
                }
                catch (WLDeploymentException wLDeploymentException) {
                    throw new EJBDeploymentException(object2.getEJBName(), this.ejbModule.getURI(), wLDeploymentException);
                }
            }
            if (!(object instanceof Ejb3SessionBeanInfo)) continue;
            bl = true;
        }
        this.pitchforkContext = this.dinfo.getPitchforkContext();
        if (bl) {
            this.pitchforkContext.getPitchforkUtils().acceptClassLoader(classLoader);
        }
        if (virtualJarFile != null) {
            this.compileIfNecessary(virtualJarFile, genericClassLoader);
        }
        try {
            this.helper = new RuntimeHelper(this.dinfo, this.appCtx);
            this.registerSupplementalPolicyObject(ejbDescriptorBean);
        }
        catch (Exception exception) {
            throw new EJBDeploymentException(ejbDescriptorBean.getJarFileName(), this.ejbModule.getURI(), exception);
        }
        EjbComponentCreatorImpl ejbComponentCreatorImpl = new EjbComponentCreatorImpl(this.pitchforkContext);
        try {
            ejbComponentCreatorImpl.initialize(this.dinfo, (ClassLoader)genericClassLoader);
        }
        catch (DeploymentException deploymentException) {
            throw new EJBDeploymentException(ejbDescriptorBean.getJarFileName(), this.ejbModule.getURI(), (Throwable)((Object)deploymentException));
        }
        this.setupBeanInfos(ejbDescriptorBean, context, ejbComponentCreatorImpl);
        if (virtualJarFile != null) {
            for (Object object2 : this.deployListeners) {
                object2.prepare(this.dinfo, ejbDescriptorBean, this.appCtx);
            }
        }
        this.setupMessageDestinations(ejbDescriptorBean, context);
        this.firstActivate = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void activate(EjbDescriptorBean ejbDescriptorBean, ClassLoader classLoader, Context context) throws EJBDeploymentException {
        Context context2 = null;
        Context context3 = null;
        BeanInfo beanInfo2 = null;
        try {
            Object object4;
            Object object2;
            String string = J2EEUtils.normalizeJarName(this.ejbModule.getURI());
            Context context4 = (Context)context.lookup("ejb");
            for (BeanInfo beanInfo2 : this.dinfo.getBeanInfos()) {
                Object object3;
                Iterator iterator;
                object2 = beanInfo2.getEJBName();
                context3 = (Context)context4.lookup(string + "#" + (String)object2);
                object4 = new Environment();
                ((Environment)object4).setCreateIntermediateContexts(true);
                context2 = ((Environment)object4).getInitialContext();
                EnvironmentBuilder environmentBuilder = (EnvironmentBuilder)this.eBuilderMap.get(object2);
                Context context5 = environmentBuilder.getContext();
                try {
                    EJBRuntimeUtils.pushEnvironment(context5);
                    beanInfo2.activate(context2, this.cacheMap, this.queryCacheMap, this.dinfo, context5);
                    iterator = null;
                }
                catch (Throwable throwable) {
                    iterator = null;
                    EJBRuntimeUtils.popEnvironment();
                    this.deployedManagers.addManager(beanInfo2);
                    throw throwable;
                }
                EJBRuntimeUtils.popEnvironment();
                this.deployedManagers.addManager(beanInfo2);
                if (beanInfo2 instanceof Ejb3SessionBeanInfo) {
                    ((Ejb3SessionBeanInfo)beanInfo2).setPersistenceUnitRegistry(this.ejbModule.getPersistenceUnitRegistry());
                    object3 = ((Ejb3SessionBeanInfo)beanInfo2).getRemoteBusinessJNDINames();
                    if (object3 != null && object3.size() > 0) {
                        EJBLogger.logDeployedWithEJBName((String)beanInfo2.getDisplayName());
                        for (Map.Entry entry : object3.entrySet()) {
                            Object k = entry.getKey();
                            Object v = entry.getValue();
                            if (!(k instanceof Class) || !(v instanceof String)) continue;
                            EJBLogger.logJNDINamesMap((String)((Class)k).getCanonicalName(), (String)((String)v));
                        }
                    }
                }
                if (beanInfo2.getJNDIName() != null) {
                    if (!(beanInfo2 instanceof MessageDrivenBeanInfo)) {
                        EJBLogger.logDeployedWithJNDIName((String)beanInfo2.getJNDIName().toString());
                    } else {
                        EJBLogger.logDeployedMDB((String)object2);
                    }
                }
                if (!(beanInfo2 instanceof ClientDrivenBeanInfo) || (object3 = (ClientDrivenBeanInfo)beanInfo2).getLocalJNDIName() == null) continue;
                EJBLogger.logDeployedWithJNDIName((String)object3.getLocalJNDIName().toString());
            }
            DataBeanMapper.addBeans(this, this.dinfo.getBeanInfos());
            if (this.firstActivate) {
                for (BeanInfo beanInfo2 : this.dinfo.getBeanInfos()) {
                    if (!(beanInfo2 instanceof EntityBeanInfo) || (object4 = (object2 = (EntityBeanInfo)beanInfo2).getCMPInfo()) == null) continue;
                    object4.setupParentBeanManagers();
                    object4.setupMNBeanManagers();
                }
                for (BeanInfo beanInfo2 : this.dinfo.getBeanInfos()) {
                    if (!(beanInfo2 instanceof EntityBeanInfo) || (object4 = (object2 = (EntityBeanInfo)beanInfo2).getCMPInfo()) == null) continue;
                    object4.setCycleExists();
                }
                this.firstActivate = false;
            }
            this.helper.activate();
            this.activateEnvironment();
            this.setIsDeployed(true);
            for (Object object4 : this.deployListeners) {
                object4.activate(ejbDescriptorBean, classLoader, context);
            }
        }
        catch (WLDeploymentException wLDeploymentException) {
            throw new EJBDeploymentException(this.getEJBName(beanInfo2, ejbDescriptorBean), this.ejbModule.getURI(), wLDeploymentException);
        }
        catch (Throwable throwable) {
            throw new EJBDeploymentException(this.getEJBName(beanInfo2, ejbDescriptorBean), this.ejbModule.getURI(), throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deployMessageDrivenBeansUsingModuleCL() throws Exception {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (this.moduleCL != null) {
            Thread.currentThread().setContextClassLoader(this.moduleCL);
        }
        try {
            this.deployMessageDrivenBeans();
            Object var3_2 = null;
            if (classLoader != null) {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
            if (this.moduleCL != null) {
                this.moduleCL = null;
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (classLoader != null) {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
            if (this.moduleCL != null) {
                this.moduleCL = null;
            }
            throw throwable;
        }
    }

    final void start(boolean bl) throws EJBDeploymentException {
        Object object;
        Object object2;
        this.initializePools();
        boolean bl2 = this.isServerStarted();
        if (this.deployedManagers.hasMDBs()) {
            object2 = MDBServiceActivator.INSTANCE.getMDBService();
            if (bl && !bl2 && object2 != null && object2.addMDBStarter(this)) {
                this.moduleCL = Thread.currentThread().getContextClassLoader();
                if (debugLogger.isDebugEnabled()) {
                    EJBDeployer.debug("MDB is added to MDBService to start.  Server Status : " + T3Srvr.getT3Srvr().getState());
                }
            } else {
                try {
                    this.deployMessageDrivenBeans();
                }
                catch (WLDeploymentException wLDeploymentException) {
                    throw new EJBDeploymentException(this.ejbModule.getURI(), this.ejbModule.getURI(), wLDeploymentException);
                }
                catch (Throwable throwable) {
                    throw new EJBDeploymentException(this.ejbModule.getURI(), this.ejbModule.getURI(), throwable);
                }
            }
        }
        object2 = new HashSet();
        object2.addAll(this.deployedManagers.getNoneMdbManagers());
        object2.addAll(this.deployedManagers.getMdbManagers());
        this.deployedManagers.removeMdbManagers();
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            Object object3 = (BeanManager)iterator.next();
            object = object3.getTimerManager();
            if (object == null) continue;
            try {
                object.perhapsStart();
            }
            catch (Exception exception) {
                throw new EJBDeploymentException(object3.getBeanInfo().getEJBName(), this.ejbModule.getURI(), exception);
            }
        }
        if (!this.dinfo.isDynamicQueriesEnabled()) {
            for (Object object3 : this.dinfo.getBeanInfos()) {
                PersistenceManager persistenceManager;
                if (!(object3 instanceof EntityBeanInfo) || (persistenceManager = (object = (EntityBeanInfo)object3).getPersistenceManager()) == null || !(persistenceManager instanceof RDBMSPersistenceManager)) continue;
                RDBMSPersistenceManager rDBMSPersistenceManager = (RDBMSPersistenceManager)persistenceManager;
                rDBMSPersistenceManager.cleanup();
            }
        }
    }

    public void invalidate(InvalidationMessage invalidationMessage) {
        String string = invalidationMessage.getEjbName();
        BeanInfo beanInfo = this.dinfo.getBeanInfo(string);
        assert (beanInfo instanceof EntityBeanInfo);
        EntityBeanInfo entityBeanInfo = (EntityBeanInfo)beanInfo;
        InvalidationBeanManager invalidationBeanManager = (InvalidationBeanManager)entityBeanInfo.getBeanManager();
        if (invalidationMessage.getPrimaryKey() != null) {
            invalidationBeanManager.invalidateLocalServer(null, invalidationMessage.getPrimaryKey());
        } else if (invalidationMessage.getPrimaryKeys() != null) {
            invalidationBeanManager.invalidateLocalServer(null, invalidationMessage.getPrimaryKeys());
        } else {
            invalidationBeanManager.invalidateAllLocalServer(null);
        }
    }

    private boolean isServerStarted() {
        return T3Srvr.getT3Srvr().getRunState() == 2;
    }

    final void rollback(Context context) throws NamingException {
        Object object;
        this.unprepare();
        this.unregisterMBeans();
        if (this.dinfo != null && (object = this.dinfo.getBeanInfos()) != null) {
            Object object2 = object.iterator();
            while (object2.hasNext()) {
                BeanInfo beanInfo = (BeanInfo)object2.next();
                this.cleanupAppContext(beanInfo, context);
            }
        }
        this.removeSupplementalPolicyObject();
        this.unsetupEnvironmentContext();
        for (Object object2 : this.deployListeners) {
            object2.unprepare();
        }
        if (this.pitchforkContext != null) {
            this.pitchforkContext.getPitchforkUtils().clearClassLoader((ClassLoader)this.appCtx.getAppClassLoader());
        }
        this.eBuilderMap.clear();
        this.cacheMap = null;
    }

    private void initializePools() {
        BeanInfo beanInfo2 = null;
        for (BeanInfo beanInfo2 : this.dinfo.getBeanInfos()) {
            BeanManager beanManager;
            ClientDrivenBeanInfo clientDrivenBeanInfo;
            if (beanInfo2 instanceof SessionBeanInfo) {
                clientDrivenBeanInfo = (SessionBeanInfo)beanInfo2;
                if (clientDrivenBeanInfo.isStateful()) continue;
                beanManager = (StatelessManager)clientDrivenBeanInfo.getBeanManager();
                try {
                    ((StatelessManager)beanManager).initializePool();
                }
                catch (Exception exception) {
                    EJBLogger.logErrorCreatingFreepool((String)clientDrivenBeanInfo.getDisplayName(), (Exception)exception);
                }
                continue;
            }
            if (!(beanInfo2 instanceof EntityBeanInfo) || !((beanManager = (clientDrivenBeanInfo = (EntityBeanInfo)beanInfo2).getBeanManager()) instanceof BaseEntityManager)) continue;
            try {
                ((BaseEntityManager)beanManager).initializePool();
            }
            catch (Exception exception) {
                EJBLogger.logErrorCreatingFreepool((String)clientDrivenBeanInfo.getDisplayName(), (Exception)exception);
            }
        }
    }

    protected void deployMessageDrivenBeans() throws Exception {
        BeanInfo beanInfo2 = null;
        if (this.dinfo == null) {
            EJBLogger.logErrorOnStartMDBs((String)this.name);
            return;
        }
        for (BeanInfo beanInfo2 : this.dinfo.getBeanInfos()) {
            if (!(beanInfo2 instanceof MessageDrivenBeanInfo)) continue;
            MessageDrivenBeanInfo messageDrivenBeanInfo = (MessageDrivenBeanInfo)beanInfo2;
            messageDrivenBeanInfo.deployMessageDrivenBeans();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void activateEnvironment() throws EnvironmentException, NamingException {
        for (BeanInfo beanInfo : this.dinfo.getBeanInfos()) {
            Object var18_16;
            EnvironmentBuilder environmentBuilder = (EnvironmentBuilder)this.eBuilderMap.get(beanInfo.getEJBName());
            Context context = environmentBuilder.getContext();
            try {
                Object var16_15;
                Object object2;
                EJBRuntimeUtils.pushEnvironment(context);
                LinkedList<ResourceRefBean> linkedList = new LinkedList<ResourceRefBean>();
                LinkedList<EjbRefBean> linkedList2 = new LinkedList<EjbRefBean>();
                LinkedList<EjbLocalRefBean> linkedList3 = new LinkedList<EjbLocalRefBean>();
                LinkedList<MessageDestinationRefBean> linkedList4 = new LinkedList<MessageDestinationRefBean>();
                LinkedList<ServiceRefBean> linkedList5 = new LinkedList<ServiceRefBean>();
                String string = beanInfo.getEJBName();
                List list = this.dinfo.getInterceptorBeans(string);
                for (Object object2 : list) {
                    linkedList.addAll(Arrays.asList(object2.getResourceRefs()));
                    linkedList2.addAll(Arrays.asList(object2.getEjbRefs()));
                    linkedList3.addAll(Arrays.asList(object2.getEjbLocalRefs()));
                    linkedList4.addAll(Arrays.asList(object2.getMessageDestinationRefs()));
                    linkedList5.addAll(Arrays.asList(object2.getServiceRefs()));
                }
                linkedList.addAll(beanInfo.getAllResourceReferences());
                environmentBuilder.addResourceReferences(linkedList, beanInfo.getAllResourceReferenceJNDINames(this.appCtx == null ? null : this.appCtx.getApplicationId()), beanInfo);
                linkedList2.addAll(beanInfo.getAllEJBReferences());
                environmentBuilder.addEJBReferences(linkedList2, beanInfo.getAllEJBReferenceJNDINames(), this.ejbModule.getURI());
                linkedList3.addAll(beanInfo.getAllEJBLocalReferences());
                environmentBuilder.addEJBLocalReferences(linkedList3, beanInfo.getAllEJBLocalReferenceJNDINames(), this.ejbModule.getURI());
                linkedList4.addAll(beanInfo.getAllMessageDestinationReferences());
                environmentBuilder.addMessageDestinationReferences(linkedList4, this.ejbModule.getURI());
                object2 = Thread.currentThread();
                ClassLoader classLoader = ((Thread)object2).getContextClassLoader();
                try {
                    ((Thread)object2).setContextClassLoader(beanInfo.getClassLoader());
                    linkedList5.addAll(beanInfo.getAllServiceReferences());
                    environmentBuilder.addServiceReferences(linkedList5, beanInfo.getAllServiceReferenceDescriptions(), null, this.ejbModule.getURI());
                    var16_15 = null;
                    ((Thread)object2).setContextClassLoader(classLoader);
                }
                catch (Throwable throwable) {
                    var16_15 = null;
                    ((Thread)object2).setContextClassLoader(classLoader);
                    throw throwable;
                }
                var18_16 = null;
            }
            catch (Throwable throwable) {
                var18_16 = null;
                EJBRuntimeUtils.popEnvironment();
                throw throwable;
            }
            EJBRuntimeUtils.popEnvironment();
            {
            }
        }
    }

    final void deactivateEnvironment(BeanInfo beanInfo, EnvironmentBuilder environmentBuilder) throws NamingException {
        if (environmentBuilder != null) {
            LinkedList<ResourceRefBean> linkedList = new LinkedList<ResourceRefBean>();
            LinkedList<Object> linkedList2 = new LinkedList<Object>();
            LinkedList<MessageDestinationRefBean> linkedList3 = new LinkedList<MessageDestinationRefBean>();
            LinkedList<ServiceRefBean> linkedList4 = new LinkedList<ServiceRefBean>();
            String string = beanInfo.getEJBName();
            List list = this.dinfo.getInterceptorBeans(string);
            for (InterceptorBean interceptorBean : list) {
                linkedList.addAll(Arrays.asList(interceptorBean.getResourceRefs()));
                linkedList2.addAll(Arrays.asList(interceptorBean.getEjbRefs()));
                linkedList2.addAll(Arrays.asList(interceptorBean.getEjbLocalRefs()));
                linkedList3.addAll(Arrays.asList(interceptorBean.getMessageDestinationRefs()));
                linkedList4.addAll(Arrays.asList(interceptorBean.getServiceRefs()));
            }
            linkedList2.addAll(beanInfo.getAllEJBReferences());
            linkedList2.addAll(beanInfo.getAllEJBLocalReferences());
            environmentBuilder.removeEJBReferences(linkedList2);
            linkedList3.addAll(beanInfo.getAllMessageDestinationReferences());
            environmentBuilder.removeMessageDestinationReferences(linkedList3);
            linkedList4.addAll(beanInfo.getAllServiceReferences());
            environmentBuilder.removeServiceReferences(linkedList4);
            linkedList.addAll(beanInfo.getAllResourceReferences());
            environmentBuilder.removeResourceReferences(linkedList);
        }
    }

    final void setIsDeployed(boolean bl) {
        if (this.deployedManagers != null) {
            for (BeanManager beanManager : this.deployedManagers.getNoneMdbManagers()) {
                beanManager.setIsDeployed(bl);
            }
            for (BeanManager beanManager : this.deployedManagers.getMdbManagers()) {
                beanManager.setIsDeployed(bl);
            }
        }
    }

    final void deactivate() {
        Object object2;
        this.removeSupplementalPolicyObject();
        if (this.dinfo != null) {
            this.unDeployRoles();
        }
        if (this.helper != null) {
            this.helper.deactivate();
        }
        if (this.dinfo != null) {
            for (BeanInfo object2 : this.dinfo.getBeanInfos()) {
                if (!(object2 instanceof MessageDrivenBeanInfo)) continue;
                this.deployedManagers.addManager(object2);
            }
        }
        for (MessageDrivenManagerIntf messageDrivenManagerIntf : this.deployedManagers.getMdbManagers()) {
            messageDrivenManagerIntf.undeploy();
            if (!messageDrivenManagerIntf.subscriptionDeletionRequired()) continue;
            this.subscriptionDeleteList.add(messageDrivenManagerIntf);
        }
        this.setIsDeployed(false);
        if (this.dinfo != null) {
            for (BeanInfo beanInfo : this.dinfo.getBeanInfos()) {
                try {
                    object2 = (EnvironmentBuilder)this.eBuilderMap.get(beanInfo.getEJBName());
                    this.deactivateEnvironment(beanInfo, (EnvironmentBuilder)object2);
                }
                catch (NamingException namingException) {}
            }
        }
        if (this.deployedManagers != null) {
            for (BeanManager beanManager : this.deployedManagers.getNoneMdbManagers()) {
                beanManager.undeploy();
            }
            this.deployedManagers.removeAll();
        }
        for (BeanInfo beanInfo : this.dinfo.getBeanInfos()) {
            if (!(beanInfo instanceof MessageDrivenBeanInfo) || !((MessageDrivenBeanInfo)beanInfo).getIsWeblogicJMS()) continue;
            object2 = (MessageDrivenBeanInfo)beanInfo;
            object2.unRegister();
        }
        this.unregisterMBeans();
        for (Object object2 : this.deployListeners) {
            object2.deactivate();
        }
    }

    public void unprepare() {
        if (this.dinfo != null) {
            for (BeanInfo beanInfo : this.dinfo.getBeanInfos()) {
                beanInfo.unprepare();
            }
        }
    }

    void remove() {
        Iterator<MessageDrivenManagerIntf> iterator = this.subscriptionDeleteList.iterator();
        while (iterator.hasNext()) {
            iterator.next().remove();
            iterator.remove();
        }
    }

    public void removeEJBTimers() {
        if (this.dinfo != null) {
            for (BeanInfo beanInfo : this.dinfo.getBeanInfos()) {
                if (!beanInfo.isTimerDriven()) continue;
                EJBTimerManagerFactory.removeAllTimers(beanInfo);
            }
        }
    }

    private void cleanupAppContext(BeanInfo beanInfo, Context context) throws NamingException {
        String string = J2EEUtils.normalizeJarName(this.ejbModule.getURI());
        Context context2 = null;
        try {
            context2 = (Context)context.lookup("ejb");
        }
        catch (NamingException namingException) {
            EJBLogger.logStackTrace((Throwable)namingException);
        }
        String string2 = beanInfo.getEJBName();
        try {
            Context context3 = (Context)context2.lookup(string + "#" + string2);
            if (beanInfo instanceof ClientDrivenBeanInfo) {
                ClientDrivenBeanInfo clientDrivenBeanInfo = (ClientDrivenBeanInfo)beanInfo;
                clientDrivenBeanInfo.unbindEJBRefs(context3);
            }
        }
        catch (NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
    }

    private String[] getDeploymentPaths() {
        String[] stringArray = new String[]{this.getCanonicalPath(this.jarFilePath), this.outputDirPath != null ? this.getCanonicalPath(this.outputDirPath) : this.getEJBCompilerCache().getAbsolutePath()};
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || File.separatorChar != '\\') continue;
            stringArray[i] = stringArray[i].replace(File.separatorChar, '/');
        }
        return stringArray;
    }

    private String getCanonicalPath(String string) {
        String string2 = null;
        if (string != null) {
            string2 = new File(string).getAbsolutePath();
        }
        return string2;
    }

    public String getObjectSchemaName() {
        return this.objectSchemaName;
    }

    public void setObjectSchemaName(String string) {
        this.objectSchemaName = string;
    }

    public Map getDataBeansMap() {
        return this.dataBeansMap;
    }

    public void setDataBeansMap(Map map) {
        this.dataBeansMap = map;
    }

    private static void debug(String string) {
        debugLogger.debug("[EJBDeployer] " + string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DeployedManagers {
        private List<BeanManager> noneMdbManagers = new LinkedList<BeanManager>();
        private List<MessageDrivenManagerIntf> mdbManagers = new LinkedList<MessageDrivenManagerIntf>();
        private boolean hasMDBs = false;

        DeployedManagers() {
        }

        List<BeanManager> getNoneMdbManagers() {
            return this.noneMdbManagers;
        }

        List<MessageDrivenManagerIntf> getMdbManagers() {
            return this.mdbManagers;
        }

        void addManager(BeanInfo beanInfo) {
            if (beanInfo instanceof MessageDrivenBeanInfo) {
                this.mdbManagers.addAll(((MessageDrivenBeanInfo)beanInfo).getMDManagerList());
            } else if (beanInfo instanceof ClientDrivenBeanInfo) {
                this.noneMdbManagers.add(beanInfo.getBeanManager());
            } else {
                throw new AssertionError("Unexpected BeanInfo type: " + beanInfo.getClass().getName());
            }
        }

        void removeMdbManagers() {
            this.mdbManagers.clear();
        }

        void removeAll() {
            this.noneMdbManagers.clear();
            this.mdbManagers.clear();
        }

        boolean hasMDBs() {
            return this.hasMDBs;
        }
    }
}

