/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.deployer;

import java.io.File;
import weblogic.application.Deployment;
import weblogic.application.Module;
import weblogic.application.internal.SingleModuleDeployment;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.ejb.container.deployer.EJBModule;
import weblogic.management.DeploymentException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.ComponentMBean;

public final class EJBDeployment
extends SingleModuleDeployment
implements Deployment {
    public EJBDeployment(AppDeploymentMBean appDeploymentMBean, File file) throws DeploymentException {
        super(appDeploymentMBean, EJBDeployment.createModule(appDeploymentMBean), file);
    }

    private static Module createModule(AppDeploymentMBean appDeploymentMBean) throws DeploymentException {
        ComponentMBean[] componentMBeanArray = appDeploymentMBean.getAppMBean().getComponents();
        if (componentMBeanArray == null || componentMBeanArray.length == 0) {
            throw new DeploymentException("Application " + ApplicationVersionUtils.getDisplayName(appDeploymentMBean) + " does not have any Components in it.");
        }
        if (componentMBeanArray.length > 1) {
            throw new DeploymentException("Application " + ApplicationVersionUtils.getDisplayName(appDeploymentMBean) + " is a JAR file, but it contains > 1 component.");
        }
        return new EJBModule(componentMBeanArray[0].getURI());
    }
}

