/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.deployer;

import java.io.File;
import java.io.IOException;
import weblogic.application.ComponentMBeanFactory;
import weblogic.application.Deployment;
import weblogic.application.DeploymentFactory;
import weblogic.application.internal.BaseComponentMBeanFactory;
import weblogic.ejb.container.deployer.EJBDeployment;
import weblogic.ejb.spi.EJBJarUtils;
import weblogic.management.DeploymentException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.ApplicationMBean;
import weblogic.management.configuration.ComponentMBean;
import weblogic.management.configuration.SystemResourceMBean;
import weblogic.utils.Debug;

public final class EJBDeploymentFactory
extends BaseComponentMBeanFactory
implements DeploymentFactory,
ComponentMBeanFactory {
    private void s(String string) {
        Debug.say((String)("\n '" + string + "'\n"));
    }

    private boolean isEJB(File file) throws IOException {
        return EJBJarUtils.isEJB(file);
    }

    public Deployment createDeployment(AppDeploymentMBean appDeploymentMBean, File file) throws DeploymentException {
        try {
            return this.isEJB(file) ? new EJBDeployment(appDeploymentMBean, file) : null;
        }
        catch (IOException iOException) {
            throw new DeploymentException(iOException);
        }
    }

    public Deployment createDeployment(SystemResourceMBean systemResourceMBean, File file) throws DeploymentException {
        return null;
    }

    public ComponentMBean[] findOrCreateComponentMBeans(ApplicationMBean applicationMBean, File file, AppDeploymentMBean appDeploymentMBean) throws DeploymentException {
        try {
            if (!this.isEJB(file)) {
                return null;
            }
            String string = file.getName();
            String string2 = this.removeExtension(string);
            if (appDeploymentMBean != null) {
                string2 = this.getCompatibilityName(string2, appDeploymentMBean);
            }
            return new ComponentMBean[]{this.findOrCreateComponentMBean(EJB_COMP, applicationMBean, string2, string)};
        }
        catch (IOException iOException) {
            throw new DeploymentException(iOException);
        }
    }
}

