/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.deployer;

import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.zip.ZipEntry;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.cmp11.rdbms.Deployer;
import weblogic.ejb.container.compliance.EJBComplianceTextFormatter;
import weblogic.ejb.container.persistence.InstalledPersistence;
import weblogic.ejb.container.persistence.PersistenceType;
import weblogic.ejb.container.persistence.spi.CMPDeployer;
import weblogic.ejb.spi.EjbDescriptorBean;
import weblogic.ejb.spi.EjbDescriptorFactory;
import weblogic.j2ee.descriptor.EnterpriseBeanBean;
import weblogic.j2ee.descriptor.EnterpriseBeansBean;
import weblogic.j2ee.descriptor.EntityBeanBean;
import weblogic.j2ee.descriptor.MessageDrivenBeanBean;
import weblogic.j2ee.descriptor.SessionBeanBean;
import weblogic.j2ee.descriptor.wl.EntityDescriptorBean;
import weblogic.j2ee.descriptor.wl.PersistenceBean;
import weblogic.j2ee.descriptor.wl.PersistenceUseBean;
import weblogic.j2ee.descriptor.wl.WeblogicEnterpriseBeanBean;
import weblogic.j2ee.descriptor.wl.WeblogicRdbmsBeanBean;
import weblogic.j2ee.descriptor.wl60.WeblogicRdbmsJarBean;
import weblogic.management.descriptors.XMLElementMBean;
import weblogic.utils.StackTraceUtils;
import weblogic.utils.jars.VirtualJarFile;
import weblogic.xml.process.ProcessorFactory;
import weblogic.xml.process.XMLParsingException;
import weblogic.xml.process.XMLProcessingException;

public final class EJBDescriptorMBeanUtils {
    private static EJBComplianceTextFormatter fmt = new EJBComplianceTextFormatter();
    static final String WLPersistence = "WebLogic_CMP_RDBMS";
    private static ProcessorFactory procFac = new ProcessorFactory();

    public static EjbDescriptorBean createDescriptorFromJarFile(VirtualJarFile virtualJarFile) throws Exception {
        return EJBDescriptorMBeanUtils.createDescriptorFromJarFile(virtualJarFile, false);
    }

    public static EjbDescriptorBean createDescriptorFromJarFile(VirtualJarFile virtualJarFile, boolean bl) throws Exception {
        EjbDescriptorBean ejbDescriptorBean;
        block8: {
            ejbDescriptorBean = new EjbDescriptorBean();
            ejbDescriptorBean.setJarFileName(virtualJarFile.getName());
            ProcessorFactory processorFactory = new ProcessorFactory();
            processorFactory.setValidating(bl);
            Object var4_4 = null;
            try {
                ejbDescriptorBean = EjbDescriptorFactory.createDescriptorFromJarFile(virtualJarFile);
                EJBDescriptorMBeanUtils.loadWeblogicRDBMSJarMBeans(ejbDescriptorBean, virtualJarFile, processorFactory, bl);
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (bl) {
                    throw fileNotFoundException;
                }
            }
            catch (XMLParsingException xMLParsingException) {
                ejbDescriptorBean.setParsingErrorMessage(xMLParsingException.toString());
                if (bl) {
                    throw xMLParsingException;
                }
            }
            catch (XMLProcessingException xMLProcessingException) {
                ejbDescriptorBean.setParsingErrorMessage(xMLProcessingException.toString());
                if (bl) {
                    throw xMLProcessingException;
                }
            }
            catch (Exception exception) {
                String string = StackTraceUtils.throwable2StackTrace((Throwable)exception);
                ejbDescriptorBean.setParsingErrorMessage(string);
                if (!bl) break block8;
                throw exception;
            }
        }
        return ejbDescriptorBean;
    }

    public static void loadWeblogicRDBMSJarMBeans(EjbDescriptorBean ejbDescriptorBean, VirtualJarFile virtualJarFile, ProcessorFactory processorFactory, boolean bl) throws Exception {
        HashSet<String> hashSet = new HashSet<String>();
        Set set = EJBDescriptorMBeanUtils.getEJBNames(ejbDescriptorBean);
        for (String string : set) {
            String string2;
            PersistenceBean persistenceBean = EJBDescriptorMBeanUtils.getPersistenceMBean(string, ejbDescriptorBean);
            if (persistenceBean == null || persistenceBean.getPersistenceUse() == null || !WLPersistence.equals(string2 = persistenceBean.getPersistenceUse().getTypeIdentifier())) continue;
            String string3 = persistenceBean.getPersistenceUse().getTypeVersion();
            String string4 = EJBDescriptorMBeanUtils.getRDBMSDescriptorFileName(persistenceBean);
            if (string4 == null || hashSet.contains(string4)) continue;
            EJBDescriptorMBeanUtils.loadRDBMSDescriptor(ejbDescriptorBean, virtualJarFile, string, string4, string3, processorFactory, bl);
            hashSet.add(string4);
        }
    }

    public static Set getCMPEJBNames(EjbDescriptorBean ejbDescriptorBean) {
        EnterpriseBeansBean enterpriseBeansBean;
        HashSet<String> hashSet = new HashSet<String>();
        if (ejbDescriptorBean.getEjbJarBean() != null && (enterpriseBeansBean = ejbDescriptorBean.getEjbJarBean().getEnterpriseBeans()) != null) {
            EntityBeanBean[] entityBeanBeanArray = enterpriseBeansBean.getEntities();
            for (int i = 0; i < entityBeanBeanArray.length; ++i) {
                if (!"Container".equals(entityBeanBeanArray[i].getPersistenceType()) || entityBeanBeanArray[i].getEjbName() == null) continue;
                hashSet.add(entityBeanBeanArray[i].getEjbName());
            }
        }
        return hashSet;
    }

    public static Set getEJBNames(EjbDescriptorBean ejbDescriptorBean) {
        EnterpriseBeansBean enterpriseBeansBean;
        HashSet<String> hashSet = new HashSet<String>();
        if (ejbDescriptorBean.getEjbJarBean() != null && (enterpriseBeansBean = ejbDescriptorBean.getEjbJarBean().getEnterpriseBeans()) != null) {
            EntityBeanBean[] entityBeanBeanArray = enterpriseBeansBean.getEntities();
            for (int i = 0; i < entityBeanBeanArray.length; ++i) {
                hashSet.add(entityBeanBeanArray[i].getEjbName());
            }
            SessionBeanBean[] sessionBeanBeanArray = enterpriseBeansBean.getSessions();
            for (int i = 0; i < sessionBeanBeanArray.length; ++i) {
                hashSet.add(sessionBeanBeanArray[i].getEjbName());
            }
            MessageDrivenBeanBean[] messageDrivenBeanBeanArray = enterpriseBeansBean.getMessageDrivens();
            for (int i = 0; i < messageDrivenBeanBeanArray.length; ++i) {
                hashSet.add(messageDrivenBeanBeanArray[i].getEjbName());
            }
        }
        return hashSet;
    }

    public static WeblogicEnterpriseBeanBean getWeblogicEnterpriseMBean(String string, EjbDescriptorBean ejbDescriptorBean) {
        WeblogicEnterpriseBeanBean[] weblogicEnterpriseBeanBeanArray;
        if (ejbDescriptorBean.getWeblogicEjbJarBean() != null && (weblogicEnterpriseBeanBeanArray = ejbDescriptorBean.getWeblogicEjbJarBean().getWeblogicEnterpriseBeans()) != null) {
            for (int i = 0; i < weblogicEnterpriseBeanBeanArray.length; ++i) {
                if (!string.equals(weblogicEnterpriseBeanBeanArray[i].getEjbName())) continue;
                return weblogicEnterpriseBeanBeanArray[i];
            }
        }
        return null;
    }

    public static EnterpriseBeanBean getEnterpriseMBean(String string, EjbDescriptorBean ejbDescriptorBean) {
        EnterpriseBeansBean enterpriseBeansBean;
        if (ejbDescriptorBean.getEjbJarBean() != null && (enterpriseBeansBean = ejbDescriptorBean.getEjbJarBean().getEnterpriseBeans()) != null) {
            SessionBeanBean[] sessionBeanBeanArray = enterpriseBeansBean.getSessions();
            for (int i = 0; i < sessionBeanBeanArray.length; ++i) {
                if (!string.equals(sessionBeanBeanArray[i].getEjbName())) continue;
                return sessionBeanBeanArray[i];
            }
            EntityBeanBean[] entityBeanBeanArray = enterpriseBeansBean.getEntities();
            for (int i = 0; i < entityBeanBeanArray.length; ++i) {
                if (!string.equals(entityBeanBeanArray[i].getEjbName())) continue;
                return entityBeanBeanArray[i];
            }
            MessageDrivenBeanBean[] messageDrivenBeanBeanArray = enterpriseBeansBean.getMessageDrivens();
            for (int i = 0; i < messageDrivenBeanBeanArray.length; ++i) {
                if (!string.equals(messageDrivenBeanBeanArray[i].getEjbName())) continue;
                return messageDrivenBeanBeanArray[i];
            }
        }
        return null;
    }

    static void loadRDBMSDescriptor(EjbDescriptorBean ejbDescriptorBean, VirtualJarFile virtualJarFile, String string, String string2, String string3, ProcessorFactory processorFactory, boolean bl) throws Exception {
        ZipEntry zipEntry = virtualJarFile.getEntry(string2);
        if (zipEntry == null) {
            EJBLogger.logCouldNotFindSpecifiedRDBMSDescriptorInJarFile((String)string, (String)string2, (String)virtualJarFile.getName());
            if (bl) {
                throw new FileNotFoundException(fmt.cmpFileNotFound(string, string2, virtualJarFile.getName()));
            }
        } else {
            InstalledPersistence installedPersistence = new InstalledPersistence();
            PersistenceType persistenceType = installedPersistence.getInstalledType(WLPersistence, string3);
            if (persistenceType != null) {
                CMPDeployer cMPDeployer = persistenceType.getCmpDeployer();
                if (cMPDeployer instanceof weblogic.ejb.container.cmp.rdbms.Deployer) {
                    weblogic.ejb.container.cmp.rdbms.Deployer deployer = (weblogic.ejb.container.cmp.rdbms.Deployer)cMPDeployer;
                    EJBDescriptorMBeanUtils.loadRDBMS20Descriptor(ejbDescriptorBean, deployer, virtualJarFile, string2, processorFactory);
                } else if (cMPDeployer instanceof Deployer) {
                    Deployer deployer = (Deployer)cMPDeployer;
                    EJBDescriptorMBeanUtils.loadRDBMS11Descriptor(ejbDescriptorBean, deployer, virtualJarFile, string2, string, processorFactory);
                }
            }
        }
    }

    static void loadRDBMS20Descriptor(EjbDescriptorBean ejbDescriptorBean, weblogic.ejb.container.cmp.rdbms.Deployer deployer, VirtualJarFile virtualJarFile, String string, ProcessorFactory processorFactory) throws Exception {
        weblogic.j2ee.descriptor.wl.WeblogicRdbmsJarBean weblogicRdbmsJarBean = deployer.parseXMLFile(virtualJarFile, string, ejbDescriptorBean);
    }

    static void loadRDBMS11Descriptor(EjbDescriptorBean ejbDescriptorBean, Deployer deployer, VirtualJarFile virtualJarFile, String string, String string2, ProcessorFactory processorFactory) throws Exception {
        deployer.parseXMLFile(virtualJarFile, string, string2, processorFactory, ejbDescriptorBean);
    }

    public static PersistenceBean getPersistenceMBean(String string, EjbDescriptorBean ejbDescriptorBean) {
        PersistenceBean persistenceBean;
        EntityDescriptorBean entityDescriptorBean;
        WeblogicEnterpriseBeanBean weblogicEnterpriseBeanBean = EJBDescriptorMBeanUtils.getWeblogicEnterpriseMBean(string, ejbDescriptorBean);
        if (weblogicEnterpriseBeanBean != null && weblogicEnterpriseBeanBean.getEntityDescriptor() != null && (entityDescriptorBean = weblogicEnterpriseBeanBean.getEntityDescriptor()).getPersistence() != null && (persistenceBean = entityDescriptorBean.getPersistence()) != null) {
            return persistenceBean;
        }
        return null;
    }

    public static String getRDBMSDescriptorFileName(PersistenceBean persistenceBean) {
        PersistenceUseBean persistenceUseBean = persistenceBean.getPersistenceUse();
        if (persistenceUseBean != null) {
            return persistenceUseBean.getTypeStorage();
        }
        return null;
    }

    public static String getRDBMSDescriptorFileName(WeblogicRdbmsJarBean weblogicRdbmsJarBean, EjbDescriptorBean ejbDescriptorBean) {
        PersistenceBean persistenceBean;
        String string;
        String string2 = "weblogic-cmp-rdbms-jar.xml";
        weblogic.j2ee.descriptor.wl60.WeblogicRdbmsBeanBean[] weblogicRdbmsBeanBeanArray = weblogicRdbmsJarBean.getWeblogicRdbmsBeans();
        if (weblogicRdbmsBeanBeanArray.length >= 1 && (string = weblogicRdbmsBeanBeanArray[0].getEjbName()) != null && (persistenceBean = EJBDescriptorMBeanUtils.getPersistenceMBean(string, ejbDescriptorBean)) != null) {
            return EJBDescriptorMBeanUtils.getRDBMSDescriptorFileName(persistenceBean);
        }
        return string2;
    }

    public static String getRDBMSDescriptorFileName(weblogic.j2ee.descriptor.wl.WeblogicRdbmsJarBean weblogicRdbmsJarBean, EjbDescriptorBean ejbDescriptorBean) {
        PersistenceBean persistenceBean;
        String string;
        String string2 = "weblogic-cmp-rdbms-jar.xml";
        WeblogicRdbmsBeanBean[] weblogicRdbmsBeanBeanArray = weblogicRdbmsJarBean.getWeblogicRdbmsBeans();
        if (weblogicRdbmsBeanBeanArray.length >= 1 && (string = weblogicRdbmsBeanBeanArray[0].getEjbName()) != null && (persistenceBean = EJBDescriptorMBeanUtils.getPersistenceMBean(string, ejbDescriptorBean)) != null) {
            return EJBDescriptorMBeanUtils.getRDBMSDescriptorFileName(persistenceBean);
        }
        return string2;
    }

    public static boolean areIdenticalMBeans(XMLElementMBean xMLElementMBean, XMLElementMBean xMLElementMBean2) {
        boolean bl = true;
        if (xMLElementMBean == null && xMLElementMBean2 != null || xMLElementMBean != null && xMLElementMBean2 == null) {
            return false;
        }
        Method[] methodArray = xMLElementMBean.getClass().getDeclaredMethods();
        LinkedList<Method> linkedList = new LinkedList<Method>();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            if (!method.getName().startsWith("get") && !method.getName().startsWith("is")) continue;
            linkedList.add(method);
        }
        for (Method method : linkedList) {
            try {
                Object object = method.invoke((Object)xMLElementMBean, new Object[0]);
                Object object2 = method.invoke((Object)xMLElementMBean2, new Object[0]);
                if (method.getReturnType().isAssignableFrom(XMLElementMBean.class)) {
                    bl = bl && EJBDescriptorMBeanUtils.areIdenticalMBeans((XMLElementMBean)object, (XMLElementMBean)object2);
                    continue;
                }
                if (object == null && object2 == null) {
                    bl = true;
                    continue;
                }
                if (object == null && object2 != null || object != null && object2 == null) {
                    bl = false;
                    continue;
                }
                bl = bl && object.equals(object2);
            }
            catch (IllegalAccessException illegalAccessException) {
                EJBLogger.logStackTrace((Throwable)illegalAccessException);
                bl = false;
            }
            catch (InvocationTargetException invocationTargetException) {
                EJBLogger.logStackTrace((Throwable)invocationTargetException);
                bl = false;
            }
        }
        return bl;
    }

    private static void ppp(String string) {
        System.out.println("[EJBDescriptorMBeanUtils] " + string);
    }
}

