/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.deployer;

import com.bea.wls.redef.RedefiningClassLoader;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.xml.stream.XMLStreamException;
import kodo.jdbc.conf.descriptor.PersistenceUnitConfigurationBean;
import weblogic.application.AdminModeCompletionBarrier;
import weblogic.application.ApplicationContext;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.ApplicationFileManager;
import weblogic.application.ConcurrentModule;
import weblogic.application.Module;
import weblogic.application.ModuleException;
import weblogic.application.Type;
import weblogic.application.UpdateListener;
import weblogic.application.internal.BaseJ2EEModule;
import weblogic.application.library.Library;
import weblogic.application.library.LibraryConstants;
import weblogic.application.library.LibraryManager;
import weblogic.application.library.LibraryReferencer;
import weblogic.cacheprovider.coherence.CoherenceClusterManager;
import weblogic.deploy.api.shared.WebLogicModuleType;
import weblogic.deployment.AbstractPersistenceUnitRegistry;
import weblogic.deployment.EnvironmentException;
import weblogic.deployment.ModulePersistenceUnitRegistry;
import weblogic.deployment.PersistenceUnitInfoImpl;
import weblogic.deployment.PersistenceUnitRegistry;
import weblogic.deployment.PersistenceUnitRegistryInitializer;
import weblogic.deployment.PersistenceUnitRegistryProvider;
import weblogic.descriptor.BeanUpdateListener;
import weblogic.descriptor.Descriptor;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorUpdateFailedException;
import weblogic.descriptor.DescriptorUpdateRejectedException;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.container.EJBDebugService;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.dd.DDConstants;
import weblogic.ejb.container.deployer.EJBDeployer;
import weblogic.ejb.container.deployer.EJBDescriptorMBeanUtils;
import weblogic.ejb.container.interfaces.BeanInfo;
import weblogic.ejb.container.interfaces.ClientDrivenBeanInfo;
import weblogic.ejb.container.interfaces.EntityBeanInfo;
import weblogic.ejb.container.interfaces.MessageDrivenBeanInfo;
import weblogic.ejb.container.interfaces.SessionBeanInfo;
import weblogic.ejb.container.internal.EJBComponentRuntimeMBeanImpl;
import weblogic.ejb.spi.EJBDeploymentException;
import weblogic.ejb.spi.EJBJar;
import weblogic.ejb.spi.EjbDescriptorBean;
import weblogic.ejb.spi.EjbDescriptorFactory;
import weblogic.ejb.spi.InvalidationMessage;
import weblogic.ejb.spi.WLDeploymentException;
import weblogic.j2ee.J2EEApplicationRuntimeMBeanImpl;
import weblogic.j2ee.descriptor.ActivationConfigBean;
import weblogic.j2ee.descriptor.ActivationConfigPropertyBean;
import weblogic.j2ee.descriptor.EjbJarBean;
import weblogic.j2ee.descriptor.EjbRefBean;
import weblogic.j2ee.descriptor.EnterpriseBeanBean;
import weblogic.j2ee.descriptor.EnterpriseBeansBean;
import weblogic.j2ee.descriptor.EntityBeanBean;
import weblogic.j2ee.descriptor.MessageDrivenBeanBean;
import weblogic.j2ee.descriptor.SessionBeanBean;
import weblogic.j2ee.descriptor.wl.ApplicationEntityCacheBean;
import weblogic.j2ee.descriptor.wl.AutomaticKeyGenerationBean;
import weblogic.j2ee.descriptor.wl.CoherenceClusterRefBean;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.j2ee.descriptor.wl.EjbBean;
import weblogic.j2ee.descriptor.wl.EntityDescriptorBean;
import weblogic.j2ee.descriptor.wl.PersistenceBean;
import weblogic.j2ee.descriptor.wl.PersistenceUseBean;
import weblogic.j2ee.descriptor.wl.WeblogicApplicationBean;
import weblogic.j2ee.descriptor.wl.WeblogicEjbJarBean;
import weblogic.j2ee.descriptor.wl.WeblogicEnterpriseBeanBean;
import weblogic.j2ee.descriptor.wl.WeblogicRdbmsBeanBean;
import weblogic.j2ee.descriptor.wl.WeblogicRdbmsJarBean;
import weblogic.logging.Loggable;
import weblogic.management.DeploymentException;
import weblogic.management.ManagementException;
import weblogic.management.configuration.EJBComponentMBean;
import weblogic.management.runtime.ComponentRuntimeMBean;
import weblogic.management.runtime.EJBComponentRuntimeMBean;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.WorkManagerRuntimeMBean;
import weblogic.utils.AssertionError;
import weblogic.utils.Debug;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.classloaders.JarClassFinder;
import weblogic.utils.collections.ConcurrentHashMap;
import weblogic.utils.compiler.jdt.JDTJavaCompilerFactory;
import weblogic.utils.jars.VirtualJarFactory;
import weblogic.utils.jars.VirtualJarFile;
import weblogic.work.WorkManagerCollection;
import weblogic.work.WorkManagerRuntimeMBeanImpl;
import weblogic.work.WorkManagerService;
import weblogic.xml.process.ProcessorFactory;
import weblogic.xml.process.XMLParsingException;
import weblogic.xml.process.XMLProcessingException;

public class EJBModule
extends BaseJ2EEModule
implements Module,
UpdateListener,
PersistenceUnitRegistryProvider,
ConcurrentModule {
    private Set<String> ejbInterfaces = new HashSet<String>();
    private static final DebugLogger debugLogger = EJBDebugService.deploymentLogger;
    private static final Map ejbModules = new ConcurrentHashMap();
    private EJBComponentRuntimeMBeanImpl compRTMBean;
    private VirtualJarFile jf;
    private EJBDeployer ejbDeployer;
    private String applicationName;
    private String name;
    private boolean isEnableBeanClassRedeploy = false;
    private final Map implClassToNameMap = new HashMap();
    private final List updateImplClasses = new ArrayList();
    protected GenericClassLoader classLoader;
    private ClassFinder classFinder;
    private String altDD = null;
    protected ApplicationContextInternal appCtx;
    private final String uri;
    private EjbDescriptorBean ejbDescriptor;
    private EjbDescriptorBean proposedDescriptor;
    private EJBJar ejbJar;
    private AbstractPersistenceUnitRegistry persistenceUnitRegistry;
    private AbstractPersistenceUnitRegistry proposedPersistenceUnitRegistry;
    private LibraryManager manager = null;

    public EJBModule(String string) {
        this.uri = string;
    }

    public String getId() {
        return this.uri;
    }

    public String getURI() {
        return this.uri;
    }

    public String getType() {
        return WebLogicModuleType.MODULETYPE_EJB;
    }

    public GenericClassLoader getClassLoader() {
        return this.classLoader;
    }

    public ComponentRuntimeMBean[] getComponentRuntimeMBeans() {
        return new ComponentRuntimeMBean[]{this.compRTMBean};
    }

    public DescriptorBean[] getDescriptors() {
        if (this.ejbDescriptor.getWeblogicEjbJarBean() == null) {
            return new DescriptorBean[]{(DescriptorBean)this.ejbDescriptor.getEjbJarBean()};
        }
        return new DescriptorBean[]{(DescriptorBean)this.ejbDescriptor.getEjbJarBean(), (DescriptorBean)this.ejbDescriptor.getWeblogicEjbJarBean()};
    }

    private ClassFinder buildClassFinder(ApplicationContextInternal applicationContextInternal) throws IOException {
        this.ejbJar = new EJBJar(this.uri, applicationContextInternal);
        ApplicationFileManager applicationFileManager = applicationContextInternal.getApplicationFileManager();
        this.jf = applicationFileManager.getVirtualJarFile(this.uri);
        Debug.assertion((this.jf != null ? 1 : 0) != 0);
        return this.ejbJar.getClassFinder();
    }

    protected void setupPersistenceUnitRegistry() throws DeploymentException {
        try {
            if (this.persistenceUnitRegistry == null) {
                this.persistenceUnitRegistry = new ModulePersistenceUnitRegistry(this.classLoader, this.appCtx, this, true);
            }
        }
        catch (EnvironmentException environmentException) {
            throw new DeploymentException((Throwable)((Object)environmentException));
        }
        catch (MalformedURLException malformedURLException) {
            throw new DeploymentException(malformedURLException);
        }
    }

    private void initMBeans() throws ModuleException {
        EJBComponentMBean eJBComponentMBean = this.getEJBComponent();
        this.name = eJBComponentMBean != null ? eJBComponentMBean.getName() : this.getURI();
        this.applicationName = this.appCtx.getApplicationName();
        try {
            this.compRTMBean = new EJBComponentRuntimeMBeanImpl(this.getName(), this.getId(), (RuntimeMBean)this.appCtx.getRuntime(), this.applicationName);
            if (this.persistenceUnitRegistry != null) {
                this.persistenceUnitRegistry.setParentRuntimeMBean(this.compRTMBean);
            }
        }
        catch (ManagementException managementException) {
            throw new ModuleException("Error creating RuntimeMBean for EJBModule '" + this + "': " + managementException.getMessage(), managementException);
        }
        catch (EnvironmentException environmentException) {
            throw new ModuleException("Error creating RuntimeMBean for EJBModule '" + this + "': " + environmentException.getMessage(), (Throwable)((Object)environmentException));
        }
    }

    private void initJNDIContext() {
        Context context = this.appCtx.getEnvContext();
        try {
            context.lookup("/ejb");
        }
        catch (NameNotFoundException nameNotFoundException) {
            try {
                context.createSubcontext("ejb");
            }
            catch (NamingException namingException) {
                throw new AssertionError((Throwable)namingException);
            }
        }
        catch (NamingException namingException) {
            throw new AssertionError((Throwable)namingException);
        }
    }

    public void initUsingLoader(ApplicationContext applicationContext, GenericClassLoader genericClassLoader, UpdateListener.Registration registration) throws ModuleException {
        this.init(applicationContext, genericClassLoader, registration);
    }

    public GenericClassLoader init(ApplicationContext applicationContext, GenericClassLoader genericClassLoader, UpdateListener.Registration registration) throws ModuleException {
        this.appCtx = (ApplicationContextInternal)applicationContext;
        this.classLoader = genericClassLoader;
        this.initJNDIContext();
        registration.addUpdateListener(this);
        try {
            if (debugLogger.isDebugEnabled()) {
                EJBModule.debug("init() on module : " + this + ".");
            }
            this.classFinder = this.buildClassFinder(this.appCtx);
            this.classLoader.addClassFinder(this.classFinder);
            PersistenceUnitRegistryInitializer persistenceUnitRegistryInitializer = PersistenceUnitRegistryInitializer.getInstance(this.appCtx);
            persistenceUnitRegistryInitializer.addPersistenceUnitRegistryPrepareTask(new PersistenceUnitRegistryInitializer.PersistenceUnitRegistryPrepareTask(){

                public void execute() throws ModuleException {
                    try {
                        EJBModule.this.setupPersistenceUnitRegistry();
                    }
                    catch (DeploymentException deploymentException) {
                        throw new ModuleException((Throwable)((Object)deploymentException));
                    }
                }
            });
            return this.classLoader;
        }
        catch (IOException iOException) {
            throw new ModuleException(iOException);
        }
    }

    public void remove() throws ModuleException {
        if (debugLogger.isDebugEnabled()) {
            EJBModule.debug("remove() on module : " + this + ".");
        }
        JDTJavaCompilerFactory.getInstance().resetCache((ClassLoader)this.getClassLoader());
        if (this.ejbJar != null) {
            this.ejbJar.remove();
        }
        if (this.ejbDeployer != null) {
            this.ejbDeployer.remove();
            this.ejbDeployer.removeEJBTimers();
        }
        this.ejbDeployer = null;
    }

    public void adminToProduction() {
        if (debugLogger.isDebugEnabled()) {
            EJBModule.debug("adminToProduction() on module : " + this + ".");
        }
    }

    public void gracefulProductionToAdmin(AdminModeCompletionBarrier adminModeCompletionBarrier) {
        if (debugLogger.isDebugEnabled()) {
            EJBModule.debug("gracefulProductionToAdmin() on module : " + this + ".");
        }
    }

    public void forceProductionToAdmin() {
        if (debugLogger.isDebugEnabled()) {
            EJBModule.debug("forceProductionToAdmin() on module : " + this + ".");
        }
    }

    public ComponentRuntimeMBean getRuntimeMBean() {
        return this.compRTMBean;
    }

    public final void prepare() throws ModuleException {
        try {
            Object object;
            PersistenceUnitRegistryInitializer persistenceUnitRegistryInitializer = PersistenceUnitRegistryInitializer.getInstance(this.appCtx);
            persistenceUnitRegistryInitializer.setupPersistenceUnitRegistries();
            this.initMBeans();
            this.ejbDescriptor = this.loadEJBDescriptor();
            if (this.classLoader instanceof RedefiningClassLoader) {
                this.fillInterfaceInfoForEJBModule(this.ejbDescriptor);
                this.setupRedefiningClassLoader(this.classLoader);
            }
            if (debugLogger.isDebugEnabled()) {
                EJBModule.debug("prepare() on module : " + this + ".");
            }
            WeblogicEjbJarBean weblogicEjbJarBean = this.ejbDescriptor.getWeblogicEjbJarBean();
            this.isEnableBeanClassRedeploy = weblogicEjbJarBean.isEnableBeanClassRedeploy();
            this.setupEJBToImplClassDependencies((ClassLoader)this.classLoader);
            if (debugLogger.isDebugEnabled()) {
                this.dumpDependencyMaps();
            }
            if (this.isEnableBeanClassRedeploy) {
                object = this.implClassToNameMap.keySet().iterator();
                while (object.hasNext()) {
                    this.classLoader.excludeClass((String)object.next());
                }
            }
            object = this.appCtx.getWorkManagerCollection();
            ((WorkManagerCollection)object).populate(this.getName(), this.ejbDescriptor.getWeblogicEjbJarBean());
            this.addWorkManagerRuntimes(((WorkManagerCollection)object).getWorkManagers(this.getName()));
            this.setupCoherenceCaches();
            this.ejbDeployer = new EJBDeployer(this.appCtx, this, this.compRTMBean);
            this.ejbDeployer.prepare(this.jf, (ClassLoader)this.classLoader, this.ejbDescriptor, this.appCtx.getEnvContext(), this.appCtx.getEJBCacheMap(), this.appCtx.getEJBQueryCacheMap());
        }
        catch (DeploymentException deploymentException) {
            try {
                this.unprepare();
            }
            catch (ModuleException moduleException) {
                EJBLogger.logExcepionUninitializing((String)this.getURI(), (Throwable)((Object)moduleException));
            }
            throw new ModuleException("Exception preparing module: " + this + "\n" + deploymentException.getMessage(), (Throwable)((Object)deploymentException));
        }
    }

    public final void activate() throws IllegalStateException, ModuleException {
        if (debugLogger.isDebugEnabled()) {
            EJBModule.debug("activate() on module : " + this + " : activating module");
        }
        JDTJavaCompilerFactory.getInstance().resetCache((ClassLoader)this.getClassLoader());
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader((ClassLoader)this.classLoader);
        try {
            try {
                this.ejbDeployer.activate(this.ejbDescriptor, (ClassLoader)this.classLoader, this.appCtx.getEnvContext());
            }
            catch (DeploymentException deploymentException) {
                if (debugLogger.isDebugEnabled()) {
                    EJBModule.debug("Error activating module : " + this + " :\n" + deploymentException.getMessage());
                }
                this.doDeactivate();
                throw new ModuleException("Exception activating module: " + this + "\n" + deploymentException.getMessage(), (Throwable)((Object)deploymentException));
            }
            Object var4_2 = null;
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            Thread.currentThread().setContextClassLoader(classLoader);
            throw throwable;
        }
        ejbModules.put(new ModuleKey(this.appCtx.getApplicationId(), this.getName()), this);
        this.registerBeanUpdateListeners();
        this.reconfigPersistenceUnits();
    }

    private void reconfigPersistenceUnits() throws ModuleException {
        PersistenceUnitRegistry persistenceUnitRegistry = this.getPersistenceUnitRegistry();
        if (persistenceUnitRegistry == null) {
            return;
        }
        Collection collection = persistenceUnitRegistry.getPersistenceUnitNames();
        for (String string : collection) {
            PersistenceUnitInfoImpl persistenceUnitInfoImpl = persistenceUnitRegistry.getPersistenceUnit(string);
            try {
                persistenceUnitInfoImpl.activate(this.appCtx.getEnvContext());
            }
            catch (EnvironmentException environmentException) {
                throw new ModuleException("Error activating JPA deployment:", (Throwable)((Object)environmentException));
            }
        }
    }

    private void addWorkManagerRuntimes(List list) throws DeploymentException {
        try {
            Iterator iterator = list.iterator();
            J2EEApplicationRuntimeMBeanImpl j2EEApplicationRuntimeMBeanImpl = this.appCtx.getRuntime();
            while (iterator.hasNext()) {
                WorkManagerRuntimeMBean workManagerRuntimeMBean = WorkManagerRuntimeMBeanImpl.getWorkManagerRuntime(((WorkManagerService)iterator.next()).getDelegate(), j2EEApplicationRuntimeMBeanImpl, this.compRTMBean);
                if (workManagerRuntimeMBean == null) continue;
                this.compRTMBean.addWorkManagerRuntime(workManagerRuntimeMBean);
            }
        }
        catch (ManagementException managementException) {
            throw new DeploymentException("unable to create WorkManagerRuntimeMBean", managementException);
        }
    }

    private boolean startMdbsWithApplication() {
        WeblogicApplicationBean weblogicApplicationBean = this.appCtx.getWLApplicationDD();
        if (weblogicApplicationBean == null) {
            return false;
        }
        EjbBean ejbBean = weblogicApplicationBean.getEjb();
        if (ejbBean == null) {
            return false;
        }
        return ejbBean.isStartMdbsWithApplication();
    }

    public final void start() throws ModuleException {
        if (debugLogger.isDebugEnabled()) {
            EJBModule.debug("start() on module : " + this + " : starting module");
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader((ClassLoader)this.classLoader);
        try {
            try {
                this.ejbDeployer.start(!this.startMdbsWithApplication());
            }
            catch (EJBDeploymentException eJBDeploymentException) {
                throw new ModuleException("Exception starting module: " + this + "\n" + eJBDeploymentException.getMessage(), (Throwable)((Object)eJBDeploymentException));
            }
            Object var4_2 = null;
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            Thread.currentThread().setContextClassLoader(classLoader);
            throw throwable;
        }
    }

    public final void deactivate() throws IllegalStateException, ModuleException {
        if (debugLogger.isDebugEnabled()) {
            EJBModule.debug("deactivate() on module : " + this + ".");
        }
        ejbModules.remove(new ModuleKey(this.appCtx.getApplicationId(), this.getName()));
        this.unregisterBeanUpdateListeners();
        this.doDeactivate();
    }

    public boolean acceptURI(String string) {
        if (!this.acceptModuleUri(this.appCtx, this.uri, string)) {
            EJBModule.debug("acceptURI: does not acceptModuleURI: " + string);
            return false;
        }
        if (this.getEjbDDName(string) != null) {
            EJBModule.debug("getEjbDDName(u) != null: " + string);
            EJBModule.debug("acceptURI: does acceptModuleURI: " + string);
            return true;
        }
        if (this.getPersistenceDDName(string) != null) {
            EJBModule.debug("getPersistenceDDName(u) != null: " + string);
            EJBModule.debug("acceptURI: does acceptModuleURI: " + string);
            return true;
        }
        if (this.findImplClassName(string) != null) {
            EJBModule.debug("findImplClassName(u) != null: " + string);
            EJBModule.debug("acceptURI: does acceptModuleURI: " + string);
            return true;
        }
        EJBModule.debug("acceptURI: none of the cases applies, therefore no acceptance of uri: " + string);
        return false;
    }

    private String findImplClassName(String string) {
        if (!string.endsWith(".class")) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.appCtx.isEar()) {
            stringBuffer.append(string.substring(this.uri.length() + 1));
        } else {
            stringBuffer.append(string);
        }
        stringBuffer.setLength(stringBuffer.length() - 6);
        if (stringBuffer.length() == 0) {
            return null;
        }
        for (int i = 0; i < stringBuffer.length(); ++i) {
            char c = stringBuffer.charAt(i);
            if (c != '\\' && c != '/') continue;
            stringBuffer.setCharAt(i, '.');
        }
        String string2 = stringBuffer.toString();
        if (this.implClassToNameMap.containsKey(string2)) {
            return string2;
        }
        return null;
    }

    private String getEjbDDName(String string) {
        if (!string.endsWith("xml")) {
            return null;
        }
        String string2 = string.replace('\\', '/');
        if (this.appCtx.isEar()) {
            string2 = string2.substring(this.uri.length() + 1);
        }
        if (string2.length() == 0) {
            return null;
        }
        if (string2.equals("META-INF/ejb-jar.xml")) {
            return string2;
        }
        if (string2.equals("META-INF/weblogic-ejb-jar.xml")) {
            return string2;
        }
        WeblogicEjbJarBean weblogicEjbJarBean = this.ejbDescriptor.getWeblogicEjbJarBean();
        if (weblogicEjbJarBean != null) {
            WeblogicEnterpriseBeanBean[] weblogicEnterpriseBeanBeanArray = weblogicEjbJarBean.getWeblogicEnterpriseBeans();
            for (int i = 0; i < weblogicEnterpriseBeanBeanArray.length; ++i) {
                PersistenceUseBean persistenceUseBean;
                PersistenceBean persistenceBean;
                EntityDescriptorBean entityDescriptorBean = weblogicEnterpriseBeanBeanArray[i].getEntityDescriptor();
                if (entityDescriptorBean == null || (persistenceBean = entityDescriptorBean.getPersistence()) == null || (persistenceUseBean = persistenceBean.getPersistenceUse()) == null) continue;
                String string3 = persistenceUseBean.getTypeStorage();
                if (!string2.equals(string3 = string3.replace('\\', '/'))) continue;
                EjbJarBean ejbJarBean = this.ejbDescriptor.getEjbJarBean();
                EnterpriseBeansBean enterpriseBeansBean = ejbJarBean.getEnterpriseBeans();
                EntityBeanBean[] entityBeanBeanArray = enterpriseBeansBean.getEntities();
                for (int j = 0; j < entityBeanBeanArray.length; ++j) {
                    if (!weblogicEnterpriseBeanBeanArray[i].getEjbName().equals(entityBeanBeanArray[j].getEjbName())) continue;
                    String string4 = entityBeanBeanArray[j].getCmpVersion();
                    if (string4.equals("2.x")) {
                        return string2;
                    }
                    return null;
                }
            }
        }
        return null;
    }

    private String getPersistenceDDName(String string) {
        if (!string.endsWith("xml")) {
            return null;
        }
        String string2 = string.replace('\\', '/');
        if (this.appCtx.isEar()) {
            string2 = string2.substring(this.uri.length() + 1);
            EJBModule.debug("getPersistenceDDName: candidate is " + string2);
        }
        if (string2.length() == 0) {
            return null;
        }
        if (string2.equals("META-INF/persistence.xml")) {
            return string2;
        }
        if (string2.equals("META-INF/persistence-configuration.xml")) {
            return string2;
        }
        return null;
    }

    public void prepareUpdate(String string) throws ModuleException {
        if (debugLogger.isDebugEnabled()) {
            EJBModule.debug("prepareUpdate called for app: " + this.appCtx.getApplicationName() + " uri: " + this.uri);
        }
        if (string.endsWith(".xml")) {
            this.prepareDescriptorUpdate(string);
            return;
        }
        this.updateImplClasses.clear();
        String string2 = this.findImplClassName(string);
        if (string2 != null) {
            this.updateImplClasses.add(string2);
        }
        if (this.updateImplClasses.isEmpty()) {
            return;
        }
        if (!this.isEnableBeanClassRedeploy) {
            EJBLogger.logEJBModuleRolledBackSinceImplCLDisabled((String)this.getDisplayName(), (String)((String)this.updateImplClasses.get(0)));
            throw new ModuleException("Unable to update bean implementation class for EJB " + string + " since enable-bean-class-redeploy was not" + " enabled in the weblogic-ejb-jar.xml");
        }
        GenericClassLoader genericClassLoader = new GenericClassLoader(this.classFinder);
        try {
            String string3 = this.ejbDeployer.needsRecompile(this.updateImplClasses, (ClassLoader)genericClassLoader);
            if (string3 != null) {
                EJBLogger.logEJBModuleRolledBackSinceChangeIncompatible((String)this.getDisplayName(), (String)string3);
                if (debugLogger.isDebugEnabled()) {
                    EJBModule.debug("needsRecompile returned: " + string3);
                }
                throw new ModuleException("Attempt to update EJB implementation class in EJB " + string + " failed because " + string3 + "requires weblogic.appc to be run.  You must redeploy " + "the application.");
            }
            if (debugLogger.isDebugEnabled()) {
                EJBModule.debug("needsRecompile returned false");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (debugLogger.isDebugEnabled()) {
                EJBModule.debug("ClassNotFoundException during needsRecompile: " + classNotFoundException);
                classNotFoundException.printStackTrace();
            }
            throw new ModuleException(classNotFoundException);
        }
    }

    public void activateUpdate(String string) throws ModuleException {
        if (debugLogger.isDebugEnabled()) {
            EJBModule.debug("activateUpdate() on module : " + this + ".");
        }
        if (string.endsWith(".xml")) {
            this.activateDescriptorUpdate(string);
            return;
        }
        if (this.updateImplClasses.isEmpty()) {
            return;
        }
        if (debugLogger.isDebugEnabled()) {
            EJBModule.debug("Updating beanImpl ClassLoader for EJBs:");
        }
        Iterator iterator = this.updateImplClasses.iterator();
        HashSet hashSet = new HashSet();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            hashSet.addAll((List)this.implClassToNameMap.get(string2));
        }
        for (String string3 : hashSet) {
            if (debugLogger.isDebugEnabled()) {
                EJBModule.debug(string3);
            }
            try {
                this.ejbDeployer.updateImplClassLoader(string3);
            }
            catch (WLDeploymentException wLDeploymentException) {
                throw new ModuleException("Module :" + string + " cannot be redeployed: " + wLDeploymentException);
            }
        }
    }

    public void rollbackUpdate(String string) {
        if (debugLogger.isDebugEnabled()) {
            EJBModule.debug("rollbackUpdate() on module : " + this + ".");
        }
        if (string.endsWith(".xml")) {
            this.rollbackDescriptorUpdate(string);
            return;
        }
    }

    private Descriptor getDescriptor(EjbDescriptorBean ejbDescriptorBean, String string) {
        if (string.equals("META-INF/ejb-jar.xml")) {
            return ((DescriptorBean)ejbDescriptorBean.getEjbJarBean()).getDescriptor();
        }
        if (string.equals("META-INF/weblogic-ejb-jar.xml")) {
            return ((DescriptorBean)ejbDescriptorBean.getWeblogicEjbJarBean()).getDescriptor();
        }
        return ((DescriptorBean)ejbDescriptorBean.getWeblogicRdbmsJarBean(string)).getDescriptor();
    }

    private void prepareDescriptorUpdate(String string) throws ModuleException {
        String string2 = this.getEjbDDName(string);
        EJBModule.debug("prepareDescriptorUpdate: EJB descriptorName = " + string2);
        if (string2 != null) {
            String string3;
            if (this.proposedDescriptor == null) {
                this.proposedDescriptor = this.loadEJBDescriptor();
            }
            if (!string2.equals("META-INF/ejb-jar.xml") && !string2.equals("META-INF/weblogic-ejb-jar.xml")) {
                string3 = "6.0";
                try {
                    ProcessorFactory processorFactory = new ProcessorFactory();
                    EJBDescriptorMBeanUtils.loadRDBMSDescriptor(this.proposedDescriptor, this.jf, string2, string2, string3, processorFactory, true);
                }
                catch (Exception exception) {
                    throw new ModuleException(exception);
                }
            }
            try {
                string3 = this.getDescriptor(this.ejbDescriptor, string2);
                string3.prepareUpdate(this.getDescriptor(this.proposedDescriptor, string2));
            }
            catch (DescriptorUpdateRejectedException descriptorUpdateRejectedException) {
                throw new ModuleException(descriptorUpdateRejectedException);
            }
        }
        string2 = this.getPersistenceDDName(string);
        EJBModule.debug("prepareDescriptorUpdate: persistence descriptorName = " + string2);
        assert (string2 != null);
        if (this.proposedPersistenceUnitRegistry == null) {
            try {
                this.proposedPersistenceUnitRegistry = new ModulePersistenceUnitRegistry(this.classLoader, this.appCtx, this, false);
            }
            catch (EnvironmentException environmentException) {
                throw new ModuleException((Throwable)((Object)environmentException));
            }
            catch (MalformedURLException malformedURLException) {
                throw new ModuleException(malformedURLException);
            }
        }
        try {
            ModulePersistenceUnitRegistry modulePersistenceUnitRegistry = (ModulePersistenceUnitRegistry)this.getPersistenceUnitRegistry();
            Descriptor descriptor = modulePersistenceUnitRegistry.getDescriptor(string2);
            modulePersistenceUnitRegistry = (ModulePersistenceUnitRegistry)this.getProposedPersistenceUnitRegistry();
            descriptor.prepareUpdate(modulePersistenceUnitRegistry.getDescriptor(string2));
        }
        catch (DescriptorUpdateRejectedException descriptorUpdateRejectedException) {
            throw new ModuleException(descriptorUpdateRejectedException);
        }
    }

    private void activateDescriptorUpdate(String string) throws ModuleException {
        String string2 = this.getEjbDDName(string);
        if (string2 != null) {
            this.proposedDescriptor = null;
            Descriptor descriptor = this.getDescriptor(this.ejbDescriptor, string2);
            try {
                descriptor.activateUpdate();
            }
            catch (DescriptorUpdateFailedException descriptorUpdateFailedException) {
                throw new ModuleException(descriptorUpdateFailedException);
            }
        }
        string2 = this.getPersistenceDDName(string);
        assert (string2 != null);
        this.proposedPersistenceUnitRegistry = null;
        ModulePersistenceUnitRegistry modulePersistenceUnitRegistry = (ModulePersistenceUnitRegistry)this.getPersistenceUnitRegistry();
        Descriptor descriptor = modulePersistenceUnitRegistry.getDescriptor(string2);
        try {
            descriptor.activateUpdate();
        }
        catch (DescriptorUpdateFailedException descriptorUpdateFailedException) {
            throw new ModuleException(descriptorUpdateFailedException);
        }
    }

    private void rollbackDescriptorUpdate(String string) {
        String string2 = this.getEjbDDName(string);
        if (string2 != null) {
            this.proposedDescriptor = null;
            Descriptor descriptor = this.getDescriptor(this.ejbDescriptor, string2);
            descriptor.rollbackUpdate();
        } else {
            string2 = this.getPersistenceDDName(string);
            assert (string2 != null);
            this.proposedPersistenceUnitRegistry = null;
            ModulePersistenceUnitRegistry modulePersistenceUnitRegistry = (ModulePersistenceUnitRegistry)this.getPersistenceUnitRegistry();
            Descriptor descriptor = modulePersistenceUnitRegistry.getDescriptor(string2);
            descriptor.rollbackUpdate();
        }
    }

    public void invalidate(InvalidationMessage invalidationMessage) {
        this.ejbDeployer.invalidate(invalidationMessage);
    }

    public String getObjectSchemaName() {
        return this.ejbDeployer.getObjectSchemaName();
    }

    public Map getDataBeansMap() {
        return this.ejbDeployer.getDataBeansMap();
    }

    public String toString() {
        String string = this.name == null ? this.getURI() : this.name;
        return "EJBModule(" + string + ")";
    }

    protected EjbDescriptorBean loadEJBDescriptor() throws ModuleException {
        Library[] libraryArray;
        File file = this.resolveAltDD(this.appCtx, this.uri);
        DeploymentPlanBean deploymentPlanBean = this.appCtx.findDeploymentPlan();
        File file2 = null;
        if (deploymentPlanBean != null && (libraryArray = this.appCtx.getAppDeploymentMBean()).getPlanDir() != null) {
            file2 = new File(libraryArray.getLocalPlanDir());
        }
        Debug.assertion((this.jf != null ? 1 : 0) != 0);
        try {
            if (this.manager == null) {
                this.manager = new LibraryManager(new LibraryReferencer(this.uri, this.compRTMBean, "Unresolved library references for module " + this.uri));
            }
            this.manager.lookupAndAddAutoReferences(Type.EJB, LibraryConstants.AutoReferrer.EJBApp);
            libraryArray = this.manager.getAutoReferencedLibraries();
            VirtualJarFile[] virtualJarFileArray = null;
            if (libraryArray != null && libraryArray.length > 0) {
                virtualJarFileArray = new VirtualJarFile[libraryArray.length];
                for (int i = 0; i < libraryArray.length; ++i) {
                    File file3 = libraryArray[i].getLocation();
                    virtualJarFileArray[i] = VirtualJarFactory.createVirtualJar((File)file3);
                    JarClassFinder jarClassFinder = new JarClassFinder(file3);
                    this.classLoader.addClassFinder((ClassFinder)jarClassFinder);
                }
            }
            return EjbDescriptorFactory.createReadOnlyDescriptorFromJarFile(this.jf, file, file2, deploymentPlanBean, this.appCtx.getApplicationId(), this.uri, this.classLoader, virtualJarFileArray);
        }
        catch (IOException iOException) {
            Loggable loggable = EJBLogger.logErrorReadingDDLoggable((String)iOException.getMessage());
            throw new ModuleException(loggable.getMessage(), iOException);
        }
        catch (XMLParsingException xMLParsingException) {
            Loggable loggable = EJBLogger.logXmlParsingErrorLoggable((String)xMLParsingException.getMessage());
            throw new ModuleException(loggable.getMessage(), (Throwable)((Object)xMLParsingException));
        }
        catch (XMLProcessingException xMLProcessingException) {
            Loggable loggable = EJBLogger.logXmlProcessingErrorLoggable((String)xMLProcessingException.getMessage());
            throw new ModuleException(loggable.getMessage(), (Throwable)((Object)xMLProcessingException));
        }
        catch (XMLStreamException xMLStreamException) {
            Loggable loggable = EJBLogger.logXmlProcessingErrorLoggable((String)xMLStreamException.getMessage());
            throw new ModuleException(loggable.getMessage(), xMLStreamException);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Loggable loggable = EJBLogger.logErrorReadingDDLoggable((String)throwable.getMessage());
            throw new ModuleException(loggable.getMessage(), throwable);
        }
    }

    private void closeJarFile() {
        if (this.jf == null) {
            return;
        }
        try {
            this.jf.close();
            this.jf = null;
        }
        catch (Exception exception) {
            EJBLogger.logStackTrace((Throwable)exception);
        }
    }

    EJBComponentMBean getEJBComponent() throws ModuleException {
        return (EJBComponentMBean)this.findComponentMBeanInternal(this.appCtx, this.uri, EJBComponentMBean.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unprepare() throws ModuleException {
        EJBComponentMBean eJBComponentMBean = this.getEJBComponent();
        try {
            try {
                if (debugLogger.isDebugEnabled()) {
                    EJBModule.debug("unprepare() on module : " + this + ".");
                }
                if (eJBComponentMBean != null) {
                    this.appCtx.getWorkManagerCollection().removeModuleEntries(this.getName());
                }
                if (this.ejbDeployer != null) {
                    this.ejbDeployer.rollback(this.appCtx.getEnvContext());
                }
                if (this.persistenceUnitRegistry != null) {
                    this.persistenceUnitRegistry.close();
                    this.persistenceUnitRegistry = null;
                }
                this.releaseCoherenceCaches();
            }
            catch (NamingException namingException) {
                throw new ModuleException(namingException);
            }
            Object var4_2 = null;
            if (this.manager != null) {
                this.manager.removeReferences();
                this.manager = null;
            }
            if (eJBComponentMBean != null) {
                eJBComponentMBean.setEJBComponentRuntime(null);
            }
            if (this.compRTMBean == null) return;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (this.manager != null) {
                this.manager.removeReferences();
                this.manager = null;
            }
            if (eJBComponentMBean != null) {
                eJBComponentMBean.setEJBComponentRuntime(null);
            }
            if (this.compRTMBean == null) throw throwable;
            try {
                try {
                    this.compRTMBean.unregister();
                }
                catch (ManagementException managementException) {
                    throw new ModuleException("Error unregistering RuntimeMBean: " + managementException.getMessage(), managementException);
                }
                Object var7_6 = null;
                this.compRTMBean = null;
                throw throwable;
            }
            catch (Throwable throwable2) {
                Object var7_7 = null;
                this.compRTMBean = null;
                throw throwable2;
            }
        }
        try {}
        catch (Throwable throwable) {
            Object var7_5 = null;
            this.compRTMBean = null;
            throw throwable;
        }
        try {}
        catch (ManagementException managementException) {
            throw new ModuleException("Error unregistering RuntimeMBean: " + managementException.getMessage(), managementException);
        }
        this.compRTMBean.unregister();
        Object var7_4 = null;
        this.compRTMBean = null;
    }

    private void doDeactivate() {
        this.ejbDeployer.deactivate();
    }

    public void destroy(UpdateListener.Registration registration) throws ModuleException {
        if (debugLogger.isDebugEnabled()) {
            EJBModule.debug("destroy() on module : " + this + ".");
        }
        registration.removeUpdateListener(this);
        if (this.classFinder != null) {
            this.classFinder.close();
        }
        this.closeJarFile();
        this.classLoader = null;
        this.classFinder = null;
    }

    public String getName() {
        return this.name == null ? this.getURI() : this.name;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    private String getDisplayName() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getName());
        stringBuffer.append("(Application: ");
        stringBuffer.append(this.getApplicationName());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public void setAltDD(String string) {
        this.altDD = string;
    }

    public String getAltDD() {
        return this.altDD;
    }

    private void registerBeanUpdateListeners() {
        PersistenceUnitConfigurationBean persistenceUnitConfigurationBean;
        WeblogicRdbmsBeanBean[] weblogicRdbmsBeanBeanArray;
        MessageDrivenBeanBean[] messageDrivenBeanBeanArray;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        HashMap<String, WeblogicEnterpriseBeanBean> hashMap = new HashMap<String, WeblogicEnterpriseBeanBean>();
        WeblogicEjbJarBean weblogicEjbJarBean = this.ejbDescriptor.getWeblogicEjbJarBean();
        WeblogicEnterpriseBeanBean[] weblogicEnterpriseBeanBeanArray = weblogicEjbJarBean.getWeblogicEnterpriseBeans();
        for (int i = 0; i < weblogicEnterpriseBeanBeanArray.length; ++i) {
            hashMap.put(weblogicEnterpriseBeanBeanArray[i].getEjbName(), weblogicEnterpriseBeanBeanArray[i]);
        }
        Collection collection = this.ejbDeployer.getBeanInfos();
        for (BeanInfo beanInfo : collection) {
            assert (hashMap.containsKey(beanInfo.getEJBName()));
            object6 = (WeblogicEnterpriseBeanBean)hashMap.get(beanInfo.getEJBName());
            object5 = object6.getTransactionDescriptor();
            object4 = (DescriptorBean)object5;
            object4.addBeanUpdateListener((BeanUpdateListener)beanInfo);
            if (beanInfo instanceof EntityBeanInfo) {
                object3 = (EntityBeanInfo)beanInfo;
                object2 = object6.getEntityDescriptor();
                if (object2.getEntityCacheRef() != null) {
                    object = object2.getEntityCacheRef();
                    object4 = (DescriptorBean)object;
                    object4.addBeanUpdateListener((BeanUpdateListener)beanInfo);
                    messageDrivenBeanBeanArray = this.appCtx.getWLApplicationDD();
                    weblogicRdbmsBeanBeanArray = messageDrivenBeanBeanArray.getEjb();
                    persistenceUnitConfigurationBean = weblogicRdbmsBeanBeanArray.getEntityCaches();
                    for (int i = 0; i < ((PersistenceUnitConfigurationBean)persistenceUnitConfigurationBean).length; ++i) {
                        if (!object.getEntityCacheName().equals(persistenceUnitConfigurationBean[i].getEntityCacheName())) continue;
                        object4 = (DescriptorBean)persistenceUnitConfigurationBean[i];
                        object4.addBeanUpdateListener((BeanUpdateListener)beanInfo);
                    }
                } else {
                    object4 = (DescriptorBean)object2.getEntityCache();
                    object4.addBeanUpdateListener((BeanUpdateListener)beanInfo);
                }
                object4 = (DescriptorBean)object2.getPool();
                object4.addBeanUpdateListener((BeanUpdateListener)beanInfo);
                if (object3.getIsBeanManagedPersistence() || !object3.getCMPInfo().uses20CMP()) continue;
                object = this.ejbDescriptor.getWeblogicRdbmsJarBeans();
                for (int i = 0; i < ((Object)object).length; ++i) {
                    weblogicRdbmsBeanBeanArray = object[i].getWeblogicRdbmsBeans();
                    for (int j = 0; j < weblogicRdbmsBeanBeanArray.length; ++j) {
                        AutomaticKeyGenerationBean automaticKeyGenerationBean;
                        if (!object3.getEJBName().equals(weblogicRdbmsBeanBeanArray[j].getEjbName()) || (automaticKeyGenerationBean = weblogicRdbmsBeanBeanArray[j].getAutomaticKeyGeneration()) == null) continue;
                        object4 = (DescriptorBean)automaticKeyGenerationBean;
                        object4.addBeanUpdateListener((BeanUpdateListener)beanInfo);
                    }
                }
                continue;
            }
            if (beanInfo instanceof SessionBeanInfo) {
                object3 = (SessionBeanInfo)beanInfo;
                if (object3.isStateful()) {
                    object2 = object6.getStatefulSessionDescriptor();
                    object4 = (DescriptorBean)object2.getStatefulSessionCache();
                    object4.addBeanUpdateListener((BeanUpdateListener)beanInfo);
                    continue;
                }
                object2 = object6.getStatelessSessionDescriptor();
                object4 = (DescriptorBean)object2.getPool();
                object4.addBeanUpdateListener((BeanUpdateListener)beanInfo);
                continue;
            }
            if (beanInfo instanceof MessageDrivenBeanInfo) {
                object3 = object6.getMessageDrivenDescriptor();
                object4 = (DescriptorBean)object3;
                object4.addBeanUpdateListener((BeanUpdateListener)beanInfo);
                object4 = (DescriptorBean)object3.getPool();
                object4.addBeanUpdateListener((BeanUpdateListener)beanInfo);
                object2 = this.ejbDescriptor.getEjbJarBean();
                object = object2.getEnterpriseBeans();
                messageDrivenBeanBeanArray = object.getMessageDrivens();
                for (int i = 0; i < messageDrivenBeanBeanArray.length; ++i) {
                    if (!beanInfo.getEJBName().equals(messageDrivenBeanBeanArray[i].getEjbName())) continue;
                    persistenceUnitConfigurationBean = messageDrivenBeanBeanArray[i].getActivationConfig();
                    ActivationConfigPropertyBean[] activationConfigPropertyBeanArray = persistenceUnitConfigurationBean.getActivationConfigProperties();
                    for (int j = 0; j < activationConfigPropertyBeanArray.length; ++j) {
                        if (!DDConstants.updateElementSet.contains(activationConfigPropertyBeanArray[j].getActivationConfigPropertyName().toUpperCase())) continue;
                        object4 = (DescriptorBean)activationConfigPropertyBeanArray[j];
                        object4.addBeanUpdateListener((BeanUpdateListener)beanInfo);
                    }
                }
                continue;
            }
            throw new AssertionError("Unknown BeanInfo type!");
        }
        for (BeanInfo beanInfo : collection) {
            if (!(beanInfo instanceof EntityBeanInfo) && !(beanInfo instanceof SessionBeanInfo)) continue;
            object6 = (ClientDrivenBeanInfo)beanInfo;
            object6.setPersistenceUnitRegistry(this.getPersistenceUnitRegistry());
            object5 = this.getPersistenceUnitRegistry();
            object4 = object5.getPersistenceUnitNames();
            object3 = object4.iterator();
            while (object3.hasNext()) {
                object2 = (String)object3.next();
                object = object5.getPersistenceUnit((String)object2);
                messageDrivenBeanBeanArray = ((PersistenceUnitInfoImpl)object).getDD();
                weblogicRdbmsBeanBeanArray = (WeblogicRdbmsBeanBean[])messageDrivenBeanBeanArray;
                weblogicRdbmsBeanBeanArray.addBeanUpdateListener((BeanUpdateListener)object6);
                persistenceUnitConfigurationBean = ((PersistenceUnitInfoImpl)object).getConfigDD();
                if (persistenceUnitConfigurationBean == null) continue;
                weblogicRdbmsBeanBeanArray = (DescriptorBean)persistenceUnitConfigurationBean;
                weblogicRdbmsBeanBeanArray.addBeanUpdateListener((BeanUpdateListener)object6);
            }
        }
    }

    private void unregisterBeanUpdateListeners() {
        WeblogicRdbmsBeanBean[] weblogicRdbmsBeanBeanArray;
        MessageDrivenBeanBean[] messageDrivenBeanBeanArray;
        WeblogicRdbmsJarBean[] weblogicRdbmsJarBeanArray;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        HashMap<String, WeblogicEnterpriseBeanBean> hashMap = new HashMap<String, WeblogicEnterpriseBeanBean>();
        WeblogicEjbJarBean weblogicEjbJarBean = this.ejbDescriptor.getWeblogicEjbJarBean();
        WeblogicEnterpriseBeanBean[] weblogicEnterpriseBeanBeanArray = weblogicEjbJarBean.getWeblogicEnterpriseBeans();
        for (int i = 0; i < weblogicEnterpriseBeanBeanArray.length; ++i) {
            hashMap.put(weblogicEnterpriseBeanBeanArray[i].getEjbName(), weblogicEnterpriseBeanBeanArray[i]);
        }
        Collection collection = this.ejbDeployer.getBeanInfos();
        for (BeanInfo beanInfo : collection) {
            ActivationConfigBean activationConfigBean;
            assert (hashMap.containsKey(beanInfo.getEJBName()));
            object5 = (WeblogicEnterpriseBeanBean)hashMap.get(beanInfo.getEJBName());
            object4 = object5.getTransactionDescriptor();
            object3 = (DescriptorBean)object4;
            object3.removeBeanUpdateListener((BeanUpdateListener)beanInfo);
            if (beanInfo instanceof EntityBeanInfo) {
                object2 = (EntityBeanInfo)beanInfo;
                object = object5.getEntityDescriptor();
                if (object.getEntityCacheRef() != null) {
                    weblogicRdbmsJarBeanArray = object.getEntityCacheRef();
                    object3 = (DescriptorBean)weblogicRdbmsJarBeanArray;
                    object3.removeBeanUpdateListener((BeanUpdateListener)beanInfo);
                    messageDrivenBeanBeanArray = this.appCtx.getWLApplicationDD();
                    weblogicRdbmsBeanBeanArray = messageDrivenBeanBeanArray.getEjb();
                    activationConfigBean = weblogicRdbmsBeanBeanArray.getEntityCaches();
                    for (int i = 0; i < ((ApplicationEntityCacheBean[])activationConfigBean).length; ++i) {
                        if (!weblogicRdbmsJarBeanArray.getEntityCacheName().equals(activationConfigBean[i].getEntityCacheName())) continue;
                        object3 = (DescriptorBean)activationConfigBean[i];
                        object3.removeBeanUpdateListener((BeanUpdateListener)beanInfo);
                    }
                } else {
                    object3 = (DescriptorBean)object.getEntityCache();
                    object3.removeBeanUpdateListener((BeanUpdateListener)beanInfo);
                }
                object3 = (DescriptorBean)object.getPool();
                object3.removeBeanUpdateListener((BeanUpdateListener)beanInfo);
                if (object2.getIsBeanManagedPersistence() || !object2.getCMPInfo().uses20CMP()) continue;
                weblogicRdbmsJarBeanArray = this.ejbDescriptor.getWeblogicRdbmsJarBeans();
                for (int i = 0; i < weblogicRdbmsJarBeanArray.length; ++i) {
                    weblogicRdbmsBeanBeanArray = weblogicRdbmsJarBeanArray[i].getWeblogicRdbmsBeans();
                    for (int j = 0; j < weblogicRdbmsBeanBeanArray.length; ++j) {
                        AutomaticKeyGenerationBean automaticKeyGenerationBean;
                        if (!object2.getEJBName().equals(weblogicRdbmsBeanBeanArray[j].getEjbName()) || (automaticKeyGenerationBean = weblogicRdbmsBeanBeanArray[j].getAutomaticKeyGeneration()) == null) continue;
                        object3 = (DescriptorBean)automaticKeyGenerationBean;
                        object3.removeBeanUpdateListener((BeanUpdateListener)beanInfo);
                    }
                }
                continue;
            }
            if (beanInfo instanceof SessionBeanInfo) {
                object2 = (SessionBeanInfo)beanInfo;
                if (object2.isStateful()) {
                    object = object5.getStatefulSessionDescriptor();
                    object3 = (DescriptorBean)object.getStatefulSessionCache();
                    object3.removeBeanUpdateListener((BeanUpdateListener)beanInfo);
                    continue;
                }
                object = object5.getStatelessSessionDescriptor();
                object3 = (DescriptorBean)object.getPool();
                object3.removeBeanUpdateListener((BeanUpdateListener)beanInfo);
                continue;
            }
            if (beanInfo instanceof MessageDrivenBeanInfo) {
                object2 = object5.getMessageDrivenDescriptor();
                object3 = (DescriptorBean)object2;
                object3.removeBeanUpdateListener((BeanUpdateListener)beanInfo);
                object3 = (DescriptorBean)object2.getPool();
                object3.removeBeanUpdateListener((BeanUpdateListener)beanInfo);
                object = this.ejbDescriptor.getEjbJarBean();
                weblogicRdbmsJarBeanArray = object.getEnterpriseBeans();
                messageDrivenBeanBeanArray = weblogicRdbmsJarBeanArray.getMessageDrivens();
                for (int i = 0; i < messageDrivenBeanBeanArray.length; ++i) {
                    if (!beanInfo.getEJBName().equals(messageDrivenBeanBeanArray[i].getEjbName())) continue;
                    activationConfigBean = messageDrivenBeanBeanArray[i].getActivationConfig();
                    ActivationConfigPropertyBean[] activationConfigPropertyBeanArray = activationConfigBean.getActivationConfigProperties();
                    for (int j = 0; j < activationConfigPropertyBeanArray.length; ++j) {
                        if (!DDConstants.updateElementSet.contains(activationConfigPropertyBeanArray[j].getActivationConfigPropertyName().toUpperCase())) continue;
                        object3 = (DescriptorBean)activationConfigPropertyBeanArray[j];
                        object3.removeBeanUpdateListener((BeanUpdateListener)beanInfo);
                    }
                }
                continue;
            }
            throw new AssertionError("Unknown BeanInfo type!");
        }
        for (BeanInfo beanInfo : collection) {
            if (!(beanInfo instanceof EntityBeanInfo) && !(beanInfo instanceof SessionBeanInfo)) continue;
            object5 = this.getPersistenceUnitRegistry();
            object4 = object5.getPersistenceUnitNames();
            object3 = object4.iterator();
            while (object3.hasNext()) {
                object2 = (String)object3.next();
                object = object5.getPersistenceUnit((String)object2);
                weblogicRdbmsJarBeanArray = ((PersistenceUnitInfoImpl)object).getDD();
                messageDrivenBeanBeanArray = (MessageDrivenBeanBean[])weblogicRdbmsJarBeanArray;
                messageDrivenBeanBeanArray.removeBeanUpdateListener((BeanUpdateListener)beanInfo);
                weblogicRdbmsBeanBeanArray = ((PersistenceUnitInfoImpl)object).getConfigDD();
                if (weblogicRdbmsBeanBeanArray == null) continue;
                messageDrivenBeanBeanArray = (DescriptorBean)weblogicRdbmsBeanBeanArray;
                messageDrivenBeanBeanArray.removeBeanUpdateListener((BeanUpdateListener)beanInfo);
            }
        }
    }

    private void setupEJBToImplClassDependencies(ClassLoader classLoader) {
        this.implClassToNameMap.clear();
        EnterpriseBeansBean enterpriseBeansBean = this.ejbDescriptor.getEjbJarBean().getEnterpriseBeans();
        EntityBeanBean[] entityBeanBeanArray = enterpriseBeansBean.getEntities();
        for (int i = 0; i < entityBeanBeanArray.length; ++i) {
            this.addEJBToImplClassDependency(entityBeanBeanArray[i].getEjbName(), entityBeanBeanArray[i].getEjbClass());
        }
        SessionBeanBean[] sessionBeanBeanArray = enterpriseBeansBean.getSessions();
        for (int i = 0; i < sessionBeanBeanArray.length; ++i) {
            this.addEJBToImplClassDependency(sessionBeanBeanArray[i].getEjbName(), sessionBeanBeanArray[i].getEjbClass());
        }
        MessageDrivenBeanBean[] messageDrivenBeanBeanArray = enterpriseBeansBean.getMessageDrivens();
        for (int i = 0; i < messageDrivenBeanBeanArray.length; ++i) {
            this.addEJBToImplClassDependency(messageDrivenBeanBeanArray[i].getEjbName(), messageDrivenBeanBeanArray[i].getEjbClass());
        }
        ClassFinder classFinder = ((GenericClassLoader)classLoader).getClassFinder();
        GenericClassLoader genericClassLoader = new GenericClassLoader(classFinder, classLoader.getParent());
        Set set = this.implClassToNameMap.keySet();
        String[] stringArray = new String[set.size()];
        stringArray = set.toArray(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            try {
                Class clazz;
                Class clazz2 = genericClassLoader.loadClass(string);
                while ((clazz = clazz2.getSuperclass()).getClassLoader() == genericClassLoader) {
                    List list = (List)this.implClassToNameMap.get(string);
                    string = clazz.getName();
                    for (String string2 : list) {
                        this.addEJBToImplClassDependency(string2, string);
                    }
                    clazz2 = clazz;
                }
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    private void addEJBToImplClassDependency(String string, String string2) {
        ArrayList<String> arrayList = (ArrayList<String>)this.implClassToNameMap.get(string2);
        if (arrayList == null) {
            arrayList = new ArrayList<String>();
            arrayList.add(string);
            this.implClassToNameMap.put(string2, arrayList);
        } else if (!arrayList.contains(string)) {
            arrayList.add(string);
        }
    }

    private void dumpDependencyMaps() {
        System.out.println("Dumping beanImpl -> ejbName map");
        Set set = this.implClassToNameMap.keySet();
        for (String string : set) {
            List list = (List)this.implClassToNameMap.get(string);
            Iterator iterator = list.iterator();
            boolean bl = true;
            String string2 = "";
            while (iterator.hasNext()) {
                if (!bl) {
                    string2 = string2 + ", ";
                } else {
                    bl = false;
                }
                string2 = string2 + (String)iterator.next();
            }
            System.out.println(string + ": " + string2);
        }
    }

    public static EJBModule findModule(String string, String string2) {
        return (EJBModule)ejbModules.get(new ModuleKey(string, string2));
    }

    private static void debug(String string) {
        debugLogger.debug("[EJBModule] " + string);
    }

    private static void debug(String string, Throwable throwable) {
        debugLogger.debug("[EJBModule] " + string, throwable);
    }

    public PersistenceUnitRegistry getPersistenceUnitRegistry() {
        return this.persistenceUnitRegistry;
    }

    public PersistenceUnitRegistry getProposedPersistenceUnitRegistry() {
        return this.proposedPersistenceUnitRegistry;
    }

    private void fillInterfaceInfoForEJBModule(EjbDescriptorBean ejbDescriptorBean) {
        SessionBeanBean sessionBeanBean;
        int n;
        SessionBeanBean[] sessionBeanBeanArray;
        EjbJarBean ejbJarBean = ejbDescriptorBean.getEjbJarBean();
        EnterpriseBeansBean enterpriseBeansBean = ejbJarBean.getEnterpriseBeans();
        SessionBeanBean[] sessionBeanBeanArray2 = sessionBeanBeanArray = enterpriseBeansBean.getSessions();
        int n2 = sessionBeanBeanArray2.length;
        for (n = 0; n < n2; ++n) {
            int n3;
            SessionBeanBean sessionBeanBean2;
            SessionBeanBean sessionBeanBean3 = sessionBeanBeanArray2[n];
            this.fillInterfaceInfoForEJBModule((EnterpriseBeanBean)sessionBeanBean3);
            sessionBeanBean = sessionBeanBean3.getBusinessRemotes();
            if (sessionBeanBean != null) {
                sessionBeanBean2 = sessionBeanBean;
                int n4 = ((String[])sessionBeanBean2).length;
                for (n3 = 0; n3 < n4; ++n3) {
                    String string = sessionBeanBean2[n3];
                    this.ejbInterfaces.add(string);
                }
            }
            if (sessionBeanBean3.getHome() != null) {
                this.ejbInterfaces.add(sessionBeanBean3.getHome());
                this.ejbInterfaces.add(sessionBeanBean3.getRemote());
            }
            if ((sessionBeanBean2 = sessionBeanBean3.getBusinessLocals()) != null) {
                SessionBeanBean sessionBeanBean4 = sessionBeanBean2;
                n3 = ((String[])sessionBeanBean4).length;
                for (int i = 0; i < n3; ++i) {
                    SessionBeanBean sessionBeanBean5 = sessionBeanBean4[i];
                    this.ejbInterfaces.add((String)sessionBeanBean5);
                }
            }
            if (sessionBeanBean3.getLocalHome() == null) continue;
            this.ejbInterfaces.add(sessionBeanBean3.getLocalHome());
            this.ejbInterfaces.add(sessionBeanBean3.getLocal());
        }
        SessionBeanBean[] sessionBeanBeanArray3 = sessionBeanBeanArray2 = enterpriseBeansBean.getEntities();
        n = sessionBeanBeanArray3.length;
        for (int i = 0; i < n; ++i) {
            sessionBeanBean = sessionBeanBeanArray3[i];
            this.fillInterfaceInfoForEJBModule((EnterpriseBeanBean)sessionBeanBean);
            if (sessionBeanBean.getHome() != null) {
                this.ejbInterfaces.add(sessionBeanBean.getHome());
            }
            if (sessionBeanBean.getLocal() != null) {
                this.ejbInterfaces.add(sessionBeanBean.getLocal());
            }
            if (sessionBeanBean.getLocalHome() != null) {
                this.ejbInterfaces.add(sessionBeanBean.getLocalHome());
            }
            if (sessionBeanBean.getRemote() != null) {
                this.ejbInterfaces.add(sessionBeanBean.getRemote());
            }
            if (sessionBeanBean.getPrimKeyClass() == null) continue;
            this.ejbInterfaces.add(sessionBeanBean.getPrimKeyClass());
        }
        for (SessionBeanBean sessionBeanBean2 : sessionBeanBeanArray3 = enterpriseBeansBean.getMessageDrivens()) {
            this.fillInterfaceInfoForEJBModule((EnterpriseBeanBean)sessionBeanBean2);
        }
    }

    private void fillInterfaceInfoForEJBModule(EnterpriseBeanBean enterpriseBeanBean) {
        EjbRefBean[] ejbRefBeanArray;
        if (enterpriseBeanBean.getEjbClass() != null) {
            this.ejbInterfaces.add(enterpriseBeanBean.getEjbClass());
        }
        if ((ejbRefBeanArray = enterpriseBeanBean.getEjbRefs()) != null) {
            for (EjbRefBean ejbRefBean : ejbRefBeanArray) {
                if (ejbRefBean.getHome() != null) {
                    this.ejbInterfaces.add(ejbRefBean.getHome());
                }
                if (ejbRefBean.getRemote() == null) continue;
                this.ejbInterfaces.add(ejbRefBean.getRemote());
            }
        }
    }

    private Set getEJBInterfaces() {
        return this.ejbInterfaces;
    }

    private void setupRedefiningClassLoader(GenericClassLoader genericClassLoader) {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug(" ClassLoader " + genericClassLoader + " EJB Interfaces " + this.ejbInterfaces);
        }
        if (genericClassLoader instanceof RedefiningClassLoader && this.ejbInterfaces.size() > 0) {
            ((RedefiningClassLoader)genericClassLoader).setExcludedClasses(this.ejbInterfaces);
        }
    }

    private void setupCoherenceCaches() throws DeploymentException {
        if (this.shouldProcessCoherence()) {
            try {
                GenericClassLoader genericClassLoader = this.getClassLoader();
                CoherenceClusterManager coherenceClusterManager = CoherenceClusterManager.getInstance();
                boolean bl = coherenceClusterManager.isCoherenceAvailable((ClassLoader)genericClassLoader);
                CoherenceClusterRefBean coherenceClusterRefBean = this.getCoherenceClusterRefBean();
                String string = null;
                if (coherenceClusterRefBean != null) {
                    string = coherenceClusterRefBean.getCoherenceClusterName();
                    if (!bl) {
                        throw new ModuleException("Missing Coherence jar or WebLogic Coherence Integration jar");
                    }
                }
                if (bl) {
                    coherenceClusterManager.registerEJBComponentRuntimeMBean((ClassLoader)genericClassLoader, (EJBComponentRuntimeMBean)this.getRuntimeMBean());
                    coherenceClusterManager.configureClusterService((ClassLoader)genericClassLoader, string);
                    coherenceClusterManager.addCacheConfiguration((ClassLoader)genericClassLoader);
                }
            }
            catch (ModuleException moduleException) {
                throw moduleException;
            }
            catch (Exception exception) {
                throw new ModuleException(exception.getMessage(), exception);
            }
        }
    }

    private boolean shouldProcessCoherence() {
        GenericClassLoader genericClassLoader = this.getClassLoader();
        return this.appCtx != null && (!this.appCtx.isEar() || this.appCtx.getAppClassLoader() != genericClassLoader);
    }

    private CoherenceClusterRefBean getCoherenceClusterRefBean() {
        WeblogicEjbJarBean weblogicEjbJarBean = this.ejbDescriptor.getWeblogicEjbJarBean();
        if (weblogicEjbJarBean != null) {
            return weblogicEjbJarBean.getCoherenceClusterRef();
        }
        return null;
    }

    private void releaseCoherenceCaches() {
        if (this.shouldProcessCoherence()) {
            try {
                GenericClassLoader genericClassLoader = this.getClassLoader();
                CoherenceClusterManager coherenceClusterManager = CoherenceClusterManager.getInstance();
                if (coherenceClusterManager.isCoherenceAvailable((ClassLoader)genericClassLoader)) {
                    coherenceClusterManager.releaseCacheConfiguration((ClassLoader)genericClassLoader);
                    coherenceClusterManager.shutdownClusterService((ClassLoader)genericClassLoader);
                    coherenceClusterManager.unRegisterEJBComponentRuntimeMBean((ClassLoader)genericClassLoader, (EJBComponentRuntimeMBean)this.getRuntimeMBean());
                }
            }
            catch (Exception exception) {
                EJBLogger.logErrorUndeploying((String)this.getURI(), (Exception)exception);
            }
        }
    }

    public boolean isParallelEnabled() {
        return true;
    }

    private static final class ModuleKey {
        private final String appName;
        private final String compName;
        private final int hash;

        ModuleKey(String string, String string2) {
            this.appName = string;
            this.compName = string2;
            this.hash = string.hashCode() ^ string2.hashCode();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ModuleKey)) {
                return false;
            }
            ModuleKey moduleKey = (ModuleKey)object;
            return moduleKey.hashCode() == this.hash && moduleKey.appName.equals(this.appName) && moduleKey.compName.equals(this.compName);
        }
    }
}

