/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.deployer;

import javax.ejb.EJBObject;
import javax.naming.LinkRef;
import javax.naming.NamingException;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.deployer.EjbJndiBinder;
import weblogic.ejb.container.deployer.EjbJndiService;
import weblogic.ejb.container.interfaces.ClientDrivenBeanInfo;
import weblogic.ejb.container.interfaces.EntityBeanInfo;
import weblogic.ejb.container.manager.StatefulSessionManager;
import weblogic.ejb.spi.WLDeploymentException;
import weblogic.logging.Loggable;

public class Ejb2JndiBinder
implements EjbJndiBinder {
    protected ClientDrivenBeanInfo beanInfo;
    protected EjbJndiService jndiService;

    Ejb2JndiBinder(ClientDrivenBeanInfo clientDrivenBeanInfo) {
        this.beanInfo = clientDrivenBeanInfo;
        this.jndiService = new EjbJndiService(clientDrivenBeanInfo.getClientsOnSameServer());
    }

    private void bindHome() throws WLDeploymentException {
        ClientDrivenBeanInfo clientDrivenBeanInfo = this.beanInfo;
        if (clientDrivenBeanInfo.hasRemoteClientView() && clientDrivenBeanInfo.hasDeclaredRemoteHome() && clientDrivenBeanInfo.getJNDIName() != null && !clientDrivenBeanInfo.getJNDIName().toString().equals(clientDrivenBeanInfo.getIsIdenticalKey().replace('.', '_') + "_Home")) {
            try {
                if (clientDrivenBeanInfo.getClusteringDescriptor().getHomeIsClusterable()) {
                    this.jndiService.replicatedBind(clientDrivenBeanInfo.getJNDIName(), (Object)clientDrivenBeanInfo.getRemoteHome());
                } else {
                    this.jndiService.nonReplicatedBind(clientDrivenBeanInfo.getJNDIName(), (Object)clientDrivenBeanInfo.getRemoteHome());
                }
            }
            catch (NamingException namingException) {
                Loggable loggable = EJBLogger.logHomeJNDIRebindFailedLoggable((String)clientDrivenBeanInfo.getJNDIName().toString(), (Exception)namingException);
                throw new WLDeploymentException(loggable.getMessage(), namingException);
            }
        }
        if (clientDrivenBeanInfo.hasLocalClientView() && clientDrivenBeanInfo.hasDeclaredLocalHome() && clientDrivenBeanInfo.getLocalJNDIName() != null) {
            String string = clientDrivenBeanInfo.getComponentURI() + "#" + clientDrivenBeanInfo.getEJBName();
            LinkRef linkRef = new LinkRef("java:app/ejb/" + string + "/local-home");
            try {
                this.jndiService.nonReplicatedBind(clientDrivenBeanInfo.getLocalJNDIName(), (Object)linkRef);
            }
            catch (NamingException namingException) {
                Loggable loggable = EJBLogger.logLocalHomeJNDIRebindFailedLoggable((String)(clientDrivenBeanInfo.getLocalJNDIName() != null ? clientDrivenBeanInfo.getLocalJNDIName().toString() : "<unknown>"), (Exception)namingException);
                throw new WLDeploymentException(loggable.getMessage(), namingException);
            }
        }
    }

    private void bindEJBObject() throws WLDeploymentException {
        if (this.beanInfo instanceof EntityBeanInfo) {
            return;
        }
        ClientDrivenBeanInfo clientDrivenBeanInfo = this.beanInfo;
        if (clientDrivenBeanInfo.getBeanManager() instanceof StatefulSessionManager) {
            return;
        }
        if (clientDrivenBeanInfo.hasRemoteClientView()) {
            String string = clientDrivenBeanInfo.getIsIdenticalKey().replace('.', '_') + "_EO";
            EJBObject eJBObject = clientDrivenBeanInfo.getRemoteHome().allocateEO();
            try {
                if (clientDrivenBeanInfo.getClusteringDescriptor().getStatelessBeanIsClusterable()) {
                    this.jndiService.replicatedBind(string, (Object)eJBObject);
                } else {
                    this.jndiService.nonReplicatedBind(string, (Object)eJBObject);
                }
            }
            catch (NamingException namingException) {
                Loggable loggable = EJBLogger.logStatelessEOJNDIBindErrorLoggable((String)string, (Exception)namingException);
                throw new WLDeploymentException(loggable.getMessage(), namingException);
            }
        }
    }

    public void bindToJNDI() throws WLDeploymentException {
        if (this.beanInfo.hasRemoteClientView() && this.beanInfo.getJNDIName() != null || this.beanInfo.hasLocalClientView() && this.beanInfo.getLocalJNDIName() != null) {
            try {
                this.bindEJBObject();
                this.bindHome();
            }
            catch (WLDeploymentException wLDeploymentException) {
                this.unbindFromJNDI();
                throw wLDeploymentException;
            }
        }
    }

    public void unbindFromJNDI() {
        this.jndiService.unbindAll();
    }
}

