/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.deployer;

import java.lang.reflect.Method;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.jws.WebService;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.ws.WebServiceProvider;
import weblogic.application.ApplicationContextInternal;
import weblogic.deployment.BaseEnvironmentBuilder;
import weblogic.deployment.PersistenceUnitInfoImpl;
import weblogic.deployment.PersistenceUnitRegistry;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.compliance.ComplianceException;
import weblogic.ejb.container.compliance.Ejb30SessionBeanClassChecker;
import weblogic.ejb.container.dd.xml.DDUtils;
import weblogic.ejb.container.deployer.CompositeMBeanDescriptor;
import weblogic.ejb.container.deployer.Ejb3SessionBinder;
import weblogic.ejb.container.deployer.EjbJndiBinder;
import weblogic.ejb.container.deployer.NamingConvention;
import weblogic.ejb.container.deployer.SessionBeanInfoImpl;
import weblogic.ejb.container.deployer.SessionContextProxyImpl;
import weblogic.ejb.container.interfaces.DeploymentInfo;
import weblogic.ejb.container.interfaces.Ejb3SessionBeanInfo;
import weblogic.ejb.container.interfaces.Ejb3SessionHome;
import weblogic.ejb.container.interfaces.MethodInfo;
import weblogic.ejb.container.manager.StatefulSessionManager;
import weblogic.ejb.spi.BusinessObject;
import weblogic.ejb.spi.WLDeploymentException;
import weblogic.j2ee.descriptor.InitMethodBean;
import weblogic.j2ee.descriptor.MethodParamsBean;
import weblogic.j2ee.descriptor.NamedMethodBean;
import weblogic.j2ee.descriptor.PersistenceContextRefBean;
import weblogic.j2ee.descriptor.RemoveMethodBean;
import weblogic.j2ee.descriptor.SessionBeanBean;
import weblogic.logging.Loggable;
import weblogic.rmi.extensions.server.ServerHelper;
import weblogic.utils.AssertionError;
import weblogic.utils.classloaders.GenericClassLoader;

final class Ejb3SessionBeanInfoImpl
extends SessionBeanInfoImpl
implements Ejb3SessionBeanInfo {
    private Set businessLocalInterfaces = new HashSet();
    private Set businessRemoteInterfaces = new HashSet();
    private Map jndiNameMap = new HashMap();
    private Map localBusinessImplClassMap = new HashMap();
    private Map remoteBusinessImplClassMap = new HashMap();
    private Map remoteBusinessIntfClassMap = new HashMap();
    private Map removeMethodToRetainIfExceptionMap = new HashMap();
    private Map interfaceMethodToRemoveMethodMap = new HashMap();
    private Set interfaceMethodWithoutRemove = new HashSet();
    private PersistenceContextRefBean[] extendedPersistenceContextRefs;

    public Ejb3SessionBeanInfoImpl(DeploymentInfo deploymentInfo, CompositeMBeanDescriptor compositeMBeanDescriptor, GenericClassLoader genericClassLoader) throws ClassNotFoundException, WLDeploymentException {
        super(deploymentInfo, compositeMBeanDescriptor, genericClassLoader);
        PersistenceContextRefBean[] persistenceContextRefBeanArray;
        String[] stringArray = compositeMBeanDescriptor.getBusinessLocals();
        for (int i = 0; i < stringArray.length; ++i) {
            Class clazz = this.loadClass(stringArray[i]);
            this.businessLocalInterfaces.add(clazz);
            this.checkClassLoaders(compositeMBeanDescriptor, clazz);
        }
        String[] stringArray2 = compositeMBeanDescriptor.getBusinessRemotes();
        for (int i = 0; i < stringArray2.length; ++i) {
            persistenceContextRefBeanArray = this.loadClass(stringArray2[i]);
            this.businessRemoteInterfaces.add(persistenceContextRefBeanArray);
            this.checkClassLoaders(compositeMBeanDescriptor, (Class)persistenceContextRefBeanArray);
            String string = compositeMBeanDescriptor.getBusinessJNDIName((Class)persistenceContextRefBeanArray);
            string = BaseEnvironmentBuilder.transformJNDIName(string, deploymentInfo.getApplicationName());
            if (string == null) continue;
            this.jndiNameMap.put(persistenceContextRefBeanArray, string);
        }
        this.initializeMethodInfos();
        this.initializeRemoveMethodInfos();
        HashSet<PersistenceContextRefBean> hashSet = new HashSet<PersistenceContextRefBean>();
        persistenceContextRefBeanArray = this.getPersistenceContextRefs();
        for (int i = 0; i < persistenceContextRefBeanArray.length; ++i) {
            if (!"Extended".equals(persistenceContextRefBeanArray[i].getPersistenceContextType())) continue;
            hashSet.add(persistenceContextRefBeanArray[i]);
        }
        this.extendedPersistenceContextRefs = hashSet.toArray(new PersistenceContextRefBean[hashSet.size()]);
    }

    protected boolean needSetReplicationType(CompositeMBeanDescriptor compositeMBeanDescriptor) {
        if (this.getJNDIName() != null) {
            return true;
        }
        return compositeMBeanDescriptor.getBusinessRemotes().length > 0;
    }

    public boolean hasWebserviceClientView() {
        return super.hasWebserviceClientView() || this.getBeanClass().isAnnotationPresent(WebService.class) || this.getBeanClass().isAnnotationPresent(WebServiceProvider.class);
    }

    public boolean hasBusinessRemotes() {
        return !this.businessRemoteInterfaces.isEmpty();
    }

    public boolean hasBusinessLocals() {
        return !this.businessLocalInterfaces.isEmpty();
    }

    public String[] getBusinessLocalNames() {
        return this.m_desc.getBusinessLocals();
    }

    public String[] getBusinessRemoteNames() {
        return this.m_desc.getBusinessRemotes();
    }

    public Map getRemoteBusinessJNDINames() {
        return this.jndiNameMap;
    }

    public Set getBusinessLocals() {
        return this.businessLocalInterfaces;
    }

    public Set getBusinessRemotes() {
        return this.businessRemoteInterfaces;
    }

    public boolean hasRemoteClientView() {
        return super.hasRemoteClientView() || !this.businessRemoteInterfaces.isEmpty();
    }

    public boolean hasLocalClientView() {
        return super.hasLocalClientView() || !this.businessLocalInterfaces.isEmpty();
    }

    public Class getGeneratedLocalBusinessImplClass(Class clazz) {
        return (Class)this.localBusinessImplClassMap.get(clazz);
    }

    public Class getGeneratedRemoteBusinessImplClass(Class clazz) {
        return (Class)this.remoteBusinessImplClassMap.get(clazz);
    }

    public Class getGeneratedRemoteBusinessIntfClass(Class clazz) {
        return (Class)this.remoteBusinessIntfClassMap.get(clazz);
    }

    private void initializeMethodInfos() throws WLDeploymentException {
        List<Object> list;
        if (this.businessRemoteInterfaces.size() > 0) {
            Iterator iterator = Arrays.asList((Object[])BusinessObject.class.getMethods());
            this.createMethodInfoImpls((Collection)((Object)iterator), "Remote", this.remoteMethods);
        }
        for (Class clazz : this.businessRemoteInterfaces) {
            list = Arrays.asList((Object[])clazz.getMethods());
            this.createMethodInfoImpls(list, "Remote", this.remoteMethods);
        }
        for (Class clazz : this.businessLocalInterfaces) {
            list = Arrays.asList((Object[])clazz.getMethods());
            this.createMethodInfoImpls(list, "Local", this.localMethods);
        }
    }

    private void initializeRemoveMethodInfos() throws ClassNotFoundException, WLDeploymentException {
        SessionBeanBean sessionBeanBean = (SessionBeanBean)this.m_desc.getBean();
        Class clazz = this.loadClass(sessionBeanBean.getEjbClass());
        RemoveMethodBean[] removeMethodBeanArray = sessionBeanBean.getRemoveMethods();
        for (int i = 0; i < removeMethodBeanArray.length; ++i) {
            RemoveMethodBean removeMethodBean = removeMethodBeanArray[i];
            NamedMethodBean namedMethodBean = removeMethodBean.getBeanMethod();
            String string = namedMethodBean.getMethodName();
            MethodParamsBean methodParamsBean = namedMethodBean.getMethodParams();
            boolean bl = removeMethodBean.isRetainIfException();
            String string2 = null;
            try {
                string2 = methodParamsBean == null ? DDUtils.getMethodSignature(string, new String[0]) : DDUtils.getMethodSignature(string, methodParamsBean.getMethodParams());
                MethodInfo methodInfo = this.getRemoteMethodInfo(string2);
                if (methodInfo == null) {
                    methodInfo = this.getLocalMethodInfo(string2);
                }
                try {
                    Ejb30SessionBeanClassChecker.validateRemoveMethodToBeBusinessMethod(sessionBeanBean, methodInfo, string2);
                }
                catch (ComplianceException complianceException) {
                    throw new WLDeploymentException("Deploy failure: ", complianceException);
                }
                Method method = methodInfo.getMethod();
                Method method2 = clazz.getMethod(method.getName(), method.getParameterTypes());
                this.addRemoveMethod(method2, bl);
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new AssertionError("Should not reach", (Throwable)noSuchMethodException);
            }
        }
    }

    private void addRemoveMethod(Method method, boolean bl) {
        if (bl) {
            this.removeMethodToRetainIfExceptionMap.put(method, Boolean.TRUE);
        } else {
            this.removeMethodToRetainIfExceptionMap.put(method, Boolean.FALSE);
        }
    }

    protected boolean checkIfItsSafeToUseCallByReference() {
        boolean bl = super.checkIfItsSafeToUseCallByReference();
        if (!this.businessRemoteInterfaces.isEmpty()) {
            for (Class clazz : this.businessRemoteInterfaces) {
                Method[] methodArray = clazz.getMethods();
                for (int i = 0; i < methodArray.length; ++i) {
                    if (this.checkIfMethodCanUseCallByReference(methodArray[i])) continue;
                    return false;
                }
            }
        }
        return bl;
    }

    protected void warnIfParameterNotSerializable() {
        super.warnIfParameterNotSerializable();
        if (!this.businessRemoteInterfaces.isEmpty()) {
            for (Class clazz : this.businessRemoteInterfaces) {
                Method[] methodArray = clazz.getMethods();
                for (int i = 0; i < methodArray.length; ++i) {
                    this.warnIfParamNotSerializableForMethod(methodArray[i]);
                }
            }
        }
    }

    public void prepare(ApplicationContextInternal applicationContextInternal, DeploymentInfo deploymentInfo) throws WLDeploymentException {
        Iterator iterator;
        Object object;
        Object object2;
        super.prepare(applicationContextInternal, deploymentInfo);
        NamingConvention namingConvention = new NamingConvention(this.getBeanClassName(), this.getEJBName());
        for (Class clazz : this.businessRemoteInterfaces) {
            try {
                object2 = this.loadClass(namingConvention.getRemoteBusinessImplClassName(clazz));
                this.remoteBusinessImplClassMap.put(clazz, object2);
                this.setMethodDescriptors(null, (Class)object2, clazz.getMethods(), "Remote");
                if (!Remote.class.isAssignableFrom(clazz)) {
                    object = this.loadClass(namingConvention.getRemoteBusinessIntfClassName(clazz));
                    this.remoteBusinessIntfClassMap.put(clazz, object);
                }
                this.setMethodDescriptors(null, (Class)object2, BusinessObject.class.getMethods(), "Remote");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new AssertionError("Unable to load class " + namingConvention.getRemoteBusinessImplClassName(clazz), (Throwable)classNotFoundException);
            }
        }
        for (Class clazz : this.businessLocalInterfaces) {
            try {
                object2 = this.loadClass(namingConvention.getLocalBusinessImplClassName(clazz));
                this.localBusinessImplClassMap.put(clazz, object2);
                this.setMethodDescriptors(null, (Class)object2, clazz.getMethods(), "Local");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new AssertionError("Unable to load class " + namingConvention.getLocalBusinessImplClassName(clazz), (Throwable)classNotFoundException);
            }
        }
        if (this.hasBusinessRemotes()) {
            iterator = (Ejb3SessionHome)((Object)this.getRemoteHome());
            iterator.prepare();
        }
        if (this.hasBusinessLocals()) {
            iterator = (Ejb3SessionHome)((Object)this.getLocalHome());
            iterator.prepare();
        }
        for (Class clazz : this.jndiNameMap.keySet()) {
            object2 = (String)this.jndiNameMap.get(clazz);
            try {
                object = new InitialContext();
                Object object3 = ((InitialContext)object).lookup((String)object2);
                if (object3 == null) continue;
                Loggable loggable = EJBLogger.logJNDINameAlreadyInUseLoggable((String)this.getDisplayName(), (String)object2);
                if (object3 instanceof Remote) {
                    Remote remote = (Remote)object3;
                    if (ServerHelper.isClusterable((Remote)remote) && !ServerHelper.isLocal((Remote)remote)) continue;
                    throw new WLDeploymentException(loggable.getMessage());
                }
                throw new WLDeploymentException(loggable.getMessage());
            }
            catch (NamingException namingException) {
            }
        }
    }

    public EjbJndiBinder getJndiBinder() {
        if (this.jndiBinder == null) {
            this.jndiBinder = new Ejb3SessionBinder(this);
        }
        return this.jndiBinder;
    }

    public boolean isRetainifException(Method method) {
        Method method2 = this.getRemoveMethodFromBIMethod(method);
        Boolean bl = (Boolean)this.removeMethodToRetainIfExceptionMap.get(method2);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public boolean isRemoveMethod(Method method) {
        Method method2 = this.getRemoveMethodFromBIMethod(method);
        return method2 != null;
    }

    private Method getRemoveMethodFromBIMethod(Method method) {
        if (this.interfaceMethodWithoutRemove.contains(method)) {
            return null;
        }
        Method method2 = (Method)this.interfaceMethodToRemoveMethodMap.get(method);
        if (method2 != null) {
            return method2;
        }
        if (this.removeMethodToRetainIfExceptionMap.size() < 1) {
            return null;
        }
        String string = method.getName();
        Class<?>[] classArray = method.getParameterTypes();
        Iterator iterator = this.removeMethodToRetainIfExceptionMap.keySet().iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            method2 = (Method)iterator.next();
            Class<?>[] classArray2 = method2.getParameterTypes();
            if (!string.equals(method2.getName()) || classArray.length != classArray2.length) continue;
            bl = true;
            for (int i = 0; i < classArray.length; ++i) {
                if (classArray[i].equals(classArray2)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            this.interfaceMethodToRemoveMethodMap.put(method, method2);
            return method2;
        }
        this.interfaceMethodWithoutRemove.add(method);
        return null;
    }

    public String getEjbCreateInitMethodName(Method method) {
        String string = null;
        String string2 = method.getName();
        SessionBeanBean sessionBeanBean = (SessionBeanBean)this.m_desc.getBean();
        InitMethodBean[] initMethodBeanArray = sessionBeanBean.getInitMethods();
        for (int i = 0; i < initMethodBeanArray.length; ++i) {
            Class<?>[] classArray = method.getParameterTypes();
            if (initMethodBeanArray[i].getCreateMethod().getMethodParams() == null) {
                if (!initMethodBeanArray[i].getCreateMethod().getMethodName().equalsIgnoreCase(method.getName())) continue;
                return initMethodBeanArray[i].getBeanMethod().getMethodName();
            }
            String[] stringArray = initMethodBeanArray[i].getCreateMethod().getMethodParams().getMethodParams();
            if (stringArray.length != classArray.length || !initMethodBeanArray[i].getCreateMethod().getMethodName().equalsIgnoreCase(method.getName())) continue;
            boolean bl = true;
            for (int j = 0; j < classArray.length; ++j) {
                if (classArray[j].getName().equalsIgnoreCase(stringArray[j])) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            string = initMethodBeanArray[i].getBeanMethod().getMethodName();
            break;
        }
        if (string == null) {
            string = "ejb" + string2.substring(0, 1).toUpperCase(Locale.ENGLISH) + string2.substring(1);
        }
        return string;
    }

    public boolean containsExtendedPersistenceContextRefs() {
        return this.extendedPersistenceContextRefs.length > 0;
    }

    public PersistenceContextRefBean[] getExtendedPersistenceContextRefs() {
        return this.extendedPersistenceContextRefs;
    }

    public void activate(Context context, Map map, Map map2, DeploymentInfo deploymentInfo, Context context2) throws WLDeploymentException {
        super.activate(context, map, map2, deploymentInfo, context2);
        try {
            context2.bind("comp/EJBContext", (Object)new SessionContextProxyImpl());
        }
        catch (NamingException namingException) {
            throw new WLDeploymentException("Error binding EJBContext: " + namingException, namingException);
        }
    }

    public void setPersistenceUnitRegistry(PersistenceUnitRegistry persistenceUnitRegistry) {
        if (this.containsExtendedPersistenceContextRefs()) {
            PersistenceContextRefBean[] persistenceContextRefBeanArray = this.getExtendedPersistenceContextRefs();
            HashSet<String> hashSet = new HashSet<String>();
            for (int i = 0; i < persistenceContextRefBeanArray.length; ++i) {
                hashSet.add(persistenceContextRefBeanArray[i].getPersistenceUnitName());
            }
            HashMap<String, PersistenceUnitInfoImpl> hashMap = new HashMap<String, PersistenceUnitInfoImpl>();
            Class clazz = this.getGeneratedBeanClass();
            for (String string : hashSet) {
                PersistenceUnitInfoImpl persistenceUnitInfoImpl = persistenceUnitRegistry.getPersistenceUnit(string);
                hashMap.put(string, persistenceUnitInfoImpl);
            }
            StatefulSessionManager statefulSessionManager = (StatefulSessionManager)this.getBeanManager();
            statefulSessionManager.setExtendedPersistenceContextMap(hashMap);
        }
        this.persistenceUnitRegistry = persistenceUnitRegistry;
    }

    public void bindEJBRefs(Context context) throws NamingException {
        super.bindEJBRefs(context);
        if (this.hasBusinessRemotes()) {
            this.bindBusinessObjects(context, (Ejb3SessionHome)((Object)this.getRemoteHome()), this.businessRemoteInterfaces);
        }
        if (this.hasBusinessLocals()) {
            this.bindBusinessObjects(context, (Ejb3SessionHome)((Object)this.getLocalHome()), this.businessLocalInterfaces);
        }
    }

    public void unbindEJBRefs(Context context) throws NamingException {
        super.unbindEJBRefs(context);
        if (this.hasBusinessRemotes()) {
            this.unbindBusinessObjects(context, this.businessRemoteInterfaces);
        }
        if (this.hasBusinessLocals()) {
            this.unbindBusinessObjects(context, this.businessLocalInterfaces);
        }
    }

    private void bindBusinessObjects(Context context, Ejb3SessionHome ejb3SessionHome, Set set) throws NamingException {
        for (Class clazz : set) {
            context.bind(clazz.getName(), ejb3SessionHome.getBindableImpl(clazz));
        }
    }

    private void unbindBusinessObjects(Context context, Set set) throws NamingException {
        for (Class clazz : set) {
            context.unbind(clazz.getName());
        }
    }

    public void onUndeploy() {
        block5: {
            for (Class clazz : this.jndiNameMap.keySet()) {
                Ejb3SessionHome ejb3SessionHome = (Ejb3SessionHome)((Object)this.getRemoteHome());
                Object object = ejb3SessionHome.getBindableImpl(clazz);
                if (!Remote.class.isAssignableFrom(clazz)) continue;
                try {
                    ServerHelper.unexportObject((Object)object, (boolean)true, (boolean)true);
                }
                catch (NoSuchObjectException noSuchObjectException) {}
            }
            try {
                this.getBeanManager().getEnvironmentContext().unbind("comp/EJBContext");
            }
            catch (NamingException namingException) {
                if (!debugLogger.isDebugEnabled()) break block5;
                Ejb3SessionBeanInfoImpl.debug("error unbinding EJBContext from local environment: " + namingException);
            }
        }
        super.onUndeploy();
    }

    private static void debug(String string) {
        debugLogger.debug("[Ejb3SessionBeanInfoImpl] " + string);
    }
}

