/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.deployer;

import java.rmi.Remote;
import java.util.Map;
import java.util.Set;
import javax.naming.LinkRef;
import javax.naming.NamingException;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.deployer.Ejb2JndiBinder;
import weblogic.ejb.container.deployer.EjbJndiBinder;
import weblogic.ejb.container.interfaces.Ejb3SessionBeanInfo;
import weblogic.ejb.container.interfaces.Ejb3SessionHome;
import weblogic.ejb.container.internal.AggregatableOpaqueReference;
import weblogic.ejb.container.internal.StatelessEJBHomeImpl;
import weblogic.ejb.spi.WLDeploymentException;
import weblogic.logging.Loggable;

public class Ejb3SessionBinder
extends Ejb2JndiBinder
implements EjbJndiBinder {
    Ejb3SessionBinder(Ejb3SessionBeanInfo ejb3SessionBeanInfo) {
        super(ejb3SessionBeanInfo);
    }

    private void bindRemoteProxy() throws NamingException {
        Ejb3SessionBeanInfo ejb3SessionBeanInfo = (Ejb3SessionBeanInfo)this.beanInfo;
        if (ejb3SessionBeanInfo.isStateful() || ejb3SessionBeanInfo.getBusinessRemotes().isEmpty()) {
            return;
        }
        Map map = ejb3SessionBeanInfo.getRemoteBusinessJNDINames();
        for (Class clazz : map.keySet()) {
            if (Remote.class.isAssignableFrom(clazz)) continue;
            String string = (String)map.get(clazz);
            Object object = ((Ejb3SessionHome)((Object)ejb3SessionBeanInfo.getRemoteHome())).getBindableImpl(clazz);
            object = new AggregatableOpaqueReference(ejb3SessionBeanInfo.getIsIdenticalKey(), clazz.getName(), object);
            boolean bl = ejb3SessionBeanInfo.getClusteringDescriptor().getStatelessBeanIsClusterable();
            this.jndiService.bind(string, object, bl);
        }
    }

    private void bindClusterableObject() throws NamingException {
        Ejb3SessionBeanInfo ejb3SessionBeanInfo = (Ejb3SessionBeanInfo)this.beanInfo;
        if (ejb3SessionBeanInfo.isStateful() || ejb3SessionBeanInfo.getBusinessRemotes().isEmpty()) {
            return;
        }
        Set set = ejb3SessionBeanInfo.getBusinessRemotes();
        Map map = ejb3SessionBeanInfo.getRemoteBusinessJNDINames();
        for (Class clazz : set) {
            Object object;
            String string = (String)map.get(clazz);
            if (string == null) continue;
            boolean bl = ejb3SessionBeanInfo.getClusteringDescriptor().getStatelessBeanIsClusterable();
            if (Remote.class.isAssignableFrom(clazz)) {
                object = ((StatelessEJBHomeImpl)ejb3SessionBeanInfo.getRemoteHome()).getBindableImpl(clazz);
                this.jndiService.bind(string, object, bl);
                continue;
            }
            object = ejb3SessionBeanInfo.getIsIdenticalKey().replace('.', '_') + "_" + clazz.getSimpleName();
            Object object2 = ((StatelessEJBHomeImpl)ejb3SessionBeanInfo.getRemoteHome()).getBindableEO((String)object);
            this.jndiService.bind((String)object, object2, bl);
        }
    }

    private void bindOpaqueRefImpl() throws NamingException {
        Ejb3SessionBeanInfo ejb3SessionBeanInfo = (Ejb3SessionBeanInfo)this.beanInfo;
        if (!ejb3SessionBeanInfo.isStateful() || ejb3SessionBeanInfo.getBusinessRemotes().isEmpty()) {
            return;
        }
        Set set = ejb3SessionBeanInfo.getBusinessRemotes();
        Map map = ejb3SessionBeanInfo.getRemoteBusinessJNDINames();
        for (Class clazz : set) {
            String string = (String)map.get(clazz);
            if (string == null) continue;
            Object object = ((Ejb3SessionHome)((Object)ejb3SessionBeanInfo.getRemoteHome())).getBindableImpl(clazz);
            if (!Remote.class.isAssignableFrom(clazz)) {
                object = new AggregatableOpaqueReference(ejb3SessionBeanInfo.getIsIdenticalKey(), clazz.getName(), object);
            }
            this.jndiService.replicatedBind(string, object);
        }
    }

    public void bindToJNDI() throws WLDeploymentException {
        Ejb3SessionBeanInfo ejb3SessionBeanInfo = (Ejb3SessionBeanInfo)this.beanInfo;
        if (ejb3SessionBeanInfo.hasDeclaredRemoteHome() || ejb3SessionBeanInfo.hasDeclaredLocalHome()) {
            super.bindToJNDI();
        }
        if (!ejb3SessionBeanInfo.hasBusinessRemotes()) {
            return;
        }
        try {
            this.bindClusterableObject();
            String string = ejb3SessionBeanInfo.getIsIdenticalKey().replace('.', '_') + "_Home";
            if (!ejb3SessionBeanInfo.hasDeclaredRemoteHome() || string.equals(ejb3SessionBeanInfo.getJNDIName().toString())) {
                this.jndiService.replicatedBind(string, (Object)ejb3SessionBeanInfo.getRemoteHome());
            }
            this.bindOpaqueRefImpl();
            this.bindRemoteProxy();
        }
        catch (NamingException namingException) {
            Loggable loggable = EJBLogger.logBusinessJNDIRebindFailedLoggable((String)ejb3SessionBeanInfo.getJNDINameAsString(), (String)namingException.toString());
            this.unbindFromJNDI();
            throw new WLDeploymentException(loggable.getMessage(), namingException);
        }
    }

    private void bindLocalBusinessIntf() throws NamingException {
        Ejb3SessionBeanInfo ejb3SessionBeanInfo = (Ejb3SessionBeanInfo)this.beanInfo;
        if (ejb3SessionBeanInfo.getBusinessLocals().size() > 0 && ejb3SessionBeanInfo.getLocalJNDIName() != null) {
            String string = ejb3SessionBeanInfo.getComponentURI() + "#" + ejb3SessionBeanInfo.getEJBName();
            LinkRef linkRef = new LinkRef("java:app/ejb/" + string + "/local-home");
            this.jndiService.nonReplicatedBind(ejb3SessionBeanInfo.getLocalJNDIName(), (Object)linkRef);
        }
    }
}

