/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.deployer;

import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import weblogic.deployment.EjbInfo;
import weblogic.ejb.container.interfaces.BeanInfo;
import weblogic.ejb.container.interfaces.ClientDrivenBeanInfo;
import weblogic.ejb.container.interfaces.Ejb3SessionBeanInfo;

public final class EjbInfoImpl
implements EjbInfo {
    private BeanInfo bi;
    private SoftReference interfaceNames;

    public EjbInfoImpl(BeanInfo beanInfo) {
        this.bi = beanInfo;
    }

    public String getHomeName() {
        if (this.bi instanceof ClientDrivenBeanInfo) {
            return ((ClientDrivenBeanInfo)this.bi).getHomeInterfaceName();
        }
        return null;
    }

    public String getLocalHomeName() {
        if (this.bi instanceof ClientDrivenBeanInfo) {
            return ((ClientDrivenBeanInfo)this.bi).getLocalHomeInterfaceName();
        }
        return null;
    }

    public String[] getLocalBusinessInterfaceNames() {
        if (this.bi instanceof Ejb3SessionBeanInfo) {
            return ((Ejb3SessionBeanInfo)this.bi).getBusinessLocalNames();
        }
        return new String[0];
    }

    public String[] getRemoteBusinessInterfaceNames() {
        if (this.bi instanceof Ejb3SessionBeanInfo) {
            return ((Ejb3SessionBeanInfo)this.bi).getBusinessRemoteNames();
        }
        return new String[0];
    }

    public String[] getImplementedInterfaceNames() {
        return this.getInterfaceNames().toArray(new String[1]);
    }

    public boolean implementsInterface(String string) {
        if (string == null) {
            return false;
        }
        return this.getInterfaceNames().contains(string);
    }

    private Set getInterfaceNames() {
        Set<String> set;
        if (this.interfaceNames != null && (set = (Set)this.interfaceNames.get()) != null) {
            return set;
        }
        set = new HashSet();
        if (this.bi instanceof ClientDrivenBeanInfo) {
            ClientDrivenBeanInfo clientDrivenBeanInfo = (ClientDrivenBeanInfo)this.bi;
            if (clientDrivenBeanInfo.hasDeclaredRemoteHome()) {
                set.add(clientDrivenBeanInfo.getHomeInterfaceName());
            }
            if (clientDrivenBeanInfo.hasDeclaredLocalHome()) {
                set.add(clientDrivenBeanInfo.getLocalHomeInterfaceName());
            }
            if (this.bi instanceof Ejb3SessionBeanInfo) {
                Ejb3SessionBeanInfo ejb3SessionBeanInfo = (Ejb3SessionBeanInfo)this.bi;
                if (ejb3SessionBeanInfo.hasBusinessLocals()) {
                    set.addAll(Arrays.asList(ejb3SessionBeanInfo.getBusinessLocalNames()));
                }
                if (ejb3SessionBeanInfo.hasBusinessRemotes()) {
                    set.addAll(Arrays.asList(ejb3SessionBeanInfo.getBusinessRemoteNames()));
                }
            }
        }
        this.interfaceNames = new SoftReference(set);
        return set;
    }
}

