/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.deployer;

import java.util.ArrayList;
import java.util.List;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.container.EJBDebugService;
import weblogic.jndi.Environment;

public class EjbJndiService {
    private static final DebugLogger debugLogger = EJBDebugService.deploymentLogger;
    private boolean clientsOnSameServer;
    private Context ctx;
    private List<BoundEnv> boundEnvs = new ArrayList<BoundEnv>();

    EjbJndiService(boolean bl) {
        this.clientsOnSameServer = bl;
    }

    public void replicatedBind(String string, Object object) throws NamingException {
        this.bind(string, object, true);
    }

    public void nonReplicatedBind(String string, Object object) throws NamingException {
        this.bind(string, object, false);
    }

    public void replicatedBind(Name name, Object object) throws NamingException {
        this.bind(name, object, true);
    }

    public void nonReplicatedBind(Name name, Object object) throws NamingException {
        this.bind(name, object, false);
    }

    public void bind(String string, Object object, boolean bl) throws NamingException {
        this.initCtx(bl);
        this.ctx.bind(string, object);
        this.boundEnvs.add(new BoundEnv(string, bl));
    }

    public void bind(Name name, Object object, boolean bl) throws NamingException {
        this.initCtx(bl);
        this.ctx.bind(name, object);
        this.boundEnvs.add(new BoundEnv(name.toString(), bl));
    }

    public void unbind(Name name) {
        this.unbind(name.toString());
    }

    public void unbind(String string) {
        if (string == null) {
            return;
        }
        boolean bl = true;
        for (BoundEnv boundEnv : this.boundEnvs) {
            if (!string.equals(boundEnv.name)) continue;
            bl = boundEnv.replicatedBind;
            break;
        }
        this.unbind(string, bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void unbind(String string, boolean bl) {
        if (string == null) {
            return;
        }
        try {
            if (this.ctx == null) {
                Environment environment = new Environment();
                this.ctx = environment.getInitialContext();
            }
            this.initCtx(bl);
            this.ctx.unbind(string);
            while (string.indexOf(46) > 0) {
                int n = string.lastIndexOf(46);
                string = string.substring(0, n);
                try {
                    this.ctx.destroySubcontext(string);
                }
                catch (Exception exception) {
                    if (!debugLogger.isDebugEnabled()) return;
                    debugLogger.debug("error in unbind " + string, (Throwable)exception);
                    return;
                }
            }
        }
        catch (NamingException namingException) {
            if (!debugLogger.isDebugEnabled()) return;
            debugLogger.debug("error in unbind " + string, (Throwable)namingException);
        }
    }

    public void unbindAll() {
        block4: {
            for (int i = this.boundEnvs.size() - 1; i > -1; --i) {
                BoundEnv boundEnv = this.boundEnvs.get(i);
                this.unbind(boundEnv.name, boundEnv.replicatedBind);
            }
            this.boundEnvs.clear();
            if (this.ctx != null) {
                try {
                    this.ctx.close();
                    this.ctx = null;
                }
                catch (NamingException namingException) {
                    if (!debugLogger.isDebugEnabled()) break block4;
                    debugLogger.debug("error in unbind", (Throwable)namingException);
                }
            }
        }
    }

    private void initCtx(boolean bl) throws NamingException {
        if (this.ctx == null) {
            Environment environment = new Environment();
            environment.setCreateIntermediateContexts(true);
            this.ctx = environment.getInitialContext();
        }
        if (this.clientsOnSameServer) {
            this.ctx.addToEnvironment("weblogic.jndi.replicateBindings", "false");
        } else {
            this.ctx.addToEnvironment("weblogic.jndi.replicateBindings", String.valueOf(bl));
        }
    }

    private static class BoundEnv {
        final String name;
        final boolean replicatedBind;

        BoundEnv(String string, boolean bl) {
            this.name = string;
            this.replicatedBind = bl;
        }
    }
}

