/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.deployer;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import javax.naming.Context;
import kodo.jdbc.conf.descriptor.PersistenceUnitConfigurationBean;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BeanUpdateRejectedException;
import weblogic.descriptor.DescriptorBean;
import weblogic.ejb.QueryHome;
import weblogic.ejb.QueryLocalHome;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.compliance.EJBComplianceTextFormatter;
import weblogic.ejb.container.dd.DDDefaults;
import weblogic.ejb.container.dd.xml.DDUtils;
import weblogic.ejb.container.deployer.CMPInfoImpl;
import weblogic.ejb.container.deployer.ClientDrivenBeanInfoImpl;
import weblogic.ejb.container.deployer.CompositeMBeanDescriptor;
import weblogic.ejb.container.deployer.EntityBeanQueryImpl;
import weblogic.ejb.container.deployer.NamingConvention;
import weblogic.ejb.container.interfaces.BeanManager;
import weblogic.ejb.container.interfaces.CMPInfo;
import weblogic.ejb.container.interfaces.DeploymentInfo;
import weblogic.ejb.container.interfaces.EntityBeanInfo;
import weblogic.ejb.container.interfaces.InvalidationBeanManager;
import weblogic.ejb.container.interfaces.MethodInfo;
import weblogic.ejb.container.interfaces.PoolIntf;
import weblogic.ejb.container.interfaces.QueryCache;
import weblogic.ejb.container.interfaces.ReadOnlyManager;
import weblogic.ejb.container.internal.EJBComponentRuntimeMBeanImpl;
import weblogic.ejb.container.internal.MethodDescriptor;
import weblogic.ejb.container.manager.BaseEntityManager;
import weblogic.ejb.container.manager.BeanManagedPersistenceManager;
import weblogic.ejb.container.manager.DBManager;
import weblogic.ejb.container.manager.ExclusiveEntityManager;
import weblogic.ejb.container.manager.ReadOnlyEntityManager;
import weblogic.ejb.container.manager.TTLManager;
import weblogic.ejb.container.persistence.spi.PersistenceManager;
import weblogic.ejb.spi.EJBCache;
import weblogic.ejb.spi.WLDeploymentException;
import weblogic.j2ee.descriptor.EntityBeanBean;
import weblogic.j2ee.descriptor.QueryBean;
import weblogic.j2ee.descriptor.wl.ApplicationEntityCacheBean;
import weblogic.j2ee.descriptor.wl.AutomaticKeyGenerationBean;
import weblogic.j2ee.descriptor.wl.EntityCacheBean;
import weblogic.j2ee.descriptor.wl.EntityCacheRefBean;
import weblogic.j2ee.descriptor.wl.PoolBean;
import weblogic.j2ee.descriptor.wl.TransactionDescriptorBean;
import weblogic.logging.Loggable;
import weblogic.utils.AssertionError;
import weblogic.utils.classloaders.GenericClassLoader;

public final class EntityBeanInfoImpl
extends ClientDrivenBeanInfoImpl
implements EntityBeanInfo {
    protected static EJBComplianceTextFormatter fmt;
    private final int concurrencyStrategy;
    private final boolean isBeanManagedPersistence;
    private final String persistenceUseIdentifier;
    private final String persistenceUseVersion;
    private final String persistenceUseStorage;
    private boolean cacheBetweenTransactions;
    private boolean boxCarUpdates;
    private String isModifiedMethodName;
    private boolean unknownPK = false;
    private final String primaryKeyClassName;
    private final Collection allQueries;
    private final boolean isReentrant;
    private final CMPInfoImpl cmpInfo;
    private final String generatedBeanClassName;
    private final String generatedBeanInterfaceName;
    private Class generatedBeanClass;
    private Class generatedBeanInterface;
    private Class pkClass;
    private boolean disableReadyInstances;
    private final String invalidationTargetEJBName;
    private String jarFileName;
    private PersistenceManager persistenceManager = null;
    private BeanManager beanManager = null;
    private boolean singleInstanceReadOnly = false;
    private boolean enableDynamicQueries = false;
    private String entityCacheName = null;
    private int estimatedBeanSize = -1;
    private String categoryCmpField = null;

    public EntityBeanInfoImpl(DeploymentInfo deploymentInfo, CompositeMBeanDescriptor compositeMBeanDescriptor, GenericClassLoader genericClassLoader) throws ClassNotFoundException, WLDeploymentException {
        super(deploymentInfo, compositeMBeanDescriptor, genericClassLoader);
        Object object;
        this.jarFileName = compositeMBeanDescriptor.getEJBDescriptor().getJarFileName();
        EntityBeanBean entityBeanBean = (EntityBeanBean)compositeMBeanDescriptor.getBean();
        fmt = new EJBComplianceTextFormatter();
        this.isBeanManagedPersistence = compositeMBeanDescriptor.isBeanManagedPersistence();
        this.isModifiedMethodName = compositeMBeanDescriptor.getIsModifiedMethodName();
        this.boxCarUpdates = compositeMBeanDescriptor.getDelayUpdatesUntilEndOfTx();
        this.primaryKeyClassName = entityBeanBean.getPrimKeyClass();
        if (this.primaryKeyClassName.equals("java.lang.Object")) {
            this.unknownPK = true;
        }
        this.isReentrant = entityBeanBean.isReentrant();
        NamingConvention namingConvention = new NamingConvention(entityBeanBean.getEjbClass(), compositeMBeanDescriptor.getEJBName());
        try {
            this.pkClass = this.loadClass(this.primaryKeyClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ClassNotFoundException(fmt.ENTITYBEANINFOIMPL(this.primaryKeyClassName));
        }
        this.checkClassLoaders(compositeMBeanDescriptor, this.pkClass);
        if (!this.isBeanManagedPersistence) {
            this.cmpInfo = new CMPInfoImpl(this, compositeMBeanDescriptor);
            this.persistenceUseIdentifier = this.cmpInfo.getPersistenceUseIdentifier();
            this.persistenceUseVersion = this.cmpInfo.getPersistenceUseVersion();
            this.persistenceUseStorage = this.cmpInfo.getPersistenceUseStorage();
            if (this.persistenceUseIdentifier != null) {
                this.generatedBeanClassName = namingConvention.getCmpBeanClassName(this.persistenceUseIdentifier);
                if (this.getDeploymentInfo().isEnableBeanClassRedeploy()) {
                    genericClassLoader.excludeClass(this.generatedBeanClassName);
                }
                this.cmpInfo.setGeneratedBeanClassName(this.generatedBeanClassName);
            } else {
                this.generatedBeanClassName = null;
            }
            this.allQueries = new ArrayList();
            object = this.cmpInfo.getAllQueries();
            Enumeration enumeration = Collections.enumeration(object);
            while (enumeration.hasMoreElements()) {
                QueryBean queryBean = (QueryBean)enumeration.nextElement();
                EntityBeanQueryImpl entityBeanQueryImpl = new EntityBeanQueryImpl(queryBean);
                this.allQueries.add(entityBeanQueryImpl);
            }
        } else {
            this.persistenceUseIdentifier = "N/A: not a CMP Bean";
            this.persistenceUseVersion = "N/A: not a CMP Bean";
            this.persistenceUseStorage = "N/A: not a CMP Bean";
            this.generatedBeanClassName = namingConvention.getGeneratedBeanClassName();
            genericClassLoader.excludeClass(this.generatedBeanClassName);
            this.generatedBeanClass = null;
            this.allQueries = null;
            this.cmpInfo = null;
        }
        this.generatedBeanInterfaceName = namingConvention.getGeneratedBeanInterfaceName();
        if (compositeMBeanDescriptor.hasEntityCacheReference()) {
            this.entityCacheName = compositeMBeanDescriptor.getEntityCacheName();
            this.estimatedBeanSize = compositeMBeanDescriptor.getEstimatedBeanSize();
        }
        object = compositeMBeanDescriptor.getConcurrencyStrategy();
        this.concurrencyStrategy = DDUtils.concurrencyStringToInt((String)object);
        this.cacheBetweenTransactions = compositeMBeanDescriptor.getCacheBetweenTransactions();
        this.invalidationTargetEJBName = compositeMBeanDescriptor.getInvalidationTargetEJBName();
        this.disableReadyInstances = compositeMBeanDescriptor.getDisableReadyIntances();
        this.initializeDynamicQueryMethodInfos(compositeMBeanDescriptor);
    }

    public void activate(Context context, Map map, Map map2, DeploymentInfo deploymentInfo, Context context2) throws WLDeploymentException {
        super.activate(context, map, map2, deploymentInfo, context2);
        if (!this.isBeanManagedPersistence) {
            for (MethodDescriptor methodDescriptor : this.getMethodDescriptors()) {
                Method method = methodDescriptor.getMethod();
                if (!this.cmpInfo.isQueryCachingEnabled(method)) continue;
                methodDescriptor.setMethodId(this.cmpInfo.getQueryCachingEnabledFinderIndex(method));
                if (!this.cmpInfo.isEnableEagerRefresh(method)) continue;
                ((TTLManager)this.beanManager).addEagerRefreshMethod(method, methodDescriptor.getMethodId());
            }
        }
    }

    public int getInstanceLockOrder() {
        if (!this.isBeanManagedPersistence) {
            return this.cmpInfo.getInstanceLockOrder();
        }
        return 100;
    }

    public boolean isReadOnlyWithSingleInstance() {
        return this.singleInstanceReadOnly;
    }

    public boolean isReadOnly() {
        return this.concurrencyStrategy == 5;
    }

    public boolean isOptimistic() {
        return this.concurrencyStrategy == 6;
    }

    public int getConcurrencyStrategy() {
        return this.concurrencyStrategy;
    }

    public boolean usesBeanManagedTx() {
        return false;
    }

    public Class getPrimaryKeyClass() {
        return this.pkClass;
    }

    public boolean isUnknownPrimaryKey() {
        return this.unknownPK;
    }

    public boolean getIsBeanManagedPersistence() {
        return this.isBeanManagedPersistence;
    }

    public String getPersistenceUseIdentifier() {
        return this.persistenceUseIdentifier;
    }

    public String getPersistenceUseVersion() {
        return this.persistenceUseVersion;
    }

    public String getPersistenceUseStorage() {
        return this.persistenceUseStorage;
    }

    public boolean getCacheBetweenTransactions() {
        return this.cacheBetweenTransactions;
    }

    public boolean getDisableReadyInstances() {
        return this.disableReadyInstances;
    }

    public boolean getBoxCarUpdates() {
        return this.boxCarUpdates;
    }

    public String getPrimaryKeyClassName() {
        return this.primaryKeyClassName;
    }

    public String getIsModifiedMethodName() {
        return this.isModifiedMethodName;
    }

    public Collection getAllQueries() {
        return this.allQueries;
    }

    public boolean isReentrant() {
        return this.isReentrant;
    }

    public CMPInfo getCMPInfo() {
        return this.cmpInfo;
    }

    public String getGeneratedBeanClassName() {
        return this.generatedBeanClassName;
    }

    public String getGeneratedBeanInterfaceName() {
        return this.generatedBeanInterfaceName;
    }

    public Class getGeneratedBeanClass() {
        try {
            if (this.generatedBeanClass == null) {
                this.generatedBeanClass = this.loadClass(this.generatedBeanClassName);
            }
            return this.generatedBeanClass;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError((Throwable)classNotFoundException);
        }
    }

    public Class getGeneratedBeanInterface() {
        try {
            if (this.generatedBeanInterface == null) {
                this.generatedBeanInterface = this.loadClass(this.generatedBeanInterfaceName);
            }
            return this.generatedBeanInterface;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError((Throwable)classNotFoundException);
        }
    }

    public PersistenceManager getPersistenceManager() {
        if (this.persistenceManager == null) {
            if (this.getIsBeanManagedPersistence()) {
                this.persistenceManager = new BeanManagedPersistenceManager();
            } else {
                assert (this.getCMPInfo() != null);
                assert (this.getCMPInfo().getPersistenceType() != null);
                this.persistenceManager = this.getCMPInfo().getPersistenceType().getPersistenceManager();
            }
        }
        return this.persistenceManager;
    }

    public BeanManager getBeanManagerInstance(EJBComponentRuntimeMBeanImpl eJBComponentRuntimeMBeanImpl) {
        if (this.beanManager == null) {
            switch (this.getConcurrencyStrategy()) {
                case 1: {
                    if (this.getIsBeanManagedPersistence() || !this.getCMPInfo().getPersistenceType().hasExclusiveManager()) {
                        this.beanManager = new ExclusiveEntityManager(eJBComponentRuntimeMBeanImpl);
                        break;
                    }
                    this.beanManager = this.getCMPInfo().getPersistenceType().getExclusiveManager();
                    break;
                }
                case 6: {
                    if (this.getIsBeanManagedPersistence() || !this.getCMPInfo().getPersistenceType().hasDatabaseManager()) {
                        if (this.cacheBetweenTransactions) {
                            this.beanManager = new TTLManager(eJBComponentRuntimeMBeanImpl);
                            break;
                        }
                        this.beanManager = new DBManager(eJBComponentRuntimeMBeanImpl);
                        break;
                    }
                    this.beanManager = this.getCMPInfo().getPersistenceType().getDatabaseManager();
                    break;
                }
                case 2: {
                    if (this.getIsBeanManagedPersistence() || !this.getCMPInfo().getPersistenceType().hasDatabaseManager()) {
                        this.beanManager = new DBManager(eJBComponentRuntimeMBeanImpl);
                        break;
                    }
                    this.beanManager = this.getCMPInfo().getPersistenceType().getDatabaseManager();
                    break;
                }
                case 4: {
                    if (this.getIsBeanManagedPersistence() || !this.getCMPInfo().getPersistenceType().hasReadonlyManager()) {
                        this.beanManager = new ReadOnlyEntityManager(eJBComponentRuntimeMBeanImpl);
                        break;
                    }
                    this.beanManager = this.getCMPInfo().getPersistenceType().getReadonlyManager();
                    break;
                }
                case 5: {
                    if (this.getIsBeanManagedPersistence() || !this.getCMPInfo().getPersistenceType().hasReadonlyManager()) {
                        this.beanManager = new TTLManager(eJBComponentRuntimeMBeanImpl);
                        break;
                    }
                    this.beanManager = this.getCMPInfo().getPersistenceType().getReadonlyManager();
                    break;
                }
                default: {
                    throw new AssertionError("Unexpected value: " + this.getConcurrencyStrategy());
                }
            }
        }
        return this.beanManager;
    }

    private String beanNameToHomeName(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.delete(0, 4);
        if (string.startsWith("ejbF")) {
            return "f" + stringBuffer;
        }
        if (string.startsWith("ejbC")) {
            return "c" + stringBuffer;
        }
        throw new AssertionError("Unexpected method: " + string);
    }

    protected EJBCache getCache(Map map) throws WLDeploymentException {
        EJBCache eJBCache = null;
        if (this.entityCacheName != null) {
            if (map == null) {
                Loggable loggable = EJBLogger.logmustUseTwoPhaseDeploymentLoggable((String)this.getEJBName(), (String)this.entityCacheName);
                throw new WLDeploymentException(loggable.getMessage());
            }
            eJBCache = (EJBCache)map.get(this.entityCacheName);
            if (eJBCache == null) {
                Loggable loggable = EJBLogger.logmissingCacheDefinitionLoggable((String)this.getEJBName(), (String)this.entityCacheName);
                throw new WLDeploymentException(loggable.getMessage());
            }
        }
        return eJBCache;
    }

    protected QueryCache getQueryCache(Map map) throws WLDeploymentException {
        QueryCache queryCache = null;
        if (this.entityCacheName != null) {
            if (map == null) {
                Loggable loggable = EJBLogger.logmustUseTwoPhaseDeploymentLoggable((String)this.getEJBName(), (String)this.entityCacheName);
                throw new WLDeploymentException(loggable.getMessage());
            }
            queryCache = (QueryCache)map.get(this.entityCacheName);
        }
        return queryCache;
    }

    public int getEstimatedBeanSize() {
        return this.estimatedBeanSize;
    }

    public String getCacheName() {
        return this.entityCacheName;
    }

    protected short getTxAttribute(MethodInfo methodInfo, Class clazz) {
        if (this.getConcurrencyStrategy() == 4) {
            return 0;
        }
        return methodInfo.getTransactionAttribute();
    }

    public void assignDefaultTXAttributesIfNecessary() {
        ArrayList<MethodInfo> arrayList = new ArrayList<MethodInfo>();
        if (this.hasRemoteClientView()) {
            arrayList.add(this.getRemoteMethodInfo("getEJBHome()"));
            arrayList.add(this.getRemoteMethodInfo("getHandle()"));
            arrayList.add(this.getRemoteMethodInfo("getPrimaryKey()"));
            arrayList.add(this.getRemoteMethodInfo("isIdentical(javax.ejb.EJBObject)"));
            arrayList.add(this.getHomeMethodInfo("getEJBMetaData()"));
            arrayList.add(this.getHomeMethodInfo("getHomeHandle()"));
        }
        if (this.hasLocalClientView()) {
            arrayList.add(this.getLocalMethodInfo("getEJBLocalHome()"));
            arrayList.add(this.getLocalMethodInfo("getPrimaryKey()"));
            arrayList.add(this.getLocalMethodInfo("isIdentical(javax.ejb.EJBLocalObject)"));
            arrayList.add(this.getLocalMethodInfo("getLocalHandle()"));
        }
        for (MethodInfo methodInfo : arrayList) {
            if (methodInfo == null || methodInfo.getTransactionAttribute() != -1) continue;
            methodInfo.setTransactionAttribute(DDDefaults.getTransactionAttribute(this));
        }
        super.assignDefaultTXAttributesIfNecessary();
    }

    private boolean hasAMethodDescriptor(Method method, Class clazz) {
        String string = method.getName();
        if (string.startsWith("ejbCreate") || string.startsWith("ejbFind")) {
            try {
                clazz.getMethod(this.beanNameToHomeName(string), method.getParameterTypes());
                return true;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return false;
            }
        }
        return false;
    }

    public String getInvalidationTargetEJBName() {
        return this.invalidationTargetEJBName;
    }

    public InvalidationBeanManager getInvalidationTargetBeanManager() {
        if (this.invalidationTargetEJBName == null) {
            return null;
        }
        DeploymentInfo deploymentInfo = this.getDeploymentInfo();
        EntityBeanInfo entityBeanInfo = (EntityBeanInfo)deploymentInfo.getBeanInfo(this.invalidationTargetEJBName);
        if (entityBeanInfo == null) {
            throw new AssertionError("Unable to find entity bean in deployment with name: " + this.invalidationTargetEJBName);
        }
        BeanManager beanManager = entityBeanInfo.getBeanManager();
        if (beanManager == null) {
            throw new AssertionError("Unable to find entity bean in deployment with name: " + this.invalidationTargetEJBName);
        }
        assert (beanManager instanceof InvalidationBeanManager);
        return (InvalidationBeanManager)beanManager;
    }

    public String getJarFileName() {
        return this.jarFileName;
    }

    public boolean isDynamicQueriesEnabled() {
        return this.enableDynamicQueries;
    }

    private void initializeDynamicQueryMethodInfos(CompositeMBeanDescriptor compositeMBeanDescriptor) {
        if (!this.isBeanManagedPersistence && this.getCMPInfo().uses20CMP()) {
            ArrayList<Method> arrayList;
            if (compositeMBeanDescriptor.isDynamicQueriesEnabled()) {
                this.enableDynamicQueries = true;
            }
            if (this.hasRemoteClientView()) {
                arrayList = new ArrayList<Method>();
                arrayList.add(EntityBeanInfoImpl.getRemoteCreateQueryMethod());
                this.createMethodInfoImpls(arrayList, "Home", this.homeMethods);
            }
            if (this.hasLocalClientView()) {
                arrayList = new ArrayList();
                arrayList.add(EntityBeanInfoImpl.getLocalCreateQueryMethod());
                this.createMethodInfoImpls(arrayList, "LocalHome", this.localHomeMethods);
            }
        }
    }

    public static Method getRemoteCreateQueryMethod() {
        return EntityBeanInfoImpl.getCreateQueryMethod(QueryHome.class);
    }

    public static Method getLocalCreateQueryMethod() {
        return EntityBeanInfoImpl.getCreateQueryMethod(QueryLocalHome.class);
    }

    public static String getCreateQuerySignature() {
        return DDUtils.getMethodSignature(EntityBeanInfoImpl.getRemoteCreateQueryMethod());
    }

    public static Method getCreateQueryMethod(Class clazz) {
        try {
            return clazz.getMethod("createQuery", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError("Couldn't find createQuery method");
        }
    }

    public void updateImplClassLoader() throws WLDeploymentException {
        super.updateImplClassLoader();
        try {
            this.generatedBeanClass = this.loadClass(this.generatedBeanClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new WLDeploymentException("Couldn't load updated impl class: " + classNotFoundException);
        }
        if (!this.isBeanManagedPersistence) {
            this.cmpInfo.beanImplClassChangeNotification();
        }
        BeanManager beanManager = this.getBeanManager();
        try {
            beanManager.beanImplClassChangeNotification();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw new WLDeploymentException("Bean Manager does not support partial updates");
        }
    }

    public void updateReadTimeoutSeconds(int n) {
        this.getCachingDescriptor().setReadTimeoutSeconds(n);
        BeanManager beanManager = this.getBeanManager();
        if (beanManager instanceof ReadOnlyManager) {
            ((ReadOnlyManager)((Object)beanManager)).updateReadTimeoutSeconds(n);
        }
        if (debugLogger.isDebugEnabled()) {
            EntityBeanInfoImpl.debug("updated ReadTimeoutSeconds to " + n + " for EJB " + this.getDisplayName());
        }
    }

    public void updateKeyCacheSize(int n) {
        BeanManager beanManager = this.getBeanManager();
        if (beanManager instanceof BaseEntityManager) {
            ((BaseEntityManager)beanManager).updateKeyCacheSize(n);
        }
        if (debugLogger.isDebugEnabled()) {
            EntityBeanInfoImpl.debug("updated KeyCacheSize to " + n + " for EJB " + this.getDisplayName());
        }
    }

    public void updateMaxBeansInFreePool(int n) {
        BeanManager beanManager = this.getBeanManager();
        if (beanManager instanceof BaseEntityManager) {
            PoolIntf poolIntf = ((BaseEntityManager)beanManager).getPool();
            poolIntf.updateMaxBeansInFreePool(n);
        }
        if (debugLogger.isDebugEnabled()) {
            EntityBeanInfoImpl.debug("updated MaxBeansInFreePool to " + n + " for EJB " + this.getDisplayName());
        }
    }

    public void updatePoolIdleTimeoutSeconds(int n) {
        BeanManager beanManager = this.getBeanManager();
        if (beanManager instanceof BaseEntityManager) {
            PoolIntf poolIntf = ((BaseEntityManager)beanManager).getPool();
            poolIntf.updateIdleTimeoutSeconds(n);
        }
        if (debugLogger.isDebugEnabled()) {
            EntityBeanInfoImpl.debug("updated Pool IdleTimeoutSeconds to " + n + " for EJB " + this.getDisplayName());
        }
    }

    public int getMaxQueriesInCache() {
        if (this.isBeanManagedPersistence) {
            return 0;
        }
        return this.getCMPInfo().getMaxQueriesInCache();
    }

    public void prepareUpdate(BeanUpdateEvent beanUpdateEvent) throws BeanUpdateRejectedException {
        if (debugLogger.isDebugEnabled()) {
            EntityBeanInfoImpl.debug("prepareUpdate: " + beanUpdateEvent);
        }
        BeanUpdateEvent.PropertyUpdate[] propertyUpdateArray = beanUpdateEvent.getUpdateList();
        DescriptorBean descriptorBean = beanUpdateEvent.getProposedBean();
        block4: for (int i = 0; i < propertyUpdateArray.length; ++i) {
            BeanUpdateEvent.PropertyUpdate propertyUpdate = propertyUpdateArray[i];
            switch (propertyUpdate.getUpdateType()) {
                case 1: {
                    int n;
                    PersistenceUnitConfigurationBean persistenceUnitConfigurationBean;
                    String string = propertyUpdate.getPropertyName();
                    if (debugLogger.isDebugEnabled()) {
                        EntityBeanInfoImpl.debug("Preparing property of type: " + string);
                    }
                    if (string.equals("LockTimeout")) {
                        if (debugLogger.isDebugEnabled()) {
                            EntityBeanInfoImpl.debug("Preparing persistence property: " + string);
                        }
                        persistenceUnitConfigurationBean = (PersistenceUnitConfigurationBean)descriptorBean;
                        n = persistenceUnitConfigurationBean.getLockTimeout();
                        this.prepareLockTimeout(n);
                        continue block4;
                    }
                    if (string.equals("DataCacheTimeout")) {
                        if (debugLogger.isDebugEnabled()) {
                            EntityBeanInfoImpl.debug("Preparing persistence property: " + string);
                        }
                        persistenceUnitConfigurationBean = (PersistenceUnitConfigurationBean)descriptorBean;
                        n = persistenceUnitConfigurationBean.getDataCacheTimeout();
                        this.prepareDataCacheTimeout(n);
                        continue block4;
                    }
                    if (string.equals("FetchBatchSize")) {
                        if (debugLogger.isDebugEnabled()) {
                            EntityBeanInfoImpl.debug("Preparing persistence property: " + string);
                        }
                        persistenceUnitConfigurationBean = (PersistenceUnitConfigurationBean)descriptorBean;
                        n = persistenceUnitConfigurationBean.getFetchBatchSize();
                        this.prepareFetchBatchSize(n);
                        continue block4;
                    }
                    throw new AssertionError("Unexpected propertyName: " + string);
                }
                case 2: 
                case 3: {
                    throw new AssertionError("Unexpected BeanUpdateEvent: " + beanUpdateEvent);
                }
            }
        }
    }

    public void rollbackUpdate(BeanUpdateEvent beanUpdateEvent) {
        if (debugLogger.isDebugEnabled()) {
            EntityBeanInfoImpl.debug("rollbackUpdate: " + beanUpdateEvent);
        }
    }

    public void activateUpdate(BeanUpdateEvent beanUpdateEvent) {
        if (debugLogger.isDebugEnabled()) {
            EntityBeanInfoImpl.debug("activateUpdate: " + beanUpdateEvent);
        }
        BeanUpdateEvent.PropertyUpdate[] propertyUpdateArray = beanUpdateEvent.getUpdateList();
        DescriptorBean descriptorBean = beanUpdateEvent.getProposedBean();
        block4: for (int i = 0; i < propertyUpdateArray.length; ++i) {
            BeanUpdateEvent.PropertyUpdate propertyUpdate = propertyUpdateArray[i];
            switch (propertyUpdate.getUpdateType()) {
                case 1: {
                    int n;
                    String string;
                    PoolBean poolBean;
                    String string2 = propertyUpdate.getPropertyName();
                    if (debugLogger.isDebugEnabled()) {
                        EntityBeanInfoImpl.debug("Changing property of type: " + string2);
                    }
                    if (string2.equals("MaxBeansInFreePool")) {
                        poolBean = (PoolBean)descriptorBean;
                        this.updateMaxBeansInFreePool(poolBean.getMaxBeansInFreePool());
                        continue block4;
                    }
                    if (string2.equals("MaxBeansInCache")) {
                        if (descriptorBean instanceof EntityCacheBean) {
                            poolBean = (EntityCacheBean)descriptorBean;
                            this.updateMaxBeansInCache(poolBean.getMaxBeansInCache());
                            continue block4;
                        }
                        poolBean = (ApplicationEntityCacheBean)descriptorBean;
                        this.updateMaxBeansInCache(poolBean.getMaxBeansInCache());
                        continue block4;
                    }
                    if (string2.equals("TransTimeoutSeconds")) {
                        poolBean = (TransactionDescriptorBean)descriptorBean;
                        this.updateTransactionTimeoutSeconds(poolBean.getTransTimeoutSeconds());
                        continue block4;
                    }
                    if (string2.equals("IdleTimeoutSeconds")) {
                        if (descriptorBean instanceof EntityCacheBean) {
                            poolBean = (EntityCacheBean)descriptorBean;
                            this.updateCacheIdleTimeoutSeconds(poolBean.getIdleTimeoutSeconds());
                            continue block4;
                        }
                        if (descriptorBean instanceof EntityCacheRefBean) {
                            poolBean = (EntityCacheRefBean)descriptorBean;
                            this.updateCacheIdleTimeoutSeconds(poolBean.getIdleTimeoutSeconds());
                            continue block4;
                        }
                        poolBean = (PoolBean)descriptorBean;
                        this.updatePoolIdleTimeoutSeconds(poolBean.getIdleTimeoutSeconds());
                        continue block4;
                    }
                    if (string2.equals("ReadTimeoutSeconds")) {
                        if (descriptorBean instanceof EntityCacheBean) {
                            poolBean = (EntityCacheBean)descriptorBean;
                            this.updateReadTimeoutSeconds(poolBean.getReadTimeoutSeconds());
                            continue block4;
                        }
                        poolBean = (EntityCacheRefBean)descriptorBean;
                        this.updateReadTimeoutSeconds(poolBean.getReadTimeoutSeconds());
                        continue block4;
                    }
                    if (string2.equals("KeyCacheSize")) {
                        poolBean = (AutomaticKeyGenerationBean)descriptorBean;
                        this.updateKeyCacheSize(poolBean.getKeyCacheSize());
                        continue block4;
                    }
                    if (string2.equals("LockTimeout")) {
                        if (debugLogger.isDebugEnabled()) {
                            EntityBeanInfoImpl.debug("Changing persistence property: " + string2);
                        }
                        poolBean = (PersistenceUnitConfigurationBean)descriptorBean;
                        string = poolBean.getName();
                        n = poolBean.getLockTimeout();
                        this.updateLockTimeout(n, string);
                        continue block4;
                    }
                    if (string2.equals("DataCacheTimeout")) {
                        if (debugLogger.isDebugEnabled()) {
                            EntityBeanInfoImpl.debug("Changing persistence property: " + string2);
                        }
                        poolBean = (PersistenceUnitConfigurationBean)descriptorBean;
                        string = poolBean.getName();
                        n = poolBean.getDataCacheTimeout();
                        this.updateDataCacheTimeout(n, string);
                        continue block4;
                    }
                    if (string2.equals("FetchBatchSize")) {
                        if (debugLogger.isDebugEnabled()) {
                            EntityBeanInfoImpl.debug("Changing persistence property: " + string2);
                        }
                        poolBean = (PersistenceUnitConfigurationBean)descriptorBean;
                        string = poolBean.getName();
                        n = poolBean.getFetchBatchSize();
                        this.updateFetchBatchSize(n, string);
                        continue block4;
                    }
                    throw new AssertionError("Unexpected propertyName: " + string2);
                }
                case 2: 
                case 3: {
                    throw new AssertionError("Unexpected BeanUpdateEvent: " + beanUpdateEvent);
                }
            }
        }
    }

    public void updateCacheIdleTimeoutSeconds(int n) {
        this.getCachingDescriptor().setIdleTimeoutSecondsCache(n);
        super.updateCacheIdleTimeoutSeconds(n);
    }

    private static void debug(String string) {
        debugLogger.debug("[EntityBeanInfoImpl] " + string);
    }

    public boolean isEntityBean() {
        return true;
    }

    public String getCategoryCmpField() {
        return this.categoryCmpField;
    }

    public void setCategoryCmpField(String string) {
        this.categoryCmpField = string;
    }
}

