/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.deployer;

import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.ejb.EJBContext;
import javax.ejb.TimerService;
import javax.jms.JMSException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.transaction.UserTransaction;
import javax.xml.ws.WebServiceContext;
import org.omg.CORBA.ORB;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.cacheprovider.coherence.jndi.CoherenceOpaqueReference;
import weblogic.deployment.BaseEnvironmentBuilder;
import weblogic.deployment.EnvironmentException;
import weblogic.deployment.JMSConnFactoryOpaqueReferenceImpl;
import weblogic.deployment.URLOpaqueReferenceImpl;
import weblogic.deployment.jms.PooledConnectionFactory;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.deployer.TimerServiceProxyImpl;
import weblogic.ejb.container.interfaces.BeanInfo;
import weblogic.j2ee.J2EELogger;
import weblogic.j2ee.descriptor.EjbLocalRefBean;
import weblogic.j2ee.descriptor.EjbRefBean;
import weblogic.j2ee.descriptor.EnvEntryBean;
import weblogic.j2ee.descriptor.ResourceEnvRefBean;
import weblogic.j2ee.descriptor.ResourceRefBean;
import weblogic.logging.Loggable;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.AssertionError;
import weblogic.utils.Debug;
import weblogic.utils.StackTraceUtils;
import weblogic.work.j2ee.J2EEWorkManager;

public final class EnvironmentBuilder
extends BaseEnvironmentBuilder {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private BeanInfo bi;
    protected static final String EJB_CONTEXT_BINDING = "comp/EJBContext";
    protected static final String TIMERSERVICE_BINDING = "comp/TimerService";
    protected static final String WEB_SERVICE_CONTEXT_BINDING = "comp/WebServiceContext";

    public EnvironmentBuilder(Context context, String string, String string2, String string3, BeanInfo beanInfo) throws NamingException {
        super(context, string, string2, string3);
        this.bi = beanInfo;
    }

    protected String transformJNDIName(String string) {
        return EnvironmentBuilder.transformJNDIName(string, this.applicationName);
    }

    private Object getValue(EnvEntryBean envEntryBean) throws EnvironmentException {
        Object object;
        String string = envEntryBean.getEnvEntryType();
        String string2 = envEntryBean.getEnvEntryValue();
        if (DEBUG) {
            object = new HashSet<Object>(Arrays.asList((Object[])new String[]{"java.lang.String", "java.lang.Boolean", "java.lang.Integer", "java.lang.Double", "java.lang.Float", "java.lang.Short", "java.lang.Long", "java.lang.Byte", "java.lang.Character"}));
            Debug.assertion((boolean)object.contains(string));
        }
        if ("java.lang.String".equals(string)) {
            if (string2 == null) {
                return "";
            }
            return string2;
        }
        if ("java.lang.Character".equals(string)) {
            if (string2 != null && string2.length() > 0) {
                return new Character(string2.charAt(0));
            }
            object = EJBLogger.logcharEnvEntryHasLengthZeroLoggable();
            throw new EnvironmentException(object.getMessage());
        }
        try {
            object = ClassLoader.getSystemClassLoader().loadClass(string);
            Constructor constructor = ((Class)object).getConstructor(String.class);
            return constructor.newInstance(string2);
        }
        catch (Exception exception) {
            throw new AssertionError((Throwable)exception);
        }
    }

    protected void bindEnvEntry(Object object) throws NamingException, EnvironmentException {
        EnvEntryBean envEntryBean = (EnvEntryBean)object;
        if (envEntryBean.getEnvEntryValue() != null) {
            this.envCtx.bind(envEntryBean.getEnvEntryName(), this.getValue(envEntryBean));
        }
    }

    protected void unbindEnvEntry(Object object) {
        block2: {
            EnvEntryBean envEntryBean = (EnvEntryBean)object;
            try {
                this.envCtx.unbind(envEntryBean.getEnvEntryName());
            }
            catch (NamingException namingException) {
                if (!DEBUG) break block2;
                namingException.printStackTrace();
            }
        }
    }

    public void removeResourceReferences(Collection collection) {
        if (DEBUG) {
            Debug.assertion((collection != null ? 1 : 0) != 0);
        }
        for (ResourceRefBean resourceRefBean : collection) {
            String string = resourceRefBean.getResType();
            if ("javax.sql.DataSource".equals(string)) {
                this.removeDataSourceRef(resourceRefBean);
                continue;
            }
            if (this.isJMSConnectionFactory(string)) {
                this.removeJMSConnectionFactoryRef(resourceRefBean);
                continue;
            }
            if ("java.net.URL".equals(string)) {
                this.removeURLRef(resourceRefBean);
                continue;
            }
            if ("commonj.work.WorkManager".equals(string)) {
                this.removeWorkManagerRef(resourceRefBean);
                continue;
            }
            if ("commonj.timers.TimerManager".equals(string)) {
                this.removeTimerManagerRef(resourceRefBean.getResRefName());
                continue;
            }
            if ("com.tangosol.net.NamedCache".equals(string) || "com.tangosol.net.Service".equals(string)) {
                this.removeCoherenceEntityRef(resourceRefBean, string);
                continue;
            }
            this.removeConnectorRef(resourceRefBean);
        }
    }

    private boolean isJMSConnectionFactory(String string) {
        return "javax.jms.QueueConnectionFactory".equals(string) || "javax.jms.TopicConnectionFactory".equals(string) || "javax.jms.XAQueueConnectionFactory".equals(string) || "javax.jms.XATopicConnectionFactory".equals(string) || "javax.jms.ConnectionFactory".equals(string) || "javax.jms.XAConnectionFactory".equals(string);
    }

    public void addResourceReferences(Collection collection, Map map, BeanInfo beanInfo) throws NamingException, EnvironmentException {
        if (DEBUG) {
            Debug.assertion((collection != null ? 1 : 0) != 0);
        }
        for (ResourceRefBean resourceRefBean : collection) {
            String string = resourceRefBean.getResType();
            String string2 = resourceRefBean.getResRefName();
            String string3 = (String)map.get(string2);
            if ((string3 == null || string3.length() == 0) && resourceRefBean.getMappedName() != null) {
                map.put(string2, resourceRefBean.getMappedName());
            }
            if ("javax.sql.DataSource".equals(string)) {
                this.addDataSourceRef(resourceRefBean, map);
                continue;
            }
            if (this.isJMSConnectionFactory(string)) {
                this.addJMSConnectionFactoryRef(resourceRefBean, map, beanInfo);
                continue;
            }
            if ("java.net.URL".equals(string)) {
                this.addURLRef(resourceRefBean, map);
                continue;
            }
            if ("commonj.work.WorkManager".equals(string)) {
                this.addJ2EEWorkManager(resourceRefBean);
                continue;
            }
            if ("commonj.timers.TimerManager".equals(string)) {
                this.addTimerManager(resourceRefBean.getResRefName());
                continue;
            }
            if ("org.omg.CORBA.ORB".equals(string) || "org.omg.CORBA_2_3.ORB".equals(string)) {
                this.envCtx.bind(resourceRefBean.getResRefName(), (Object)new LinkRef("java:comp/ORB"));
                continue;
            }
            if ("com.tangosol.net.NamedCache".equals(string) || "com.tangosol.net.Service".equals(string)) {
                this.addCoherenceEntityRef(resourceRefBean, string);
                continue;
            }
            this.addConnectorRef(resourceRefBean, map);
        }
    }

    private void addCoherenceEntityRef(ResourceRefBean resourceRefBean, String string) throws NamingException, EnvironmentException {
        String string2 = resourceRefBean.getResRefName();
        if (string2 == null || string2.length() == 0) {
            throw new EnvironmentException("ResourceReference has no name set");
        }
        String string3 = resourceRefBean.getMappedName();
        if (string3 == null || string3.length() == 0) {
            throw new EnvironmentException("ResourceReference has no mappedName set");
        }
        CoherenceOpaqueReference coherenceOpaqueReference = new CoherenceOpaqueReference(string3, string, Thread.currentThread().getContextClassLoader());
        this.envCtx.bind(string2, (Object)coherenceOpaqueReference);
    }

    private void removeCoherenceEntityRef(ResourceRefBean resourceRefBean, String string) {
        block2: {
            try {
                String string2 = resourceRefBean.getResRefName();
                this.envCtx.unbind(string2);
            }
            catch (NamingException namingException) {
                J2EELogger.logDebug((String)("Cannot unbind " + resourceRefBean.getResRefName()));
                if (!DEBUG) break block2;
                namingException.printStackTrace();
            }
        }
    }

    private boolean isResourceShareable(ResourceRefBean resourceRefBean) {
        boolean bl = true;
        if (resourceRefBean.getResSharingScope() != null && resourceRefBean.getResSharingScope().equalsIgnoreCase("Unshareable")) {
            bl = false;
        }
        return bl;
    }

    private void addURLRef(ResourceRefBean resourceRefBean, Map map) throws NamingException, EnvironmentException {
        String string = (String)map.get(resourceRefBean.getResRefName());
        if (string == null || string.length() == 0) {
            string = this.getJNDIFromRefName(resourceRefBean, string);
        }
        boolean bl = this.isResourceShareable(resourceRefBean);
        try {
            URL uRL = new URL(string);
            if (!bl) {
                URLOpaqueReferenceImpl uRLOpaqueReferenceImpl = new URLOpaqueReferenceImpl(string, this.applicationName);
                this.envCtx.bind(resourceRefBean.getResRefName(), (Object)uRLOpaqueReferenceImpl);
            } else {
                this.envCtx.bind(resourceRefBean.getResRefName(), (Object)uRL);
            }
        }
        catch (MalformedURLException malformedURLException) {
            this.envCtx.bind(resourceRefBean.getResRefName(), (Object)this.createLinkRef(string));
        }
        this.addToResCtx(resourceRefBean, string);
    }

    private void removeURLRef(ResourceRefBean resourceRefBean) {
        block2: {
            try {
                this.envCtx.unbind(resourceRefBean.getResRefName());
            }
            catch (NamingException namingException) {
                if (!DEBUG) break block2;
                namingException.printStackTrace();
            }
        }
        this.removeFromResCtx(resourceRefBean);
    }

    private void removeWorkManagerRef(ResourceRefBean resourceRefBean) {
        block2: {
            try {
                J2EEWorkManager j2EEWorkManager = (J2EEWorkManager)((Object)this.envCtx.lookup(resourceRefBean.getResRefName()));
                j2EEWorkManager.shutdown(null);
                this.envCtx.unbind(resourceRefBean.getResRefName());
            }
            catch (NamingException namingException) {
                J2EELogger.logDebug((String)("Cannot unbind " + resourceRefBean.getResRefName()));
                if (!DEBUG) break block2;
                namingException.printStackTrace();
            }
        }
        this.removeFromResCtx(resourceRefBean);
    }

    private void addJ2EEWorkManager(ResourceRefBean resourceRefBean) throws NamingException {
        this.envCtx.bind(resourceRefBean.getResRefName(), (Object)J2EEWorkManager.get(this.applicationName, this.moduleName, resourceRefBean.getResRefName()));
    }

    private void removeConnectorRef(ResourceRefBean resourceRefBean) {
        block2: {
            try {
                this.envCtx.unbind(resourceRefBean.getResRefName());
            }
            catch (NamingException namingException) {
                if (!DEBUG) break block2;
                namingException.printStackTrace();
            }
        }
        this.removeFromResCtx(resourceRefBean);
    }

    protected Map createJMSPoolProperties(String string, AuthenticatedSubject authenticatedSubject) throws NamingException {
        String string2;
        Context context = null;
        try {
            context = (Context)this.rootCtx.lookup("app/jms");
        }
        catch (NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("JNDIName", string);
        hashMap.put("ApplicationName", this.applicationName);
        hashMap.put("ComponentName", this.componentName);
        hashMap.put("ComponentType", "EJB");
        hashMap.put("JmsApplicationContext", context);
        if (authenticatedSubject != null) {
            hashMap.put("RunAsSubject", authenticatedSubject);
        }
        if ((string2 = ApplicationVersionUtils.getBindApplicationId()) != null) {
            hashMap.put("weblogic.jndi.lookupApplicationId", string2);
        }
        return hashMap;
    }

    private void addConnectorRef(ResourceRefBean resourceRefBean, Map map) throws NamingException, EnvironmentException {
        String string = (String)map.get(resourceRefBean.getResRefName());
        if (string == null || string.length() == 0) {
            string = this.getJNDIFromRefName(resourceRefBean, string);
        }
        String string2 = resourceRefBean.getResType();
        boolean bl = this.isResourceShareable(resourceRefBean);
        boolean bl2 = false;
        if (resourceRefBean.getResAuth() != null && resourceRefBean.getResAuth().equalsIgnoreCase("Container")) {
            bl2 = true;
        }
        this.bindResRef(string2, bl, bl2, string, resourceRefBean.getResRefName(), 1);
        this.addToResCtx(resourceRefBean, string);
    }

    private void addToResCtx(ResourceRefBean resourceRefBean, String string) throws NamingException {
        this.resCtx.bind(resourceRefBean.getResRefName() + "JNDI", (Object)string);
        this.resCtx.bind(resourceRefBean.getResRefName() + "Auth", (Object)resourceRefBean.getResAuth());
        this.resCtx.bind(resourceRefBean.getResRefName() + "SharingScope", (Object)resourceRefBean.getResSharingScope());
    }

    private void removeFromResCtx(ResourceRefBean resourceRefBean) {
        block8: {
            block7: {
                block6: {
                    try {
                        this.resCtx.unbind(resourceRefBean.getResRefName() + "JNDI");
                    }
                    catch (NamingException namingException) {
                        if (!DEBUG) break block6;
                        namingException.printStackTrace();
                    }
                }
                try {
                    this.resCtx.unbind(resourceRefBean.getResRefName() + "Auth");
                }
                catch (NamingException namingException) {
                    if (!DEBUG) break block7;
                    namingException.printStackTrace();
                }
            }
            try {
                this.resCtx.unbind(resourceRefBean.getResRefName() + "SharingScope");
            }
            catch (NamingException namingException) {
                if (!DEBUG) break block8;
                namingException.printStackTrace();
            }
        }
    }

    private void removeDataSourceRef(ResourceRefBean resourceRefBean) {
        block2: {
            try {
                this.envCtx.unbind(resourceRefBean.getResRefName());
            }
            catch (NamingException namingException) {
                if (!DEBUG) break block2;
                namingException.printStackTrace();
            }
        }
        this.removeFromResCtx(resourceRefBean);
    }

    private void addDataSourceRef(ResourceRefBean resourceRefBean, Map map) throws NamingException, EnvironmentException {
        Context context;
        String string = (String)map.get(resourceRefBean.getResRefName());
        String string2 = resourceRefBean.getResRefName();
        if (string2 == null || string2.length() == 0) {
            throw new EnvironmentException("ResourceReference has no name set");
        }
        if (string == null || string.length() == 0) {
            string = string2;
        }
        Object object = null;
        try {
            context = (Context)this.rootCtx.lookup("app");
            object = context.lookup(string);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (object == null) {
            try {
                context = (Context)this.rootCtx.lookup("app");
                object = context.lookup("jdbc/" + string);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (object == null) {
            try {
                object = new InitialContext().lookup(string);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (object != null) {
            this.envCtx.bind(string2, object);
        } else {
            this.envCtx.bind(string2, (Object)this.createLinkRef(string));
            J2EELogger.logDebug((String)("Cannot find JDBC DataSource at " + string));
        }
    }

    private void addJMSConnectionFactoryRef(ResourceRefBean resourceRefBean, Map map, BeanInfo beanInfo) throws NamingException, EnvironmentException {
        PooledConnectionFactory pooledConnectionFactory;
        boolean bl;
        String string = (String)map.get(resourceRefBean.getResRefName());
        if (string == null || string.length() == 0) {
            string = this.getJNDIFromRefName(resourceRefBean, string);
        }
        String string2 = !(bl = this.isResourceShareable(resourceRefBean)) ? this.applicationName + "-" + this.componentName + "-" + string : string;
        boolean bl2 = false;
        if (resourceRefBean.getResAuth() != null && resourceRefBean.getResAuth().equalsIgnoreCase("Container")) {
            bl2 = true;
        }
        AuthenticatedSubject authenticatedSubject = null;
        try {
            authenticatedSubject = beanInfo.getRunAsSubject();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            pooledConnectionFactory = new PooledConnectionFactory(string2, 1, bl2, this.createJMSPoolProperties(string, authenticatedSubject));
        }
        catch (JMSException jMSException) {
            Loggable loggable = EJBLogger.logunableToCreateJMSConnectionFactoryLoggable((String)StackTraceUtils.throwable2StackTrace((Throwable)jMSException));
            throw new EnvironmentException(loggable.getMessage());
        }
        if (!bl) {
            JMSConnFactoryOpaqueReferenceImpl jMSConnFactoryOpaqueReferenceImpl = new JMSConnFactoryOpaqueReferenceImpl(string2, 1, bl2, this.createJMSPoolProperties(string, authenticatedSubject));
            this.envCtx.bind(resourceRefBean.getResRefName(), (Object)jMSConnFactoryOpaqueReferenceImpl);
        } else {
            this.envCtx.bind(resourceRefBean.getResRefName(), (Object)pooledConnectionFactory);
        }
        this.addToResCtx(resourceRefBean, string);
    }

    private void removeJMSConnectionFactoryRef(ResourceRefBean resourceRefBean) {
        block3: {
            try {
                PooledConnectionFactory pooledConnectionFactory = (PooledConnectionFactory)this.envCtx.lookup(resourceRefBean.getResRefName());
                if (pooledConnectionFactory != null) {
                    ServerRuntimeMBean serverRuntimeMBean = ManagementService.getRuntimeAccess(kernelId).getServerRuntime();
                    boolean bl = serverRuntimeMBean.getStateVal() == 18;
                    pooledConnectionFactory.close(bl);
                }
                this.envCtx.unbind(resourceRefBean.getResRefName());
            }
            catch (Throwable throwable) {
                if (!DEBUG) break block3;
                throwable.printStackTrace();
            }
        }
        this.removeFromResCtx(resourceRefBean);
    }

    public void removeResourceEnvReferences(Collection collection) {
        if (DEBUG) {
            Debug.assertion((collection != null ? 1 : 0) != 0);
        }
        for (ResourceEnvRefBean resourceEnvRefBean : collection) {
            try {
                this.envCtx.unbind(resourceEnvRefBean.getResourceEnvRefName());
            }
            catch (NamingException namingException) {
                if (!DEBUG) continue;
                namingException.printStackTrace();
            }
        }
    }

    public void addResourceEnvReferences(Collection collection, Map map) throws NamingException, EnvironmentException {
        if (DEBUG) {
            Debug.assertion((collection != null ? 1 : 0) != 0);
        }
        for (ResourceEnvRefBean resourceEnvRefBean : collection) {
            Object object;
            String string = (String)map.get(resourceEnvRefBean.getResourceEnvRefName());
            if ((string == null || string.length() == 0) && resourceEnvRefBean.getMappedName() != null) {
                string = resourceEnvRefBean.getMappedName();
            }
            if (string == null) {
                try {
                    object = this.bi.getModuleClassLoader().loadClass(resourceEnvRefBean.getResourceEnvRefType());
                    String string2 = null;
                    if (EJBContext.class.isAssignableFrom((Class<?>)object)) {
                        string2 = EJB_CONTEXT_BINDING;
                    } else if (TimerService.class == object) {
                        string2 = TIMERSERVICE_BINDING;
                    } else if (UserTransaction.class == object) {
                        string2 = "comp/UserTransaction";
                    } else if (ORB.class.isAssignableFrom((Class<?>)object)) {
                        string2 = "comp/ORB";
                    } else if (WebServiceContext.class == object) {
                        string2 = WEB_SERVICE_CONTEXT_BINDING;
                    }
                    if (string2 != null) {
                        this.envCtx.bind(resourceEnvRefBean.getResourceEnvRefName(), (Object)new LinkRef("java:" + string2));
                        continue;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new EnvironmentException("Unable to load class: " + resourceEnvRefBean.getResourceEnvRefType(), classNotFoundException);
                }
            }
            if (string == null || string.length() == 0) {
                object = EJBLogger.lognoJNDIForResourceEnvRefLoggable((String)resourceEnvRefBean.getResourceEnvRefName());
                throw new EnvironmentException(object.getMessage());
            }
            this.envCtx.bind(resourceEnvRefBean.getResourceEnvRefName(), (Object)this.createLinkRef(string));
        }
    }

    public void addEJBReferences(Collection collection, Map map, String string) throws NamingException, EnvironmentException {
        if (DEBUG) {
            Debug.assertion((collection != null ? 1 : 0) != 0);
        }
        for (EjbRefBean ejbRefBean : collection) {
            String string2 = (String)map.get(ejbRefBean.getEjbRefName());
            if (string2 != null && string2.length() > 0) {
                this.envCtx.rebind(ejbRefBean.getEjbRefName(), (Object)this.createLinkRef(string2));
                continue;
            }
            if (ejbRefBean.getEjbLink() != null) {
                this.addEJBLinkRef(ejbRefBean.getEjbRefName(), ejbRefBean.getEjbLink(), ejbRefBean.getHome(), ejbRefBean.getRemote(), string, false);
                continue;
            }
            if (ejbRefBean.getMappedName() != null) {
                string2 = ejbRefBean.getMappedName().startsWith("weblogic-jndi:") ? ejbRefBean.getMappedName().substring("weblogic-jndi:".length(), ejbRefBean.getMappedName().length()) : ejbRefBean.getMappedName() + "#" + ejbRefBean.getRemote();
                this.envCtx.rebind(ejbRefBean.getEjbRefName(), (Object)this.createLinkRef(string2));
                continue;
            }
            this.autowireEJBRef(ejbRefBean.getEjbRefName(), ejbRefBean.getHome(), ejbRefBean.getRemote());
        }
    }

    public void removeEJBReferences(Collection collection) throws NamingException {
        if (DEBUG) {
            Debug.assertion((collection != null ? 1 : 0) != 0);
        }
        for (Object e : collection) {
            EjbRefBean ejbRefBean;
            if (e instanceof EjbRefBean) {
                ejbRefBean = (EjbRefBean)e;
                try {
                    this.envCtx.unbind(ejbRefBean.getEjbRefName());
                }
                catch (NamingException namingException) {
                    if (!DEBUG) continue;
                    namingException.printStackTrace();
                }
                continue;
            }
            if (!(e instanceof EjbLocalRefBean)) continue;
            ejbRefBean = (EjbLocalRefBean)e;
            try {
                this.envCtx.unbind(ejbRefBean.getEjbRefName());
            }
            catch (NamingException namingException) {
                if (!DEBUG) continue;
                namingException.printStackTrace();
            }
        }
    }

    public void addEJBLocalReferences(Collection collection, Map map, String string) throws NamingException, EnvironmentException {
        if (DEBUG) {
            Debug.assertion((collection != null ? 1 : 0) != 0);
        }
        for (EjbLocalRefBean ejbLocalRefBean : collection) {
            String string2 = (String)map.get(ejbLocalRefBean.getEjbRefName());
            if (string2 != null && string2.length() > 0) {
                this.envCtx.bind(ejbLocalRefBean.getEjbRefName(), (Object)this.createLinkRef(string2));
                continue;
            }
            if (ejbLocalRefBean.getEjbLink() != null) {
                this.addEJBLinkRef(ejbLocalRefBean.getEjbRefName(), ejbLocalRefBean.getEjbLink(), ejbLocalRefBean.getLocalHome(), ejbLocalRefBean.getLocal(), string, true);
                continue;
            }
            if (ejbLocalRefBean.getMappedName() != null) {
                string2 = ejbLocalRefBean.getMappedName().startsWith("weblogic-jndi:") ? ejbLocalRefBean.getMappedName().substring("weblogic-jndi:".length(), ejbLocalRefBean.getMappedName().length()) : ejbLocalRefBean.getMappedName() + "#" + ejbLocalRefBean.getLocal();
                this.envCtx.bind(ejbLocalRefBean.getEjbRefName(), (Object)this.createLinkRef(string2));
                continue;
            }
            this.autowireEJBRef(ejbLocalRefBean.getEjbRefName(), ejbLocalRefBean.getLocalHome(), ejbLocalRefBean.getLocal());
        }
    }

    public void addTimerServiceBinding() throws NamingException {
        if (this.bi.isEJB30()) {
            this.rootCtx.bind(TIMERSERVICE_BINDING, (Object)new TimerServiceProxyImpl(this.bi));
        }
    }

    public void removeTimerServiceBinding() {
        block3: {
            if (this.bi.isEJB30()) {
                try {
                    this.rootCtx.unbind(TIMERSERVICE_BINDING);
                }
                catch (NamingException namingException) {
                    if (!DEBUG) break block3;
                    namingException.printStackTrace();
                }
            }
        }
    }

    private String getJNDIFromRefName(ResourceRefBean resourceRefBean, String string) {
        if (string == null || string.length() == 0) {
            string = resourceRefBean.getResRefName();
        }
        return string;
    }
}

