/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.deployer;

import java.io.File;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.ejb.ApplicationException;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContextException;
import weblogic.application.ApplicationContextInternal;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.compliance.EJBComplianceTextFormatter;
import weblogic.ejb.container.dd.DDConstants;
import weblogic.ejb.container.dd.xml.DDUtils;
import weblogic.ejb.container.deployer.BeanInfoImpl;
import weblogic.ejb.container.deployer.CMPInfoImpl;
import weblogic.ejb.container.deployer.CompositeMBeanDescriptor;
import weblogic.ejb.container.deployer.DeploymentDescriptorException;
import weblogic.ejb.container.deployer.EntityBeanInfoImpl;
import weblogic.ejb.container.deployer.PKClassPreProcessor;
import weblogic.ejb.container.deployer.mbimpl.ContainerTransactionImpl;
import weblogic.ejb.container.deployer.mbimpl.ExcludeListImpl;
import weblogic.ejb.container.deployer.mbimpl.IsolationLevelImpl;
import weblogic.ejb.container.deployer.mbimpl.MethodDescriptorImpl;
import weblogic.ejb.container.deployer.mbimpl.MethodPermissionImpl;
import weblogic.ejb.container.deployer.mbimpl.RelationshipsImpl;
import weblogic.ejb.container.deployer.mbimpl.RetryMethodsOnRollbackImpl;
import weblogic.ejb.container.deployer.mbimpl.RoleDescriptorImpl;
import weblogic.ejb.container.deployer.mbimpl.SecurityRoleMappingImpl;
import weblogic.ejb.container.interfaces.BeanInfo;
import weblogic.ejb.container.interfaces.CMPInfo;
import weblogic.ejb.container.interfaces.ClientDrivenBeanInfo;
import weblogic.ejb.container.interfaces.ContainerTransaction;
import weblogic.ejb.container.interfaces.DeploymentInfo;
import weblogic.ejb.container.interfaces.EntityBeanInfo;
import weblogic.ejb.container.interfaces.IsolationLevel;
import weblogic.ejb.container.interfaces.MessageDrivenBeanInfo;
import weblogic.ejb.container.interfaces.MethodDescriptor;
import weblogic.ejb.container.interfaces.MethodInfo;
import weblogic.ejb.container.interfaces.MethodPermission;
import weblogic.ejb.container.interfaces.RetryMethodsOnRollback;
import weblogic.ejb.container.interfaces.RoleDescriptor;
import weblogic.ejb.container.interfaces.SecurityRoleMapping;
import weblogic.ejb.container.internal.RuntimeHelper;
import weblogic.ejb.container.persistence.CMPBeanDescriptorImpl;
import weblogic.ejb.container.persistence.InstalledPersistence;
import weblogic.ejb.container.persistence.PersistenceException;
import weblogic.ejb.container.persistence.PersistenceType;
import weblogic.ejb.container.persistence.spi.Dependents;
import weblogic.ejb.container.persistence.spi.Relationships;
import weblogic.ejb.spi.EjbDescriptorBean;
import weblogic.ejb.spi.WLDeploymentException;
import weblogic.ejb20.dd.DescriptorErrorInfo;
import weblogic.j2ee.descriptor.ApplicationExceptionBean;
import weblogic.j2ee.descriptor.AssemblyDescriptorBean;
import weblogic.j2ee.descriptor.ContainerTransactionBean;
import weblogic.j2ee.descriptor.EjbJarBean;
import weblogic.j2ee.descriptor.EnterpriseBeanBean;
import weblogic.j2ee.descriptor.EntityBeanBean;
import weblogic.j2ee.descriptor.ExcludeListBean;
import weblogic.j2ee.descriptor.InterceptorBean;
import weblogic.j2ee.descriptor.InterceptorsBean;
import weblogic.j2ee.descriptor.MessageDestinationBean;
import weblogic.j2ee.descriptor.MethodPermissionBean;
import weblogic.j2ee.descriptor.SecurityRoleBean;
import weblogic.j2ee.descriptor.wl.IdempotentMethodsBean;
import weblogic.j2ee.descriptor.wl.MessageDestinationDescriptorBean;
import weblogic.j2ee.descriptor.wl.MethodBean;
import weblogic.j2ee.descriptor.wl.RetryMethodsOnRollbackBean;
import weblogic.j2ee.descriptor.wl.RunAsRoleAssignmentBean;
import weblogic.j2ee.descriptor.wl.TransactionIsolationBean;
import weblogic.j2ee.descriptor.wl.WeblogicEjbJarBean;
import weblogic.j2ee.injection.PitchforkContext;
import weblogic.j2ee.validation.IDescriptorErrorInfo;
import weblogic.kernel.Kernel;
import weblogic.logging.Loggable;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.jacc.RoleMapper;
import weblogic.security.jacc.RoleMapperFactory;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.AssertionError;
import weblogic.utils.Debug;
import weblogic.utils.ErrorCollectionException;
import weblogic.utils.classloaders.ClassPreProcessor;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.collections.CombinedIterator;
import weblogic.utils.jars.VirtualJarFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MBeanDeploymentInfoImpl
implements DeploymentInfo {
    private static boolean debug = false;
    private static boolean verbose = false;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final boolean SKIP_ENTITY_PKENHANCE = Boolean.getBoolean("weblogic.ejb.entity.IgnorePKClassOptimization");
    private GenericClassLoader m_classLoader;
    private HashMap m_beanInfos = new HashMap();
    private EjbDescriptorBean ejbDescriptor;
    private HashMap m_runAsRoleAssignmentsJarScoped = new HashMap();
    private Map messageDestinations = new HashMap();
    private SecurityRoleMapping m_deploymentRoles = new SecurityRoleMappingImpl();
    private Relationships m_relationships;
    private Dependents m_dependents;
    private String m_applicationName;
    private String m_applicationId;
    private String m_EJBComponentName;
    private String moduleURI;
    private String m_securityRealmName;
    private EJBComplianceTextFormatter fmt;
    private String jarFileName;
    private String clientJarFileName;
    private String jaccPolicyContextId = null;
    private PolicyConfiguration jaccPolicyConfig = null;
    private String jaccCodeSource;
    private RoleMapper jaccRoleMapper = null;
    private boolean enableDynamicQueries = false;
    private boolean enableBeanClassRedeploy = false;
    private PitchforkContext pitchforkContext = null;
    private final VirtualJarFile virtualJarFile;
    private final Set disabledWarnings;
    private HashMap applicationExceptions = new HashMap();
    private Set<Class<?>> uncheckedAppExceptions;
    private ConcurrentHashMap<Class<?>, Boolean> appExeptionsCache = new ConcurrentHashMap();
    private ConcurrentHashMap<Class<?>, Boolean> rollbackExceptionsCache = new ConcurrentHashMap();
    private HashMap ejbToInterceptor = new HashMap();
    private HashMap iceptorClassToIBean = new HashMap();

    public MBeanDeploymentInfoImpl(EjbDescriptorBean ejbDescriptorBean, GenericClassLoader genericClassLoader, String string, String string2, VirtualJarFile virtualJarFile, ApplicationContextInternal applicationContextInternal) throws ErrorCollectionException, DeploymentDescriptorException, ClassNotFoundException, PersistenceException, WLDeploymentException {
        this.m_classLoader = genericClassLoader;
        this.ejbDescriptor = ejbDescriptorBean;
        if (applicationContextInternal != null) {
            this.m_applicationName = applicationContextInternal.getApplicationId();
            this.m_applicationId = applicationContextInternal.getApplicationId();
            this.m_securityRealmName = applicationContextInternal.getApplicationSecurityRealmName();
        } else {
            this.m_applicationName = "";
        }
        if (this.m_securityRealmName == null) {
            this.m_securityRealmName = RuntimeHelper.getDefaultRealmName();
        }
        this.m_EJBComponentName = string;
        this.moduleURI = string2;
        this.virtualJarFile = virtualJarFile;
        this.fmt = new EJBComplianceTextFormatter();
        this.jarFileName = ejbDescriptorBean.getJarFileName();
        this.clientJarFileName = ejbDescriptorBean.getEjbJarBean().getEjbClientJar();
        this.disabledWarnings = this.getDisabledWarnings(ejbDescriptorBean);
        this.enableBeanClassRedeploy = ejbDescriptorBean.getWeblogicEjbJarBean().isEnableBeanClassRedeploy();
        String string3 = ejbDescriptorBean.getWeblogicEjbJarBean().getComponentFactoryClassName();
        if (string3 == null && applicationContextInternal != null && applicationContextInternal.getWLApplicationDD() != null) {
            string3 = applicationContextInternal.getWLApplicationDD().getComponentFactoryClassName();
        }
        this.pitchforkContext = new PitchforkContext(string3);
        if (MBeanDeploymentInfoImpl.isServer()) {
            this.initializeJAAC(virtualJarFile, applicationContextInternal);
        }
        this.initializeRoles(ejbDescriptorBean);
        this.initializeJarScopedRunAsRoles(ejbDescriptorBean);
        this.initializeBeanInfos(ejbDescriptorBean, this.m_classLoader);
        this.initializeMethodPermissions(ejbDescriptorBean);
        this.initializeTransactionAttribute(ejbDescriptorBean);
        this.initializeTransactionLevels(ejbDescriptorBean);
        this.initializeIdempotentMethods(ejbDescriptorBean);
        this.initializeRetryMethodsOnRollback(ejbDescriptorBean);
        this.initializeExcludedMethods(ejbDescriptorBean);
        this.initializeMessageDestinations(ejbDescriptorBean);
        this.initializeApplicationExceptions(ejbDescriptorBean);
        this.setupRelationsForEJBAndInterceptors(ejbDescriptorBean);
    }

    private void initializeJAAC(VirtualJarFile virtualJarFile, ApplicationContextInternal applicationContextInternal) throws WLDeploymentException {
        if (applicationContextInternal != null && applicationContextInternal.useJACC()) {
            if (verbose) {
                Debug.say((String)("\n+++++++++++  " + ManagementService.getRuntimeAccess(kernelId).getServer().getName() + "_" + this.m_applicationName + "_" + this.m_EJBComponentName + "  JACC is enabled\n"));
            }
            this.jaccPolicyContextId = ManagementService.getRuntimeAccess(kernelId).getServer().getName() + "_" + this.m_applicationName + "_" + this.m_EJBComponentName;
            File file = virtualJarFile.getDirectory();
            if (file != null) {
                this.jaccCodeSource = file.getName();
            } else {
                this.jaccCodeSource = virtualJarFile.getName();
                int n = this.jaccCodeSource.lastIndexOf(File.separatorChar);
                if (n != -1 && this.jaccCodeSource.length() > 1) {
                    this.jaccCodeSource = this.jaccCodeSource.substring(0, n);
                }
            }
            try {
                PolicyConfigurationFactory policyConfigurationFactory = PolicyConfigurationFactory.getPolicyConfigurationFactory();
                this.jaccPolicyConfig = policyConfigurationFactory.getPolicyConfiguration(this.jaccPolicyContextId, true);
                RoleMapperFactory roleMapperFactory = RoleMapperFactory.getRoleMapperFactory();
                this.jaccRoleMapper = roleMapperFactory.getRoleMapper(this.m_applicationId, this.jaccPolicyContextId, false);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new WLDeploymentException(classNotFoundException.getMessage(), classNotFoundException);
            }
            catch (PolicyContextException policyContextException) {
                throw new WLDeploymentException(policyContextException.getMessage(), policyContextException);
            }
        } else {
            this.jaccPolicyContextId = null;
            this.jaccPolicyConfig = null;
            this.jaccCodeSource = null;
            this.jaccRoleMapper = null;
        }
    }

    @Override
    public String getRunAsRoleAssignment(String string) {
        return (String)this.m_runAsRoleAssignmentsJarScoped.get(string);
    }

    @Override
    public String getApplicationName() {
        return this.m_applicationName;
    }

    @Override
    public String getEJBComponentName() {
        return this.m_EJBComponentName;
    }

    @Override
    public String getJACCPolicyContextId() {
        return this.jaccPolicyContextId;
    }

    @Override
    public PolicyConfiguration getJACCPolicyConfig() {
        return this.jaccPolicyConfig;
    }

    @Override
    public String getJACCCodeSource() {
        return this.jaccCodeSource;
    }

    @Override
    public RoleMapper getJACCRoleMapper() {
        return this.jaccRoleMapper;
    }

    @Override
    public String getModuleURI() {
        return this.moduleURI;
    }

    @Override
    public String getSecurityRealmName() {
        return this.m_securityRealmName;
    }

    @Override
    public String getJarFileName() {
        return this.jarFileName;
    }

    @Override
    public String getClientJarFileName() {
        return this.clientJarFileName;
    }

    @Override
    public boolean isDynamicQueriesEnabled() {
        return this.enableDynamicQueries;
    }

    @Override
    public EjbDescriptorBean getEjbDescriptorBean() {
        return this.ejbDescriptor;
    }

    @Override
    public Map getApplicationExceptions() {
        return this.applicationExceptions;
    }

    @Override
    public Set<Class<?>> getUncheckedAppExceptionClasses() {
        return this.uncheckedAppExceptions;
    }

    @Override
    public Collection getBeanInfos() {
        return this.m_beanInfos.values();
    }

    @Override
    public BeanInfo getBeanInfo(String string) {
        return (BeanInfo)this.m_beanInfos.get(string);
    }

    @Override
    public ClassLoader getModuleClassLoader() {
        return this.m_classLoader;
    }

    @Override
    public SecurityRoleMapping getDeploymentRoles() {
        return this.m_deploymentRoles;
    }

    @Override
    public Relationships getRelationships() {
        return this.m_relationships;
    }

    @Override
    public Dependents getDependents() {
        return this.m_dependents;
    }

    @Override
    public VirtualJarFile getVirtualJarFile() {
        return this.virtualJarFile;
    }

    @Override
    public boolean isWarningDisabled(String string) {
        return this.disabledWarnings.contains(string);
    }

    @Override
    public boolean isEnableBeanClassRedeploy() {
        return this.enableBeanClassRedeploy;
    }

    @Override
    public PitchforkContext getPitchforkContext() {
        return this.pitchforkContext;
    }

    @Override
    public List getInterceptorBeans(String string) {
        LinkedList<InterceptorBean> linkedList = new LinkedList<InterceptorBean>();
        HashSet hashSet = (HashSet)this.ejbToInterceptor.get(string);
        HashSet hashSet2 = (HashSet)this.ejbToInterceptor.get("*");
        if (hashSet == null) {
            hashSet = hashSet2;
        } else if (hashSet2 != null) {
            hashSet.addAll(hashSet2);
        }
        if (hashSet != null) {
            for (String string2 : hashSet) {
                InterceptorBean interceptorBean = (InterceptorBean)this.iceptorClassToIBean.get(string2);
                linkedList.add(interceptorBean);
            }
        }
        return linkedList;
    }

    private void initializeRoles(EjbDescriptorBean ejbDescriptorBean) {
        Collection collection = this.getAllRoleDescriptors(ejbDescriptorBean);
        for (RoleDescriptor roleDescriptor : collection) {
            this.m_deploymentRoles.addRoleToPrincipalsMapping(roleDescriptor.getName(), roleDescriptor.getAllSecurityPrincipals());
            if (!roleDescriptor.isExternallyDefined()) continue;
            this.m_deploymentRoles.addExternallyDefinedRole(roleDescriptor.getName());
        }
    }

    private Collection getAllRoleDescriptors(EjbDescriptorBean ejbDescriptorBean) {
        ArrayList<RoleDescriptorImpl> arrayList = new ArrayList<RoleDescriptorImpl>();
        AssemblyDescriptorBean assemblyDescriptorBean = ejbDescriptorBean.getEjbJarBean().getAssemblyDescriptor();
        if (null != assemblyDescriptorBean) {
            SecurityRoleBean[] securityRoleBeanArray = assemblyDescriptorBean.getSecurityRoles();
            for (int i = 0; i < securityRoleBeanArray.length; ++i) {
                arrayList.add(new RoleDescriptorImpl(ejbDescriptorBean, securityRoleBeanArray[i]));
            }
        }
        return arrayList;
    }

    private void initializeJarScopedRunAsRoles(EjbDescriptorBean ejbDescriptorBean) {
        RunAsRoleAssignmentBean[] runAsRoleAssignmentBeanArray = ejbDescriptorBean.getWeblogicEjbJarBean().getRunAsRoleAssignments();
        for (int i = 0; i < runAsRoleAssignmentBeanArray.length; ++i) {
            this.m_runAsRoleAssignmentsJarScoped.put(runAsRoleAssignmentBeanArray[i].getRoleName(), runAsRoleAssignmentBeanArray[i].getRunAsPrincipalName());
        }
    }

    private void initializeBeanInfos(EjbDescriptorBean ejbDescriptorBean, GenericClassLoader genericClassLoader) throws DeploymentDescriptorException, PersistenceException, WLDeploymentException {
        Object object;
        Object object22;
        CompositeMBeanDescriptor compositeMBeanDescriptor = null;
        InstalledPersistence installedPersistence = new InstalledPersistence();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        HashMap<String, EnterpriseBeanBean> hashMap = new HashMap<String, EnterpriseBeanBean>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        HashMap<String, EnterpriseBeanBean> hashMap2 = new HashMap<String, EnterpriseBeanBean>();
        EnterpriseBeanBean[] enterpriseBeanBeanArray = CompositeMBeanDescriptor.getEnterpriseBeans(ejbDescriptorBean.getEjbJarBean());
        if (!SKIP_ENTITY_PKENHANCE) {
            ArrayList<String> arrayList3 = new ArrayList<String>();
            for (Object object3 : enterpriseBeanBeanArray) {
                if (!(object3 instanceof EntityBeanBean)) continue;
                String string = ((EntityBeanBean)object3).getPrimKeyClass();
                arrayList3.add(string);
            }
            object22 = new PKClassPreProcessor(arrayList3);
            genericClassLoader.addInstanceClassPreProcessor((ClassPreProcessor)object22);
            object = arrayList3.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                try {
                    genericClassLoader.loadClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new WLDeploymentException(string, classNotFoundException);
                }
            }
        }
        for (int i = 0; i < enterpriseBeanBeanArray.length; ++i) {
            Object object3;
            compositeMBeanDescriptor = new CompositeMBeanDescriptor(enterpriseBeanBeanArray[i], ejbDescriptorBean);
            object22 = null;
            try {
                object22 = BeanInfoImpl.createBeanInfoImpl(this, compositeMBeanDescriptor, genericClassLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Loggable loggable = EJBLogger.logUnableLoadClassSpecifiedInDDLoggable((String)classNotFoundException.getMessage());
                throw new DeploymentDescriptorException(loggable.getMessage(), (IDescriptorErrorInfo)new DescriptorErrorInfo("<ejb-class>", (Object)enterpriseBeanBeanArray[i].getEjbName(), (Object)enterpriseBeanBeanArray[i].getEjbName()));
            }
            this.m_beanInfos.put(enterpriseBeanBeanArray[i].getEjbName(), object22);
            if (!(object22 instanceof EntityBeanInfoImpl) || ((EntityBeanInfoImpl)(object = (EntityBeanInfoImpl)object22)).getIsBeanManagedPersistence()) continue;
            CMPInfoImpl cMPInfoImpl = (CMPInfoImpl)((EntityBeanInfoImpl)object).getCMPInfo();
            object3 = new CMPBeanDescriptorImpl((EntityBeanInfo)object, ejbDescriptorBean);
            if (cMPInfoImpl.uses20CMP()) {
                hashMap.put(((EntityBeanInfoImpl)object).getEJBName(), (EnterpriseBeanBean)object3);
                arrayList.add(object);
                this.enableDynamicQueries |= ((EntityBeanInfoImpl)object).isDynamicQueriesEnabled();
            }
            hashMap2.put(((EntityBeanInfoImpl)object).getEJBName(), (EnterpriseBeanBean)object3);
            arrayList2.add(object);
            cMPInfoImpl.setPersistenceType(this.getPersistenceType((EntityBeanInfo)object, installedPersistence));
        }
        this.m_relationships = new RelationshipsImpl(ejbDescriptorBean.getEjbJarBean().getRelationships(), MBeanDeploymentInfoImpl.getRelationshipJNDIMap(ejbDescriptorBean));
        for (Object object22 : arrayList) {
            object = (CMPInfoImpl)((EntityBeanInfoImpl)object22).getCMPInfo();
            ((CMPInfoImpl)object).setBeanMap(hashMap);
            ((CMPInfoImpl)object).setRelationships(this.m_relationships);
        }
        for (Object object22 : arrayList2) {
            object = (CMPInfoImpl)((EntityBeanInfoImpl)object22).getCMPInfo();
            ((CMPInfoImpl)object).setAllBeanMap(hashMap2);
        }
    }

    private static Map getRelationshipJNDIMap(EjbDescriptorBean ejbDescriptorBean) {
        HashMap hashMap = new HashMap();
        return hashMap;
    }

    private PersistenceType getPersistenceType(EntityBeanInfo entityBeanInfo, InstalledPersistence installedPersistence) throws PersistenceException {
        PersistenceType persistenceType;
        String string;
        CMPInfo cMPInfo = entityBeanInfo.getCMPInfo();
        if (debug) {
            Debug.assertion((cMPInfo != null ? 1 : 0) != 0);
        }
        if ((string = cMPInfo.getPersistenceUseIdentifier()) == null) {
            throw new PersistenceException(this.fmt.BEAN_MISSING_PERSISTENCE_USE(entityBeanInfo.getEJBName()));
        }
        String string2 = cMPInfo.getPersistenceUseVersion();
        if (debug) {
            Debug.assertion((string != null ? 1 : 0) != 0);
        }
        if (debug) {
            Debug.assertion((string2 != null ? 1 : 0) != 0);
        }
        if ((persistenceType = installedPersistence.getInstalledType(string, string2)) == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.fmt.vendorPersistenceTypeNotInstalled(string, string2, entityBeanInfo.getEJBName()));
            Iterator iterator = installedPersistence.getInstalledTypes().iterator();
            if (!iterator.hasNext()) {
                stringBuffer.append("<No persistence types installed.>");
            } else {
                while (iterator.hasNext()) {
                    PersistenceType persistenceType2 = (PersistenceType)iterator.next();
                    stringBuffer.append("(" + persistenceType2.getIdentifier() + ", " + persistenceType2.getVersion() + ")");
                    if (!iterator.hasNext()) continue;
                    stringBuffer.append(", ");
                }
                stringBuffer.append(".");
            }
            throw new PersistenceException(stringBuffer.toString());
        }
        if (!persistenceType.getCmpVersion().equalsIgnoreCase(entityBeanInfo.getCMPInfo().getCMPVersion())) {
            throw new PersistenceException(this.fmt.incompatibleCmpVersion(entityBeanInfo.getEJBName(), entityBeanInfo.getCMPInfo().getCMPVersion(), persistenceType.getCmpVersion()));
        }
        if (!persistenceType.getWeblogicVersion().equalsIgnoreCase("7")) {
            throw new PersistenceException(this.fmt.incompatibleVendorPersistenceType(entityBeanInfo.getEJBName(), persistenceType.getWeblogicVersion(), "7"));
        }
        return persistenceType;
    }

    private Collection getAllMethodPermissions(EjbDescriptorBean ejbDescriptorBean) {
        ArrayList<MethodPermissionImpl> arrayList = new ArrayList<MethodPermissionImpl>();
        AssemblyDescriptorBean assemblyDescriptorBean = ejbDescriptorBean.getEjbJarBean().getAssemblyDescriptor();
        if (null != assemblyDescriptorBean) {
            MethodPermissionBean[] methodPermissionBeanArray = assemblyDescriptorBean.getMethodPermissions();
            for (int i = 0; i < methodPermissionBeanArray.length; ++i) {
                MethodPermissionImpl methodPermissionImpl = new MethodPermissionImpl(methodPermissionBeanArray[i]);
                arrayList.add(methodPermissionImpl);
            }
        }
        return arrayList;
    }

    private Iterator getAllMethodInfosIterator() {
        ArrayList<Iterator> arrayList = new ArrayList<Iterator>();
        Iterator iterator = this.getBeanInfos().iterator();
        while (iterator.hasNext()) {
            arrayList.add(((BeanInfo)iterator.next()).getAllMethodInfosIterator());
        }
        return new CombinedIterator(arrayList);
    }

    private void initializeMethodPermissions(EjbDescriptorBean ejbDescriptorBean) throws DeploymentDescriptorException {
        Collection collection = this.getAllMethodPermissions(ejbDescriptorBean);
        if (collection.size() > 0) {
            this.processDefaultMethodMPs(ejbDescriptorBean, collection);
            this.processGenericMethodMPs(ejbDescriptorBean, collection);
            this.processSpecificMethodMPs(ejbDescriptorBean, collection);
        }
        Iterator iterator = this.getAllMethodInfosIterator();
        while (iterator.hasNext()) {
            MethodInfo methodInfo = (MethodInfo)iterator.next();
            methodInfo.setRealmName(this.m_securityRealmName);
        }
    }

    private void initializeTransactionAttribute(EjbDescriptorBean ejbDescriptorBean) throws DeploymentDescriptorException {
        AssemblyDescriptorBean assemblyDescriptorBean = ejbDescriptorBean.getEjbJarBean().getAssemblyDescriptor();
        if (null != assemblyDescriptorBean) {
            ContainerTransactionBean[] containerTransactionBeanArray = assemblyDescriptorBean.getContainerTransactions();
            Object object = new ArrayList();
            for (int i = 0; i < containerTransactionBeanArray.length; ++i) {
                ContainerTransactionImpl containerTransactionImpl = new ContainerTransactionImpl((ContainerTransactionBean)containerTransactionBeanArray[i]);
                object.add(containerTransactionImpl);
            }
            this.processDefaultMethodCTs(ejbDescriptorBean, (Collection)object);
            this.processGenericMethodCTs(ejbDescriptorBean, (Collection)object);
            this.processSpecificMethodCTs(ejbDescriptorBean, (Collection)object);
        }
        for (Object object : this.getBeanInfos()) {
            object.assignDefaultTXAttributesIfNecessary();
        }
    }

    private void initializeTransactionLevels(EjbDescriptorBean ejbDescriptorBean) throws DeploymentDescriptorException {
        Collection collection = this.getAllIsolationLevels(ejbDescriptorBean);
        this.processDefaultMethodISOs(collection);
        this.processGenericMethodISOs(collection);
        this.processSpecificMethodISOs(collection);
    }

    private void initializeIdempotentMethods(EjbDescriptorBean ejbDescriptorBean) throws DeploymentDescriptorException {
        Collection collection = this.getAllIdempotentMethods(ejbDescriptorBean);
        this.processDefaultMethodIdempotency(collection);
        this.processGenericMethodIdempotency(collection);
        this.processSpecificMethodIdempotency(collection);
    }

    private void initializeRetryMethodsOnRollback(EjbDescriptorBean ejbDescriptorBean) throws DeploymentDescriptorException {
        Collection collection = this.getAllRetryMethods(ejbDescriptorBean);
        this.processDefaultMethodRetries(collection);
        this.processGenericMethodRetries(collection);
        this.processSpecificMethodRetries(collection);
    }

    private void initializeExcludedMethods(EjbDescriptorBean ejbDescriptorBean) throws DeploymentDescriptorException, WLDeploymentException {
        ExcludeListBean excludeListBean;
        AssemblyDescriptorBean assemblyDescriptorBean = ejbDescriptorBean.getEjbJarBean().getAssemblyDescriptor();
        if (null != assemblyDescriptorBean && (excludeListBean = assemblyDescriptorBean.getExcludeList()) != null) {
            ExcludeListImpl excludeListImpl = new ExcludeListImpl(excludeListBean);
            Collection collection = excludeListImpl.getAllMethodDescriptors();
            for (MethodDescriptor methodDescriptor : collection) {
                Collection collection2 = this.lookupMethodInfos(methodDescriptor);
                for (MethodInfo methodInfo : collection2) {
                    methodInfo.setIsExcluded(true);
                    methodInfo.setMethodDescriptorMethodType(methodDescriptor.getMethodType());
                }
            }
        }
    }

    private void initializeMessageDestinations(EjbDescriptorBean ejbDescriptorBean) throws WLDeploymentException {
        AssemblyDescriptorBean assemblyDescriptorBean;
        EjbJarBean ejbJarBean;
        WeblogicEjbJarBean weblogicEjbJarBean = ejbDescriptorBean.getWeblogicEjbJarBean();
        if (weblogicEjbJarBean != null) {
            ejbJarBean = weblogicEjbJarBean.getMessageDestinationDescriptors();
            for (int i = 0; i < ((EjbJarBean)ejbJarBean).length; ++i) {
                this.messageDestinations.put(ejbJarBean[i].getMessageDestinationName(), ejbJarBean[i]);
            }
        }
        if ((assemblyDescriptorBean = (ejbJarBean = ejbDescriptorBean.getEjbJarBean()).getAssemblyDescriptor()) != null) {
            MessageDestinationBean[] messageDestinationBeanArray = assemblyDescriptorBean.getMessageDestinations();
            for (int i = 0; i < messageDestinationBeanArray.length; ++i) {
                if (this.messageDestinations.containsKey(messageDestinationBeanArray[i].getMessageDestinationName())) continue;
                Loggable loggable = EJBLogger.logMissingMessageDestinationDescriptorLoggable((String)messageDestinationBeanArray[i].getMessageDestinationName(), (String)this.jarFileName);
                throw new WLDeploymentException(loggable.getMessage());
            }
        }
    }

    private void initializeApplicationExceptions(EjbDescriptorBean ejbDescriptorBean) throws WLDeploymentException {
        if (!ejbDescriptorBean.isEjb30()) {
            this.uncheckedAppExceptions = Collections.emptySet();
            return;
        }
        EjbJarBean ejbJarBean = ejbDescriptorBean.getEjbJarBean();
        AssemblyDescriptorBean assemblyDescriptorBean = ejbJarBean.getAssemblyDescriptor();
        ApplicationExceptionBean[] applicationExceptionBeanArray = null;
        if (assemblyDescriptorBean != null) {
            applicationExceptionBeanArray = assemblyDescriptorBean.getApplicationExceptions();
        }
        if (applicationExceptionBeanArray == null) {
            this.uncheckedAppExceptions = Collections.emptySet();
            return;
        }
        this.uncheckedAppExceptions = new HashSet(applicationExceptionBeanArray.length);
        for (int i = 0; i < applicationExceptionBeanArray.length; ++i) {
            String string = applicationExceptionBeanArray[i].getExceptionClass();
            this.applicationExceptions.put(string, applicationExceptionBeanArray[i].isRollback() ? Boolean.TRUE : Boolean.FALSE);
            try {
                Class clazz = this.m_classLoader.loadClass(string);
                if (!RuntimeException.class.isAssignableFrom(clazz)) continue;
                this.uncheckedAppExceptions.add(clazz);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new WLDeploymentException("Failed to load class : " + string, classNotFoundException);
            }
        }
        this.uncheckedAppExceptions = Collections.unmodifiableSet(this.uncheckedAppExceptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addApplicationException(Class clazz) {
        if (!this.ejbDescriptor.isEjb30() || this.ejbDescriptor.getEjbJarBean().isMetadataComplete() || !clazz.isAnnotationPresent(ApplicationException.class)) {
            return false;
        }
        ApplicationException applicationException = clazz.getAnnotation(ApplicationException.class);
        HashMap hashMap = this.applicationExceptions;
        synchronized (hashMap) {
            if (!this.applicationExceptions.containsKey(clazz.getName())) {
                this.applicationExceptions.put(clazz.getName(), applicationException.rollback());
            }
        }
        return true;
    }

    @Override
    public Collection getMessageDestinationDescriptors() {
        return this.messageDestinations.values();
    }

    @Override
    public MessageDestinationDescriptorBean getMessageDestinationDescriptor(String string) {
        return (MessageDestinationDescriptorBean)this.messageDestinations.get(string);
    }

    private void setupRelationsForEJBAndInterceptors(EjbDescriptorBean ejbDescriptorBean) {
        Object object;
        InterceptorsBean interceptorsBean;
        EjbJarBean ejbJarBean = ejbDescriptorBean.getEjbJarBean();
        HashSet<String> hashSet = new HashSet<String>();
        AssemblyDescriptorBean assemblyDescriptorBean = ejbJarBean.getAssemblyDescriptor();
        if (assemblyDescriptorBean != null) {
            interceptorsBean = assemblyDescriptorBean.getInterceptorBindings();
            for (int i = 0; i < ((InterceptorsBean)interceptorsBean).length; ++i) {
                String[] stringArray = null;
                stringArray = interceptorsBean[i].getInterceptorOrder() != null ? interceptorsBean[i].getInterceptorOrder().getInterceptorClasses() : interceptorsBean[i].getInterceptorClasses();
                object = interceptorsBean[i].getEjbName();
                HashSet<String> hashSet2 = (HashSet<String>)this.ejbToInterceptor.get(object);
                if (hashSet2 == null) {
                    hashSet2 = new HashSet<String>();
                }
                for (int j = 0; j < stringArray.length; ++j) {
                    hashSet.add(stringArray[j]);
                    hashSet2.add(stringArray[j]);
                }
                this.ejbToInterceptor.put(object, hashSet2);
            }
        }
        if ((interceptorsBean = ejbJarBean.getInterceptors()) != null) {
            InterceptorBean[] interceptorBeanArray = interceptorsBean.getInterceptors();
            for (int i = 0; i < interceptorBeanArray.length; ++i) {
                object = interceptorBeanArray[i];
                if (!hashSet.contains(object.getInterceptorClass())) continue;
                this.iceptorClassToIBean.put(object.getInterceptorClass(), object);
            }
        }
    }

    private void processDefaultMethodISOs(Collection collection) throws DeploymentDescriptorException {
        this.processISOs(collection, (short)1);
    }

    private void processGenericMethodISOs(Collection collection) throws DeploymentDescriptorException {
        this.processISOs(collection, (short)2);
    }

    private void processSpecificMethodISOs(Collection collection) throws DeploymentDescriptorException {
        this.processISOs(collection, (short)3);
    }

    private static int selectForUpdateFromIsoLevel(String string) {
        if (string.equalsIgnoreCase("TransactionReadCommittedForUpdate")) {
            return 1;
        }
        if (string.equalsIgnoreCase("TransactionReadCommittedForUpdateNoWait")) {
            return 2;
        }
        if (string.equalsIgnoreCase("TRANSACTION_READ_COMMITTED_FOR_UPDATE")) {
            return 1;
        }
        if (string.equalsIgnoreCase("TRANSACTION_READ_COMMITTED_FOR_UPDATE_NO_WAIT")) {
            return 2;
        }
        return 0;
    }

    private void processISOs(Collection collection, short s) throws DeploymentDescriptorException {
        if (debug) {
            Debug.assertion((s == 1 || s == 2 || s == 3 ? 1 : 0) != 0);
        }
        for (IsolationLevel isolationLevel : collection) {
            Collection collection2 = isolationLevel.getAllMethodDescriptors();
            for (MethodDescriptor methodDescriptor : collection2) {
                if (methodDescriptor.getMethodType() != s) continue;
                Collection collection3 = this.lookupMethodInfos(methodDescriptor);
                if (collection3.size() == 0) {
                    Object object = "";
                    if (methodDescriptor.getMethodIntf() != null) {
                        object = methodDescriptor.getMethodIntf() + " ";
                    }
                    throw new DeploymentDescriptorException(this.fmt.noMethodFoundForEJBDeploymentDescriptorSetting(methodDescriptor.getMethodSignature(), methodDescriptor.getEjbName(), (String)object, "weblogic-ejb-jar.xml", "isolation-level"), (IDescriptorErrorInfo)new DescriptorErrorInfo("<isolation-level>", (Object)methodDescriptor.getEjbName(), (Object)methodDescriptor.getMethodSignature()));
                }
                for (MethodInfo methodInfo : collection3) {
                    String string = isolationLevel.getIsolationLevel();
                    methodInfo.setSelectForUpdate(MBeanDeploymentInfoImpl.selectForUpdateFromIsoLevel(string));
                    methodInfo.setTxIsolationLevel(DDUtils.isoStringToInt(string));
                }
            }
        }
    }

    private Collection getAllIsolationLevels(EjbDescriptorBean ejbDescriptorBean) {
        ArrayList<IsolationLevelImpl> arrayList = new ArrayList<IsolationLevelImpl>();
        TransactionIsolationBean[] transactionIsolationBeanArray = ejbDescriptorBean.getWeblogicEjbJarBean().getTransactionIsolations();
        for (int i = 0; i < transactionIsolationBeanArray.length; ++i) {
            arrayList.add(new IsolationLevelImpl(transactionIsolationBeanArray[i]));
        }
        return arrayList;
    }

    private Collection getAllIdempotentMethods(EjbDescriptorBean ejbDescriptorBean) {
        ArrayList<MethodDescriptorImpl> arrayList = new ArrayList<MethodDescriptorImpl>();
        IdempotentMethodsBean idempotentMethodsBean = ejbDescriptorBean.getWeblogicEjbJarBean().getIdempotentMethods();
        if (idempotentMethodsBean != null) {
            MethodBean[] methodBeanArray = idempotentMethodsBean.getMethods();
            for (int i = 0; i < methodBeanArray.length; ++i) {
                arrayList.add(new MethodDescriptorImpl(methodBeanArray[i]));
            }
        }
        return arrayList;
    }

    private Collection getAllRetryMethods(EjbDescriptorBean ejbDescriptorBean) {
        ArrayList<RetryMethodsOnRollbackImpl> arrayList = new ArrayList<RetryMethodsOnRollbackImpl>();
        RetryMethodsOnRollbackBean[] retryMethodsOnRollbackBeanArray = ejbDescriptorBean.getWeblogicEjbJarBean().getRetryMethodsOnRollbacks();
        for (int i = 0; i < retryMethodsOnRollbackBeanArray.length; ++i) {
            arrayList.add(new RetryMethodsOnRollbackImpl(retryMethodsOnRollbackBeanArray[i]));
        }
        return arrayList;
    }

    private void processDefaultMethodIdempotency(Collection collection) throws DeploymentDescriptorException {
        this.processIdempotency(collection, (short)1);
    }

    private void processGenericMethodIdempotency(Collection collection) throws DeploymentDescriptorException {
        this.processIdempotency(collection, (short)2);
    }

    private void processSpecificMethodIdempotency(Collection collection) throws DeploymentDescriptorException {
        this.processIdempotency(collection, (short)3);
    }

    private void processIdempotency(Collection collection, short s) throws DeploymentDescriptorException {
        if (debug) {
            Debug.assertion((s == 1 || s == 2 || s == 3 ? 1 : 0) != 0);
        }
        for (MethodDescriptor methodDescriptor : collection) {
            if (methodDescriptor.getMethodType() != s) continue;
            Collection collection2 = this.lookupMethodInfos(methodDescriptor);
            if (collection2.size() == 0) {
                Object object = "";
                if (methodDescriptor.getMethodIntf() != null) {
                    object = methodDescriptor.getMethodIntf() + " ";
                }
                throw new DeploymentDescriptorException(this.fmt.noMethodFoundForEJBDeploymentDescriptorSetting(methodDescriptor.getMethodSignature(), methodDescriptor.getEjbName(), (String)object, "weblogic-ejb-jar.xml", "idempotency"), (IDescriptorErrorInfo)new DescriptorErrorInfo("<idempotent-methods>", (Object)methodDescriptor.getEjbName(), (Object)methodDescriptor.getMethodSignature()));
            }
            for (MethodInfo methodInfo : collection2) {
                methodInfo.setIdempotent(true);
            }
        }
    }

    private void processDefaultMethodRetries(Collection collection) throws DeploymentDescriptorException {
        this.processRetries(collection, (short)1);
    }

    private void processGenericMethodRetries(Collection collection) throws DeploymentDescriptorException {
        this.processRetries(collection, (short)2);
    }

    private void processSpecificMethodRetries(Collection collection) throws DeploymentDescriptorException {
        this.processRetries(collection, (short)3);
    }

    private void processRetries(Collection collection, short s) throws DeploymentDescriptorException {
        if (debug) {
            Debug.assertion((s == 1 || s == 2 || s == 3 ? 1 : 0) != 0);
        }
        for (RetryMethodsOnRollback retryMethodsOnRollback : collection) {
            Collection collection2 = retryMethodsOnRollback.getAllMethodDescriptors();
            for (MethodDescriptor methodDescriptor : collection2) {
                if (methodDescriptor.getMethodType() != s) continue;
                Collection collection3 = this.lookupMethodInfos(methodDescriptor);
                if (collection3.size() == 0) {
                    Object object = "";
                    if (methodDescriptor.getMethodIntf() != null) {
                        object = methodDescriptor.getMethodIntf() + " ";
                    }
                    throw new DeploymentDescriptorException(this.fmt.noMethodFoundForEJBDeploymentDescriptorSetting(methodDescriptor.getMethodSignature(), methodDescriptor.getEjbName(), (String)object, "weblogic-ejb-jar.xml", "retry-methods-on-rollback"), (IDescriptorErrorInfo)new DescriptorErrorInfo("<isolation-level>", (Object)methodDescriptor.getEjbName(), (Object)methodDescriptor.getMethodSignature()));
                }
                for (MethodInfo methodInfo : collection3) {
                    int n = retryMethodsOnRollback.getRetryCount();
                    methodInfo.setRetryOnRollbackCount(n);
                }
            }
        }
    }

    private void processDefaultMethodMPs(EjbDescriptorBean ejbDescriptorBean, Collection collection) throws DeploymentDescriptorException {
        this.processMPs(ejbDescriptorBean, collection, (short)1);
    }

    private void processGenericMethodMPs(EjbDescriptorBean ejbDescriptorBean, Collection collection) throws DeploymentDescriptorException {
        this.processMPs(ejbDescriptorBean, collection, (short)2);
    }

    private void processSpecificMethodMPs(EjbDescriptorBean ejbDescriptorBean, Collection collection) throws DeploymentDescriptorException {
        this.processMPs(ejbDescriptorBean, collection, (short)3);
    }

    private void processMPs(EjbDescriptorBean ejbDescriptorBean, Collection collection, short s) throws DeploymentDescriptorException {
        Debug.assertion((s == 1 || s == 2 || s == 3 ? 1 : 0) != 0);
        for (MethodPermission methodPermission : collection) {
            boolean bl = methodPermission.isUnchecked();
            Collection collection2 = methodPermission.getAllMethodDescriptors();
            for (MethodDescriptor methodDescriptor : collection2) {
                if (methodDescriptor.getMethodType() != s) continue;
                Collection collection3 = this.lookupMethodInfos(methodDescriptor);
                if (collection3.size() == 0) {
                    String[] stringArray = new String[]{"<method>", "<method-permission>"};
                    Object object = "";
                    if (methodDescriptor.getMethodIntf() != null) {
                        object = methodDescriptor.getMethodIntf() + " ";
                    }
                    throw new DeploymentDescriptorException(this.fmt.noMethodFoundForEJBDeploymentDescriptorSetting(methodDescriptor.getMethodSignature(), methodDescriptor.getEjbName(), (String)object, "ejb-jar.xml", "method permission"), (IDescriptorErrorInfo)new DescriptorErrorInfo(stringArray, (Object)methodDescriptor.getEjbName(), (Object)methodDescriptor.getMethodSignature()));
                }
                for (Object object : collection3) {
                    object.setMethodDescriptorMethodType(methodDescriptor.getMethodType());
                    if (bl) {
                        object.setUnchecked(true);
                        continue;
                    }
                    Collection collection4 = methodPermission.getAllRoleNames();
                    for (String string : collection4) {
                        if (!this.m_deploymentRoles.hasRole(string)) {
                            throw new DeploymentDescriptorException(this.fmt.METHOD_PERMISSION_ROLE_NAME_NOT_DECLARED(string), (IDescriptorErrorInfo)new DescriptorErrorInfo("<role-name>", (Object)string, (Object)string));
                        }
                        object.addSecurityRoleRestriction(string);
                    }
                }
            }
        }
    }

    private Collection lookupMethodInfos(MethodDescriptor methodDescriptor) throws DeploymentDescriptorException {
        BeanInfo beanInfo = this.getBeanInfo(methodDescriptor.getEjbName());
        if (beanInfo == null) {
            throw new DeploymentDescriptorException("Could not find an EJB named " + methodDescriptor.getEjbName() + " while parsing the assembly-descriptor", (IDescriptorErrorInfo)new DescriptorErrorInfo("<ejb-name>", (Object)methodDescriptor.getEjbName(), (Object)methodDescriptor.getEjbName()));
        }
        ArrayList<MethodInfo> arrayList = new ArrayList<MethodInfo>();
        String string = methodDescriptor.getMethodSignature();
        if (beanInfo instanceof MessageDrivenBeanInfo) {
            if (((MessageDrivenBeanInfo)beanInfo).getIsWeblogicJMS()) {
                MethodInfo methodInfo = ((MessageDrivenBeanInfo)beanInfo).getOnMessageMethodInfo();
                if (debug) {
                    Debug.assertion((methodInfo != null ? 1 : 0) != 0);
                }
                arrayList.add(methodInfo);
            } else {
                arrayList.addAll(this.getMatchingMethods(beanInfo, "MessagingType", string));
            }
            arrayList.addAll(this.getMatchingMethods(beanInfo, null, string));
        } else {
            String string2;
            if (debug) {
                Debug.assertion((boolean)(beanInfo instanceof ClientDrivenBeanInfo));
            }
            if ("Remote".equals(string2 = methodDescriptor.getMethodIntf())) {
                arrayList.addAll(this.getMatchingMethods(beanInfo, "Remote", string));
            } else if ("Home".equals(string2)) {
                arrayList.addAll(this.getMatchingMethods(beanInfo, "Home", string));
            } else if ("Local".equals(string2)) {
                arrayList.addAll(this.getMatchingMethods(beanInfo, "Local", string));
            } else if ("LocalHome".equals(string2)) {
                arrayList.addAll(this.getMatchingMethods(beanInfo, "LocalHome", string));
            } else if ("ServiceEndpoint".equals(string2)) {
                arrayList.addAll(this.getMatchingMethods(beanInfo, "ServiceEndpoint", string));
            } else {
                arrayList.addAll(this.getMatchingMethods(beanInfo, "Local", string));
                arrayList.addAll(this.getMatchingMethods(beanInfo, "LocalHome", string));
                arrayList.addAll(this.getMatchingMethods(beanInfo, "Remote", string));
                arrayList.addAll(this.getMatchingMethods(beanInfo, "Home", string));
                arrayList.addAll(this.getMatchingMethods(beanInfo, "ServiceEndpoint", string));
                arrayList.addAll(this.getMatchingMethods(beanInfo, null, string));
            }
        }
        return arrayList;
    }

    private Collection getMatchingMethods(BeanInfo beanInfo, String string, String string2) {
        if (debug) {
            Debug.assertion((beanInfo != null ? 1 : 0) != 0);
            Debug.assertion((string2 != null ? 1 : 0) != 0);
        }
        ArrayList<MethodInfo> arrayList = new ArrayList<MethodInfo>();
        Collection collection = null;
        ClientDrivenBeanInfo clientDrivenBeanInfo = null;
        MessageDrivenBeanInfo messageDrivenBeanInfo = null;
        if (beanInfo instanceof MessageDrivenBeanInfo) {
            messageDrivenBeanInfo = (MessageDrivenBeanInfo)beanInfo;
        } else {
            clientDrivenBeanInfo = (ClientDrivenBeanInfo)beanInfo;
        }
        if (string == "Home") {
            collection = clientDrivenBeanInfo.getAllHomeMethodInfos();
        } else if (string == "Remote") {
            collection = clientDrivenBeanInfo.getAllRemoteMethodInfos();
        } else if (string == "LocalHome") {
            collection = clientDrivenBeanInfo.getAllLocalHomeMethodInfos();
        } else if (string == "Local") {
            collection = clientDrivenBeanInfo.getAllLocalMethodInfos();
        } else if (string == "MessagingType") {
            collection = messageDrivenBeanInfo.getAllMessagingTypeMethodInfos();
        } else if (string == "ServiceEndpoint") {
            collection = clientDrivenBeanInfo.getAllWebserviceMethodInfos();
        } else if (string == null) {
            collection = messageDrivenBeanInfo == null ? clientDrivenBeanInfo.getAllBeanMethodInfos() : messageDrivenBeanInfo.getAllBeanMethodInfos();
        } else {
            throw new AssertionError("Unknown interface type: " + string);
        }
        if (string2.equals("*")) {
            arrayList.addAll(collection);
        } else {
            for (MethodInfo methodInfo : collection) {
                if (!string2.equals(methodInfo.getSignature()) && !string2.equals(methodInfo.getMethodName())) continue;
                arrayList.add(methodInfo);
            }
        }
        return arrayList;
    }

    private void processDefaultMethodCTs(EjbDescriptorBean ejbDescriptorBean, Collection collection) throws DeploymentDescriptorException {
        this.processCTs(ejbDescriptorBean, collection, (short)1);
    }

    private void processGenericMethodCTs(EjbDescriptorBean ejbDescriptorBean, Collection collection) throws DeploymentDescriptorException {
        this.processCTs(ejbDescriptorBean, collection, (short)2);
    }

    private void processSpecificMethodCTs(EjbDescriptorBean ejbDescriptorBean, Collection collection) throws DeploymentDescriptorException {
        this.processCTs(ejbDescriptorBean, collection, (short)3);
    }

    private void processCTs(EjbDescriptorBean ejbDescriptorBean, Collection collection, short s) throws DeploymentDescriptorException {
        if (debug) {
            Debug.assertion((s == 1 || s == 2 || s == 3 ? 1 : 0) != 0);
        }
        for (ContainerTransaction containerTransaction : collection) {
            Collection collection2 = containerTransaction.getAllMethodDescriptors();
            for (MethodDescriptor methodDescriptor : collection2) {
                if (methodDescriptor.getMethodType() != s) continue;
                Collection collection3 = this.lookupMethodInfos(methodDescriptor);
                if (collection3.size() == 0) {
                    Object object = "";
                    if (methodDescriptor.getMethodIntf() != null) {
                        object = methodDescriptor.getMethodIntf() + " ";
                    }
                    throw new DeploymentDescriptorException(this.fmt.noMethodFoundForEJBDeploymentDescriptorSetting(methodDescriptor.getMethodSignature(), methodDescriptor.getEjbName(), (String)object, "ejb-jar.xml", "transaction attribute"), (IDescriptorErrorInfo)new DescriptorErrorInfo("<trans-attribute>", (Object)methodDescriptor.getEjbName(), (Object)methodDescriptor.getMethodSignature()));
                }
                for (MethodInfo methodInfo : collection3) {
                    String string = containerTransaction.getTransactionAttribute();
                    Short s2 = (Short)DDConstants.VALID_TX_ATTRIBUTES.get(string);
                    methodInfo.setTransactionAttribute(s2);
                }
            }
        }
    }

    private Set getDisabledWarnings(EjbDescriptorBean ejbDescriptorBean) {
        HashSet<String> hashSet = new HashSet<String>();
        String[] stringArray = ejbDescriptorBean.getWeblogicEjbJarBean().getDisableWarnings();
        for (int i = 0; i < stringArray.length; ++i) {
            hashSet.add(stringArray[i]);
        }
        return hashSet;
    }

    static boolean isServer() {
        return Kernel.isServer();
    }

    @Override
    public String getApplicationId() {
        return this.m_applicationId;
    }

    public ConcurrentHashMap<Class<?>, Boolean> getRollBackExeptionsCache() {
        return this.rollbackExceptionsCache;
    }

    public ConcurrentHashMap<Class<?>, Boolean> getApplicationExeptionsCache() {
        return this.appExeptionsCache;
    }
}

