/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.deployer;

import java.util.HashSet;
import java.util.Set;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.deployer.EJBDeployer;
import weblogic.ejb.container.deployer.MDBService;
import weblogic.ejb.container.internal.MDConnectionManager;
import weblogic.server.ActivatedService;
import weblogic.server.ServiceFailureException;

public final class MDBServiceImpl
extends ActivatedService
implements MDBService {
    private HashSet deployedMDBs = null;
    private static Set mdbStarters = new HashSet();
    private static boolean started = false;
    private static final int MDB_SUSPEND = 1;
    private static final int MDB_SIGNAL_THREAD_EXIT = 2;
    private static final int MDB_SHUTDOWN = 3;
    private static final int MDB_RESUME = 4;
    private boolean shutdown;

    private void MDBServiceImpl() {
    }

    public synchronized void haltService() throws ServiceFailureException {
        if (this.shutdown) {
            return;
        }
        if (this.deployedMDBs != null) {
            EJBLogger.logMDBsBeingSuspended();
            this.iterateOnMDBs(2);
            this.iterateOnMDBs(1);
            EJBLogger.logMDBsDoneSuspending();
        }
        this.shutdown = true;
    }

    public synchronized void stopService() throws ServiceFailureException {
        this.haltService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean startService() throws ServiceFailureException {
        this.iterateOnMDBs(4);
        Set set = mdbStarters;
        synchronized (set) {
            for (EJBDeployer eJBDeployer : mdbStarters) {
                try {
                    ApplicationVersionUtils.setCurrentAdminMode(true);
                    try {
                        eJBDeployer.deployMessageDrivenBeansUsingModuleCL();
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        EJBLogger.logErrorStartingMDB((Throwable)exception);
                    }
                }
                finally {
                    ApplicationVersionUtils.setCurrentAdminMode(false);
                }
            }
            mdbStarters.clear();
            started = true;
        }
        this.shutdown = false;
        return started;
    }

    private void iterateOnMDBs(int n) throws ServiceFailureException {
        if (this.deployedMDBs != null) {
            for (MDConnectionManager mDConnectionManager : this.deployedMDBs) {
                if (mDConnectionManager == null) continue;
                switch (n) {
                    case 1: {
                        mDConnectionManager.suspend(true);
                        break;
                    }
                    case 2: {
                        mDConnectionManager.signalBackgroundThreads();
                        break;
                    }
                    case 3: {
                        mDConnectionManager.shutdown();
                        break;
                    }
                    case 4: {
                        mDConnectionManager.resume(true);
                        break;
                    }
                }
            }
        }
    }

    public synchronized void addDeployedMDB(MDConnectionManager mDConnectionManager) {
        if (this.deployedMDBs == null) {
            this.deployedMDBs = new HashSet();
        }
        this.deployedMDBs.add(mDConnectionManager);
    }

    public synchronized void removeDeployedMDB(MDConnectionManager mDConnectionManager) {
        if (this.deployedMDBs != null) {
            this.deployedMDBs.remove(mDConnectionManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addMDBStarter(EJBDeployer eJBDeployer) {
        Set set = mdbStarters;
        synchronized (set) {
            if (!started) {
                mdbStarters.add(eJBDeployer);
                return true;
            }
        }
        return false;
    }
}

