/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.deployer;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import weblogic.application.ApplicationContextInternal;
import weblogic.cluster.migration.Migratable;
import weblogic.cluster.migration.MigrationManager;
import weblogic.deployment.BaseEnvironmentBuilder;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BeanUpdateFailedException;
import weblogic.descriptor.BeanUpdateRejectedException;
import weblogic.descriptor.DescriptorBean;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.compliance.ComplianceException;
import weblogic.ejb.container.compliance.EJBComplianceTextFormatter;
import weblogic.ejb.container.compliance.Ejb30MessageDrivenBeanClassChecker;
import weblogic.ejb.container.dd.DDConstants;
import weblogic.ejb.container.dd.DDDefaults;
import weblogic.ejb.container.deployer.BeanInfoImpl;
import weblogic.ejb.container.deployer.CompositeMBeanDescriptor;
import weblogic.ejb.container.deployer.NamingConvention;
import weblogic.ejb.container.deployer.mbimpl.MethodInfoImpl;
import weblogic.ejb.container.interfaces.BaseEJBHomeIntf;
import weblogic.ejb.container.interfaces.CachingDescriptor;
import weblogic.ejb.container.interfaces.DeploymentInfo;
import weblogic.ejb.container.interfaces.MessageDrivenBeanInfo;
import weblogic.ejb.container.interfaces.MessageDrivenManagerIntf;
import weblogic.ejb.container.interfaces.MethodInfo;
import weblogic.ejb.container.interfaces.PoolIntf;
import weblogic.ejb.container.interfaces.TimerManager;
import weblogic.ejb.container.internal.EJBComponentRuntimeMBeanImpl;
import weblogic.ejb.container.internal.EJBRuntimeUtils;
import weblogic.ejb.container.internal.JMSConnectionPoller;
import weblogic.ejb.container.internal.MethodDescriptor;
import weblogic.ejb.container.internal.SecurityHelper;
import weblogic.ejb.container.manager.MessageDrivenManager;
import weblogic.ejb.container.timer.MDBTimerManagerFactory;
import weblogic.ejb.spi.WLDeploymentException;
import weblogic.j2ee.J2EEUtils;
import weblogic.j2ee.descriptor.ActivationConfigBean;
import weblogic.j2ee.descriptor.ActivationConfigPropertyBean;
import weblogic.j2ee.descriptor.MessageDrivenBeanBean;
import weblogic.j2ee.descriptor.wl.MessageDestinationDescriptorBean;
import weblogic.j2ee.descriptor.wl.MessageDrivenDescriptorBean;
import weblogic.j2ee.descriptor.wl.PoolBean;
import weblogic.j2ee.descriptor.wl.SecurityPluginBean;
import weblogic.j2ee.descriptor.wl.TransactionDescriptorBean;
import weblogic.j2ee.descriptor.wl.WeblogicEnterpriseBeanBean;
import weblogic.jms.common.CrossDomainSecurityManager;
import weblogic.jms.extensions.DestinationAvailabilityListener;
import weblogic.jms.extensions.DestinationDetail;
import weblogic.jms.extensions.JMSDestinationAvailabilityHelper;
import weblogic.jms.extensions.RegistrationHandle;
import weblogic.kernel.Kernel;
import weblogic.logging.Loggable;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.MigratableTargetMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.subject.AbstractSubject;
import weblogic.utils.AssertionError;
import weblogic.utils.StackTraceUtils;
import weblogic.utils.annotation.BeaSynthetic;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.collections.CombinedIterator;
import weblogic.utils.reflect.MethodText;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MessageDrivenBeanInfoImpl
extends BeanInfoImpl
implements MessageDrivenBeanInfo {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private String connectionFactoryResourceLink = null;
    private String destinationResourceLink = null;
    private String messageDestinationLink = null;
    private boolean m_usesBeanManagedTx = false;
    private String m_messageSelector = null;
    private int m_acknowledgeMode = 1;
    private boolean m_isDestinationQueue = false;
    private boolean m_isDestinationTopic = false;
    private boolean m_isDurableSubscriber = false;
    private boolean m_isInactive = false;
    private int m_maxConcurrentInstances;
    private CachingDescriptor m_cachingDescriptor = null;
    private String m_destinationJNDIName = null;
    private String m_initialContextFactory;
    private String m_providerURL;
    private String m_connectionFactoryJNDIName;
    private int jmsPollingIntervalSeconds;
    private int initSuspendSeconds;
    private int maxSuspendSeconds;
    private MDBTimerManagerFactory mdbTimerManagerFactory;
    private int distributedDestinationConnection = -1;
    private SecurityPluginBean securityPlugin;
    private boolean isGenerateUniqueJmsClientId;
    private ClusterMBean clusterMBean = null;
    private String currServerName = "";
    private String currClusterName = "";
    private String domainName = "";
    private String jmsClientIDBase;
    private String jmsClientID;
    private boolean isDurableSubscriptionDeletion;
    private int maxMessagesInTransaction;
    private boolean use81StylePolling;
    private boolean minimizeAQSessions = Boolean.getBoolean("weblogic.mdb.message.MinimizeAQSessions");
    private String resourceAdapterJndiName = "";
    private final boolean callByReference;
    private boolean m_noLocal = false;
    private MethodInfo m_onMessageMethodInfo;
    private String messagingTypeInterfaceName;
    private String messageDrivenLocalObjectClassName;
    private Class messagingTypeInterfaceClass;
    private Class messageDrivenLocalObjectClass;
    private final Map messagingTypeMethods = new HashMap();
    private Map mdbMethodDescriptors = new HashMap();
    private boolean isResourceAdapter;
    private ActivationConfigBean activationConfigBean;
    private Context environmentContext;
    private AtomicInteger contextBoundCounter = new AtomicInteger(0);
    private List<MessageDrivenManagerIntf> mdManagerList = null;
    private List<DestinationDetail> backupDestMembersList = null;
    private boolean oneMDBDeployedForDT = false;
    private EJBComponentRuntimeMBeanImpl ejbComponentRuntime;
    private HashMap pseudoMDMBeans = new HashMap();
    private AbstractSubject subject = null;
    private boolean indirectlyImplMessageListener = false;
    private String generatedBeanClassName = null;
    private Class generatedBeanClass;
    private StringBuffer userName = null;
    private StringBuffer password = null;
    private boolean hasCredentials = false;
    private boolean isRemoteSubjectExists = false;
    private Map<String, String> activationMap = null;
    private Hashtable<String, String> jmsRegisterEnv = new Hashtable();
    private WorkManager wm;
    private AtomicReference<MessageDrivenManagerIntf> defaultMDManager = new AtomicReference();
    private AtomicReference<DestinationEventHandler> destinationHandler = new AtomicReference();
    private int topicMessagesDistributionMode = 0;

    public MessageDrivenBeanInfoImpl(DeploymentInfo deploymentInfo, CompositeMBeanDescriptor compositeMBeanDescriptor, GenericClassLoader genericClassLoader) throws ClassNotFoundException, WLDeploymentException {
        super(deploymentInfo, compositeMBeanDescriptor, genericClassLoader);
        Object object;
        Object object2;
        int n;
        Object object3;
        MessageDrivenBeanBean messageDrivenBeanBean = (MessageDrivenBeanBean)compositeMBeanDescriptor.getBean();
        WeblogicEnterpriseBeanBean weblogicEnterpriseBeanBean = compositeMBeanDescriptor.getWl60Bean();
        MessageDrivenDescriptorBean messageDrivenDescriptorBean = weblogicEnterpriseBeanBean.getMessageDrivenDescriptor();
        this.messagingTypeInterfaceName = compositeMBeanDescriptor.getMessagingTypeName();
        if (this.messagingTypeInterfaceName == null) {
            this.messagingTypeInterfaceName = "javax.jms.MessageListener";
        }
        this.m_usesBeanManagedTx = "bean".equalsIgnoreCase(messageDrivenBeanBean.getTransactionType());
        if (messageDrivenBeanBean.getMessageDestinationType() != null) {
            this.setDestination(messageDrivenBeanBean.getMessageDestinationType());
        }
        this.activationConfigBean = messageDrivenBeanBean.getActivationConfig();
        this.activationMap = new HashMap<String, String>();
        if (this.activationConfigBean != null) {
            object3 = this.activationConfigBean.getActivationConfigProperties();
            for (n = 0; n < ((ActivationConfigPropertyBean[])object3).length; ++n) {
                object2 = object3[n].getActivationConfigPropertyName();
                object = object3[n].getActivationConfigPropertyValue();
                this.activationMap.put(((String)object2).toUpperCase(Locale.ENGLISH), (String)object);
            }
        }
        try {
            Ejb30MessageDrivenBeanClassChecker.validateForConflictingConfiguration(compositeMBeanDescriptor, this.activationMap.keySet(), this.getDisplayName());
        }
        catch (ComplianceException complianceException) {
            throw new WLDeploymentException(complianceException.getMessage(), complianceException);
        }
        if (debugLogger.isDebugEnabled()) {
            this.dumpActivationConfigValues();
        }
        if (this.activationMap.get("RESOURCEADAPTERJNDINAME") != null && messageDrivenDescriptorBean.getResourceAdapterJNDIName() == null) {
            this.resourceAdapterJndiName = this.activationMap.get("RESOURCEADAPTERJNDINAME");
            this.debugPropertyValue("resourceAdapterJNDIName", this.resourceAdapterJndiName);
        } else {
            this.resourceAdapterJndiName = messageDrivenDescriptorBean.getResourceAdapterJNDIName();
            if (messageDrivenDescriptorBean.getResourceAdapterJNDIName() != null && this.activationMap.get("RESOURCEADAPTERJNDINAME") != null) {
                EJBLogger.logOverridenActivationConfigProperty((String)this.getDestinationName(), (String)"resourceAdapterJNDIName", (String)this.resourceAdapterJndiName);
            }
        }
        if (this.resourceAdapterJndiName != null) {
            this.isResourceAdapter = true;
        }
        this.m_messageSelector = this.activationMap.get("MESSAGESELECTOR");
        if (this.m_messageSelector == null) {
            this.m_messageSelector = "";
        }
        if (this.activationMap.get("ACKNOWLEDGEMODE") != null) {
            this.m_acknowledgeMode = this.acknowledgeMode2Int(this.activationMap.get("ACKNOWLEDGEMODE"));
        }
        if (this.activationMap.get("DESTINATIONTYPE") != null) {
            this.setDestination(this.activationMap.get("DESTINATIONTYPE"));
        }
        if (this.activationMap.get("SUBSCRIPTIONDURABILITY") != null) {
            this.m_isDurableSubscriber = "durable".equalsIgnoreCase(this.activationMap.get("SUBSCRIPTIONDURABILITY"));
        }
        if (this.activationMap.get("INACTIVE") != null) {
            this.m_isInactive = Boolean.parseBoolean(this.activationMap.get("INACTIVE"));
            if (this.m_isInactive) {
                EJBLogger.logMDBInactive((String)this.getEJBName());
            } else {
                EJBLogger.logMDBActive((String)this.getEJBName());
            }
        }
        this.messageDestinationLink = messageDrivenBeanBean.getMessageDestinationLink();
        this.m_cachingDescriptor = compositeMBeanDescriptor.getCachingDescriptor();
        this.m_maxConcurrentInstances = this.m_cachingDescriptor.getMaxBeansInFreePool();
        if (this.activationMap.get("DESTINATIONJNDINAME") != null && compositeMBeanDescriptor.getDestinationJNDIName() == null) {
            this.m_destinationJNDIName = this.activationMap.get("DESTINATIONJNDINAME");
            this.debugPropertyValue("destinationJNDIName", this.m_destinationJNDIName);
        } else {
            this.m_destinationJNDIName = compositeMBeanDescriptor.getDestinationJNDIName();
            if (compositeMBeanDescriptor.getDestinationJNDIName() != null && this.activationMap.get("DESTINATIONJNDINAME") != null) {
                EJBLogger.logOverridenActivationConfigProperty((String)this.getDisplayName(), (String)"destinationJNDIName", (String)this.m_destinationJNDIName);
            }
        }
        if (this.activationMap.get("INITIALCONTEXTFACTORY") != null && !this.isSet("InitialContextFactory", messageDrivenDescriptorBean)) {
            this.m_initialContextFactory = this.activationMap.get("INITIALCONTEXTFACTORY");
            this.debugPropertyValue("initialContextFactory", this.m_initialContextFactory);
        } else {
            this.m_initialContextFactory = messageDrivenDescriptorBean.getInitialContextFactory();
            if (this.isSet("InitialContextFactory", messageDrivenDescriptorBean) && this.activationMap.get("INITIALCONTEXTFACTORY") != null) {
                EJBLogger.logOverridenActivationConfigProperty((String)this.getDisplayName(), (String)"initialContextFactory", (String)this.m_initialContextFactory);
            }
        }
        if (this.activationMap.get("PROVIDERURL") != null && messageDrivenDescriptorBean.getProviderUrl() == null) {
            this.m_providerURL = this.activationMap.get("PROVIDERURL");
            this.debugPropertyValue("providerUrl", this.m_providerURL);
        } else {
            this.m_providerURL = messageDrivenDescriptorBean.getProviderUrl();
            if (messageDrivenDescriptorBean.getProviderUrl() != null && this.activationMap.get("PROVIDERURL") != null) {
                EJBLogger.logOverridenActivationConfigProperty((String)this.getDisplayName(), (String)"providerUrl", (String)this.m_providerURL);
            }
        }
        if (this.activationMap.get("CONNECTIONFACTORYJNDINAME") != null && !this.isSet("ConnectionFactoryJNDIName", messageDrivenDescriptorBean)) {
            this.m_connectionFactoryJNDIName = this.activationMap.get("CONNECTIONFACTORYJNDINAME");
            this.debugPropertyValue("connectionFactoryJNDIName", this.m_connectionFactoryJNDIName);
        } else {
            this.m_connectionFactoryJNDIName = messageDrivenDescriptorBean.getConnectionFactoryJNDIName();
            if (this.isSet("ConnectionFactoryJNDIName", messageDrivenDescriptorBean) && this.activationMap.get("CONNECTIONFACTORYJNDINAME") != null) {
                EJBLogger.logOverridenActivationConfigProperty((String)this.getDisplayName(), (String)"connectionFactoryJNDIName", (String)this.m_connectionFactoryJNDIName);
            }
        }
        if (this.activationMap.get("CONNECTIONFACTORYRESOURCELINK") != null && messageDrivenDescriptorBean.getConnectionFactoryResourceLink() == null) {
            this.connectionFactoryResourceLink = this.activationMap.get("CONNECTIONFACTORYRESOURCELINK");
            this.debugPropertyValue("connectionFactoryResourceLink", this.connectionFactoryResourceLink);
        } else {
            this.connectionFactoryResourceLink = messageDrivenDescriptorBean.getConnectionFactoryResourceLink();
            if (messageDrivenDescriptorBean.getConnectionFactoryResourceLink() != null && this.activationMap.get("CONNECTIONFACTORYRESOURCELINK") != null) {
                EJBLogger.logOverridenActivationConfigProperty((String)this.getDisplayName(), (String)"connectionFactoryResourceLink", (String)this.connectionFactoryResourceLink);
            }
        }
        if (this.activationMap.get("DESTINATIONRESOURCELINK") != null && messageDrivenDescriptorBean.getDestinationResourceLink() == null) {
            this.destinationResourceLink = this.activationMap.get("DESTINATIONRESOURCELINK");
            this.debugPropertyValue("destinationResourceLink", this.destinationResourceLink);
        } else {
            this.destinationResourceLink = messageDrivenDescriptorBean.getDestinationResourceLink();
            if (messageDrivenDescriptorBean.getDestinationResourceLink() != null && this.activationMap.get("DESTINATIONRESOURCELINK") != null) {
                EJBLogger.logOverridenActivationConfigProperty((String)this.getDisplayName(), (String)"destinationResourceLink", (String)this.destinationResourceLink);
            }
        }
        if (this.activationMap.get("JMSPOLLINGINTERVALSECONDS") != null && !this.isSet("JmsPollingIntervalSeconds", messageDrivenDescriptorBean)) {
            try {
                this.jmsPollingIntervalSeconds = Integer.parseInt(this.activationMap.get("JMSPOLLINGINTERVALSECONDS"));
                if (this.jmsPollingIntervalSeconds <= 0) {
                    this.jmsPollingIntervalSeconds = messageDrivenDescriptorBean.getJmsPollingIntervalSeconds();
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new WLDeploymentException("the value for jmsPollingIntervalSeconds must be numberic", numberFormatException);
            }
            this.debugPropertyValue("jmsPollingIntervalSeconds", Integer.toString(this.jmsPollingIntervalSeconds));
        } else {
            this.jmsPollingIntervalSeconds = messageDrivenDescriptorBean.getJmsPollingIntervalSeconds();
            if (this.isSet("JmsPollingIntervalSeconds", messageDrivenDescriptorBean) && this.activationMap.get("JMSPOLLINGINTERVALSECONDS") != null) {
                EJBLogger.logOverridenActivationConfigProperty((String)this.getDisplayName(), (String)"jmsPollingIntervalSeconds", (String)Integer.toString(this.jmsPollingIntervalSeconds));
            }
        }
        if (this.activationMap.get("INITSUSPENDSECONDS") != null && !this.isSet("InitSuspendSeconds", messageDrivenDescriptorBean)) {
            try {
                this.initSuspendSeconds = Integer.parseInt(this.activationMap.get("INITSUSPENDSECONDS"));
            }
            catch (NumberFormatException numberFormatException) {
                throw new WLDeploymentException("the value for 'initSuspendSeconds' must be numberic", numberFormatException);
            }
            this.debugPropertyValue("initSuspendSeconds", Integer.toString(this.initSuspendSeconds));
        } else {
            this.initSuspendSeconds = messageDrivenDescriptorBean.getInitSuspendSeconds();
            if (this.isSet("InitSuspendSeconds", messageDrivenDescriptorBean) && this.activationMap.get("INITSUSPENDSECONDS") != null) {
                EJBLogger.logOverridenActivationConfigProperty((String)this.getDisplayName(), (String)"initSuspendSeconds", (String)Integer.toString(this.initSuspendSeconds));
            }
        }
        if (this.activationMap.get("MAXSUSPENDSECONDS") != null && !this.isSet("MaxSuspendSeconds", messageDrivenDescriptorBean)) {
            try {
                this.maxSuspendSeconds = Integer.parseInt(this.activationMap.get("MAXSUSPENDSECONDS"));
            }
            catch (NumberFormatException numberFormatException) {
                throw new WLDeploymentException("the value for MAXSUSPENDSECONDS must be numberic", numberFormatException);
            }
            this.debugPropertyValue("maxSuspendSeconds", Integer.toString(this.maxSuspendSeconds));
        } else {
            this.maxSuspendSeconds = messageDrivenDescriptorBean.getMaxSuspendSeconds();
            if (this.isSet("MaxSuspendSeconds", messageDrivenDescriptorBean) && this.activationMap.get("MAXSUSPENDSECONDS") != null) {
                EJBLogger.logOverridenActivationConfigProperty((String)this.getDisplayName(), (String)"maxSuspendSeconds", (String)Integer.toString(this.maxSuspendSeconds));
            }
        }
        if (this.activationMap.get("MAXMESSAGESINTRANSACTION") != null && !this.isSet("MaxMessagesInTransaction", messageDrivenDescriptorBean)) {
            try {
                this.maxMessagesInTransaction = Integer.parseInt(this.activationMap.get("MAXMESSAGESINTRANSACTION"));
            }
            catch (NumberFormatException numberFormatException) {
                throw new WLDeploymentException("the value for MAXMESSAGESINTRANSACTION must be numberic", numberFormatException);
            }
            this.debugPropertyValue("maxMessagesInTransaction", Integer.toString(this.maxMessagesInTransaction));
        } else {
            this.maxMessagesInTransaction = messageDrivenDescriptorBean.getMaxMessagesInTransaction();
            if (this.isSet("MaxMessagesInTransaction", messageDrivenDescriptorBean) && this.activationMap.get("MAXMESSAGESINTRANSACTION") != null) {
                EJBLogger.logOverridenActivationConfigProperty((String)this.getDisplayName(), (String)"maxMessagesInTransaction", (String)Integer.toString(this.maxMessagesInTransaction));
            }
        }
        this.securityPlugin = messageDrivenDescriptorBean.getSecurityPlugin();
        if (MessageDrivenBeanInfoImpl.isServer()) {
            object3 = ManagementService.getRuntimeAccess(kernelId).getServer();
            this.currServerName = object3.getName();
            this.clusterMBean = object3.getCluster();
            if (this.clusterMBean != null) {
                this.currClusterName = this.clusterMBean.getName();
            }
            this.domainName = ManagementService.getRuntimeAccess(kernelId).getDomain().getName();
        } else {
            this.currServerName = "";
        }
        if (this.activationMap.get("JMSCLIENTID") != null && messageDrivenDescriptorBean.getJmsClientId() == null) {
            this.jmsClientIDBase = this.activationMap.get("JMSCLIENTID");
            this.debugPropertyValue("jmsClientId", this.jmsClientIDBase);
        } else {
            this.jmsClientIDBase = messageDrivenDescriptorBean.getJmsClientId();
            if (messageDrivenDescriptorBean.getJmsClientId() != null && this.activationMap.get("JMSCLIENTID") != null) {
                EJBLogger.logOverridenActivationConfigProperty((String)this.getDisplayName(), (String)"jmsClientId", (String)this.jmsClientIDBase);
            }
        }
        if (this.jmsClientIDBase == null) {
            this.jmsClientIDBase = this.getEJBName();
        }
        this.jmsClientID = this.jmsClientIDBase;
        this.isGenerateUniqueJmsClientId = messageDrivenDescriptorBean.isGenerateUniqueJmsClientId();
        if (this.activationMap.get("DURABLESUBSCRIPTIONDELETION") != null && !this.isSet("DurableSubscriptionDeletion", messageDrivenDescriptorBean)) {
            this.isDurableSubscriptionDeletion = Boolean.parseBoolean(this.activationMap.get("DURABLESUBSCRIPTIONDELETION"));
            this.debugPropertyValue("durableSubscriptionDeletion", Boolean.toString(this.isDurableSubscriptionDeletion));
        } else {
            this.isDurableSubscriptionDeletion = messageDrivenDescriptorBean.isDurableSubscriptionDeletion();
            if (this.isSet("DurableSubscriptionDeletion", messageDrivenDescriptorBean) && this.activationMap.get("DURABLESUBSCRIPTIONDELETION") != null) {
                EJBLogger.logOverridenActivationConfigProperty((String)this.getDisplayName(), (String)"durableSubscriptionDeletion", (String)Boolean.toString(this.isDurableSubscriptionDeletion));
            }
        }
        if (this.activationMap.get("USE81STYLEPOLLING") != null && !this.isSet("Use81StylePolling", messageDrivenDescriptorBean)) {
            this.use81StylePolling = Boolean.parseBoolean(this.activationMap.get("USE81STYLEPOLLING"));
            this.debugPropertyValue("use81StylePolling", Boolean.toString(this.use81StylePolling));
        } else {
            this.use81StylePolling = messageDrivenDescriptorBean.isUse81StylePolling();
            if (this.isSet("Use81StylePolling", messageDrivenDescriptorBean) && this.activationMap.get("USE81STYLEPOLLING") != null) {
                EJBLogger.logOverridenActivationConfigProperty((String)this.getDisplayName(), (String)"use81StylePolling", (String)Boolean.toString(this.use81StylePolling));
            }
        }
        object3 = this.activationMap.get("MINIMIZEAQSESSIONS");
        if (object3 != null) {
            this.minimizeAQSessions = Boolean.parseBoolean((String)object3);
            this.debugPropertyValue("minimizeAQSessions", Boolean.toString(this.minimizeAQSessions));
        }
        n = 0;
        if (this.activationMap.get("DISTRIBUTEDDESTINATIONCONNECTION") != null && !this.isSet("DistributedDestinationConnection", messageDrivenDescriptorBean)) {
            n = this.convertToInt("DISTRIBUTEDDESTINATIONCONNECTION", DDConstants.DISTRIBUTEDDESTINATIONCONNECTIONS, this.activationMap.get("DISTRIBUTEDDESTINATIONCONNECTION"));
            if (n < 0) {
                object2 = EJBLogger.logIllegalDistributedDestinationConnectionValueLoggable((String)this.getDisplayName(), (String)this.activationMap.get("DISTRIBUTEDDESTINATIONCONNECTION"));
                throw new WLDeploymentException(object2.getMessage());
            }
            this.distributedDestinationConnection = n;
            this.debugPropertyValue("distributedDestinationConnection", this.activationMap.get("DISTRIBUTEDDESTINATIONCONNECTION"));
        } else {
            this.distributedDestinationConnection = this.convertToInt("distributedDestinationConnection", DDConstants.DISTRIBUTEDDESTINATIONCONNECTIONS, messageDrivenDescriptorBean.getDistributedDestinationConnection());
            if (this.isSet("DistributedDestinationConnection", messageDrivenDescriptorBean) && this.activationMap.get("DISTRIBUTEDDESTINATIONCONNECTION") != null) {
                EJBLogger.logOverridenActivationConfigProperty((String)this.getDisplayName(), (String)"distributedDestinationConnection", (String)messageDrivenDescriptorBean.getDistributedDestinationConnection());
            }
        }
        if (this.activationMap.get("TOPICMESSAGESDISTRIBUTIONMODE") != null) {
            n = this.convertToInt("TOPICMESSAGESDISTRIBUTIONMODE", DDConstants.TOPICMESSAGEDISTRIBUTIONMODES, this.activationMap.get("TOPICMESSAGESDISTRIBUTIONMODE"));
            if (n < 0) {
                object2 = EJBLogger.logIllegalTopicMessagesDistributionModeValueLoggable((String)this.getDisplayName(), (String)this.activationMap.get("TOPICMESSAGESDISTRIBUTIONMODE"));
                throw new WLDeploymentException(object2.getMessage());
            }
            this.topicMessagesDistributionMode = n;
            this.debugPropertyValue("topicMessagesDistributionMode", this.activationMap.get("TOPICMESSAGESDISTRIBUTIONMODE"));
        }
        this.callByReference = compositeMBeanDescriptor.useCallByReference();
        object2 = new NamingConvention(this.getBeanClassName(), this.getEJBName());
        if (!this.getIsWeblogicJMS() || compositeMBeanDescriptor.isMessageDriven()) {
            this.messageDrivenLocalObjectClassName = ((NamingConvention)object2).getMdLocalObjectClassName(this.getIsWeblogicJMS());
        }
        this.messagingTypeInterfaceClass = this.loadClass(this.messagingTypeInterfaceName);
        this.messageDrivenLocalObjectClass = null;
        if (this.getIsWeblogicJMS()) {
            this.initializeOnMessageMethodInfo();
        } else {
            this.initializeMethodInfos();
        }
        this.mdManagerList = new ArrayList<MessageDrivenManagerIntf>();
        this.backupDestMembersList = new ArrayList<DestinationDetail>();
        if (this.isEJB30()) {
            object = this.getBeanClass();
            Class clazz = this.getMessagingTypeInterfaceClass();
            if (!clazz.isAssignableFrom((Class<?>)object)) {
                this.setIndirectlyImplMessageListener(true);
                this.generatedBeanClassName = ((NamingConvention)object2).getGeneratedBeanClassName();
            }
        }
        if (this.isTimerDriven()) {
            this.mdbTimerManagerFactory = new MDBTimerManagerFactory();
        }
    }

    private void dumpActivationConfigValues() {
        if (this.activationMap == null) {
            return;
        }
        for (String string : this.activationMap.keySet()) {
            String string2 = this.activationMap.get(string);
            debugLogger.debug("Activation Config: <" + string + "--" + string2 + ">");
        }
    }

    private void detectDestinationByJNDIName() {
        block11: {
            if (!this.isDestinationQueue() && !this.isDestinationTopic()) {
                try {
                    Destination destination = this.lookupWithRightSubject(this.m_destinationJNDIName);
                    if (destination instanceof Destination) {
                        if (destination instanceof Queue) {
                            this.setDestination("javax.jms.Queue");
                        } else if (destination instanceof Topic) {
                            this.setDestination("javax.jms.Topic");
                        } else if (debugLogger.isDebugEnabled()) {
                            MessageDrivenBeanInfoImpl.debug("Unknown message destination type " + destination);
                        }
                    } else if (debugLogger.isDebugEnabled()) {
                        MessageDrivenBeanInfoImpl.debug("Unknown message destination type " + destination);
                    }
                }
                catch (Exception exception) {
                    if (!debugLogger.isDebugEnabled()) break block11;
                    MessageDrivenBeanInfoImpl.debug("No message destination found to associate with MessageDrivenBean " + this.ejbName + " : " + exception);
                }
            }
        }
    }

    @Override
    public void init() {
    }

    protected void setIndirectlyImplMessageListener(boolean bl) {
        this.indirectlyImplMessageListener = bl;
    }

    @Override
    public boolean isIndirectlyImplMessageListener() {
        return this.indirectlyImplMessageListener;
    }

    @Override
    public String getGeneratedBeanClassName() {
        return this.generatedBeanClassName;
    }

    @Override
    public Class getGeneratedBeanClass() {
        try {
            if (this.generatedBeanClass == null) {
                this.generatedBeanClass = this.loadClass(this.generatedBeanClassName);
            }
            return this.generatedBeanClass;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError("Unable to load class " + this.generatedBeanClassName, (Throwable)classNotFoundException);
        }
    }

    private void setDestination(String string) {
        if (this.isDestinationQueue() || this.isDestinationTopic()) {
            return;
        }
        String string2 = "javax.jms.Queue";
        String string3 = "javax.jms.Topic";
        if (string2.equals(string)) {
            this.m_isDestinationQueue = true;
        } else if (string3.equals(string)) {
            this.m_isDestinationTopic = true;
        } else if (this.getIsWeblogicJMS()) {
            throw new AssertionError("Unknown destination type : " + string);
        }
    }

    private int acknowledgeMode2Int(String string) throws WLDeploymentException {
        int n = 1;
        if ("dups-ok-acknowledge".equalsIgnoreCase(string)) {
            n = 3;
        } else if (!"auto-acknowledge".equalsIgnoreCase(string)) {
            if ("no_acknowledge".equalsIgnoreCase(string)) {
                throw new WLDeploymentException(string + " is no longer a valid acknowledgement mode.");
            }
            if ("multicast_no_acknowledge".equals(string)) {
                throw new WLDeploymentException(string + " is no longer a valid acknowledgement mode.");
            }
            if (null != string && this.getIsWeblogicJMS()) {
                throw new AssertionError("Unknown ACKNOWLEDGE MODE : " + string);
            }
        }
        return n;
    }

    @Override
    public Context getInitialContext() throws NamingException {
        AuthenticatedSubject authenticatedSubject = null;
        try {
            authenticatedSubject = this.getRunAsSubject();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.userName == null || this.password == null || authenticatedSubject != null && (this.userName.length() == 0 || this.password.length() == 0)) {
            this.reSetUsernameAndPassword();
        }
        if (this.hasCredentials) {
            return this.getInitialContext(this.userName.toString(), this.password.toString());
        }
        if (authenticatedSubject == null) {
            authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelId);
        }
        return (Context)this.doPrivilagedAction(authenticatedSubject, new PrivilegedExceptionAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() throws Exception {
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                hashtable.put("java.naming.factory.initial", MessageDrivenBeanInfoImpl.this.m_initialContextFactory);
                hashtable.put("weblogic.jndi.allowGlobalResourceLookup", "true");
                if (null != MessageDrivenBeanInfoImpl.this.m_providerURL) {
                    hashtable.put("java.naming.provider.url", MessageDrivenBeanInfoImpl.this.m_providerURL);
                }
                InitialContext initialContext = new InitialContext(hashtable);
                MessageDrivenBeanInfoImpl messageDrivenBeanInfoImpl = MessageDrivenBeanInfoImpl.this;
                synchronized (messageDrivenBeanInfoImpl) {
                    MessageDrivenBeanInfoImpl.this.subject = (AbstractSubject)SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelId);
                }
                return initialContext;
            }
        });
    }

    @Override
    public void reSetUsernameAndPassword() {
        this.userName = new StringBuffer();
        this.password = new StringBuffer();
        this.hasCredentials = false;
        try {
            this.hasCredentials = JMSConnectionPoller.getCredentials(this, this.userName, this.password);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public Context getInitialContext(final String string, final String string2) throws NamingException {
        return (Context)this.doPrivilagedAction(SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelId), new PrivilegedExceptionAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() throws Exception {
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                hashtable.put("java.naming.factory.initial", MessageDrivenBeanInfoImpl.this.m_initialContextFactory);
                hashtable.put("weblogic.jndi.allowGlobalResourceLookup", "true");
                if (null != MessageDrivenBeanInfoImpl.this.m_providerURL) {
                    hashtable.put("java.naming.provider.url", MessageDrivenBeanInfoImpl.this.m_providerURL);
                }
                hashtable.put("java.naming.security.principal", string);
                hashtable.put("java.naming.security.credentials", string2);
                InitialContext initialContext = new InitialContext(hashtable);
                MessageDrivenBeanInfoImpl messageDrivenBeanInfoImpl = MessageDrivenBeanInfoImpl.this;
                synchronized (messageDrivenBeanInfoImpl) {
                    MessageDrivenBeanInfoImpl.this.subject = (AbstractSubject)SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelId);
                }
                return initialContext;
            }
        });
    }

    @Override
    public boolean isDeliveryTransacted(Method method) throws NoSuchMethodException {
        this.getMessagingTypeInterfaceClass().getDeclaredMethod(method.getName(), method.getParameterTypes());
        if (this.usesBeanManagedTx()) {
            return false;
        }
        MethodInfo methodInfo = this.getMessagingTypeMethodInfo(method);
        short s = methodInfo.getTransactionAttribute();
        return 1 == s;
    }

    @Override
    public String getName() {
        return this.getEJBName();
    }

    @Override
    public boolean usesBeanManagedTx() {
        return this.m_usesBeanManagedTx;
    }

    @Override
    public String getMessageSelector() {
        return this.m_messageSelector;
    }

    @Override
    public int getAcknowledgeMode() {
        return this.m_acknowledgeMode;
    }

    @Override
    public boolean isDestinationQueue() {
        return this.m_isDestinationQueue;
    }

    @Override
    public boolean isDestinationTopic() {
        return this.m_isDestinationTopic;
    }

    @Override
    public boolean isDurableSubscriber() {
        return this.m_isDurableSubscriber;
    }

    @Override
    public int getMaxConcurrentInstances() {
        return this.m_maxConcurrentInstances;
    }

    @Override
    public String getProviderURL() {
        return this.m_providerURL;
    }

    @Override
    public String getDestinationName() {
        return this.m_destinationJNDIName;
    }

    @Override
    public String getConnectionFactoryJNDIName() {
        return this.m_connectionFactoryJNDIName;
    }

    @Override
    public int getJMSPollingIntervalSeconds() {
        return this.jmsPollingIntervalSeconds;
    }

    @Override
    public int getInitSuspendSeconds() {
        return this.initSuspendSeconds;
    }

    @Override
    public int getMaxSuspendSeconds() {
        return this.maxSuspendSeconds;
    }

    @Override
    public SecurityPluginBean getSecurityPlugin() {
        return this.securityPlugin;
    }

    @Override
    public String getJMSClientID() {
        return this.jmsClientID;
    }

    @Override
    public boolean isDurableSubscriptionDeletion() {
        return this.isDurableSubscriptionDeletion;
    }

    @Override
    public int getMaxMessagesInTransaction() {
        return this.maxMessagesInTransaction;
    }

    @Override
    public boolean getUse81StylePolling() {
        return this.use81StylePolling;
    }

    @Override
    public boolean getMinimizeAQSessions() {
        return this.minimizeAQSessions;
    }

    @Override
    public String getResourceAdapterJndiName() {
        return this.resourceAdapterJndiName;
    }

    @Override
    public boolean useCallByReference() {
        return this.callByReference;
    }

    @Override
    public boolean noLocalMessages() {
        return this.m_noLocal;
    }

    @Override
    public boolean getIsWeblogicJMS() {
        return !this.isResourceAdapter;
    }

    @Override
    public ActivationConfigBean getActivationConfigBean() {
        return this.activationConfigBean;
    }

    @Override
    public MessageDrivenManagerIntf getBeanManagerInstance(EJBComponentRuntimeMBeanImpl eJBComponentRuntimeMBeanImpl) {
        return new MessageDrivenManager(eJBComponentRuntimeMBeanImpl);
    }

    @Override
    public MessageDrivenManagerIntf getBeanManager() {
        return (MessageDrivenManagerIntf)super.getBeanManager();
    }

    @Override
    public List<MessageDrivenManagerIntf> getMDManagerList() {
        return this.mdManagerList;
    }

    public List<DestinationDetail> getBackupDestMembersList() {
        return this.backupDestMembersList;
    }

    @Override
    public synchronized AbstractSubject getSubject() {
        return this.subject;
    }

    @Override
    public boolean getIsRemoteSubjectExists() {
        if (!this.isRemoteSubjectExists) {
            this.isRemoteSubjectExists = CrossDomainSecurityManager.getCrossDomainSecurityUtil().ifRemoteSubjectExists(this.m_providerURL);
        }
        return this.isRemoteSubjectExists;
    }

    @Override
    public boolean isOnMessageTransacted() {
        return 1 == this.m_onMessageMethodInfo.getTransactionAttribute();
    }

    @Override
    public Integer getOnMessageTxIsolationLevel() {
        int n = this.m_onMessageMethodInfo.getTxIsolationLevel();
        if (n == -1) {
            return null;
        }
        return new Integer(n);
    }

    @Override
    public MethodInfo getOnMessageMethodInfo() {
        return this.m_onMessageMethodInfo;
    }

    private void initializeOnMessageMethodInfo() throws WLDeploymentException {
        Class clazz = this.getBeanClass();
        assert (clazz != null);
        Method method = null;
        try {
            Class[] classArray = new Class[]{Message.class};
            method = clazz.getMethod("onMessage", classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            EJBComplianceTextFormatter eJBComplianceTextFormatter = new EJBComplianceTextFormatter();
            throw new WLDeploymentException(eJBComplianceTextFormatter.BEAN_CLASS_IMPLEMENTS_MESSAGE_LISTENER(this.getDisplayName(), this.getMessagingTypeInterfaceName()));
        }
        this.m_onMessageMethodInfo = MethodInfoImpl.createMethodInfoImpl(method, this.jaccPolicyContextId);
        assert (this.m_onMessageMethodInfo != null);
    }

    @Override
    public void assignDefaultTXAttributesIfNecessary() {
        HashSet<MethodInfo> hashSet = new HashSet<MethodInfo>();
        if (this.getIsWeblogicJMS()) {
            hashSet.add(this.m_onMessageMethodInfo);
        } else {
            hashSet.addAll(this.getAllMessagingTypeMethodInfos());
        }
        hashSet.addAll(this.getAllBeanMethodInfos());
        if (this.usesBeanManagedTx()) {
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                ((MethodInfo)iterator.next()).setTransactionAttribute((short)0);
            }
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            short s = DDDefaults.getBeanMethodTransactionAttribute(this);
            stringBuffer.append(this.assignDefaultTXAttributesIfNecessary("beanClass", hashSet, s));
            if (stringBuffer.length() > 0 && !this.isEJB30()) {
                EJBLogger.logEJBUsesDefaultTXAttribute((String)this.getDisplayName(), (String)"NotSupported", (String)stringBuffer.toString());
            }
        }
    }

    @Override
    protected short getTxAttribute(MethodInfo methodInfo, Class clazz) {
        if (this.usesBeanManagedTx()) {
            return 0;
        }
        return methodInfo.getTransactionAttribute();
    }

    @Override
    public Iterator getAllMethodInfosIterator() {
        ArrayList arrayList = new ArrayList();
        if (this.getIsWeblogicJMS()) {
            ArrayList<MethodInfo> arrayList2 = new ArrayList<MethodInfo>();
            arrayList2.add(this.m_onMessageMethodInfo);
            arrayList.add(arrayList2.iterator());
        } else {
            arrayList.add(this.messagingTypeMethods.values().iterator());
        }
        arrayList.add(this.getAllBeanMethodInfos().iterator());
        return new CombinedIterator(arrayList);
    }

    @Override
    public MethodDescriptor getMDBMethodDescriptor(Method method) {
        return (MethodDescriptor)this.mdbMethodDescriptors.get(method.toString());
    }

    @Override
    public Class getMessageDrivenLocalObjectClass() {
        try {
            if (this.messageDrivenLocalObjectClass == null) {
                this.messageDrivenLocalObjectClass = this.loadClass(this.messageDrivenLocalObjectClassName);
            }
            return this.messageDrivenLocalObjectClass;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError((Throwable)classNotFoundException);
        }
    }

    @Override
    public String getMessagingTypeInterfaceName() {
        return this.messagingTypeInterfaceName;
    }

    @Override
    public Class getMessagingTypeInterfaceClass() {
        return this.messagingTypeInterfaceClass;
    }

    public MethodInfo getMessagingTypeMethodInfo(String string) {
        return (MethodInfo)this.messagingTypeMethods.get(string);
    }

    public MethodInfo getMessagingTypeMethodInfo(String string, String[] stringArray) {
        return (MethodInfo)this.messagingTypeMethods.get(MessageDrivenBeanInfoImpl.getMethodSignature(string, stringArray));
    }

    public MethodInfo getMessagingTypeMethodInfo(Method method) {
        return (MethodInfo)this.messagingTypeMethods.get(MessageDrivenBeanInfoImpl.getMethodSignature(method));
    }

    @Override
    public Collection getAllMessagingTypeMethodInfos() {
        return this.messagingTypeMethods.values();
    }

    public Map getMessagingTypeMethods() {
        return this.messagingTypeMethods;
    }

    private void initializeMethodInfos() throws WLDeploymentException {
        List<Object> list = null;
        try {
            list = Arrays.asList((Object[])this.messagingTypeInterfaceClass.getMethods());
        }
        catch (Throwable throwable) {
            Loggable loggable = EJBLogger.logunableToInitializeInterfaceMethodInfoLoggable((String)this.getEJBName(), (String)StackTraceUtils.throwable2StackTrace((Throwable)throwable));
            throw new WLDeploymentException(loggable.getMessage(), throwable);
        }
        for (Method method : list) {
            MethodInfoImpl methodInfoImpl = MethodInfoImpl.createMethodInfoImpl(method, "MessagingType", this.jaccPolicyContextId);
            if (debugLogger.isDebugEnabled()) {
                MessageDrivenBeanInfoImpl.debug(".....messagingTypeMethods.put(" + methodInfoImpl.getSignature() + ")");
            }
            this.messagingTypeMethods.put(methodInfoImpl.getSignature(), methodInfoImpl);
        }
    }

    protected void setMethodDescriptors(BaseEJBHomeIntf baseEJBHomeIntf, Class clazz, String string) throws WLDeploymentException {
        Method[] methodArray = clazz.getMethods();
        Class clazz2 = this.getMessagingTypeInterfaceClass();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            if (BeaSynthetic.Helper.isBeaSyntheticMethod((Method)method)) continue;
            boolean bl = false;
            MethodInfo methodInfo = null;
            if (string.equals("MessagingType")) {
                methodInfo = this.getMessagingTypeMethodInfo(method);
                bl = true;
            }
            if (methodInfo == null) continue;
            MethodText methodText = new MethodText();
            methodText.setMethod(method);
            methodText.setOptions(128);
            String string2 = methodText.toString();
            string2 = "eo_" + string2;
            MethodDescriptor methodDescriptor = this.setMethodDescriptor(baseEJBHomeIntf, method, clazz, methodInfo, bl, string2, string);
            Method method2 = null;
            try {
                method2 = clazz2.getMethod(method.getName(), method.getParameterTypes());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (method2 == null) continue;
            this.mdbMethodDescriptors.put(method2.toString(), methodDescriptor);
        }
    }

    public void dumpMethodDescriptors() {
        if (!this.getIsWeblogicJMS()) {
            Field[] fieldArray = this.getMessageDrivenLocalObjectClass().getFields();
            MessageDrivenBeanInfoImpl.debug("** Dumping Message Driven MethodDescriptor for: " + this.getMessagingTypeInterfaceName());
            this.dumpMethodDescriptorFields(fieldArray, null);
        }
    }

    public void dumpMethodInfos() {
        if (!this.getIsWeblogicJMS()) {
            MessageDrivenBeanInfoImpl.debug("Dumping Messging Type MethodInfos for: " + this.getDisplayName());
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Messging Type Methods: ");
            Iterator iterator = this.getAllMessagingTypeMethodInfos().iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next().toString());
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", ");
            }
            MessageDrivenBeanInfoImpl.debug(stringBuffer.toString());
        }
    }

    @Override
    public void prepare(ApplicationContextInternal applicationContextInternal, DeploymentInfo deploymentInfo) throws WLDeploymentException {
        super.prepare(applicationContextInternal);
        this.ensureMDBHasDestinationConfigured();
        if (!this.getIsWeblogicJMS()) {
            this.setMethodDescriptors(null, this.getMessageDrivenLocalObjectClass(), "MessagingType");
        }
        if (debugLogger.isDebugEnabled()) {
            this.dumpMethodInfos();
            this.dumpMethodDescriptors();
        }
    }

    @Override
    public void activate(Context context, Map map, Map map2, DeploymentInfo deploymentInfo, Context context2) throws WLDeploymentException {
        this.environmentContext = context2;
        this.isRemoteSubjectExists = CrossDomainSecurityManager.getCrossDomainSecurityUtil().ifRemoteSubjectExists(this.m_providerURL);
        this.detectDestinationByJNDIName();
        this.resolveMessageDestinationLink(context2, this.getDeploymentInfo());
        this.resolveDestinationResourceLink();
        this.resolveConnectionFactoryResourceLink();
        String string = this.getDispatchPolicy();
        WorkManager workManager = WorkManagerFactory.getInstance().find("weblogic.kernel.Default");
        this.wm = WorkManagerFactory.getInstance().find(string, this.getDeploymentInfo().getApplicationName(), null);
        if (string != null) {
            if (workManager.getType() == 1 && this.wm == workManager) {
                EJBLogger.logMDBUnknownDispatchPolicyWM((String)this.getEJBName(), (String)string);
            } else if (workManager.getType() == 2 && !Kernel.isDispatchPolicy(string)) {
                EJBLogger.logMDBUnknownDispatchPolicy((String)this.getEJBName(), (String)string);
            }
        }
        if (!this.getIsWeblogicJMS()) {
            this.createJCAManager();
        }
    }

    private void createJCAManager() throws WLDeploymentException {
        this.setupBeanManager(this.ejbComponentRuntime);
        MessageDrivenManagerIntf messageDrivenManagerIntf = this.getBeanManager();
        messageDrivenManagerIntf.setup(null, null, this, this.environmentContext);
        this.mdManagerList.add(messageDrivenManagerIntf);
        this.postBeanManagerSetup(messageDrivenManagerIntf);
        if (debugLogger.isDebugEnabled()) {
            MessageDrivenBeanInfoImpl.debug("Deploying JCA based MD bean, resourceAdapterJNDIName:" + this.resourceAdapterJndiName);
        }
    }

    @Override
    public void deployMessageDrivenBeans() throws Exception {
        if (!this.getIsWeblogicJMS()) {
            if (this.mdManagerList.size() < 1) {
                EJBLogger.logErrorOnStartMDBs((String)this.getDisplayName());
                return;
            }
            MessageDrivenManagerIntf messageDrivenManagerIntf = this.mdManagerList.get(0);
            try {
                this.mdManagerStart(messageDrivenManagerIntf);
            }
            catch (WLDeploymentException wLDeploymentException) {
                throw wLDeploymentException;
            }
            catch (Exception exception) {
                EJBLogger.logStackTrace((Throwable)exception);
            }
            return;
        }
        while (this.destinationHandler.get() == null && !this.destinationHandler.compareAndSet(null, new DestinationEventHandler())) {
        }
        if (this.destinationHandler.get() != null) {
            this.destinationHandler.get().register();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mdManagerStart(MessageDrivenManagerIntf messageDrivenManagerIntf) throws WLDeploymentException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            EJBRuntimeUtils.pushEnvironment(this.environmentContext);
            Thread.currentThread().setContextClassLoader(this.getClassLoader());
            messageDrivenManagerIntf.start();
            messageDrivenManagerIntf.setIsDeployed(true);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            EJBRuntimeUtils.popEnvironment();
            Thread.currentThread().setContextClassLoader(classLoader);
            throw throwable;
        }
        EJBRuntimeUtils.popEnvironment();
        Thread.currentThread().setContextClassLoader(classLoader);
    }

    @Override
    public void onUndeploy() {
        block4: {
            if (this.isEJB30() && this.contextBoundCounter.getAndDecrement() <= 1) {
                if (debugLogger.isDebugEnabled()) {
                    MessageDrivenBeanInfoImpl.debug("Undeploying MDB destination:" + this.getDestinationName());
                }
                try {
                    this.getBeanManager().getEnvironmentContext().unbind("comp/EJBContext");
                }
                catch (NamingException namingException) {
                    if (!debugLogger.isDebugEnabled()) break block4;
                    MessageDrivenBeanInfoImpl.debug("error unbinding EJBContext from local environment: " + namingException);
                }
            }
        }
        super.onUndeploy();
    }

    private void resolveDestinationResourceLink() {
        if (this.destinationResourceLink != null) {
            this.m_destinationJNDIName = this.m_desc.resolveResourceLink(this.deploymentInfo.getApplicationId(), this.destinationResourceLink);
        }
    }

    private void resolveConnectionFactoryResourceLink() {
        if (this.connectionFactoryResourceLink != null) {
            this.m_connectionFactoryJNDIName = this.m_desc.resolveResourceLink(this.deploymentInfo.getApplicationId(), this.connectionFactoryResourceLink);
        }
    }

    private void resolveMessageDestinationLink(Context context, DeploymentInfo deploymentInfo) throws WLDeploymentException {
        if (this.messageDestinationLink != null) {
            Object object;
            MessageDestinationDescriptorBean messageDestinationDescriptorBean = null;
            try {
                object = (Context)context.lookup("app/messageDestination");
                String string = J2EEUtils.getAppScopedLinkPath(this.messageDestinationLink, deploymentInfo.getModuleURI(), (Context)object);
                if (string == null) {
                    Loggable loggable = EJBLogger.logUnableToResolveMDBMessageDestinationLinkLoggable((String)this.messageDestinationLink, (String)this.getEJBName(), (String)deploymentInfo.getModuleURI());
                    throw new WLDeploymentException(loggable.getMessage());
                }
                try {
                    messageDestinationDescriptorBean = (MessageDestinationDescriptorBean)object.lookup(string);
                }
                catch (NamingException namingException) {
                    Loggable loggable = EJBLogger.logUnableToResolveMDBMessageDestinationLinkLoggable((String)this.messageDestinationLink, (String)this.getEJBName(), (String)deploymentInfo.getModuleURI());
                    throw new WLDeploymentException(loggable.getMessage());
                }
            }
            catch (NamingException namingException) {
                throw new WLDeploymentException("Error resolving message-destination-link", namingException);
            }
            this.destinationResourceLink = messageDestinationDescriptorBean.getDestinationResourceLink();
            if (this.destinationResourceLink == null) {
                object = messageDestinationDescriptorBean.getDestinationJNDIName();
                this.m_destinationJNDIName = object = BaseEnvironmentBuilder.transformJNDIName((String)object, deploymentInfo.getApplicationName());
                this.m_initialContextFactory = messageDestinationDescriptorBean.getInitialContextFactory();
                this.m_providerURL = messageDestinationDescriptorBean.getProviderUrl();
            } else {
                this.m_destinationJNDIName = this.m_desc.resolveResourceLink(deploymentInfo.getApplicationId(), this.destinationResourceLink);
            }
        }
    }

    public AuthenticatedSubject getRightSubject(String string) throws NamingException {
        return (AuthenticatedSubject)CrossDomainSecurityManager.getCrossDomainSecurityUtil().getRemoteSubject(string, null);
    }

    private Destination lookupWithRightSubject(String string) throws NamingException {
        final Context context = this.getInitialContext();
        return (Destination)this.doPrivilagedAction((AuthenticatedSubject)this.subject, new PrivilegedExceptionAction(){

            public Object run() throws NamingException {
                return context.lookup(MessageDrivenBeanInfoImpl.this.m_destinationJNDIName);
            }
        });
    }

    private void postBeanManagerSetup(MessageDrivenManagerIntf messageDrivenManagerIntf) throws WLDeploymentException {
        if (this.isEJB30() && this.contextBoundCounter.getAndIncrement() < 1) {
            try {
                this.environmentContext.bind("comp/EJBContext", (Object)messageDrivenManagerIntf.getMessageDrivenContext());
            }
            catch (NamingException namingException) {
                throw new WLDeploymentException("Error binding EJBContext: " + namingException, namingException);
            }
        }
    }

    @Override
    public MigratableTargetMBean getMtMBean(String string) {
        MigratableTargetMBean migratableTargetMBean = null;
        if (string != null) {
            DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
            migratableTargetMBean = domainMBean.lookupMigratableTarget(string);
        }
        if (migratableTargetMBean != null && migratableTargetMBean.getServerNames() != null && !migratableTargetMBean.getServerNames().contains(this.currServerName)) {
            migratableTargetMBean = null;
        }
        return migratableTargetMBean;
    }

    @Override
    public boolean isGenerateUniqueJmsClientId() {
        return this.isGenerateUniqueJmsClientId;
    }

    private void ensureMDBHasDestinationConfigured() throws WLDeploymentException {
        if (this.destinationResourceLink == null && this.messageDestinationLink == null && this.m_destinationJNDIName == null && this.resourceAdapterJndiName == null) {
            Loggable loggable = EJBLogger.logNoMdbDestinationConfiguredLoggable((String)this.getDisplayName());
            throw new WLDeploymentException(loggable.getMessage());
        }
    }

    private void printDDMemberInfo(List<DestinationDetail> list) {
        if (list == null) {
            return;
        }
        int n = 0;
        for (DestinationDetail destinationDetail : list) {
            MessageDrivenBeanInfoImpl.debug("destination member[" + n + "]:" + ((Object)destinationDetail).toString());
            ++n;
        }
    }

    @Override
    public void updateImplClassLoader() throws WLDeploymentException {
        super.updateImplClassLoader();
        ArrayList<MessageDrivenManagerIntf> arrayList = new ArrayList<MessageDrivenManagerIntf>(this.mdManagerList);
        for (MessageDrivenManagerIntf messageDrivenManagerIntf : arrayList) {
            PoolIntf poolIntf = messageDrivenManagerIntf.getPool();
            poolIntf.reset();
            ((MessageDrivenManager)messageDrivenManagerIntf).updateImplCL();
        }
    }

    @Override
    public void updateJMSPollingIntervalSeconds(int n) {
        this.jmsPollingIntervalSeconds = n;
        ArrayList<MessageDrivenManagerIntf> arrayList = new ArrayList<MessageDrivenManagerIntf>(this.mdManagerList);
        for (MessageDrivenManagerIntf messageDrivenManagerIntf : arrayList) {
            messageDrivenManagerIntf.updateJMSPollingIntervalSeconds(n);
        }
        if (debugLogger.isDebugEnabled()) {
            MessageDrivenBeanInfoImpl.debug("updated JMSPollingIntervalSeconds to " + n + " for EJB " + this.getDisplayName());
        }
    }

    @Override
    public void updateMaxBeansInFreePool(int n) {
        this.m_maxConcurrentInstances = n;
        ArrayList<MessageDrivenManagerIntf> arrayList = new ArrayList<MessageDrivenManagerIntf>(this.mdManagerList);
        for (MessageDrivenManagerIntf messageDrivenManagerIntf : arrayList) {
            PoolIntf poolIntf = messageDrivenManagerIntf.getPool();
            poolIntf.updateMaxBeansInFreePool(n);
        }
        if (debugLogger.isDebugEnabled()) {
            MessageDrivenBeanInfoImpl.debug("updated MaxBeansInFreePool to " + n + " for EJB " + this.getDisplayName());
        }
    }

    private void resetMessageConsumers(List<MessageDrivenManagerIntf> list, boolean bl) {
        for (MessageDrivenManagerIntf messageDrivenManagerIntf : list) {
            messageDrivenManagerIntf.resetMessageConsumer(bl);
        }
    }

    public synchronized void undeployManagers(boolean bl) {
        ArrayList<MessageDrivenManagerIntf> arrayList = new ArrayList<MessageDrivenManagerIntf>(this.mdManagerList);
        this.mdManagerList.clear();
        this.backupDestMembersList.clear();
        for (MessageDrivenManagerIntf object : arrayList) {
            object.undeploy();
        }
        MessageDrivenManagerIntf messageDrivenManagerIntf = this.defaultMDManager.getAndSet(null);
        if (messageDrivenManagerIntf != null) {
            messageDrivenManagerIntf.undeploy();
            arrayList.add(messageDrivenManagerIntf);
        }
        if (this.isDurableSubscriber() && bl) {
            for (MessageDrivenManagerIntf messageDrivenManagerIntf2 : arrayList) {
                messageDrivenManagerIntf2.remove();
            }
        }
    }

    public void updatePoolIdleTimeoutSeconds(int n) {
        ArrayList<MessageDrivenManagerIntf> arrayList = new ArrayList<MessageDrivenManagerIntf>(this.mdManagerList);
        for (MessageDrivenManagerIntf messageDrivenManagerIntf : arrayList) {
            PoolIntf poolIntf = messageDrivenManagerIntf.getPool();
            poolIntf.updateIdleTimeoutSeconds(n);
        }
        if (debugLogger.isDebugEnabled()) {
            MessageDrivenBeanInfoImpl.debug("updated Pool IdleTimeoutSeconds to " + n + " for EJB " + this.getDisplayName());
        }
    }

    public void prepareUpdate(BeanUpdateEvent beanUpdateEvent) throws BeanUpdateRejectedException {
        if (debugLogger.isDebugEnabled()) {
            MessageDrivenBeanInfoImpl.debug("prepareUpdate: " + beanUpdateEvent);
        }
    }

    private void stopAndUnregisterJMS() {
        for (MessageDrivenManagerIntf messageDrivenManagerIntf : this.mdManagerList) {
            messageDrivenManagerIntf.stop();
            messageDrivenManagerIntf.setMDBStatus(DDConstants.MDBStatus[5]);
        }
        if (this.getIsWeblogicJMS()) {
            this.destinationHandler.get().unRegister();
        }
        EJBLogger.logMDBInactive((String)this.getEJBName());
    }

    public void rollbackUpdate(BeanUpdateEvent beanUpdateEvent) {
        if (debugLogger.isDebugEnabled()) {
            MessageDrivenBeanInfoImpl.debug("rollbackUpdate: " + beanUpdateEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateUpdate(BeanUpdateEvent beanUpdateEvent) throws BeanUpdateFailedException {
        Object object;
        if (debugLogger.isDebugEnabled()) {
            MessageDrivenBeanInfoImpl.debug("activateUpdate: " + beanUpdateEvent);
        }
        UpdateOperation updateOperation = UpdateOperation.NOOPERATION;
        BeanUpdateEvent.PropertyUpdate[] propertyUpdateArray = beanUpdateEvent.getUpdateList();
        DescriptorBean descriptorBean = beanUpdateEvent.getProposedBean();
        boolean bl = this.topicMessagesDistributionMode == 2 || this.topicMessagesDistributionMode == 1;
        boolean bl2 = false;
        block10: for (int i = 0; i < propertyUpdateArray.length; ++i) {
            object = propertyUpdateArray[i];
            switch (object.getUpdateType()) {
                case 1: {
                    String string = object.getPropertyName();
                    if (debugLogger.isDebugEnabled()) {
                        MessageDrivenBeanInfoImpl.debug("Changing property of type: " + (String)string);
                    }
                    if (string.equals("MaxBeansInFreePool")) {
                        PoolBean poolBean = (PoolBean)descriptorBean;
                        this.updateMaxBeansInFreePool(poolBean.getMaxBeansInFreePool());
                        continue block10;
                    }
                    if (string.equals("TransTimeoutSeconds")) {
                        TransactionDescriptorBean transactionDescriptorBean = (TransactionDescriptorBean)descriptorBean;
                        this.updateTransactionTimeoutSeconds(transactionDescriptorBean.getTransTimeoutSeconds());
                        continue block10;
                    }
                    if (string.equals("InitSuspendSeconds")) {
                        this.initSuspendSeconds = ((MessageDrivenDescriptorBean)descriptorBean).getInitSuspendSeconds();
                        continue block10;
                    }
                    if (string.equals("MaxSuspendSeconds")) {
                        this.maxSuspendSeconds = ((MessageDrivenDescriptorBean)descriptorBean).getMaxSuspendSeconds();
                        continue block10;
                    }
                    if (string.equals("JmsPollingIntervalSeconds")) {
                        this.updateJMSPollingIntervalSeconds(((MessageDrivenDescriptorBean)descriptorBean).getJmsPollingIntervalSeconds());
                        continue block10;
                    }
                    if (string.equals("MaxMessagesInTransaction")) {
                        this.maxMessagesInTransaction = ((MessageDrivenDescriptorBean)descriptorBean).getMaxMessagesInTransaction();
                        updateOperation = UpdateOperation.compareAndSet(UpdateOperation.RECONNECTION, updateOperation);
                        continue block10;
                    }
                    if (string.equals("IdleTimeoutSeconds")) {
                        PoolBean poolBean = (PoolBean)descriptorBean;
                        this.updatePoolIdleTimeoutSeconds(poolBean.getIdleTimeoutSeconds());
                        continue block10;
                    }
                    if (string.equals("ProviderUrl")) {
                        this.m_providerURL = ((MessageDrivenDescriptorBean)descriptorBean).getProviderUrl();
                        updateOperation = UpdateOperation.compareAndSet(UpdateOperation.REREGISTER, updateOperation);
                        continue block10;
                    }
                    if (string.equals("DestinationJNDIName")) {
                        this.m_destinationJNDIName = ((MessageDrivenDescriptorBean)descriptorBean).getDestinationJNDIName();
                        updateOperation = UpdateOperation.compareAndSet(UpdateOperation.REREGISTER, updateOperation);
                        continue block10;
                    }
                    if (string.equals("InitialContextFactory")) {
                        this.m_initialContextFactory = ((MessageDrivenDescriptorBean)descriptorBean).getInitialContextFactory();
                        updateOperation = UpdateOperation.compareAndSet(UpdateOperation.REREGISTER, updateOperation);
                        continue block10;
                    }
                    if (string.equals("ConnectionFactoryJNDIName")) {
                        this.m_connectionFactoryJNDIName = ((MessageDrivenDescriptorBean)descriptorBean).getConnectionFactoryJNDIName();
                        updateOperation = UpdateOperation.compareAndSet(UpdateOperation.REREGISTER, updateOperation);
                        continue block10;
                    }
                    if (string.equals("DestinationResourceLink")) {
                        this.destinationResourceLink = ((MessageDrivenDescriptorBean)descriptorBean).getDestinationResourceLink();
                        this.resolveDestinationResourceLink();
                        updateOperation = UpdateOperation.compareAndSet(UpdateOperation.REREGISTER, updateOperation);
                        continue block10;
                    }
                    if (string.equals("ConnectionFactoryResourceLink")) {
                        this.connectionFactoryResourceLink = ((MessageDrivenDescriptorBean)descriptorBean).getConnectionFactoryResourceLink();
                        this.resolveConnectionFactoryResourceLink();
                        updateOperation = UpdateOperation.compareAndSet(UpdateOperation.REREGISTER, updateOperation);
                        continue block10;
                    }
                    if (string.equals("JmsClientId")) {
                        this.jmsClientID = ((MessageDrivenDescriptorBean)descriptorBean).getJmsClientId();
                        bl2 = this.needUnsubscribe(bl, bl2);
                        updateOperation = UpdateOperation.compareAndSet(UpdateOperation.RECONNECTION, updateOperation);
                        continue block10;
                    }
                    if (string.equals("GenerateUniqueJmsClientId")) {
                        this.isGenerateUniqueJmsClientId = ((MessageDrivenDescriptorBean)descriptorBean).isGenerateUniqueJmsClientId();
                        updateOperation = UpdateOperation.compareAndSet(UpdateOperation.RECONNECTION, updateOperation);
                        continue block10;
                    }
                    if (string.equals("Use81StylePolling")) {
                        this.use81StylePolling = ((MessageDrivenDescriptorBean)descriptorBean).isUse81StylePolling();
                        updateOperation = UpdateOperation.compareAndSet(UpdateOperation.RECONNECTION, updateOperation);
                        continue block10;
                    }
                    if (string.equals("DistributedDestinationConnection")) {
                        this.distributedDestinationConnection = this.convertToInt("distributedDestinationConnection", DDConstants.DISTRIBUTEDDESTINATIONCONNECTIONS, ((MessageDrivenDescriptorBean)descriptorBean).getDistributedDestinationConnection());
                        updateOperation = UpdateOperation.compareAndSet(UpdateOperation.REREGISTER, updateOperation);
                        continue block10;
                    }
                    if (string.equals("DurableSubscriptionDeletion")) {
                        this.isDurableSubscriptionDeletion = ((MessageDrivenDescriptorBean)descriptorBean).isDurableSubscriptionDeletion();
                        updateOperation = UpdateOperation.compareAndSet(UpdateOperation.RECONNECTION, updateOperation);
                        continue block10;
                    }
                    if (string.equals("TopicMessageDistributionMode")) {
                        this.topicMessagesDistributionMode = this.convertToInt("TOPICMESSAGESDISTRIBUTIONMODE", DDConstants.TOPICMESSAGEDISTRIBUTIONMODES, ((MessageDrivenDescriptorBean)descriptorBean).toString());
                        bl2 = true;
                        updateOperation = UpdateOperation.compareAndSet(UpdateOperation.REREGISTER, updateOperation);
                        continue block10;
                    }
                    if (string.equals("ResourceAdapterJNDIName")) {
                        this.resourceAdapterJndiName = ((MessageDrivenDescriptorBean)descriptorBean).getResourceAdapterJNDIName();
                        updateOperation = UpdateOperation.compareAndSet(UpdateOperation.REREGISTER, updateOperation);
                        continue block10;
                    }
                    if (string.equals("ActivationConfigPropertyValue")) {
                        ActivationConfigPropertyBean activationConfigPropertyBean = (ActivationConfigPropertyBean)descriptorBean;
                        if (activationConfigPropertyBean.getActivationConfigPropertyName().equalsIgnoreCase("MESSAGESELECTOR")) {
                            this.m_messageSelector = activationConfigPropertyBean.getActivationConfigPropertyValue();
                            if (debugLogger.isDebugEnabled()) {
                                MessageDrivenBeanInfoImpl.debug("updated MessageSelector to " + this.m_messageSelector + " for EJB " + this.getDisplayName());
                            }
                            bl2 = this.needUnsubscribe(bl, bl2);
                            updateOperation = UpdateOperation.compareAndSet(UpdateOperation.RECONNECTION, updateOperation);
                            continue block10;
                        }
                        if (activationConfigPropertyBean.getActivationConfigPropertyName().equalsIgnoreCase("TOPICMESSAGESDISTRIBUTIONMODE")) {
                            this.topicMessagesDistributionMode = this.convertToInt("TOPICMESSAGESDISTRIBUTIONMODE", DDConstants.TOPICMESSAGEDISTRIBUTIONMODES, activationConfigPropertyBean.getActivationConfigPropertyValue());
                            bl2 = true;
                            updateOperation = UpdateOperation.REREGISTER;
                            continue block10;
                        }
                        if (activationConfigPropertyBean.getActivationConfigPropertyName().equalsIgnoreCase("INACTIVE")) {
                            this.m_isInactive = Boolean.parseBoolean(activationConfigPropertyBean.getActivationConfigPropertyValue());
                            if (!this.m_isInactive) {
                                if (this.getIsWeblogicJMS()) {
                                    this.destinationHandler.get().registerToJMS(this.jmsRegisterEnv);
                                } else {
                                    try {
                                        for (MessageDrivenManagerIntf messageDrivenManagerIntf : this.mdManagerList) {
                                            this.mdManagerStart(messageDrivenManagerIntf);
                                        }
                                    }
                                    catch (WLDeploymentException wLDeploymentException) {
                                        Loggable loggable = EJBLogger.logInactiveMDBStartFailLoggable((String)this.getEJBName(), (Exception)wLDeploymentException);
                                        EJBLogger.logStackTraceAndMessage((String)loggable.getMessageText(), (Throwable)wLDeploymentException);
                                        this.stopAndUnregisterJMS();
                                        this.m_isInactive = true;
                                        throw new BeanUpdateFailedException(loggable.getMessage());
                                    }
                                }
                                EJBLogger.logMDBActive((String)this.getEJBName());
                                continue block10;
                            }
                            this.stopAndUnregisterJMS();
                            continue block10;
                        }
                        throw new AssertionError("unexpected ActivationConfigProperty");
                    }
                    throw new AssertionError("Unexpected propertyName: " + (String)string);
                }
                case 2: 
                case 3: {
                    throw new AssertionError("Unexpected BeanUpdateEvent: " + beanUpdateEvent);
                }
            }
        }
        if (updateOperation.equals((Object)UpdateOperation.REREGISTER)) {
            this.undeployManagers(bl2);
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                try {
                    Thread.currentThread().setContextClassLoader((ClassLoader)this.moduleCL);
                    if (this.getIsWeblogicJMS()) {
                        this.unRegister();
                        if (this.destinationHandler.get() == null) {
                            throw new AssertionError("The MDB application does not exist at all");
                        }
                    } else {
                        this.createJCAManager();
                    }
                    this.deployMessageDrivenBeans();
                }
                catch (Throwable throwable) {
                    EJBLogger.logStackTraceLoggable((Throwable)throwable);
                    Object var14_25 = null;
                    Thread.currentThread().setContextClassLoader(classLoader);
                }
                Object var14_24 = null;
                Thread.currentThread().setContextClassLoader(classLoader);
            }
            catch (Throwable throwable) {
                Object var14_26 = null;
                Thread.currentThread().setContextClassLoader(classLoader);
                throw throwable;
            }
        } else if (updateOperation.equals((Object)UpdateOperation.RECONNECTION)) {
            ArrayList<MessageDrivenManagerIntf> arrayList = new ArrayList<MessageDrivenManagerIntf>(this.mdManagerList);
            object = this.defaultMDManager.getAndSet(null);
            if (object != null) {
                arrayList.add((MessageDrivenManagerIntf)object);
            }
            for (MessageDrivenManagerIntf messageDrivenManagerIntf : arrayList) {
                messageDrivenManagerIntf.stop();
            }
            this.resetMessageConsumers(arrayList, bl2);
        }
    }

    private boolean needUnsubscribe(boolean bl, boolean bl2) {
        return bl2 ? bl2 : bl;
    }

    private static void debug(String string) {
        debugLogger.debug("[MessageDrivenBeanInfoImpl] " + string);
    }

    @Override
    public String getDestinationResourceLink() {
        return this.destinationResourceLink;
    }

    @Override
    public void setEJBComponentRuntime(EJBComponentRuntimeMBeanImpl eJBComponentRuntimeMBeanImpl) {
        this.ejbComponentRuntime = eJBComponentRuntimeMBeanImpl;
    }

    public Object doPrivilagedAction(AuthenticatedSubject authenticatedSubject, PrivilegedExceptionAction privilegedExceptionAction) throws NamingException {
        if (authenticatedSubject == null || SecurityServiceManager.isKernelIdentity((AuthenticatedSubject)authenticatedSubject) || SecurityServiceManager.isServerIdentity((AuthenticatedSubject)authenticatedSubject) || this.getIsRemoteSubjectExists()) {
            authenticatedSubject = this.getRightSubject(this.m_providerURL);
        }
        try {
            return authenticatedSubject.doAs((AbstractSubject)kernelId, privilegedExceptionAction);
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (privilegedActionException.getCause() instanceof NamingException) {
                throw (NamingException)privilegedActionException.getCause();
            }
            throw new AssertionError((Throwable)privilegedActionException);
        }
    }

    private boolean isSet(String string, Object object) {
        return ((DescriptorBean)object).isSet(string);
    }

    public int convertToInt(String string, String[] stringArray, String string2) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase(string2)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getDistributedDestinationConnection() {
        return this.distributedDestinationConnection;
    }

    @Override
    public int getTopicMessagesDistributionMode() {
        return this.topicMessagesDistributionMode;
    }

    @Override
    public void unRegister() {
        if (this.destinationHandler.get() != null) {
            this.destinationHandler.get().unRegister();
        }
    }

    private void debugPropertyValue(String string, String string2) {
        if (debugLogger.isDebugEnabled()) {
            MessageDrivenBeanInfoImpl.debug("In the EJB " + this.getDisplayName() + ", the value for the activation config property '" + string + "' is '" + string2 + "'");
        }
    }

    protected MessageDrivenManagerIntf createMDManager(Context context, MigratableTargetMBean migratableTargetMBean, DestinationDetail destinationDetail) throws WLDeploymentException {
        MessageDrivenManagerIntf messageDrivenManagerIntf;
        Object var4_4 = null;
        if (debugLogger.isDebugEnabled()) {
            if (destinationDetail != null && MessageDrivenBeanInfoImpl.isDistributedDestination(destinationDetail)) {
                MessageDrivenBeanInfoImpl.debug("Creating MDManager for member: " + ((Object)destinationDetail).toString());
            } else {
                MessageDrivenBeanInfoImpl.debug("Creating MDManager for destination: " + this.m_destinationJNDIName);
            }
        }
        this.setupBeanManager(this.ejbComponentRuntime);
        MessageDrivenManagerIntf messageDrivenManagerIntf2 = messageDrivenManagerIntf = this.getBeanManager();
        messageDrivenManagerIntf2.setup(this, context, this.m_destinationJNDIName, this.domainName, this.currServerName, this.jmsClientIDBase, migratableTargetMBean, destinationDetail);
        this.postBeanManagerSetup(messageDrivenManagerIntf2);
        return messageDrivenManagerIntf;
    }

    private static boolean isDistributedDestination(DestinationDetail destinationDetail) {
        return destinationDetail.getType() == 4 || destinationDetail.getType() == 6 || destinationDetail.getType() == 5;
    }

    @Override
    public boolean getIsInactive() {
        return this.m_isInactive;
    }

    @Override
    public WorkManager getCustomWorkManager() {
        return this.wm;
    }

    @Override
    public MDBTimerManagerFactory getTimerManagerFactory() {
        return this.mdbTimerManagerFactory;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class QueueConnectionHandler
    extends DestinationResovler {
        public QueueConnectionHandler() {
            this(false);
        }

        public QueueConnectionHandler(boolean bl) {
            this.isDD = bl;
        }

        @Override
        public boolean complianceCheck(List<DestinationDetail> list) {
            if (MessageDrivenBeanInfoImpl.this.topicMessagesDistributionMode > 0) {
                EJBLogger.logInvalidConfigurationForTopicMessagesDistributionMode((String)MessageDrivenBeanInfoImpl.this.getDisplayName());
                return false;
            }
            if (MessageDrivenBeanInfoImpl.this.distributedDestinationConnection < 0) {
                MessageDrivenBeanInfoImpl.this.distributedDestinationConnection = 0;
            }
            return true;
        }

        @Override
        void handleDD(List<DestinationDetail> list) {
            if (list.size() >= 1) {
                DestinationDetail destinationDetail = list.get(0);
                this.connectionMode = !destinationDetail.isLocalCluster() ? 1 : (MessageDrivenBeanInfoImpl.this.distributedDestinationConnection <= 0 ? 2 : 1);
                this.activateMDManagerList(this.createDDMDManagers(list));
            }
        }

        @Override
        void handleNoneDD(List<DestinationDetail> list) {
            for (DestinationDetail destinationDetail : list) {
                this.activateNoneDDMDManager(destinationDetail);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TopicConnectionHandler
    extends DestinationResovler {
        private boolean isPartitioned;

        public TopicConnectionHandler() {
            this(false, false);
        }

        public TopicConnectionHandler(boolean bl, boolean bl2) {
            this.isPartitioned = false;
            this.isDD = bl;
            this.isPartitioned = bl2;
        }

        @Override
        public boolean complianceCheck(List<DestinationDetail> list) {
            if (MessageDrivenBeanInfoImpl.this.topicMessagesDistributionMode < 0) {
                this.detectDefauleMode();
            }
            if (MessageDrivenBeanInfoImpl.this.topicMessagesDistributionMode == 0) {
                if (this.isPartitioned) {
                    EJBLogger.logIllegalPermutationOnPDTAndComp((String)MessageDrivenBeanInfoImpl.this.getDisplayName());
                    return false;
                }
                if (MessageDrivenBeanInfoImpl.this.isDurableSubscriber()) {
                    for (DestinationDetail destinationDetail : list) {
                        if (destinationDetail.getType() != 5 || destinationDetail.isLocalCluster()) continue;
                        EJBLogger.logIllegalSubscriptionOnDurRemoteRDT((String)MessageDrivenBeanInfoImpl.this.getDisplayName(), (String)MessageDrivenBeanInfoImpl.this.getDestinationName());
                        return false;
                    }
                }
                if (MessageDrivenBeanInfoImpl.this.distributedDestinationConnection < 0) {
                    MessageDrivenBeanInfoImpl.this.distributedDestinationConnection = 0;
                }
            } else {
                for (DestinationDetail destinationDetail : list) {
                    if (destinationDetail.getType() != 3 && destinationDetail.isAdvancedTopicSupported()) continue;
                    EJBLogger.logInvalidConfigurationForPre1033((String)MessageDrivenBeanInfoImpl.this.getDisplayName(), (String)"topicMessagesDistributionMode");
                    return false;
                }
            }
            return true;
        }

        @Override
        void handleDD(List<DestinationDetail> list) {
            if (list.size() >= 1) {
                DestinationDetail destinationDetail = list.get(0);
                if (MessageDrivenBeanInfoImpl.this.topicMessagesDistributionMode == 0) {
                    if (!destinationDetail.isLocalCluster()) {
                        this.connectionMode = 3;
                        if (BeanInfoImpl.debugLogger.isDebugEnabled()) {
                            MessageDrivenBeanInfoImpl.debug("The JMS destination at the JNDI name " + destinationDetail.getJNDIName() + " is a remote Distributed Topic and '" + DDConstants.TOPICMESSAGEDISTRIBUTIONMODES[MessageDrivenBeanInfoImpl.this.topicMessagesDistributionMode] + "' is configured so a connection will be made to one member of the Distributed Topic.");
                        }
                    } else {
                        this.connectionMode = 4;
                        if (BeanInfoImpl.debugLogger.isDebugEnabled()) {
                            MessageDrivenBeanInfoImpl.debug("The JMS destination at the JNDI name " + destinationDetail.getJNDIName() + " is a local Distributed Topic and '" + DDConstants.TOPICMESSAGEDISTRIBUTIONMODES[MessageDrivenBeanInfoImpl.this.topicMessagesDistributionMode] + "' is configured so a connection will be made to every member of the Distributed Topic.");
                        }
                    }
                } else if (!destinationDetail.isLocalCluster()) {
                    if (!MessageDrivenBeanInfoImpl.this.isDurableSubscriber() && destinationDetail.getType() == 5 && MessageDrivenBeanInfoImpl.this.topicMessagesDistributionMode == 1) {
                        this.connectionMode = 3;
                        MessageDrivenBeanInfoImpl.this.distributedDestinationConnection = 0;
                    } else {
                        this.connectionMode = 1;
                        MessageDrivenBeanInfoImpl.this.distributedDestinationConnection = 1;
                    }
                } else if (MessageDrivenBeanInfoImpl.this.distributedDestinationConnection == 1) {
                    if (BeanInfoImpl.debugLogger.isDebugEnabled()) {
                        MessageDrivenBeanInfoImpl.debug("The JMS destination at the JNDI name " + destinationDetail.getJNDIName() + " is a local Distributed Topic and '" + DDConstants.TOPICMESSAGEDISTRIBUTIONMODES[MessageDrivenBeanInfoImpl.this.topicMessagesDistributionMode] + "' is configured so a connection will be made to every member of the Distributed Topic.");
                    }
                    this.connectionMode = 1;
                } else if (MessageDrivenBeanInfoImpl.this.distributedDestinationConnection == 0) {
                    if (this.isPartitioned && MessageDrivenBeanInfoImpl.this.topicMessagesDistributionMode == 1) {
                        EJBLogger.logOverridenLocalOnlyWithEveryMember((String)MessageDrivenBeanInfoImpl.this.getDisplayName());
                        this.connectionMode = 1;
                    } else {
                        if (BeanInfoImpl.debugLogger.isDebugEnabled()) {
                            MessageDrivenBeanInfoImpl.debug("The JMS destination at the JNDI name " + destinationDetail.getJNDIName() + " is a local Distributed Topic and '" + DDConstants.TOPICMESSAGEDISTRIBUTIONMODES[MessageDrivenBeanInfoImpl.this.topicMessagesDistributionMode] + "' is configured so a connection will be made to every member on local server.");
                        }
                        this.connectionMode = 2;
                    }
                } else if (2 == MessageDrivenBeanInfoImpl.this.topicMessagesDistributionMode) {
                    if (BeanInfoImpl.debugLogger.isDebugEnabled()) {
                        MessageDrivenBeanInfoImpl.debug("The JMS Destination " + destinationDetail.getJNDIName() + " is replicated distributed topic, so 'EveryMember' is the defaule value for 'DistributionConnection'");
                    }
                    this.connectionMode = 2;
                } else if (1 == MessageDrivenBeanInfoImpl.this.topicMessagesDistributionMode) {
                    if (this.isPartitioned) {
                        if (BeanInfoImpl.debugLogger.isDebugEnabled()) {
                            MessageDrivenBeanInfoImpl.debug("The JMS Destination " + destinationDetail.getJNDIName() + " is partitioned distributed topic, so 'EveryMember' is the defaule value for 'DistributionConnection'");
                        }
                        this.connectionMode = 1;
                    } else {
                        if (BeanInfoImpl.debugLogger.isDebugEnabled()) {
                            MessageDrivenBeanInfoImpl.debug("The JMS Destination " + destinationDetail.getJNDIName() + " is replicated distributed topic, so 'EveryMember' is the defaule value for 'DistributionConnection'");
                        }
                        this.connectionMode = 2;
                    }
                }
                this.activateMDManagerList(this.createDDMDManagers(list));
            }
        }

        @Override
        void handleNoneDD(List<DestinationDetail> list) {
            for (DestinationDetail destinationDetail : list) {
                this.activateNoneDDMDManager(destinationDetail);
            }
        }

        @Override
        protected void undeployAndActivate(MessageDrivenManagerIntf messageDrivenManagerIntf) {
            if (this.isDD && !this.isPartitioned) {
                ArrayList<DestinationDetail> arrayList = new ArrayList<DestinationDetail>(MessageDrivenBeanInfoImpl.this.backupDestMembersList);
                if (this.connectionMode == 3 || this.connectionMode == 4) {
                    if (this.releaseOne()) {
                        messageDrivenManagerIntf.undeploy();
                    } else {
                        MessageDrivenBeanInfoImpl.debug("duplicate remove event on destination " + messageDrivenManagerIntf.getDDMemberName());
                    }
                    if (arrayList.size() > 0) {
                        this.activateBackupMemeber(arrayList);
                    }
                } else {
                    messageDrivenManagerIntf.undeploy();
                    if (this.connectionMode == 2 && arrayList.size() > 0) {
                        this.activateBackupMemeber(arrayList);
                    }
                }
            } else {
                messageDrivenManagerIntf.undeploy();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void activateBackupMemeber(List<DestinationDetail> list) {
            MigratableTargetMBean migratableTargetMBean = null;
            MessageDrivenManagerIntf messageDrivenManagerIntf = null;
            try {
                DestinationDetail destinationDetail;
                if (this.connectionMode == 2) {
                    destinationDetail = list.remove(0);
                    migratableTargetMBean = MessageDrivenBeanInfoImpl.this.getMtMBean(destinationDetail.getMigratableTargetName());
                    messageDrivenManagerIntf = MessageDrivenBeanInfoImpl.this.createMDManager(MessageDrivenBeanInfoImpl.this.environmentContext, migratableTargetMBean, destinationDetail);
                } else if (this.connectionMode == 3) {
                    destinationDetail = null;
                    for (int i = 0; i < list.size() && !(destinationDetail = list.get(i)).isLocalWLSServer(); ++i) {
                    }
                    list.remove(destinationDetail);
                    migratableTargetMBean = MessageDrivenBeanInfoImpl.this.getMtMBean(destinationDetail.getMigratableTargetName());
                    TopicConnectionHandler topicConnectionHandler = this;
                    synchronized (topicConnectionHandler) {
                        if (this.createOne()) {
                            messageDrivenManagerIntf = MessageDrivenBeanInfoImpl.this.createMDManager(MessageDrivenBeanInfoImpl.this.environmentContext, migratableTargetMBean, destinationDetail);
                        }
                    }
                } else if (this.connectionMode == 4) {
                    destinationDetail = list.remove(0);
                    migratableTargetMBean = MessageDrivenBeanInfoImpl.this.getMtMBean(destinationDetail.getMigratableTargetName());
                    if (migratableTargetMBean == null) {
                        TopicConnectionHandler topicConnectionHandler = this;
                        synchronized (topicConnectionHandler) {
                            if (this.createOne()) {
                                messageDrivenManagerIntf = MessageDrivenBeanInfoImpl.this.createMDManager(MessageDrivenBeanInfoImpl.this.environmentContext, migratableTargetMBean, destinationDetail);
                            }
                        }
                    } else {
                        messageDrivenManagerIntf = MessageDrivenBeanInfoImpl.this.createMDManager(MessageDrivenBeanInfoImpl.this.environmentContext, migratableTargetMBean, destinationDetail);
                    }
                }
                if (messageDrivenManagerIntf != null) {
                    try {
                        MessageDrivenBeanInfoImpl.this.mdManagerStart(messageDrivenManagerIntf);
                        MessageDrivenBeanInfoImpl.this.mdManagerList.add(messageDrivenManagerIntf);
                    }
                    catch (Exception exception) {
                        EJBLogger.logStackTrace((Throwable)exception);
                    }
                }
            }
            catch (WLDeploymentException wLDeploymentException) {
                // empty catch block
            }
        }

        private void detectDefauleMode() {
            if (this.isPartitioned) {
                MessageDrivenBeanInfoImpl.this.topicMessagesDistributionMode = 2;
                if (BeanInfoImpl.debugLogger.isDebugEnabled()) {
                    MessageDrivenBeanInfoImpl.debug("Activation config proerty TOPICMESSAGESDISTRIBUTIONMODE on EJB '" + MessageDrivenBeanInfoImpl.this.getDisplayName() + " is not specified, default value is " + DDConstants.TOPICMESSAGEDISTRIBUTIONMODES[MessageDrivenBeanInfoImpl.this.topicMessagesDistributionMode]);
                }
            } else {
                MessageDrivenBeanInfoImpl.this.topicMessagesDistributionMode = 0;
                if (BeanInfoImpl.debugLogger.isDebugEnabled()) {
                    MessageDrivenBeanInfoImpl.debug("Activation config proerty TOPICMESSAGESDISTRIBUTIONMODE on EJB " + MessageDrivenBeanInfoImpl.this.getDisplayName() + " is not specified, the default value is " + DDConstants.TOPICMESSAGEDISTRIBUTIONMODES[MessageDrivenBeanInfoImpl.this.topicMessagesDistributionMode]);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class DestinationResovler {
        boolean isDD = false;
        protected int connectionMode;
        protected static final int EVERYMEMBER_MODE = 1;
        protected static final int LOCALMEMBER_MODE = 2;
        protected static final int ONLYONEOF_MODE = 3;
        protected static final int LOCALMEMBER_PRE10_3_3_MODE = 4;
        protected boolean activedOne = false;

        DestinationResovler() {
        }

        protected boolean createOne() {
            if (!this.activedOne) {
                this.activedOne = true;
                return true;
            }
            return false;
        }

        protected synchronized boolean releaseOne() {
            if (this.activedOne) {
                this.activedOne = false;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean resolveDestnationWorkMode(List<DestinationDetail> list) {
            if (!this.complianceCheck(list)) {
                return false;
            }
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                EJBRuntimeUtils.pushEnvironment(MessageDrivenBeanInfoImpl.this.environmentContext);
                Thread.currentThread().setContextClassLoader(MessageDrivenBeanInfoImpl.this.getClassLoader());
                if (this.isDD) {
                    this.handleDD(list);
                } else {
                    this.handleNoneDD(list);
                }
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                EJBRuntimeUtils.popEnvironment();
                Thread.currentThread().setContextClassLoader(classLoader);
                throw throwable;
            }
            EJBRuntimeUtils.popEnvironment();
            Thread.currentThread().setContextClassLoader(classLoader);
            return true;
        }

        abstract boolean complianceCheck(List<DestinationDetail> var1);

        abstract void handleDD(List<DestinationDetail> var1);

        abstract void handleNoneDD(List<DestinationDetail> var1);

        void activateMDManagerList(List<MessageDrivenManagerIntf> list) {
            for (MessageDrivenManagerIntf messageDrivenManagerIntf : list) {
                try {
                    messageDrivenManagerIntf.setMDBStatus(DDConstants.MDBStatus[1]);
                    MessageDrivenBeanInfoImpl.this.mdManagerStart(messageDrivenManagerIntf);
                }
                catch (Exception exception) {
                    EJBLogger.logStackTrace((Throwable)exception);
                }
            }
            MessageDrivenBeanInfoImpl.this.mdManagerList.addAll(list);
            MessageDrivenManagerIntf messageDrivenManagerIntf = MessageDrivenBeanInfoImpl.this.defaultMDManager.getAndSet(null);
            if (messageDrivenManagerIntf != null) {
                messageDrivenManagerIntf.undeploy();
            }
        }

        private MessageDrivenManagerIntf createDefaultMDManager() {
            Object var1_1 = null;
            MessageDrivenManagerIntf messageDrivenManagerIntf = null;
            try {
                messageDrivenManagerIntf = MessageDrivenBeanInfoImpl.this.createMDManager(MessageDrivenBeanInfoImpl.this.environmentContext, null, null);
                messageDrivenManagerIntf.setMDBStatus(DDConstants.MDBStatus[0]);
            }
            catch (WLDeploymentException wLDeploymentException) {
                // empty catch block
            }
            return messageDrivenManagerIntf;
        }

        protected void activateNoneDDMDManager(DestinationDetail destinationDetail) {
            Object var2_2 = null;
            MessageDrivenManagerIntf messageDrivenManagerIntf = MessageDrivenBeanInfoImpl.this.defaultMDManager.getAndSet(null);
            if (messageDrivenManagerIntf == null) {
                throw new AssertionError("no creating MDB manager in deployment");
            }
            try {
                messageDrivenManagerIntf.enableDestination(destinationDetail);
                messageDrivenManagerIntf.setMDBStatus(DDConstants.MDBStatus[1]);
                boolean bl = ((MessageDrivenManager)messageDrivenManagerIntf).isNoneDDMD();
                if (bl && var2_2 != null) {
                    MigrationManager.singleton().register((Migratable)((Object)messageDrivenManagerIntf), var2_2);
                } else {
                    messageDrivenManagerIntf.start();
                    messageDrivenManagerIntf.setIsDeployed(true);
                }
            }
            catch (Exception exception) {
                EJBLogger.logStackTraceAndMessage((String)("Error in starting the MDB " + MessageDrivenBeanInfoImpl.this.getName()), (Throwable)exception);
            }
            TimerManager timerManager = messageDrivenManagerIntf.getTimerManager();
            if (timerManager != null) {
                try {
                    timerManager.perhapsStart();
                }
                catch (Exception exception) {
                    EJBLogger.logStackTrace((Throwable)exception);
                }
            }
            if (!MessageDrivenBeanInfoImpl.this.mdManagerList.contains(messageDrivenManagerIntf)) {
                MessageDrivenBeanInfoImpl.this.mdManagerList.add(messageDrivenManagerIntf);
            }
        }

        private boolean filterMultipleJMSServer(DestinationDetail destinationDetail, List<MessageDrivenManagerIntf> list) {
            if (destinationDetail.getType() == 5 && MessageDrivenBeanInfoImpl.this.distributedDestinationConnection != 1 && MessageDrivenBeanInfoImpl.this.topicMessagesDistributionMode != 2) {
                Iterator<MessageDrivenManagerIntf> iterator = list.iterator();
                if (iterator.hasNext()) {
                    MessageDrivenManagerIntf messageDrivenManagerIntf = iterator.next();
                    destinationDetail.getWLSServerName().equals(messageDrivenManagerIntf.getDestination().getWLSServerName());
                    return true;
                }
                iterator = MessageDrivenBeanInfoImpl.this.mdManagerList.iterator();
                if (iterator.hasNext()) {
                    MessageDrivenManagerIntf messageDrivenManagerIntf = iterator.next();
                    destinationDetail.getWLSServerName().equals(messageDrivenManagerIntf.getDestination().getWLSServerName());
                    return true;
                }
            }
            return false;
        }

        protected void removeMDmanagers(List<DestinationDetail> list) {
            ArrayList arrayList = new ArrayList(MessageDrivenBeanInfoImpl.this.mdManagerList);
            for (DestinationDetail destinationDetail : list) {
                for (MessageDrivenManagerIntf messageDrivenManagerIntf : arrayList) {
                    if (!messageDrivenManagerIntf.getDDMemberName().equals(destinationDetail.getMemberConfigName())) continue;
                    if (BeanInfoImpl.debugLogger.isDebugEnabled()) {
                        MessageDrivenBeanInfoImpl.debug("The EJB " + MessageDrivenBeanInfoImpl.this.getDisplayName() + " removes MDManager for connection to destination " + messageDrivenManagerIntf.getDestinationName());
                    }
                    this.undeployAndActivate(messageDrivenManagerIntf);
                }
            }
            if (MessageDrivenBeanInfoImpl.this.mdManagerList.size() == 0) {
                MessageDrivenBeanInfoImpl.this.defaultMDManager.compareAndSet(null, this.createDefaultMDManager());
            }
        }

        protected void undeployAndActivate(MessageDrivenManagerIntf messageDrivenManagerIntf) {
            messageDrivenManagerIntf.undeploy();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected List<MessageDrivenManagerIntf> createDDMDManagers(List<DestinationDetail> list) {
            MigratableTargetMBean migratableTargetMBean = null;
            ArrayList<MessageDrivenManagerIntf> arrayList = new ArrayList<MessageDrivenManagerIntf>();
            try {
                switch (this.connectionMode) {
                    case 1: {
                        for (DestinationDetail destinationDetail : list) {
                            migratableTargetMBean = MessageDrivenBeanInfoImpl.this.getMtMBean(destinationDetail.getMigratableTargetName());
                            MessageDrivenManagerIntf messageDrivenManagerIntf = MessageDrivenBeanInfoImpl.this.createMDManager(MessageDrivenBeanInfoImpl.this.environmentContext, migratableTargetMBean, destinationDetail);
                            arrayList.add(messageDrivenManagerIntf);
                        }
                        break;
                    }
                    case 2: {
                        for (DestinationDetail destinationDetail : list) {
                            if (!destinationDetail.isLocalWLSServer()) continue;
                            if (!this.filterMultipleJMSServer(destinationDetail, arrayList)) {
                                migratableTargetMBean = MessageDrivenBeanInfoImpl.this.getMtMBean(destinationDetail.getMigratableTargetName());
                                MessageDrivenManagerIntf messageDrivenManagerIntf = MessageDrivenBeanInfoImpl.this.createMDManager(MessageDrivenBeanInfoImpl.this.environmentContext, migratableTargetMBean, destinationDetail);
                                arrayList.add(messageDrivenManagerIntf);
                                continue;
                            }
                            MessageDrivenBeanInfoImpl.this.backupDestMembersList.add(destinationDetail);
                        }
                        break;
                    }
                    case 3: {
                        DestinationDetail destinationDetail = null;
                        ArrayList<DestinationDetail> arrayList2 = new ArrayList<DestinationDetail>(list);
                        Object object = arrayList2.iterator();
                        while (object.hasNext()) {
                            DestinationDetail destinationDetail2;
                            destinationDetail = destinationDetail2 = object.next();
                            if (!destinationDetail2.isLocalWLSServer()) continue;
                            break;
                        }
                        object = this;
                        synchronized (object) {
                            if (this.createOne()) {
                                arrayList2.remove(destinationDetail);
                                migratableTargetMBean = MessageDrivenBeanInfoImpl.this.getMtMBean(destinationDetail.getMigratableTargetName());
                                arrayList.add(MessageDrivenBeanInfoImpl.this.createMDManager(MessageDrivenBeanInfoImpl.this.environmentContext, migratableTargetMBean, destinationDetail));
                            }
                        }
                        MessageDrivenBeanInfoImpl.this.backupDestMembersList.addAll(arrayList2);
                        break;
                    }
                    case 4: {
                        for (DestinationDetail destinationDetail : list) {
                            migratableTargetMBean = MessageDrivenBeanInfoImpl.this.getMtMBean(destinationDetail.getMigratableTargetName());
                            if (migratableTargetMBean != null) {
                                arrayList.add(MessageDrivenBeanInfoImpl.this.createMDManager(MessageDrivenBeanInfoImpl.this.environmentContext, migratableTargetMBean, destinationDetail));
                                continue;
                            }
                            DestinationResovler destinationResovler = this;
                            synchronized (destinationResovler) {
                                if (this.createOne()) {
                                    arrayList.add(MessageDrivenBeanInfoImpl.this.createMDManager(MessageDrivenBeanInfoImpl.this.environmentContext, migratableTargetMBean, destinationDetail));
                                } else {
                                    MessageDrivenBeanInfoImpl.this.backupDestMembersList.add(destinationDetail);
                                }
                            }
                        }
                        break;
                    }
                }
            }
            catch (WLDeploymentException wLDeploymentException) {
                wLDeploymentException.printStackTrace();
            }
            return arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DestinationEventHandler
    implements DestinationAvailabilityListener {
        private RegistrationHandle handle;
        private DestinationResovler resolver;

        DestinationEventHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDestinationsAvailable(String string, List<DestinationDetail> list) {
            if (BeanInfoImpl.debugLogger.isDebugEnabled()) {
                MessageDrivenBeanInfoImpl.debug("New DDMember Available Event, JMS destination on " + string + " is available");
                MessageDrivenBeanInfoImpl.this.printDDMemberInfo(list);
            }
            if (list != null && list.size() > 0) {
                if (this.resolver == null) {
                    DestinationEventHandler destinationEventHandler = this;
                    synchronized (destinationEventHandler) {
                        if (this.resolver == null) {
                            DestinationDetail destinationDetail = list.get(0);
                            int n = destinationDetail.getType();
                            switch (n) {
                                case 0: 
                                case 2: {
                                    this.resolver = new QueueConnectionHandler();
                                    break;
                                }
                                case 4: {
                                    this.resolver = new QueueConnectionHandler(true);
                                    break;
                                }
                                case 1: 
                                case 3: {
                                    this.resolver = new TopicConnectionHandler();
                                    break;
                                }
                                case 5: {
                                    this.resolver = new TopicConnectionHandler(true, false);
                                    break;
                                }
                                case 6: {
                                    this.resolver = new TopicConnectionHandler(true, true);
                                }
                            }
                        }
                    }
                }
                if (this.resolver != null && !this.resolver.resolveDestnationWorkMode(list)) {
                    this.unRegister();
                }
            }
        }

        @Override
        public void onDestinationsUnavailable(String string, List<DestinationDetail> list) {
            if (BeanInfoImpl.debugLogger.isDebugEnabled()) {
                MessageDrivenBeanInfoImpl.debug("DDMember unavailable event on destination [" + string + "]");
                MessageDrivenBeanInfoImpl.this.printDDMemberInfo(list);
            }
            if (list != null && list.size() > 0) {
                ArrayList<DestinationDetail> arrayList = new ArrayList<DestinationDetail>();
                ArrayList arrayList2 = new ArrayList(MessageDrivenBeanInfoImpl.this.backupDestMembersList);
                block0: for (DestinationDetail destinationDetail : list) {
                    for (DestinationDetail destinationDetail2 : arrayList2) {
                        if (!destinationDetail2.getMemberConfigName().equals(destinationDetail.getMemberConfigName())) continue;
                        if (BeanInfoImpl.debugLogger.isDebugEnabled()) {
                            MessageDrivenBeanInfoImpl.debug("The distributed destination member [" + destinationDetail.getMemberConfigName() + "] has been removed");
                        }
                        arrayList.add(destinationDetail2);
                        continue block0;
                    }
                }
                MessageDrivenBeanInfoImpl.this.backupDestMembersList.removeAll(arrayList);
                this.resolver.removeMDmanagers(list);
            }
        }

        @Override
        public void onFailure(String string, Exception exception) {
            if (!BeanInfoImpl.debugLogger.isDebugEnabled() && exception instanceof NameNotFoundException) {
                EJBLogger.logMDBUnableToConnectToJMS((String)MessageDrivenBeanInfoImpl.this.getEJBName(), (String)string, (String)("The destination for the MDB " + MessageDrivenBeanInfoImpl.this.displayName + " could not be resolved at this time.  Please ensure the destination is available at the JNDI name " + string + ".  The EJB container will periodically attempt to resolve this MDB destination and additional warnings may be issued."));
            } else {
                EJBLogger.logMDBUnableToConnectToJMS((String)MessageDrivenBeanInfoImpl.this.getEJBName(), (String)string, (String)StackTraceUtils.throwable2StackTrace((Throwable)exception));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void register() throws WLDeploymentException {
            String string = MessageDrivenBeanInfoImpl.this.m_destinationJNDIName;
            if (MessageDrivenBeanInfoImpl.this.isOnMessageTransacted()) {
                MessageDrivenBeanInfoImpl.this.m_acknowledgeMode = 2;
            }
            if (string == null && MessageDrivenBeanInfoImpl.this.messageDestinationLink == null) {
                Loggable loggable = EJBLogger.logNoDestinationJNDINameSpecifiedLoggable();
                throw new WLDeploymentException(loggable.getMessage());
            }
            MessageDrivenBeanInfoImpl.this.reSetUsernameAndPassword();
            MessageDrivenBeanInfoImpl.this.jmsRegisterEnv.put("java.naming.factory.initial", MessageDrivenBeanInfoImpl.this.m_initialContextFactory);
            MessageDrivenBeanInfoImpl.this.jmsRegisterEnv.put("weblogic.jndi.allowGlobalResourceLookup", "true");
            if (null != MessageDrivenBeanInfoImpl.this.m_providerURL) {
                MessageDrivenBeanInfoImpl.this.jmsRegisterEnv.put("java.naming.provider.url", MessageDrivenBeanInfoImpl.this.m_providerURL);
            }
            if (MessageDrivenBeanInfoImpl.this.hasCredentials) {
                MessageDrivenBeanInfoImpl.this.jmsRegisterEnv.put("java.naming.security.principal", MessageDrivenBeanInfoImpl.this.userName.toString());
                MessageDrivenBeanInfoImpl.this.jmsRegisterEnv.put("java.naming.security.credentials", MessageDrivenBeanInfoImpl.this.password.toString());
                this.register(MessageDrivenBeanInfoImpl.this.jmsRegisterEnv);
            } else {
                AuthenticatedSubject authenticatedSubject = null;
                try {
                    authenticatedSubject = MessageDrivenBeanInfoImpl.this.getRunAsSubject();
                    if (authenticatedSubject == null) {
                        authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelId);
                    }
                    if (authenticatedSubject == null || SecurityServiceManager.isKernelIdentity((AuthenticatedSubject)authenticatedSubject) || SecurityServiceManager.isServerIdentity((AuthenticatedSubject)authenticatedSubject) || MessageDrivenBeanInfoImpl.this.getIsRemoteSubjectExists()) {
                        authenticatedSubject = MessageDrivenBeanInfoImpl.this.getRightSubject(MessageDrivenBeanInfoImpl.this.m_providerURL);
                    }
                }
                catch (Exception exception) {
                    EJBLogger.logStackTrace((Throwable)exception);
                }
                try {
                    SecurityHelper.pushRunAsSubject(authenticatedSubject);
                    this.register(MessageDrivenBeanInfoImpl.this.jmsRegisterEnv);
                    Object var5_5 = null;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    SecurityHelper.popRunAsSubject();
                    throw throwable;
                }
                SecurityHelper.popRunAsSubject();
                {
                }
            }
            if (BeanInfoImpl.debugLogger.isDebugEnabled()) {
                MessageDrivenBeanInfoImpl.debug("Deploying JMS based MD bean, dest:" + string + " transacted:" + MessageDrivenBeanInfoImpl.this.isOnMessageTransacted());
            }
        }

        private void register(Hashtable hashtable) throws WLDeploymentException {
            try {
                if (BeanInfoImpl.debugLogger.isDebugEnabled()) {
                    MessageDrivenBeanInfoImpl.debug("Registering into JMS destination helper");
                }
                try {
                    MessageDrivenBeanInfoImpl.this.defaultMDManager.set(MessageDrivenBeanInfoImpl.this.createMDManager(MessageDrivenBeanInfoImpl.this.environmentContext, null, null));
                    ((MessageDrivenManagerIntf)MessageDrivenBeanInfoImpl.this.defaultMDManager.get()).setMDBStatus(DDConstants.MDBStatus[0]);
                }
                catch (WLDeploymentException wLDeploymentException) {
                    // empty catch block
                }
                if (MessageDrivenBeanInfoImpl.this.m_isInactive) {
                    ((MessageDrivenManagerIntf)MessageDrivenBeanInfoImpl.this.defaultMDManager.get()).setMDBStatus(DDConstants.MDBStatus[5]);
                    return;
                }
                this.registerToJMS(hashtable);
            }
            catch (Exception exception) {
                throw new WLDeploymentException("Error registering DestinationAvailabilityListener", exception);
            }
        }

        private void registerToJMS(Hashtable hashtable) {
            this.handle = JMSDestinationAvailabilityHelper.getInstance().register(hashtable, MessageDrivenBeanInfoImpl.this.m_destinationJNDIName, this);
        }

        public void unRegister() {
            this.resolver = null;
            if (this.handle != null) {
                this.handle.unregister();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum UpdateOperation {
        NOOPERATION,
        RECONNECTION,
        REREGISTER;


        private static UpdateOperation compareAndSet(UpdateOperation updateOperation, UpdateOperation updateOperation2) {
            if (updateOperation2.ordinal() < updateOperation.ordinal()) {
                return updateOperation;
            }
            return updateOperation2;
        }
    }
}

