/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.deployer;

import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.container.EJBDebugService;
import weblogic.ejb.container.utils.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NamingConvention {
    private static final DebugLogger debugLogger = EJBDebugService.deploymentLogger;
    private String beanClassName;
    private String beanRootName;
    private String beanPackageName;
    private String ejbName;
    private String generatedBaseName;
    private String interceptorClassName;
    private String interceptorPackageName;

    public NamingConvention(String string) {
        this.interceptorClassName = string;
    }

    public NamingConvention(String string, String string2) {
        this.beanClassName = string;
        this.ejbName = string2;
    }

    private String unique() {
        String string = NamingConvention.makeLegalFileName(this.getEJBName() + this.getSimpleBeanClassName());
        return "_" + Long.toString(Math.abs(string.hashCode()), 36) + "_";
    }

    private String uniqueForInterceptor() {
        String string = NamingConvention.makeLegalFileName(this.getSimpleInterceptorClassName());
        return "_" + Long.toString(Math.abs(string.hashCode()), 36) + "_";
    }

    public String getSimpleBeanClassName() {
        return NamingConvention.tail(this.beanClassName);
    }

    public String getSimpleInterceptorClassName() {
        return NamingConvention.tail(this.interceptorClassName);
    }

    public String getBeanClassName() {
        return this.beanClassName;
    }

    public String getGeneratedBaseName() {
        assert (this.getEJBName() != null);
        if (this.generatedBaseName != null) {
            return this.generatedBaseName;
        }
        this.generatedBaseName = this.getEJBName().length() <= 26 ? NamingConvention.makeLegalFileName(this.getEJBName() + this.unique()) : this.getSimpleBeanClassName() + this.unique();
        return this.generatedBaseName;
    }

    public String getGeneratedBaseInterceptorName() {
        return this.getSimpleInterceptorClassName() + this.uniqueForInterceptor();
    }

    public String getSimpleHomeClassName() {
        return this.getGeneratedBaseName() + "HomeImpl";
    }

    public String getHomeClassName() {
        return this.getBeanPackagePrefix() + this.getSimpleHomeClassName();
    }

    public String getSimpleLocalHomeClassName() {
        return this.getGeneratedBaseName() + "LocalHomeImpl";
    }

    public String getLocalHomeClassName() {
        return this.getBeanPackagePrefix() + this.getSimpleLocalHomeClassName();
    }

    public String getHomeImplClassName(boolean bl) {
        if (bl) {
            return "weblogic.ejb.container.internal.StatefulEJBHomeImpl";
        }
        return "weblogic.ejb.container.internal.StatelessEJBHomeImpl";
    }

    public String getLocalHomeImplClassName(boolean bl) {
        if (bl) {
            return "weblogic.ejb.container.internal.StatefulEJBLocalHomeImpl";
        }
        return "weblogic.ejb.container.internal.StatelessEJBLocalHomeImpl";
    }

    public String getSimpleEJBObjectClassName() {
        return this.getGeneratedBaseName() + "EOImpl";
    }

    public String getEJBObjectClassName() {
        return this.getBeanPackagePrefix() + this.getSimpleEJBObjectClassName();
    }

    public String getSimpleEJBLocalObjectClassName() {
        return this.getGeneratedBaseName() + "ELOImpl";
    }

    public String getEJBLocalObjectClassName() {
        return this.getBeanPackagePrefix() + this.getSimpleEJBLocalObjectClassName();
    }

    public String getSimpleLocalBusinessImplClassName(Class<?> clazz) {
        return this.getGeneratedBaseName() + clazz.getSimpleName() + "Impl";
    }

    public String getLocalBusinessImplClassName(Class<?> clazz) {
        return this.getBeanPackagePrefix() + this.getSimpleLocalBusinessImplClassName(clazz);
    }

    public String getSimpleInterceptorImplClassName() {
        return this.getGeneratedBaseInterceptorName() + "Impl";
    }

    public String getInterceptorImplClassName() {
        return this.getInterceptorPackagePrefix() + this.getSimpleInterceptorImplClassName();
    }

    public String getSimpleRemoteBusinessImplClassName(Class<?> clazz) {
        return this.getGeneratedBaseName() + clazz.getSimpleName() + "Impl";
    }

    public String getRemoteBusinessImplClassName(Class<?> clazz) {
        return this.getBeanPackagePrefix() + this.getSimpleLocalBusinessImplClassName(clazz);
    }

    public String getSimpleRemoteBusinessIntfClassName(Class<?> clazz) {
        return this.getGeneratedBaseName() + clazz.getSimpleName() + "RIntf";
    }

    public String getRemoteBusinessIntfClassName(Class<?> clazz) {
        String string = NamingConvention.head(clazz.getName());
        if (string.length() > 0) {
            string = string + ".";
        }
        return string + this.getSimpleRemoteBusinessIntfClassName(clazz);
    }

    public String getSimpleRemoteBusinessWrapperClassName(Class<?> clazz) {
        return this.getGeneratedBaseName() + clazz.getSimpleName() + "Wrap";
    }

    public String getRemoteBusinessWrapperClassName(Class<?> clazz) {
        return this.getBeanPackagePrefix() + this.getSimpleRemoteBusinessWrapperClassName(clazz);
    }

    public String getSimpleWsHomeClassName() {
        return this.getGeneratedBaseName() + "WSLocalHomeImpl";
    }

    public String getWsHomeClassName() {
        return this.getBeanPackagePrefix() + this.getSimpleWsHomeClassName();
    }

    public String getSimpleWsObjectClassName() {
        return this.getGeneratedBaseName() + "WSOImpl";
    }

    public String getWsObjectClassName() {
        return this.getBeanPackagePrefix() + this.getSimpleWsObjectClassName();
    }

    public String getSimpleMdLocalObjectClassName() {
        return this.getGeneratedBaseName() + "MDOImpl";
    }

    public String getMdLocalObjectClassName(boolean bl) {
        if (bl) {
            return "weblogic.ejb.container.internal.MessageDrivenLocalObject";
        }
        return this.getBeanPackagePrefix() + this.getSimpleMdLocalObjectClassName();
    }

    public String getSimpleCmpBeanClassName(String string) {
        return this.getGeneratedBaseName() + "_" + string;
    }

    private static String makeLegalFileName(String string) {
        return ClassUtils.makeLegalName(string);
    }

    public String getCmpBeanClassName(String string) {
        return this.getBeanPackagePrefix() + this.getSimpleCmpBeanClassName(string);
    }

    public String getGeneratedBeanClassName() {
        return this.getBeanPackagePrefix() + this.getSimpleGeneratedBeanClassName();
    }

    public String getSimpleGeneratedBeanClassName() {
        return this.getGeneratedBaseName() + "Impl";
    }

    public String getGeneratedBeanInterfaceName() {
        return this.getBeanPackagePrefix() + this.getSimpleGeneratedBeanInterfaceName();
    }

    public String getSimpleGeneratedBeanInterfaceName() {
        return this.getGeneratedBaseName() + "Intf";
    }

    public String getEJBName() {
        return this.ejbName;
    }

    public String beanRoot() {
        if (this.beanRootName == null) {
            this.beanRootName = NamingConvention.tail(this.beanClassName);
            if (this.beanRootName.endsWith("Bean")) {
                int n = this.beanRootName.length();
                this.beanRootName = this.beanRootName.substring(0, n - 4);
            }
        }
        return this.beanRootName;
    }

    public String getInterceptorPackageName() {
        if (this.interceptorPackageName == null) {
            this.interceptorPackageName = NamingConvention.head(this.interceptorClassName);
        }
        return this.interceptorPackageName;
    }

    public String getInterceptorPackagePrefix() {
        String string = this.getInterceptorPackageName();
        String string2 = "";
        if (string != null && string.length() > 0) {
            string2 = string + ".";
        }
        return string2;
    }

    public String getBeanPackageName() {
        if (this.beanPackageName == null) {
            this.beanPackageName = NamingConvention.head(this.beanClassName);
        }
        return this.beanPackageName;
    }

    public String getBeanPackagePrefix() {
        String string = this.getBeanPackageName();
        String string2 = "";
        if (string != null && string.length() > 0) {
            string2 = string + ".";
        }
        return string2;
    }

    private static void debug(String string) {
        debugLogger.debug("[NamingConvention] " + string);
    }

    static String head(String string) {
        int n = string.lastIndexOf(".");
        return n == -1 ? "" : string.substring(0, n);
    }

    public static String tail(String string) {
        int n = string.lastIndexOf(".");
        return string.substring(n + 1);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("BeanClassName: " + this.beanClassName + "\n");
        stringBuffer.append("BeanRootName: " + this.beanRootName + "\n");
        stringBuffer.append("BeanPackageName: " + this.beanPackageName + "\n");
        stringBuffer.append("EJBName: " + this.ejbName + "\n");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        NamingConvention namingConvention = new NamingConvention(stringArray[0], null);
        System.out.println("beanClass(" + namingConvention.getBeanClassName() + ")");
        System.out.println("homeImplClass(" + namingConvention.getHomeClassName() + ")");
    }
}

