/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.deployer;

import com.bea.objectweb.asm.ClassAdapter;
import com.bea.objectweb.asm.ClassReader;
import com.bea.objectweb.asm.ClassVisitor;
import com.bea.objectweb.asm.ClassWriter;
import com.bea.objectweb.asm.FieldVisitor;
import com.bea.objectweb.asm.Label;
import com.bea.objectweb.asm.MethodVisitor;
import com.bea.objectweb.asm.Type;
import com.bea.objectweb.asm.commons.AdviceAdapter;
import com.bea.objectweb.asm.tree.FieldNode;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import weblogic.ejb.container.deployer.EJBClassEnhancer;
import weblogic.utils.classloaders.ClassPreProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PKClassPreProcessor
extends EJBClassEnhancer
implements ClassPreProcessor {
    private static final String _WL_HASHCODE_NAME = "_WL_HASHCODE_";
    private byte[] bytes;
    private Map<String, Boolean> pkClassNames = new HashMap<String, Boolean>();

    public PKClassPreProcessor(List<String> list) {
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            this.pkClassNames.put(iterator.next(), Boolean.FALSE);
        }
    }

    public void initialize(Hashtable hashtable) {
    }

    public byte[] preProcess(String string, byte[] byArray) {
        if (!this.pkClassNames.containsKey(string) || this.pkClassNames.get(string).booleanValue()) {
            return byArray;
        }
        FieldNode fieldNode = new FieldNode(130, _WL_HASHCODE_NAME, Type.INT_TYPE.getDescriptor(), null, (Object)0);
        ClassReader classReader = new ClassReader(byArray);
        int n = (byArray[6] & 0xFF) << 8 | byArray[7] & 0xFF;
        ClassWriter classWriter = n > 50 ? new ClassWriter(classReader, 2) : new ClassWriter(classReader, 0);
        HashCodeClassEnhancer hashCodeClassEnhancer = new HashCodeClassEnhancer((ClassVisitor)classWriter, fieldNode);
        classReader.accept((ClassVisitor)hashCodeClassEnhancer, 4);
        this.bytes = classWriter.toByteArray();
        this.pkClassNames.put(string, Boolean.TRUE);
        this.writeEnhancedClassBack(string, this.bytes);
        return this.bytes;
    }

    private class HashCodeMethodEnhancer
    extends AdviceAdapter {
        private String owner;
        private Label label;

        protected HashCodeMethodEnhancer(MethodVisitor methodVisitor, int n, String string, String string2, String string3) {
            super(methodVisitor, n, string, string2);
            this.label = new Label();
            this.owner = string3;
        }

        protected void onMethodEnter() {
            this.visitVarInsn(25, 0);
            this.visitFieldInsn(180, this.owner, PKClassPreProcessor._WL_HASHCODE_NAME, Type.INT_TYPE.getDescriptor());
            this.visitJumpInsn(154, this.label);
            this.visitVarInsn(25, 0);
        }

        protected void onMethodExit(int n) {
            this.visitFieldInsn(181, this.owner, PKClassPreProcessor._WL_HASHCODE_NAME, Type.INT_TYPE.getDescriptor());
            this.visitLabel(this.label);
            this.visitVarInsn(25, 0);
            this.visitFieldInsn(180, this.owner, PKClassPreProcessor._WL_HASHCODE_NAME, Type.INT_TYPE.getDescriptor());
        }

        public void visitMaxs(int n, int n2) {
            super.visitMaxs(n + 1, n2);
        }
    }

    private class InitMethodAdapter
    extends AdviceAdapter {
        private String owner;

        public InitMethodAdapter(MethodVisitor methodVisitor, int n, String string, String string2, String string3) {
            super(methodVisitor, n, string, string2);
            this.owner = string3;
        }

        protected void onMethodEnter() {
        }

        protected void onMethodExit(int n) {
            this.visitVarInsn(25, 0);
            this.visitInsn(3);
            this.visitFieldInsn(181, this.owner, PKClassPreProcessor._WL_HASHCODE_NAME, Type.INT_TYPE.getDescriptor());
        }

        public void visitMaxs(int n, int n2) {
            super.visitMaxs(n + 1, n2);
        }
    }

    private class HashCodeClassEnhancer
    extends ClassAdapter {
        private final FieldNode fn;
        private boolean isFieldPresent;
        private String owner;
        private ClassVisitor cv;
        private boolean noNeedEnhance;

        public HashCodeClassEnhancer(ClassVisitor classVisitor, FieldNode fieldNode) {
            super(classVisitor);
            this.isFieldPresent = false;
            this.fn = fieldNode;
            this.cv = classVisitor;
        }

        public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
            if ((n2 & 0x200) != 0) {
                this.cv.visit(n, n2, string, string2, string3, stringArray);
                this.noNeedEnhance = true;
                return;
            }
            this.owner = string;
            this.cv.visit(n, n2, string, string2, string3, stringArray);
        }

        public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
            Object object = this.cv.visitMethod(n, string, string2, string3, stringArray);
            if (this.noNeedEnhance) {
                return object;
            }
            if ("<init>".equals(string)) {
                object = new InitMethodAdapter((MethodVisitor)object, n, string, string2, this.owner);
            }
            if ("hashCode".equals(string) && "()I".equals(string2)) {
                object = new HashCodeMethodEnhancer((MethodVisitor)object, n, string, string2, this.owner);
            }
            return object;
        }

        public FieldVisitor visitField(int n, String string, String string2, String string3, Object object) {
            if (string.equals(PKClassPreProcessor._WL_HASHCODE_NAME)) {
                this.isFieldPresent = true;
            }
            return this.cv.visitField(n, string, string2, string3, object);
        }

        public void visitEnd() {
            if (!this.isFieldPresent && !this.noNeedEnhance) {
                this.fn.accept(this.cv);
            }
            super.visitEnd();
        }
    }
}

