/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.deployer;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.SessionSynchronization;
import javax.jws.WebService;
import javax.xml.ws.WebServiceProvider;
import kodo.jdbc.conf.descriptor.PersistenceUnitConfigurationBean;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BeanUpdateRejectedException;
import weblogic.descriptor.DescriptorBean;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.dd.DDDefaults;
import weblogic.ejb.container.deployer.ClientDrivenBeanInfoImpl;
import weblogic.ejb.container.deployer.CompositeMBeanDescriptor;
import weblogic.ejb.container.deployer.NamingConvention;
import weblogic.ejb.container.interfaces.BeanManager;
import weblogic.ejb.container.interfaces.DeploymentInfo;
import weblogic.ejb.container.interfaces.MethodInfo;
import weblogic.ejb.container.interfaces.PoolIntf;
import weblogic.ejb.container.interfaces.SessionBeanInfo;
import weblogic.ejb.container.internal.EJBComponentRuntimeMBeanImpl;
import weblogic.ejb.container.manager.ReplicatedStatefulSessionManager;
import weblogic.ejb.container.manager.StatefulSessionManager;
import weblogic.ejb.container.manager.StatelessManager;
import weblogic.ejb.spi.EJBCache;
import weblogic.ejb.spi.WLDeploymentException;
import weblogic.ejb.spi.WSObjectFactory;
import weblogic.j2ee.descriptor.SessionBeanBean;
import weblogic.j2ee.descriptor.wl.PoolBean;
import weblogic.j2ee.descriptor.wl.StatefulSessionCacheBean;
import weblogic.j2ee.descriptor.wl.StatefulSessionDescriptorBean;
import weblogic.j2ee.descriptor.wl.TransactionDescriptorBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.AssertionError;
import weblogic.utils.Debug;
import weblogic.utils.classloaders.GenericClassLoader;

class SessionBeanInfoImpl
extends ClientDrivenBeanInfoImpl
implements SessionBeanInfo {
    private final boolean usesBeanManagedTx;
    private final boolean isStateful;
    private final boolean isEndpointView;
    private final String generatedBeanClassName;
    private final String generatedBeanInterfaceName;
    private Class generatedBeanClass;
    private Class generatedBeanInterface;
    private int replicationType = 1;
    private boolean implementsSessionSynchronization;
    private String swapDirectoryName;
    private long idleTimeoutMS;
    private long sessionTimeoutMS;
    private boolean statefulSessionSerializesConcurrentCalls = false;
    private boolean allowRemoveDuringTx = false;
    private boolean passivateDuringReplication = true;
    private boolean calculateDeltaUsingReflection = false;

    public SessionBeanInfoImpl(DeploymentInfo deploymentInfo, CompositeMBeanDescriptor compositeMBeanDescriptor, GenericClassLoader genericClassLoader) throws ClassNotFoundException, WLDeploymentException {
        super(deploymentInfo, compositeMBeanDescriptor, genericClassLoader);
        Object object;
        SessionBeanBean sessionBeanBean = (SessionBeanBean)compositeMBeanDescriptor.getBean();
        assert ("bean".equalsIgnoreCase(sessionBeanBean.getTransactionType()) || "container".equalsIgnoreCase(sessionBeanBean.getTransactionType()));
        this.usesBeanManagedTx = "bean".equalsIgnoreCase(sessionBeanBean.getTransactionType());
        this.implementsSessionSynchronization = SessionSynchronization.class.isAssignableFrom(this.getBeanClass());
        this.idleTimeoutMS = (long)compositeMBeanDescriptor.getIdleTimeoutSecondsCache() * 1000L;
        this.sessionTimeoutMS = (long)compositeMBeanDescriptor.getSessionTimeoutSeconds() * 1000L;
        Debug.assertion(("stateful".equalsIgnoreCase(sessionBeanBean.getSessionType()) || "stateless".equalsIgnoreCase(sessionBeanBean.getSessionType()) ? 1 : 0) != 0);
        this.isStateful = "stateful".equalsIgnoreCase(sessionBeanBean.getSessionType());
        this.isEndpointView = "stateless".equalsIgnoreCase(sessionBeanBean.getSessionType()) && (this.beanClass.isAnnotationPresent(WebService.class) || this.beanClass.isAnnotationPresent(WebServiceProvider.class));
        if (this.isStateful) {
            Object object2;
            object = compositeMBeanDescriptor.getWl60Bean();
            StatefulSessionDescriptorBean statefulSessionDescriptorBean = object.getStatefulSessionDescriptor();
            if (null != statefulSessionDescriptorBean) {
                this.swapDirectoryName = statefulSessionDescriptorBean.getPersistentStoreDir();
                object2 = statefulSessionDescriptorBean.getStatefulSessionClustering();
                if (object2 != null) {
                    this.passivateDuringReplication = object2.isPassivateDuringReplication();
                    this.calculateDeltaUsingReflection = object2.isCalculateDeltaUsingReflection();
                }
            }
            this.statefulSessionSerializesConcurrentCalls = statefulSessionDescriptorBean.isAllowConcurrentCalls();
            this.allowRemoveDuringTx = statefulSessionDescriptorBean.isAllowRemoveDuringTransaction();
            if (this.needSetReplicationType(compositeMBeanDescriptor) && "InMemory".equals(object2 = statefulSessionDescriptorBean.getStatefulSessionClustering().getReplicationType())) {
                AuthenticatedSubject authenticatedSubject;
                this.replicationType = 2;
                if (SessionBeanInfoImpl.isServer() && ManagementService.getRuntimeAccess(authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction())).getServer().getCluster() == null) {
                    EJBLogger.logWarningOnSFSBInMemoryReplicationFeature((String)this.getEJBName());
                }
            }
        }
        if (this.swapDirectoryName == null) {
            this.swapDirectoryName = "pstore";
        }
        object = new NamingConvention(sessionBeanBean.getEjbClass(), sessionBeanBean.getEjbName());
        this.generatedBeanClassName = ((NamingConvention)object).getGeneratedBeanClassName();
        if (this.getDeploymentInfo().isEnableBeanClassRedeploy()) {
            genericClassLoader.excludeClass(this.generatedBeanClassName);
        }
        this.generatedBeanInterfaceName = ((NamingConvention)object).getGeneratedBeanInterfaceName();
    }

    protected boolean needSetReplicationType(CompositeMBeanDescriptor compositeMBeanDescriptor) {
        return this.getJNDIName() != null;
    }

    public String getGeneratedBeanClassName() {
        return this.generatedBeanClassName;
    }

    public String getGeneratedBeanInterfaceName() {
        return this.generatedBeanInterfaceName;
    }

    public Class getGeneratedBeanClass() {
        try {
            if (this.generatedBeanClass == null) {
                this.generatedBeanClass = this.loadClass(this.generatedBeanClassName);
            }
            return this.generatedBeanClass;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError("Unable to load class " + this.generatedBeanClassName, (Throwable)classNotFoundException);
        }
    }

    public Class getGeneratedBeanInterface() {
        try {
            if (this.generatedBeanInterface == null) {
                this.generatedBeanInterface = this.loadClass(this.generatedBeanInterfaceName);
            }
            return this.generatedBeanInterface;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError("Unable to load class " + this.generatedBeanInterfaceName, (Throwable)classNotFoundException);
        }
    }

    public boolean statefulSessionSerializesConcurrentCalls() {
        return this.statefulSessionSerializesConcurrentCalls;
    }

    public int getReplicationType() {
        return this.replicationType;
    }

    public boolean isStateful() {
        return this.isStateful;
    }

    public boolean usesBeanManagedTx() {
        return this.usesBeanManagedTx;
    }

    public boolean implementsSessionSynchronization() {
        return this.implementsSessionSynchronization;
    }

    public String getSwapDirectoryName() {
        return this.swapDirectoryName;
    }

    public long getIdleTimeoutMS() {
        return this.idleTimeoutMS;
    }

    public long getSessionTimeoutMS() {
        return this.sessionTimeoutMS;
    }

    public boolean isTimerDriven() {
        if (this.isStateful()) {
            return false;
        }
        return super.isTimerDriven();
    }

    public boolean getCalculateDeltaUsingReflection() {
        return this.calculateDeltaUsingReflection;
    }

    public boolean getPassivateDuringReplication() {
        return this.passivateDuringReplication;
    }

    public BeanManager getBeanManagerInstance(EJBComponentRuntimeMBeanImpl eJBComponentRuntimeMBeanImpl) {
        if (this.isStateful()) {
            if (this.getReplicationType() == 2) {
                return new ReplicatedStatefulSessionManager(eJBComponentRuntimeMBeanImpl);
            }
            return new StatefulSessionManager(eJBComponentRuntimeMBeanImpl);
        }
        return new StatelessManager(eJBComponentRuntimeMBeanImpl);
    }

    protected EJBCache getCache(Map map) {
        return null;
    }

    protected short getTxAttribute(MethodInfo methodInfo, Class clazz) {
        if (this.usesBeanManagedTx) {
            return 0;
        }
        if (EJBHome.class.isAssignableFrom(clazz) || EJBLocalHome.class.isAssignableFrom(clazz)) {
            String string = methodInfo.getMethodName();
            if (string.equals("remove") || string.startsWith("create")) {
                return 0;
            }
        } else if (EJBObject.class.isAssignableFrom(clazz) || EJBLocalObject.class.isAssignableFrom(clazz)) {
            String string = methodInfo.getMethodName();
            String[] stringArray = methodInfo.getMethodParams();
            if (string.equals("remove") && (stringArray == null || stringArray.length == 0)) {
                if (this.allowRemoveDuringTx) {
                    return 2;
                }
                return 0;
            }
        }
        return methodInfo.getTransactionAttribute();
    }

    public void assignDefaultTXAttributesIfNecessary() {
        if (this.usesBeanManagedTx) {
            Iterator iterator = this.getAllMethodInfosIterator();
            while (iterator.hasNext()) {
                ((MethodInfo)iterator.next()).setTransactionAttribute((short)0);
            }
        } else {
            ArrayList<MethodInfo> arrayList = new ArrayList<MethodInfo>();
            if (this.hasDeclaredRemoteHome()) {
                arrayList.addAll(this.getAllHomeMethodInfos());
                arrayList.add(this.getRemoteMethodInfo("remove()"));
                arrayList.add(this.getRemoteMethodInfo("getEJBHome()"));
                arrayList.add(this.getRemoteMethodInfo("getHandle()"));
                arrayList.add(this.getRemoteMethodInfo("getPrimaryKey()"));
                arrayList.add(this.getRemoteMethodInfo("isIdentical(javax.ejb.EJBObject)"));
            }
            if (this.hasDeclaredLocalHome()) {
                arrayList.addAll(this.getAllLocalHomeMethodInfos());
                arrayList.add(this.getLocalMethodInfo("remove()"));
                arrayList.add(this.getLocalMethodInfo("getEJBLocalHome()"));
                arrayList.add(this.getLocalMethodInfo("getPrimaryKey()"));
                arrayList.add(this.getLocalMethodInfo("isIdentical(javax.ejb.EJBLocalObject)"));
                arrayList.add(this.getLocalMethodInfo("getLocalHandle()"));
            }
            for (MethodInfo methodInfo : arrayList) {
                if (methodInfo == null || methodInfo.getTransactionAttribute() != -1) continue;
                methodInfo.setTransactionAttribute(DDDefaults.getTransactionAttribute(this));
            }
            super.assignDefaultTXAttributesIfNecessary();
        }
    }

    public void updateImplClassLoader() throws WLDeploymentException {
        super.updateImplClassLoader();
        try {
            this.generatedBeanClass = this.loadClass(this.generatedBeanClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new WLDeploymentException("Couldn't load updated impl class: " + classNotFoundException);
        }
        if (this.implementsSessionSynchronization != SessionSynchronization.class.isAssignableFrom(this.getBeanClass())) {
            throw new WLDeploymentException("Unable to perform a partial redeploy due to a SessionSynchronization change in the bean class.");
        }
        BeanManager beanManager = this.getBeanManager();
        try {
            beanManager.beanImplClassChangeNotification();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw new WLDeploymentException("Bean Manager does not support partial updates");
        }
    }

    public void updatePoolIdleTimeoutSeconds(int n) {
        BeanManager beanManager;
        if (!this.isStateful && (beanManager = this.getBeanManager()) instanceof StatelessManager) {
            PoolIntf poolIntf = ((StatelessManager)beanManager).getPool();
            poolIntf.updateIdleTimeoutSeconds(n);
        }
        if (debugLogger.isDebugEnabled()) {
            SessionBeanInfoImpl.debug("updated Pool IdleTimeoutSeconds to " + n + " for EJB " + this.getDisplayName());
        }
    }

    public void updateMaxBeansInFreePool(int n) {
        BeanManager beanManager;
        if (!this.isStateful && (beanManager = this.getBeanManager()) instanceof StatelessManager) {
            PoolIntf poolIntf = ((StatelessManager)beanManager).getPool();
            poolIntf.updateMaxBeansInFreePool(n);
        }
        if (debugLogger.isDebugEnabled()) {
            SessionBeanInfoImpl.debug("updated MaxBeansInFreePool to " + n + " for EJB " + this.getDisplayName());
        }
    }

    public WSObjectFactory getWSObjectFactory() {
        return this.webserviceObjectFactory;
    }

    public void prepareUpdate(BeanUpdateEvent beanUpdateEvent) throws BeanUpdateRejectedException {
        if (debugLogger.isDebugEnabled()) {
            SessionBeanInfoImpl.debug("prepareUpdate: " + beanUpdateEvent);
        }
        BeanUpdateEvent.PropertyUpdate[] propertyUpdateArray = beanUpdateEvent.getUpdateList();
        DescriptorBean descriptorBean = beanUpdateEvent.getProposedBean();
        block4: for (int i = 0; i < propertyUpdateArray.length; ++i) {
            BeanUpdateEvent.PropertyUpdate propertyUpdate = propertyUpdateArray[i];
            switch (propertyUpdate.getUpdateType()) {
                case 1: {
                    int n;
                    PersistenceUnitConfigurationBean persistenceUnitConfigurationBean;
                    String string = propertyUpdate.getPropertyName();
                    if (debugLogger.isDebugEnabled()) {
                        SessionBeanInfoImpl.debug("Preparing property of type: " + string);
                    }
                    if (string.equals("LockTimeout")) {
                        if (debugLogger.isDebugEnabled()) {
                            SessionBeanInfoImpl.debug("Preparing persistence property: " + string);
                        }
                        persistenceUnitConfigurationBean = (PersistenceUnitConfigurationBean)descriptorBean;
                        n = persistenceUnitConfigurationBean.getLockTimeout();
                        this.prepareLockTimeout(n);
                        continue block4;
                    }
                    if (string.equals("DataCacheTimeout")) {
                        if (debugLogger.isDebugEnabled()) {
                            SessionBeanInfoImpl.debug("Preparing persistence property: " + string);
                        }
                        persistenceUnitConfigurationBean = (PersistenceUnitConfigurationBean)descriptorBean;
                        n = persistenceUnitConfigurationBean.getDataCacheTimeout();
                        this.prepareDataCacheTimeout(n);
                        continue block4;
                    }
                    if (!string.equals("FetchBatchSize")) continue block4;
                    if (debugLogger.isDebugEnabled()) {
                        SessionBeanInfoImpl.debug("Preparing persistence property: " + string);
                    }
                    persistenceUnitConfigurationBean = (PersistenceUnitConfigurationBean)descriptorBean;
                    n = persistenceUnitConfigurationBean.getFetchBatchSize();
                    this.prepareFetchBatchSize(n);
                    continue block4;
                }
                case 2: 
                case 3: {
                    throw new AssertionError("Unexpected BeanUpdateEvent: " + beanUpdateEvent);
                }
            }
        }
    }

    public void rollbackUpdate(BeanUpdateEvent beanUpdateEvent) {
        if (debugLogger.isDebugEnabled()) {
            SessionBeanInfoImpl.debug("rollbackUpdate: " + beanUpdateEvent);
        }
    }

    public void activateUpdate(BeanUpdateEvent beanUpdateEvent) {
        if (debugLogger.isDebugEnabled()) {
            SessionBeanInfoImpl.debug("activateUpdate: " + beanUpdateEvent);
        }
        BeanUpdateEvent.PropertyUpdate[] propertyUpdateArray = beanUpdateEvent.getUpdateList();
        DescriptorBean descriptorBean = beanUpdateEvent.getProposedBean();
        block4: for (int i = 0; i < propertyUpdateArray.length; ++i) {
            BeanUpdateEvent.PropertyUpdate propertyUpdate = propertyUpdateArray[i];
            switch (propertyUpdate.getUpdateType()) {
                case 1: {
                    int n;
                    String string;
                    PoolBean poolBean;
                    String string2 = propertyUpdate.getPropertyName();
                    if (debugLogger.isDebugEnabled()) {
                        SessionBeanInfoImpl.debug("Changing property of type: " + string2);
                    }
                    if (string2.equals("MaxBeansInFreePool")) {
                        assert (!this.isStateful());
                        poolBean = (PoolBean)descriptorBean;
                        this.updateMaxBeansInFreePool(poolBean.getMaxBeansInFreePool());
                        continue block4;
                    }
                    if (string2.equals("MaxBeansInCache")) {
                        assert (this.isStateful());
                        poolBean = (StatefulSessionCacheBean)descriptorBean;
                        this.updateMaxBeansInCache(poolBean.getMaxBeansInCache());
                        continue block4;
                    }
                    if (string2.equals("TransTimeoutSeconds")) {
                        poolBean = (TransactionDescriptorBean)descriptorBean;
                        this.updateTransactionTimeoutSeconds(poolBean.getTransTimeoutSeconds());
                        continue block4;
                    }
                    if (string2.equals("IdleTimeoutSeconds")) {
                        if (descriptorBean instanceof StatefulSessionCacheBean) {
                            assert (this.isStateful());
                            poolBean = (StatefulSessionCacheBean)descriptorBean;
                            this.updateCacheIdleTimeoutSeconds(poolBean.getIdleTimeoutSeconds());
                            continue block4;
                        }
                        poolBean = (PoolBean)descriptorBean;
                        this.updatePoolIdleTimeoutSeconds(poolBean.getIdleTimeoutSeconds());
                        continue block4;
                    }
                    if (string2.equals("LockTimeout")) {
                        if (debugLogger.isDebugEnabled()) {
                            SessionBeanInfoImpl.debug("Changing persistence property: " + string2);
                        }
                        poolBean = (PersistenceUnitConfigurationBean)descriptorBean;
                        string = poolBean.getName();
                        n = poolBean.getLockTimeout();
                        this.updateLockTimeout(n, string);
                        continue block4;
                    }
                    if (string2.equals("DataCacheTimeout")) {
                        if (debugLogger.isDebugEnabled()) {
                            SessionBeanInfoImpl.debug("Changing persistence property: " + string2);
                        }
                        poolBean = (PersistenceUnitConfigurationBean)descriptorBean;
                        string = poolBean.getName();
                        n = poolBean.getDataCacheTimeout();
                        this.updateDataCacheTimeout(n, string);
                        continue block4;
                    }
                    if (string2.equals("FetchBatchSize")) {
                        if (debugLogger.isDebugEnabled()) {
                            SessionBeanInfoImpl.debug("Changing persistence property: " + string2);
                        }
                        poolBean = (PersistenceUnitConfigurationBean)descriptorBean;
                        string = poolBean.getName();
                        n = poolBean.getFetchBatchSize();
                        this.updateFetchBatchSize(n, string);
                        continue block4;
                    }
                    throw new AssertionError("Unexpected propertyName: " + string2);
                }
                case 2: 
                case 3: {
                    throw new AssertionError("Unexpected BeanUpdateEvent: " + beanUpdateEvent);
                }
            }
        }
    }

    private static void debug(String string) {
        debugLogger.debug("[SessionBeanInfoImpl] " + string);
    }

    public boolean isSessionBean() {
        return true;
    }

    public boolean isAllowRemoveDuringTx() {
        return this.allowRemoveDuringTx;
    }

    public boolean isEndpointView() {
        return this.isEndpointView;
    }
}

