/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.deployer;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import javax.ejb.EJBException;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import weblogic.ejb.WLTimerInfo;
import weblogic.ejb.WLTimerService;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.interfaces.BeanInfo;
import weblogic.ejb.container.interfaces.MessageDrivenManagerIntf;
import weblogic.ejb.container.interfaces.SessionBeanInfo;
import weblogic.ejb.container.internal.EJBContextManager;
import weblogic.logging.Loggable;

public class TimerServiceProxyImpl
implements WLTimerService {
    private BeanInfo bi;
    private boolean isSessionBean;

    public TimerServiceProxyImpl(BeanInfo beanInfo) {
        this.bi = beanInfo;
        if (beanInfo instanceof SessionBeanInfo) {
            this.isSessionBean = true;
        }
    }

    private TimerService getDelegate() {
        if (!this.bi.isTimerDriven()) {
            Loggable loggable = null;
            loggable = this.isSessionBean && ((SessionBeanInfo)this.bi).isStateful() ? EJBLogger.logStatefulSessionBeanAttemptToAccessTimerServiceLoggable() : EJBLogger.logIllegalAttemptToAccessTimerServiceLoggable();
            throw new IllegalStateException(loggable.getMessage());
        }
        if (this.isSessionBean) {
            return EJBContextManager.getEJBContext().getTimerService();
        }
        return ((MessageDrivenManagerIntf)this.bi.getBeanManager()).getMessageDrivenContext().getTimerService();
    }

    public Timer createTimer(Date date, long l, Serializable serializable) {
        return this.getDelegate().createTimer(date, l, serializable);
    }

    public Timer createTimer(Date date, Serializable serializable) {
        return this.getDelegate().createTimer(date, serializable);
    }

    public Timer createTimer(long l, long l2, Serializable serializable) {
        return this.getDelegate().createTimer(l, l2, serializable);
    }

    public Timer createTimer(long l, Serializable serializable) {
        return this.getDelegate().createTimer(l, serializable);
    }

    public Collection getTimers() {
        return this.getDelegate().getTimers();
    }

    public Timer createTimer(Date date, long l, Serializable serializable, WLTimerInfo wLTimerInfo) throws IllegalArgumentException, IllegalStateException, EJBException {
        return ((WLTimerService)this.getDelegate()).createTimer(date, l, serializable, wLTimerInfo);
    }

    public Timer createTimer(Date date, Serializable serializable, WLTimerInfo wLTimerInfo) throws IllegalArgumentException, IllegalStateException, EJBException {
        return ((WLTimerService)this.getDelegate()).createTimer(date, serializable, wLTimerInfo);
    }

    public Timer createTimer(long l, long l2, Serializable serializable, WLTimerInfo wLTimerInfo) throws IllegalArgumentException, IllegalStateException, EJBException {
        return ((WLTimerService)this.getDelegate()).createTimer(l, l2, serializable, wLTimerInfo);
    }

    public Timer createTimer(long l, Serializable serializable, WLTimerInfo wLTimerInfo) throws IllegalArgumentException, IllegalStateException, EJBException {
        return ((WLTimerService)this.getDelegate()).createTimer(l, serializable, wLTimerInfo);
    }
}

