/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.deployer.mbimpl;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import weblogic.ejb.container.dd.xml.DDUtils;
import weblogic.ejb.container.interfaces.MethodInfo;
import weblogic.ejb.container.internal.RuntimeHelper;
import weblogic.ejb.container.utils.ToStringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MethodInfoImpl
implements MethodInfo {
    private RuntimeHelper helper = null;
    private boolean jaccEnabled;
    private Method method;
    private String methodIntf;
    private short methodDescriptorMethodType;
    private Set<String> roleNames = new HashSet<String>();
    private String[] methodParams;
    private short transAttribute = (short)-1;
    private int isolationLevel = -1;
    private int selectForUpdate = 0;
    private boolean isExcluded = false;
    private boolean isUnchecked = false;
    private boolean idempotent = false;
    private String realmName = null;
    private int retryOnRollbackCount = 0;

    public MethodInfoImpl(Method method, String string, String string2) {
        assert (method != null);
        this.method = method;
        Class<?>[] classArray = method.getParameterTypes();
        this.methodParams = new String[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            this.methodParams[i] = classArray[i].getName();
        }
        this.methodIntf = string;
        this.setJaccEnabled(string2);
    }

    @Override
    public void setSelectForUpdate(int n) {
        this.selectForUpdate = n;
    }

    @Override
    public int getSelectForUpdate() {
        return this.selectForUpdate;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public String getSignature() {
        return DDUtils.getMethodSignature(this.method);
    }

    @Override
    public String getMethodName() {
        return this.method.getName();
    }

    @Override
    public String[] getMethodParams() {
        return (String[])this.methodParams.clone();
    }

    @Override
    public void setMethodDescriptorMethodType(short s) {
        this.methodDescriptorMethodType = s;
    }

    @Override
    public short getMethodDescriptorMethodType() {
        return this.methodDescriptorMethodType;
    }

    @Override
    public String getMethodInterfaceType() {
        return this.methodIntf;
    }

    @Override
    public void setRuntimeHelper(RuntimeHelper runtimeHelper) {
        this.helper = runtimeHelper;
    }

    @Override
    public void setRealmName(String string) {
        this.realmName = string;
    }

    @Override
    public boolean isJaccEnabled() {
        return this.jaccEnabled;
    }

    private void setJaccEnabled(String string) {
        this.jaccEnabled = string != null;
    }

    @Override
    public void setRetryOnRollbackCount(int n) {
        this.retryOnRollbackCount = n;
    }

    @Override
    public int getRetryOnRollbackCount() {
        return this.retryOnRollbackCount;
    }

    @Override
    public void addSecurityRoleRestriction(String string) {
        this.roleNames.add(string);
    }

    @Override
    public Set<String> getSecurityRoleNames() {
        return this.roleNames;
    }

    @Override
    public boolean hasRole(String string) {
        return this.roleNames.contains(string);
    }

    @Override
    public boolean needsSecurityCheck() {
        assert (this.realmName != null) : " Error !  the realmName has not been set in MethodInfoImpl, " + this.toString();
        if (this.helper.fullyDelegateSecurityCheck(this.realmName)) {
            return true;
        }
        return !this.roleNames.isEmpty();
    }

    @Override
    public void setTransactionAttribute(short s) {
        this.transAttribute = s;
    }

    @Override
    public short getTransactionAttribute() {
        return this.transAttribute;
    }

    @Override
    public void setTxIsolationLevel(int n) {
        this.isolationLevel = n;
    }

    @Override
    public int getTxIsolationLevel() {
        return this.isolationLevel;
    }

    @Override
    public void setIsExcluded(boolean bl) {
        this.isExcluded = bl;
    }

    @Override
    public boolean getIsExcluded() {
        return this.isExcluded;
    }

    @Override
    public void setUnchecked(boolean bl) {
        this.isUnchecked = bl;
    }

    @Override
    public boolean getUnchecked() {
        return this.isUnchecked;
    }

    @Override
    public void setIdempotent(boolean bl) {
        this.idempotent = bl;
    }

    @Override
    public boolean isIdempotent() {
        return this.idempotent;
    }

    public static MethodInfoImpl createMethodInfoImpl(Method method, String string) {
        return MethodInfoImpl.createMethodInfoImpl(method, null, string);
    }

    public static MethodInfoImpl createMethodInfoImpl(Method method, String string, String string2) {
        assert (method != null);
        MethodInfoImpl methodInfoImpl = new MethodInfoImpl(method, string, string2);
        return methodInfoImpl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("MethodInfo: Method: ");
        stringBuffer.append(this.getSignature());
        stringBuffer.append(" TxAttribute: " + ToStringUtils.txAttributeToString(this.transAttribute));
        stringBuffer.append(" Isolation Level: " + ToStringUtils.isoToString(this.isolationLevel));
        return stringBuffer.toString();
    }
}

